<?php
class Wechatmodel extends CI_Model {
    public $orderId;
    const CNKN_TIMEZONE = 'Asia/Shanghai';
    public function orderLocation(int $orderId): array{
        $getResult = $this->db->query("
            SELECT
              tps.latitude,
              tps.longitude,
              tps.loc_name
            FROM
              `tb_stop_status` tps
            WHERE
                tps.order_id = ?
            ORDER BY
              tps.id DESC
            LIMIT
              1",
            [$orderId]
        );
        return $getResult->num_rows() == 1 ? $getResult->row_array() : [];
    }

    public function collectShipments(string $searchKey): array{
        $companyCodeList = $this->getWeChatNotificationCountryList();
        $todayDate = date('Y-m-d');
        $LastYearDate = date('Y-m-d', strtotime('-1 year', strtotime($todayDate)));
        $key = '%' . $searchKey . '%';
        $getResult = $this->db->query(
            "
            SELECT
                DISTINCT(o.id) AS id,
                o.order_id,
                o.drop_endtime,
                CONCAT(o.pickup_company,', ',o.pickup_city,', ',o.pickup_country) AS from_location,
                CONCAT(o.delivery_company,', ',o.delivery_city,', ',o.delivery_country) AS to_location,
                o.trip_id,
                r.ref_value,
                CASE WHEN (SELECT COUNT(t.`id`) AS `id` FROM `tb_stop_status` t WHERE t.`order_id` = o.`id` AND t.`status_code` = ? AND t.`status`= ?)=1 THEN 1 ELSE 0 END AS is_delivered,
                CASE WHEN (SELECT COUNT(t.`id`) AS `id` FROM `tb_stop_status` t WHERE t.`order_id` = o.`id` AND t.`status_code` = ? AND t.`status`= ?)=1 THEN 1 ELSE 0 END AS is_arrived,
                CASE WHEN (SELECT COUNT(t.`id`) AS `id` FROM `tb_stop_status` t WHERE t.`order_id` = o.`id` AND t.`status_code` = ? AND t.`status`= ?)=1 THEN 1 ELSE 0 END AS is_picked,
                CASE WHEN (SELECT COUNT(t.`id`) AS `id` FROM `tb_stop_status` t WHERE t.`order_id` = o.`id` AND t.`status_code` = ? AND t.`status`= ?)=1 THEN 1 ELSE 0 END AS is_departure
            FROM
                tb_orders o
            INNER JOIN tb_order_references r ON (
            reference_id IN ?
                AND r.order_id = o.id
            )
            WHERE
                o.company_code IN ? AND
                DATE(o.createdon) >= ? AND
                DATE(o.createdon) <= ? AND
                ( o.order_id LIKE ? OR r.ref_value LIKE ? ) ",
            [
                '2300',
                1,
                '0192',
                1,
                '0500',
                1,
                '0191',
                1,
                ['DQ', 'PO', 'DO', 'INN','XSR'],
                $companyCodeList,
                $LastYearDate,
                $todayDate,
                $key,
                $key
            ]
        );
        return $getResult->num_rows() > 0 ? $getResult->result_array() : [];
    }
    private function getWeChatNotificationCountryList():array {
        $countryList = $this->db->query("SELECT `condition` FROM access_conditions WHERE `title` = ?",['WECHAT_COUNTRY'])->row();
        return explode(',', $countryList->condition);
    }
    public function validateTrackingNumber(int $trackingNumber) : array {
        $companyCodeList = $this->getWeChatNotificationCountryList();
        $getResult = $this->db->query("
            SELECT r.order_id FROM tb_order_references r
            INNER JOIN tb_orders o ON (o.id = r.order_id)
            WHERE r.ref_value = ? AND r.reference_id = ? AND o.company_code IN ?
            ORDER BY r.id DESC LIMIT ?", [(string)$trackingNumber, 'XSR', $companyCodeList, 1]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getBasicShipmentInfo(): array {
        $getResult = $this->db->query("
            SELECT o.id, o.pickup_datetime, o.pickup_endtime, o.drop_endtime, o.delivery_datetime, o.pickup_company as companyname, o.pickup_address1 as address1, pickup_address2 as address2, pickup_address1 as street, pickup_city as city, pickup_address2 as state, pickup_pincode as postal, pickup_country as country, o.delivery_company as dcompanyname, o.delivery_address1 as daddress1, delivery_address2 as daddress2, delivery_address1 as dstreet, delivery_city as dcity, delivery_address2 as dstate, delivery_pincode as dpostal, delivery_country as dcountry, o.shipment_id, o.status, o.trip_sts, o.shift_id, o.trip_id, o.plat, o.plng, o.dlat, o.dlng, ocm.country_name as origin_country, dcm.country_name as destination_country,
            (SELECT s.vehicle_type FROM tb_shifts s WHERE (s.id = o.shift_id) AND s.status = 1 LIMIT 1) AS vehicle_type,
            (SELECT ts.transport_mode FROM tb_shifts ts WHERE (ts.id = o.shift_id) AND ts.status = 1 LIMIT 1) AS transport_mode,
            (SELECT driver_id FROM tb_shft_veh v, tbl_assigned_drivers a WHERE v.vehicle_id = a.vehicle_id AND v.shft_id = o.shift_id AND v.status = 1 AND a.status = 1 LIMIT 1) AS driver_id
            FROM tb_orders o
            LEFT JOIN tbl_country_master ocm ON (ocm.country_code = o.pickup_country)
            LEFT JOIN tbl_country_master dcm ON (dcm.country_code = o.delivery_country)
            WHERE o.id = ?
            ", [$this->orderId]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getShipmentStatuses(): array {
        $getResult = $this->db->query("
            SELECT ss.status_code, ss.createdon, sm.status_name
            FROM tb_stop_status AS ss
            INNER JOIN tb_status_master sm ON (sm.status_code = ss.status_code)
            WHERE ss.order_id = ?
            ORDER BY id ASC
            ", [$this->orderId]);
    }

    public function getTripStatusInfo(int $orderId, int $shiftId) : array {
        $getResults = $this->db->query("
            SELECT ss.latitude,ss.status_code, ss.longitude, ss.loc_name, ss.next_stop_eta, ss.next_stop_duration,ss.createdon, (SELECT sm.status_name FROM tb_status_master sm WHERE sm.status_code = ss.status_code LIMIT ?) AS status_name, `ss`.`comment`, ss.status_stage,
            (SELECT c.cntry_timezone FROM tbl_country_master c WHERE c.country_code = u.country_code AND c.status = ? LIMIT ?) AS cntry_timezone
            FROM tb_stop_status ss
            INNER JOIN tb_orders o ON (o.id = ss.order_id)
            LEFT JOIN tb_users u ON (u.id = o.user_id)
            WHERE ss.order_id = ? AND ss.shipment_id = ? AND ss.status = ? ORDER BY ss.id ASC",
            [1, 1, 1, $orderId, $shiftId, 1]);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }

    public function getAssignedDriverInfo(int $driverId) : array {
        $getResult = $this->db->query("SELECT name AS driverName, contact_num AS contactNo, COALESCE(driver_national_identification_number, '') AS nationalIdentificationNumber FROM tb_truck_drivers WHERE id = ? ",[$driverId]);
        return $getResult->num_rows() > 0 ? $getResult->row_array() : [];
    }

    public function getShipmentStopStatus(int $id, string $statusCode): string {
        $getResult = $this->db->query("SELECT createdon FROM `tb_stop_status` t WHERE t.`order_id` = ? AND t.`status_code` = ? AND t.`status`= ?", [$id, $statusCode, 1]);
        return $getResult->num_rows() > 0 ? $getResult->row()->createdon : "";
    }

    public function getShipmentDetails(string $shipmentId): array {
        $companyCodeList = $this->getWeChatNotificationCountryList();
        $getResult = $this->db->query("
            SELECT o.shipmentid, o.pickup_datetime, o.delivery_datetime, o.company_code, s.vendor_id, s.txnid, v.code AS carrier_code, v.name as carrier_name,o.trip_id,o.status
            FROM tb_orders o
            INNER JOIN tb_shifts s ON s.shipmentid = o.shipmentid
            LEFT JOIN tb_vendors v ON (v.id = o.vendor_id)
            WHERE o.order_id = ? AND o.company_code IN ?",
            [$shipmentId, $companyCodeList]
        );
        return (int)$getResult->num_rows() === 1 ? $getResult->row_array() : [];
    }

    public function createShipmentHistory(string $shipmentId): int {
        if ($this->db->insert('wechat_shipment_history',['order_id'=>$shipmentId, 'createdon'=>date('Y-m-d H:i:s')])) {
            return 1;
        }
        return 0;
    }

    public function checkShipmentHistory(string $shipmentId): int {
        return $this->db->query("SELECT id FROM wechat_shipment_history WHERE order_id = ?", [$shipmentId])->num_rows();
    }

    public function getGPSPings(int $orderId = 0,int $shiftId = 0): array {
        $response = [];
        $getResult = $this->db->query("SELECT
            MAX(CASE WHEN (status_code = ? AND `status`=?) THEN 1 ELSE 0 END) AS pickup_status,
            MAX(CASE WHEN (status_code = ? AND `status`=?) THEN 1 ELSE 0 END) AS intransit_status,
            MAX(CASE WHEN (status_code IN ? AND `status`=?) THEN 1 ELSE 0 END) AS delivery_status,
            trip_id, order_id            
            FROM tb_stop_status WHERE order_id = ? GROUP BY order_id",['0500',1,'1550',1,['0192','2300','3000'],1,$orderId]);
        if ($getResult->num_rows() === 1) {
            $result = $getResult->row();
            $getTimeZone = $this->db->query("SELECT (SELECT c.cntry_timezone FROM tbl_country_master c WHERE c.country_code = u.country_code AND c.status = ? LIMIT ?) AS cntry_timezone 
            FROM tb_orders o
            INNER JOIN tb_users u ON (u.id = o.user_id)
            WHERE o.id = ?
            ",[1,1,(int)$result->order_id])->row();
            $timeZone = $getTimeZone ? $getTimeZone->cntry_timezone : CNKN_TIMEZONE;            
            if ((int)$result->pickup_status === 1 && (int)$result->intransit_status === 1 && (int)$result->delivery_status === 0) {
                $getResults = $this->db->query("SELECT latitude,longitude,`timestamp`
                    FROM tb_rtdrive_locations WHERE trip_id = ? AND createdon > DATE_SUB(NOW(), INTERVAL 10 MINUTE)",
                    [(int)$result->trip_id]);
                $results = $getResults->num_rows() > 0 ? $getResults->result() : [];
                if ($results) {
                    foreach ($results as $data) {
                        $getTimeStamp = getdatetimebytimezone(DFLT_TZ, $data->timestamp, $timeZone);
                        $dateTime  = $getTimeStamp['date'];
                        $latitude  = $data->latitude;
                        $longitude = $data->longitude;
                        $location  = ($latitude && $longitude) ? @getLocationName($latitude, $longitude) : '';
                        $response[] = [
                            'latitude'=>$latitude,
                            'longitude'=>$longitude,
                            'location'=>$location,
                            "createdon" => (new DateTime($dateTime))->format('Y-m-d\TH:i:s.v\Z')
                        ];
                    }
                }
            }
        }
        return $response;
    }

    public function getXSRDetailsByTripId(int $tripId = 0): array {
        $getResults = $this->db->query("SELECT tor.ref_value FROM tb_order_references tor
        INNER JOIN tb_orders o ON o.id = tor.order_id
        WHERE o.trip_id = ? AND tor.reference_id = ? ",[$tripId, "XSR"]);
        return $getResults->num_rows() > 0 ? $getResults->result_array() : [];
    }
}