<?php

defined('BASEPATH') or exit('No direct script access allowed');

class WestPharmaModel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function checkCompanyCode(string $chklreceiver): object
    {
        return $this->db->select("branch_code,company_code")->get_where("tb_branch_master", [
            "logical_sender" => $chklreceiver,
            "status" => 1,
        ], 1, 0);
    }

    public function checkOrderId(array $refValues): object
    {
        return $this->db->query(
            "SELECT order_id FROM tb_order_references WHERE ref_value IN ? GROUP BY reference_id",
            [$refValues]
        );
    }

    public function checkCargoInfo(array $shipmentData, string $cargo_content): int
    {
        $cargoData = [
            'cargo_type' => $shipmentData['pkgs_uom'],
            'handling_unit' => $cargo_content,
            'height_unit' => 'M',
            'weight' => $shipmentData['gross_weight'],
            'weight_unit' => $shipmentData['weight_uom'],
            'volume' => $shipmentData['volume'],
            'volume_unit' => $shipmentData['volume_uom'],
            'quantity' => $shipmentData['pkgs_count'],
        ];
        $checkCargoData = $this->db->select("id")->get_where("tb_cargo_details", $cargoData, 1, 0);
        if ($checkCargoData->num_rows() > 0) {
            $cargoId = $this->insertCargoInfo(
                $shipmentData,
                $cargo_content,
                $checkCargoData->row()->id
            );
        } else {
            $cargoId = $this->insertCargoInfo($shipmentData, $cargo_content, "0");
        }
        return $cargoId;
    }

    public function checkOrderCargoInfo(array $shipmentData,
        int $ord_id,
        int $cargoId,
        string $cargo_content,
        int $user_id): void
    {
        $orderCargoData = [
            'order_id' => $ord_id,
            'cargo_id' => $cargoId,
            'weight' => $shipmentData['gross_weight'],
            'volume' => $shipmentData['volume'],
            'quantity' => $shipmentData['pkgs_count'],
            'quantity_type' => $shipmentData['pkgs_uom'],
            'cargo_content' => $cargo_content,
        ];
        $checkOrderCargoData = $this->db->select("id")->get_where("tb_order_cargodetails", $orderCargoData);
        if ($checkOrderCargoData->num_rows() == 0) {
            $hunit = 1;
            $chkhandlingunit = $this->db->select("id")->get_where(
                "tbl_shipunit_types",
                ["user_id" => $user_id],
                1,
                0
            );
            if ($chkhandlingunit->num_rows() > 0) {
                $hunit = $chkhandlingunit->row()->id;
            }
            $cargodata = [
                'order_id' => $ord_id,
                'cargo_id' => $cargoId,
                'handling_unit' => $hunit,
                'length' => 0.00,
                'width' => 0.00,
                'height' => 0.00,
                'weight' => $shipmentData['gross_weight'],
                'volume' => $shipmentData['volume'],
                'quantity' => $shipmentData['pkgs_count'],
                'quantity_type' => $shipmentData['pkgs_uom'],
                'cargo_content' => $cargo_content,
                'status' => 1,
            ];
            $cargo_id = $this->common->insertTableData('tb_order_cargodetails', $cargodata);
            $this->generateQRCodes($cargo_id, $cargodata);
        }
    }

    public function getLatLongByLocationName(string $address): array
    {
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }

    public function checkOrderParties(array $customer,
        string $cmpcode,
        string $branchcode,
        int $uid,
        string $customerType): array
    {
        $cwhr1 = $customer['custid'] != "" ? ["code" => $customer['custid']] : "";
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cust_id = 0;
        $country_code = "86";
        $year = date('y');
        $week = date('W');
        if ($customer['custid'] != "") {
            $ctable = 'tb_customers';
            $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
            if (count($chkcust) > 0) {
                $cust_id = $chkcust['id'];
                $data = [
                    'location' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'updatedon' => $curdt,
                ];
                $this->db->where(["id" => $cust_id])->update('tb_customers', $data);
            } else {
                $randnum = $customer['custid'];
                $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                $data = [
                    'name' => $customer['name'],
                    'phone' => $customer['custid'],
                    'location' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'code' => $customer['custid'],
                    'country' => $customer['country'],
                    'password' => $pwd,
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt,
                ];
                $cust_id = $this->common->insertTableData('tb_customers', $data);
            }
        } else {
            $randnum = $country_code . $year . $week . $cust_id;
            $pwd = password_hash($randnum,PASSWORD_DEFAULT);
            $data = [
                'name' => $customer['name'],
                'phone' => $randnum,
                'location' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $randnum,
                'country' => $customer['country'],
                'password' => $pwd,
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'createdon' => $curdt,
                'updatedon' => $curdt,
            ];
            $cust_id = $this->common->insertTableData('tb_customers', $data);
        }

        if ($customerType == "SH") {
            $cwhr['party_type_id'] = 1;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", [
                "name" => "Shipper",
                "user_id" => $uid,
                'company_code' => $cmpcode,
            ], 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $cwhr['party_type_id'] = $chkpartytype->row()->id;
            }
        } elseif ($customerType == "CN") {
            $cwhr['party_type_id'] = 3;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", [
                "name" => "Consignee",
                "user_id" => $uid,
                'company_code' => $cmpcode,
            ], 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $cwhr['party_type_id'] = $chkpartytype->row()->id;
            }
        } elseif ($customerType == "PF") {
            $cwhr['party_type_id'] = 7;
            $chkpartytype = $this->db->select("id")->get_where("tbl_party_types", [
                "name" => "Customer",
                "user_id" => $uid,
                'company_code' => $cmpcode,
            ], 1, 0);
            if ($chkpartytype->num_rows() > 0) {
                $cwhr['party_type_id'] = $chkpartytype->row()->id;
            }
        }
        if ("" != $cwhr1) {
            $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, "tbl_party_master", 0, 0);
            if (count($chkcust) > 0 && "" != $cwhr1) {
                $custid = $chkcust['id'];
                $data = [
                    'location_id' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'customeridentifier' => $customer['custid'],
                    'partyindetifier' => $customer['partyid'],
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'updated_on' => $curdt,
                ];
                $this->db->where(["id" => $custid])->update('tbl_party_master', $data);
            } else {
                $randnum = $country_code . $year . $week . $cust_id;
                $customer['custid'] = $randnum;
                $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                $data = [
                    'party_type_id' => $cwhr['party_type_id'],
                    'name' => $customer['name'],
                    'email' => 'svkonekt@kuehne-nagel.com',
                    'mobile' => $customer['custid'],
                    'location_id' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'code' => $customer['custid'],
                    'country' => $customer['country'],
                    'user_id' => $uid,
                    'password' => $pwd,
                    'customeridentifier' => $customer['custid'],
                    'partyindetifier' => $customer['partyid'],
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'created_on' => $curdt,
                    'updated_on' => $curdt,
                ];
                $custid = $this->common->insertTableData('tbl_party_master', $data);
                $cust_id = $this->db->insert_id();

                $custid = $country_code . $year . $week . $cust_id;
                $this->db->where(['id' => $cust_id])->update("tbl_party_master", [
                    'code' => $custid,
                    'customeridentifier' => $custid,
                ]);
            }
        } else {
            $randnum = $country_code . $year . $week . $cust_id;
            $customer['custid'] = $randnum;
            $pwd = password_hash($randnum,PASSWORD_DEFAULT);
            $data = [
                'party_type_id' => $cwhr['party_type_id'],
                'name' => $customer['name'],
                'email' => 'svkonekt@kuehne-nagel.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'password' => $pwd,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt,
            ];
            $custid = $this->common->insertTableData('tbl_party_master', $data);
            $cust_id = $this->db->insert_id();
            $custid = $country_code . $year . $week . $cust_id;
            $this->db->where(['id' => $cust_id])->update("tbl_party_master", [
                'code' => $custid,
                'customeridentifier' => $custid,
            ]);
        }

        $res['id'] = $cust_id;
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr['party_type_id'];
        return $res;
    }

    public function checkCustomer(array $customer,
        string $cmpcode,
        string $branchcode,
        int $uid,
        string $customerType): array
    {
        $cwhr1 = ["code" => $customer['custid']];
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cust_id = 0;
        $country_code = "86";
        $year = date('y');
        $week = date('W');
        if ($customerType == "PF") {
            if ($customer['custid'] != "") {
                $ctable = 'tb_customers';
                $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, $ctable, 0, 0);
                if (count($chkcust) > 0) {
                    $cust_id = $chkcust['id'];
                    $data = [
                        'location' => $customer['city'],
                        'address' => $customer['street'],
                        'pincode' => $customer['zip'],
                        'country' => $customer['country'],
                        'user_id' => $uid,
                        'company_code' => $cmpcode,
                        'branch_code' => $branchcode,
                        'status' => 1,
                        'updatedon' => $curdt,
                    ];
                    $this->db->where(["id" => $cust_id])->update('tb_customers', $data);
                } else {
                    $randnum = $customer['custid'];
                    $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                    $data = [
                        'name' => $customer['name'],
                        'phone' => $customer['custid'],
                        'location' => $customer['city'],
                        'address' => $customer['street'],
                        'pincode' => $customer['zip'],
                        'code' => $customer['custid'],
                        'country' => $customer['country'],
                        'password' => $pwd,
                        'user_id' => $uid,
                        'company_code' => $cmpcode,
                        'branch_code' => $branchcode,
                        'status' => 1,
                        'createdon' => $curdt,
                        'updatedon' => $curdt,
                    ];
                    $cust_id = $this->common->insertTableData('tb_customers', $data);
                }
            } else {
                $cust_id = date("ymd");
                $country_code = $this->session->userdata("usr_tzone")['phone_code'];
                $year = date('y');
                $week = date('W');
                $randnum = $country_code . $year . $week . $cust_id;
                $customer['custid'] = $randnum;
                $pwd = password_hash($randnum,PASSWORD_DEFAULT);
                $data = [
                    'name' => $customer['name'],
                    'phone' => $customer['custid'],
                    'location' => $customer['city'],
                    'address' => $customer['street'],
                    'pincode' => $customer['zip'],
                    'code' => $customer['custid'],
                    'country' => $customer['country'],
                    'password' => $pwd,
                    'user_id' => $uid,
                    'company_code' => $cmpcode,
                    'branch_code' => $branchcode,
                    'status' => 1,
                    'createdon' => $curdt,
                    'updatedon' => $curdt,
                ];
                $cust_id = $this->common->insertTableData('tb_customers', $data);
            }
        }
        $cwhr['party_type_id'] = 7;
        $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", [
            "name" => "Customer",
            "user_id" => $uid,
            'company_code' => $cmpcode,
        ], 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $cwhr['party_type_id'] = $checkPartyType->row()->id;
        }
        $chkcust = $this->common->gettblrowdata($cwhr1, $cselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $data = [
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'user_id' => $uid,
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'updated_on' => $curdt,
            ];
            $this->db->where(["id" => $custid])->update('tbl_party_master', $data);
            $cust_Party_id = $custid;
        } else {
            $randnum = $country_code . $year . $week . $cust_id;
            $customer['custid'] = $randnum;
            $pwd = password_hash($randnum,PASSWORD_DEFAULT);
            $data = [
                'party_type_id' => $cwhr['party_type_id'],
                'name' => $customer['name'],
                'email' => 'svkonekt@kuehne-nagel.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $customer['street'],
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'password' => $pwd,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt,
            ];
            $custid = $this->common->insertTableData('tbl_party_master', $data);
            $cust_Party_id = $this->db->insert_id();
            $custid = $country_code . $year . $week . $cust_Party_id;
            $this->db->where(['id' => $cust_Party_id])->update("tbl_party_master", [
                'code' => $custid,
                'customeridentifier' => $custid,
            ]);
        }
        $res['id'] = $cust_id;
        $res['party_id'] = $cust_Party_id;
        $res['party_type'] = $cwhr['party_type_id'];
        log_message("error", "Customerinfo" . json_encode($res));
        return $res;
    }


    public function checkParties(array $customer,
        string $cmpcode,
        string $branchcode,
        int $uid,
        string $customerType): array
    {
        $cwhr["code"] = $customer['custid'];
        $cselect = 'id';
        $curdt = date("Y-m-d H:i:s");
        $curtz = date_default_timezone_get();
        $getactual = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $curdt = $getactual['datetime'];
        $cwhr1['party_type_id'] = 6;
        $country_code = "86";
        $year = date('y');
        $week = date('W');

        $checkPartyType = $this->db->select("id")->get_where("tbl_party_types", [
            "name" => $customerType,
            "user_id" => $uid,
            'company_code' => $cmpcode,
        ], 1, 0);
        if ($checkPartyType->num_rows() > 0) {
            $cwhr1['party_type_id'] = $checkPartyType->row()->id;
        }
        $address = $customer['street'];
        if ('' !== $customer['city']) {
            $address .= ", " . $customer['city'];
        }
        if ('' !== $customer['state']) {
            $address .= ", " . $customer['state'];
        }
        if ('' !== $customer['statecode']) {
            $address .= ", " . $customer['statecode'];
        }
        if ('' !== $customer['country']) {
            $address .= ", " . $customer['country'];
        }
        if ('' !== $customer['zip']) {
            $address .= ", " . $customer['zip'];
        }
        $chkcust = $this->common->gettblrowdata($cwhr, $cselect, "tbl_party_master", 0, 0);
        if (count($chkcust) > 0) {
            $custid = $chkcust['id'];
            $data = [
                'name' => $customer['name'],
                'location_id' => $customer['city'],
                'address' => $address,
                'pincode' => $customer['zip'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'updated_on' => $curdt,
            ];
            $this->db->where(["id" => $custid])->update('tbl_party_master', $data);
        } else {
            $randnum = $customer['custid'];
            $pwd = password_hash($randnum,PASSWORD_DEFAULT);
            $data = [
                'party_type_id' => $cwhr1['party_type_id'],
                'name' => $customer['name'],
                'email' => 'svkonekt@kuehne-nagel.com',
                'mobile' => $customer['custid'],
                'location_id' => $customer['city'],
                'address' => $address,
                'pincode' => $customer['zip'],
                'code' => $customer['custid'],
                'country' => $customer['country'],
                'user_id' => $uid,
                'password' => $pwd,
                'customeridentifier' => $customer['custid'],
                'partyindetifier' => $customer['partyid'],
                'company_code' => $cmpcode,
                'branch_code' => $branchcode,
                'status' => 1,
                'created_on' => $curdt,
                'updated_on' => $curdt,
            ];
            $custid = $this->common->insertTableData('tbl_party_master', $data);
            $cust_id = $this->db->insert_id();
            $custid = $country_code . $year . $week . $cust_id;
            $this->db->where(['id' => $cust_id])->update("tbl_party_master", [
                'code' => $custid,
                'customeridentifier' => $custid,
            ]);
        }
        $res['party_id'] = $custid;
        $res['party_type'] = $cwhr1['party_type_id'];
        return $res;
    }

    public function generateQRCodes(int $cargo_id, array $cargodata): array
    {
        $this->load->library('barcode');
        $qrid = [];
        $handling_unit = $cargodata["handling_unit"];
        $quantity = $cargodata["quantity"];
        $data = [];
        $data["order_cargo_details_id"] = $cargo_id;
        $data["handling_unit"] = $handling_unit;
        $data["quantity"] = $quantity;
        $data["path"] = $qrid['qr_path'] = $this->barcode->generate(
            json_encode([
                "cargo_id" => $handling_unit,
                "quantity" => $quantity,
            ])
        );
        $qrid['id'] = $this->common->insertTableData("tb_order_cargo_qrdetails", $data);
        return $qrid;
    }

    public function insertInvolvedParties(int $ord_id, int $id, int $shiporderid, string $partytype)
    {
        $curdt = date("Y-m-d H:i:s");
        $checkparty = $this->db->select("id")->get_where("tb_order_parties", [
            'order_id' => $ord_id,
            'party_id' => $id,
        ], 1, 0);
        if ($checkparty->num_rows() > 0) {
            $partyarr = [
                'order_number' => $shiporderid,
                'party_id' => $id,
                'party_type' => $partytype,
                'status' => 1,
            ];
            $partyid = $checkparty->row()->id;
            $this->common->updatetbledata("tb_order_parties", $partyarr, ["id" => $partyid]);
        } else {
            $partyarr = [
                'order_id' => $ord_id,
                'order_number' => $shiporderid,
                'party_id' => $id,
                'party_type' => $partytype,
                'status' => 1,
                'createdon' => $curdt,
            ];
            $this->common->insertTableData("tb_order_parties", $partyarr);
        }
    }

    public function insertOrderReferences(int $ord_id, array $sref): void
    {
        $curdt = date("Y-m-d H:i:s");
        $chkdt = [
            'order_id' => $ord_id,
            'reference_id' => $sref['code'],
            'ref_value' => $sref['value'],
        ];
        $chkref = $this->db->select("id")->get_where("tb_order_references", $chkdt);
        if ($chkref->num_rows() == 0) {
            $srefqry = [
                'order_id' => $ord_id,
                'reference_id' => $sref['code'],
                'ref_value' => $sref['value'],
                'status' => 1,
                'createdon' => $curdt,
            ];
            $this->common->insertTableData('tb_order_references', $srefqry);
        }
    }

    public function insertCargoInfo($shipmentData, $cargo_content, $cargod_id): int
    {
        $cargoData = [
            'cargo_type' => $shipmentData['pkgs_uom'],
            'cargotype_id' => 0,
            'handling_unit' => $cargo_content,
            'handlingunit_id' => 0,
            'length' => 1.00,
            'length_unit' => 'M',
            'width' => 1.00,
            'width_unit' => 'M',
            'height' => 1.00,
            'height_unit' => 'M',
            'weight' => $shipmentData['gross_weight'],
            'weight_unit' => $shipmentData['weight_uom'],
            'volume' => $shipmentData['volume'],
            'volume_unit' => $shipmentData['volume_uom'],
            'quantity' => $shipmentData['pkgs_count'],
        ];
        if ($cargod_id === "0") {
            $cargoData['goods_description'] = $cargo_content;
            $cargoData['createdon'] = date('Y-m-d H:i:s');
            $cargod_id = $this->common->insertTableData('tb_cargo_details', $cargoData);
        } else {
            $this->common->updatetbledata("tb_cargo_details", $cargoData, ["id" => $cargod_id]);
        }
        return (int)$cargod_id;
    }

    public function insertOrderDetails(array $shipmentData,
        string $company_code,
        string $branch_code,
        int $sship_id,
        array $data,
        string $transportMode,
        string $dedicateVehicle,
        int $user_id,
        int $customer_id)
    {
        $shipchk = $shipmentData['shipper'];
        $conschk = $shipmentData['consignee'];
        $pickup_datefrom = $shipmentData['pickdrops'][0]['pickup_datefrom'] ?? $shipmentData['statusinfo_date'];
        $pickup_datefromtime = $shipmentData['pickdrops'][0]['pickup_datefromtime'] ?? $shipmentData['statusinfo_date'];
        $pickupDateTime = $pickup_datefrom . " " . $pickup_datefromtime;
        $pickupDate = date('Y-m-d H:i:s', strtotime($pickupDateTime));
        $lstchars = substr($pickup_datefromtime, -8);
        $curtzs = gettimezonebygmtplusval($lstchars);
        $getActualPickup = getdatetimebytimezone(DFLT_TZ, $pickupDate, $curtzs);
        $pickup_datetime = $getActualPickup['datetime'];
        $pickup_dateto = $shipmentData['pickdrops'][0]['pickup_dateto'] ?? $shipmentData['statusinfo_date'];
        $pickup_datetotime = $shipmentData['pickdrops'][0]['pickup_datetotime'] ?? $shipmentData['statusinfo_date'];
        $pickupEndTime = $pickup_dateto . " " . $pickup_datetotime;
        $pickupEnd = date('Y-m-d H:i:s', strtotime($pickupEndTime));
        $lstchars = substr($pickupEnd, -6);
        $curtzs = gettimezonebygmtplusval($lstchars);
        $getActualpickupEnd = getdatetimebytimezone(DFLT_TZ, $pickupEnd, $curtzs);
        $pickup_endtime = $getActualpickupEnd['datetime'];
        $pickup_company = $shipmentData['pickdrops'][0]['pickup_company'] ?? $shipchk['name'];
        $pickup_address = $shipmentData['pickdrops'][0]['pickup_address'] ?? $shipchk['street'];
        $pickup_city = $shipmentData['pickdrops'][0]['pickup_city'] ?? $shipchk['city'];
        $pickup_countrycode = $shipmentData['pickdrops'][0]['pickup_countrycode'] ?? $shipchk['country'];
        $pickup_postal = $shipmentData['pickdrops'][0]['pickup_postal'] ?? $shipchk['zip'];
        $pickup_address1 = $shipmentData['pickdrops'][0]['pickup_address1'] ?? $shipchk['street'];
        $pickup_custid = $shipmentData['pickdrops'][0]['pickup_custid'] ?? $shipchk['custid'];
        $pickup_partyid = $shipmentData['pickdrops'][0]['pickup_partyid'] ?? $shipchk['partyid'];

        $drop_datefrom = $shipmentData['pickdrops'][1]['drop_datefrom'] ?? $shipmentData['statusinfo_date'];
        $drop_datefromtime = $shipmentData['pickdrops'][1]['drop_datefromtime'] ?? $shipmentData['statusinfo_date'];
        $deliveryDateTime = $drop_datefrom . " " . $drop_datefromtime;
        $deliveryDate = date('Y-m-d H:i:s', strtotime($deliveryDateTime));
        $lstchars = substr($deliveryDate, -8);
        $curtzs = gettimezonebygmtplusval($lstchars);
        $getActualDelivery = getdatetimebytimezone(DFLT_TZ, $deliveryDate, $curtzs);
        $delivery_datetime = $getActualDelivery['datetime'];

        $drop_dateto = $shipmentData['pickdrops'][1]['drop_dateto'] ?? $shipmentData['statusinfo_date'];
        $drop_datetotime = $shipmentData['pickdrops'][1]['drop_datetotime'] ?? $shipmentData['statusinfo_date'];
        $drop_endtime = $drop_dateto . " " . $drop_datetotime;
        $drop_endtime = date('Y-m-d H:i:s', strtotime($drop_endtime));
        $lstchars = substr($drop_endtime, -8);
        $curtzs = gettimezonebygmtplusval($lstchars);
        $getactual = getdatetimebytimezone(DFLT_TZ, $drop_endtime, $curtzs);
        $drop_endtime = $getactual['datetime'];
        $drop_company = $res['drop_company'] ?? $conschk['name'];
        $drop_address = $res['drop_address'] ?? $conschk['street'];
        $drop_city = $res['drop_city'] ?? $conschk['city'];
        $drop_countrycode = $res['drop_countrycode'] ?? $conschk['country'];
        $drop_postal = $res['drop_postal'] ?? $conschk['zip'];
        $drop_address1 = $res['drop_address1'] ?? $conschk['street'];
        $drop_custid = $res['drop_custid'] ?? $conschk['custid'];
        $drop_partyid = $res['drop_partyid'] ?? $conschk['partyid'];

        $startLat = $startLong = $endLat = $endLong = "";
        $startLocation = $pickup_address . ", " . $pickup_city . ", " . $pickup_countrycode . ", " . $pickup_postal;
        $endLocation = $drop_address . ", " . $drop_city . ", " . $drop_countrycode . ", " . $drop_postal;
        $cheklatlng = $this->getLatLongByLocationName($startLocation);
        if (!empty($cheklatlng)) {
            $startLat = $cheklatlng['latitude'];
            $startLong = $cheklatlng['longitude'];
        }
        $cheklatlng1 = $this->getLatLongByLocationName($endLocation);
        if (!empty($cheklatlng1)) {
            $endLat = $cheklatlng1['latitude'];
            $endLong = $cheklatlng1['longitude'];
        }
        $xsrvalue = $shipmentData['xsrvalue'];
        $dqnum = $shipmentData['orderid'];
        $bookext = $booking_id = 0;
        $OrderArray = [];
        $checkOrderId = $this->checkOrderId([$xsrvalue, $dqnum]);
        if ($checkOrderId->num_rows() > 1) {
            $ord_idqry = $checkOrderId->result_array();
            $OrderArray1 = [];
            foreach ($ord_idqry as $ordr) {
                $OrderArray1[] = $ordr['order_id'];
            }
            $OrderArray = array_unique($OrderArray1);
        }

        $orderData = [
            'pickup_datetime' => $pickup_datetime,
            'pickup_endtime' => $pickup_endtime,
            'delivery_datetime' => $delivery_datetime,
            'drop_endtime' => $drop_endtime,
            'pickup_company' => $pickup_company,
            'delivery_company' => $drop_company,
            'pickup_country' => $pickup_countrycode,
            'delivery_country' => $drop_countrycode,
            'pickup_city' => $pickup_city,
            'delivery_city' => $drop_city,
            'pickup_pincode' => $pickup_postal,
            'delivery_pincode' => $drop_postal,
            'pickup_address1' => $pickup_address,
            'delivery_address1' => $drop_address,
            'pickup_address2' => $pickup_address1,
            'delivery_address2' => $drop_address1,
            'quantity' => $shipmentData['pkgs_count'],
            'weight' => $shipmentData['gross_weight'],
            'volume' => $shipmentData['volume'],
            'goods_value' => $shipmentData['pkgs_count'],
            'transport_mode' => $transportMode,
            'dedicated_vehicle' => $dedicateVehicle,
            'vehicle_type' => $transportMode,
            'user_id' => $user_id,
            'customer_id' => $customer_id,
            'customer_name' => $shipmentData['consignee']['name'],
            'customer_code' => $shipmentData['consignee']['custid'],
            'customer_area' => ($shipmentData['consignee']['street'] . ", " . $shipmentData['consignee']['city'] . ", " . $shipmentData['consignee']['zip']),
            'customer_phone' => $shipmentData['consignee']['custid'],
            'vendor_name' => $shipmentData['shipper']['name'],
            'vendor_code' => $shipmentData['shipper']['custid'],
            'vendor_area' => ($shipmentData['shipper']['street'] . ", " . $shipmentData['shipper']['city'] . ", " . $shipmentData['shipper']['zip']),
            'vendor_phone' => $shipmentData['shipper']['custid'],
            'plat' => $startLat,
            'plng' => $startLong,
            'dlat' => $endLat,
            'dlng' => $endLong,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'product' => $shipmentData['serviceproduct'],
            'shipment_id' => $sship_id,
            'pickup_custid' => $pickup_custid,
            'pickup_partyid' => $pickup_partyid,
            'drop_custid' => $drop_custid,
            'drop_partyid' => $drop_partyid,
            "created_source" => 5,
            'logicalreceiver' => $data['header']['lreceiver'],
            'physicalreceiver' => $data['header']['preceiver'],
            'physicalsender' => $data['header']['psender'],
            'logicalsender' => $data['header']['lsender'],
            'modeoftransport' => $shipmentData['sendertransmode'],
        ];
        if (count($OrderArray) == 1) {
            $ord_id = $OrderArray[0];
            $this->common->updatetbledata('tb_orders', $orderData, ["id" => $ord_id]);
            $bookext = 1;
            $bookingchk = $this->common->gettblrowdata(["id" => $ord_id], "order_id", "tb_orders", 0, 0);
            if (count($bookingchk) > 0) {
                $booking_id = $bookingchk['order_id'];
            }
        } else {
            $orderData['order_id'] = $shipmentData['orderid'];
            $orderData['status'] = 1;
            $orderData['createdon'] = date("Y-m-d H:i:s");
            $orderData['updatedon'] = date("Y-m-d H:i:s");
            $orderData['created_source'] = 29;
            $ord_id = $this->common->insertTableData('tb_orders', $orderData);
            $bookingchk = $this->common->gettblrowdata(["id" => $ord_id], "order_id", "tb_orders", 0, 0);
            if (count($bookingchk) > 0) {
                $booking_id = $bookingchk['order_id'];
            }
        }
        return ['ord_id' => $ord_id, 'bookext' => $bookext, 'booking_id' => $booking_id];
    }
}
