<?php

defined('BASEPATH') or exit('No direct script access allowed');

class StandardTripInboundModel extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('common');
    }

    public function getAPIHarmonizationData(string $object, string $sourceApp, string $clientIdentifier, string $carrierIdentifier, string $sourceValue): string
    {
        $this->db->select('Sourcevalue, TargetValue');
        $this->db->from('API_Harmonization ah');
        $this->db->where([
            'ah.Object'      => $object,
            'ah.SourceApp'   => $sourceApp,
            'ah.ClientID'    => $clientIdentifier,
            'ah.CarrierID'   => $carrierIdentifier,
            'ah.SourceValue' => $sourceValue,
            'ah.Status'      => 1,
        ]);
        $query = $this->db->get();
    
        // Set default value to empty string
        $targetValue = '';
    
        if ($query && $query->num_rows() > 0) {
            $targetValue = $query->row()->TargetValue;
        }
    
        log_message('error', 'SQL Query: ' . $this->db->last_query());
        return $targetValue;
    }
    
    public function getPartyUsersAPIData(string $object, string $sourceApp, string $clientIdentifier, string $carrierIdentifier, string $sourceValue): string
    {
        $this->db->select('Sourcevalue, TargetValue');
        $this->db->from('party_users_api pu');
        $this->db->where([
            'pu.Object'      => $object,
            'pu.SourceApp'   => $sourceApp,
            'pu.ClientID'    => $clientIdentifier,
            'pu.CarrierID'   => $carrierIdentifier,
            'pu.SourceValue' => $sourceValue,
            'pu.Status'      => 1,
        ]);
    
        $query = $this->db->get();
    
        // Set default value to empty string
        $targetValue = '';
    
        if ($query && $query->num_rows() > 0) {
            $targetValue = $query->row()->TargetValue;
        }
    
        log_message('error', 'SQL Query: ' . $this->db->last_query());
        return $targetValue;
    }

    
    public function getCargoAPIData(string $sourceApp, string $clientIdentifier, string $carrierIdentifier, string $sourceValue): string
    {
        $this->db->select('Sourcevalue, TargetValue');
        $this->db->from('cargo_type_api ct');
        $this->db->where([
            'ct.SourceApp'   => $sourceApp,
            'ct.ClientID'    => $clientIdentifier,
            'ct.CarrierID'   => $carrierIdentifier,
            'ct.SourceValue' => $sourceValue,
            'ct.Status'      => 1,
        ]);
        $query = $this->db->get();
    
        // Set default value to empty string
        $targetValue = '';
    
        if ($query && $query->num_rows() > 0) {
            $targetValue = $query->row()->TargetValue;
        }
    
        //log_message('error', 'SQL Query: ' . $this->db->last_query());
        return $targetValue;
    }
    
    public function getReferenceAPIData(string $sourceApp, string $clientIdentifier, string $carrierIdentifier, string $sourceValue): string
    {
        $this->db->select('Sourcevalue, TargetValue');
        $this->db->from('reference_api ct');
        $this->db->where([
            'ct.SourceApp'   => $sourceApp,
            'ct.ClientID'    => $clientIdentifier,
            'ct.CarrierID'   => $carrierIdentifier,
            'ct.SourceValue' => $sourceValue,
            'ct.Status'      => 1,
        ]);
        $query = $this->db->get();
    
        // Set default value to empty string
        $targetValue = '';
    
        if ($query && $query->num_rows() > 0) {
            $targetValue = $query->row()->TargetValue;
        }
    
        log_message('error', 'SQL Query: ' . $this->db->last_query());
        return $targetValue;
    }
    
    public function getPartyData(array $partyData, string $partyRole, string $companyCode, string $clientCode, string $userId): string
    {
        log_message('error', 'partyData: ' . json_encode($partyData));
        if (!empty($partyData['Company']['Name'])) {
            $partyName = $partyData['Company']['Name'];
        } elseif (!empty($partyData['Address']['CompanyName'])) {
            $partyName =$partyData['Address']['CompanyName'];
        }
        $partyEmail    = $partyData['ContactInfo']['EmailAddress'] ?? "";
        $partyMobile      = $partyData['ContactInfo']['ContactNo'] ?? "";
        $partyCity    = $partyData['Address']['City'] ?? "";
        $partyState    = $partyData['Address']['State'] ?? "";
        $partyStreet = $partyData['Address']['Street'] ?? "";
        $partyPostalCode = $partyData['Address']['Postal'] ?? "";
        $partySourceAddress = $partyDestinationAddress = $partyAddress = '';
        if (!empty($partyData['Address']['Address1'])) {
            $partySourceAddress = $partyData['Address']['Address1'];
        }
        if (!empty($partyData['Address']['Address2'])) {
            $partyDestinationAddress .= $partyData['Address']['Address2'];
        }
        if (!empty($partySourceAddress) || !empty($partyDestinationAddress)) {
            $partyAddress = $partySourceAddress . "," . $partyDestinationAddress;
        }
        log_message('error', 'partyAddresspartyAddresspartyAddress: ' . $partyAddress);
        //$partyAddress = !empty($partyData['Address']['Address1']) ? $partyData['Address']['Address1'] : "";
        $partyCountry  = $partyData['Address']['Country'] ?? "";
        
        $this->db->select('tpt.id');
        $this->db->from('`tbl_party_types` `tpt`');
        $this->db->where(['`tpt.company_code`' => $companyCode, '`tpt`.`branch_code`' => $clientCode, '`tpt`.`user_id`' => $userId, 'UPPER(tpt.name)' => strtoupper($partyRole), 'tpt.`status' => 1]);
       
        $getPartyTypeId = $this->db->get();
        log_message('error', 'Qryyyyyyyyy: ' . $this->db->last_query());
        if ($getPartyTypeId->num_rows() == 0) {
            $curdt = date("Y-m-d H:i:s");
            $party = [
                'name'         => $partyRole,
                'description'  => $partyRole,
                'user_id'      => $userId,
                'company_code' => $companyCode,
                'branch_code'  => $clientCode,
                'created_on'   => $curdt,
                'updated_on'   => $curdt,
            ];
            $cpartyId = $this->common->insertTableData("tbl_party_types", $party);
        } else {
            $row      = $getPartyTypeId->row_array();
            $cpartyId = $row['id'];
        }
        $masterCheck = [
            'UPPER(name)'    => strtoupper($partyName),
            'UPPER(state)'   => strtoupper($partyState),
            'UPPER(pincode)' => strtoupper($partyPostalCode),
            'user_id'        => $userId,
            'company_code'   => $companyCode,
            'branch_code'    => $clientCode,
            'status'         => '1',
        ];
        $checkParty = $this->common->gettblrowdata($masterCheck, "code", "tbl_party_master", 1, 0);
        
        log_message('error', 'Qryyyyyyyyy111111: ' . $this->db->last_query());
        
        if(isset($checkParty['code']) && $checkParty['code'] != ''){
            $partyCode = $checkParty['code'];
        } else {
            $masterInsert = [
                'party_type_id' => $cpartyId,
                'name'          => $partyName,
                'state'         => $partyState,
                'pincode'       => $partyPostalCode,
                'country'       => $partyCountry,
                'user_id'       => $userId,
                'company_code'  => $companyCode,
                'branch_code'   => $clientCode,
                'status'        => '1',
                'address'       => $partyAddress,
                'location_id'   => $partyCity,
                'email'         => $partyEmail ?? "",
                'mobile'        => $partyMobile ?? "",
            ];
            log_message('error', 'partyAddress111111111111: ' . $partyAddress);
            $partyId   = $this->common->insertTableData("tbl_party_master", $masterInsert);
            log_message('error', 'partyId: ' . $partyId);
            $partyId = str_pad($partyId, 4, '0', STR_PAD_LEFT);
            $year          = date('y');
            $week          = date('W');
            $countryCode   = substr($companyCode, 0, 2);
            $get_country_master = $this->common->gettblrowdata(array('status'=>1,'country_code'=>$countryCode),"phone_code","tbl_country_master",0,0);
            if(isset($get_country_master['phone_code']) && $get_country_master['phone_code']!=''){
                $countryCode = $get_country_master['phone_code'];
            }
            $partyCode = $countryCode . $year . $week . $partyId;
            log_message('error', 'partyCode: ' . $partyCode);
            $mobile        = ! empty($partyMobile) ? $partyMobile : $partyCode;
            $upd           = $this->common->updatetbledata("tbl_party_master", ['code' => $partyCode, 'mobile' => $mobile, 'customeridentifier' => $partyCode], ['id' => $partyId]);
        }

        return $partyCode;
    }
}
