<?php

defined('BASEPATH') or exit('No direct script access allowed');

class DriverDashboard extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'driverDashboard/DriverDashboard']);
    }

    public function getVendorslist(int $uid): array
    {
        if (empty($uid)) { return [];  } else {
            $vquery = $this->db->select("id,name")->get_where("tb_vendors", ["user_id" => $uid ,"status" => 1,"name !=" => ''], 0, 0);
            return $vquery->num_rows() > 0 ? $result = $vquery->result_array() : [];
        }
    }

    public function getDriverlist(int $uid): array
    {
        if (empty($uid)) {  return []; } else {
            $cid = $this->input->get('cid');
            $where = (!empty($cid)) ? ["user_id" => $uid , "vendor_id" => $cid ] : ["user_id" => $uid ];
            $vquery = $this->db->select("id,name")->get_where("tb_truck_drivers", $where, 0, 0);
            return $vquery->num_rows() > 0 ? $vquery->result_array() : [];
        }
    }

    public function getCustomerlist(int $uid): array
    {
        if (empty($uid)) { return []; } else {
            $vquery = $this->db->select("id,name")->get_where("tb_customers", ["user_id" => $uid], 0, 0);
            return $vquery->num_rows() > 0 ? $vquery->result_array() : [];
        }
    }

    public function ajaxtripListing()
    {
        $post = $this->input->get();
        $uid = $this->session->userdata('user_id');
        $data = $this->getallTripsinfo($uid, $post);
        return $data;
    }

    public function getallTripsinfo(int $uid, array $post): array
    {
        if (!empty($uid) && !empty($post)) {
            $where = " and ";
            if ($post['duration'] == 'one' || $post['duration'] == 'week') {
                $where .= "DATE(s.startdate) >='" . $post['fromdate'] . "' and DATE(s.enddate) <= '" . $post['todate'] . "' ";
            } else {
                if (!empty($post['fromdate']) && !empty($post['todate'])) {
                    $where .= "DATE(s.startdate) >='" . $post['fromdate'] . "' and DATE(s.enddate) <= '" . $post['todate'] . "' ";
                } else {
                    if (!empty($post['fromdate'])) {
                        $where .= " and DATE(s.startdate) ='" . $post['fromdate'] . "' ";
                    } else {
                        if (!empty($post['todate'])) {
                            $where .= " and DATE(s.enddate) ='" . $post['todate'] . "' and ";
                        }
                    }
                }
            }
            if (!empty($post['carrier'])) {
                $where .= "and s.vendor_id =" . $post['carrier'] . " ";
            }
            if (!empty($post['driver'])) {
                $where .= "and t.driver_id =" . $post['driver'] . " ";
            }
            if (!empty($post['customer'])) {
                $where .= "and s.customer_id =" . $post['customer'] . " ";
            }
            $where1 = "";
            if (!empty($post['status'])) {
                if($post['status'] == 'completed'){
                    $sts = 1;
                }else {
                    $sts = 0;
                }
                $where1 .= "and o.trip_sts =" . $sts. " ";
            }else{
                $sts= 0;
                $where1 .=" and o.trip_id >= 0 and o.shift_id > 0 and o.trip_sts != 1";
            }
            $shift_data = [];
            $query = $this->db->query(
                " select s.shipmentid,s.scity,s.dcity,s.startdate,s.enddate,s.status,s.id as sid,o.trip_sts
           from tb_shifts as s
           left join tb_orders as o on s.id = o.shift_id
           left join tb_trips  as t on t.id = o.trip_id
           where s.user_id = ? " . $where . $where1 . " group by s.shipmentid  order by s.startdate DESC",
                [$uid]
            );
            if ($query->num_rows() > 0) {
                foreach($query->result_array() as $res ){
                    $shift_data[] = array(
                        "sid"  => $res['sid'],
                        "shipmentid" => $res['shipmentid'],
                        "scity" => $res['scity'],
                        "dcity" => $res['dcity'],
                        "startdate" => $res['startdate'],
                        "enddate" => $res['enddate'],
                        "status" => $res['status'],
                        "trip_sts" => $res['trip_sts']
                    );
                }
            }
            $cquery = $this->db->query("select o.shift_id from tb_orders as o left join tb_shifts as s on s.id = o.shift_id
                left join tb_trips  as t on t.shift_id = s.id
                where s.user_id =$uid and o.trip_id = 0 and o.shift_id > 0 and o.trip_sts !=1  ".$where." ");
            if ($cquery->num_rows() > 0) {
                $cres = $cquery->result_array();
                $ssres = array_column($cres, 'shift_id');
                $sub_where = join("','",$ssres);
                $sub_query= $this->db->query("select s.shipmentid,s.scity,s.dcity,s.startdate,s.enddate,s.status,s.id as sid,e.trip_id from tb_shifts as s left join tb_employee as e on e.shipment_id = s.id where s.user_id = $uid and s.id IN('$sub_where')");
                if ($sub_query->num_rows() > 0) {
                    foreach ($sub_query->result_array() as $sres) {
                        if($sts == 1) {
                            if ($sres['trip_id'] > 0) {
                                $trip_sts = $this->db->query("select status,transit_status from tb_trips where id= " . $res['trip_id']);
                                if ($trip_sts->num_rows() > 0) {
                                    $status = $trip_sts->row()->status;
                                    $tsts = $trip_sts->row()->transit_status;
                                }
                                if($status == 0 && $tsts == 1) {
                                    $shift_data[] = [
                                        "sid" => $sres['sid'],
                                        "shipmentid" => $sres['shipmentid'],
                                        "scity" => $sres['scity'],
                                        "dcity" => $sres['dcity'],
                                        "startdate" => $sres['startdate'],
                                        "enddate" => $sres['enddate'],
                                        "status" => $sres['status'],
                                        "trip_sts" => $sts
                                    ];
                                }
                            }
                        }else{
                            $shift_data[] = [
                                "sid" => $sres['sid'],
                                "shipmentid" => $sres['shipmentid'],
                                "scity" => $sres['scity'],
                                "dcity" => $sres['dcity'],
                                "startdate" => $sres['startdate'],
                                "enddate" => $sres['enddate'],
                                "status" => $sres['status'],
                                "trip_sts" => $sts
                            ];
                        }
                    }
                }
              }
            $sort_array = $this->super_unique($shift_data,'startdate');
            return $sort_array ?? [];
        } else {
            return [];
        }
    }

    public function getallMapsdata()
    {
        $post = $this->input->post();
        $uid = $this->session->userdata('user_id');
        $data = $this->getalltripmapsData($uid, $post['shift_ids']);
        return $data;
    }

    public function getalltripmapsData(int $uid, array $shift): array
    {
        if (!empty($uid) && !empty($shift)) {
            $sid = join("','", $shift);
            $query = $this->db->query("select id,slat,slng,elat,elng,scity,dcity from tb_shifts where user_id= ? and id IN('$sid')", [$uid]);
            return $query->num_rows() > 0 ? $query->result_array() : [];
        } else {
            return [];
        }
    }

    public function getallChartsdata()
    {
        $post = $this->input->post();
        $uid = $this->session->userdata('user_id');
        $data = $this->getalltripchartData($uid, $post['shift_ids']);
        return $data;
    }

    public function random_color(): string
    {
        $colors = ["#0080bf", "#00acdf", "#15AAFF", "#55d0ff", "#7ce8ff", "#ccf9ff", "#2EAAFA"];
        $randomIndex = array_rand($colors);
        return $colors[$randomIndex];
    }

    public function getalltripchartData(int $uid, array $shift): string
    {
        if (!empty($uid) && !empty($shift)) {
            $sid = join("','", $shift);
            $result1 = $result2 = $result = [];
            $query = $this->db->query("select id,shipmentid,scity,dcity,startdate,enddate,user_id from tb_shifts where user_id= ? and id IN('$sid')", [$uid]);
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $res) {
                    $color = $this->random_color();
                    $vehicle = $this->getvehicleinfoByshift($res['id'],$res['user_id']);
                    $result1[] = [
                        "category" => $res['shipmentid'],
                        "start" => (strtotime($res['startdate']) * 1000),
                        "end" => (strtotime($res['enddate']) * 1000),
                        "columnSettings" => [
                            "fill" => $color
                        ],
                        "task" => $vehicle['vehicle'] . " - " . $vehicle['driver']
                    ];
                    $result2[] = [
                        "category" => $res['shipmentid']
                    ];
                }
                $result = [
                    "data" => $result1,
                    "category" => $result2
                ];
            }
            return json_encode($result);
        } else {
            return "";
        }
    }

    public function getvehicleinfoByshift(int $shift, int $uid): array
    {
        if (!empty($shift)) {
            $this->db->select("ttd.register_number,tsv.vehicle_id");
            $this->db->from("tb_shft_veh tsv");
            $this->db->join('tb_trucks_data ttd', 'ttd.id = tsv.vehicle_id');
            $this->db->join('tb_trucktypes ttt', 'ttt.id = ttd.truck_type');
            $where = array("tsv.shft_id" => $shift, "tsv.user_id" => $uid);
            $this->db->where($where);
            $getvehicle_info = $this->db->get();
            if ($getvehicle_info->num_rows() > 0) {
                $register_number = $getvehicle_info->row()->register_number;
                $vehicle_id = $getvehicle_info->row()->vehicle_id;
            }
            if (!empty($vehicle_id)) {
                $this->db->select("ttd.name");
                $this->db->from("tbl_assigned_drivers tad");
                $this->db->join('tb_truck_drivers ttd', 'ttd.id = tad.driver_id');
                $vwhere = array("tad.vehicle_id" => $vehicle_id, "tad.status" => 1,"tad.user_id"=> $uid);
                $this->db->where($vwhere);
                $this->db->order_by("ttd.id", "DESC");
                $getdriver = $this->db->get();
                if ($getdriver->num_rows() > 0) {
                    $driver_name = $getdriver->row()->name;
                }
            }
            $driver_name = (!empty($driver_name)) ? $driver_name : "";
            $register_number = (!empty($register_number)) ? $register_number : "";
            $result = [
                "driver" => $driver_name,
                "vehicle" => $register_number
            ];
            return $result ?? [];
        } else {
            return [];
        }
    }

    public function super_unique( array $array, string $key): array
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;

    }

}
