<?php

require_once APPPATH . "/third_party/inspectPdf/MalwareSignatures.php";

class InspectPdf extends MalwareSignatures
{
    public function __construct()
    {
        parent::__construct();
    }

    public function analysePDF(array $file): array
    {
        $pdfStringSearch = $this->PDFstringSearch;
        $pdfHexSearch = $this->PDFhexSearch;
        $globalEngine = $this->globalEngine;
        $fileRaw = file_get_contents($file['filename']);
        $yaraResult = [];
        $fileUpdate = ['exploit' => 0, 'hits' => 0, 'completed' => 1, 'is_malware' => 0, 'summary' => '', 'severity' => 0, 'not_pdf' => 0];
        $header = substr($fileRaw, 0, 1024);
        if (preg_match("/ns.adobe.com\/xdp/si", $header)) {
            preg_match("/<chunk>(.*?)<\/chunk>/si", $fileRaw, $matchF);
            if (isset($matchF[1])) {
                $intermediate = base64_decode($matchF[1]);
                if ($intermediate != '') {
                    $fileRaw = $intermediate;
                }
            }
        }
        $header = substr($fileRaw, 0, 1024);
        if (!preg_match("/%PDF/si", $header)) {
            $fileUpdate['not_pdf'] = 1;
            return $fileUpdate;
        }
        $result = $this->pdfSlice($fileRaw);
        if (isset($result['document']['encrypted']) && $result['document']['encrypted'] > 0) {
            $fileUpdate['encrypted'] = 1;
            $fileUpdate['key'] = $result['document']['key'];
            $fileUpdate['encrypt_alg'] = $result['document']['v'];
            $fileUpdate['key_length'] = $result['document']['key_length'];
        }
        $summaryA = [];
        foreach ($result as $unique => $data) {
            if ($unique != 'document') {
                if (isset($data['parameters']) && preg_match("/(#4F|O)(#62|b)(#6a|j)(#53|S)(#74|t)(#6d|m)/si", $data['parameters'])) {
                    $data['otype'] = "ObjStm";
                    $newobj = $this->parseObjStm($data['parameters'], $data['decoded']);
                    foreach ($newobj as $uniquel => $datal) {
                        $datal['objstm'] = $data['object'];
                        $datal['dup_id'] += $data['dup_id'];
                        $datal['atype'] = "objstm";
                        $result[$uniquel] = $datal;
                    }
                }
            }
        }
        foreach ($result as $unique => $data) {
            if ($unique != 'document') {
                $malware = ['found' => 0];
                $d = '';
                if (isset($data['decoded'])) {
                    $d = $data['decoded'];
                }
                if (preg_match("/^CWS(.{1}?)/s", $d)) {
                    $uncompressed = $this->flashExplode($d);
                    if ($uncompressed != '') {
                        $data['size_uncompressed'] = strlen($uncompressed);
                    }
                    $malware = $this->javascriptScan($malware, $uncompressed, $pdfStringSearch, $pdfHexSearch);
                    if ($malware['found'] >= 1 && (!isset($malware['javascript']) || $malware['javascript'] == '')) {
                        $malware['javascript'] = $uncompressed;
                    }
                    unset($uncompressed);
                }
                $malware = $this->javascriptScan($malware, $d, $pdfStringSearch, $pdfHexSearch);
                if ($malware['found'] >= 1 && (!isset($malware['javascript']) || $malware['javascript'] == '')) {
                    $malware['javascript'] = $d;
                }
                if (strlen($d) < 20000000) {
                    $d = str_replace("\x00", "", $d);
                    $malware = $this->javascriptScan($malware, $d, $pdfStringSearch, $pdfHexSearch);
                    if ($malware['found'] >= 1 && (!isset($malware['javascript']) || $malware['javascript'] == '')) {
                        $malware['javascript'] = $d;
                    }
                    $df = $this->findHiddenJS($d);
                    $malware = $this->javascriptScan($malware, $df, $pdfStringSearch, $pdfHexSearch);
                    unset($df);
                    $df = $this->decodeReplace($d);
                    $malware = $this->javascriptScan($malware, $df, $pdfStringSearch, $pdfHexSearch);
                    if ($malware['found'] >= 1 && (!isset($malware['javascript']) || $malware['javascript'] == '')) {
                        $malware['javascript'] = $df;
                    }
                    unset($df);
                } else {
                    $malware[uniqid('', true)] = [
                        'searchtype' => 'pdfoverflow',
                        'matching' => 'full',
                        'keylength' => 0,
                        'key' => '',
                        'search' => 'size',
                        'location' => 0,
                        'top' => 0,
                        'keycount' => 0,
                        'keysum' => '',
                        'keylocation' => 0,
                        'keyaccuracy' => 0,
                        'searcherrors' => 0,
                        'virustype' => 'warning block size over 10MB',
                        'block' => '',
                        'block_is_decoded' => 1,
                        'block_encoding' => 'plain',
                        'block_size' => strlen($d),
                        'block_md5' => md5($d),
                        'block_sha1' => sha1($d),
                        'block_sha256' => hash('sha256', $d),
                        'rawblock' => '',
                        'rawclean' => ''
                    ];
                    $malware['found'] = 1;
                }
                if (isset($data['md5_raw'])) {
                    $ret = $this->checkBlockHash($data['md5_raw']);
                    if ($ret['found'] == 1) {
                        $malware = array_merge($ret, $malware);
                        //echo "blocka\n";
                        $malware['found'] = 1;
                    } elseif (isset($data['md5'])) {
                        $ret = $this->checkBlockHash($data['md5']);
                        if ($ret['found'] == 1) {
                            $malware = array_merge($ret, $malware);
                            //echo "blockb\n";
                            $malware['found'] = 1;
                        }
                    }
                } elseif (isset($data['md5'])) {
                    $ret = $this->checkBlockHash($data['md5']);
                    if ($ret['found'] == 1) {
                        $malware = array_merge($ret, $malware);
                        $malware['found'] = 1;
                    }
                }
                if (isset($data['parameters']) && $data['parameters'] != '') {
                    $malware = $this->javascriptScan($malware, $data['parameters'], $pdfStringSearch, $pdfHexSearch);
                }
                $pdfobj = [
                    'obj_id' => $data['object'],
                    'gen_id' => $data['generation'],
                    'params' => $data['parameters'],
                    'dup_id' => $data['dup_id'],
                    'parent_md5' => $file['md5'] ?? "",
                    'parent_sha256' => $file['sha256'] ?? ""
                ];
                if (isset($data['filename_uncompressed'])) {
                    $pdfobj['filename_uncompressed'] = $data['filename_uncompressed'];
                    $pdfobj['size_uncompressed'] = $data['size_uncompressed'];
                }
                if ($malware['found'] >= 1) {
                    $pdfobj['exploit'] = 1;
                    $fileUpdate['exploit'] = 1;
                    $fileUpdate['hits']++;
                    foreach ($malware as $search => $hitraw) {
                        if (is_array($hitraw)) {
                            $hit = [
                                'obj_id' => $data['object'],
                                'gen_id' => $data['generation'],
                                'dup_id' => $data['dup_id'],
                                'exploittype' => $hitraw['virustype']
                            ];
                            if (isset($hitraw['block_type']) && stristr($hitraw['block_type'], 'shellcode')) {
                                $hit['shellcode'] = 1;
                            }
                            if (isset($hitraw['rawblock'])) {
                                $hit['partial'] = $hitraw['rawblock'];
                            }
                            if (stristr($hitraw['virustype'], 'javascript in XFA block')) {
                                $pdfobj['js'] = 1;
                            }
                            if (stristr($hitraw['virustype'], 'CVE-') && !stristr($hitraw['virustype'], 'CVE-2009-0658')) {
                                $fileUpdate['severity'] += 10;
                            } else {
                                $fileUpdate['severity'] += 1;
                            }
                            $summaryA[$hit['obj_id'] . "." . $hit['gen_id'] . "@" . $hit['dup_id'] . $hit['exploittype']] = $hit['obj_id'] . "." . $hit['gen_id'] . "@" . $hit['dup_id'] . ": " . $hit['exploittype'] . "\n";
                        }
                    }
                }
                if (isset($data['key'])) {
                    $pdfobj['key'] = $data['key'];
                }
                if (isset($data['filter'])) {
                    $pdfobj['filters'] = $data['filter'];
                }
                if (isset($data['atype']) && $data['atype'] == 'js') {
                    $pdfobj['js'] = 1;
                }
                if (!isset($pdfobj['js']) && isset($data['decoded'])) {
                    $dat = str_replace("\x00", "", $data['decoded']);
                    $level = $this->isJs($dat);
                    if ($level > 1) {
                        $pdfobj['js'] = $level;
                    }
                }
                if (!isset($pdfobj['js']) && (preg_match("/\/(#4a|J)(#61|a)(#76|v)(#61|a)(#53|S)(#63|c)(#72|r)(#69|i)(#70#p)(#74|t)\s+" . $data['object'] . "\s+" . $data['generation'] . "\s+R/si", $fileRaw) || preg_match("/\/(#4a|J)(#53|S)\s+" . $data['object'] . "\s+" . $data['generation'] . "\s+R/s", $fileRaw))) {
                    $pdfobj['js'] = 1;
                }
                if (!isset($pdfobj['js']) && preg_match("/\/(#4a|J)(#53|S)\s+\(/s", $data['parameters'])) {
                    $pdfobj['js'] = 1;
                }
                if (!isset($pdfobj['js']) && $this->scanStreams($result, $data['object'], $data['generation']) == 1) {
                    $pdfobj['js'] = 1;
                }
                if (isset($data['parameters']) && preg_match("/(#61|a)(#70|p)(#70|p)(#6c|l)(#69|i)(#63|c)(#61|a)(#74|t)(#69|i)(#6f|o)(#6e|n)\s*(#2F|\/)\s*(#70|p)(#64|d)(#66|f)/si", $data['parameters'])) {
                    $pdfobj['embed_file'] = 1;
                }
                if (isset($data['otype']) && $data['otype'] != '') {
                    $pdfobj['otype'] = $data['otype'];
                }
                if (isset($data['parameters']) && preg_match("/(#4F|O)(#62|b)(#6a|j)(#53|S)(#74|t)(#6d|m)/si", $data['parameters'])) {
                    //check for ObjStm
                    $pdfobj['otype'] = "ObjStm";
                }
                if (isset($result['document']['encrypted'])) {
                    $pdfobj['encrypted'] = $result['document']['encrypted'];
                } else {
                    $pdfobj['encrypted'] = 0;
                }
                if (isset($data['stream']) && $data['stream'] != '') {
                    $pdfobj['md5_raw'] = $data['md5_raw'];
                    $pdfobj['size_raw'] = strlen($data['stream']);
                }
                if (isset($pdfobj['embed_file']) && $pdfobj['embed_file'] == 1) {
                    if (isset($data['decoded']) && $data['decoded'] != '') {
                        if (preg_match("/%PDF/si", $data['decoded'])) {
                            if (isset($sub['severity'])) {
                                $fileUpdate['severity'] += $sub['severity'];
                            }
                        }
                    }
                }
                if (isset($pdfobj['js']) && $pdfobj['js'] > 0) {
                    $fileUpdate['severity'] += 1;
                }
                if ($fileUpdate['severity'] > 0) {
                    $fileUpdate['is_malware'] = 1;
                }
                if (isset($pdfobj['js']) && $pdfobj['js'] > 0) {
                    $summaryA[$pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . "js"] = $pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . ": suspicious.warning: object contains JavaScript\n";
                }
                if (isset($pdfobj['embed_file']) && $pdfobj['embed_file'] == 1) {
                    $summaryA[$pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . "pdf"] = $pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . ": suspicious.warning: object contains embedded PDF\n";
                }
                if (isset($pdfobj['size_raw']) && isset($pdfobj['size_decoded']) && $pdfobj['size_raw'] > 0 && $pdfobj['size_decoded'] == 0) {
                    $summaryA[$pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . "dc"] = $pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . ": suspicious.warning: object not decoded\n";
                }
            }
        }
        if (preg_match_all("/(\x25\x25EOF)/s", $fileRaw, $matches, PREG_OFFSET_CAPTURE)) {
            $occ = count($matches[0]);
            $lastloc = $matches[0][$occ - 1][1] + 5;
            $enddata = trim(substr($fileRaw, $lastloc), "\x0A\x0D");
            if ($enddata != '') {
                $pdfobj = [
                    'obj_id' => -1,
                    'gen_id' => -1,
                    'dup_id' => $lastloc,
                ];
                $pdfobj['size_raw'] = strlen($enddata);
                if ($pdfobj['obj_id'] == -1 && $pdfobj['size_raw'] > 128) {
                    $summaryA[$pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . "ss"] = $pdfobj['obj_id'] . "." . $pdfobj['gen_id'] . "@" . $pdfobj['dup_id'] . ": suspicious.warning: end of file contains content\n";
                }
            }
        }
        foreach ($summaryA as $key => $value) {
            $fileUpdate['summary'] .= $value;
        }
        $fileUpdate['engine'] = $globalEngine;
        if (isset($global_export_all) && $global_export_all == 1) {
            $fileUpdate['export_all'] = $result;
        }
        return $fileUpdate;
    }

    private function pdfDecryptRC4($message, $key, $ishex = 0): string
    {
        return $this->rc4($key, $message, $ishex);
    }

    private function rc4($pwd, $data, $ispwdHex = 0): string
    {
        if ($ispwdHex) {
            $pwd = @pack('H*', $pwd);
        }
        $key[] = '';
        $box[] = '';
        $cipher = '';
        $pwd_length = strlen($pwd);
        $data_length = strlen($data);
        for ($i = 0; $i < 256; $i++) {
            $key[$i] = ord($pwd[$i % $pwd_length]);
            $box[$i] = $i;
        }
        for ($j = $i = 0; $i < 256; $i++) {
            $j = ($j + $box[$i] + $key[$i]) % 256;
            $tmp = $box[$i];
            $box[$i] = $box[$j];
            $box[$j] = $tmp;
        }
        for ($a = $j = $i = 0; $i < $data_length; $i++) {
            $a = ($a + 1) % 256;
            $j = ($j + $box[$a]) % 256;
            $tmp = $box[$a];
            $box[$a] = $box[$j];
            $box[$j] = $tmp;
            $k = $box[(($box[$a] + $box[$j]) % 256)];
            $cipher .= chr(ord($data[$i]) ^ $k);
        }
        return $cipher;
    }

    private function lowOrder(string $data): string
    {
        $new = '';
        for ($i = strlen($data) - 2; $i >= 0; $i -= 2) {
            $new .= $data[$i] . $data[$i + 1];
        }
        return $new;
    }

    private function flashExplode(string $stream): string
    {
        $magic = substr($stream, 0, 3);
        if ($magic == "CWS") {
            $header = substr($stream, 4, 5);
            $content = substr($stream, 10);
            $uncompressed = @gzinflate($content);
            return "FWS" . $header . $uncompressed;
        } else {
            return $stream;
        }
    }

    private function asciihexdecode($hex): string
    {
        $bin = '';
        for ($i = 0; $i < strlen($hex) - 1; $i++) {
            if (ctype_alnum($hex[$i]) && ctype_alnum($hex[$i + 1])) {
                $n = $hex[$i] . $hex[$i + 1];
                $bin .= chr(hexdec($n));
                $i++;
            }
        }
        return $bin;
    }

    private function pdfhex($hex): string
    {
        $str = '';
        for ($i = 0; $i < strlen($hex); $i++) {
            if ($i + 2 <= strlen($hex) && $hex[$i] == '#' && ctype_alnum($hex[$i + 1]) && ctype_alnum($hex[$i + 2])) {
                $n = $hex[$i + 1] . $hex[$i + 2];
                $str .= chr(hexdec($n));
                $i += 2;
            } else {
                $str .= $hex[$i];
            }
        }
        return $str;
    }

    private function flateDecode($data)
    {
        $errlev = error_reporting();
        error_reporting(0);
        $out = @gzinflate($data);
        error_reporting($errlev);
        return $out;
    }

    private function ascii85_decode($data)
    {
        $output = '';
        $whiteSpace = ["\x00", "\x09", "\x0A", "\x0C", "\x0D", "\x20"];
        $data = str_replace($whiteSpace, '', $data);
        $data = substr($data, 0, (strlen($data) - 2));
        $dataLength = strlen($data);
        for ($i = 0; $i < $dataLength; $i += 5) {
            $b = 0;
            if (substr($data, $i, 1) == "z") {
                $i -= 4;
                $output .= pack("N", 0);
                continue;
            }
            $c = substr($data, $i, 5);
            if (strlen($c) < 5) {
                break;
            }
            $c = unpack('C5', $c);
            $value = 0;
            for ($j = 1; $j <= 5; $j++) {
                $value += (($c[$j] - 33) * pow(85, (5 - $j)));
            }
            $output .= pack("N", $value);
        }
        if ($i < $dataLength) {
            $value = 0;
            $chunk = substr($data, $i);
            $partialLength = strlen($chunk);
            for ($j = 0; $j < (5 - $partialLength); $j++) {
                $chunk .= 'u';
            }
            $c = unpack('C5', $chunk);
            for ($j = 1; $j <= 5; $j++) {
                $value += (($c[$j] - 33) * pow(85, (5 - $j)));
            }
            $foo = pack("N", $value);
            $output .= substr($foo, 0, ($partialLength - 1));
        }
        return $output;
    }

    private function runlengthdecode($data)
    {
        $dataLength = strlen($data);
        $output = '';
        $i = 0;
        while ($i < $dataLength) {
            $byteValue = ord($data[$i]);
            if ($byteValue == 128) {
                break;
            }
            if ($byteValue < 128) {
                $output .= substr($data, $i + 1, ($byteValue + 1));
                $i += $byteValue + 2;
            }
            if ($byteValue > 128) {
                $numOfTimesToCopy = 257 - $byteValue;
                $copyValue = $data[$i + 1];
                for ($j = 0; $j < $numOfTimesToCopy; $j++) {
                    $output .= $copyValue;
                }
                $i += 2;
            }
        }
        return $output;
    }

    private function strhex($string)
    {
        $hex = '';
        $len = strlen($string);
        for ($i = 0; $i < $len; $i++) {
            $hex .= str_pad(dechex(ord($string[$i])), 2, 0, STR_PAD_LEFT);
        }
        return $hex;
    }

    private function decryptObj($document, $object, $key, $stream)
    {
        if ($key != '') {
            $object['key_long'] = $key . $object['decrypt_part'];
            $object['key'] = md5(self::hex2bin($object['key_long']));
            if ($document['v'] == 1) {
                $object['key'] = substr($object['key'], 0, 20);
            }
            if ($document['v'] == 3) {
                $object['obj_hex'] = $this->pdfxor($this->pdfhexTostring($object['obj_hex']), $this->pdfhexTostring('3569AC'));
                $object['gen_hex'] = $this->pdfxor($this->pdfhexTostring($object['gen_hex']), $this->pdfhexTostring('CA96'));
                $object['decrypt_part'] = $this->lowOrder($object['obj_hex']) . $this->lowOrder($object['gen_hex']);
                if ($document['v'] >= 3) {
                    $object['decrypt_part'] .= "73416C54";
                }
                $object['key_long'] = $key . $object['decrypt_part'];
                $object['key'] = md5(self::hex2bin($object['key_long']));
            }
            $t = $this->pdfDecryptRC4($stream, $object['key'], 1);
        } else {
            $t = $stream;
        }
        return $t;
    }

    private function pdfhexTostring(string $hex): string
    {
        $str = '';
        for ($i = 0; $i < strlen($hex); $i += 2) {
            $str .= chr(hexdec(substr($hex, $i, 2)));
        }
        return $str;
    }

    private function pdfxor($InputString, $KeyPhrase)
    {
        $KeyPhraseLength = strlen($KeyPhrase);
        for ($i = 0; $i < strlen($InputString); $i++) {
            $rPos = $i % $KeyPhraseLength;
            $r = ord($InputString[$i]) ^ ord($KeyPhrase[$rPos]);
            $InputString[$i] = chr($r);
        }
        return $InputString;
    }

    private function unliteral($oct)
    {
        $dec = '';
        for ($i = 0; $i < strlen($oct); $i++) {
            if ($oct[$i] == '\\') {
                if (!isset($oct[$i + 1])) {
                    return $dec;
                }
                if ($oct[$i + 1] == 'n') {
                    $dec .= chr(hexdec("0a"));
                    $i += 1;
                } elseif ($oct[$i + 1] == 'r') {
                    $dec .= chr(hexdec("0d"));
                    $i += 1;
                } elseif ($oct[$i + 1] == 't') {
                    $dec .= chr(hexdec("09"));
                    $i += 1;
                } elseif ($oct[$i + 1] == 'b') {
                    $dec .= chr(hexdec("08"));
                    $i += 1;
                } elseif ($oct[$i + 1] == 'f') {
                    $dec .= chr(hexdec("0c"));
                    $i += 1;
                } elseif ($oct[$i + 1] == '(') {
                    $dec .= chr(hexdec("28"));
                    $i += 1;
                } elseif ($oct[$i + 1] == ')') {
                    $dec .= chr(hexdec("29"));
                    $i += 1;
                } elseif ($oct[$i + 1] == '\\') {
                    $dec .= chr(hexdec("5c"));
                    $i += 1;
                } elseif (isset($oct[$i + 3]) && preg_match('/^[0-7]$/', $oct[$i + 1] . $oct[$i + 2] . $oct[$i + 3]) === true) {
                    $dec .= chr(octdec($oct[$i + 1] . $oct[$i + 2] . $oct[$i + 3]));
                    $i += 3;
                } elseif (isset($oct[$i + 2]) && preg_match('/^[0-7]$/', $oct[$i + 1] . $oct[$i + 2]) === true) {
                    $dec .= chr(octdec($oct[$i + 1] . $oct[$i + 2]));
                    $i += 2;
                } elseif (isset($oct[$i + 1]) && preg_match('/^[0-7]$/', $oct[$i + 1]) === true) {
                    $dec .= chr(octdec($oct[$i + 1]));
                    $i += 1;
                } else {
                    $dec .= $oct[$i];
                }
            } else {
                $dec .= $oct[$i];
            }
        }
        return $dec;
    }

    private function pdfSlice(string $data): array
    {
        global $global_userpass;
        $key = '';
        $globalTest = $this->global_test;
        $block_encoding = '';
        $result = ['document' => []];
        $result['document']['v'] = "0";
        if (preg_match("/\/AuthEvent\/DocOpen\/CFM\/AESV2/si", $data) || preg_match("/\/Encrypt\s+/s", $data)) {
            if (preg_match("/\/Encrypt (\d+)\D+(\d+)\D+R/si", $data, $matches)) {
                $result['document']['encrypt_obj'] = $matches[1];
                $result['document']['encrypt_gen'] = $matches[2];
                preg_match_all("/(\x0a|\x0d|\x20)" . $result['document']['encrypt_obj'] . "[^\d]{1,3}" . $result['document']['encrypt_gen'] . "[^\d]{1,3}obj(.+?)endobj/si", $data, $matches0, PREG_OFFSET_CAPTURE);
                if (isset($matches0[0])) {
                    $ordered = [];
                    for ($j = 0; $j < count($matches0[0]); $j++) {
                        $ordered[$matches0[2][$j][1]] = [];
                        for ($i = 1; $i < count($matches0); $i++) {
                            $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                        }
                    }
                }
                $encrypt_block = end($ordered);
                $encrypt_block = $encrypt_block[2];
            }

            if (!isset($encrypt_block)) {
                preg_match("/\/Encrypt(.*?)(endobj|$)/si", $data, $matches);
                if (isset($matches[1])) {
                    $encrypt_block = $matches[1];
                }
            }

            if (!isset($encrypt_block)) {
                $encrypt_block = $data;
            }
            $encrypted = 1;
            $result['document']['encrypted'] = 1;
            $result['document']['padding'] = '28BF4E5E4E758A4164004E56FFFA01082E2E00B6D0683E802F0CA9FE6453697A'; //standard padding
            $result['document']['u'] = "00000000000000000000000000000000";
            if (isset($global_userpass) && $global_userpass != '') {
                $result['document']['u'] = $this->strhex($global_userpass);
            }
            $result['document']['o'] = "";
            $result['document']['id'] = "";
            if (preg_match_all("/\/ID[^\[]{0,5}\[\s*<(.*?)>/si", $data, $matchi)) {
                $last = count($matchi[1]) - 1;
                if ($last < 0) {
                    $last = 0;
                }
                $result['document']['id'] = $matchi[1][$last];
            } elseif (preg_match_all("/\/ID[^\[]{0,5}\[\s*\((.*?)\)/si", $data, $matchi)) {
                $last = count($matchi[1]) - 1;
                if ($last < 0) {
                    $last = 0;
                }
                $result['document']['id'] = $this->strhex($this->unliteral($matchi[1][$last]));
            }
            if (preg_match("/\/O[^\(]{0,5}\((.{32,64}?)\)/si", $encrypt_block, $matcho)) {
                $result['document']['o'] = $this->strhex($matcho[1]);
            } elseif (preg_match("/\/O[^\<]{0,5}\<(.{64}?)\>/si", $encrypt_block, $matcho)) {
                $result['document']['o'] = $matcho[1];
            }
            if ($result['document']['o'] == "" && preg_match("/trailer.{1,400}\/O[^\<]{0,5}\<(.{32,64}?)\>/si", $data, $matcho)) {
                $result['document']['o'] = $matcho[1];
            }
            $result['document']['o_orig'] = $result['document']['o'];
            if (strlen($result['document']['o']) > 64) {
                $result['document']['o'] = $this->strhex($this->unliteral(hex2str($result['document']['o'])));
            }
            $result['document']['key_length'] = 128;
            if (preg_match("/\/Length\s+(\d{1,4})\D/si", $encrypt_block, $matchl)) {
                $result['document']['key_length'] = $matchl[1];
            }
            if ($result['document']['key_length'] <= 16) {
                $result['document']['key_length'] *= 8;
            }
            $result['document']['r'] = 1; //version
            if (preg_match("/\/R (\d{1})\D/si", $encrypt_block, $matchr)) {
                $result['document']['r'] = $matchr[1];
            } //version 1-4
            $result['document']['v'] = 4; //version
            if (preg_match("/\/V (\d{1})\D/si", $encrypt_block, $matchv)) {
                $result['document']['v'] = $matchv[1];
            } //version 1-4
            if (preg_match("/\/P ([0-9-]*)/si", $encrypt_block, $matchp)) {
                $result['document']['p'] = $matchp[1];
            } //permission - 32 bit
            if ($result['document']['r'] <= 2) {
                $result['document']['key_length'] = 40;
            }
            if ($result['document']['r'] == 5) {
                $result['document']['key_length'] = 256;
                if (preg_match("/\/O[^\(]{0,5}\((.{48,132}?)\)/si", $encrypt_block, $matcho)) {
                    $result['document']['o'] = $this->strhex($matcho[1]);
                } elseif (preg_match("/\/O[^\<]{0,5}\<(.{96,164}?)\>/si", $encrypt_block, $matcho)) {
                    $result['document']['o'] = $matcho[1];
                }
                if (strlen($result['document']['o']) > 96)  //fix escaped things
                {
                    $result['document']['o'] = $this->strhex($this->unliteral(hex2str($result['document']['o'])));
                }
                if (strlen($result['document']['o']) > 96) {
                    $result['document']['o'] = substr($result['document']['o'], 0, 96);
                }
                if (preg_match("/\/U[\s]{0,5}\((.{48,132}?)\)/si", $encrypt_block, $matcho)) {
                    $result['document']['u'] = $this->strhex($matcho[1]);
                } elseif (preg_match("/\/U[\s]{0,5}\<(.{96,164}?)\>/si", $encrypt_block, $matcho)) {
                    $result['document']['u'] = $matcho[1];
                }
                if (strlen($result['document']['u']) > 96)  //fix escaped things
                {
                    $result['document']['u'] = $this->strhex($this->unliteral(hex2str($result['document']['u'])));
                }
                if (strlen($result['document']['u']) > 96) {
                    $result['document']['u'] = substr($result['document']['u'], 0, 96);
                }
                $result['document']['oe'] = "";
                $result['document']['ue'] = "";
                $result['document']['perms'] = "";
                if (preg_match("/\/OE[^\(]{0,5}\((.{32,64}?)\)/si", $encrypt_block, $matcho)) {
                    $result['document']['oe'] = $this->strhex($matcho[1]);
                } elseif (preg_match("/\/OE[^\<]{0,5}\<(.{64}?)\>/si", $encrypt_block, $matcho)) {
                    $result['document']['oe'] = $matcho[1];
                }
                if (strlen($result['document']['oe']) > 64)  //fix escaped things
                {
                    $result['document']['oe'] = $this->strhex($this->unliteral(hex2str($result['document']['oe'])));
                }
                if (preg_match("/\/UE[^\(]{0,5}\((.{32,64}?)\)/si", $encrypt_block, $matcho)) {
                    $result['document']['ue'] = $this->strhex($matcho[1]);
                } elseif (preg_match("/\/UE[^\<]{0,5}\<(.{64}?)\>/si", $encrypt_block, $matcho)) {
                    $result['document']['ue'] = $matcho[1];
                }
                if (strlen($result['document']['ue']) > 64)  //fix escaped things
                {
                    $result['document']['ue'] = $this->strhex($this->unliteral(hex2str($result['document']['ue'])));
                }
                if (preg_match("/\/Perms[^\(]{0,5}\((.{16,32}?)\)/si", $encrypt_block, $matcho)) {
                    $result['document']['perms'] = $this->strhex($matcho[1]);
                } elseif (preg_match("/\/Perms[^\<]{0,5}\<(.{32}?)\>/si", $encrypt_block, $matcho)) {
                    $result['document']['perms'] = $matcho[1];
                }
                if (strlen($result['document']['perms']) > 32)  //fix escaped things
                {
                    $result['document']['perms'] = $this->strhex($this->unliteral(hex2str($result['document']['perms'])));
                }
                $result['document']['password'] = '';
                $result['document']['ue_key'] = hash('sha256', hex2bin($result['document']['password'] . substr($result['document']['u'], 80, 16)));
                $result['document']['key'] = '';
                $result['document']['test2'] = '';
                if (substr(hex2bin($result['document']['test2']), 9, 3) == "abd") {
                    $result['document']['aesv3'] = 1;
                } else {
                    $result['document']['aesv3'] = 0;
                }

                $key = $result['document']['key'];
            } else {
                $trimmed = rtrim($result['document']['u'], "0");
                if (strlen($trimmed) % 2 == 1) {
                    $trimmed .= "0";
                }
                $result['document']['password'] = str_pad($trimmed, 64, $result['document']['padding'], STR_PAD_RIGHT);
                $hashbuilder = $result['document']['password'];
                $hashbuilder .= $result['document']['o'];
                if ($result['document']['p'] < 0) {
                    $permissions = pow(2, 32) + ($result['document']['p']);
                } else {
                    $permissions = $result['document']['p'];
                }
                $result['document']['p_hexh'] = str_pad(dechex(pow(2, 32) - pow(2, 32) + $permissions), 8, 0, STR_PAD_LEFT);
                $result['document']['p_hex'] = $this->lowOrder($result['document']['p_hexh']);
                $result['document']['p_raw'] = $permissions;
                $result['document']['p_max'] = pow(2, 32);
                $result['document']['p_check'] = hexdec($result['document']['p_hexh']);
                $hashbuilder .= $result['document']['p_hex'];
                $hashbuilder .= $result['document']['id'];
                $result['document']['hashbuilder'] = $hashbuilder;
                $hash = md5(self::hex2bin($hashbuilder));
                if ($result['document']['r'] > 2) {
                    for ($i = 0; $i < 50; $i++) {
                        $partial = substr($hash, 0, $result['document']['key_length'] / 4);
                        $hash = md5(self::hex2bin($partial));
                    }
                }
                if ($result['document']['r'] > 2) {
                    $key = substr($hash, 0, $result['document']['key_length'] / 4);
                } else {
                    $key = substr($hash, 0, 10);
                }
                $result['document']['key'] = $key;
            }
        }
        unset($matches0);
        preg_match_all("/((\x0a|\x0d|\x20)(\d{1,4})[^\d]{1,3}(\d{1,2})\sobj|(\x0a|\x0d)(xref|trailer)(\x0a|\x0d))/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        $ordered = [];
        if (isset($matches0[1])) {
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $end = '';
                if (isset($matches0[0][$j + 1][1])) {
                    $end = $matches0[0][$j + 1][1] + 1;
                } else {
                    $end = strlen($data);
                }
                $dup_id = $matches0[0][$j][1] + 1;
                if (isset($matches0[6][$j][0]) && ($matches0[6][$j][0] == 'xref' || $matches0[6][$j][0] == 'trailer')) {
                    $start = $matches0[0][$j][1] + 1;
                    $len = ($end - $start);
                    $ordered[$dup_id] = [
                        'otype' => $matches0[6][$j][0],
                        'obj_id' => '0',
                        'gen_id' => '0',
                        'start' => $start,
                        'end' => $end,
                        'len' => $len,
                        'dup_id' => $dup_id,
                        'parameters' => substr($data, $start, $len)
                    ];
                } else {
                    $start = $matches0[4][$j][1] + strlen($matches0[4][$j][0]) + 4;
                    $len = ($end - $start);
                    $ordered[$dup_id] = [
                        'obj_id' => $matches0[3][$j][0],
                        'gen_id' => $matches0[4][$j][0],
                        'start' => $start,
                        'end' => $end,
                        'len' => $len,
                        'dup_id' => $dup_id,
                        'parameters' => substr($data, $start, $len)
                    ];
                }
            }
        }

        foreach ($ordered as $dup_id => $vals) {
            $index = $vals['obj_id'] . "." . $vals['gen_id'] . "." . $dup_id;
            $result[$index] = [
                'object' => $vals['obj_id'],
                'generation' => $vals['gen_id'],
                'obj_hex' => str_pad(dechex($vals['obj_id']), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($vals['gen_id']), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $vals['parameters'],
                'atype' => 'sas'
            ];
            if (isset($vals['otype'])) {
                $result[$index]['otype'] = $vals['otype'];
            }

            $result[$index]['decrypt_part'] = $this->lowOrder($result[$index]['obj_hex']) . $this->lowOrder($result[$index]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$index]['decrypt_part'] .= "73416C54";
            }
            if (isset($result['document']['key']) && $result['document']['key'] != '' && !isset($vals['otype'])) {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$index]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = decryptObj($result['document'], $result[$index], $key, $p);
                    if ($newParams != '') {
                        $result[$index]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$index]['parameters'];
                    }
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\x0a|\x0d|\x20)(\d{1,4})[^\d]{1,3}(\d{1,2})\sobj(.*?)endobj/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[1])) {
            $ordered = [];
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[2][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            if (!isset($result[$val[2] . "." . $val[3] . "." . $dup_id])) {
                $result[$val[2] . "." . $val[3] . "." . $dup_id] = [
                    'object' => $val[2],
                    'generation' => $val[3],
                    'obj_hex' => str_pad(dechex($val[2]), 6, 0, STR_PAD_LEFT),
                    'gen_hex' => str_pad(dechex($val[3]), 4, 0, STR_PAD_LEFT),
                    'dup_id' => $dup_id,
                    'parameters' => $val[4],
                    'atype' => 'nos'
                ];
                $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['gen_hex']);
                if ($result['document']['v'] >= 3) {
                    $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] .= "73416C54";
                }
                if (isset($result['document']['key']) && $result['document']['key'] != '') {
                    preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'], $param1);
                    for ($j = 0; $j < count($param1[1]); $j++) {
                        $p = $this->unliteral($param1[1][$j]);
                        $newParams = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $p);
                        if ($newParams != '') {
                            $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'];
                        }
                    }
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\x0a|\x0d|\x20)(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?! obj).){1,350}?)(s|#73)(t|#74)(r|#72)(e|#65)(a|#61)(m|#6d)(.*?)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            $ordered = [];
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[2][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $result[$val[2] . "." . $val[3] . "." . $dup_id] = [
                'object' => $val[2],
                'generation' => $val[3],
                'obj_hex' => str_pad(dechex($val[2]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[3]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[4],
                'atype' => 'alls'
            ];
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $d = trim($val[11], "\x0A\x0D");
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $d);
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5'] = md5(trim($t, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decoded'] = trim($t, "\x0A\x0D");
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['text'] = $this->getPDFText($t);
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\x0a|\x0d|\x20)(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?! obj).){1,350}?)(s|#73)(t|#74)(r|#72)(e|#65)(a|#61)(m|#6d)(.*?)(\x0a|\x0d)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            $ordered = [];
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[2][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $result[$val[2] . "." . $val[3] . "." . $dup_id] = [
                'object' => $val[2],
                'generation' => $val[3],
                'obj_hex' => str_pad(dechex($val[2]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[3]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[4],
                'atype' => 'alls'
            ];
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $d = trim($val[11], "\x0A\x0D");
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $d);
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5'] = md5(trim($t, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decoded'] = trim($t, "\x0A\x0D");
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['text'] = $this->getPDFText($t);
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\x0a|\x0d)(\d{1,4})[^\d]{1,3}(\d{1,2})\sobj((?:(?!\s+\d{1,2}\s+obj).){1,350}?)(#4a|J)(#53|S)[\s]{0,5}\((.+?)((\x0a|\x0d|>>))endobj/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            $ordered = [];
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[2][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $result[$val[2] . "." . $val[3] . "." . $dup_id] = [
                'object' => $val[2],
                'generation' => $val[3],
                'obj_hex' => str_pad(dechex($val[2]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[3]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[4],
                'atype' => 'js'
            ];
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $d = '';
            preg_match("/(.*)\)$/is", $val[7], $stream);
            if (isset($stream[1])) {
                $d = $stream[1];
            } else {
                $d = $val[7];
            }
            $d = $this->unliteral(trim($d, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $d);
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5'] = md5(trim($t, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decoded'] = trim($t, "\x0A\x0D");
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\x0a|\x0d|\x20)(\d{1,4})[^\d]{1,3}(\d{1,2})\sobj((?:(?!\s+\d{1,2}\s+obj).){1,350}?)(#4a|J)(#53|S)[\s]{0,5}\<(.*?)\>(\x20|\x0a|\x0d|>>|\)\/)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            $ordered = [];
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[2][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[2][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $result[$val[2] . "." . $val[3] . "." . $dup_id] = [
                'object' => $val[2],
                'generation' => $val[3],
                'obj_hex' => str_pad(dechex($val[2]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[3]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[4],
                'atype' => 'js'
            ];
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[2] . "." . $val[3] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[2] . "." . $val[3] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $d = trim($val[7], "\x0A\x0D");
            $d = $this->hexToString($d);
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $d);
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['md5'] = md5(trim($t, "\x0A\x0D"));
            $result[$val[2] . "." . $val[3] . "." . $dup_id]['decoded'] = trim($t, "\x0A\x0D");
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[2] . "." . $val[3] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[2] . "." . $val[3] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        unset($matches0);
        $ordered = [];
        preg_match_all("/(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?!\s+\d{1,2}\s+obj).){1,350}?)\/(F|#46)(i|#69)(l|#6c)(t|#74)(e|#65)(r|#72).{0,8}?\/(.{1,200}?)(.{0})(.{0})(.{0})(.{0})(.{0})(.{0})(.{0})>>(.*?)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[1][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[1][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        unset($matches0);
        $block_no = 0;
        preg_match_all("/(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?!\s+\d{1,2}\s+obj).){1,350}?)\/(F|#46)(i|#69)(l|#6c)(t|#74)(e|#65)(r|#72).{0,8}?\/(.{1,200}?)>>(.{0,100}?)(s|#73)(t|#74)(r|#72)(e|#65)(a|#61)(m|#6d)(.*?)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[1][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[1][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $block_no++;
            $master_block_encoding = $block_encoding;
            $filter_raw = $this->pdfhex($val[10]);
            $filters = preg_split("/( |\/)/si", trim($filter_raw), -1, PREG_SPLIT_NO_EMPTY);
            $predictor = '';
            if (preg_match("/\/Predictor ([\d]*)/si", $filter_raw, $matchpre)) {
                $predictor = $matchpre[1];
            }
            $colors = '';
            if (preg_match("/\/Colors ([\d]*)/si", $filter_raw, $matchcol)) {
                $colors = $matchcol[1];
            }
            $bitsPerComponent = '';
            if (preg_match("/\/BitsPerComponent ([\d]*)/si", $filter_raw, $matchbpc)) {
                $bitsPerComponent = $matchbpc[1];
            }
            $columns = '';
            if (preg_match("/\/Columns ([\d]*)/si", $filter_raw, $matchcl)) {
                $columns = $matchcl[1];
            }
            $field = 18;
            if (!isset($val[$field]) || $val[$field] == '') {
                continue;
            }
            $d = trim($val[$field], "\x0A\x0D");
            $result[$val[1] . "." . $val[2] . "." . $dup_id] = [
                'object' => $val[1],
                'generation' => $val[2],
                'obj_hex' => str_pad(dechex($val[1]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[2]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[3] . " " . $val[11] . "/Filter /$filter_raw",
                'atype' => 'single'
            ];
            if (strlen($val[10]) - 3 > strlen($this->pdfhex($val[10]))) {
                $obfuscation = 1;
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation'] = 1;
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation_raw'] = $val[10];
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation_decode'] = $this->pdfhex($val[10]);
            }

            $result[$val[1] . "." . $val[2] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[1] . "." . $val[2] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[1] . "." . $val[2] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[1] . "." . $val[2] . "." . $dup_id], $key, $d);
            $d = $t;
            if ($globalTest == 1) {
                echo "Found " . strlen($d) . " bytes of encoded data.\n";
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] = '';
            foreach ($filters as $filter) {
                if ($d == '') {
                    continue;
                }
                if (stripos($filter, 'ASCIIHexDecode') !== false || stripos($filter, 'AHx') !== false) {
                    $d = $this->asciihexdecode($d);
                    $master_block_encoding .= '-PA';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+ASCIIHexDecode";
                } elseif (stripos($filter, 'LZWDecode') !== false || stripos($filter, 'LZW') !== false) {
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+LZWDecode";
                    $master_block_encoding .= '-PL';
                } elseif (stripos($filter, 'ASCII85Decode') !== false || stripos($filter, 'A85') !== false) {
                    $d = $this->ascii85_decode($d);
                    $master_block_encoding .= '-P8';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+ASCII85Decode";
                } elseif (stripos($filter, 'CCITTFaxDecode') !== false || stripos($filter, 'CCF') !== false) {
                    $master_block_encoding .= '-CC';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+CCITTFaxDecode";
                } elseif (stripos($filter, 'DCTDecode') !== false || stripos($filter, 'DCT') !== false) {
                    if (extension_loaded('imagick')) {
                        $im = new Imagick();
                        $im->readImageBlob($d);
                        $im->setImageFormat("GRAY");
                        $d = "$im";
                        $master_block_encoding .= '-DC';
                        $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+DCTDecode";
                    } else {
                        log_message("error", "Warning: DCTDecode failed missing ImageMagick / Imagick module");
                    }
                } elseif (stripos($filter, 'RunLengthDecode') !== false || stripos($filter, 'RL') !== false) {
                    $d = $this->runlengthdecode($d);
                    $master_block_encoding .= '-PR';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+RunLengthDecode";
                } elseif (stripos($filter, 'flateDecode') !== false || stripos($filter, 'Fl') !== false) {
                    $master_block_encoding .= '-PF';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+flateDecode";
                    $t = $d;
                    for ($i = 0; $i <= 5; $i++) {
                        $d = substr($t, $i);
                        $d = $this->flateDecode($d);
                        if (strlen($d) > 4) {
                            break;
                        }
                    }
                    if ($globalTest == 1 && $d == '') {
                        log_message("error", "Warning: flateDecode failed .s");
                    }
                } else {
                    if ($globalTest == 1) {
                        echo "hi";
                    }
                }
            }
            if ($predictor > 0 && $colors > 0 && $bitsPerComponent > 0 && $columns > 0) {
                $d = $this->decodePredictor($d, $predictor, $colors, $bitsPerComponent, $columns);
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['decoded'] = $d;
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['md5'] = md5($d);
            if ($globalTest == 1) {
                echo "Found " . strlen($d) . " bytes of decoded data.\n";
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['text'] = $this->getPDFText($d);
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[1] . "." . $val[2] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        $master_block_encoding = $block_encoding;
        unset($matches0);
        $ordered = [];
        $flagJS = 0;
        preg_match_all("/(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?! obj).){1,300}?)\/(F|#46)(i|#69)(l|#6c)(t|#74)(e|#65)(r|#72).{0,8}?\[(.{1,200}?)\](.{0,300}?)>>(.{0})(.{0})(.{0})(.{0})(.{0})(.{0})(.*?)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[1][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[1][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        unset($matches0);
        preg_match_all("/(\d{1,4})[^\d]{1,3}(\d{1,2})\s+obj((?:(?! obj).){1,300}?)\/(F|#46)(i|#69)(l|#6c)(t|#74)(e|#65)(r|#72).{0,8}?\[(.{1,200}?)\](.{1,300}?)(s|#73)(t|#74)(r|#72)(e|#65)(a|#61)(m|#6d)(.*?)(e|#65)(n|#6e)(d|#64)(s|#73|o|#6f)/si", $data, $matches0, PREG_OFFSET_CAPTURE);
        if (isset($matches0[0])) {
            for ($j = 0; $j < count($matches0[0]); $j++) {
                $ordered[$matches0[1][$j][1]] = [];
                for ($i = 1; $i < count($matches0); $i++) {
                    $ordered[$matches0[1][$j][1]][$i] = $matches0[$i][$j][0];
                }
            }
        }
        foreach ($ordered as $dup_id => $val) {
            $master_block_encoding = $block_encoding;
            $filter_raw = $this->pdfhex($val[10]);
            $filter_raw2 = $this->pdfhex($val[11]);
            $filters = preg_split("/( |\/)/si", trim($filter_raw), -1, PREG_SPLIT_NO_EMPTY);
            $predictor = '';
            if (preg_match("/\/Predictor ([\d]*)/si", $filter_raw2, $matchpre)) {
                $predictor = $matchpre[1];
            }

            $colors = '';
            if (preg_match("/\/Colors ([\d]*)/si", $filter_raw2, $matchcol)) {
                $colors = $matchcol[1];
            }

            $bitsPerComponent = '';
            if (preg_match("/\/BitsPerComponent ([\d]*)/si", $filter_raw2, $matchbpc)) {
                $bitsPerComponent = $matchbpc[1];
            }
            $columns = '';
            if (preg_match("/\/Columns ([\d]*)/si", $filter_raw2, $matchcl)) {
                $columns = $matchcl[1];
            }
            $field = 18;
            if (!isset($val[$field]) || $val[$field] == '') {
                continue;
            }

            $d = trim($val[$field], "\x0A\x0D");
            $result[$val[1] . "." . $val[2] . "." . $dup_id] = [
                'object' => $val[1],
                'generation' => $val[2],
                'obj_hex' => str_pad(dechex($val[1]), 6, 0, STR_PAD_LEFT),
                'gen_hex' => str_pad(dechex($val[2]), 4, 0, STR_PAD_LEFT),
                'dup_id' => $dup_id,
                'parameters' => $val[3] . " " . "/Filter /$filter_raw " . $val[11],
                'atype' => 'multiple'
            ];
            if (strlen($val[10]) - 3 > strlen($this->pdfhex($val[10]))) {
                $obfuscation = 1;
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation'] = 1;
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation_raw'] = $val[10];
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['obfuscation_decode'] = $this->pdfhex($val[10]);
            }


            $result[$val[1] . "." . $val[2] . "." . $dup_id]['decrypt_part'] = $this->lowOrder($result[$val[1] . "." . $val[2] . "." . $dup_id]['obj_hex']) . $this->lowOrder($result[$val[1] . "." . $val[2] . "." . $dup_id]['gen_hex']);
            if ($result['document']['v'] >= 3) {
                $result[$val[1] . "." . $val[2] . "." . $dup_id]['decrypt_part'] .= "73416C54";
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['md5_raw'] = md5(trim($d, "\x0A\x0D"));
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['stream'] = trim($d, "\x0A\x0D");
            $t = $this->decryptObj($result['document'], $result[$val[1] . "." . $val[2] . "." . $dup_id], $key, $d);
            $d = $t;
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] = '';
            foreach ($filters as $filter) {
                if ($d == '') {
                    continue;
                }

                if (stripos($filter, 'ASCIIHexDecode') !== false || stripos($filter, 'AHx') !== false) {
                    $d = $this->asciihexdecode($d);
                    $master_block_encoding .= '-PA';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+ASCIIHexDecode";
                } elseif (stripos($filter, 'LZWDecode') !== false || stripos($filter, 'LZW') !== false) {
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+LZWDecode";
                    $master_block_encoding .= '-PL';
                } elseif (stripos($filter, 'ASCII85Decode') !== false || stripos($filter, 'A85') !== false) {
                    $d = $this->ascii85_decode($d);
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+ASCII85Decode";
                    $master_block_encoding .= '-P8';
                } elseif (stripos($filter, 'CCITTFaxDecode') !== false || stripos($filter, 'CCF') !== false) {
                    $master_block_encoding .= '-CC';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+CCITTFaxDecode";
                } elseif (stripos($filter, 'DCTDecode') !== false || stripos($filter, 'DCT') !== false) {
                    if (extension_loaded('imagick')) {
                        $im = new Imagick();
                        $im->readImageBlob($d);
                        $im->setImageFormat("GRAY");
                        $d = "$im";
                        $master_block_encoding .= '-DC';
                        $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+DCTDecode";
                    } else {
                        log_message("error", "Warning: DCTDecode failed missing ImageMagick / Imagick module");
                    }
                } elseif (stripos($filter, 'RunLengthDecode') !== false || stripos($filter, 'RL') !== false) {
                    $d = $this->runlengthdecode($d);
                    $master_block_encoding .= '-PR';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+RunLengthDecode";
                } elseif (stripos($filter, 'flateDecode') !== false || stripos($filter, 'Fl') !== false) {
                    $master_block_encoding .= '-PF';
                    $result[$val[1] . "." . $val[2] . "." . $dup_id]['filter'] .= "+flateDecode";
                    $t = $d;
                    for ($i = 0; $i <= 5; $i++) {
                        $d = substr($t, $i);
                        $d = $this->flateDecode($d);
                        if ($d != '') {
                            break;
                        }
                    }
                    if ($globalTest == 1 && $d == '') {
                        log_message("error", "Warning: flateDecode failed .m");
                    }
                } else {
                    log_message("error", "Unknown filter" . $filter);
                }
            }
            if ($predictor > 0 && $colors > 0 && $bitsPerComponent > 0 && $columns > 0) {
                $d = $this->decodePredictor($d, $predictor, $colors, $bitsPerComponent, $columns);
            }
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['decoded'] = $d;
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['md5'] = md5($d);
            $result[$val[1] . "." . $val[2] . "." . $dup_id]['text'] = $this->getPDFText($d);
            if (isset($result['document']['key']) && $result['document']['key'] != '') {
                preg_match_all("/\((.*?)\)(\x0a|\x0d)/s", $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'], $param1);
                for ($j = 0; $j < count($param1[1]); $j++) {
                    $p = $this->unliteral($param1[1][$j]);
                    $newParams = $this->decryptObj($result['document'], $result[$val[1] . "." . $val[2] . "." . $dup_id], $key, $p);
                    if ($newParams != '') {
                        $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'] = $newParams . "\n[encrypted params:]" . $result[$val[1] . "." . $val[2] . "." . $dup_id]['parameters'];
                    }
                }
            }
        }
        $master_block_encoding = $block_encoding;
        return $result;
    }

    private function getPDFText($data)
    {
        $result = '';
        if (preg_match_all('/\(([^\)]+)\)/', $data, $matches)) {
            $result .= join('', $matches[1]);
        }
        return $this->unliteral($result);
    }

    private function decodePredictor($data, $predictor, $colors, $bitsPerComponent, $columns)
    {
        if (
            $predictor == 10 ||  //No prediction
            $predictor == 11 ||  //Sub prediction
            $predictor == 12 ||  //Up prediction
            $predictor == 13 ||  //Average prediction
            $predictor == 14 ||  //Paeth prediction
            $predictor == 15    //Optimal prediction
        ) {
            $bitsPerSample = $bitsPerComponent * $colors;
            $bytesPerSample = ceil($bitsPerSample / 8);
            $bytesPerRow = ceil($bitsPerSample * $columns / 8);
            $rows = ceil(strlen($data) / ($bytesPerRow + 1));
            $output = '';
            $offset = 0;

            $lastRow = array_fill(0, $bytesPerRow, 0);
            for ($count = 0; $count < $rows; $count++) {
                $lastSample = array_fill(0, $bytesPerSample, 0);
                switch (ord($data[$offset++])) {
                    case 0: // None of prediction
                        $output .= substr($data, $offset, $bytesPerRow);
                        for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) {
                            $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = ord($data[$offset++]);
                        }
                        break;

                    case 1: // Sub prediction
                        for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) {
                            $decodedByte = (ord($data[$offset++]) + $lastSample[$count2 % $bytesPerSample]) & 0xFF;
                            $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte;
                            $output .= chr($decodedByte);
                        }
                        break;

                    case 2: // Up prediction
                        for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) {
                            $decodedByte = (ord($data[$offset++]) + $lastRow[$count2]) & 0xFF;
                            $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte;
                            $output .= chr($decodedByte);
                        }
                        break;

                    case 3: // Average prediction
                        for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) {
                            $decodedByte = (ord($data[$offset++]) +
                                    floor(($lastSample[$count2 % $bytesPerSample] + $lastRow[$count2]) / 2)
                                ) & 0xFF;
                            $lastSample[$count2 % $bytesPerSample] = $lastRow[$count2] = $decodedByte;
                            $output .= chr($decodedByte);
                        }
                        break;

                    case 4: // Paeth prediction
                        $currentRow = [];
                        for ($count2 = 0; $count2 < $bytesPerRow && $offset < strlen($data); $count2++) {
                            $decodedByte = (ord($data[$offset++]) +
                                    $this->paeth(
                                        $lastSample[$count2 % $bytesPerSample],
                                        $lastRow[$count2],
                                        ($count2 - $bytesPerSample < 0) ?
                                            0 : $lastRow[$count2 - $bytesPerSample]
                                    )
                                ) & 0xFF;
                            $lastSample[$count2 % $bytesPerSample] = $currentRow[$count2] = $decodedByte;
                            $output .= chr($decodedByte);
                        }
                        $lastRow = $currentRow;
                        break;

                    default:
                        die('Unknown prediction tag.');
                }
            }
            return $output;
        }
    }


    private function paeth($a, $b, $c)
    {
        $p = $a + $b - $c; // initial estimate
        $pa = abs($p - $a); // distances to a, b, c
        $pb = abs($p - $b);
        $pc = abs($p - $c);
        if ($pa <= $pb && $pa <= $pc) {
            return $a;
        } elseif ($pb <= $pc) {
            return $b;
        } else {
            return $c;
        }
    }

    private function checkBlockHash($md5)
    {
        global $PDFblockHash;
        $malware['found'] = 0;
        if (isset($PDFblockHash[$md5])) {
            $malware[$md5 . uniqid('', true)] = [
                'searchtype' => 'block',
                'matching' => 'full',
                'keylength' => 0,
                'key' => 0,
                'search' => $md5,
                'location' => 0,
                'top' => 0,
                'keycount' => 0,
                'keylocation' => 0,
                'keyaccuracy' => 0,
                'searcherrors' => 0,
                'virustype' => $PDFblockHash[$md5],
                'rawlocation' => 0,
                'rawblock' => '',
                'block' => '',
                'block_type' => '',
                'rawclean' => '',
                'keysum' => ''
            ];
            $malware['found'] = 1;
        }
        return $malware;
    }

    private function reghex2str($hex)
    {
        $str = '';
        for ($i = 0; $i < strlen($hex); $i++) {
            if ($i + 3 <= strlen($hex) && $hex[$i] == '\\' && $hex[$i + 1] == 'x' && ctype_alnum($hex[$i + 2]) && ctype_alnum($hex[$i + 3])) {
                $n = $hex[$i + 2] . $hex[$i + 3];
                $str .= @chr(hexdec($n));
                $i += 3;
            } else {
                $str .= $hex[$i];
            }
        }
        return $str;
    }

    private function jsascii2str($hex)
    {
        $str = '';
        for ($i = 0; $i < strlen($hex); $i++) {
            $hexOne = isset($hex[$i + 1]) ?? '';
            $hexTwo = isset($hex[$i + 2]) ?? '';
            $hexThree = isset($hex[$i + 3]) ?? '';
            if ($i + 3 <= strlen($hex) && $hex[$i] == '\\' && ctype_alnum($hexOne) && ctype_alnum($hexTwo) && ctype_alnum($hexThree)) {
                $n = $hex[$i + 1] . $hex[$i + 2] . $hex[$i + 3];
                $str .= chr((int)$n);
                $i += 3;
            } elseif ($i + 3 <= strlen($hex) && $hex[$i] == '\\' && ctype_alnum($hexOne) && ctype_alnum($hexTwo)) {
                $n = $hex[$i + 1] . $hex[$i + 2];
                $str .= chr((int)$n);
                $i += 2;
            } elseif ($i + 2 <= strlen($hex) && $hex[$i] == '\\' && ctype_alnum($hexOne)) {
                $n = $hex[$i + 1];
                $str .= chr((int)$n);
                $i += 1;
            } else {
                $str .= $hex[$i];
            }
        }
        return $str;
    }

    private function javascriptScanEscaped($malware, $dec, $stringSearch, $hexSearch)
    {
        global $globalBlockEncoding;
        $isJs = 0;
        $block_encoding = $globalBlockEncoding;
        if (strlen($dec) > 100) {
            $decAlt = $dec;
            $tiff = 0;
            if (stristr($this->strhex(substr($dec, 0, 4)), "49492a00")) {
                $decAlt = substr($dec, 4);
                $tiff = 1;
            }
            $shellcode = $this->detectShellcodePlain($decAlt);

            if ($shellcode == 'SHELLCODE DETECTED') {
                $l = 0;
                if ($tiff == 0) {
                    $malware["shellcode $l" . uniqid('', true)] = [
                        'searchtype' => 'shellcodePDF',
                        'matching' => 'full',
                        'keylength' => 0,
                        'key' => '',
                        'search' => 'shellcode',
                        'location' => $l,
                        'top' => 0,
                        'keycount' => 0,
                        'keysum' => '',
                        'keylocation' => 0,
                        'keyaccuracy' => 0,
                        'searcherrors' => 0,
                        'virustype' => "pdf.shellcode detected",
                        'block' => $this->strhex($decAlt),
                        'block_is_decoded' => 1,
                        'block_encoding' => 'hex',
                        'block_size' => strlen($decAlt),
                        'block_type' => 'shellcode-hex',
                        'block_md5' => md5($decAlt),
                        'block_sha1' => sha1($decAlt),
                        'block_sha256' => hash('sha256', $decAlt),
                        'rawlocation' => 0,
                        'rawblock' => $decAlt,
                        'rawclean' => ''
                    ];
                } else {
                    $malware["pdfshelltiff" . uniqid('', true)] = [
                        'searchtype' => 'pdfexploit',
                        'matching' => 'full',
                        'keylength' => 0,
                        'key' => '',
                        'search' => 'pdfshelltiff',
                        'location' => $l,
                        'top' => 0,
                        'keycount' => 0,
                        'keylocation' => 0,
                        'keyaccuracy' => 0,
                        'searcherrors' => 0,
                        'virustype' => "pdf.exploit base 64 shellcode in TIFF CVE-2010-0188",
                        'block' => $this->strhex($decAlt),
                        'block_is_decoded' => 1,
                        'block_encoding' => 'hex',
                        'block_size' => strlen($decAlt),
                        'block_type' => 'shellcode-hex',
                        'block_md5' => md5($decAlt),
                        'block_sha1' => sha1($decAlt),
                        'block_sha256' => hash('sha256', $decAlt),
                        'rawlocation' => 0,
                        'rawblock' => $decAlt,
                        'rawclean' => ''
                    ];
                }
                $malware['found'] = 1;
                $malware['shellcode'] = 1;
                $malware['shellcodedump'] = $this->strhex($decAlt);
            }
        }
        foreach ($hexSearch as $pattern => $name) {
            if ($l = stripos($dec, $this->hexToString($pattern))) {
                $rawstart = $l - 64;
                if ($rawstart < 0) {
                    $rawstart = 0;
                }
                $malware[$pattern . uniqid('', true)] = [
                    'searchtype' => 'pdfexploit',
                    'matching' => 'full',
                    'keylength' => 0,
                    'key' => '',
                    'search' => $pattern,
                    'location' => $l,
                    'top' => 0,
                    'keycount' => 0,
                    'keylocation' => 0,
                    'keyaccuracy' => 0,
                    'searcherrors' => 0,
                    'virustype' => $name,
                    'block' => $this->strhex($dec),
                    'keysum' => '',
                    'block_size' => strlen($dec),
                    'block_type' => 'javascript-shellcode',
                    'block_md5' => md5($dec),
                    'block_sha1' => sha1($dec),
                    'block_sha256' => hash('sha256', $dec),
                    'block_encoding' => $globalBlockEncoding,
                    'rawlocation' => $rawstart,
                    'rawblock' => substr($dec, $rawstart, 64 * 2 + strlen($this->hexToString($pattern))),
                    'rawclean' => ''
                ];

                $malware['found'] = 1;
                $isJs = 1;
                $malware['shellcode'] = $l;
                $malware['shellcodedump'] = $this->strhex($dec);
            }
        }
        foreach ($stringSearch as $pattern => $name) {
            if (stristr($pattern, '?') || stristr($pattern, "\x28")) {
                preg_match("/$pattern/is", $dec, $matches, PREG_OFFSET_CAPTURE);
                if (isset($matches['0']['0'])) {
                    $l = $matches['0']['1'];
                    $rawstart = $l - 64;
                    if ($rawstart < 0) {
                        $rawstart = 0;
                    }
                    $malware[$pattern . uniqid('', true)] = [
                        'searchtype' => 'pdfexploit',
                        'matching' => 'full',
                        'keylength' => 0,
                        'key' => '',
                        'search' => $pattern,
                        'location' => $l,
                        'top' => 0,
                        'keycount' => 0,
                        'keylocation' => 0,
                        'keyaccuracy' => 0,
                        'searcherrors' => 0,
                        'virustype' => $name,
                        'block' => $dec,
                        'keysum' => '',
                        'block_size' => strlen($dec),
                        'block_type' => 'javascript',
                        'block_md5' => md5($dec),
                        'block_sha1' => sha1($dec),
                        'block_sha256' => hash('sha256', $dec),
                        'block_encoding' => $globalBlockEncoding,
                        'rawlocation' => $rawstart,
                        'rawblock' => substr($dec, $rawstart, 64 * 2 + strlen($pattern)),
                        'rawclean' => ''
                    ];
                    $malware['found'] = 1;
                    $isJs = 1;
                }
            } elseif ($l = stripos($dec, $pattern)) {
                $rawstart = $l - 64;
                if ($rawstart < 0) {
                    $rawstart = 0;
                }
                $malware[$pattern . uniqid('', true)] = [
                    'searchtype' => 'pdfexploit',
                    'matching' => 'full',
                    'keylength' => 0,
                    'key' => '',
                    'keysum' => '',
                    'search' => $pattern,
                    'location' => $l,
                    'top' => 0,
                    'keycount' => 0,
                    'keylocation' => 0,
                    'keyaccuracy' => 0,
                    'searcherrors' => 0,
                    'virustype' => $name,
                    'block' => $dec,
                    'block_size' => strlen($dec),
                    'block_type' => 'javascript',
                    'block_md5' => md5($dec),
                    'block_sha1' => sha1($dec),
                    'block_sha256' => hash('sha256', $dec),
                    'block_encoding' => $globalBlockEncoding,
                    'rawlocation' => $rawstart,
                    'rawblock' => substr($dec, $rawstart, 64 * 2 + strlen($pattern)),
                    'rawclean' => ''
                ];
                $malware['found'] = 1;
                $isJs = 1;
            }
        }
        preg_match_all("/\"(.{1,9600}?)\"/is", $dec, $matches2, PREG_SET_ORDER);
        foreach ($matches2 as $encoded) {
            $globalBlockEncoding = $block_encoding;
            $strings = $this->reghex2str($encoded[1]);
            $globalBlockEncoding .= '-RH';
            $strings = $this->jsascii2str($strings);
            $globalBlockEncoding .= '-JA';
            $globalBlockEncoding .= '-UC';
            if ($strings == 0x0000) {
                if ($this->isBase64($encoded[1]) && strlen($encoded[1]) > 100) {
                    $globalBlockEncoding = $block_encoding . "-64";
                    $strings = base64_decode($encoded[1]);
                    if ($strings != "") {
                        $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                    }
                }
            } else {
                $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
            }
        }
        preg_match_all("/'(.{1,9600}?)'/is", $dec, $matches2, PREG_SET_ORDER);
        foreach ($matches2 as $encoded) {
            $globalBlockEncoding = $block_encoding;
            $strings = $this->reghex2str($encoded[1]);
            $globalBlockEncoding .= '-RH';
            $strings = $this->jsascii2str($strings);
            $globalBlockEncoding .= '-JA';
            $globalBlockEncoding .= '-UC';
            if ($strings == 0x0000) {
                //logVerbose("invalid escaped string\n".$encoded[1]."\n");
                if ($this->isBase64($encoded[1]) && strlen($encoded[1]) > 100) {
                    //logVerbose("string is base 64 encoded, testing for shellcode\n");
                    $globalBlockEncoding = $block_encoding . "-64";
                    $strings = base64_decode($encoded[1]);
                    if ($strings != "") {
                        $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                    }
                }
            } else {
                $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
            }
        }
        preg_match_all("/fromCharCode.{0,2}?\((.*?)\)/is", $dec, $matches2, PREG_SET_ORDER);
        foreach ($matches2 as $encoded) {
            $globalBlockEncoding = $block_encoding;
            echo "need to decode " . $encoded[1] . "\n";
            $strings = ($encoded[1]);
            $globalBlockEncoding .= '-CF';
            $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
        }
        $globalBlockEncoding = $block_encoding;
        return $malware;
    }

    private function parseObjStm($params, $stream)
    {
        $n = 0;
        $out = [];
        if (preg_match("/(#4E|N)\s+(\d+)/s", $params, $res)) {
            $n = $res[2];
        }
        $first = 0;
        if (preg_match("/(#46|F)(#69|i)(#72|r)(#73|s)(#74|t)\s+(\d+)/s", $params, $res2)) {
            $first = $res2[6];
        }
        $header = substr($stream, 0, $first - 1);
        preg_match_all("/(\d+)\s+(\d+)/s", $header, $resh);
        if (isset($resh[1])) {
            for ($i = 0; $i < count($resh[1]); $i++) {
                if ($i + 1 >= count($resh[1])) {
                    $end = strlen($stream);
                } else {
                    $end = $resh[2][$i + 1] + $first - 1;
                }
                $ident = $resh[1][$i] . ".0." . ($resh[2][$i] + $first);
                $out[$ident] = ['object' => $resh[1][$i], 'generation' => '0', 'obj_id' => $resh[1][$i], 'gen_id' => '0', 'dup_id' => ($resh[2][$i] + $first)];
                $out[$ident]['parameters'] = substr($stream, $resh[2][$i] + $first, $end - $resh[2][$i] - $first);
            }
        }
        return $out;
    }

    private function javascriptScan($malware, $dec, $stringSearch, $hexSearch): array
    {
        global $globalBlockEncoding;
        $block_encoding = $globalBlockEncoding;
        if (strlen($dec) < 10000000) {
            $stringsFixed = $this->reghex2str($dec);
        } else {
            $stringsFixed = $dec;
        }
        if ($dec != $stringsFixed) {
            $globalBlockEncoding .= '-RH';
        }
        foreach ($stringSearch as $pattern => $name) {
            if (stristr($pattern, '?') || strstr($pattern, "\x28")) {
                preg_match("/$pattern/is", $stringsFixed, $matches, PREG_OFFSET_CAPTURE);
                if (isset($matches['0']['0'])) {
                    $l = $matches['0']['1'];
                    $rawstart = $l - 64;
                    if ($rawstart < 0) {
                        $rawstart = 0;
                    }
                    $malware[$pattern . uniqid('', true)] = [
                        'searchtype' => 'pdfexploit',
                        'matching' => 'full',
                        'keylength' => 0,
                        'key' => '',
                        'search' => $pattern,
                        'location' => $l,
                        'top' => 0,
                        'keycount' => 0,
                        'keysum' => '',
                        'keylocation' => 0,
                        'keyaccuracy' => 0,
                        'searcherrors' => 0,
                        'virustype' => $name,
                        'block' => $stringsFixed,
                        'block_is_decoded' => 1,
                        'block_size' => strlen($stringsFixed),
                        'block_type' => 'javascript',
                        'block_md5' => md5($stringsFixed),
                        'block_sha1' => sha1($stringsFixed),
                        'block_sha256' => hash('sha256', $stringsFixed),
                        'block_encoding' => $globalBlockEncoding,
                        'rawlocation' => $rawstart,
                        'rawblock' => substr($stringsFixed, $rawstart, 64 * 2 + strlen($pattern)),
                        'rawclean' => ''
                    ];
                    $malware['found'] = 1;
                }
            } elseif ($l = stripos($stringsFixed, $pattern)) {
                $rawstart = $l - 64;
                if ($rawstart < 0) {
                    $rawstart = 0;
                }
                $malware[$pattern . uniqid('', true)] = [
                    'searchtype' => 'pdfexploit',
                    'matching' => 'full',
                    'keylength' => 0,
                    'key' => '',
                    'keysum' => '',
                    'search' => $pattern,
                    'location' => $l,
                    'top' => 0,
                    'keycount' => 0,
                    'keylocation' => 0,
                    'keyaccuracy' => 0,
                    'searcherrors' => 0,
                    'virustype' => $name,
                    'block' => $stringsFixed,
                    'block_is_decoded' => 1,
                    'block_size' => strlen($stringsFixed),
                    'block_type' => 'javascript',
                    'block_md5' => md5($stringsFixed),
                    'block_sha1' => sha1($stringsFixed),
                    'block_sha256' => hash('sha256', $stringsFixed),
                    'block_encoding' => $globalBlockEncoding,
                    'rawlocation' => $rawstart,
                    'rawblock' => substr($stringsFixed, $rawstart, 64 * 2 + strlen($pattern)),
                    'rawclean' => ''
                ];
                $malware['found'] = 1;
            }
        }
        if (strlen($dec) < 10000000) {
            preg_match_all("/\"(.{1,32000}?)\"/is", $stringsFixed, $matches2, PREG_SET_ORDER);
            foreach ($matches2 as $encoded) {
                $globalBlockEncoding = $block_encoding;
                if ($dec != $stringsFixed) {
                    $globalBlockEncoding .= '-RH';
                }
                $globalBlockEncoding .= '-ES';
                $strings = $this->jsascii2str($encoded[1]);
                $globalBlockEncoding .= '-JA';
                $globalBlockEncoding .= '-UC';
                if ($strings == 0x0000) {
                    if ($this->isBase64($encoded[1]) && strlen($encoded[1]) > 100) {
                        $globalBlockEncoding = $block_encoding . "-64";
                        $strings = base64_decode($encoded[1]);
                        if ($strings != "") {
                            $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                        }
                    }
                } else {
                    $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                }
            }
            preg_match_all("/'(.{1,32000}?)'/is", $stringsFixed, $matches2, PREG_SET_ORDER);
            foreach ($matches2 as $encoded) {
                $globalBlockEncoding = $block_encoding;
                if ($dec != $stringsFixed) {
                    $globalBlockEncoding .= '-RH';
                }
                $globalBlockEncoding .= '-ES';
                $strings = $this->jsascii2str($encoded[1]);
                $globalBlockEncoding .= '-JA';
                $globalBlockEncoding .= '-UC';
                if ($strings == 0x0000) {
                    if ($this->isBase64($encoded[1]) && strlen($encoded[1]) > 100) {
                        $globalBlockEncoding = $block_encoding . "-64";
                        $strings = base64_decode($encoded[1]);
                        if ($strings != "") {
                            $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                        }
                    }
                } else {
                    $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                }
            }
            preg_match_all("/\>(.*?)\</is", $stringsFixed, $matches2, PREG_SET_ORDER);
            foreach ($matches2 as $encoded) {
                $globalBlockEncoding = $block_encoding;
                if ($this->isBase64($encoded[1]) && strlen($encoded[1]) > 100) {
                    $globalBlockEncoding = $block_encoding . "-64";
                    $strings = base64_decode($encoded[1]);
                    if ($strings != "") {
                        $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
                    }
                }
            }
            preg_match_all("/fromCharCode.{0,2}?\((.*?)\)/is", $stringsFixed, $matches2, PREG_SET_ORDER);
            foreach ($matches2 as $encoded) {
                $globalBlockEncoding = $block_encoding;
                if ($dec != $stringsFixed) {
                    $globalBlockEncoding .= '-RH';
                }
                $strings = @code2str($encoded[1]);
                $globalBlockEncoding .= '-CF';
                $this->javascriptScanEscaped($malware, $strings, $stringSearch, $hexSearch);
            }
            unset($stringsFixed);
        }
        $globalBlockEncoding = $block_encoding;
        return $malware;
    }


    private function findHiddenJS(string $string): string
    {
        if (ctype_print($string)) {
            $newstring = '';
            $tmp = '';
            $data = '';
            for ($i = 0; $i < strlen($string); $i++) {
                if (ctype_xdigit($string[$i])) {
                    $tmp .= $string[$i];
                } else {
                    if (strlen($tmp) == 4) {
                        $data .= chr(hexdec($tmp[2] . $tmp[3])) . chr(hexdec($tmp[0] . $tmp[1]));
                        $tmp = '';
                    } else {
                        $ascii = base_convert($tmp, 16, 10);
                        if(is_numeric($ascii)){
                            $data .= chr((int)$ascii);
                        }
                        $tmp = '';
                    }
                }
            }
            return $data;
        }
        return $string;
    }

    private function decodeReplace(string $string): string
    {
        return preg_replace("/([A-Z])/", '%', $string);
    }

    private function scanStreams($result, $obj, $gen)
    {
        foreach ($result as $unique => $data) {
            if (isset($data['objstm']) && $data['objstm'] > 0) {
                if ((preg_match("/\/(#4a|J)(#61|a)(#76|v)(#61|a)(#53|S)(#63|c)(#72|r)(#69|i)(#70#p)(#74|t)\s+" . $obj . "\s+" . $gen . "\s+R/si", $data['parameters']) || preg_match("/\/(#4a|J)(#53|S)\s+" . $obj . "\s+" . $gen . "\s+R/s", $data['parameters']))) {
                    return 1;
                }
            }
        }
        return 0;
    }

    private function isBase64($data): int
    {
        if (preg_match('/^[A-Za-z=\/\+]+$/s', trim($data))) {
            ;
        }
        {
            return 1;
        }
        return 0;
    }

    private function isJs($string)
    {
        $str = $string;
        $level = 0;
        $arr = explode(";\n", $str);
        $str = '';
        foreach ($arr as $line) {
            $line = trim($line);
            if (strstr($line, '=') && strstr($line, 'var ')) {
                $level++;
            } elseif (preg_match("/function(\s*?)([a-zA-Z0-9_-]*?)(\s{0,25}?)\(/i", $line)) {
                $level++;
            } elseif (preg_match("/return /i", $line)) {
                $level++;
            } elseif (preg_match("/try(\s*?)\{/i", $line)) {
                $level++;
            } elseif (preg_match("/catch(\s*?)\{/i", $line)) {
                $level++;
            } elseif (preg_match("/replace(\s{0,3}?)\(/i", $line)) {
                $level++;
            } elseif (preg_match("/new Array/", $line)) {
                $level++;
            } elseif (preg_match("/new Object/", $line)) {
                $level++;
            } elseif (preg_match("/new String(\s{0,3}?)\(/", $line)) {
                $level++;
            } elseif (preg_match("/charAt(\s{0,3}?)\(/", $line)) {
                $level++;
            } elseif (preg_match("/^([a-zA-Z0-9_-]+?)=([a-zA-Z0-9_-]+?);$/", $line)) {
                $level++;
            } elseif (preg_match("/substr(\s{0,3}?)\(/", $line)) {
                $level++;
            } elseif (preg_match("/app.viewerVersion/", $line)) {
                $level++;
            }
        }
        return $level;
    }

    private function hexToString($hex)
    {
        $str = '';
        for ($i = 0; $i < strlen($hex); $i += 2) {
            $str .= chr(hexdec(substr($hex, $i, 2)));
        }
        return $str;
    }

    private function detectShellcodePlain($data): string
    {
        global $global_libemu, $malwaredir;
        $filename = $malwaredir . "shell_" . uniqid();
        $fp = fopen($filename, "w");
        fwrite($fp, $data);
        fclose($fp);
        $le = explode(';', $global_libemu);
        $shellcode_scan = '';
        if (isset($le[2]) && is_executable($le[2])) {
            $shellcode_scan = exec("$global_libemu " . escapeshellarg($filename));
        }
        unlink($filename);
        if (strstr($shellcode_scan, 'SHELLCODE DETECTED')) {
            return "SHELLCODE DETECTED";
        }
        return "not found";
    }

}
