<!doctype html>
<html>

<head>
    <title>ELOGOTMSTSRWB</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php $assets_url = base_url('assets/ELOGOTMSTSRWB'); ?>
    <!-- CSS -->
    <link rel="icon" type="image/png" href="<?= $assets_url . '/img/favicon.ico' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/bootstrap.min.css' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/magnific-popup.css' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/animate.css' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/flaticon.css' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/meanmenu.css' ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/style.css?v=' . time() ?>">
    <link rel="stylesheet" href="<?= $assets_url . '/css/responsive.css' ?>">
    <



    <!-- JS -->
    <script src="<?= $assets_url . '/js/jquery.min.js' ?>"></script>
    <script src="<?= $assets_url . '/js/popper.min.js' ?>"></script>
    <script src="<?= $assets_url . '/js/bootstrap.min.js' ?>"></script>
    <script src="<?= $assets_url . '/js/jquery.meanmenu.js' ?>"></script>
    <script src="<?= $assets_url . '/js/jquery.magnific-popup.min.js' ?>"></script>
    <script src="<?= $assets_url . '/js/main.js' ?>"></script>
    <script src="<?= $assets_url . '/js/custom.js?v=' . time() ?>"></script>
    <script src="<?= $assets_url . '/js/jsQR.js' ?>"></script>
    
</head>


<body>
    
    <?php 
    if (isset($OrderRelease)) {
        $format = 'Y-m-d\TH:i:s.uP';
        //log_message("error","orderReleaseData:".json_encode($OrderRelease));
        $bookingId = $OrderRelease['orderReleaseXid'] ?? '';
        $sourceLocationGid = '';
        if (isset($OrderRelease['sourceLocationGid'])) {
            $sourceLocationParts = explode('.', $OrderRelease['sourceLocationGid']);
            $sourceLocationGid = end($sourceLocationParts);
        }
        $destLocationGid = '';
        if (isset($OrderRelease['destLocationGid'])) {
            $destLocationParts = explode('.', $OrderRelease['destLocationGid']);
            $destLocationGid = end($destLocationParts);
        }
        $totalItemPackageCount = $OrderRelease['totalItemPackageCount'] ?? '';
        $totalWeightValue = $OrderRelease['totalWeight']['value'] ?? '';
        $totalWeightUomCode = $OrderRelease['totalWeight']['uomCode'] ?? '';
        $totalVolumeValue = $OrderRelease['totalVolume']['value'] || '';
        $totalVolumeUomCode = $OrderRelease['totalVolume']['uomCode'] ?? '';
        $cargoDetails = $totalItemPackageCount . ' :   ' . $totalWeightValue . ' ' . $totalWeightUomCode . ' :   ' . $totalVolumeValue . ' ' . $totalVolumeUomCode;
        $earlyPickupDate = $OrderRelease['earlyPickupDate'] ?? '';
        $latePickupDate = $OrderRelease['latePickupDate'] ?? '';
        $earlydropDate = $OrderRelease['earlyDeliveryDate'] ?? '';
        $latedropDate = $OrderRelease['lateDeliveryDate'] ?? '';
    }?>
    <div class="navbar-area navbar-two">
        <div class="fria-nav">
            <div class="container-fluid">
                <nav class="navbar navbar-expand-md navbar-light">
                    <a class="navbar-brand" href="javascript:void (0)">
                        <img src="<?= base_url(); ?>assets/images/svkonekt-logo.svg" alt="logo" width="250px">
                    </a>
                    <div class="collapse navbar-collapse mean-menu text-right" id="navbarSupportedContent">
                        <ul class="navbar-nav ">
                            <li class="nav-item dropdown language-selector">
                                <a href="#" role="button" class="dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <?php
                                    $supportedLanguage = (is_string(WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES)) ? json_decode(WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES, true) : WEBLINK_DRIVER_APP_SUPPORTED_LANGUAGES;

                                    if (!$this->session->has_userdata('site_lang')) {
                                        $this->session->set_userdata('site_lang', WEBLINK_DRIVER_APP_DEFAULT_LANG);
                                    }
                                    $selectedLanguageFlag = array_search($this->session->userdata('site_lang'), $supportedLanguage);
                                    $flgIcon = $selectedLanguageFlag == 'en' ? 'uk' : $selectedLanguageFlag;
                                    ?>
                                    <img class="flag-ico" src="<?= $assets_url . '/img/flags/flag-' . $flgIcon . '.svg'  ?>" alt="flag_ico" width="32" height="32" />
                                </a>
                                <ul class="dropdown-menu pull-right">
                                    <input type="hidden" id="final_lang" name="final_lang">
                                    <?php
                                    foreach ($supportedLanguage as $key => $value) {
                                        $lang_label = strtoupper($supportedLanguage[$key]);

                                        // Need to change language label for Chinese and Taiwan to simplified and traditional
                                        if ($key == 'zh-cn') {
                                            $lang_label = 'SIMPLIFIED';
                                        } elseif ($key == 'zh-tw') {
                                            $lang_label = 'TRADITIONAL';
                                        }
                                        $key = $key == 'en' ? 'uk' : $key;
                                    ?>
                                        <li class="nav-item">
                                            <button type="button" onclick="$('#final_lang').val(this.value); setTimeout(() => change_language(),100); " id="<?= $key ?>" name="language" value="<?= $value ?>">
                                                <img class="flag-ico" src="<?= $assets_url . '/img/flags/flag-' . $key . '.svg' ?>" alt="flag_ico" width="32" height="32" />
                                                <span><?= $lang_label ?></span>
                                            </button>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <div class="topid-section">
            <div class="row align-items-center">
                <div class="col-12 col-md-4 col-lg-4">
                    <form class="searchCol">
                        <div class="input-group">
                            <input type="text" class="form-control searchreferenceid" id="tracking_number" placeholder="Please enter your order number" fdprocessedid="mii1hn">
                            <div class="input-group-append">
                                <!--<input type="file" id="cameraInput" accept="image/*;capture=camera" style="display: none;">-->
                                <button type="button" class="btn btn-info" id="fetchBtn">
                                    <img src="<?= base_url('assets/ELOGOTMSTSRWB/img/api.svg') ?>" alt="api" style="width:25px; height:25px; filter: invert(100%);">Search
                                </button>
                                <button type="button" class="btn btn-info" id="scanBtn">Scan</button>
                            </div>
                        </div>
                    </form>
                    <div id="cameraInstruction" style="margin-top: 10px;display: none;">
                        <video id="video" style="max-width: 100%; height: auto;"></video>
                        <div id="loading" style="display: none;">
                            <p>Loading...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="trip-block choose-section pt-196 pb-70" style="<?= !empty($OrderRelease) ? 'display: block;' : 'display: none;' ?>">

        <div class="container-fluid">
            <div class="row align-items-center left_line_col">
                <!-- Pickup_box-->
                <div class="col-lg-12 col-md-12 animated animatedFadeInUp fadeInUp pickup-details">
                    <input type="hidden" id="pickup_data" value="">
                    <input type="hidden" id="pickup_POP_res " value="">
                    <div class="cardSecure bg-white ptblr10 ml-25 pk_sec">
                        <!-- Pickup card info -->
                        <div class="card shadow-card-sm pickupleft-boarder progress_left_col pk_card" data-toggle="collapse" data-target="#p_act_btn_sec" data-tail="">
                            <div class="right_icons_box">
                                <a href="javascript:void(0)">
                                    <div class="choose-text">
                                        <div class="icon" id="icon_p_">
                                            <img src="<?= base_url('assets/ELOGOTMSTSRWB/img/pickuptruck.svg') ?>" alt="pickup_icon" style="width:70%;height:70%;">
                                            <h6>P</h6>
                                        </div>
                                        <h3><?= isset($bookingId) ? $bookingId : '';  ?></h3>
                                        <h2 id="sourceAddressDisplay"><?= isset($sourceLocationGid) ? $sourceLocationGid : ''; ?></h2>
                                          <!-- <p id="sourceAddressDisplay"><?= isset($sourceLocationGid) ? $sourceLocationGid : ''; ?></p> -->

                                        <p class="kg_col animated fadeIn" style="display: none"><?= isset($cargoDetails) ? $cargoDetails : ''; ?></p>
                                        <p class="dt_col animated fadeIn" style="display: none">
                                            <?php
                                            if (isset($earlyPickupDate) && $earlyPickupDate != null) {
                                                $date = DateTime::createFromFormat($format, $earlyPickupDate['date']);
                                                echo $date ? $date->format('d-m-Y H:i:s') : '';
                                            }else if(isset($latePickupDate) && $latePickupDate != null){
                                                $date = DateTime::createFromFormat($format, $latePickupDate['date']);
                                                echo $date ? $date->format('d-m-Y H:i:s') : '';
                                            }else {
                                                echo '';
                                             }?>
                                        </p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <!-- Pickup card info// -->
                        <!-- Pickup Status -->
                        <div class="collapse1" id="p_act_btn_sec">
                            <div class="status_col_main">
                                <div class="pickMain-hideshow animated animatedFadeIn fadeIn" id="pickup_act_ico" style="display: none;">
                                </div>
                                <div class="list_icons">
                                    <ul class="list_stats">
                                        <li>
                                        <button type="button" id="gatein_btn" <?= $disabled ?> onclick="processNextButton('ORG_GATEIN', this)" data-status="ORG_GATEIN" data-tail="" id="" data-next-id="" data-order-id="" data-trip-id="" class="gatein_btn <?= $class ?> act_btn">
                                            <span id="pgatein">
                                                <img src="<?= base_url('assets/driverappv3/img/gatein.svg') ?>" alt="gate_in"/>
                                            </span>
                                            <div class="activeCont" style="display: none;">
                                                <small class="statusLabel">PICKUP_GATE_IN</small>
                                                <p  class="status_time"><?= date('H:i d/m/y'); // you can replace with actual time ?></p>
                                            </div>
                                            <div class="buttonTitle"><?= lang('driverapp_gate_in'); ?></div>
                                        </button>
                                        </li>
                                        <li>
                                        <input type="hidden" value="" id="crd_act_p_">
                                            <button type="button" onclick="processNextButton('ORG_PICKUP', this)" data-status="ORG_PICKUP" data-tail="" id="" data-next-id="" data-order-id="" data-trip-id="" class="pickup_btn  act_btn">
                                                <span id="pickup"><img src="<?= base_url('assets/driverappv3/img/pickup.svg') ?>" alt="pickup_icon"  /></span>
                                                <div class="activeCont" style="display: none;">
                                                    <small class="statusLabel">PICKUP_OK</small>
                                                    <p  class="status_time"><?= date('H:i d/m/y');  ?></p>
                                                </div>
                                                <div class="buttonTitle"><?= lang('driverapp_pickup'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <button type="button" onclick="processNextButton('ORG_GATEOUT', this)" data-status="ORG_GATEOUT" data-tail="" id="" data-next-id="" data-order-id="" data-trip-id="" class="gateout_btn  act_btn">
                                                <span id="pgateout">
                                                    <img src="<?= base_url('assets/driverappv3/img/gateout.svg') ?>" alt="gate_out" /></span>
                                                <div class="activeCont" style="display: none;">
                                                    <small class="statusLabel">PICKUP_GATE_OUT</small>
                                                        <p  class="status_time"><?= date('H:i d/m/y'); ?></p>
                                                </div>
                                                <div class="buttonTitle"> <?= lang('driverapp_gate_out'); ?></div>
                                            </button>

                                        </li>
                                    </ul>
                                </div>

                            </div>
                        </div>
                        <!-- Pickup Status //-->
                    </div>
                </div>
                <!-- Pickup_box//-->
                <!-- drop_box-->
                <div class="col-lg-12 col-md-12 animated animatedFadeInUp fadeInUp drop-details">
                    <input type="hidden" id="drop_data" value="">
                    <input type="hidden" id="delivery_POD_res" value="">
                    <div class="cardSecure bg-white ptblr10 ml-25 dl_sec">
                        <!-- drop card info -->
                        <div class="card shadow-card-sm dropleft-boarder progress_left_col dl_card dl_sec_" data-tail="" data-toggle="collapse" data-target="#d_act_btn_sec">
                            <div class="right_icons_box">
                                <a href="javascript:void(0)">
                                    <div class="choose-text">
                                        <div class="icon" id="icon_d_">
                                            <img src="<?= base_url('assets/ELOGOTMSTSRWB/img/droptruck.svg') ?>" alt="drop_icon" style="width:70%;height:70%;">
                                            <h6>D</h6>
                                        </div>
                                        <h3><?= isset($bookingId) ? $bookingId : '';  ?></h3>
                                        <h2></h2>
                                           <h2 id="destAddressDisplay"><?= isset($destLocationGid) ? $destLocationGid : ''; ?></h2>
                                        <p class="kg_col animated fadeIn" style="display: none"><?= isset($cargoDetails) ? $cargoDetails : ''; ?></p>
                                        <p class="dt_col animated fadeIn" style="display: none">
                                            <?php
                                            if (isset($earlydropDate) && $earlydropDate != null) {
                                                $date = DateTime::createFromFormat($format, $earlydropDate['date']);
                                                echo $date ? $date->format('d-m-Y H:i:s') : '';
                                            }else if(isset($latedropDate) && $latedropDate != null){
                                                $date = DateTime::createFromFormat($format, $latedropDate['date']);
                                                echo $date ? $date->format('d-m-Y H:i:s') : '';
                                            }else {
                                               echo '';
                                            }?>
                                        </p>
                                    </div>
                                </a>
                            </div>
                        </div>
                        <!-- drop action buttons Status -->
                        <div class="collapse1" id="d_act_btn_sec">
                            <div class="status_col_main">
                                <div class="dropMain-hideshow animated fadeIn" id="delivery_act_ico" style="display: none;">
                                </div>
                                <div class="list_icons">
                                    <ul class="list_stats">
                                        <li>
                                            <button type="button" onclick="processNextButton('DEST_GATEIN', this)" data-status="DEST_GATEIN" data-tail="" id="" data-next-id="" data-order-id="" data-trip-id="" class="d_gatein_btn  act_btn">
                                                <span id="dgatein"><img src="<?= base_url('assets/driverappv3/img/gatein.svg') ?>" alt="gate_in" /></span>
                                                <div class="activeCont" style="display: none;">
                                                    <small class="statusLabel">DELIVERY_GATE_IN</small>
                                                    <p class="status_time"><?= date('H:i d/m/y');  ?></p>
                                                </div>
                                                <div class="buttonTitle"><?= lang('driverapp_gate_in'); ?></div>

                                            </button>
                                        </li>
                                        <li>
                                            <input type="hidden" value="" id="crd_act_d_">
                                            <button type="button" onclick="processNextButton('DEST_DELIVERED', this)" data-status="DEST_DELIVERED" data-tail="" id="delivered" data-next-id="" data-order-id="" data-trip-id="" class="delivery_btn  act_btn">
                                                <span id="delivered"><img src="<?= base_url('assets/driverappv3/img/drop.svg') ?>" alt="delivery_icon"  /></span>
                                                    <div class="activeCont" style="display: none;">
                                                        <small class="statusLabel">DELIVERED</small>
                                                        <p class="status_time"><?= date('H:i d/m/y');  ?></p>
                                                    </div>
                                                <div class="buttonTitle"> <?= lang('driverapp_drop'); ?></div>
                                            </button>
                                        </li>
                                        <li>
                                            <button type="button" onclick="processNextButton('DEST_GATEOUT', this)" data-status="DEST_GATEOUT" data-tail="" id="" data-next-id="" data-order-id="" data-trip-id="" class="d_gateout_btn  act_btn">
                                                <span id="dgateout"><img src="<?= base_url('assets/driverappv3/img/gateout.svg') ?>" alt="gate_out"  /></span>
                                               <div class="activeCont" style="display: none;">
                                                    <small class="statusLabel">DELIVERY_GATE_OUT</small>
                                                    <p class="status_time"><?= date('H:i d/m/y'); ?></p>
                                                </div>
                                                <div class="buttonTitle"> <?= lang('driverapp_gate_out'); ?></div>
                                            </button>

                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- drop action buttons Status //-->
                    </div>
                </div>
                <!-- drop_box//-->
            </div>
        </div>
    </section>
    <div id="alert_modal" class="modal1 modal-in1">
        <div class="modal-inner1">
            <div class="modal-title1" id="msg_1"></div>
            <div class="modal-text1" id="user_message"></div>
        </div>
        <div class="modal-buttons1">
            <span class="modal-button1 modal-button-bold1" onclick="set_message('1')" id="msg_2"></span>
        </div>
    </div>
    <input type="hidden" id="base_url" value="<?= base_url() ?>">
    <input type="hidden" id="driverapp_connection_lost" value="<?= lang('driverapp_connection_lost') ?>">
    <input type="hidden" id="driverapp_reload" value="<?= lang('driverapp_reload') ?>">
    <input type="hidden" id="driverapp_please_enter_comment" value="<?= lang('driverapp_please_enter_comment') ?>">
    <input type="hidden" id="driverapp_please_select_picture" value="<?= lang('driverapp_please_select_picture') ?>">
    <input type="hidden" id="driverapp_please_enter_valid_input" value="<?= lang('driverapp_please_enter_valid_input') ?>">
    <input type="hidden" id="driverapp_please_enter_missing_quantity" value="<?= lang('driverapp_please_enter_missing_quantity') ?>">
    <input type="hidden" id="driverapp_please_enter_signee_name" value="<?= lang('driverapp_please_enter_signee_name') ?>">
    <input type="hidden" id="driverapp_special_characters_not_allowed" value="<?= lang('driverapp_special_characters_not_allowed') ?>">
    <input type="hidden" id="driverapp_pickup_not_done_KN_message" value="<?= lang('driverapp_pickup_not_done_KN_message') ?>">
    <input type="hidden" id="driverapp_invalid_file" value="<?= lang('driverapp_invalid_file') ?>">
    <input type="hidden" id="driverapp_add_picture" value="<?= lang('driverapp_add_picture') ?>">
    <input type="hidden" id="driverapp_take_picture" value="<?= lang('driverapp_take_picture') ?>">
    <input type="hidden" id="driverapp_next" value="<?= lang('driverapp_next') ?>">
    <input type="hidden" id="driverapp_confirm_close" value="<?= lang('driverapp_confirm_close') ?>">
    <input type="hidden" id="client_time_zone_offset" value="120">
    <script>
          var mediaStream = null;
          $(document).ready(function() {
            // Add event listener to the Fetch button
            $("#fetchBtn").click(function(event) {
                event.preventDefault();
                var orderId = $("#tracking_number").val().trim();
                if (orderId !== "") {
                    fetchApiData(orderId); // Fetch directly if orderId is provided
                } else {
                    set_message('Please enter order ID.');
                }
            });
            
            $("#scanBtn").click(function(event) {
                event.preventDefault();
                startCamera();
            });

           // Function to fetch data from the API
        function fetchApiData(orderId) {
          $("#cameraInstruction").hide();
          console.log("Fetching API data for orderId:", orderId);
            $.ajax({
                type: "GET",
                url: "<?php echo base_url('ELOGOTMSTSRWB/fetchDataFromAPI'); ?>",
                data: { orderId: orderId },
                cache: false,
                success: function(res) {
                    console.log("API Response:", res);

                var data = (typeof res === "string") ? JSON.parse(res) : res;

                if (!data || data === null) {
                    alert('No data available for this orderId.');
                    return;
                }

                if (data.error) {
                    alert(data.error);
                    document.getElementById('sourceAddressDisplay').innerText = data.error;
                    document.getElementById('destAddressDisplay').innerText = data.error;
                    return;
                }

                // Show source and destination addresses
                    document.getElementById('sourceAddressDisplay').innerText = data.sourceLocation || sourceLocationGid;
                    document.getElementById('destAddressDisplay').innerText = data.destLocation || destLocationGid;

            
                displayDataInSection(data);

                stopCamera();
                },
                error: function(xhr, textStatus, errorThrown) {
                    console.error('There was a problem with the fetch operation:', errorThrown);
                    alert('Failed to fetch data from API. Please try again.');
                    document.getElementById('sourceAddressDisplay').innerText = 'Failed to fetch data';
                    document.getElementById('destAddressDisplay').innerText = 'Failed to fetch data';
                }
            });
        }


// Function to display order data and source/destination details


            function startCamera() {
                $("#cameraInstruction").show(); 
                $("#loading").hide();
                // Access the mobile camera
                navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
                    .then(function(stream) {
                        mediaStream = stream;
                        var video = document.getElementById('video');
                        video.srcObject = mediaStream;
                        video.play();
                        video.onloadedmetadata = function() {
                            readQRCodeFromCamera(video);
                        };
                    })  
                    .catch(function(err) {
                        $("#cameraInstruction").hide();
                        console.error('Error accessing camera:', err);
                        alert('Error accessing camera. Please try again.');
                    });
            }

            function readQRCodeFromCamera(video) {
                // Create a canvas element to capture video frames
                var canvasElement = document.createElement('canvas');
                var canvas = canvasElement.getContext('2d');

                // Set canvas dimensions to match video dimensions
                canvasElement.width = video.videoWidth;
                canvasElement.height = video.videoHeight;

                // Draw video frames onto the canvas and decode QR code
                var timer = setInterval(function() {
                    canvas.drawImage(video, 0, 0, canvasElement.width, canvasElement.height);
                    var imageData = canvas.getImageData(0, 0, canvasElement.width, canvasElement.height);
                    var code = jsQR(imageData.data, imageData.width, imageData.height);
                    if (code) {
                        clearInterval(timer); // Stop scanning
                        var orderId = code.data; // Extracted order ID from QR code
                        $("#cameraInstruction").hide(); 
                        $("#loading").show();
                        fetchApiData(orderId); // Call fetchApiData with order ID
                    }
                }, 100); // Scan for QR code every 100 milliseconds
            }
        });
        
        function stopCamera() {
            if (mediaStream) {
                mediaStream.getTracks().forEach(track => {
                    track.stop(); // Stop all tracks
                });
            }
        }

       function displayDataInSection(data) {
        var orderData = data.orderData ?? {};
        var orderRelease = orderData['OrderRelease'] ?? null;

        document.querySelector('.trip-block').style.display = 'block';

    if (orderRelease) {
        var bookingId = orderRelease['orderReleaseXid'] ?? '';
        var sourceLocationGid = (orderRelease['sourceLocationGid'] || '').split('.').pop() || '';
        var destLocationGid = (orderRelease['destLocationGid'] || '').split('.').pop() || '';
        var totalItemPackageCount = orderRelease['totalItemPackageCount'] || '';
        var totalWeightValue = orderRelease['totalWeight']['value'] || '';
        var totalWeightUomCode = orderRelease['totalWeight']['uomCode'] || '';
        var totalVolumeValue = orderRelease['totalVolume']['value'] || '';
        var totalVolumeUomCode = orderRelease['totalVolume']['uomCode'] || '';
        var cargoDetails = totalItemPackageCount + '-' + totalWeightValue + '-' + totalWeightUomCode + '-' + totalVolumeValue + '-' + totalVolumeUomCode;
        var earlyPickupDate = orderRelease['earlyPickupDate'] || '';
        var latePickupDate = orderRelease['latePickupDate'] || '';
        var earlydropDate = orderRelease['earlyDeliveryDate'] || '';
        var latedropDate = orderRelease['lateDeliveryDate'] || '';

        // Pickup card
        document.querySelector('.pk_card .choose-text h3').textContent = bookingId;
        document.querySelector('.pk_card .choose-text p').textContent = data.sourceLocation || sourceLocationGid;
        document.querySelector('.pk_card .choose-text .kg_col').textContent = cargoDetails;
        document.querySelectorAll('.pk_card .choose-text .dt_col')[0].textContent = earlyPickupDate;
        document.querySelectorAll('.pk_card .choose-text .dt_col')[1].textContent = latePickupDate;

        // Delivery card
        document.querySelector('.dl_card .choose-text h3').textContent = bookingId;
        document.querySelector('.dl_card .choose-text p').textContent = data.destLocation || destLocationGid;
        document.querySelector('.dl_card .choose-text .kg_col').textContent = cargoDetails;
        document.querySelectorAll('.dl_card .choose-text .dt_col')[0].textContent = earlydropDate;
        document.querySelectorAll('.dl_card .choose-text .dt_col')[1].textContent = latedropDate;
    } else {
        console.log("OrderRelease not found in data:", data);
    }
}


        // Clear session data when window is closed
        window.addEventListener('beforeunload', function() {
            sessionStorage.removeItem('apiResponse');
        });
    </script>
    <script>
        var statusValues = [];
        var statusValues = <?=
            isset($_SESSION['statusValues']) && is_array($_SESSION['statusValues'])
                ? json_encode($_SESSION['statusValues'])
                : '[]'
        ?>;

            
            // Function to find the previous status
            function findPrevStatus(status) {
                switch (status) {
                    case "ORG_GATEIN":
                        return null;;
                    case "ORG_PICKUP":
                        return "ORG_GATEIN";
                    case "ORG_GATEOUT":
                        return "ORG_PICKUP";
                    case "DEST_GATEIN":
                        return "ORG_GATEOUT";
                    case "DEST_DELIVERED":
                        return "DEST_GATEIN";
                    case "DEST_GATEOUT":
                        return "DEST_DELIVERED";
                    default:
                        return null;;
                }
            }

            // Function to find the next status
            function findNextStatus(status) {
                switch (status) {
                    case "ORG_GATEIN":
                        return "ORG_PICKUP";
                    case "ORG_PICKUP":
                        return "ORG_GATEOUT";
                    case "ORG_GATEOUT":
                        return "DEST_GATEIN";
                    case "DEST_GATEIN":
                    case "DEST_DELIVERED":
                        return "DEST_GATEOUT";
                    default:
                        return null;
                }
            }

            function getNextButton(nextStatus) {
                if (nextStatus) {
                    var buttons = document.querySelectorAll('.act_btn[data-status="' + nextStatus + '"]');
                    if (buttons.length > 0) {
                        return buttons[0];
                    }
                }
                return null;
            }
            document.addEventListener("DOMContentLoaded", function() {
                // Iterate through each button and check if its status is in the statusValues array
                var buttons = document.querySelectorAll('.act_btn');
                buttons.forEach(function(button) {
                    var status = button.getAttribute('data-status');
                    if (statusValues.includes(status)) {
                        button.disabled = true;
                        button.querySelector('span').style.backgroundColor = '#50C878';
                    }
                });
            });

           function processNextButton(status, button) {
                console.log("status: " + status);
                var prevStatus = findPrevStatus(status);
                console.log("prevStatus: " + prevStatus);
                if (status === "ORG_GATEIN" || (prevStatus && statusValues.includes(prevStatus))) {
                    statusValues.push(status);
                    updateSession('statusValues', statusValues);
                    button.disabled = true;
                    var titleDiv = button.querySelector(".buttonTitle");
                        if (titleDiv) {
                            titleDiv.style.display = "none";
                        }
                    var labelDiv = button.querySelector(".activeCont");
                    if (labelDiv) {
                        // Set current time
                        var now = new Date();
                        var formattedTime = now.getHours().toString().padStart(2,'0') + ':' +
                                            now.getMinutes().toString().padStart(2,'0') + ' ' +
                                            now.getDate().toString().padStart(2,'0') + '/' +
                                            (now.getMonth()+1).toString().padStart(2,'0') + '/' +
                                            now.getFullYear().toString().slice(2);

                        var timeP = labelDiv.querySelector(".status_time");
                        if (timeP) {
                            timeP.textContent = formattedTime;
                        }

                        labelDiv.style.display = "block";
                        labelDiv.classList.add("animated", "animatedFadeInUp", "fadeInUp");
                    }
                    button.classList.add("active");
        

                  sendStatusToServer(status);
                } else {
                    button.disabled = true;
                    return;
                }

    
                var nextStatus = findNextStatus(status);
                var nextButton = getNextButton(nextStatus);
                if (nextButton) {
                    nextButton.disabled = false;
                    nextButton.classList.remove("only-image");
                }
            }

            // Function to update session
            function updateSession(key, value) {
                 
                <?php
                // Start PHP block to echo JavaScript code
                ?>
                var xhr = new XMLHttpRequest();
                xhr.open('POST', '<?= htmlspecialchars($_SERVER["PHP_SELF"]) ?>', true);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

                xhr.onload = function() {
                    if (xhr.status === 200) {
                        // Success
                        button.disabled = true;
                        console.log(xhr.responseText);
                    } else {
                        // Error
                        console.error(xhr.statusText);
                    }
                };

                var sendData = key + '=' + encodeURIComponent(JSON.stringify(value));

                xhr.send(sendData);
                <?php
                // End PHP block
                ?>
            }

            // Function to send status to server
            function sendStatusToServer(status) {
               
                
                var xhr = new XMLHttpRequest();
                xhr.open('POST', 'ELOGOTMSTSRWB/generateStatusXml', true);
                xhr.setRequestHeader('Content-Type', 'application/json');

                xhr.onload = function() {
                    if (xhr.status === 200) {
                        // Success
                        console.log(xhr.responseText);
                    } else {
                        // Error
                        console.error(xhr.statusText);
                    }
                };

                xhr.send(JSON.stringify({
                    status: status
                }));
            }
       
    </script>
    <script>
        function set_message(user_mesage, button_msg = 'OK') {
            $('#user_message').html(user_mesage);
            $('#msg_1').html('Message');
            $('#msg_2').html(button_msg);

            if (user_mesage.length > 2) {
                document.getElementById('alert_modal').style.display = 'block';
            } else {
                document.getElementById('alert_modal').style.display = 'none';
            }
            if (button_msg !== 'OK') {
                $('#msg_2').click(() => {
                    window.location.reload();
                })
            }
        }
        var base_url = 'https://elog360.app/svkonekt_test/';
        function change_language() {
            var final_lang = $('#final_lang').val()
            if (final_lang.length < 3) {
                set_message('Please select valid language')
                return false
            }
            var form = new FormData()
            form.append('language', final_lang)
            $.ajax({
                type: 'POST',
                url: base_url + 'driversite_language2',
                processData: false,
                data: form,
                contentType: false,
                cache: false,
                beforeSend: function() {
                    $('body .loading_roc').show()
                    showLoader()
                },
                success: function(response) {
                    var res = JSON.parse(response)
                    if (parseInt(res.status) === 1) {
                        window.location.reload()
                    } else {
                        set_message(res.response)
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    hideLoader()
                    set_message('Error Occurred.')
                }
            })
        }

        function showLoader() {
            $('body .loading_roc').css('display', '')
        }

        function hideLoader() {
            $('body .loading_roc').css('display', 'none')
        }
        
    </script>
</body>

</html>