<!DOCTYPE html>
<html>
  <head>
    <title>Svkonekt Status (Outbound)</title>
    <link rel="stylesheet" href="/assets/css/tree.css">
  </head>
  <body>
    <ul class="tree">
      <!-- (A) "NORMAL" ITEMS -->
      <li>Events in svkonekt represents state of a shipment / action occurence, an Event can be of following types
	<ul>
	<li>Cargo Events : Actions occured while transporation e.g. Vehicle Get In, Pickup delivered</li>
	<li>Info Events  : Generic Updates on Transportation e.g. Driver Assigned etc </li>
	<li>Customs Events  : Events to update customs info for Cross Border or Export or Import shipments f</li>

	</ul>
	</li>
      <li>Events to svkonekt can be sent in multiple models
	<ul>
	<li>API : svkonekt API URL can be used to push Events / Status</li>
	<li>MFT : Events can be sent to svkonekt by placing files in MFT folder as shared by Kuehne Nagel</li>
	<li><b>METHOD</b> : <button class="button">POST</button></li>
	</ul></li>

      <!-- (B) SECTION -->
      <li class="section">
        <input type="checkbox" id="groupA">
        <label for="groupA">Sample XML</label>
	<ul><li>
        <xmp>

            <SVKEDIMessage>
                <SVKEDITransmissionHeader>
                    <EDIVersion/>
                    <SenderTransmissionNo/>
                    <AckSpec>
                        <AckOption/>
                        <EmailAddress/>
                    </AckSpec>
                    <SourceApp/>
                    <DestinationApp/>
                    <Action/>
                </SVKEDITransmissionHeader>
                <SVKEDITransmissionBody>
                    <TripOrderDetails>
                        <VehicleDetails>
                            <VehicleTypeCode/>
                            <VehicleModelCode/>
                            <RegistrationNumber/>
                        </VehicleDetails>
                        <DriverDetails>
                            <DriverName/>
                            <DriverLicence/>
                            <DriverNationalIdentificationNumber/>
                            <ContactNo/>
                        </DriverDetails>
                    </TripOrderDetails>
                    <Order>
                        <OrderID/>
                        <Status>
                            <StatusCode/>
                            <StatusValue/>
                            <StatusType/>
                            <DateTime/>
                            <TimeZone/>
                            <Lat/>
                            <Lng/>
                            <Location/>
                            <NextStopETA/>
                            <NextStopDuration/>
                        </Status>
                        <Pod>
                            <PodUrl/>
                        </Pod>
                        <AdditionalInfo>
                            <Reason>
                                <ReasonCode/>
                                <ReasonDescription/>
                                <RemarkCode/>
                                <RemarkDescription/>
                            </Reason>
                            <Reason>
                                <ReasonCode/>
                                <ReasonDescription/>
                                <RemarkCode/>
                                <RemarkDescription/>
                            </Reason>
                        </AdditionalInfo>
                    </Order>
                </SVKEDITransmissionBody>
            </SVKEDIMessage>

	</xmp></li>
	</ul>
      </li>

      <!-- (C) SECTION WITH SUB-SECTION -->
      <li class="section">
        <input type="checkbox" id="BKGSTSREQ">
        <label for="BKGSTSREQ">Request : Payload</label>
        <ul>
          <!-- SUB-SECTION -->
          <li class="section">
            <input type="checkbox" id="SVKEDITransmissionHeader">
            <label for="SVKEDITransmissionHeader">SVKEDITransmissionHeader</label>
            <ul>
              <li>
		<Table border=0.5 style="color:black">
		<tr style="background-color:lightgrey">
	 	<td>Element  </td>
		<td>Code table&nbsp;&nbsp;&nbsp;</td>
		<td>Mandatory&nbsp;&nbsp;&nbsp;</td>
		<td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
		<td>Type&nbsp;&nbsp;&nbsp;</td>
		<td>Loop&nbsp;&nbsp;&nbsp;</td>
		<td>Min/max&nbsp;&nbsp;&nbsp;</td>
		<td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
		<td>Sample Value&nbsp;&nbsp;&nbsp;</td>
		<td>Description&nbsp;&nbsp;&nbsp;</td>
		</tr>
		<tr>
	 	<td>EDIVersion</td>
		<td></td>
		<td>Y</td>
		<td>Fixed</td>
		<td>Numeric  </td>
		<td>No</td>
		<td></td>
		<td></td>
		<td>6.3.1</td>
		<td>This is used to maintain the API / EDI version used for data exchange</td>
		</tr>
		<tr>
	 	<td>SenderTransmissionNo</td>
		<td></td>
		<td>Y</td>
		<td>Variable</td>
		<td>Alpha-Numeric &nbsp;&nbsp;</td>
		<td>No</td>
		<td>1/27</td>
		<td></td>
		<td>20221031084446_KN8422040333 &nbsp;</td>
		<td>Unique number generated by Source application for Tracking this Transmission: Suggested to have as below
(YMDHMS-KNBOOKINGID)
</td>
		</tr>
		<tr>
            <td>AckSpec</td>
           <td></td>
           <td>N</td>
           <td>Variable</td>
           <td> </td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           <td></td>
           </tr>
          <tr>
           <td colspan="10">
            <li class="section">
              <input type="checkbox" id="SVKEDITAckSpec">
              <label for="SVKEDITAckSpec">AckSpec</label>
              <ul>
                <li>
                  <Table border=0.5 style="color:black">
                    <tr style="background-color:lightgrey">
                     <td>Element  </td>
                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    </tr>
                 <tr>
                 <td>AckOption</td>
                 <td>CT_Ack</td>
                 <td>N</td>
                 <td>Variable</td>
                 <td>Alpha &nbsp;&nbsp;</td>
                 <td>No</td>
                 <td>0/5</td>
                 <td></td>
                 <td>ERROR</td>
                 <td>This represents transmission status</td>
                 </tr>
                 <tr>
                  <td>EmailAddress</td>
                  <td></td>
                  <td>N</td>
                  <td>Variable</td>
                  <td>Alpha-Numeric &nbsp;&nbsp;</td>
                  <td>No</td>
                  <td>0/60</td>
                  <td></td>
                  <td>abc@kuehne-nagel.com</td>
                  <td>Email ID to whom we need to send a notification of any failure</td>
                 </tr>
                 </Table>
                </li>
              </ul>
            </li>
           </td>
           </tr>
           <tr>
            <td>SourceApp</td>
           <td>FIXED</td>
           <td>Y</td>
           <td>Fixed</td>
           <td>Alpha</td>
           <td>No</td>
           <td>1/9</td>
           <td></td>
           <td>ETRA</td>
           <td>Sender Application Name.</td>
           </tr>
           <tr>
            <td>DestinationApp</td>
            <td>CT_Destination</td>
            <td>Y</td>
            <td>Variable</td>
            <td>Alpha</td>
            <td>No</td>
            <td>1/100</td>
            <td></td>
            <td>CARRIER</td>
            <td>Receiver Application Name</td>
           </tr>
           <tr>
            <td>Action</td>
           <td>CT_Action</td>
           <td>Y</td>
           <td>Variable</td>
           <td>Alpha</td>
           <td>No</td>
           <td>1/19</td>
           <td></td>
           <td>INSERT</td>
           <td>Transmission action of this event occurrence to Insert,Update ,replace and insert.</td>
           </tr>

		</table>
		</li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="SVKEDITransmissionBody">
            <label for="SVKEDITransmissionBody">SVKEDITransmissionBody</label>
            <ul>
              <li>
                <Table border=0.5 style="color:black">
                  <tr style="background-color:lightgrey">
                    <td>Element  </td>
                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr>
                    <td colspan="10">
                     <li class="section">
                       <input type="checkbox" id="SVKEDITTripOD">
                       <label for="SVKEDITTripOD">TripOrderDetails</label>
                       <ul>
                         <li>
                           <Table border=0.5 style="color:black">
                             <tr style="background-color:lightgrey">
                              <td>Element  </td>
                             <td>Code table&nbsp;&nbsp;&nbsp;</td>
                             <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                             <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                             <td>Type&nbsp;&nbsp;&nbsp;</td>
                             <td>Loop&nbsp;&nbsp;&nbsp;</td>
                             <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                             <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                             <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                             <td>Description&nbsp;&nbsp;&nbsp;</td>
                             </tr>
                             <tr>
                              <td colspan="10">
                               <li class="section">
                                 <input type="checkbox" id="SVKEDITVehDet">
                                 <label for="SVKEDITVehDet">VehicleDetails</label>
                                 <ul>
                                   <li>
                                     <Table border=0.5 style="color:black">
                                       <tr style="background-color:lightgrey">
                                        <td>Element  </td>
                                       <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                       <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                       <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                       <td>Type&nbsp;&nbsp;&nbsp;</td>
                                       <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                       <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                       <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                       <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                       <td>Description&nbsp;&nbsp;&nbsp;</td>
                                       </tr>
                                       <tr>
                                        <td>VehicleTypeCode</td>
                                       <td>CT_Truck Type Master</td>
                                       <td>N</td>
                                       <td>Variable</td>
                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                       <td>No</td>
                                       <td>0/10</td>
                                       <td></td>
                                       <td>4WC</td>
                                       <td>The type of the vehicle in the Database</td>
                                       </tr>
                                       <tr>
                                        <td>VehicleModelCode</td>
                                       <td>CT_Truck Type Master</td>
                                       <td>N</td>
                                       <td>Variable</td>
                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                       <td>No</td>
                                       <td>0/10</td>
                                       <td></td>
                                       <td>FOUR WHEELER</td>
                                       <td>The model for particular type of vehicle in the data base</td>
                                       </tr>
                                       <tr>
                                        <td>RegistrationNumber</td>
                                       <td></td>
                                       <td>N</td>
                                       <td>Variable</td>
                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                       <td>No</td>
                                       <td>0/10</td>
                                       <td></td>
                                       <td>APAXC8767</td>
                                       <td>The no. denoting the registration of the vehicle with the competent authority</td>
                                       </tr>
                                    </Table>
                                   </li>
                                 </ul>
                               </li>
                              </td>
                              </tr>
                              <tr>
                                <td colspan="10">
                                 <li class="section">
                                   <input type="checkbox" id="SVKEDITDriDet">
                                   <label for="SVKEDITDriDet">DriverDetails</label>
                                   <ul>
                                     <li>
                                       <Table border=0.5 style="color:black">
                                         <tr style="background-color:lightgrey">
                                          <td>Element  </td>
                                         <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                         <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                         <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                         <td>Type&nbsp;&nbsp;&nbsp;</td>
                                         <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                         <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                         <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                         <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                         <td>Description&nbsp;&nbsp;&nbsp;</td>
                                         </tr>
                                         <tr>
                                          <td>DriverName</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/10</td>
                                         <td></td>
                                         <td>Long Suki</td>
                                         <td></td>
                                         </tr>
                                         <tr>
                                          <td>DriverLicence</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/10</td>
                                         <td></td>
                                         <td>A78120</td>
                                         <td></td>
                                         </tr>
                                         <tr>
                                          <td>DriverNationalIdentificationNumber&nbsp;&nbsp;&nbsp;</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/10</td>
                                         <td></td>
                                         <td>Y7893JKM</td>
                                         <td></td>
                                         </tr>
                                         <tr>
                                          <td>ContactNo</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/10</td>
                                         <td></td>
                                         <td>994678900</td>
                                         <td></td>
                                         </tr>
                                      </Table>
                                     </li>
                                   </ul>
                                 </li>
                                </td>
                                </tr>
                          </Table>
                         </li>
                       </ul>
                     </li>
                    </td>
                    </tr>
                    <tr>
                      <td colspan="10">
                       <li class="section">
                         <input type="checkbox" id="SVKEDITOrder">
                         <label for="SVKEDITOrder">Order</label>
                         <ul>
                           <li>
                             <Table border=0.5 style="color:black">
                               <tr style="background-color:lightgrey">
                                <td>Element  </td>
                               <td>Code table&nbsp;&nbsp;&nbsp;</td>
                               <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                               <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                               <td>Type&nbsp;&nbsp;&nbsp;</td>
                               <td>Loop&nbsp;&nbsp;&nbsp;</td>
                               <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                               <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                               <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                               <td>Description&nbsp;&nbsp;&nbsp;</td>
                               </tr>
                               <tr>
                                <td>OrderID</td>
                               <td></td>
                               <td>Y</td>
                               <td>Variable</td>
                               <td>Numeric</td>
                               <td>No</td>
                               <td>1/10</td>
                               <td></td>
                               <td>8422040333</td>
                               <td>KN Booking ID against which this status is being triggered.</td>
                               </tr>
                               <tr>
                                <td colspan="10">
                                 <li class="section">
                                   <input type="checkbox" id="SVKEDITStatus">
                                   <label for="SVKEDITStatus">Status</label>
                                   <ul>
                                     <li>
                                       <Table border=0.5 style="color:black">
                                         <tr style="background-color:lightgrey">
                                          <td>Element  </td>
                                         <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                         <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                         <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                         <td>Type&nbsp;&nbsp;&nbsp;</td>
                                         <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                         <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                         <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                         <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                         <td>Description&nbsp;&nbsp;&nbsp;</td>
                                         </tr>
                                         <tr>
                                          <td>StatusCode</td>
                                         <td>CT_Statuscode</td>
                                         <td>Y</td>
                                         <td>Variable</td>
                                         <td>Numeric</td>
                                         <td>No</td>
                                         <td>1/4</td>
                                         <td></td>
                                         <td>1500</td>
                                         <td>Status Code to identify the event information.</td>
                                         </tr>
                                         <tr>
                                          <td>StatusValue</td>
                                         <td>CT_Statuscode : Description</td>
                                         <td>Y</td>
                                         <td>Variable</td>
                                         <td>Alpha</td>
                                         <td>No</td>
                                         <td>1/20</td>
                                         <td></td>
                                         <td>ORIGIN_GATE_OUT</td>
                                         <td>Status description need to be always in English only .</td>
                                         </tr>
                                         <tr>
                                          <td>StatusType</td>
                                         <td>CT_Statuscode : Category</td>
                                         <td>Y</td>
                                         <td>Variable</td>
                                         <td>Alpha</td>
                                         <td>No</td>
                                         <td>1/4</td>
                                         <td></td>
                                         <td>IN-TRANSIT</td>
                                         <td>Primary Category of the status .</td>
                                         </tr>
                                         <tr>
                                          <td>DateTime</td>
                                         <td>dd-mm-yyyy hh:mm:ss</td>
                                         <td>Y</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>1/19</td>
                                         <td></td>
                                         <td>2022-10-31T00:25:38</td>
                                         <td>Event date needs to be transmitted in this field.</td>
                                         </tr>
                                         <tr>
                                          <td>TimeZone</td>
                                         <td>CT_Time Zone Value</td>
                                         <td>Y</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>1/12</td>
                                         <td></td>
                                         <td>Asia/Ho_Chi_Minh</td>
                                         <td>UTC timezone of the event date, this is used to derive the UTC time for storing in system.</td>
                                         </tr>
                                         <tr>
                                          <td>Lat</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Numeric</td>
                                         <td>No</td>
                                         <td>0/20</td>
                                         <td></td>
                                         <td>20.8984531</td>
                                         <td>Latitude of location at which status was triggered.</td>
                                         </tr>
                                         <tr>
                                          <td>Lng</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Numeric</td>
                                         <td>No</td>
                                         <td>0/20</td>
                                         <td></td>
                                         <td>106.5141873</td>
                                         <td>Longitude of location at which status was triggered.</td>
                                         </tr>
                                         <tr>
                                          <td>Location</td>
                                         <td></td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/100</td>
                                         <td></td>
                                         <td>KimThnh, HaiDuong,Vietnam</td>
                                         <td>Name of the Location</td>
                                         </tr>
                                         <tr>
                                          <td>NextStopETA</td>
                                         <td>dd-mm-yyyy hh:mm:ss</td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                         <td>No</td>
                                         <td>0/12</td>
                                         <td></td>
                                         <td>2023-03-30T18:00:00</td>
                                         <td>The Estimated date/time for arrival to the next stop.</td>
                                         </tr>
                                         <tr>
                                          <td>NextStopDuration</td>
                                         <td>hh:mm:ss</td>
                                         <td>N</td>
                                         <td>Variable</td>
                                         <td>Numeric</td>
                                         <td>No</td>
                                         <td>0/12</td>
                                         <td></td>
                                         <td>02:25:00</td>
                                         <td>Duration taken for arrival to the next stop.</td>
                                         </tr>
                                      </Table>
                                     </li>
                                   </ul>
                                 </li>
                                </td>
                                </tr>
                                <tr>
                                  <td colspan="10">
                                   <li class="section">
                                     <input type="checkbox" id="SVKEDITPod">
                                     <label for="SVKEDITPod">Pod</label>
                                     <ul>
                                       <li>
                                         <Table border=0.5 style="color:black">
                                           <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                           <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                           <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                           <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                           <td>Type&nbsp;&nbsp;&nbsp;</td>
                                           <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                           <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                           <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                           <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                           <td>Description&nbsp;&nbsp;&nbsp;</td>
                                           </tr>
                                           <tr>
                                            <td>PodUrl</td>
                                           <td></td>
                                           <td>N</td>
                                           <td>Variable</td>
                                           <td>Numeric</td>
                                           <td>No</td>
                                           <td></td>
                                           <td></td>
                                           <td></td>
                                           <td>This is a link directing to upload document such as Proof of delivery.</td>
                                           </tr>
                                        </Table>
                                       </li>
                                     </ul>
                                   </li>
                                  </td>
                                  </tr>
                                  <tr>
                                    <td colspan="10">
                                     <li class="section">
                                       <input type="checkbox" id="SVKEDITAddInfo">
                                       <label for="SVKEDITAddInfo">AdditionalInfo</label>
                                       <ul>
                                         <li>
                                           <Table border=0.5 style="color:black">
                                             <tr style="background-color:lightgrey">
                                              <td>Element  </td>
                                             <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                             <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                             <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                             <td>Type&nbsp;&nbsp;&nbsp;</td>
                                             <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                             <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                             <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                             <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                             <td>Description&nbsp;&nbsp;&nbsp;</td>
                                             </tr>
                                             <tr>
                                              <td colspan="10">
                                               <li class="section">
                                                 <input type="checkbox" id="SVKEDITReason">
                                                 <label for="SVKEDITReason">Reason</label>
                                                 <ul>
                                                   <li>
                                                     <Table border=0.5 style="color:black">
                                                       <tr style="background-color:lightgrey">
                                                        <td>Element  </td>
                                                       <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                       <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                       </tr>
                                                       <tr>
                                                        <td>ReasonCode</td>
                                                       <td>CT_Exception</td>
                                                       <td>N</td>
                                                       <td>Variable</td>
                                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                       <td>No</td>
                                                       <td></td>
                                                       <td></td>
                                                       <td>0502</td>
                                                       <td>Reason code for the feedback or short description mentioned.</td>
                                                       </tr>
                                                       <tr>
                                                        <td>ReasonDescription</td>
                                                       <td>CT_Exception</td>
                                                       <td>N</td>
                                                       <td>Variable</td>
                                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                       <td>No</td>
                                                       <td></td>
                                                       <td></td>
                                                       <td>pick up broken</td>
                                                       <td>Description of the reason or feedback on the transit /cargo.</td>
                                                       </tr>
                                                       <tr>
                                                        <td>RemarkCode</td>
                                                       <td></td>
                                                       <td>N</td>
                                                       <td>Variable</td>
                                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                       <td>No</td>
                                                       <td></td>
                                                       <td></td>
                                                       <td>123</td>
                                                       <td>Remark code on the feedback that carrier can provide.</td>
                                                       </tr>
                                                       <tr>
                                                        <td>RemarkDescription</td>
                                                       <td></td>
                                                       <td>N</td>
                                                       <td>Variable</td>
                                                       <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                       <td>No</td>
                                                       <td></td>
                                                       <td></td>
                                                       <td>damage because of accident</td>
                                                       <td>Description of the remark code.</td>
                                                       </tr>

                                                    </Table>
                                                   </li>
                                                 </ul>
                                               </li>
                                              </td>
                                              </tr>
                                              <tr>
                                                <td colspan="10">
                                                 <li class="section">
                                                   <input type="checkbox" id="SVKEDITReason1">
                                                   <label for="SVKEDITReason1">Reason</label>
                                                   <ul>
                                                     <li>
                                                       <Table border=0.5 style="color:black">
                                                         <tr style="background-color:lightgrey">
                                                          <td>Element  </td>
                                                         <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                         <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                         </tr>
                                                         <tr>
                                                          <td>ReasonCode</td>
                                                         <td></td>
                                                         <td>N</td>
                                                         <td>Variable</td>
                                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                         <td>No</td>
                                                         <td></td>
                                                         <td></td>
                                                         <td>503</td>
                                                         <td></td>
                                                         </tr>
                                                         <tr>
                                                          <td>ReasonDescription</td>
                                                         <td></td>
                                                         <td>N</td>
                                                         <td>Variable</td>
                                                         <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                         <td>No</td>
                                                         <td></td>
                                                         <td></td>
                                                         <td>DELIVERY_SHORT</td>
                                                         <td></td>
                                                         </tr>
                                                         <tr>
                                                          <td>RemarkCode</td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td>1234</td>
                                                         <td></td>
                                                         </tr>
                                                         <tr>
                                                          <td>RemarkDescription</td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td></td>
                                                         <td>NON-AVAILABILITY</td>
                                                         <td></td>
                                                         </tr>

                                                      </Table>
                                                     </li>
                                                   </ul>
                                                 </li>
                                                </td>
                                                </tr>

                                          </Table>
                                         </li>
                                       </ul>
                                     </li>
                                    </td>
                                    </tr>

                            </Table>
                           </li>
                         </ul>
                       </li>
                      </td>
                      </tr>

                </Table>
              </li>

            </ul>
          </li>

        </ul>
      </li>

  <li class="section">
        <input type="checkbox" id="BKGSTSCT">
        <label for="BKGSTSCT">Status : Cross Reference / Code Table</label>
        <ul>
          <!-- SUB-SECTION -->
          <li class="section">
            <input type="checkbox" id="STOUTACK">
            <label for="STOUTACK">Acknowledgement</label>
            <ul>
                <li>
                  <h2>Code table: Source</h2>
                  <Table border=0.5 style="color:black; width:100%;">
                    <tr style="background-color:lightgrey">
                      <td>ID</td>
                      <td>Code&nbsp;&nbsp;&nbsp;</td>
                      <td>Description&nbsp;&nbsp;&nbsp;</td>
                      <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                      <td>Description&nbsp;&nbsp;&nbsp;</td>
                    </tr>
                    <tr>
                      <td>ACK_O1</td>
                     <td>ERROR</td>
                     <td>Failed to Integrate</td>
                     <td>ERROR</td>
                     <td></td>
                    </tr>
                    <tr>
                      <td>ACK_O2</td>
                     <td>SUCCESS</td>
                     <td>Integrated successful</td>
                     <td>SUCCESS</td>
                     <td></td>
                    </tr>
                    <tr>
                      <td>ACK_O3</td>
                     <td>STAGED</td>
                     <td>Received but unable to process</td>
                     <td>STAGED</td>
                     <td></td>
                    </tr>
                  </Table>
                </li>
              </ul>
          </li>
	 <li class="section">
            <input type="checkbox" id="STSOUTDES">
            <label for="STSOUTDES">Destination</label>
            <ul>
              <li>
                <h2>Code table: Source</h2>
                  <Table border=0.5 style="color:black; width:100%;">
                    <tr style="background-color:lightgrey">
                      <td>ID</td>
                      <td>Code&nbsp;&nbsp;&nbsp;</td>
                      <td>Description&nbsp;&nbsp;&nbsp;</td>
                      <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                      <td>Description&nbsp;&nbsp;&nbsp;</td>
                    </tr>
                    <tr>
                        <td>DEST_01</td>
                        <td>SALOG</td>
                        <td></td>
                        <td>SALOG</td>
                        <td></td>
                       </tr>
                       <tr>
                        <td>DEST_02</td>
                        <td>ROADLOG</td>
                        <td></td>
                        <td>ROADLOG</td>
                        <td></td>
                       </tr>
                       <tr>
                        <td>DEST_03</td>
                        <td>CARRIER</td>
                        <td>All Carrier EDI status will provide carrier as Source</td>
                        <td>CARRIER</td>
                        <td>All Carrier EDI status will provide carrier as Source</td>
                       </tr>
                       <tr>
                        <td>DEST_04</td>
                        <td>CUSTOMER</td>
                        <td>Customer will be used if External Customer is sending Status</td>
                        <td>CUSTOMER</td>
                        <td>Customer will be used if External Customer is sending Status</td>
                       </tr>

                    </Table>
              </li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="STSOUTACT">
            <label for="STSOUTACT">Action</label>
            <ul>
              <li>
                <h2>Code table: Source</h2>
                <Table border=0.5 style="color:black; width:100%;">
                  <tr style="background-color:lightgrey">
                    <td>ID</td>
                    <td>Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr>
                    <td>ACT_01</td>
                   <td>I</td>
                   <td>INSERT</td>
                   <td>I</td>
                   <td>INSERT</td>
                   </tr>
                   <tr>
                    <td>ACT_02</td>
                   <td>U</td>
                   <td>UPDATED</td>
                   <td>U</td>
                   <td>UPDATED</td>
                   </tr>
                   <tr>
                    <td>ACT_03</td>
                   <td>RC</td>
                   <td>REPLACE AND INSERT</td>
                   <td>RC</td>
                   <td>REPLACE AND INSERT</td>
                   </tr>
                </Table>
              </li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="STSOUBTRUTYMTER">
            <label for="STSOUBTRUTYMTER">Truck Type Master</label>
            <ul>
              <li>
                <h2>Code table : Vehicle Master</h2>
                <Table border=0.5 style="color:black; width:100%;">
                  <tr style="background-color:lightgrey">
                    <td>ID</td>
                    <td>Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr >
                    <td>VEH_MAS_1</td>
                    <td > TRACTOR HEAD</td>
                    <td > TRACTOR HEAD</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_2</td>
                    <td >1 Ton pick-up</td>
                    <td >1 Ton pick-up</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_3</td>
                    <td >1 TONNER </td>
                    <td >1 TONNER </td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_4</td>
                    <td >1 TONNER Reefer</td>
                    <td >1 TONNER Reefer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_5</td>
                    <td >1.0T</td>
                    <td >1.0T</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_6</td>
                    <td >1.3 Tonner </td>
                    <td >1.3 Tonner closed</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_7</td>
                    <td >1/2 Tonner</td>
                    <td >1/2 tonner bakkie</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_8</td>
                    <td >10 Ton pick-up</td>
                    <td >10 Ton pick-up</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_9</td>
                    <td >10 Wheeler Cabinet</td>
                    <td >TEN_WHEELER</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_10</td>
                    <td >10W</td>
                    <td >10W</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_11</td>
                    <td >10W Cabinet (Dry)</td>
                    <td >10
                    &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3649;&#3627;&#3657;&#3591;</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_12</td>
                    <td >10W Cabinet
                    (Temperature Control)</td>
                    <td >10W Cabinet
                    (Temperature Control)</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_13</td>
                    <td >10W Trailer</td>
                    <td >10W Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_14</td>
                    <td >10WWV</td>
                    <td >10WWV</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_15</td>
                    <td >12 M</td>
                    <td >Flatbed</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_16</td>
                    <td >12 METER Truck Test</td>
                    <td >12 METER Truck Test</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_17</td>
                    <td >12 TON</td>
                    <td >12 TON</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_18</td>
                    <td >12 Tonner</td>
                    <td >12 Ton</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_19</td>
                    <td >12 Tonner Split Deck</td>
                    <td >12 Tonner Split </td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_20</td>
                    <td >125MTRK</td>
                    <td >12.5M Truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_21</td>
                    <td >12M Trailer</td>
                    <td >12M Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_22</td>
                    <td >12Mtr Curtain trailer</td>
                    <td >12Mtr Curtain trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_23</td>
                    <td >12Mtr Flatbed trailer</td>
                    <td >12Mtr Flatbed trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_24</td>
                    <td >12T</td>
                    <td >12 Tonne Open Tray</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_25</td>
                    <td >12TA</td>
                    <td >12 Tonne Tautliner</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_26</td>
                    <td >13.5 CURTAINSIDE
                    TRUCK</td>
                    <td >JOHNSON &amp; JOHNSON
                    PRODUCTS</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_27</td>
                    <td >13.6 mtr trailer</td>
                    <td >Curtainsider
                    arctic/box trailer approx. 26 pallets</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_28</td>
                    <td >13M MEA-CLASSIC TRUCK</td>
                    <td >13M Truck + Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_29</td>
                    <td >13M Trailer</td>
                    <td >13M Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_30</td>
                    <td >13Mtr Box truck</td>
                    <td >13Mtr Box truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_31</td>
                    <td >13Mtr Curtain trailer</td>
                    <td >13Mtr Curtain trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_32</td>
                    <td >13Mtr Flatbed  trailer</td>
                    <td >13Mtr Flatbed  trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_33</td>
                    <td >13Mtr Reefer truck</td>
                    <td >13Mtr Reefer truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_34</td>
                    <td >14 Tonner</td>
                    <td >14 Tonner
                    Curtainsider</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_35</td>
                    <td >14M Trailer</td>
                    <td >14M Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_36</td>
                    <td >14T</td>
                    <td >14 tonne Open Tray</td>
                    <td ></td>
                   </tr>
                   <td ></td>
                   <tr >
                    <td>VEH_MAS_37</td>
                    <td >14TA</td>
                    <td >14 tonne Tautliner</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_38</td>
                    <td >14Tonner</td>
                    <td >Rigid Dropside</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_39</td>
                    <td >15M Trailer</td>
                    <td >15M Trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_40</td>
                    <td >15mtr Box truck</td>
                    <td >15mtr Box truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_41</td>
                    <td >15Mtr Curtain trailer</td>
                    <td >15Mtr Curtain trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_42</td>
                    <td >15Mtr Flatbed trailer</td>
                    <td >15Mtr Flatbed trailer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_43</td>
                    <td >16ft Container</td>
                    <td >16ft Container</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_44</td>
                    <td >17 ft Container</td>
                    <td >17 ft Container</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_45</td>
                    <td >17 FT Open Mazda</td>
                    <td >17 FT Open Mazda</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_46</td>
                    <td >18t with tail lift</td>
                    <td >Curtainsider
                    arctic/box trailer approx. 16 pallets</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_47</td>
                    <td >18W Cabinet</td>
                    <td >18W Cabinet</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_48</td>
                    <td >18W Cabinet (Dry)</td>
                    <td >18
                    &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3649;&#3627;&#3657;&#3591;</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_49</td>
                    <td >1T</td>
                    <td >1 Tonne Open Tray</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_50</td>
                    <td >1V</td>
                    <td >1 Tonne Van</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_51</td>
                    <td >2 Tonner Reefer</td>
                    <td >2 Tonner Reefer</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_52</td>
                    <td >2.0T</td>
                    <td >2.0T</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_53</td>
                    <td >20 Feet Truck</td>
                    <td >20 feet Truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_54</td>
                    <td >20 FT CONTAINER</td>
                    <td >20 FT CONTAINER</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_55</td>
                    <td >20DC - VN</td>
                    <td >20DC - VN</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_56</td>
                    <td >20FT container - Flat
                    track</td>
                    <td >20FT container - Flat
                    track</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_57</td>
                    <td >20FT container - Open
                    TOP</td>
                    <td >20FT container - Open
                    TOP</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_58</td>
                    <td >20FT CONTAINER -HC</td>
                    <td >20FT CONTAINER -HC</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_59</td>
                    <td >20FT container – GP</td>
                    <td >20FT container – GP</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_60</td>
                    <td >20ft Flatbed</td>
                    <td >Flatbed 20ft
                    container body</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_61</td>
                    <td >20ft Mazda Container</td>
                    <td >20ft Mazda Container</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_62</td>
                    <td >20ft Open Mazda</td>
                    <td >20ft Open Mazda</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_63</td>
                    <td >22ft Open Mazda</td>
                    <td >22ft Open Mazda</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_64</td>
                    <td >25 ft Containers</td>
                    <td >25 ft Containers</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_65</td>
                    <td >26t with tail lift</td>
                    <td >Curtainsider
                    arctic/box trailer approx. 18 pallets</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_66</td>
                    <td >2T</td>
                    <td >2 Tonne Open-Tray</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_67</td>
                    <td >2V</td>
                    <td >2 Tonne Van</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_68</td>
                    <td >3 Ton pick-up</td>
                    <td >3 Ton pick-up</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_69</td>
                    <td >3.5t electric van</td>
                    <td >3.5t electric van</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_70</td>
                    <td >32 FT SXL</td>
                    <td >32 FT SXL</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_71</td>
                    <td >33 T temperature
                    control</td>
                    <td >33 T temperature
                    control</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_72</td>
                    <td >33 T with temperature
                    control</td>
                    <td > Big truck of 33T + TC management between 5°
                    to 15°</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_73</td>
                    <td >33 ton transport
                    truck</td>
                    <td >33 ton transport
                    truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_74</td>
                    <td >3T - Box Trcuk</td>
                    <td >3Ton Box Truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_75</td>
                    <td >3V</td>
                    <td >3 Pallet Van</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_76</td>
                    <td >4 TON</td>
                    <td >4 TON</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_77</td>
                    <td >4 Tonner</td>
                    <td >4 Ton</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_78</td>
                    <td >4 Tonner Reefer</td>
                    <td >Refrigerated truck</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_79</td>
                    <td >4 Wheeler Cabinet</td>
                    <td >4 Wheeler Cabinet</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_80</td>
                    <td >4 Wheeler Small</td>
                    <td >4 Wheeler Small</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_81</td>
                    <td >4 Wheeler Tailgate</td>
                    <td >FOUR_WHEELER</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_82</td>
                    <td >40 FT REEFER BARATA
                    TRUCK</td>
                    <td >40 FT REEFER BARATA
                    TRUCK</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_83</td>
                    <td >40' </td>
                    <td >GENSET</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_84</td>
                    <td >40ft Box Truck</td>
                    <td >40ft Box Truck - Side
                    Doors</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_85</td>
                    <td >40FT container - Flat
                    Track</td>
                    <td >40FT container - Flat
                    Track</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_86</td>
                    <td >40FT container - HC</td>
                    <td >40FT container - HC</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_87</td>
                    <td >40FT container - Open
                    Top</td>
                    <td >40FT container - Open
                    Top</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_88</td>
                    <td >40FT CONTAINER -HC</td>
                    <td >40FT CONTAINER -HC</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_89</td>
                    <td >40FT container – GP</td>
                    <td >40FT container – GP</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_90</td>
                    <td >40ft Curtain Slider</td>
                    <td >40ft Curtain Sider</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_91</td>
                    <td >40HC - VN</td>
                    <td >40HC - VN</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_92</td>
                    <td >40HQ</td>
                    <td >40HQ</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_93</td>
                    <td >45ft curtain side</td>
                    <td >45ft curtain side</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_94</td>
                    <td >45FT TRUCK BOX</td>
                    <td >45FT SMART TRUCK WITH
                    E-LOCK</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_95</td>
                    <td >4T</td>
                    <td >4 Tonne Open Tray</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_96</td>
                    <td >4TA</td>
                    <td >4 Tonne Tautliner</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_97</td>
                    <td >4W</td>
                    <td >4 Wheelers</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_98</td>
                    <td >4W Cabinet</td>
                    <td >4W Cabinet</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <td>VEH_MAS_99</td>
                    <td >4W Cabinet
                    (Temperature Control)</td>
                    <td >4W Cabinet
                    (Temperature Control)</td>
                    <td ></td>
                    <td ></td>
                   </tr>
                   <tr >
                    <tr >
                      <td>VEH_MAS_100</td>
                      <td >4W Jumbo Cabinet</td>
                      <td >4
                      &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3592;&#3633;&#3617;&#3650;&#3610;&#3657;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_101</td>
                      <td >5.0T</td>
                      <td >5.0T</td>
                      <td ></td> <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_102</td>
                      <td >6 Wheel Rigid</td>
                      <td >6 Wheel Rigid</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_103</td>
                      <td >6 Wheeler Cabinet</td>
                      <td >6 Wheeler Cabinet</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_104</td>
                      <td >6 Wheeler Tailgate</td>
                      <td >SIX_WHEELER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_105</td>
                      <td >6 WHEELER TRUCK</td>
                      <td >6 WHEELER TRUCK</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_106</td>
                      <td >6T</td>
                      <td >6 Tonne Open Tray</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_107</td>
                      <td >6TA</td>
                      <td >6 Tonne Tautliner</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_108</td>
                      <td >6W</td>
                      <td >6W</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_109</td>
                      <td >6W (REEFER)</td>
                      <td >6W (REEFER)</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_110</td>
                      <td >6W Cabinet</td>
                      <td >6W Cabinet</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_111</td>
                      <td >6W Cabinet
                      (Temperature Control)</td>
                      <td >6W Cabinet
                      (Temperature Control)</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_112</td>
                      <td >6W REEFER</td>
                      <td >6W REEFER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_113</td>
                      <td >6WF</td>
                      <td >6WF</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_114</td>
                      <td >7 Ton pick-up</td>
                      <td >7 Ton pick-up</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_115</td>
                      <td >7.5t with loading
                      ramp</td>
                      <td >6mtr box trailer
                      approx. 10 pallets</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_116</td>
                      <td >7.5T with tail lift</td>
                      <td >With Tail Lift</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_117</td>
                      <td >8 TON</td>
                      <td >8 TON</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_118</td>
                      <td >8 Tonner</td>
                      <td >8 Tonner curtainside</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_119</td>
                      <td >8 Tonner reefer</td>
                      <td >8 ton reefer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_120</td>
                      <td >8T</td>
                      <td >8 Tonne Open Tray</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_121</td>
                      <td >8TA</td>
                      <td >8 Tonne Tautliner</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_122</td>
                      <td >Air Ride Truck</td>
                      <td >Prime Mover Truck for
                      Specialised Haulage</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_123</td>
                      <td >Artic Curtain</td>
                      <td >Artic Curtain</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_124</td>
                      <td >Ashok Leyland TAURUS</td>
                      <td >Ashok Leyland TAURUS</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_125</td>
                      <td >AUV</td>
                      <td >AUV</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_126</td>
                      <td >BD eTNKNBOM</td>
                      <td >BlueDart</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_127</td>
                      <td >BD Vehicle Type</td>
                      <td >BD Vehicle Type</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_128</td>
                      <td >Blind Van</td>
                      <td >Blind Van</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_129</td>
                      <td >BM_Jumbo Trailer
                      Truck</td>
                      <td >Trucks w. 38 Pallets
                      capacity</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_130</td>
                      <td >Box trailer</td>
                      <td >Box trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_131</td>
                      <td >Box-Textile-Mega
                      trailer – 2.85 height</td>
                      <td >Box-Textile-Mega
                      trailer – 2.85 height</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_132</td>
                      <td >CALX</td>
                      <td >CALX</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_133</td>
                      <td >Calyx</td>
                      <td >Calyx</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_134</td>
                      <td >CAR</td>
                      <td >small Parcels/Boxes</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_135</td>
                      <td >CAR CARRIER</td>
                      <td >CAR CARRIER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_136</td>
                      <td >CDD</td>
                      <td >Colt Diesel Double</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_137</td>
                      <td >CDD Long</td>
                      <td >CDD Long</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_138</td>
                      <td >CDD Reefer</td>
                      <td >CDD Reefer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_139</td>
                      <td >CDDL Reefer</td>
                      <td >CDDL Reefer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_140</td>
                      <td >CDE</td>
                      <td >Colt Diesel Engkel</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_141</td>
                      <td >CDE Long</td>
                      <td >CDE Long</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_142</td>
                      <td >CDE Reefer</td>
                      <td >CDE Reefer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_143</td>
                      <td >Class7_5</td>
                      <td >Truck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_144</td>
                      <td >Closed Dyna</td>
                      <td >Closed Dyna</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_145</td>
                      <td >Curtain Truck &amp;
                      Trailer</td>
                      <td >Curtain Truck &amp;
                      Trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_146</td>
                      <td >CUSTOMS &amp;
                      BROKERAGE</td>
                      <td >CUSTOMS &amp;
                      BROKERAGE</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_147</td>
                      <td >DEFAULT</td>
                      <td >DEFAULT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_148</td>
                      <td >Diptab Venture</td>
                      <td >Diptab Venture</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_149</td>
                      <td >EDI</td>
                      <td >EDI</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_150</td>
                      <td >EDI TRUCK</td>
                      <td >EDI TRUCK</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_151</td>
                      <td >EICHER 50_TRAILER</td>
                      <td >EICHER 50' TRAILER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_152</td>
                      <td >eTNKNBOM</td>
                      <td >eTNKNBOM</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_153</td>
                      <td >FB Unit</td>
                      <td >FB Unit</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_154</td>
                      <td >FlatBed  Truck</td>
                      <td >FlatBed  Truck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_155</td>
                      <td >Frigo trailer</td>
                      <td >Frigo trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_156</td>
                      <td >Frigo trailer - 2.70m
                      height</td>
                      <td >Frigo trailer - 2.70m
                      height</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_157</td>
                      <td >Frigo trailer - Bi
                      thermo</td>
                      <td >Frigo trailer - Bi
                      thermo</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_158</td>
                      <td >Frigo trailer -
                      Double deck</td>
                      <td >Frigo trailer -
                      Double deck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_159</td>
                      <td >Frigo trailer -
                      Double tech bi thermo</td>
                      <td >Frigo trailer -
                      Double tech bi thermo</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_160</td>
                      <td >FTL</td>
                      <td >FTL</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_161</td>
                      <td >FUSO</td>
                      <td >FUSO</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_162</td>
                      <td >Fuso Lossbak</td>
                      <td >Fuso Lossbak</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_163</td>
                      <td >Fuso Reefer</td>
                      <td >Fuso Reefer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_164</td>
                      <td >Fuso Wing</td>
                      <td >Fuso Wing</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_165</td>
                      <td >GEETEE</td>
                      <td >GEETEE</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_166</td>
                      <td >Grand Max</td>
                      <td >Grand Max</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_167</td>
                      <td >GUY KNOWLES</td>
                      <td >GUY KNOWLES</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_168</td>
                      <td >Hard Body Reefer 1,5
                      T Tapa 1 i Low Value</td>
                      <td >Dimensions:
                      4,2/ok.2/ok.2</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_169</td>
                      <td >Hard Body Reefer 24 T
                      Tapa 1 i Low Value</td>
                      <td >Dimensions:
                      13,6/2,45/,2,7</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_170</td>
                      <td >Hard Body Reefer 3,5
                      T Tapa 1 i Low Value</td>
                      <td >Dimensions:
                      6,2/2,45/2,5</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_171</td>
                      <td >Hard Body Reefer 8 T
                      Tapa 1</td>
                      <td >Dimensions:
                      ok.7,3/2,45/ok.2,5</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_172</td>
                      <td >Hard Body – 24 Tons</td>
                      <td >Dimensions:
                      13,6/2,45/,2,7</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_173</td>
                      <td >HUB_12FT</td>
                      <td >HUB_12FT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_174</td>
                      <td >HUB_24FT</td>
                      <td >HUB_24FT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_175</td>
                      <td >HUB_40FT</td>
                      <td >HUB_40FT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_176</td>
                      <td >HUB_VAN</td>
                      <td >HUB_VAN</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_177</td>
                      <td >JBS_24_EQP</td>
                      <td >JBS_24_EQP</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_178</td>
                      <td >JCB</td>
                      <td >JCB</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_179</td>
                      <td >JUMBO</td>
                      <td >CLOSE</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_180</td>
                      <td >KN_CANTER_17FT</td>
                      <td >KN_CANTER_17FT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_181</td>
                      <td >Kunal</td>
                      <td >Caparo</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_182</td>
                      <td >LOWBED</td>
                      <td >Lowbed</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_183</td>
                      <td >Lowbed ART</td>
                      <td >Lowbed ART</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_184</td>
                      <td >Lowbed Trailer</td>
                      <td >LOWBED_TRAILER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_185</td>
                      <td >Lowbed Truck</td>
                      <td >Lowbed Truck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_186</td>
                      <td >LTL NETWORK</td>
                      <td >LTL NETWORK</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_187</td>
                      <td >LUTON WITH TAIL LIFT</td>
                      <td >LUTON WITH TAIL LIFT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_188</td>
                      <td >MANUAL</td>
                      <td >MANUAL</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_189</td>
                      <td >Mega Trailer – 2.85m
                      height</td>
                      <td >Mega Trailer – 2.85m
                      height</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_190</td>
                      <td >Mega Trailer – 3m
                      height</td>
                      <td >Mega Trailer – 3m
                      height</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_191</td>
                      <td >Myntra 8500780416</td>
                      <td >Keshu Spoton Vendor</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_192</td>
                      <td >Myntra eTNKNBOM</td>
                      <td >R0001</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_193</td>
                      <td >MYTRUX</td>
                      <td >MYTRUX</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_194</td>
                      <td >Normal Lowbed</td>
                      <td >Normal Lowbed</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_195</td>
                      <td >Optima Trailer</td>
                      <td >Optima Trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_196</td>
                      <td >PALLETIZED ONLY</td>
                      <td >PALLETIZED ONLY</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_197</td>
                      <td >PICKUP 1 TON</td>
                      <td >1 TONS </td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_198</td>
                      <td >PICKUP 2 TONS</td>
                      <td >2 TONS TRUCK</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_199</td>
                      <td >PICKUP 3 TONS</td>
                      <td >3 TONS PICKUP</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_200</td>
                      <td >POLO GANAPTI</td>
                      <td >POLO</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_201</td>
                      <td >Prime Mover</td>
                      <td >Prime Mover Truck for
                      haulage</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_202</td>
                      <td >R0001</td>
                      <td >R0001</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_203</td>
                      <td >R0002</td>
                      <td >R0002</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_204</td>
                      <td >R02</td>
                      <td >R02</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_205</td>
                      <td >R03</td>
                      <td >R03</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_206</td>
                      <td >R04</td>
                      <td >R04</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_207</td>
                      <td >R10</td>
                      <td >R10</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_208</td>
                      <td >R3</td>
                      <td >R3</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_209</td>
                      <td >R40</td>
                      <td >R40</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_210</td>
                      <td >Reefer Dyana</td>
                      <td >Dyana RF</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_211</td>
                      <td >Reefer Trailer</td>
                      <td >Reefer Trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_212</td>
                      <td >Reefer Truck</td>
                      <td >Reefer Truck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_213</td>
                      <td >Rigid Curtainsider</td>
                      <td >Rigid Curtainsider</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_214</td>
                      <td >Rigid Tail Lift</td>
                      <td >Rigid Tail Lift</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_215</td>
                      <td >RLS</td>
                      <td >RLS</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_216</td>
                      <td >Roller Deck</td>
                      <td >Roller Deck</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_217</td>
                      <td >Safeexpress</td>
                      <td >Safeexpress</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_218</td>
                      <td >SEMI</td>
                      <td >semi trailer</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_219</td>
                      <td >Sideloader</td>
                      <td >Sideloader</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_220</td>
                      <td >SIDHHI</td>
                      <td >SIDHHI</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_221</td>
                      <td >Special Lowbed</td>
                      <td >Special Lowbed</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_222</td>
                      <td >ST</td>
                      <td >Small Tray to 500 kg</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_223</td>
                      <td >SUPER LINK </td>
                      <td >SUPER LINK </td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_224</td>
                      <td >SUV</td>
                      <td >FURNWARE TRANSPORT</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_225</td>
                      <td >Suzuki Pickup</td>
                      <td >Suzuki Pickup</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_226</td>
                      <td >SV</td>
                      <td >Small Van to 250 kg</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_227</td>
                      <td >SW</td>
                      <td >Station Wagon</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_228</td>
                      <td >SYMBI</td>
                      <td >SYMBI</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_229</td>
                      <td >T13</td>
                      <td >T13</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_230</td>
                      <td >TAIL LIFT TRUCK</td>
                      <td >TAIL LIFT TRUCK</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_231</td>
                      <td >Tarpaulin Tilt 24 T
                      Tapa 3 i Low Value</td>
                      <td >Dimensions:
                      13,6/2,45/,2,7</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_232</td>
                      <td >Tarpaulin Tilt 3,5 T
                      Low Value</td>
                      <td >Dimensions:
                      6,2/2,45/2,5</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_233</td>
                      <td >Tarpaulin Tilt 6 T
                      Low Value</td>
                      <td >Dimensions: ok
                      6,2/2,45/ok.2,5</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_234</td>
                      <td >TATA 1109</td>
                      <td >TATA 1109</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_235</td>
                      <td >TATA 40_TRAILER</td>
                      <td >TATA 40' TRAILER</td>
                      <td ></td><td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_236</td>
                      <td >TATA 50_TRAILER</td>
                      <td >TATA 50' TRAILER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_237</td>
                      <td >TATA 55_TRAILER</td>
                      <td >TATA 55' TRAILER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_238</td>
                      <td >TATA 70_TRAILER</td>
                      <td >TATA 70' TRAILER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_239</td>
                      <td >TATA ACE</td>
                      <td >TATA ACE</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_240</td>
                      <td >TATA LBT</td>
                      <td >TATA LBT</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_241</td>
                      <td >TATA OT</td>
                      <td >TATA O.T</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_242</td>
                      <td >TCI</td>
                      <td >tci</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_243</td>
                      <td >TCISITA</td>
                      <td >SITA</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_244</td>
                      <td >TEMPERATURE-CONTROL-TRK-15FT-5TONNER</td>
                      <td >TEMPERATURE-CONTROL-TRK-15FT-5TONNER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_245</td>
                      <td >Test vehicle 1</td>
                      <td >Test vehicle 1</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_246</td>
                      <td >Test2-6</td>
                      <td >TEST</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_247</td>
                      <td >TESTTRUCK_AJ2</td>
                      <td >Test truck type </td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_248</td>
                      <td >TRACTOR HEAD</td>
                      <td >TRACTOR HEAD</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_249</td>
                      <td >Trailer 20FT</td>
                      <td >Trailer 20FT</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_250</td>
                      <td >Trailer 20FT Reefer</td>
                      <td >Trailer 20FT Reefer</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_251</td>
                      <td >Trailer 40FT</td>
                      <td >Trailer 40FT</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_252</td>
                      <td >Trailer 40FT Reefer</td>
                      <td >Trailer 40FT Reefer</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_253</td>
                      <td >Trailer Container 20</td>
                      <td >FLATBED_TRAILER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_254</td>
                      <td >Trailer Container 40</td>
                      <td >FLATBED_TRAILER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_255</td>
                      <td >TRI AXLE</td>
                      <td >TRI AXLE</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_256</td>
                      <td >Triaxle Genset</td>
                      <td >Triaxle Genset</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_257</td>
                      <td >TRK-BOX-10FT-1TONNER</td>
                      <td >TRK-BOX-10FT-1TONNER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_258</td>
                      <td >TRK-BOX-20FT-10TONNER</td>
                      <td >TRK-BOX-20FT-10TONNER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_259</td>
                      <td >TRK-REEFER-15FT-5TONNER</td>
                      <td >TRK-REEFER-15FT-5TONNER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_260</td>
                      <td >TRK-REEFER-20FT-10TONNER</td>
                      <td >TRK-REEFER-20FT-10TONNER</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_261</td>
                      <td >Tronton</td>
                      <td >Tronton</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_262</td>
                      <td >Tronton Lossbak</td>
                      <td >Tronton Lossbak</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_263</td>
                      <td >Tronton Reefer</td>
                      <td >Tronton Reefer</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_264</td>
                      <td >Truck</td>
                      <td >Truck</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_265</td>
                      <td >TRUCK 5 TONS</td>
                      <td >5 TONS TRUCK</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_266</td>
                      <td >TRUCK BOX 10FT</td>
                      <td >Truck with 10ft Box
                      Fully covered</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_267</td>
                      <td >TRUCK BOX 14FT</td>
                      <td >Truck with 14ft Box
                      Fully covered</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_268</td>
                      <td >TRUCK BOX 24FT</td>
                      <td >Truck with 24ft Box
                      Fully covered</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_269</td>
                      <td >TRUCK BOX 40FT</td>
                      <td >TRUCK BOX 40FT</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_270</td>
                      <td >TRUCK REEFER 40FT</td>
                      <td >TRUCK REEFER 40FT</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_271</td>
                      <td >USTDTRK</td>
                      <td >Unstandardized Truck</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_272</td>
                      <td >UZ 32 FT TEMP
                      CONTROL </td>
                      <td >UZ 32 FT TEMP
                      CONTROL </td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_273</td>
                      <td >Van Diesel</td>
                      <td >Van propel by diesel</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_274</td>
                      <td >Van Electric</td>
                      <td >Van propel by full
                      electric power</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_275</td>
                      <td >Véhicule porteur
                      Température Dirigé à 2 essieux</td>
                      <td >Véhicule porteur
                      Température Dirigé à 2 essieux</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_276</td>
                      <td >VW</td>
                      <td >VW</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_277</td>
                      <td >west pharma</td>
                      <td >west pharma</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_278</td>
                      <td >WHEELIE BINS ONLY</td>
                      <td >WHEELIE BINS ONLY</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_279</td>
                      <td >WILL TRUCK TYPE</td>
                      <td >WILL TRUCK TYPE</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_280</td>
                      <td >Wing Box</td>
                      <td >Wing Box</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_281</td>
                      <td >Wing Box Reefer</td>
                      <td >Wing Box Reefer</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_282</td>
                      <td >Wingbox Tronton</td>
                      <td >Wingbox Tronton</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_283</td>
                      <td >Yati</td>
                      <td >Return</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_284</td>
                      <td >ZC4320</td>
                      <td >ZC4320</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_285</td>
                      <td >ZD 6439</td>
                      <td >ZD 6439</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_286</td>
                      <td >ZD 9557</td>
                      <td >ZD 9557</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_287</td>
                      <td >ZD 9951</td>
                      <td >ZD 9951</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_288</td>
                      <td >ZD9895</td>
                      <td >ZD9895</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_289</td>
                      <td >ZD9896</td>
                      <td >ZD9896</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_290</td>
                      <td >ZD9897</td>
                      <td >ZD9897</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_291</td>
                      <td >ZE 0561</td>
                      <td >ZE 0561</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_292</td>
                      <td >ZE 3421</td>
                      <td >ZE 3421</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_293</td>
                      <td >ZE0562</td>
                      <td >ZE0562</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_294</td>
                      <td >ZE0741</td>
                      <td >ZE0741</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_295</td>
                      <td >ZE2230</td>
                      <td >ZE2230</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_296</td>
                      <td >ZE2231</td>
                      <td >ZE2231</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_297</td>
                      <td >ZE2232</td>
                      <td >ZE2232</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_298</td>
                      <td >ZE2368</td>
                      <td >ZE2368</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_299</td>
                      <td >ZE2439</td>
                      <td >ZE2439</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_300</td>
                      <td >ZE2440</td>
                      <td >ZE2440</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_301</td>
                      <td >ZE2695</td>
                      <td >ZE2695</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_302</td>
                      <td >ZE2696</td>
                      <td >ZE2696</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_303</td>
                      <td >ZE2697</td>
                      <td >ZE2697</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_304</td>
                      <td >ZE2698</td>
                      <td >ZE2698</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_305</td>
                      <td >ZE3423</td>
                      <td >ZE3423</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_306</td>
                      <td >ZE4500</td>
                      <td >ZE4500</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_307</td>
                      <td >ZE5110</td>
                      <td >ZE5110</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_308</td>
                      <td >ZE5115</td>
                      <td >ZE5115</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_309</td>
                      <td >ZE5174</td>
                      <td >ZE5174</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_310</td>
                      <td >ZF 2214</td>
                      <td >ZF 2214</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_311</td>
                      <td >ZF 2521</td>
                      <td >ZF 2521</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_312</td>
                      <td >ZF 2694</td>
                      <td >ZF 2694</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_313</td>
                      <td >ZF 2786</td>
                      <td >ZF 2786</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_314</td>
                      <td >ZF 2790</td>
                      <td >ZF 2790</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_315</td>
                      <td >ZF 2934</td>
                      <td >ZF 2934</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_316</td>
                      <td >ZF 3347</td>
                      <td >ZF 3347</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_317</td>
                      <td >ZF 4879</td>
                      <td >ZF 4879</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_318</td>
                      <td >ZF 4885</td>
                      <td >ZF 4885</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_319</td>
                      <td >ZF 5061</td>
                      <td >ZF 5061</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_320</td>
                      <td >ZF 5062</td>
                      <td >ZF 5062</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_321</td>
                      <td >ZF 5073</td>
                      <td >ZF 5073</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_322</td>
                      <td >ZF 5261</td>
                      <td >ZF 5261</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_323</td>
                      <td >ZF2215</td>
                      <td >ZF2215</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_324</td>
                      <td >ZF2785</td>
                      <td >ZF2785</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_325</td>
                      <td >ZF2788</td>
                      <td >ZF2788</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_326</td>
                      <td >ZF2789</td>
                      <td >ZF2789</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_327</td>
                      <td >ZF2935</td>
                      <td >ZF2935</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_328</td>
                      <td >ZF4761</td>
                      <td >ZF4761</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_329</td>
                      <td >ZF4764</td>
                      <td >ZF4764</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_330</td>
                      <td >ZF5056</td>
                      <td >ZF5056</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_331</td>
                      <td >ZF5057</td>
                      <td >ZF5057</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_332</td>
                      <td >ZF5058</td>
                      <td >ZF5058</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_333</td>
                      <td >ZF5059</td>
                      <td >ZF5059</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_334</td>
                      <td >ZF5065</td>
                      <td >ZF5065</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_335</td>
                      <td >ZF5068</td>
                      <td >ZF5068</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_336</td>
                      <td >ZF5075</td>
                      <td >ZF5075</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_337</td>
                      <td >ZF5076</td>
                      <td >ZF5076</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_338</td>
                      <td >ZF5078</td>
                      <td >ZF5078</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_339</td>
                      <td >ZF5080</td>
                      <td >ZF5080</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_340</td>
                      <td >ZF5083</td>
                      <td >ZF5083</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_341</td>
                      <td >ZF5084</td>
                      <td >ZF5084</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_342</td>
                      <td >ZF5257</td>
                      <td >ZF5257</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_343</td>
                      <td >ZF6020</td>
                      <td >ZF6020</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_344</td>
                      <td >ZF6024</td>
                      <td >ZF6024</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_345</td>
                      <td >ZF6025</td>
                      <td >ZF6025</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_346</td>
                      <td >ZF6026</td>
                      <td >ZF6026</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_347</td>
                      <td >ZF6027</td>
                      <td >ZF6027</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_348</td>
                      <td >ZF6080</td>
                      <td >ZF6080</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_349</td>
                      <td >ZF6082</td>
                      <td >ZF6082</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_350</td>
                      <td >ZF6085</td>
                      <td >ZF6085</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_351</td>
                      <td >ZF6440</td>
                      <td >ZF6440</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_352</td>
                      <td >ZF6442</td>
                      <td >ZF6442</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_353</td>
                      <td >ZF6443</td>
                      <td >ZF6443</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_354</td>
                      <td >ZF6444</td>
                      <td >ZF6444</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_355</td>
                      <td >ZF6445</td>
                      <td >ZF6445</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_356</td>
                      <td >ZF6446</td>
                      <td >ZF6446</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_357</td>
                      <td >ZF6447</td>
                      <td >ZF6447</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_358</td>
                      <td >ZF6449</td>
                      <td >ZF6449</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_359</td>
                      <td >ZF6451</td>
                      <td >ZF6451</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_360</td>
                      <td >ZF6452</td>
                      <td >ZF6452</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_361</td>
                      <td >ZF6453</td>
                      <td >ZF6453</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_362</td>
                      <td >ZF6454</td>
                      <td >ZF6454</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_363</td>
                      <td >ZF6455</td>
                      <td >ZF6455</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_364</td>
                      <td >ZF6456</td>
                      <td >ZF6456</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_365</td>
                      <td >ZF6464</td>
                      <td >ZF6464</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_366</td>
                      <td >ZF6465</td>
                      <td >ZF6465</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_367</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      0,5t / 3 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      0,5t / 3 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_368</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      1,5t / 10 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      1,5t / 10 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_369</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      10t / 36 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      10t / 36 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_370</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_371</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      15t / 50 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      15t / 50 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_372</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_373</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      20t / 82 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      20t / 82 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_374</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      20t / 82 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      20t / 82 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_375</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      3t / 16 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      3t / 16 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_376</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_377</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      5t / 22 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      5t / 22 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_378</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1041;&#1086;&#1082;&#1089;
                      5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_379</td>
                      <td >&#1050;&#1086;&#1085;&#1090;&#1077;&#1081;&#1085;&#1077;&#1088;
                      20ft</td>
                      <td >&#1050;&#1086;&#1085;&#1090;&#1077;&#1081;&#1085;&#1077;&#1088;
                      20ft</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_380</td>
                      <td >&#1050;&#1086;&#1085;&#1090;&#1077;&#1081;&#1085;&#1077;&#1088;
                      40ft</td>
                      <td >&#1050;&#1086;&#1085;&#1090;&#1077;&#1081;&#1085;&#1077;&#1088;
                      40ft</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_381</td>
                      <td >&#1057;&#1087;&#1077;&#1094;&#1080;&#1072;&#1083;&#1080;&#1079;&#1080;&#1088;&#1086;&#1074;&#1072;&#1085;&#1085;&#1099;&#1081;
                      &#1090;&#1088;&#1072;&#1082;</td>
                      <td >&#1057;&#1087;&#1077;&#1094;&#1080;&#1072;&#1083;&#1080;&#1079;&#1080;&#1088;&#1086;&#1074;&#1072;&#1085;&#1085;&#1099;&#1081;
                      &#1090;&#1088;&#1072;&#1082;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_382</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      20&#1090; 110 &#1082;&#1091;&#1073; &#1084; &#1089;
                      &#1079;&#1072;&#1076;&#1085;&#1077;&#1081;
                      &#1079;&#1072;&#1075;&#1088;&#1091;&#1079;&#1082;&#1086;&#1081;
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;
                      (&#1090;&#1103;&#1075;&#1072;&#1095; +
                      &#1087;&#1086;&#1083;&#1091;&#1087;&#1088;&#1080;&#1094;&#1077;&#1087;)</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      20&#1090; 110 &#1082;&#1091;&#1073; &#1084; &#1089;
                      &#1079;&#1072;&#1076;&#1085;&#1077;&#1081;
                      &#1079;&#1072;&#1075;&#1088;&#1091;&#1079;&#1082;&#1086;&#1081;
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;
                      (&#1090;&#1103;&#1075;&#1072;&#1095; +
                      &#1087;&#1086;&#1083;&#1091;&#1087;&#1088;&#1080;&#1094;&#1077;&#1087;)</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_383</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      20&#1090; 120 &#1082;&#1091;&#1073; &#1084; &#1089;
                      &#1079;&#1072;&#1076;&#1085;&#1077;&#1081;
                      &#1079;&#1072;&#1075;&#1088;&#1091;&#1079;&#1082;&#1086;&#1081;
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;
                      (&#1084;&#1072;&#1096;&#1080;&#1085;&#1072; +
                      &#1087;&#1088;&#1080;&#1094;&#1077;&#1087;)</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      20&#1090; 120 &#1082;&#1091;&#1073; &#1084; &#1089;
                      &#1079;&#1072;&#1076;&#1085;&#1077;&#1081;
                      &#1079;&#1072;&#1075;&#1088;&#1091;&#1079;&#1082;&#1086;&#1081;
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;
                      (&#1084;&#1072;&#1096;&#1080;&#1085;&#1072; +
                      &#1087;&#1088;&#1080;&#1094;&#1077;&#1087;)</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_384</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1040;&#1074;&#1090;&#1086;&#1087;&#1086;&#1077;&#1079;&#1076;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 120 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1040;&#1074;&#1090;&#1086;&#1087;&#1086;&#1077;&#1079;&#1076;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 120 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_385</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_386</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_387</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_388</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_389</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_390</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_391</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1073;&#1086;&#1082;&#1086;&#1074;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_392</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_393</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_394</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_395</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_396</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_397</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_398</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_399</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 92 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 92 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_400</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_401</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_402</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_403</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1079;&#1072;&#1076;&#1085;&#1103;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_404</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 0,5t / 3 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_405</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 1,5t / 10 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_406</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 10t / 36 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_407</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 15t / 50 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_408</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 20t / 82 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_409</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 3t / 16 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_410</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079; &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1085;&#1090;
                      &#1083;&#1102;&#1073;&#1072;&#1103;
                      &#1087;&#1086;&#1075;&#1088;&#1091;&#1079;&#1082;&#1072; 5t / 22 cbm
                      &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_411</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      0,5t / 3 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      0,5t / 3 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_412</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      1,5t / 10 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      1,5t / 10 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_413</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      1,5t / 10 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      1,5t / 10 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_414</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      10t / 36 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      10t / 36 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_415</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      10t / 36 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_416</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      15t / 50 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      15t / 50 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_417</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      15t / 50 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_418</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      20t / 82 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      20t / 82 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_419</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      3t / 16 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      3t / 16 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                    </tr>
                     <tr >
                      <td>VEH_MAS_420</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      3t / 16 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_421</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      5t / 22 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      5t / 22 cbm &#1073;&#1077;&#1079;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1072;</td>
                      <td ></td>
                      <td ></td>
                     </tr>
                     <tr >
                      <td>VEH_MAS_422</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td >&#1058;&#1077;&#1088;&#1084;&#1086;
                      5t / 22 cbm &#1089;
                      &#1075;&#1080;&#1076;&#1088;&#1086;&#1073;&#1086;&#1088;&#1090;&#1086;&#1084;</td>
                      <td ></td>
                      <td ></td>
                     </tr>

                  </Table>
              </li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="STSOUBSTSCD">
            <label for="STSOUBSTSCD">Status Code</label>
            <ul>
              <li>
                <h2>Code table: Status Code</h2>
                <Table border=0.5 style="color:black; width:100%;">
                  <tr style="background-color:lightgrey">
                    <td>ID</td>
                    <td>Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>Category&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr>
                    <td>CODE_01</td>
                    <td>0100</td>
                    <td>Booked by Supplier</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_02</td>
                    <td>0212</td>
                    <td>Accepted by Driver</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_03</td>
                    <td>2400</td>
                    <td>Planned Delivery Date</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_04</td>
                    <td>3000</td>
                    <td>Delivered to Consignee</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_05</td>
                    <td>3051</td>
                    <td>Attempted Delivery</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_06</td>
                    <td>9200</td>
                    <td>Shipment on Hold</td>
                    <td>Hold</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_07</td>
                    <td>9250</td>
                    <td>Shipment Released</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_08</td>
                    <td>3050</td>
                    <td>Delivery Refused</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_09</td>
                    <td>3002</td>
                    <td>Delivered with Discrepancies</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_10</td>
                    <td>3001</td>
                    <td>Delivery Not Successful</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_11</td>
                    <td>2490</td>
                    <td>Shipments Dispatched from Warehouse</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_12</td>
                    <td>2492</td>
                    <td>MANIFESTED</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_13</td>
                    <td>2491</td>
                    <td>SCANNED</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_14</td>
                    <td>1500</td>
                    <td>Customs Clearance Strated</td>
                    <td>Customs Filing</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_15</td>
                    <td>1510</td>
                    <td>Customs Clearance Strated at Depot</td>
                    <td>Customs Verification</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_16</td>
                    <td>1600</td>
                    <td>Customs Clearance Completed at Bor</td>
                    <td>Customs Cleared</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_17</td>
                    <td>1610</td>
                    <td>Customs Clearance Completed at Depot</td>
                    <td>Customs Cleared</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_18</td>
                    <td>1013</td>
                    <td>LOAD ON VESSEL</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_19</td>
                    <td>1014</td>
                    <td>UNLOAD OFF VESSEL</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_20</td>
                    <td>1012</td>
                    <td>Custom Clearence</td>
                    <td>Customs Cleared</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_21</td>
                    <td>0470</td>
                    <td>Manifested</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_22</td>
                    <td>2990</td>
                    <td>Shipment Received at Facility</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_23</td>
                    <td>0192</td>
                    <td>Gate In</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_24</td>
                    <td>2989</td>
                    <td>Pending</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_25</td>
                    <td>0106</td>
                    <td>Planned Pickup Date</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_26</td>
                    <td>1365</td>
                    <td>Cargo Unloaded At Customs Post</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_27</td>
                    <td>1300</td>
                    <td>Departed from terminal</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_28</td>
                    <td>0420</td>
                    <td>Gate In-Pick Up</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_29</td>
                    <td>2300</td>
                    <td>Gate Out-Delivery</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_30</td>
                    <td>1550</td>
                    <td>In-Transit</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_31</td>
                    <td>0062</td>
                    <td>Order pending</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_32</td>
                    <td>0120</td>
                    <td>Complaint: Damage</td>
                    <td>Hold</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_33</td>
                    <td>0142</td>
                    <td>Booking accepted by KN</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_34</td>
                    <td>0300</td>
                    <td>Ready at Supplier</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_35</td>
                    <td>0400</td>
                    <td>Pickup appointment Date Time</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_36</td>
                    <td>0490</td>
                    <td>Arrival at Collection Point</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_37</td>
                    <td>0500</td>
                    <td>Actual Pick Up</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_38</td>
                    <td>1000</td>
                    <td>Arrived Origin Depot</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_39</td>
                    <td>1010</td>
                    <td>Order Line Modified</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_40</td>
                    <td>1052</td>
                    <td>Orders allocated to container</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_41</td>
                    <td>1130</td>
                    <td>Arrived at Inland Terminal</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_42</td>
                    <td>1200</td>
                    <td>Expected Departure Date</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_43</td>
                    <td>1270</td>
                    <td>Arrived at Carrier Origin Ramp</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_44</td>
                    <td>1290</td>
                    <td>Linehaul Loaded</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_45</td>
                    <td>1327</td>
                    <td>Shipment Damaged</td>
                    <td>Hold</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_46</td>
                    <td>1375</td>
                    <td>Departed from Transit Port/Point</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_47</td>
                    <td>1380</td>
                    <td>Arrived Intermediate</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_48</td>
                    <td>1385</td>
                    <td>Departed Intermediate</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_49</td>
                    <td>1400</td>
                    <td>Arrival KN Depot</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_50</td>
                    <td>1450</td>
                    <td>Arrived Place of Delivery</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_51</td>
                    <td>1520</td>
                    <td>Returned to Origin / Sender</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_52</td>
                    <td>1564</td>
                    <td>Departure Pick-up Location</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_53</td>
                    <td>1577</td>
                    <td>ETA Delivery Location</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_54</td>
                    <td>1579</td>
                    <td>Free Time Expired at delivery loc.</td>
                    <td>Hold</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_55</td>
                    <td>1640</td>
                    <td>Arrived at Customs Terminal</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_56</td>
                    <td>2210</td>
                    <td>Release/Handover to 3rd Party</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_57</td>
                    <td>2333</td>
                    <td>Receipt Putaway Done</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_58</td>
                    <td>2340</td>
                    <td>Cntr Arrived at Consignee CY</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_59</td>
                    <td>2500</td>
                    <td>Estimated Delivery Date</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_60</td>
                    <td>2510</td>
                    <td>Consignee requires appointment</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_61</td>
                    <td>2525</td>
                    <td>Appointment made</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_62</td>
                    <td>2533</td>
                    <td>Delivery Delay - Weather Conditions</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_63</td>
                    <td>2600</td>
                    <td>Cartage Truck Departed</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_64</td>
                    <td>4210</td>
                    <td>B/L Instructions Recvd.from Shipper</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_65</td>
                    <td>5025</td>
                    <td>Shipment delayed due other reason</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_66</td>
                    <td>8653</td>
                    <td>Receiving Confirmed</td>
                    <td>Completed</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_67</td>
                    <td>8800</td>
                    <td>Expected Arrival at Receiving Depot</td>
                    <td>In-Transit</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_68</td>
                    <td>8850</td>
                    <td>Estimated Delivery Date</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_69</td>
                    <td>9610</td>
                    <td>Order Confirmed at KN Origin</td>
                    <td>Pending</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_70</td>
                    <td>9800</td>
                    <td>Shipment Cancelled</td>
                    <td>Cancel</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_71</td>
                    <td>1075</td>
                    <td>Booking Confirmed by Carrier</td>
                    <td>Active</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_72</td>
                    <td>EN03</td>
                    <td>Enroute to pickup delayed</td>
                    <td>Order Progress</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_73</td>
                    <td>EN02</td>
                    <td>Driver decline pickup enroute</td>
                    <td>Order Progress</td>
                    <td></td>
                   </tr>
                   <tr>
                    <td>CODE_74</td>
                    <td>EN01</td>
                    <td>Enroute to pickup </td>
                    <td>Order Progress</td>
                    <td></td>
                   </tr>
                </Table>
              </li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="STSTimeZone">
            <label for="STSTimeZone">TimeZone</label>
            <ul>
              <li>
                <h2>Code table : Timezone</h2>
                <Table border=0.5 style="color:black; width:100%;">
                  <tr style="background-color:lightgrey">
                    <td>ID</td>
                    <td>Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>CT_Time Zone Value&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr>
                    <td>TZCODE_01</td>
                    <td>SG</td>
                    <td>SINGAPORE</td>
                    <td>UTC +08:00</td>
                    <td>SINGAPORE</td>
                    <td>+8:00/SGST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_02</td>
                    <td>TH</td>
                    <td>THAILAND</td>
                    <td>UTC+07:00</td>
                    <td>THAILAND</td>
                    <td>+7:00/THST</td>
                   </tr>

                   <tr>
                    <td>TZCODE_03</td>
                    <td>MY</td>
                    <td>MALAYSIA</td>
                    <td>UTC+08:00</td>
                    <td>MALAYSIA</td>
                    <td>+8:00/MYST</td>
                   </tr>

                   <tr>
                    <td>TZCODE_04</td>
                    <td>VN</td>
                    <td>VIETNAM</td>
                    <td>UTC+07:00</td>
                    <td>VIETNAM</td>
                    <td>+7:00/VNST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_05</td>
                    <td>TW</td>
                    <td>TAIWAN</td>
                    <td>UTC+08:00</td>
                    <td>TAIWAN</td>
                    <td>+8:00/TWST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_06</td>
                    <td>CN</td>
                    <td>CHINA</td>
                    <td>UTC+08:00</td>
                    <td>CHINA</td>
                    <td>+8:00/CNST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_07</td>
                    <td>ID</td>
                    <td>INDONESIA</td>
                    <td>UTC+07:00</td>
                    <td>INDONESIA</td>
                    <td>+7:00/IDST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_08</td>
                    <td>PH</td>
                    <td>PHILIPPINES</td>
                    <td>UTC+08:00</td>
                    <td>PHILIPPINES</td>
                    <td>+8:00/PHST</td>
                   </tr>
                   <tr>
                    <td>TZCODE_09</td>
                    <td>KHKN</td>
                    <td>CAMBODIA</td>
                    <td>UTC+07:00</td>
                    <td>CAMBODIA</td>
                    <td>+7:00/KHKNST</td>
                </Table>
              </li>
            </ul>
          </li>
          <li class="section">
            <input type="checkbox" id="STSException">
            <label for="STSException"> Exception</label>
            <ul>
              <li>
                <h2>Code table : Exception code</h2>
                <Table border=0.5 style="color:black; width:100%;">
                  <tr style="background-color:lightgrey">
                    <td>ID</td>
                    <td>Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                    <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                  </tr>
                  <tr>
                   <td>Exception_01</td>
                   <td>0501</td>
                   <td>PICKUP_NOT_DONE</td>
                   <td></td>
                   <td></td>
                   </tr>
                   <tr>
                    <td>Exception_02</td>
                    <td>0502</td>
                    <td>PICKUP_BROKEN </td>
                    <td></td>
                    <td></td>
                    </tr>
                    <tr>
                      <td>Exception_03</td>
                      <td>0502</td>
                      <td>DELIVERED_WITH_DAMAGE</td>
                      <td></td>
                      <td></td>
                      </tr>
                      <tr>
                        <td>Exception_04</td>
                        <td>0503</td>
                        <td>DELIVERY_SHORT</td>
                        <td></td>
                        <td></td>
                        </tr>
                        <tr>
                          <td>Exception_05</td>
                          <td>0504</td>
                          <td>PICKUP_NOT_DONE</td>
                          <td></td>
                          <td></td>
                          </tr>
                          <tr>
                            <td>Exception_06</td>
                            <td>0505</td>
                            <td>DELIVERY_REFUSED</td>
                            <td></td>
                            <td></td>
                            </tr>
                </Table>
              </li>
            </ul>
          </li>

        </ul>
      </li>
</ul>
  </body>
</html>
