<!DOCTYPE html>
<html>
<head>
    <title>Svkonekt Trip (Outbound)</title>
    <link rel="stylesheet" href="/assets/css/tree.css">
</head>
<body>
<ul class="tree">
    <!-- (A) "NORMAL" ITEMS -->
    <li>Trip is an action of assigning the Carriers and corresponding drivers to the orders received as part of the shipment plan.<br>
        Trip information can be received/sent to the respective Business parties via Trip EDI

    </li>
    <li>
        <ul>
            <li><b>METHOD</b> : <button class="button">POST</button></li>
        </ul></li>

    <!-- (B) SECTION -->
    <li class="section">
        <input type="checkbox" id="groupA">
        <label for="groupA">Sample XML</label>
        <ul><li>
                <xmp>
                    <SVKEDIMessage>
                        <SVKEDITripHeader>
                            <EDIVersion/>
                            <UserName/>
                            <Password/>
                            <SenderTransmissionNo/>
                            <AckSpec>
                                <EmailAddress/>
                                <AckOption/>
                            </AckSpec>
                            <SourceApp/>
                            <DestinationApp />
                            <ReferenceId/>
                            <Action />
                        </SVKEDITripHeader>
                        <SVKEDITripBody>
                            <eTNOrgDetails>
                                <Companycode/>
                                <Branchcode/>
                                <DepartmentCode/>
                                <PhysicalReceiver/>
                                <LogicalReceiver/>
                                <PhysicalSender/>
                                <LogicalSender/>
                            </eTNOrgDetails>
                            <TripDetails>
                                <TripHeader>
                                    <TripID/>
                                    <ExternalTripID/>
                                    <CarrierDetails>
                                        <ID/>
                                        <Address>
                                            <CompanyName/>
                                            <Address1/>
                                            <Address2/>
                                            <Street/>
                                            <City/>
                                            <State/>
                                            <Postal/>
                                            <Country/>
                                            <ContactInfo>
                                                <CountryCode/>
                                                <ContactNo/>
                                                <EmailAddress/>
                                            </ContactInfo>
                                        </Address>
                                        <AdditionalContactInfo>
                                            <ContactInfo>
                                                <Name/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <Phone/>
                                                <Fax/>
                                                <Email/>
                                            </ContactInfo>
                                        </AdditionalContactInfo>
                                    </CarrierDetails>
                                    <TripLocation>
                                        <TripStartLocation>
                                            <Address>
                                                <CompanyName/>
                                                <Address1/>
                                                <Address2/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <ContactInfo>
                                                    <CountryCode/>
                                                    <ContactNo/>
                                                    <EmailAddress/>
                                                </ContactInfo>
                                            </Address>
                                        </TripStartLocation>
                                        <TripEndLocation>
                                            <Address>
                                                <CompanyName/>
                                                <Address1/>
                                                <Address2/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <ContactInfo>
                                                    <CountryCode/>
                                                    <ContactNo/>
                                                    <EmailAddress/>
                                                </ContactInfo>
                                            </Address>
                                        </TripEndLocation>
                                    </TripLocation>
                                    <VehicleDetails>
                                        <VehicleTypeCode/>
                                        <VehicleModelCode/>
                                        <RegistrationNumber/>
                                        <License/>
                                        <ApplicableForDangerousGoods/>
                                        <CommodityType/>
                                        <Properties>
                                            <Weight>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Weight>
                                            <Volume>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Volume>
                                            <Length>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Length>
                                            <Width>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Width>
                                            <Height>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Height>
                                            <Distance>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </Distance>
                                            <DimensionGirth>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </DimensionGirth>
                                            <ShipmentUnit>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </ShipmentUnit>
                                            <PacketWeight>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </PacketWeight>
                                            <PacketVolume>
                                                <Min/>
                                                <Max/>
                                                <UOM/>
                                            </PacketVolume>
                                        </Properties>
                                    </VehicleDetails>
                                    <DriverDetails>
                                        <DriverId/>
                                        <DriverName/>
                                        <DriverLicence/>
                                        <Address>
                                            <Address1/>
                                            <Address2/>
                                            <Street/>
                                            <City/>
                                            <State/>
                                            <Postal/>
                                            <Country/>
                                            <ContactInfo>
                                                <CountryCode/>
                                                <ContactNo/>
                                                <EmailAddress/>
                                            </ContactInfo>
                                        </Address>
                                    </DriverDetails>
                                    <CargoSummary>
                                        <TotalQuantity>
                                            <Value/>
                                            <UOM/>
                                        </TotalQuantity>
                                        <TotalVolume>
                                            <Value/>
                                            <UOM/>
                                        </TotalVolume>
                                        <TotalWeight>
                                            <Value/>
                                            <UOM/>
                                        </TotalWeight>
                                    </CargoSummary>
                                </TripHeader>
                                <TripOrderDetails>
                                    <OrderID/>
                                    <EXTOrderID/>
                                    <Transits>
                                        <TransitLegId/>
                                    </Transits>
                                    <OrderType/>
                                    <ModeOfTransport/>
                                    <Product/>
                                    <ServiceType/>
                                    <GoodsValue/>
                                    <TypeOfBusiness/>
                                    <TermsOfTrade>
                                        <Incoterm/>
                                        <FreightName>
                                            <Term/>
                                            <Name/>
                                        </FreightName>
                                    </TermsOfTrade>
                                    <OrderCargoSummary>
                                        <TotalQuantity>
                                            <Value/>
                                            <UOM/>
                                        </TotalQuantity>
                                        <Volume>
                                            <Value/>
                                            <UOM/>
                                        </Volume>
                                        <ActualVolume>
                                            <Value/>
                                            <UOM/>
                                        </ActualVolume>
                                        <Weight>
                                            <Value/>
                                            <UOM/>
                                        </Weight>
                                        <Actual Weight>
                                            <Value/>
                                            <UOM/>
                                        </Actual Weight>
                                    </OrderCargoSummary>
                                    <LocationInfo>
                                        <Source>
                                        <ID/>
                                        <Company>
                                            <Name/>
                                            <RegistrationNumber/>
                                        </Company>
                                        <Address>
                                            <CompanyName/>
                                            <Address1/>
                                            <Address2/>
                                            <Street/>
                                            <City/>
                                            <State/>
                                            <Postal/>
                                            <Country/>
                                            <ContactInfo>
                                                <CountryCode/>
                                                <ContactNo/>
                                                <EmailAddress/>
                                            </ContactInfo>
                                        </Address>
                                        <EstimatedDateTime>
                                            <From>
                                                <DateTime/>
                                                <TimeZone/>
                                                <UTC>
                                                    <Time/>
                                                </UTC>
                                            </From>
                                            <To>
                                                <DateTime/>
                                                <TimeZone/>
                                                <UTC>
                                                    <Time/>
                                                </UTC>
                                            </To>
                                        </EstimatedDateTime>
                                        <PartyReference>
                                            <References>
                                                <RefType>
                                                    <Code/>
                                                    <Value/>
                                                </RefType>
                                            </References>
                                        </PartyReference>
                                        <AdditionalContactInfo>
                                            <ContactInfo>
                                                <Name/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <Phone/>
                                                <Fax/>
                                                <Email/>
                                            </ContactInfo>
                                        </AdditionalContactInfo>
                                        </Source>
                                        <Destination>
                                            <ID/>
                                            <Company>
                                                <Name/>
                                                <RegistrationNumber/>
                                            </Company>
                                            <Address>
                                                <CompanyName/>
                                                <Address1/>
                                                <Address2/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <ContactInfo>
                                                    <CountryCode/>
                                                    <ContactNo/>
                                                    <EmailAddress/>
                                                </ContactInfo>
                                            </Address>
                                            <EstimatedDateTime>
                                                <From>
                                                    <DateTime/>
                                                    <TimeZone/>
                                                    <UTC>
                                                        <Time/>
                                                    </UTC>
                                                </From>
                                                <To>
                                                    <DateTime/>
                                                    <TimeZone/>
                                                    <UTC>
                                                        <Time/>
                                                    </UTC>
                                                </To>
                                            </EstimatedDateTime>
                                            <PartyReference>
                                                <References>
                                                    <RefType>
                                                        <Code/>
                                                        <Value/>
                                                    </RefType>
                                                </References>
                                            </PartyReference>
                                            <AdditionalContactInfo>
                                                <ContactInfo>
                                                    <Name/>
                                                    <Street/>
                                                    <City/>
                                                    <State/>
                                                    <Postal/>
                                                    <Country/>
                                                    <Phone/>
                                                    <Fax/>
                                                    <Email/>
                                                </ContactInfo>
                                            </AdditionalContactInfo>
                                        </Destination>
                                    </LocationInfo>
                                    <CargoDetails>
                                        <TransportHandlingUnit>
                                            <CargoType/>
                                            <GoodsDescription/>
                                            <MarksandNumbers/>
                                            <ValueOfGoods/>
                                            <HandlingUnit/>
                                            <ItemId/>
                                            <Length>
                                                <Value/>
                                                <UOM/>
                                            </Length>
                                            <Width>
                                                <Value/>
                                                <UOM/>
                                            </Width>
                                            <Height>
                                                <Value/>
                                                <UOM/>
                                            </Height>
                                            <ActualWeight>
                                                <Value/>
                                                <UOM/>
                                            </ActualWeight>
                                            <Weight>
                                                <Value/>
                                                <UOM/>
                                            </Weight>
                                            <VolumetricWeight>
                                                <Value/>
                                                <UOM/>
                                            </VolumetricWeight>
                                            <Volume>
                                                <Value/>
                                                <UOM/>
                                            </Volume>
                                            <ActualVolume>
                                                <Value/>
                                                <UOM/>
                                            </ActualVolume>
                                            <Quantity/>
                                            <ScannedQuantity/>
                                            <ldm/>
                                            <GroundedFlag/>
                                            <StackableFlag/>
                                            <SplittableFlag/>
                                            <DangerousGoodsFlag/>
                                            <TotalPackagesOfDangerousGoods/>
                                            <DangerousGoods>
                                                <DangerousGoodsPosition>
                                                    <NumberOfPackages>
                                                        <Value/>
                                                        <QuantityType/>
                                                    </NumberOfPackages>
                                                    <DangerousGoodsDetails>
                                                        <DangerousGoodsQuantity>
                                                            <Value/>
                                                            <QuantityType/>
                                                        </DangerousGoodsQuantity>
                                                        <UnitedNationsOrganisationNumber>
                                                            <Value/>
                                                            <Variant/>
                                                        </UnitedNationsOrganisationNumber>
                                                        <DangerousGoodsClass/>
                                                        <MainRisk/>
                                                        <SubsidiaryRisks/>
                                                        <PackingGroup/>
                                                        <DangerousGoodsDescriptions>
                                                            <Language/>
                                                            <ProperShippingName/>
                                                        </DangerousGoodsDescriptions>
                                                        <LimitedQuantityFlag/>
                                                        <ExceptedQuantityFlag/>
                                                        <HighConsequence/>
                                                        <Roadfreight>
                                                            <TunnelRestrictionCode/>
                                                            <TransportCategory/>
                                                            <EnvironmentallyHazardous/>
                                                            <NOS/>
                                                            <ADRMultiplicator/>
                                                            <TotalADRPoints/>
                                                            <ADRVersion/>
                                                        </Roadfreight>
                                                    </DangerousGoodsDetails>
                                                </DangerousGoodsPosition>
                                            </DangerousGoods>
                                            <Packagingunit>
                                                <PackageType/>
                                                <PackageDescription/>
                                                <Quantity/>
                                                <Length>
                                                    <Value/>
                                                    <UOM/>
                                                </Length>
                                                <Width>
                                                    <Value/>
                                                    <UOM/>
                                                </Width>
                                                <Height>
                                                    <Value/>
                                                    <UOM/>
                                                </Height>
                                                <Weight>
                                                    <Value/>
                                                    <UOM/>
                                                </Weight>
                                                <Volume>
                                                    <Value/>
                                                    <UOM/>
                                                </Volume>
                                            </Packagingunit>
                                        </TransportHandlingUnit>
                                    </CargoDetails>
                                    <ValueAddedServices>
                                        <Addon>
                                            <AddonName/>
                                            <AddonCode/>
                                            <Currency/>
                                            <RateUnit/>
                                            <AddonAmount/>
                                            <AddonQuantity/>
                                        </Addon>
                                    </ValueAddedServices>
                                    <InvolvedParties>
                                        <PartyType type="Shipper">
                                        <ID/>
                                        <Company>
                                            <Name/>
                                            <RegistrationNumber/>
                                        </Company>
                                        <Address>
                                            <FirstName/>
                                            <LastName/>
                                            <Address1/>
                                            <Address2/>
                                            <Street/>
                                            <City/>
                                            <State/>
                                            <Postal/>
                                            <Country/>
                                            <ContactInfo>
                                                <CountryCode/>
                                                <ContactNo/>
                                                <EmailAddress/>
                                            </ContactInfo>
                                        </Address>
                                        <PartyReference>
                                            <References>
                                                <RefType>
                                                    <Code/>
                                                    <Value/>
                                                </RefType>
                                            </References>
                                        </PartyReference>
                                        <AdditionalContactInfo>
                                            <ContactInfo>
                                                <Name/>
                                                <Street/>
                                                <City/>
                                                <State/>
                                                <Postal/>
                                                <Country/>
                                                <Phone/>
                                                <Fax/>
                                                <Email/>
                                            </ContactInfo>
                                        </AdditionalContactInfo>
                                        </PartyType>
                                    </InvolvedParties>
                                    <ManageReferences>
                                        <References>
                                            <RefType>
                                                <Code/>
                                                <Value/>
                                            </RefType>
                                        </References>
                                    </ManageReferences>
                                    <Remarks>
                                        <RemarkType>
                                            <Code/>
                                            <Value/>
                                        </RemarkType>
                                    </Remarks>
                                </TripOrderDetails>
                            </TripDetails>
                        </SVKEDITripBody>
                    </SVKEDIMessage>

                </xmp></li>
        </ul>
    </li>

    <!-- (C) SECTION WITH SUB-SECTION -->
    <li class="section">
        <input type="checkbox" id="TRPSTSREQ">
        <label for="TRPSTSREQ">Request : Payload</label>
        <ul>
            <!-- SUB-SECTION -->
            <li class="section">
                <input type="checkbox" id="SVKEDITripHeader">
                <label for="SVKEDITripHeader">SVKEDITripHeader</label>
                <ul>
                    <li>
                        <Table border=0.5 style="color:black">
                            <tr style="background-color:lightgrey">
                                <td>Element&nbsp;&nbsp;&nbsp;  </td>
                                <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                <td>Type&nbsp;&nbsp;&nbsp;</td>
                                <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                <td>Description&nbsp;&nbsp;&nbsp;</td>
                            </tr>
                            <tr>
                                <td>EDIVersion</td>
                                <td></td>
                                <td>Y</td>
                                <td>Variable</td>
                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                <td>No</td>
                                <td>1/20</td>
                                <td></td>
                                <td>1.1.1</td>
                                <td>This is used to maintain the API / EDI version used for data exchange</td>
                            </tr>
                            <tr>
                                <td>Username</td>
                                <td></td>
                                <td>Y</td>
                                <td>Variable</td>
                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                <td>No</td>
                                <td>1/50</td>
                                <td></td>
                                <td>Svkonekt</td>
                                <td>Svkonekt Username </td>
                            </tr>
                            <tr>
                                <td>Password</td>
                                <td></td>
                                <td>Y</td>
                                <td>Variable</td>
                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                <td>No</td>
                                <td>1/50</td>
                                <td></td>
                                <td>Svkonekt</td>
                                <td>Svkonekt Password</td>
                            </tr>
                            <tr>
                                <td>SenderTransmissionNo</td>
                                <td></td>
                                <td>Y</td>
                                <td>Fixed</td>
                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                <td>No</td>
                                <td>1/27</td>
                                <td></td>
                                <td>20220214122519_TNZ0722060491</td>
                                <td>Sender Transmission is a combination of ID_Tripno</td>
                            </tr>
                            <tr>
                                <td colspan="10">
                    <li class="section">
                        <input type="checkbox" id="SVKEDITAckSpec">
                        <label for="SVKEDITAckSpec">AckSpec&nbsp;&nbsp;&nbsp;</label>
                        <ul>
                            <li>
                                <Table border=0.5 style="color:black">
                                    <tr style="background-color:lightgrey">
                                        <td>Element&nbsp;&nbsp;&nbsp;  </td>
                                        <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                        <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                        <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                        <td>Type&nbsp;&nbsp;&nbsp;</td>
                                        <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                        <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                        <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                        <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                        <td>Description&nbsp;&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>EmailAddress</td>
                                        <td></td>
                                        <td>N</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>0/100</td>
                                        <td></td>
                                        <td></td>
                                        <td>Email ID linked to the user</td>
                                    </tr>
                                    <tr>
                                        <td>AckOption</td>
                                        <td></td>
                                        <td>Y</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>1/5</td>
                                        <td></td>
                                        <td>ERROR</td>
                                        <td>Defines the message whether successful or failed</td>
                                    </tr>
                                </Table>
                            </li>
                        </ul>
                    </li>
                    </td>
                    </tr>
                    <tr>
                        <td>SourceApp</td>
                        <td></td>
                        <td>Y</td>
                        <td>Fixed</td>
                        <td>Alpha</td>
                        <td>No</td>
                        <td>1/9</td>
                        <td></td>
                        <td>ETRA</td>
                        <td>Sender Application name</td>
                    </tr>
                    <tr>
                        <td>DestinationApp</td>
                        <td>CT_Destination&nbsp;&nbsp;</td>
                        <td>Y</td>
                        <td>Variable</td>
                        <td>Alpha</td>
                        <td>No</td>
                        <td>1/100</td>
                        <td></td>
                        <td>CARRIER</td>
                        <td>Receiver Application Name</td>
                    </tr>
                    <tr>
                        <td>ReferenceId</td>
                        <td></td>
                        <td>Y</td>
                        <td>Variable</td>
                        <td>Alpha-Numeric&nbsp;&nbsp;</td>
                        <td>No</td>
                        <td>1/10</td>
                        <td></td>
                        <td>TNZ0722060491</td>
                        <td>Reference I.D </td>
                    </tr>
                    <tr>
                        <td>Action</td>
                        <td>CT_Action&nbsp;&nbsp;</td>
                        <td>Y</td>
                        <td>Variable</td>
                        <td>Alpha</td>
                        <td>No</td>
                        <td>1/2</td>
                        <td></td>
                        <td>I</td>
                        <td>Transmission action of the trip event;Insert, Update, Delete</td>
                    </tr>

                    </table>
                    </li>
                </ul>
            </li>
            <li class="section">
                <input type="checkbox" id="SVKEDITripBody">
                <label for="SVKEDITripBody">SVKEDITripBody</label>
                <ul>
                    <li>
                        <Table border=0.5 style="color:black">
                            <tr style="background-color:lightgrey">
                                <td>Element  </td>
                                <td>Code table</td>
                                <td>Mandatory</td>
                                <td>Fixed / Variable</td>
                                <td>Type</td>
                                <td>Loop</td>
                                <td>Min/max</td>
                                <td>Trigger Condition</td>
                                <td>Sample Value</td>
                                <td>Description</td>
                            </tr>
                            <tr>
                                <td>eTNOrgDetails</td>
                                <td></td>
                                <td>Y</td>
                                <td>Variable</td>
                                <td>Alpha-Numeric&nbsp;&nbsp;</td>
                                <td>No</td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>Svkonekt Organization Details</td>
                            </tr>
                            <tr>
                                <td colspan="10">
                    <li class="section">
                        <input type="checkbox" id="SVKEDITOrgDts">
                        <label for="SVKEDITOrgDts">eTNOrgDetails&nbsp;&nbsp;&nbsp;</label>
                        <ul>
                            <li>
                                <Table border=0.5 style="color:black">
                                    <tr style="background-color:lightgrey">
                                        <td>Element  </td>
                                        <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                        <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                        <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                        <td>Type&nbsp;&nbsp;&nbsp;</td>
                                        <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                        <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                        <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                        <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                        <td>Description&nbsp;&nbsp;&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>Companycode</td>
                                        <td></td>
                                        <td>Y</td>
                                        <td>Variable</td>
                                        <td>Alpha &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>1/4</td>
                                        <td></td>
                                        <td>CNKN</td>
                                        <td>Company Code</td>
                                    </tr>
                                    <tr>
                                        <td>Branchcode</td>
                                        <td></td>
                                        <td>Y</td>
                                        <td>Variable</td>
                                        <td>Alpha &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>1/10</td>
                                        <td></td>
                                        <td>CNSHA</td>
                                        <td>Branch Code</td>
                                    </tr>
                                    <tr>
                                        <td>DepartmentCode</td>
                                        <td></td>
                                        <td>N</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>0/100</td>
                                        <td></td>
                                        <td></td>
                                        <td>Department Code</td>
                                    </tr>
                                    <tr>
                                        <td>PhysicalReceiver</td>
                                        <td></td>
                                        <td>N</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>0/10</td>
                                        <td></td>
                                        <td></td>
                                        <td>Svkonekt  (Receiver of The Order)</td>
                                    </tr>
                                    <tr>
                                        <td>LogicalReceiver</td>
                                        <td></td>
                                        <td>N</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>0/10</td>
                                        <td></td>
                                        <td></td>
                                        <td>The external receiver  </td>
                                    </tr>
                                    <tr>
                                        <td>PhysicalSender</td>
                                        <td></td>
                                        <td>N</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>0/10</td>
                                        <td></td>
                                        <td></td>
                                        <td>Svkonekt (sender of the order)</td>
                                    </tr>
                                    <tr>
                                        <td>LogicalSender</td>
                                        <td></td>
                                        <td>Y</td>
                                        <td>Variable</td>
                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                        <td>No</td>
                                        <td>1/10</td>
                                        <td></td>
                                        <td>2625</td>
                                        <td>External (Sending the Order/Booking details)</td>
                                    </tr>


                                </Table>
                            </li>
                        </ul>
                    </li>
                    </td>
                    </tr>

                    <tr>
                        <td colspan="10">
                            <li class="section">
                                <input type="checkbox" id="SVKEDITrpDts">
                                <label for="SVKEDITrpDts">TripDetails&nbsp;&nbsp;&nbsp;</label>
                                <ul>
                                    <li>
                                        <Table border=0.5 style="color:black">
                                            <tr style="background-color:lightgrey">
                                                <td>Element  </td>
                                                <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                <td>Description&nbsp;&nbsp;&nbsp;</td>
                                            </tr>

                                            <tr>
                                                <td colspan="10">
                                    <li class="section">
                                        <input type="checkbox" id="SVKEDITrpHdr">
                                        <label for="SVKEDITrpHdr">TripHeader&nbsp;&nbsp;&nbsp;</label>
                                        <ul>
                                            <li>
                                                <Table border=0.5 style="color:black">
                                                    <tr style="background-color:lightgrey">
                                                        <td>Element  </td>
                                                        <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                        <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                    </tr>
                                                    <tr>
                                                        <td>TripID</td>
                                                        <td></td>
                                                        <td>Y</td>
                                                        <td>Variable</td>
                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                        <td>No</td>
                                                        <td></td>
                                                        <td></td>
                                                        <td>TNZ0722060491</td>
                                                        <td>A Identification no.denoting the Trip</td>
                                                    </tr>
                                                    <tr>
                                                        <td>ExternalTripID</td>
                                                        <td></td>
                                                        <td>N</td>
                                                        <td>Variable</td>
                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                        <td>No</td>
                                                        <td></td>
                                                        <td></td>
                                                        <td>TNZ0722060491</td>
                                                        <td>External Trip I.D if available else by default taken as Trip ID from eTN</td>
                                                    </tr>


                                                    <tr>
                                                        <td colspan="10">
                                            <li class="section">
                                                <input type="checkbox" id="SVKEDICarDts">
                                                <label for="SVKEDICarDts">CarrierDetails&nbsp;&nbsp;&nbsp;</label>
                                                <ul>
                                                    <li>
                                                        <Table border=0.5 style="color:black">
                                                            <tr style="background-color:lightgrey">
                                                                <td>Element  </td>
                                                                <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                                <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                            </tr>
                                                            <tr>
                                                                <td>ID</td>
                                                                <td></td>
                                                                <td>Y</td>
                                                                <td>Fixed</td>
                                                                <td>Numeric &nbsp;&nbsp;</td>
                                                                <td>No</td>
                                                                <td>1/10</td>
                                                                <td></td>
                                                                <td>96757575675</td>
                                                                <td>Carrier identification  named as CID(Cust Identificaton no.) in eTN</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Address</td>
                                                                <td></td>
                                                                <td>Y</td>
                                                                <td>Variable</td>
                                                                <td>Alpha-Numeric</td>
                                                                <td>No</td>
                                                                <td>1/10</td>
                                                                <td></td>
                                                                <td></td>
                                                                <td>Carrier Address</td>
                                                            </tr>

                                                            <tr>
                                                                <td colspan="10">
                                                    <li class="section">
                                                        <input type="checkbox" id="SVKEDIAdd">
                                                        <label for="SVKEDIAdd">Address&nbsp;&nbsp;&nbsp;</label>
                                                        <ul>
                                                            <li>
                                                                <Table border=0.5 style="color:black">
                                                                    <tr style="background-color:lightgrey">
                                                                        <td>Element  </td>
                                                                        <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                                        <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>CompanyName</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/100</td>
                                                                        <td></td>
                                                                        <td>BASICK NETWORKS (NZ) LTD</td>
                                                                        <td>Carrier Company Name</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Address1</td>
                                                                        <td></td>
                                                                        <td>N</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>0/255</td>
                                                                        <td></td>
                                                                        <td></td>
                                                                        <td>Carrier Address1</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Address2</td>
                                                                        <td></td>
                                                                        <td>N</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>0/255</td>
                                                                        <td></td>
                                                                        <td></td>
                                                                        <td>Carrier Address2</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Street</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/255</td>
                                                                        <td></td>
                                                                        <td>179 SAVIL DRIVE</td>
                                                                        <td>Carrier Street</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>City</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/100</td>
                                                                        <td></td>
                                                                        <td>AUCKLAND</td>
                                                                        <td>Carrier City</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>State</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/100</td>
                                                                        <td></td>
                                                                        <td>OTAHUHU</td>
                                                                        <td>Carrier State</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Postal</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Variable</td>
                                                                        <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/60</td>
                                                                        <td></td>
                                                                        <td>200002</td>
                                                                        <td>Carrier Postal</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Country</td>
                                                                        <td></td>
                                                                        <td>Y</td>
                                                                        <td>Varible</td>
                                                                        <td>Alpha &nbsp;&nbsp;</td>
                                                                        <td>No</td>
                                                                        <td>1/30</td>
                                                                        <td></td>
                                                                        <td>NEW ZEALAND</td>
                                                                        <td>Carrier Country</td>
                                                                    </tr>

                                                                    <tr>
                                                                        <td colspan="10">
                                                            <li class="section">
                                                                <input type="checkbox" id="SVKEDIConInfo">
                                                                <label for="SVKEDIConInfo">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                                                                <ul>
                                                                    <li>
                                                                        <Table border=0.5 style="color:black">
                                                                            <tr style="background-color:lightgrey">
                                                                                <td>Element  </td>
                                                                                <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                                                <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>CountryCode</td>
                                                                                <td>CT_Country code</td>
                                                                                <td>Y</td>
                                                                                <td>Variable</td>
                                                                                <td>Numeric &nbsp;&nbsp;</td>
                                                                                <td>No</td>
                                                                                <td>1/2</td>
                                                                                <td></td>
                                                                                <td>64</td>
                                                                                <td>Country code set by the organization;normally goes by first 2 digits of the country phone code</td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>ContactNo</td>
                                                                                <td></td>
                                                                                <td>N</td>
                                                                                <td>Variable</td>
                                                                                <td>Numeric &nbsp;&nbsp;</td>
                                                                                <td>No</td>
                                                                                <td>0/12</td>
                                                                                <td></td>
                                                                                <td>99999999999999</td>
                                                                                <td>Carrier Contact no</td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td>EmailAddress</td>
                                                                                <td></td>
                                                                                <td>N</td>
                                                                                <td>Variable</td>
                                                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                                                <td>No</td>
                                                                                <td>0/100</td>
                                                                                <td></td>
                                                                                <td>shin,yu@email.com</td>
                                                                                <td>email address of the Carrier</td>
                                                                            </tr>

                                                                        </Table>
                                                                    </li>
                                                                </ul>
                                                            </li>
                        </td>
                    </tr>
                    </Table>
                    </li>
                </ul>
            </li>
            </td>
            </tr>
            <tr>
                <td colspan="10">
                    <li class="section">
                        <input type="checkbox" id="SVKEDIAddConInfo">
                        <label for="SVKEDIAddConInfo">AdditionalContactInfo&nbsp;&nbsp;&nbsp;</label>
                        <ul>
                            <li>
                                <Table border=0.5 style="color:black">
                                    <tr style="background-color:lightgrey">
                                        <td>Element  </td>
                                        <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                        <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                        <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                        <td>Type&nbsp;&nbsp;&nbsp;</td>
                                        <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                        <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                        <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                        <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                        <td>Description&nbsp;&nbsp;&nbsp;</td>
                                    </tr>

                                    <tr>
                                        <td colspan="10">
                            <li class="section">
                                <input type="checkbox" id="SVKEDIAddConInfo2">
                                <label for="SVKEDIAddConInfo2">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                                <ul>
                                    <li>
                                        <Table border=0.5 style="color:black">
                                            <tr style="background-color:lightgrey">
                                                <td>Element  </td>
                                                <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                <td>Description&nbsp;&nbsp;&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td>Name</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/25</td>
                                                <td></td>
                                                <td>XYZ INDUSTRY</td>
                                                <td>Name of the Additional Party involved if any</td>
                                            </tr>
                                            <tr>
                                                <td>Street</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/15</td>
                                                <td></td>
                                                <td>JIANSU</td>
                                                <td>Defines the Street of the contact entity</td>
                                            </tr>
                                            <tr>
                                                <td>City</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/15</td>
                                                <td></td>
                                                <td>BEJING</td>
                                                <td>Defines the City of the contact entity</td>
                                            </tr>
                                            <tr>
                                                <td>State</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/15</td>
                                                <td></td>
                                                <td>SHANGAI</td>
                                                <td>Defines the State of the contact entity/person</td>
                                            </tr>

                                            <tr>
                                                <td>Postal</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/15</td>
                                                <td></td>
                                                <td>450025</td>
                                                <td>Postal/zip code of the country</td>
                                            </tr>
                                            <tr>
                                                <td>Country</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/15</td>
                                                <td></td>
                                                <td>CHINA</td>
                                                <td>Defines the Country of the contact  entity</td>
                                            </tr>
                                            <tr>
                                                <td>Phone</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/10</td>
                                                <td></td>
                                                <td>8546546466</td>
                                                <td>Contact no of the entity</td>
                                            </tr>
                                            <tr>
                                                <td>Fax</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/10</td>
                                                <td></td>
                                                <td>TEST</td>
                                                <td>Fax no of the entity</td>
                                            </tr>
                                            <tr>
                                                <td>Email</td>
                                                <td></td>
                                                <td>N</td>
                                                <td>Variable</td>
                                                <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                <td>No</td>
                                                <td>0/100</td>
                                                <td></td>
                                                <td>TEST</td>
                                                <td>Email address of the contact entity</td>
                                            </tr>


                                        </Table>
                                    </li>
                                </ul>
                            </li>
                </td>
            </tr>



            </Table>
            </li>
        </ul>
    </li>
    </td>
    </tr>

    </Table>
    </li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITrpLoc">
            <label for="SVKEDITrpLoc">TripLocation&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITrpStrtLoc">
                    <label for="SVKEDITrpStrtLoc">TripStartLocation&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITrpStrLocAdd">
                            <label for="SVKEDITrpStrLocAdd">Address&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>CompanyName</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/100</td>
                                            <td></td>
                                            <td>FLIGHT PLASTICS</td>
                                            <td>Start Location Company Details</td>
                                        </tr>
                                        <tr>
                                            <td>Address1</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/255</td>
                                            <td></td>
                                            <td>75 Wainui Road</td>
                                            <td>Address</td>
                                        </tr>
                                        <tr>
                                            <td>Address2</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/255</td>
                                            <td></td>
                                            <td>Waiwhetu</td>
                                            <td>Address</td>
                                        </tr>
                                        <tr>
                                            <td>Street</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/255</td>
                                            <td></td>
                                            <td>75 Wainui Road</td>
                                            <td>Street name</td>
                                        </tr>
                                        <tr>
                                            <td>City</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/100</td>
                                            <td></td>
                                            <td>Lower Hutt</td>
                                            <td>City Name</td>
                                        </tr>
                                        <tr>
                                            <td>State</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/100</td>
                                            <td></td>
                                            <td>Waiwhetu</td>
                                            <td>State Name</td>
                                        </tr>
                                        <tr>
                                            <td>Postal</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/60</td>
                                            <td></td>
                                            <td>5010</td>
                                            <td>Postal code</td>
                                        </tr>
                                        <tr>
                                            <td>Country</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/30</td>
                                            <td></td>
                                            <td>NEW ZEALAND</td>
                                            <td>Country name</td>
                                        </tr>

                                        <tr>
                                            <td colspan="10">
                                <li class="section">
                                    <input type="checkbox" id="SVKEDIStrLocCtInfo">
                                    <label for="SVKEDIStrLocCtInfo">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                                    <ul>
                                        <li>
                                            <Table border=0.5 style="color:black">
                                                <tr style="background-color:lightgrey">
                                                    <td>Element  </td>
                                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                                </tr>
                                                <tr>
                                                    <td>CountryCode</td>
                                                    <td>CT_Country code</td>
                                                    <td>Y</td>
                                                    <td>Variable</td>
                                                    <td>Numeric &nbsp;&nbsp;</td>
                                                    <td>No</td>
                                                    <td>1/2</td>
                                                    <td></td>
                                                    <td>64</td>
                                                    <td>Country code set by the organization;normally goes by first 2 digits of the country phone code&nbsp;&nbsp;</td>
                                                </tr>
                                                <tr>
                                                    <td>ContactNo</td>
                                                    <td></td>
                                                    <td>N</td>
                                                    <td>Variable</td>
                                                    <td>Numeric &nbsp;&nbsp;</td>
                                                    <td>No</td>
                                                    <td>0/12</td>
                                                    <td></td>
                                                    <td></td>
                                                    <td>Contact no .of source entity</td>
                                                </tr>
                                                <tr>
                                                    <td>EmailAddress</td>
                                                    <td></td>
                                                    <td>Y</td>
                                                    <td>Variable</td>
                                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                                    <td>No</td>
                                                    <td>1/100</td>
                                                    <td></td>
                                                    <td>rtyu.m@email.com</td>
                                                    <td>Email address of the source entity</td>
                                                </tr>

                                            </Table>
                                        </li>
                                    </ul>
                                </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITrpEndLoc">
            <label for="SVKEDITrpEndLoc">TripEndLocation&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITrpEndLocAdd">
                    <label for="SVKEDITrpEndLocAdd">Address&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>CompanyName</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>PREMIER BEEHIVE NZ LTD</td>
                                    <td>Name of the destination location entity /person</td>
                                </tr>
                                <tr>
                                    <td>Address1</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/255</td>
                                    <td></td>
                                    <td>50 Moreton Road</td>
                                    <td>Address of the destination location </td>
                                </tr>
                                <tr>
                                    <td>Address2</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/255</td>
                                    <td></td>
                                    <td>CARTERTON</td>
                                    <td>Address of the destination location</td>
                                </tr>
                                <tr>
                                    <td>Street</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/255</td>
                                    <td></td>
                                    <td>50 Moreton Road</td>
                                    <td>Street name</td>
                                </tr>
                                <tr>
                                    <td>City</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Fixed</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>Parkvale</td>
                                    <td>City Name</td>
                                </tr>
                                <tr>
                                    <td>State</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Fixed</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>CARTERTON</td>
                                    <td>State Name</td>
                                </tr>
                                <tr>
                                    <td>Postal</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Fixed</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/60</td>
                                    <td></td>
                                    <td>5713</td>
                                    <td>Postal code</td>
                                </tr>
                                <tr>
                                    <td>Country</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/30</td>
                                    <td></td>
                                    <td>NEW ZEALAND</td>
                                    <td>Country name</td>
                                </tr>
                                <tr>
                                    <td>ContactInfo</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>Contact Information of end location details</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDIEndLocCtInfo">
                            <label for="SVKEDIEndLocCtInfo">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>CountryCode</td>
                                            <td>CT_Country code</td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/2</td>
                                            <td></td>
                                            <td>64</td>
                                            <td>Country code set by the organization;normally goes by first 2 digits of the country phone code&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>ContactNo</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/10</td>
                                            <td></td>
                                            <td>123456789</td>
                                            <td>Contact no of the destination entity</td>
                                        </tr>
                                        <tr>
                                            <td>EmailAddress</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/100</td>
                                            <td></td>
                                            <td></td>
                                            <td>Email address of the destination entity</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>




</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhcDts">
            <label for="SVKEDIVhcDts">VehicleDetails &nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>VehicleTypeCode</td>
                            <td>CT_Truck Type Master</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>12 METER Truck Test</td>
                            <td>Fixed Vehicle type code </td>
                        </tr>
                        <tr>
                            <td>VehicleModelCode</td>
                            <td>CT_Truck Type Master</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>12 METER Truck Test</td>
                            <td>Fixed Vehicle model code</td>
                        </tr>
                        <tr>
                            <td>RegistrationNumber</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>CHINA01</td>
                            <td>Vehicle registration number</td>
                        </tr>
                        <tr>
                            <td>License</td>
                            <td></td>
                            <td>Y</td>
                            <td>Fixed</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/3</td>
                            <td></td>
                            <td>AA7U80902</td>
                            <td>The driver's license no given by the State Road Authorites</td>
                        </tr>
                        <tr>
                            <td>ApplicableForDangerousGoods</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/3</td>
                            <td></td>
                            <td>Yes</td>
                            <td>Confirmation on the cargo if DG cargo carried</td>
                        </tr>
                        <tr>
                            <td>CommodityType</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/5</td>
                            <td></td>
                            <td>Yes</td>
                            <td>Goods type that the vehicle carries</td>
                        </tr>


                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIVhclProp">
                    <label for="SVKEDIVhclProp">Properties &nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDIVhclPropWei">
                            <label for="SVKEDIVhclPropWei">Weight</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Min</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Decimal</td>
                                            <td>No</td>
                                            <td>1/13</td>
                                            <td></td>
                                            <td>0.00</td>
                                            <td>Min. value of the weight</td>
                                        </tr>
                                        <tr>
                                            <td>Max</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Decimal</td>
                                            <td>No</td>
                                            <td>1/13</td>
                                            <td></td>
                                            <td>1000</td>
                                            <td>Max.value of the weight</td>
                                        </tr>
                                        <tr>
                                            <td>UOM</td>
                                            <td>CT_UOM</td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha</td>
                                            <td>No</td>
                                            <td>1/4</td>
                                            <td></td>
                                            <td>Kg</td>
                                            <td>The standard unit of measurement for weight in kg</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>


<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropvol">
            <label for="SVKEDIVhclPropvol">Volume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the Volume</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>1,00</td>
                            <td>Max.value of the Volume</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>cbm</td>
                            <td>The standard unit of measurement for  Volume in Cubic Meters</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropLen">
            <label for="SVKEDIVhclPropLen">Length</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the length</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>1</td>
                            <td>Max value of the length</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>M</td>
                            <td>The standard unit of measurement for Length in Meters</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropWid">
            <label for="SVKEDIVhclPropWid">Width</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the width</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>1</td>
                            <td>Max value of the width</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>M</td>
                            <td>The standard unit of measurement for width in Meters</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropHei">
            <label for="SVKEDIVhclPropHei">Height</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the Height of the cargo</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>1</td>
                            <td>Max value of the Height of the cargo</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>M</td>
                            <td>The standard unit of measurement for height in Meters</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropDis">
            <label for="SVKEDIVhclPropDis">Distance</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the Distance</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Max value of the distance in meters</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>The standard unit of measurement for Distance  in Meters</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropDimGir">
            <label for="SVKEDIVhclPropDimGir">Dimension Girth</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>min value of the dimension of the cargo</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Max value of the dimension of the cargo</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>The standard unit of measurement for dimension of cargo</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropShipUnt">
            <label for="SVKEDIVhclPropShipUnt">ShipmentUnit</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min value of the shipment unit no.</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Max value of the shipment unit no.</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>The standard unit of measurment of Shipments in no</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropPKGWei">
            <label for="SVKEDIVhclPropPKGWei">PacketWeight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min. value of the weight of the packet</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Max value of the weight of the packet</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>The standard unit of measurement of weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIVhclPropPKTVol">
            <label for="SVKEDIVhclPropPKTVol">PacketVolume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Min</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>Min value of the volume of the packet</td>
                        </tr>
                        <tr>
                            <td>Max</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Max value of the volume of the packet</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>The standard unit of measurement of volume of packet</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>


<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDvrDts">
            <label for="SVKEDIDvrDts">DriverDetails&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>DriverId</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/10</td>
                            <td></td>
                            <td>897987894894</td>
                            <td>Unique I.D generated by at creation</td>
                        </tr>
                        <tr>
                            <td>DriverName</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>HUSHU</td>
                            <td>Driver Name</td>
                        </tr>
                        <tr>
                            <td>DriverLicence</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/120</td>
                            <td></td>
                            <td>CHINA0021</td>
                            <td>Drivers Licence</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDvrAddr">
                    <label for="SVKEDIDvrAddr">Address&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Address1</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/255</td>
                                    <td></td>
                                    <td></td>
                                    <td>Drivers Address Details</td>
                                </tr>
                                <tr>
                                    <td>Address2</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/255</td>
                                    <td></td>
                                    <td></td>
                                    <td>Drivers Address Details</td>
                                </tr>
                                <tr>
                                    <td>Street</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/255</td>
                                    <td></td>
                                    <td>JIANGSU</td>
                                    <td>Driver Street Name</td>
                                </tr>
                                <tr>
                                    <td>City</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>SHANGHAI</td>
                                    <td>Driver City </td>
                                </tr>
                                <tr>
                                    <td>State</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>SHANGHAI</td>
                                    <td>Driver State</td>
                                </tr>
                                <tr>
                                    <td>Postal</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/60</td>
                                    <td></td>
                                    <td>200001</td>
                                    <td>Driver Postal</td>
                                </tr>
                                <tr>
                                    <td>Country</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/30</td>
                                    <td></td>
                                    <td>CHINA</td>
                                    <td>Driver Country</td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDIDvrAddConInfo">
                            <label for="SVKEDIDvrAddConInfo">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>CountryCode</td>
                                            <td>CT_Country code</td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/2</td>
                                            <td></td>
                                            <td>64</td>
                                            <td>Driver Country Code</td>
                                        </tr>
                                        <tr>
                                            <td>ContactNo</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/10</td>
                                            <td></td>
                                            <td>1023456789</td>
                                            <td>Driver ContactNo</td>
                                        </tr>
                                        <tr>
                                            <td>EmailAddress</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/100</td>
                                            <td></td>
                                            <td>HY.DR@EMAIL.COM</td>
                                            <td>Driver email id</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>


<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPCRGOSUM">
            <label for="SVKEDITPCRGOSUM">CargoSummary</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPCRGOSUMTQ">
                    <label for="SVKEDITPCRGOSUMTQ">TotalQuantity</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Value</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Decimal</td>
                                    <td>No</td>
                                    <td>1/13</td>
                                    <td></td>
                                    <td>1</td>
                                    <td>The value denoting the quantity in no</td>
                                </tr>
                                <tr>
                                    <td>UOM</td>
                                    <td>CT_UOM</td>
                                    <td>Y</td>
                                    <td>Fixed</td>
                                    <td>Alpha</td>
                                    <td>No</td>
                                    <td>1/4</td>
                                    <td></td>
                                    <td>Numbers</td>
                                    <td>the standard unit of measurement for cargo quantiy in no.</td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPCRGOSUMTV">
            <label for="SVKEDITPCRGOSUMTV">TotalVolume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Fixed</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>1.78</td>
                            <td>the value defining the volume of the cargo </td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Fixed</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>cbm</td>
                            <td>the standard unit of the volume of the cargo in cbm</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPCRGOSUMTW">
            <label for="SVKEDITPCRGOSUMTW">TotalWeight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/10</td>
                            <td></td>
                            <td>180</td>
                            <td>the value of the weight of the cargo</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>Kg</td>
                            <td>The standard unit of measurement of weight in kg</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODRDET">
            <label for="SVKEDITPODRDET">TripOrderDetails</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>OrderID</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td>1/10</td>
                            <td></td>
                            <td>8622510011</td>
                            <td>Generated Unique I.D </td>
                        </tr>
                        <tr>
                            <td>EXTOrderID</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td>1/10</td>
                            <td></td>
                            <td>8622510011</td>
                            <td>External ID if generated else by default take Order ID no</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODRDETTRAN">
                    <label for="SVKEDITPODRDETTRAN">Transits</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>TransitLegId</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>Yes</td>
                                    <td>1/12</td>
                                    <td></td>
                                    <td>8622510011-1</td>
                                    <td>Denotes the type of leg of the shipment in case of multiple leg within the same trip&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>
<tr>
    <td>OrderType</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
    <td>No</td>
    <td>1/60</td>
    <td></td>
    <td>730115 - DOMESTIC TRANSPORT</td>
    <td>Order Type </td>
</tr>
<tr>
    <td>ModeOfTransport</td>
    <td>CT_Mode of Transport</td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
    <td>No</td>
    <td>1/60</td>
    <td></td>
    <td>LTL</td>
    <td>mode of transport - less than truck load </td>
</tr>
<tr>
    <td>Product</td>
    <td>CT_Product </td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
    <td>No</td>
    <td>1/60</td>
    <td></td>
    <td>KN AsiaLink</td>
    <td>Product detail</td>
</tr>
<tr>
    <td>ServiceType</td>
    <td>CT_Service Type</td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td>1/60</td>
    <td></td>
    <td>Less Than Truck Load</td>
    <td>Servicetype needed - less than truck load</td>
</tr>
<tr>
    <td>GoodsValue</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Decimal</td>
    <td>No</td>
    <td>0/60</td>
    <td></td>
    <td>3</td>
    <td>Value of the goods</td>
</tr>
<tr>
    <td>TypeOfBusiness</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
    <td>No</td>
    <td>0/15</td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODRDETTEROFTRD">
            <label for="SVKEDITPODRDETTEROFTRD">TermsOfTrade</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Incoterm</td>
                            <td>CT_Inco Terms</td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/60</td>
                            <td></td>
                            <td></td>
                            <td>Defines of the terms of sale and is globally used International Commerical Terms&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODRDETFGTNAM">
                    <label for="SVKEDITPODRDETFGTNAM">FreightName</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Term</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/60</td>
                                    <td></td>
                                    <td></td>
                                    <td>Freight Terms</td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/60</td>
                                    <td></td>
                                    <td></td>
                                    <td>Name of the Delivery term linked to INCO terms</td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODRDCUSDTS">
            <label for="SVKEDITPODRDCUSDTS">OrderCargoSummary</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDICdCom">
                    <label for="SVKEDICdCom">TotalQuantity&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr >
                                    <td>Value</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>Yes</td>
                                    <td>1/10</td>
                                    <td></td>
                                    <td>30</td>
                                    <td>The Total quantity /no. of packages of the cargo at the Order level</td>
                                </tr>
                                <tr>
                                    <td>UOM</td>
                                    <td>CT_UOM</td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>Yes</td>
                                    <td>1/10</td>
                                    <td></td>
                                    <td>Numerics</td>
                                    <td>The unit of measurement for the quantity of cargo</td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODCUSORDADD">
            <label for="SVKEDITPODCUSORDADD">Volume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>5.07</td>
                            <td>The Total value for the volume of the cargo</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>CBM</td>
                            <td>The unit of measurement for the volume</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDICdParRef">
            <label for="SVKEDICdParRef">ActualVolume&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>6.09</td>
                            <td>Actual volume of the cargo</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>CBM</td>
                            <td>The unit of measurement for the actual  volume</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIWeight">
            <label for="SVKEDIWeight">Weight&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>200.70</td>
                            <td>Value for the weight</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>KG</td>
                            <td>The Unit of measurement for the weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIActualWeight">
            <label for="SVKEDIActualWeight">ActualWeight&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>193.97</td>
                            <td>Value for the Actual weight</td>
                        </tr>
                        <tr>
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td>KG</td>
                            <td>The Unit of measurement for the  Actual weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCIN">
            <label for="SVKEDITPODLOCIN">LocationInfo</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINSRC">
                    <label for="SVKEDITPODLOCINSRC">Source</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>ID</td>

                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td></td>
                                    <td></td>
                                    <td>6666666666</td>
                                    <td>Generated Unique I.D </td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDISrcCom">
                            <label for="SVKEDISrcCom">Company&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Name</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/30</td>
                                            <td></td>
                                            <td>AGROS LIMITED</td>
                                            <td>Denotes the name of the Source Location</td>
                                        </tr>
                                        <tr>
                                            <td>RegistrationNumber</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/30</td>
                                            <td></td>
                                            <td>67JTANRG002</td>
                                            <td>Denotes the  legal regristration no of the Source</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINSRCADD">
            <label for="SVKEDITPODLOCINSRCADD">Address</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>CompanyName</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>FLIGHT PLASTICS</td>
                            <td>Company Name</td>
                        </tr>
                        <tr>
                            <td>Address1</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>75 Wainui Road</td>
                            <td>Address</td>
                        </tr>
                        <tr>
                            <td>Address2</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>Waiwhetu</td>
                            <td>Address</td>
                        </tr>
                        <tr>
                            <td>Street</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/255</td>
                            <td></td>
                            <td>75 Wainui Road</td>
                            <td>Street details</td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>Lower Hutt</td>
                            <td>City Details</td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>Waiwhettu</td>
                            <td>State info</td>
                        </tr>
                        <tr>
                            <td>Postal</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>5010</td>
                            <td>Postal code/zipcode</td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/30</td>
                            <td></td>
                            <td>New zealand</td>
                            <td>Country name</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINSRCADDCTIN">
                    <label for="SVKEDITPODLOCINSRCADDCTIN">ContactInfo</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>CountryCode</td>
                                    <td>CT_Country code</td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/2</td>
                                    <td></td>
                                    <td>64</td>
                                    <td>CountryCode</td>
                                </tr>
                                <tr>
                                    <td>ContactNo</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/12</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>EmailAddress</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>et.i@email.com</td>
                                    <td>Email ID</td>
                                </tr>


                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td>EstimatedDateTime</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>1/100</td>
    <td></td>
    <td></td>
    <td>Estimated Date and time from starting point</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINSRCESTDT">
            <label for="SVKEDITPODLOCINSRCESTDT">EstimatedDateTime</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>From</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td></td>
                            <td>The From location time</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINSRCESTDTFR">
                    <label for="SVKEDITPODLOCINSRCESTDTFR">From</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>DateTime</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/19</td>
                                    <td></td>
                                    <td>2/14/2022  11:00:03 AM</td>
                                    <td>The Date and Time info</td>
                                </tr>
                                <tr>
                                    <td>TimeZone</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/12</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>UTC</td>
                                    <td>CT_Timezone</td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>No</td>
                                    <td>1/19</td>
                                    <td></td>
                                    <td></td>
                                    <td>Co ordinated Unique time</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITPODLOCINSRCESTDTUTC">
                            <label for="SVKEDITPODLOCINSRCESTDTUTC">UTC</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Time</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/19</td>
                                            <td></td>
                                            <td>2020-10-08T15:43:48</td>
                                            <td></td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td>TO</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td></td>
    <td>N</td>
    <td></td>
    <td></td>
    <td></td>
    <td>Delivery Location time and date</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINSRCESTDTTO">
            <label for="SVKEDITPODLOCINSRCESTDTTO">TO</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>DateTime</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/19</td>
                            <td></td>
                            <td>2/14/2022  11:00:03 AM</td>
                            <td>Delivery Location time and date</td>
                        </tr>
                        <tr>
                            <td>TimeZone</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/12</td>
                            <td></td>
                            <td>1/0/00 0:00</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>UTC</td>
                            <td>CT_Timezone</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/12</td>
                            <td></td>
                            <td></td>
                            <td>Co ordinated Unique time and date</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINSRCESTDTTOUTC">
                    <label for="SVKEDITPODLOCINSRCESTDTTOUTC">UTC</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Time</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/12</td>
                                    <td></td>
                                    <td>2020-10-08T15:43:48</td>
                                    <td></td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDISrcParRef">
            <label for="SVKEDISrcParRef">PartyReference&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>References</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td></td>
                            <td>Denotes the internal reference made</td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDISrcParReferences">
                    <label for="SVKEDISrcParReferences">References&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDISrcParRefTyp">
                            <label for="SVKEDISrcParRefTyp">RefType&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Code</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/11</td>
                                            <td></td>
                                            <td>SHOWMAP</td>
                                            <td>Denotes the reference that is opted in eTn to reflect the transmission of data</td>
                                        </tr>
                                        <tr>
                                            <td>Value</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/4</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>The referene option that is inputted by the user</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDISrcAddConInfo">
            <label for="SVKEDISrcAddConInfo">AdditionalContactInfo&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ContactInfo</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>Y</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDISrcAddConInfo2">
                    <label for="SVKEDISrcAddConInfo2">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/25</td>
                                    <td></td>
                                    <td>XYZ INDUSTRY</td>
                                    <td>Name of the Additional Party involved if any</td>
                                </tr>
                                <tr>
                                    <td>Street</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>JIANSU</td>
                                    <td>Defines the Street of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>City</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>BEJING</td>
                                    <td>Defines the City of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>State</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>SHANGAI</td>
                                    <td>Defines the State of the contact entity/person</td>
                                </tr>

                                <tr>
                                    <td>Postal</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>450025</td>
                                    <td>Postal/zip code of the country</td>
                                </tr>
                                <tr>
                                    <td>Country</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>CHINA</td>
                                    <td>Defines the Country of the contact  entity</td>
                                </tr>
                                <tr>
                                    <td>Phone</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>8546546466</td>
                                    <td>Contact no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Fax</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>TEST </td>
                                    <td>Fax no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/100</td>
                                    <td></td>
                                    <td>TEST </td>
                                    <td>Email address of the contact entity</td>
                                </tr>


                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINDT">
            <label for="SVKEDITPODLOCINDT">Destination</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ID</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric &nbsp;&nbsp;</td>
                            <td>No</td>
                            <td></td>
                            <td></td>
                            <td>6666666666</td>
                            <td>Generated Unique I.D </td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDtCom">
                    <label for="SVKEDIDtCom">Company&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/30</td>
                                    <td></td>
                                    <td>AGROS LIMITED</td>
                                    <td>Denotes the name of the customer</td>
                                </tr>
                                <tr>
                                    <td>RegistrationNumber</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/30</td>
                                    <td></td>
                                    <td>67JTANRG002</td>
                                    <td>Denotes the  legal regristration no of the customer</td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINDTADD">
            <label for="SVKEDITPODLOCINDTADD">Address</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>CompanyName</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>FLIGHT PLASTICS</td>
                            <td>Company Name</td>
                        </tr>
                        <tr>
                            <td>Address1</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>75 Wainui Road</td>
                            <td>Address</td>
                        </tr>
                        <tr>
                            <td>Address2</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>Waiwhetu</td>
                            <td>Address</td>
                        </tr>
                        <tr>
                            <td>Street</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/255</td>
                            <td></td>
                            <td>75 Wainui Road</td>
                            <td>Street details</td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>Lower Hutt</td>
                            <td>City Details</td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>Waiwhettu</td>
                            <td>State info</td>
                        </tr>
                        <tr>
                            <td>Postal</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>5010</td>
                            <td>Postal code/zipcode</td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/30</td>
                            <td></td>
                            <td>New zealand</td>
                            <td>Country name</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINDTADDCTIN">
                    <label for="SVKEDITPODLOCINDTADDCTIN">ContactInfo</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>CountryCode</td>
                                    <td>CT_Country code</td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/2</td>
                                    <td></td>
                                    <td>64</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>ContactNo</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/12</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>EmailAddress</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/100</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>


                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>


<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINDTESTDT">
            <label for="SVKEDITPODLOCINDTESTDT">EstimatedDateTime</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINDTESTDTFR">
                    <label for="SVKEDITPODLOCINDTESTDTFR">From</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>DateTime</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/19</td>
                                    <td></td>
                                    <td>2/15/2022  10:00:19 AM</td>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>TimeZone</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/12</td>
                                    <td></td>
                                    <td>00:00.0</td>
                                    <td></td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITPODLOCINDTESTDTUTC">
                            <label for="SVKEDITPODLOCINDTESTDTUTC">UTC</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Time</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>1/12</td>
                                            <td></td>
                                            <td>2020-10-08T15:43:48</td>
                                            <td></td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPODLOCINDTESTDTTO">
            <label for="SVKEDITPODLOCINDTESTDTTO">TO</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>DateTime</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/19</td>
                            <td></td>
                            <td>2/15/2022  10:00:01 AM</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>TimeZone</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                            <td>No</td>
                            <td>1/12</td>
                            <td></td>
                            <td>12:00 AM</td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPODLOCINDTESTDTTOUTC">
                    <label for="SVKEDITPODLOCINDTESTDTTOUTC">UTC</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Time</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/12</td>
                                    <td></td>
                                    <td>2020-10-08T15:43:48</td>
                                    <td></td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDtParRef">
            <label for="SVKEDIDtParRef">PartyReference&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>References</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                            <td>Yes</td>
                            <td>0/10</td>
                            <td></td>
                            <td></td>
                            <td>denotes the internal reference made </td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDtParReferences">
                    <label for="SVKEDIDtParReferences">References&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDIDtParRefTyp">
                            <label for="SVKEDIDtParRefTyp">RefType&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Code</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/11</td>
                                            <td></td>
                                            <td>ROADLOG</td>
                                            <td>denotes the referene opted in eTn</td>
                                        </tr>
                                        <tr>
                                            <td>Value</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/4</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>The referene option that is inputted as Y or Yes,N or No</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDtAddConInfo">
            <label for="SVKEDIDtAddConInfo">AdditionalContactInfo&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ContactInfo</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>Yes</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDtAddConInfo2">
                    <label for="SVKEDIDtAddConInfo2">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/25</td>
                                    <td></td>
                                    <td>XYZ INDUSTRY</td>
                                    <td>Name of the Additional Party involved if any</td>
                                </tr>
                                <tr>
                                    <td>Street</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>JIANSU</td>
                                    <td>Defines the Street of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>City</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>BEJING</td>
                                    <td>Defines the City of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>State</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>SHANGAI</td>
                                    <td>Defines the State of the contact entity/person</td>
                                </tr>

                                <tr>
                                    <td>Postal</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>450025</td>
                                    <td>Postal/zip code of the country</td>
                                </tr>
                                <tr>
                                    <td>Country</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>CHINA</td>
                                    <td>Defines the Country of the contact  entity</td>
                                </tr>
                                <tr>
                                    <td>Phone</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>8546546466</td>
                                    <td>Contact no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Fax</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>TEST</td>
                                    <td>Fax no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/100</td>
                                    <td></td>
                                    <td>TEST</td>
                                    <td>Email address of the contact entity</td>
                                </tr>


                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTS">
            <label for="SVKEDITPORDDTSCRGDTS">CargoDetails</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHU">
                    <label for="SVKEDITPORDDTSCRGDTSTHU">TransportHandlingUnit</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>CargoType</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>Yes</td>
                                    <td>1/60</td>
                                    <td></td>
                                    <td>40OT</td>
                                    <td>Cargo type</td>
                                </tr>
                                <tr>
                                    <td>GoodsDescription</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/100</td>
                                    <td></td>
                                    <td>Paper</td>
                                    <td>The description of Goods at Order level</td>
                                </tr>
                                <tr>
                                    <td>MarksandNumbers</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>1/50</td>
                                    <td></td>
                                    <td>89TR89</td>
                                    <td>The specific optional field identify different pieces of cargo</td>
                                </tr>
                                <tr>
                                    <td>ValueOfGoods</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>No</td>
                                    <td>1/20</td>
                                    <td></td>
                                    <td></td>
                                    <td>The total value of the goods keyed in by the user</td>
                                </tr>
                                <tr>
                                    <td>HandlingUnit</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td>No</td>
                                    <td>1/60</td>
                                    <td></td>
                                    <td>40OT</td>
                                    <td>The packaging structure/equipment used in handling the cargo</td>
                                </tr>
                                <tr>
                                    <td>ItemId</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>No</td>
                                    <td>1/20</td>
                                    <td></td>
                                    <td>40OT</td>
                                    <td>The identification no. of the cargo item</td>
                                </tr>
                                <tr>
                                    <td>Length</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>Length of the cargo</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUL">
                            <label for="SVKEDITPORDDTSCRGDTSTHUL">Length</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr >
                                            <td>Value</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Decimal</td>
                                            <td>No</td>
                                            <td>1/13</td>
                                            <td></td>
                                            <td>0</td>
                                            <td>Value of the item</td>
                                        </tr>
                                        <tr>
                                            <td>UOM</td>
                                            <td>CT_UOM</td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha</td>
                                            <td>No</td>
                                            <td>1/4</td>
                                            <td></td>
                                            <td>m</td>
                                            <td>The standard unit of measurement used</td>
                                        </tr>
                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>
<tr>
    <td>Width</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUW">
            <label for="SVKEDITPORDDTSCRGDTSTHUW">Width</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>The value of the width given</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>The standard unit of measurement for width</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>Height</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUH">
            <label for="SVKEDITPORDDTSCRGDTSTHUH">Height</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>value</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>The unit of measurement for Height</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>ActualWeight</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUAW">
            <label for="SVKEDITPORDDTSCRGDTSTHUAW">ActualWeight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Value denoting Actual  weight</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>The unit of measurement for  Actual weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>Weight</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUAWE">
            <label for="SVKEDITPORDDTSCRGDTSTHUAWE">Weight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Value denoting   weight</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>The unit of measurement for  weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>VolumetricWeight</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUVW">
            <label for="SVKEDITPORDDTSCRGDTSTHUVW">VolumetricWeight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Value denoting volumetric weight</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>The unit of measurement of volumetric weight</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>Volume</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUVOL">
            <label for="SVKEDITPORDDTSCRGDTSTHUVOL">Volume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Denoting value</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>the unit of measurement in volume</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>ActualVolume</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>No</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUAVOL">
            <label for="SVKEDITPORDDTSCRGDTSTHUAVOL">ActualVolume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Decimal</td>
                            <td>No</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0</td>
                            <td>Value denoting the actual volume</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/4</td>
                            <td></td>
                            <td>cbm</td>
                            <td>The unit of measurement of actual volume</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>Quantity</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Decimal</td>
    <td>No</td>
    <td>1/10</td>
    <td></td>
    <td>1.00</td>
    <td>Quantity of the cargo</td>
</tr>
<tr>
    <td>ScannedQuantity</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Decimal</td>
    <td>No</td>
    <td>1/10</td>
    <td></td>
    <td>1</td>
    <td></td>
</tr>
<tr >
    <td>ldm</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Numeric</td>
    <td>No</td>
    <td>1/1</td>
    <td></td>
    <td></td>
    <td>Loading meter-measuring the size of goods transported by a truck</td>
</tr>
<tr>
    <td>GroundedFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Numeric</td>
    <td>No</td>
    <td>1/1</td>
    <td></td>
    <td>0</td>
    <td></td>
</tr>
<tr>
    <td>StackableFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Numeric</td>
    <td>No</td>
    <td>1/1</td>
    <td></td>
    <td>0</td>
    <td></td>
</tr>
<tr>
    <td>SplittableFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Numeric</td>
    <td>No</td>
    <td>1/1</td>
    <td></td>
    <td>0</td>
    <td></td>
</tr>
<tr>
    <td>DangerousGoodsFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td>0</td>
    <td></td>
</tr>
<tr>
    <td>TotalPackagesOfDangerousGoods</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td></td>
    <td></td>
</tr>
<tr>
    <td>DangerousGoods</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDgrGoods">
            <label for="SVKEDIDgrGoods">DangerousGoods&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>DangerousGoodsPosition</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDgrGoodsPos">
                    <label for="SVKEDIDgrGoodsPos">DangerousGoodsPosition&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>NumberOfPackages</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td>0/20</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDINoOfPakgs">
                            <label for="SVKEDINoOfPakgs">NumberOfPackages&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Value</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric</td>
                                            <td>N0</td>
                                            <td>0/20</td>
                                            <td></td>
                                            <td>2</td>
                                            <td>Defines the value of
                                                the Dangerous Goods</td>
                                        </tr>
                                        <tr>
                                            <td>QuantityType</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric</td>
                                            <td>No</td>
                                            <td>0/20</td>
                                            <td></td>
                                            <td>NUMBERS</td>
                                            <td>Definesthevalueof
                                                theDangerousGoods</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDgrGoodsDts">
            <label for="SVKEDIDgrGoodsDts">DangerousGoodsDetails&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIDgrGoodsQty">
                    <label for="SVKEDIDgrGoodsQty">DangerousGoodsQuantity&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Value</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td>0/20</td>
                                    <td></td>
                                    <td>2</td>
                                    <td>Definesthevalueof
                                        theDangerousGoods</td>
                                </tr>
                                <tr>
                                    <td>QuantityType</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td>0/20</td>
                                    <td></td>
                                    <td>kg</td>
                                    <td>Definesthe
                                        quantityoftheDangerousGoods</td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIUnoNo">
            <label for="SVKEDIUnoNo">UnitedNationsOrganisationNumber&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Value</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td>123578UI</td>
                            <td>The standard code
                                provided by the UNO for the Dangerous Goods trade</td>
                        </tr>
                        <tr>
                            <td>Variant</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td>UIEV789</td>
                            <td>Thes tandard updated
                                verison code provided by the UNO for the Dangerous Goods trade</td>
                        </tr>

                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>DangerousGoodsClass</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td>ABC</td>
    <td>The standard class
        code provided by the UNO for the Dangerous Goods
        trade</td>
</tr>
<tr>
    <td>MainRisk</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td>UIEV789</td>
    <td>The risk management
        plan prescribed by UNO for DG cargo</td>
</tr>
<tr>
    <td>SubsidiaryRisks</td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td>UIEV789</td>
    <td></td>
</tr>
<tr>
    <td>PackingGroup</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td>PKGR34</td>
    <td>The group no provided
        for DG cargo</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDgrGoodsDes">
            <label for="SVKEDIDgrGoodsDes">DangerousGoodsDescriptions&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Language</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td>CN</td>
                            <td>the language of the
                                DG cargo sender country</td>
                        </tr>
                        <tr>
                            <td>ProperShippingName</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td>choushippingco</td>
                            <td></td>
                        </tr>

                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
<tr>
    <td>LimitedQuantityFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td></td>
    <td></td>
</tr>
<tr>
    <td>ExceptedQuantityFlag</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td></td>
    <td></td>
</tr>
<tr>
    <td>HighConsequence</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>No</td>
    <td>0/20</td>
    <td></td>
    <td></td>
    <td></td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIDgrGoodsRaodfrght">
            <label for="SVKEDIDgrGoodsRaodfrght">Roadfreight&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>TunnelRestrictionCode</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>


                        <tr>
                            <td>TransportCategory</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>EnvironmentallyHazardous</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>NOS</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ADRMultiplicator</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>TotalADRPoints</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ADRVersion</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/20</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>



                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>



</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPU">
            <label for="SVKEDITPORDDTSCRGDTSTHUPU">Packagingunit</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>PackageType</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td></td>
                            <td>No</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>type of package inside packaging-unit</td>
                        </tr>
                        <tr>
                            <td>PackageDescription</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td></td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td></td>
                            <td>details/descriptionof
                                inner packages</td>
                        </tr>
                        <tr>
                            <td>Quantity</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td>1/10</td>
                            <td></td>
                            <td>1.00</td>
                            <td>package quantity</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPUL">
                    <label for="SVKEDITPORDDTSCRGDTSTHUPUL">Length</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr >
                                    <td>Value</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>No</td>
                                    <td>1/13</td>
                                    <td></td>
                                    <td>0.00</td>
                                    <td>value of inner package</td>
                                </tr>
                                <tr >
                                    <td>UOM</td>
                                    <td>CT_UOM</td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td>No</td>
                                    <td>1/4</td>
                                    <td></td>
                                    <td>m</td>
                                    <td>UOM of inner package </td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPUW">
            <label for="SVKEDITPORDDTSCRGDTSTHUPUW">Width</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>Yes</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>value of inner package</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>Yes</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>UOM of inner package</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPUH">
            <label for="SVKEDITPORDDTSCRGDTSTHUPUH">Height</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>Yes</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.00</td>
                            <td>value of inner package</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>Yes</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>UOM of inner package</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPUWE">
            <label for="SVKEDITPORDDTSCRGDTSTHUPUWE">Weight</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td></td>
                            <td>Yes</td>
                            <td>1/13</td>
                            <td></td>
                            <td></td>
                            <td>value of inner package</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>Yes</td>
                            <td>1/4</td>
                            <td></td>
                            <td></td>
                            <td>UOM of inner package</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTSCRGDTSTHUPUVOL">
            <label for="SVKEDITPORDDTSCRGDTSTHUPUVOL">Volume</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>Value</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>Yes</td>
                            <td>1/13</td>
                            <td></td>
                            <td>0.000</td>
                            <td>value of inner package</td>
                        </tr>
                        <tr >
                            <td>UOM</td>
                            <td>CT_UOM</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>Yes</td>
                            <td>1/4</td>
                            <td></td>
                            <td>m</td>
                            <td>UOM of inner package</td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>

<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTVDS">
            <label for="SVKEDITPORDDTVDS">ValueAddedServices</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Addon</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td></td>
                            <td>Yes</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>addon</td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTVDSADDON">
                    <label for="SVKEDITPORDDTVDSADDON">Addon</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>AddonName</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/60</td>
                                    <td></td>
                                    <td>Freight</td>
                                    <td>addon name</td>
                                </tr>
                                <tr>
                                    <td>AddonCode</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/30</td>
                                    <td></td>
                                    <td>Customs</td>
                                    <td>addon code</td>
                                </tr>
                                <tr>
                                    <td>Currency</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td></td>
                                    <td>addon currency</td>
                                </tr>
                                <tr>
                                    <td>RateUnit</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td></td>
                                    <td>rate unit</td>
                                </tr>
                                <tr>
                                    <td>AddonAmount</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td></td>
                                    <td>addon amount</td>
                                </tr>
                                <tr>
                                    <td>AddonQuantity</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td></td>
                                    <td>Yes</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td></td>
                                    <td>addon quantity</td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td>InvolvedParties</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha</td>
    <td>Yes</td>
    <td></td>
    <td></td>
    <td></td>
    <td>involved parties</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTIP">
            <label for="SVKEDITPORDDTIP">InvolvedParties</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>PartyType=(REFER CT_PARTY TYPE)</td>
                            <td>CT_Partytype</td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>Yes</td>
                            <td>1/10</td>
                            <td></td>
                            <td>Shipper</td>
                            <td>party type</td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTPT">
                    <label for="SVKEDITPORDDTPT">PartyType</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>ID</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>Yes</td>
                                    <td>1/10</td>
                                    <td></td>
                                    <td>2621000001</td>
                                    <td>ID of particular party type-CID in the database</td>
                                </tr>
                                <tr>
                                    <td>Company</td>
                                    <td></td>
                                    <td>Y</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td>Yes</td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td>company name of party type</td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITPORDDTPTCOM">
                            <label for="SVKEDITPORDDTPTCOM">Company</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Name</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Alpha</td>
                                            <td>Yes</td>
                                            <td>1/100</td>
                                            <td></td>
                                            <td>2621000001</td>
                                            <td>name of particular person in party type </td>
                                        </tr>
                                        <tr >
                                            <td>RegistrationNumber</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Variable</td>
                                            <td>Numeric</td>
                                            <td>Yes</td>
                                            <td>1/10</td>
                                            <td></td>
                                            <td>2621000001</td>
                                            <td>registration number of party type</td>
                                        </tr>
                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>
<tr>
    <td>Address</td>
    <td></td>
    <td>Y</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td>Yes</td>
    <td></td>
    <td></td>
    <td></td>
    <td>address details of party in party type</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTPTADD">
            <label for="SVKEDITPORDDTPTADD">Address</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>FirstName</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td></td>
                            <td></td>
                            <td>2621000001</td>
                            <td>firstname of party in party type</td>
                        </tr>
                        <tr>
                            <td>LastName</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td></td>
                            <td></td>
                            <td>2621000001</td>
                            <td>lastname of party in party type</td>
                        </tr>
                        <tr>
                            <td>Address1</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>75 Wainui Road,Lower Hutt,Waiwhetu</td>
                            <td>address1 of party in party type</td>
                        </tr>
                        <tr>
                            <td>Address2</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>0/255</td>
                            <td></td>
                            <td>75 Wainui Road,Lower Hutt,Waiwhetu</td>
                            <td>address2 of party in party type</td>
                        </tr>
                        <tr>
                            <td>Street</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric</td>
                            <td>No</td>
                            <td>1/255</td>
                            <td></td>
                            <td>75 Wainui Road</td>
                            <td>Street</td>
                        </tr>
                        <tr>
                            <td>City</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>LOWER HUTT</td>
                            <td>City</td>
                        </tr>
                        <tr>
                            <td>State</td>
                            <td></td>
                            <td>Y</td>
                            <td>Variable</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/100</td>
                            <td></td>
                            <td>Waiwhetu</td>
                            <td>State</td>
                        </tr>
                        <tr>
                            <td>Postal</td>
                            <td></td>
                            <td>Y</td>
                            <td>Fixed</td>
                            <td>Numeric</td>
                            <td>No</td>
                            <td>1/60</td>
                            <td></td>
                            <td>5010</td>
                            <td>Postal</td>
                        </tr>
                        <tr>
                            <td>Country</td>
                            <td></td>
                            <td>Y</td>
                            <td>Fixed</td>
                            <td>Alpha</td>
                            <td>No</td>
                            <td>1/30</td>
                            <td></td>
                            <td>NE</td>
                            <td>Country</td>
                        </tr>
                        <tr>
                            <td>ContactInfo</td>
                            <td></td>
                            <td>N</td>
                            <td>Fixed</td>
                            <td></td>
                            <td>No</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td>Contact Information of Party</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTPTADDCONINFO">
                    <label for="SVKEDITPORDDTPTADDCONINFO">ContactInfo</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>CountryCode</td>
                                    <td>CT_Countrycode</td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric</td>
                                    <td>No</td>
                                    <td>0/2</td>
                                    <td></td>
                                    <td>64</td>
                                    <td>country code of party in party type</td>
                                </tr>
                                <tr>
                                    <td>ContactNo</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td>No</td>
                                    <td>0/12</td>
                                    <td></td>
                                    <td>ALTOWLG</td>
                                    <td>Contact number of party in party type</td>
                                </tr>
                                <tr>
                                    <td>EmailAddress</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td>0/100</td>
                                    <td></td>
                                    <td></td>
                                    <td>email address of party in party type</td>
                                </tr>
                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td>PartyReference</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td>Alpha-Numeric</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>Party reference type to be discussed per carrier</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIInvParRef">
            <label for="SVKEDIInvParRef">PartyReference&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>References</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td></td>
                            <td>Yes</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIInvParReferences">
                    <label for="SVKEDIInvParReferences">References&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDIInvParRefTyp">
                            <label for="SVKEDIInvParRefTyp">RefType&nbsp;&nbsp;&nbsp;</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Code</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/60</td>
                                            <td></td>
                                            <td>ROADLOG</td>
                                            <td>Reference Code</td>
                                        </tr>
                                        <tr>
                                            <td>Value</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Decimal &nbsp;&nbsp;</td>
                                            <td>No</td>
                                            <td>0/60</td>
                                            <td></td>
                                            <td>Y</td>
                                            <td>Reference Value</td>
                                        </tr>

                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>


</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDIInvParAdditionaConInfo">
            <label for="SVKEDIInvParAdditionaConInfo">AdditionalContactInfo&nbsp;&nbsp;&nbsp;</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ContactInfo</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td>Alpha-Numeric &nbsp;&nbsp;</td>
                            <td>Yes</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDIInvParAddConInfo2">
                    <label for="SVKEDIInvParAddConInfo2">ContactInfo&nbsp;&nbsp;&nbsp;</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Name</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/25</td>
                                    <td></td>
                                    <td>XYZ INDUSTRY</td>
                                    <td>Name of the additional party involved if any</td>
                                </tr>
                                <tr>
                                    <td>Street</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>JIANSU</td>
                                    <td>Defines the street of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>City</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>BEJING</td>
                                    <td>Defines the city of the contact entity</td>
                                </tr>
                                <tr>
                                    <td>State</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>SHANGAI</td>
                                    <td>Defines the state of the contact entity/person</td>
                                </tr>
                                <tr>
                                    <td>Postal</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>450025</td>
                                    <td>Postal/zip code of the country</td>
                                </tr>
                                <tr>
                                    <td>Country</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/15</td>
                                    <td></td>
                                    <td>CHINA</td>
                                    <td>Defines the Country of the contact  entity</td>
                                </tr>
                                <tr>
                                    <td>Phone</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>8546546466</td>
                                    <td>Contact no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Fax</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Numeric &nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/10</td>
                                    <td></td>
                                    <td>TEST</td>
                                    <td>Fax no of the entity</td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric&nbsp;&nbsp;</td>
                                    <td>No</td>
                                    <td>0/100</td>
                                    <td></td>
                                    <td>TEST</td>
                                    <td>Email address of the contact entity</td>
                                </tr>


                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>





</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr >
    <td>ManageReferences</td>
    <td>CT_Managereference</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
    <td>Manage References listed as per CT_Manage reference</td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTMR">
            <label for="SVKEDITPORDDTMR">ManageReferences</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>References</td>
                            <td></td>
                            <td>N</td>
                            <td>Variable</td>
                            <td></td>
                            <td>Yes</td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTMRREF">
                    <label for="SVKEDITPORDDTMRREF">References</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>

                                <tr>
                                    <td colspan="10">
                        <li class="section">
                            <input type="checkbox" id="SVKEDITPORDDTMRREFRT">
                            <label for="SVKEDITPORDDTMRREFRT">RefType</label>
                            <ul>
                                <li>
                                    <Table border=0.5 style="color:black">
                                        <tr style="background-color:lightgrey">
                                            <td>Element  </td>
                                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                                        </tr>
                                        <tr>
                                            <td>Code</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha</td>
                                            <td>No</td>
                                            <td>0/60</td>
                                            <td></td>
                                            <td>PO</td>
                                            <td>Reference code</td>
                                        </tr>
                                        <tr>
                                            <td>Value</td>
                                            <td></td>
                                            <td>N</td>
                                            <td>Variable</td>
                                            <td>Alpha-Numeric</td>
                                            <td>No</td>
                                            <td>0/60</td>
                                            <td></td>
                                            <td>4513224951</td>
                                            <td>Reference value</td>
                                        </tr>
                                    </Table>
                                </li>
                            </ul>
                        </li>
    </td>
</tr>

</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
<tr>
    <td>Remarks</td>
    <td></td>
    <td>N</td>
    <td>Variable</td>
    <td></td>
    <td>Yes</td>
    <td></td>
    <td></td>
    <td></td>
    <td></td>
</tr>
<tr>
    <td colspan="10">
        <li class="section">
            <input type="checkbox" id="SVKEDITPORDDTREMRKS">
            <label for="SVKEDITPORDDTREMRKS">Remarks</label>
            <ul>
                <li>
                    <Table border=0.5 style="color:black">
                        <tr style="background-color:lightgrey">
                            <td>Element  </td>
                            <td>Code table&nbsp;&nbsp;&nbsp;</td>
                            <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                            <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                            <td>Type&nbsp;&nbsp;&nbsp;</td>
                            <td>Loop&nbsp;&nbsp;&nbsp;</td>
                            <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                            <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                            <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>

                        <tr>
                            <td colspan="10">
                <li class="section">
                    <input type="checkbox" id="SVKEDITPORDDTREMRKSRT">
                    <label for="SVKEDITPORDDTREMRKSRT">RemarkType</label>
                    <ul>
                        <li>
                            <Table border=0.5 style="color:black">
                                <tr style="background-color:lightgrey">
                                    <td>Element  </td>
                                    <td>Code table&nbsp;&nbsp;&nbsp;</td>
                                    <td>Mandatory&nbsp;&nbsp;&nbsp;</td>
                                    <td>Fixed / Variable&nbsp;&nbsp;&nbsp;</td>
                                    <td>Type&nbsp;&nbsp;&nbsp;</td>
                                    <td>Loop&nbsp;&nbsp;&nbsp;</td>
                                    <td>Min/max&nbsp;&nbsp;&nbsp;</td>
                                    <td>Trigger Condition&nbsp;&nbsp;&nbsp;</td>
                                    <td>Sample Value&nbsp;&nbsp;&nbsp;</td>
                                    <td>Description&nbsp;&nbsp;&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>Code</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha</td>
                                    <td>No</td>
                                    <td>0/60</td>
                                    <td></td>
                                    <td></td>
                                    <td>The Remark code if any</td>
                                </tr>
                                <tr>
                                    <td>Value</td>
                                    <td></td>
                                    <td>N</td>
                                    <td>Variable</td>
                                    <td>Alpha-Numeric</td>
                                    <td>No</td>
                                    <td>0/60</td>
                                    <td></td>
                                    <td></td>
                                    <td>The Value of the the Remark code</td>
                                </tr>

                            </Table>
                        </li>
                    </ul>
                </li>
    </td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>
</Table>
</li>
</ul>
</li>
</td>
</tr>

</table>
</li>

</ul>
</li>

</ul>
</li>

<li class="section">
    <input type="checkbox" id="TPOUBCT">
    <label for="TPOUBCT">Trip : Cross Reference / Code Table</label>
    <ul>
        <!-- SUB-SECTION -->
        <li class="section">
            <input type="checkbox" id="TPOUBAction">
            <label for="TPOUBAction">Action</label>
            <ul>
                <li>
                    <h2>Code table : CT_ACTION</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ACT_01</td>
                            <td>I</td>
                            <td>INSERT</td>
                            <td>I</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ACT_02</td>
                            <td>U</td>
                            <td>UPDATED</td>
                            <td>U</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ACT_03</td>
                            <td>RC</td>
                            <td>REPLACE AND INSERT</td>
                            <td>RC</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ACT_04</td>
                            <td>D</td>
                            <td>Delete</td>
                            <td>D</td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBDes">
            <label for="TPOUBDes">Destination</label>
            <ul>
                <li>
                    <h2>Code table : CT_Destination</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>DEST_01</td>
                            <td>CARRIER</td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBTRUTYMST">
            <label for="TPOUBTRUTYMST">Truck Type Master</label>
            <ul>
                <li>
                    <h2>Code table : CT_Truck Type Master</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_1</td>
                            <td> TRACTOR HEAD</td>
                            <td> TRACTOR HEAD</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_2</td>
                            <td>1 Ton pick-up</td>
                            <td>1 Ton pick-up</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_3</td>
                            <td>1 TONNER </td>
                            <td>1 TONNER </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_4</td>
                            <td>1 TONNER Reefer</td>
                            <td>1 TONNER Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_5</td>
                            <td>1.0T</td>
                            <td>1.0T</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_6</td>
                            <td>1.3 Tonner </td>
                            <td>1.3 Tonner closed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_7</td>
                            <td>1/2 Tonner</td>
                            <td>1/2 tonner bakkie</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_8</td>
                            <td>10 Ton pick-up</td>
                            <td>10 Ton pick-up</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_9</td>
                            <td>10 Wheeler Cabinet</td>
                            <td>TEN_WHEELER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_10</td>
                            <td>10W</td>
                            <td>10W</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_11</td>
                            <td>10W Cabinet (Dry)</td>
                            <td>10
                                &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3649;&#3627;&#3657;&#3591;</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_12</td>
                            <td>10W Cabinet
                                (Temperature Control)</td>
                            <td>10W Cabinet
                                (Temperature Control)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_13</td>
                            <td>10W Trailer</td>
                            <td>10W Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_14</td>
                            <td>10WWV</td>
                            <td>10WWV</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_15</td>
                            <td>12 M</td>
                            <td>Flatbed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_16</td>
                            <td>12 METER Truck Test</td>
                            <td>12 METER Truck Test</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_17</td>
                            <td>12 TON</td>
                            <td>12 TON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_18</td>
                            <td>12 Tonner</td>
                            <td>12 Ton</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_19</td>
                            <td>12 Tonner Split Deck</td>
                            <td>12 Tonner Split </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_20</td>
                            <td>125MTRK</td>
                            <td>12.5M Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_21</td>
                            <td>12M Trailer</td>
                            <td>12M Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_22</td>
                            <td>12Mtr Curtain trailer</td>
                            <td>12Mtr Curtain trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_23</td>
                            <td>12Mtr Flatbed trailer</td>
                            <td>12Mtr Flatbed trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_24</td>
                            <td>12T</td>
                            <td>12 Tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_25</td>
                            <td>12TA</td>
                            <td>12 Tonne Tautliner</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_26</td>
                            <td>13.5 CURTAINSIDE
                                TRUCK</td>
                            <td>JOHNSON &amp; JOHNSON
                                PRODUCTS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_27</td>
                            <td>13.6 mtr trailer</td>
                            <td>Curtainsider
                                arctic/box trailer approx. 26 pallets</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_28</td>
                            <td>13M MEA-CLASSIC TRUCK</td>
                            <td>13M Truck + Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_29</td>
                            <td>13M Trailer</td>
                            <td>13M Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_30</td>
                            <td>13Mtr Box truck</td>
                            <td>13Mtr Box truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_31</td>
                            <td>13Mtr Curtain trailer</td>
                            <td>13Mtr Curtain trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_32</td>
                            <td>13Mtr Flatbed  trailer</td>
                            <td>13Mtr Flatbed  trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_33</td>
                            <td>13Mtr Reefer truck</td>
                            <td>13Mtr Reefer truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_34</td>
                            <td>14 Tonner</td>
                            <td>14 Tonner
                                Curtainsider</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_35</td>
                            <td>14M Trailer</td>
                            <td>14M Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_36</td>
                            <td>14T</td>
                            <td>14 tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_37</td>
                            <td>14TA</td>
                            <td>14 tonne Tautliner</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_38</td>
                            <td>14Tonner</td>
                            <td>Rigid Dropside</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_39</td>
                            <td>15M Trailer</td>
                            <td>15M Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_40</td>
                            <td>15mtr Box truck</td>
                            <td>15mtr Box truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_41</td>
                            <td>15Mtr Curtain trailer</td>
                            <td>15Mtr Curtain trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_42</td>
                            <td>15Mtr Flatbed trailer</td>
                            <td>15Mtr Flatbed trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_43</td>
                            <td>16ft Container</td>
                            <td>16ft Container</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_44</td>
                            <td>17 ft Container</td>
                            <td>17 ft Container</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_45</td>
                            <td>17 FT Open Mazda</td>
                            <td>17 FT Open Mazda</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_46</td>
                            <td>18t with tail lift</td>
                            <td>Curtainsider
                                arctic/box trailer approx. 16 pallets</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_47</td>
                            <td>18W Cabinet</td>
                            <td>18W Cabinet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_48</td>
                            <td>18W Cabinet (Dry)</td>
                            <td>18
                                &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3649;&#3627;&#3657;&#3591;</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_49</td>
                            <td>1T</td>
                            <td>1 Tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_50</td>
                            <td>1V</td>
                            <td>1 Tonne Van</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_51</td>
                            <td>2 Tonner Reefer</td>
                            <td>2 Tonner Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_52</td>
                            <td>2.0T</td>
                            <td>2.0T</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_53</td>
                            <td>20 Feet Truck</td>
                            <td>20 feet Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_54</td>
                            <td>20 FT CONTAINER</td>
                            <td>20 FT CONTAINER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_55</td>
                            <td>20DC - VN</td>
                            <td>20DC - VN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_56</td>
                            <td>20FT container - Flat
                                track</td>
                            <td>20FT container - Flat
                                track</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_57</td>
                            <td>20FT container - Open
                                TOP</td>
                            <td>20FT container - Open
                                TOP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_58</td>
                            <td>20FT CONTAINER -HC</td>
                            <td>20FT CONTAINER -HC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_59</td>
                            <td>20FT container – GP</td>
                            <td>20FT container – GP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_60</td>
                            <td>20ft Flatbed</td>
                            <td>Flatbed 20ft
                                container body</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_61</td>
                            <td>20ft Mazda Container</td>
                            <td>20ft Mazda Container</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_62</td>
                            <td>20ft Open Mazda</td>
                            <td>20ft Open Mazda</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_63</td>
                            <td>22ft Open Mazda</td>
                            <td>22ft Open Mazda</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_64</td>
                            <td>25 ft Containers</td>
                            <td>25 ft Containers</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_65</td>
                            <td>26t with tail lift</td>
                            <td>Curtainsider
                                arctic/box trailer approx. 18 pallets</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_66</td>
                            <td>2T</td>
                            <td>2 Tonne Open-Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_67</td>
                            <td>2V</td>
                            <td>2 Tonne Van</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_68</td>
                            <td>3 Ton pick-up</td>
                            <td>3 Ton pick-up</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_69</td>
                            <td>3.5t electric van</td>
                            <td>3.5t electric van</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_70</td>
                            <td>32 FT SXL</td>
                            <td>32 FT SXL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_71</td>
                            <td>33 T temperature
                                control</td>
                            <td>33 T temperature
                                control</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_72</td>
                            <td>33 T with temperature
                                control</td>
                            <td> Big truck of 33T + TC management between 5°
                                to 15°</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_73</td>
                            <td>33 ton transport
                                truck</td>
                            <td>33 ton transport
                                truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_74</td>
                            <td>3T - Box Trcuk</td>
                            <td>3Ton Box Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_75</td>
                            <td>3V</td>
                            <td>3 Pallet Van</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_76</td>
                            <td>4 TON</td>
                            <td>4 TON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_77</td>
                            <td>4 Tonner</td>
                            <td>4 Ton</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_78</td>
                            <td>4 Tonner Reefer</td>
                            <td>Refrigerated truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_79</td>
                            <td>4 Wheeler Cabinet</td>
                            <td>4 Wheeler Cabinet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_80</td>
                            <td>4 Wheeler Small</td>
                            <td>4 Wheeler Small</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_81</td>
                            <td>4 Wheeler Tailgate</td>
                            <td>FOUR_WHEELER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_82</td>
                            <td>40 FT REEFER BARATA
                                TRUCK</td>
                            <td>40 FT REEFER BARATA
                                TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_83</td>
                            <td>40' </td>
                            <td>GENSET</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_84</td>
                            <td>40ft Box Truck</td>
                            <td>40ft Box Truck - Side
                                Doors</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_85</td>
                            <td>40FT container - Flat
                                Track</td>
                            <td>40FT container - Flat
                                Track</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_86</td>
                            <td>40FT container - HC</td>
                            <td>40FT container - HC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_87</td>
                            <td>40FT container - Open
                                Top</td>
                            <td>40FT container - Open
                                Top</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_88</td>
                            <td>40FT CONTAINER -HC</td>
                            <td>40FT CONTAINER -HC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_89</td>
                            <td>40FT container – GP</td>
                            <td>40FT container – GP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_90</td>
                            <td>40ft Curtain Slider</td>
                            <td>40ft Curtain Sider</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_91</td>
                            <td>40HC - VN</td>
                            <td>40HC - VN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_92</td>
                            <td>40HQ</td>
                            <td>40HQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_93</td>
                            <td>45ft curtain side</td>
                            <td>45ft curtain side</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_94</td>
                            <td>45FT TRUCK BOX</td>
                            <td>45FT SMART TRUCK WITH
                                E-LOCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_95</td>
                            <td>4T</td>
                            <td>4 Tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_96</td>
                            <td>4TA</td>
                            <td>4 Tonne Tautliner</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_97</td>
                            <td>4W</td>
                            <td>4 Wheelers</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_98</td>
                            <td>4W Cabinet</td>
                            <td>4W Cabinet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_99</td>
                            <td>4W Cabinet
                                (Temperature Control)</td>
                            <td>4W Cabinet
                                (Temperature Control)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_100</td>
                            <td>4W Jumbo Cabinet</td>
                            <td>4
                                &#3621;&#3657;&#3629;&#3605;&#3641;&#3657;&#3592;&#3633;&#3617;&#3650;&#3610;&#3657;</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_101</td>
                            <td>5.0T</td>
                            <td>5.0T</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_102</td>
                            <td>6 Wheel Rigid</td>
                            <td>6 Wheel Rigid</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_103</td>
                            <td>6 Wheeler Cabinet</td>
                            <td>6 Wheeler Cabinet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_104</td>
                            <td>6 Wheeler Tailgate</td>
                            <td>SIX_WHEELER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_105</td>
                            <td>6 WHEELER TRUCK</td>
                            <td>6 WHEELER TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_106</td>
                            <td>6T</td>
                            <td>6 Tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_107</td>
                            <td>6TA</td>
                            <td>6 Tonne Tautliner</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_108</td>
                            <td>6W</td>
                            <td>6W</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_109</td>
                            <td>6W (REEFER)</td>
                            <td>6W (REEFER)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_110</td>
                            <td>6W Cabinet</td>
                            <td>6W Cabinet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_111</td>
                            <td>6W Cabinet
                                (Temperature Control)</td>
                            <td>6W Cabinet
                                (Temperature Control)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_112</td>
                            <td>6W REEFER</td>
                            <td>6W REEFER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_113</td>
                            <td>6WF</td>
                            <td>6WF</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_114</td>
                            <td>7 Ton pick-up</td>
                            <td>7 Ton pick-up</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_115</td>
                            <td>7.5t with loading
                                ramp</td>
                            <td>6mtr box trailer
                                approx. 10 pallets</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_116</td>
                            <td>7.5T with tail lift</td>
                            <td>With Tail Lift</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_117</td>
                            <td>8 TON</td>
                            <td>8 TON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_118</td>
                            <td>8 Tonner</td>
                            <td>8 Tonner curtainside</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_119</td>
                            <td>8 Tonner reefer</td>
                            <td>8 ton reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_120</td>
                            <td>8T</td>
                            <td>8 Tonne Open Tray</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_121</td>
                            <td>8TA</td>
                            <td>8 Tonne Tautliner</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_122</td>
                            <td>Air Ride Truck</td>
                            <td>Prime Mover Truck for
                                Specialised Haulage</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_123</td>
                            <td>Artic Curtain</td>
                            <td>Artic Curtain</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_124</td>
                            <td>Ashok Leyland TAURUS</td>
                            <td>Ashok Leyland TAURUS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_125</td>
                            <td>AUV</td>
                            <td>AUV</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_126</td>
                            <td>BD eTNKNBOM</td>
                            <td>BlueDart</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_127</td>
                            <td>BD Vehicle Type</td>
                            <td>BD Vehicle Type</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_128</td>
                            <td>Blind Van</td>
                            <td>Blind Van</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_129</td>
                            <td>BM_Jumbo Trailer
                                Truck</td>
                            <td>Trucks w. 38 Pallets
                                capacity</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_130</td>
                            <td>Box trailer</td>
                            <td>Box trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_131</td>
                            <td>Box-Textile-Mega
                                trailer – 2.85 height</td>
                            <td>Box-Textile-Mega
                                trailer – 2.85 height</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_132</td>
                            <td>CALX</td>
                            <td>CALX</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_133</td>
                            <td>Calyx</td>
                            <td>Calyx</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_134</td>
                            <td>CAR</td>
                            <td>small Parcels/Boxes</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_135</td>
                            <td>CAR CARRIER</td>
                            <td>CAR CARRIER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_136</td>
                            <td>CDD</td>
                            <td>Colt Diesel Double</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_137</td>
                            <td>CDD Long</td>
                            <td>CDD Long</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_138</td>
                            <td>CDD Reefer</td>
                            <td>CDD Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_139</td>
                            <td>CDDL Reefer</td>
                            <td>CDDL Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_140</td>
                            <td>CDE</td>
                            <td>Colt Diesel Engkel</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_141</td>
                            <td>CDE Long</td>
                            <td>CDE Long</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_142</td>
                            <td>CDE Reefer</td>
                            <td>CDE Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_143</td>
                            <td>Class7_5</td>
                            <td>Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_144</td>
                            <td>Closed Dyna</td>
                            <td>Closed Dyna</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_145</td>
                            <td>Curtain Truck &amp;
                                Trailer</td>
                            <td>Curtain Truck &amp;
                                Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_146</td>
                            <td>CUSTOMS &amp;
                                BROKERAGE</td>
                            <td>CUSTOMS &amp;
                                BROKERAGE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_147</td>
                            <td>DEFAULT</td>
                            <td>DEFAULT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_148</td>
                            <td>Diptab Venture</td>
                            <td>Diptab Venture</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_149</td>
                            <td>EDI</td>
                            <td>EDI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_150</td>
                            <td>EDI TRUCK</td>
                            <td>EDI TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_151</td>
                            <td>EICHER 50_TRAILER</td>
                            <td>EICHER 50' TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_152</td>
                            <td>eTNKNBOM</td>
                            <td>eTNKNBOM</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_153</td>
                            <td>FB Unit</td>
                            <td>FB Unit</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_154</td>
                            <td>FlatBed  Truck</td>
                            <td>FlatBed  Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_155</td>
                            <td>Frigo trailer</td>
                            <td>Frigo trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_156</td>
                            <td>Frigo trailer - 2.70m
                                height</td>
                            <td>Frigo trailer - 2.70m
                                height</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_157</td>
                            <td>Frigo trailer - Bi
                                thermo</td>
                            <td>Frigo trailer - Bi
                                thermo</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_158</td>
                            <td>Frigo trailer -
                                Double deck</td>
                            <td>Frigo trailer -
                                Double deck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_159</td>
                            <td>Frigo trailer -
                                Double tech bi thermo</td>
                            <td>Frigo trailer -
                                Double tech bi thermo</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_160</td>
                            <td>FTL</td>
                            <td>FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_161</td>
                            <td>FUSO</td>
                            <td>FUSO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_162</td>
                            <td>Fuso Lossbak</td>
                            <td>Fuso Lossbak</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_163</td>
                            <td>Fuso Reefer</td>
                            <td>Fuso Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_164</td>
                            <td>Fuso Wing</td>
                            <td>Fuso Wing</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_165</td>
                            <td>GEETEE</td>
                            <td>GEETEE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_166</td>
                            <td>Grand Max</td>
                            <td>Grand Max</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_167</td>
                            <td>GUY KNOWLES</td>
                            <td>GUY KNOWLES</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_168</td>
                            <td>Hard Body Reefer 1,5
                                T Tapa 1 i Low Value</td>
                            <td>Dimensions:
                                4,2/ok.2/ok.2</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_169</td>
                            <td>Hard Body Reefer 24 T
                                Tapa 1 i Low Value</td>
                            <td>Dimensions:
                                13,6/2,45/,2,7</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_170</td>
                            <td>Hard Body Reefer 3,5
                                T Tapa 1 i Low Value</td>
                            <td>Dimensions:
                                6,2/2,45/2,5</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_171</td>
                            <td>Hard Body Reefer 8 T
                                Tapa 1</td>
                            <td>Dimensions:
                                ok.7,3/2,45/ok.2,5</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_172</td>
                            <td>Hard Body – 24 Tons</td>
                            <td>Dimensions:
                                13,6/2,45/,2,7</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_173</td>
                            <td>HUB_12FT</td>
                            <td>HUB_12FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_174</td>
                            <td>HUB_24FT</td>
                            <td>HUB_24FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_175</td>
                            <td>HUB_40FT</td>
                            <td>HUB_40FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_176</td>
                            <td>HUB_VAN</td>
                            <td>HUB_VAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_177</td>
                            <td>JBS_24_EQP</td>
                            <td>JBS_24_EQP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_178</td>
                            <td>JCB</td>
                            <td>JCB</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_179</td>
                            <td>JUMBO</td>
                            <td>CLOSE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_180</td>
                            <td>KN_CANTER_17FT</td>
                            <td>KN_CANTER_17FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_181</td>
                            <td>Kunal</td>
                            <td>Caparo</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_182</td>
                            <td>LOWBED</td>
                            <td>Lowbed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_183</td>
                            <td>Lowbed ART</td>
                            <td>Lowbed ART</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_184</td>
                            <td>Lowbed Trailer</td>
                            <td>LOWBED_TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_185</td>
                            <td>Lowbed Truck</td>
                            <td>Lowbed Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_186</td>
                            <td>LTL NETWORK</td>
                            <td>LTL NETWORK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_187</td>
                            <td>LUTON WITH TAIL LIFT</td>
                            <td>LUTON WITH TAIL LIFT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_188</td>
                            <td>MANUAL</td>
                            <td>MANUAL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_189</td>
                            <td>Mega Trailer – 2.85m
                                height</td>
                            <td>Mega Trailer – 2.85m
                                height</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_190</td>
                            <td>Mega Trailer – 3m
                                height</td>
                            <td>Mega Trailer – 3m
                                height</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_191</td>
                            <td>Myntra 8500780416</td>
                            <td>Keshu Spoton Vendor</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_192</td>
                            <td>Myntra eTNKNBOM</td>
                            <td>R0001</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_193</td>
                            <td>MYTRUX</td>
                            <td>MYTRUX</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_194</td>
                            <td>Normal Lowbed</td>
                            <td>Normal Lowbed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_195</td>
                            <td>Optima Trailer</td>
                            <td>Optima Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_196</td>
                            <td>PALLETIZED ONLY</td>
                            <td>PALLETIZED ONLY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_197</td>
                            <td>PICKUP 1 TON</td>
                            <td>1 TONS </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_198</td>
                            <td>PICKUP 2 TONS</td>
                            <td>2 TONS TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_199</td>
                            <td>PICKUP 3 TONS</td>
                            <td>3 TONS PICKUP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_200</td>
                            <td>POLO GANAPTI</td>
                            <td>POLO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_201</td>
                            <td>Prime Mover</td>
                            <td>Prime Mover Truck for
                                haulage</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_202</td>
                            <td>R0001</td>
                            <td>R0001</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_203</td>
                            <td>R0002</td>
                            <td>R0002</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_204</td>
                            <td>R02</td>
                            <td>R02</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_205</td>
                            <td>R03</td>
                            <td>R03</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_206</td>
                            <td>R04</td>
                            <td>R04</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_207</td>
                            <td>R10</td>
                            <td>R10</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_208</td>
                            <td>R3</td>
                            <td>R3</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_209</td>
                            <td>R40</td>
                            <td>R40</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_210</td>
                            <td>Reefer Dyana</td>
                            <td>Dyana RF</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_211</td>
                            <td>Reefer Trailer</td>
                            <td>Reefer Trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_212</td>
                            <td>Reefer Truck</td>
                            <td>Reefer Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_213</td>
                            <td>Rigid Curtainsider</td>
                            <td>Rigid Curtainsider</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_214</td>
                            <td>Rigid Tail Lift</td>
                            <td>Rigid Tail Lift</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_215</td>
                            <td>RLS</td>
                            <td>RLS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_216</td>
                            <td>Roller Deck</td>
                            <td>Roller Deck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_217</td>
                            <td>Safeexpress</td>
                            <td>Safeexpress</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_218</td>
                            <td>SEMI</td>
                            <td>semi trailer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_219</td>
                            <td>Sideloader</td>
                            <td>Sideloader</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_220</td>
                            <td>SIDHHI</td>
                            <td>SIDHHI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_221</td>
                            <td>Special Lowbed</td>
                            <td>Special Lowbed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_222</td>
                            <td>ST</td>
                            <td>Small Tray to 500 kg</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_223</td>
                            <td>SUPER LINK </td>
                            <td>SUPER LINK </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_224</td>
                            <td>SUV</td>
                            <td>FURNWARE TRANSPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_225</td>
                            <td>Suzuki Pickup</td>
                            <td>Suzuki Pickup</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_226</td>
                            <td>SV</td>
                            <td>Small Van to 250 kg</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_227</td>
                            <td>SW</td>
                            <td>Station Wagon</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_228</td>
                            <td>SYMBI</td>
                            <td>SYMBI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_229</td>
                            <td>T13</td>
                            <td>T13</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_230</td>
                            <td>TAIL LIFT TRUCK</td>
                            <td>TAIL LIFT TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_231</td>
                            <td>Tarpaulin Tilt 24 T
                                Tapa 3 i Low Value</td>
                            <td>Dimensions:
                                13,6/2,45/,2,7</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_232</td>
                            <td>Tarpaulin Tilt 3,5 T
                                Low Value</td>
                            <td>Dimensions:
                                6,2/2,45/2,5</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_233</td>
                            <td>Tarpaulin Tilt 6 T
                                Low Value</td>
                            <td>Dimensions: ok
                                6,2/2,45/ok.2,5</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_234</td>
                            <td>TATA 1109</td>
                            <td>TATA 1109</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_235</td>
                            <td>TATA 40_TRAILER</td>
                            <td>TATA 40' TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_236</td>
                            <td>TATA 50_TRAILER</td>
                            <td>TATA 50' TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_237</td>
                            <td>TATA 55_TRAILER</td>
                            <td>TATA 55' TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_238</td>
                            <td>TATA 70_TRAILER</td>
                            <td>TATA 70' TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_239</td>
                            <td>TATA ACE</td>
                            <td>TATA ACE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_240</td>
                            <td>TATA LBT</td>
                            <td>TATA LBT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_241</td>
                            <td>TATA OT</td>
                            <td>TATA O.T</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_242</td>
                            <td>TCI</td>
                            <td>tci</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_243</td>
                            <td>TCISITA</td>
                            <td>SITA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_244</td>
                            <td>TEMPERATURE-CONTROL-TRK-15FT-5TONNER</td>
                            <td>TEMPERATURE-CONTROL-TRK-15FT-5TONNER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_245</td>
                            <td>Test vehicle 1</td>
                            <td>Test vehicle 1</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_246</td>
                            <td>Test2-6</td>
                            <td>TEST</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_247</td>
                            <td>TESTTRUCK_AJ2</td>
                            <td>Test truck type </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_248</td>
                            <td>TRACTOR HEAD</td>
                            <td>TRACTOR HEAD</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_249</td>
                            <td>Trailer 20FT</td>
                            <td>Trailer 20FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_250</td>
                            <td>Trailer 20FT Reefer</td>
                            <td>Trailer 20FT Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_251</td>
                            <td>Trailer 40FT</td>
                            <td>Trailer 40FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_252</td>
                            <td>Trailer 40FT Reefer</td>
                            <td>Trailer 40FT Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_253</td>
                            <td>Trailer Container 20</td>
                            <td>FLATBED_TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_254</td>
                            <td>Trailer Container 40</td>
                            <td>FLATBED_TRAILER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_255</td>
                            <td>TRI AXLE</td>
                            <td>TRI AXLE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_256</td>
                            <td>Triaxle Genset</td>
                            <td>Triaxle Genset</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_257</td>
                            <td>TRK-BOX-10FT-1TONNER</td>
                            <td>TRK-BOX-10FT-1TONNER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_258</td>
                            <td>TRK-BOX-20FT-10TONNER</td>
                            <td>TRK-BOX-20FT-10TONNER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_259</td>
                            <td>TRK-REEFER-15FT-5TONNER</td>
                            <td>TRK-REEFER-15FT-5TONNER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_260</td>
                            <td>TRK-REEFER-20FT-10TONNER</td>
                            <td>TRK-REEFER-20FT-10TONNER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_261</td>
                            <td>Tronton</td>
                            <td>Tronton</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_262</td>
                            <td>Tronton Lossbak</td>
                            <td>Tronton Lossbak</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_263</td>
                            <td>Tronton Reefer</td>
                            <td>Tronton Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_264</td>
                            <td>Truck</td>
                            <td>Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_265</td>
                            <td>TRUCK 5 TONS</td>
                            <td>5 TONS TRUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_266</td>
                            <td>TRUCK BOX 10FT</td>
                            <td>Truck with 10ft Box
                                Fully covered</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_267</td>
                            <td>TRUCK BOX 14FT</td>
                            <td>Truck with 14ft Box
                                Fully covered</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_268</td>
                            <td>TRUCK BOX 24FT</td>
                            <td>Truck with 24ft Box
                                Fully covered</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_269</td>
                            <td>TRUCK BOX 40FT</td>
                            <td>TRUCK BOX 40FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_270</td>
                            <td>TRUCK REEFER 40FT</td>
                            <td>TRUCK REEFER 40FT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_271</td>
                            <td>USTDTRK</td>
                            <td>Unstandardized Truck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_272</td>
                            <td>UZ 32 FT TEMP
                                CONTROL<span > </td>
                            <td>UZ 32 FT TEMP
                                CONTROL<span > </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_273</td>
                            <td>Van Diesel</td>
                            <td>Van propel by diesel</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_274</td>
                            <td>Van Electric</td>
                            <td>Van propel by full
                                electric power</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_275</td>
                            <td>Véhicule porteur
                                Température Dirigé à 2 essieux</td>
                            <td>Véhicule porteur
                                Température Dirigé à 2 essieux</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_276</td>
                            <td>VW</td>
                            <td>VW</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_277</td>
                            <td>west pharma</td>
                            <td>west pharma</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_278</td>
                            <td>WHEELIE BINS ONLY</td>
                            <td>WHEELIE BINS ONLY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_279</td>
                            <td>WILL TRUCK TYPE</td>
                            <td>WILL TRUCK TYPE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_280</td>
                            <td>Wing Box</td>
                            <td>Wing Box</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_281</td>
                            <td>Wing Box Reefer</td>
                            <td>Wing Box Reefer</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_282</td>
                            <td>Wingbox Tronton</td>
                            <td>Wingbox Tronton</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_283</td>
                            <td>Yati</td>
                            <td>Return</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_284</td>
                            <td>ZC4320</td>
                            <td>ZC4320</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_285</td>
                            <td>ZD 6439</td>
                            <td>ZD 6439</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_286</td>
                            <td>ZD 9557</td>
                            <td>ZD 9557</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_287</td>
                            <td>ZD 9951</td>
                            <td>ZD 9951</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_288</td>
                            <td>ZD9895</td>
                            <td>ZD9895</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_289</td>
                            <td>ZD9896</td>
                            <td>ZD9896</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_290</td>
                            <td>ZD9897</td>
                            <td>ZD9897</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_291</td>
                            <td>ZE 0561</td>
                            <td>ZE 0561</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_292</td>
                            <td>ZE 3421</td>
                            <td>ZE 3421</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_293</td>
                            <td>ZE0562</td>
                            <td>ZE0562</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_294</td>
                            <td>ZE0741</td>
                            <td>ZE0741</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_295</td>
                            <td>ZE2230</td>
                            <td>ZE2230</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_296</td>
                            <td>ZE2231</td>
                            <td>ZE2231</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_297</td>
                            <td>ZE2232</td>
                            <td>ZE2232</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_298</td>
                            <td>ZE2368</td>
                            <td>ZE2368</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_299</td>
                            <td>ZE2439</td>
                            <td>ZE2439</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_300</td>
                            <td>ZE2440</td>
                            <td>ZE2440</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_301</td>
                            <td>ZE2695</td>
                            <td>ZE2695</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_302</td>
                            <td>ZE2696</td>
                            <td>ZE2696</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_303</td>
                            <td>ZE2697</td>
                            <td>ZE2697</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_304</td>
                            <td>ZE2698</td>
                            <td>ZE2698</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_305</td>
                            <td>ZE3423</td>
                            <td>ZE3423</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_306</td>
                            <td>ZE4500</td>
                            <td>ZE4500</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_307</td>
                            <td>ZE5110</td>
                            <td>ZE5110</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_308</td>
                            <td>ZE5115</td>
                            <td>ZE5115</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_309</td>
                            <td>ZE5174</td>
                            <td>ZE5174</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_310</td>
                            <td>ZF 2214</td>
                            <td>ZF 2214</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_311</td>
                            <td>ZF 2521</td>
                            <td>ZF 2521</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_312</td>
                            <td>ZF 2694</td>
                            <td>ZF 2694</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_313</td>
                            <td>ZF 2786</td>
                            <td>ZF 2786</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_314</td>
                            <td>ZF 2790</td>
                            <td>ZF 2790</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_315</td>
                            <td>ZF 2934</td>
                            <td>ZF 2934</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_316</td>
                            <td>ZF 3347</td>
                            <td>ZF 3347</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_317</td>
                            <td>ZF 4879</td>
                            <td>ZF 4879</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_318</td>
                            <td>ZF 4885</td>
                            <td>ZF 4885</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_319</td>
                            <td>ZF 5061</td>
                            <td>ZF 5061</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_320</td>
                            <td>ZF 5062</td>
                            <td>ZF 5062</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_321</td>
                            <td>ZF 5073</td>
                            <td>ZF 5073</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_322</td>
                            <td>ZF 5261</td>
                            <td>ZF 5261</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_323</td>
                            <td>ZF2215</td>
                            <td>ZF2215</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_324</td>
                            <td>ZF2785</td>
                            <td>ZF2785</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_325</td>
                            <td>ZF2788</td>
                            <td>ZF2788</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_326</td>
                            <td>ZF2789</td>
                            <td>ZF2789</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_327</td>
                            <td>ZF2935</td>
                            <td>ZF2935</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_328</td>
                            <td>ZF4761</td>
                            <td>ZF4761</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_329</td>
                            <td>ZF4764</td>
                            <td>ZF4764</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_330</td>
                            <td>ZF5056</td>
                            <td>ZF5056</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_331</td>
                            <td>ZF5057</td>
                            <td>ZF5057</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_332</td>
                            <td>ZF5058</td>
                            <td>ZF5058</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_333</td>
                            <td>ZF5059</td>
                            <td>ZF5059</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_334</td>
                            <td>ZF5065</td>
                            <td>ZF5065</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_335</td>
                            <td>ZF5068</td>
                            <td>ZF5068</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_336</td>
                            <td>ZF5075</td>
                            <td>ZF5075</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_337</td>
                            <td>ZF5076</td>
                            <td>ZF5076</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_338</td>
                            <td>ZF5078</td>
                            <td>ZF5078</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_339</td>
                            <td>ZF5080</td>
                            <td>ZF5080</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_340</td>
                            <td>ZF5083</td>
                            <td>ZF5083</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_341</td>
                            <td>ZF5084</td>
                            <td>ZF5084</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_342</td>
                            <td>ZF5257</td>
                            <td>ZF5257</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_343</td>
                            <td>ZF6020</td>
                            <td>ZF6020</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_344</td>
                            <td>ZF6024</td>
                            <td>ZF6024</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_345</td>
                            <td>ZF6025</td>
                            <td>ZF6025</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_346</td>
                            <td>ZF6026</td>
                            <td>ZF6026</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_347</td>
                            <td>ZF6027</td>
                            <td>ZF6027</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_348</td>
                            <td>ZF6080</td>
                            <td>ZF6080</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_349</td>
                            <td>ZF6082</td>
                            <td>ZF6082</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_350</td>
                            <td>ZF6085</td>
                            <td>ZF6085</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_351</td>
                            <td>ZF6440</td>
                            <td>ZF6440</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_352</td>
                            <td>ZF6442</td>
                            <td>ZF6442</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_353</td>
                            <td>ZF6443</td>
                            <td>ZF6443</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_354</td>
                            <td>ZF6444</td>
                            <td>ZF6444</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_355</td>
                            <td>ZF6445</td>
                            <td>ZF6445</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_356</td>
                            <td>ZF6446</td>
                            <td>ZF6446</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_357</td>
                            <td>ZF6447</td>
                            <td>ZF6447</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_358</td>
                            <td>ZF6449</td>
                            <td>ZF6449</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_359</td>
                            <td>ZF6451</td>
                            <td>ZF6451</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_360</td>
                            <td>ZF6452</td>
                            <td>ZF6452</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_361</td>
                            <td>ZF6453</td>
                            <td>ZF6453</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_362</td>
                            <td>ZF6454</td>
                            <td>ZF6454</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_363</td>
                            <td>ZF6455</td>
                            <td>ZF6455</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_364</td>
                            <td>ZF6456</td>
                            <td>ZF6456</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_365</td>
                            <td>ZF6464</td>
                            <td>ZF6464</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>VEH_MAS_366</td>
                            <td>ZF6465</td>
                            <td>ZF6465</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBUOM">
            <label for="TPOUBUOM">UOM</label>
            <ul>
                <li>
                    <h2>Code table : CT_UOM</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr >
                            <td>UOM1</td>
                            <td>CBM</td>
                            <td>Cubic Meter</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM2</td>
                            <td>CHW</td>
                            <td>Chargeable Weight</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM3</td>
                            <td>CM</td>
                            <td>Centimeter</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM4</td>
                            <td>KG</td>
                            <td>Kilogram</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM5</td>
                            <td>KGS</td>
                            <td>Kilograms</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM6</td>
                            <td>L</td>
                            <td>Liter</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM7</td>
                            <td>LDM</td>
                            <td>Loading Metre</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM8</td>
                            <td>M</td>
                            <td>Meter</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM9</td>
                            <td>M3</td>
                            <td>Cubic Meter(use cbm)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM10</td>
                            <td>MTR</td>
                            <td>Metre</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM11</td>
                            <td>PAL</td>
                            <td>Pallet</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM12</td>
                            <td>POS</td>
                            <td>Position</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM13</td>
                            <td>SHP</td>
                            <td>Shipment</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM14</td>
                            <td>T</td>
                            <td>Ton</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr >
                            <td>UOM15</td>
                            <td>B</td>
                            <td>Boxes</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBCOUNCD">
            <label for="TPOUBCOUNCD">Country code</label>
            <ul>
                <li>
                    <h2>Code table : CT_Country code</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Countrycode_1</td>
                            <td>61</td>
                            <td>AUSTRALIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_2</td>
                            <td>43</td>
                            <td>AUSTRIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_3</td>
                            <td>973</td>
                            <td>BAHRAIN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_4</td>
                            <td>32</td>
                            <td>BELGIUM</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_5</td>
                            <td>267</td>
                            <td>BOTSWANA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_6</td>
                            <td>55</td>
                            <td>BRAZIL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_7</td>
                            <td>855</td>
                            <td>CAMBODIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_8</td>
                            <td>1</td>
                            <td>CANADA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_9</td>
                            <td>86</td>
                            <td>CHINA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_10</td>
                            <td>420</td>
                            <td>CZECHREPUBLIC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_11</td>
                            <td>243</td>
                            <td>DEMOCRATICREPUBLIC
                                OFCONGO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_12</td>
                            <td>45</td>
                            <td>DENMARK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_13</td>
                            <td>971</td>
                            <td>DUBAI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_14</td>
                            <td>20</td>
                            <td>EGYPT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_15</td>
                            <td>251</td>
                            <td>ETHIOPIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_16</td>
                            <td>33</td>
                            <td>FRANCE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_17</td>
                            <td>49</td>
                            <td>GERMANY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_18</td>
                            <td>852</td>
                            <td>HONGKONG</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_19</td>
                            <td>91</td>
                            <td>INDIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_20</td>
                            <td>62</td>
                            <td>INDONESIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_21</td>
                            <td>964</td>
                            <td>IRAQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_22</td>
                            <td>39</td>
                            <td>ITALY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_23</td>
                            <td>81</td>
                            <td>JAPAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_24</td>
                            <td>962</td>
                            <td>JORDAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_25</td>
                            <td>254</td>
                            <td>KENYA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_26</td>
                            <td>965</td>
                            <td>KUWAIT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_27</td>
                            <td>266</td>
                            <td>LESOTHO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_28</td>
                            <td>265</td>
                            <td>MALAWI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_29</td>
                            <td>60</td>
                            <td>MALAYSIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_30</td>
                            <td>258</td>
                            <td>MOZAMBIQUE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_31</td>
                            <td>31</td>
                            <td>NETHERLANDS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_32</td>
                            <td>64</td>
                            <td>NEWZEALAND</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_33</td>
                            <td>968</td>
                            <td>OMAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_34</td>
                            <td>92</td>
                            <td>PAKISTAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_35</td>
                            <td>51</td>
                            <td>PERU</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_36</td>
                            <td>63</td>
                            <td>PHILIPPINES</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_37</td>
                            <td>48</td>
                            <td>POLAND</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_38</td>
                            <td>974</td>
                            <td>QATAR</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_39</td>
                            <td>250</td>
                            <td>RWANDA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_40</td>
                            <td>966</td>
                            <td>SAUDIARABIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_41</td>
                            <td>381</td>
                            <td>SERBIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_42</td>
                            <td>65</td>
                            <td>SINGAPORE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_43</td>
                            <td>27</td>
                            <td>SOUTHAFRICA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_44</td>
                            <td>82</td>
                            <td>SOUTHKOREA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_45</td>
                            <td>211</td>
                            <td>SOUTHSUDAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_46</td>
                            <td>34</td>
                            <td>SPAIN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_47</td>
                            <td>94</td>
                            <td>SRILANKA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_48</td>
                            <td>268</td>
                            <td>SWAZILAND</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_49</td>
                            <td>46</td>
                            <td>SWEDEN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_50</td>
                            <td>41</td>
                            <td>SWITZERLAND</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_51</td>
                            <td>963</td>
                            <td>SYRIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_52</td>
                            <td>886</td>
                            <td>TAIWAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_53</td>
                            <td>255</td>
                            <td>TANZANIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_54</td>
                            <td>66</td>
                            <td>THAILAND</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_55</td>
                            <td>90</td>
                            <td>TURKEY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_56</td>
                            <td>256</td>
                            <td>UGANDA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_57</td>
                            <td>971</td>
                            <td>UNITEDARABEMIRATES</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_58</td>
                            <td>44</td>
                            <td>UNITEDKINGDOM</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_59</td>
                            <td>1</td>
                            <td>UNITEDSTATES</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_60</td>
                            <td>1</td>
                            <td>UNITEDSTATESOF
                                AMERICA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_61</td>
                            <td>84</td>
                            <td>VIETNAM</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_62</td>
                            <td>967</td>
                            <td>YEMEN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_63</td>
                            <td>260</td>
                            <td>ZAMBIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_64</td>
                            <td>263</td>
                            <td>ZIMBABWE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Countrycode_65</td>
                            <td>7</td>
                            <td>&#1056;&#1054;&#1057;&#1057;&#1048;&#1071;</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBMOT">
            <label for="TPOUBMOT">Mode of Transport</label>
            <ul>
                <li>
                    <h2>Code table : CT_Mode of Transport</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_1</td>
                            <td>AIR-EXPORT</td>
                            <td>AIR-EXPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_2</td>
                            <td>AIR-FCL</td>
                            <td>AIR-FCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_3</td>
                            <td>AIR-IMPORT</td>
                            <td>AIR-IMPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_4</td>
                            <td>AIR-LCL</td>
                            <td>AIR-LCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_5</td>
                            <td>COURIER</td>
                            <td>COURIER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_6</td>
                            <td>DOMESTIC</td>
                            <td>DOMESTIC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_7</td>
                            <td>EXPORT</td>
                            <td>EXPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_8</td>
                            <td>FTL</td>
                            <td>Full Truck Load</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>Mode of
                                Transport_9</td>
                            <td>GRP</td>
                            <td>Groupage</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_10</td>
                            <td>IMPORT</td>
                            <td>IMPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_11</td>
                            <td>LTL</td>
                            <td>Less Than Truck Load</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_12</td>
                            <td>Multimodal</td>
                            <td>Multimodal</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_13</td>
                            <td>PACT LTL</td>
                            <td>LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_14</td>
                            <td>Rail-FCL</td>
                            <td>Rail-FCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_15</td>
                            <td>Rail-LCL</td>
                            <td>Rail-LCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_16</td>
                            <td>ROAD-LOGISTIC-EGYPT</td>
                            <td>ROAD-LOGISTIC-EGYPT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_17</td>
                            <td>ROAD-LOGISTIC-IRAQ</td>
                            <td>ROAD-LOGISTIC-IRAQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_18</td>
                            <td>ROAD-LOGISTIC-JORDAN</td>
                            <td>ROAD-LOGISTIC-JORDAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_19</td>
                            <td>ROAD-LOGISTIC-KENYA</td>
                            <td>ROAD-LOGISTIC-KENYA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_20</td>
                            <td>ROAD-LOGISTIC-OMAN</td>
                            <td>ROAD-LOGISTIC-OMAN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_21</td>
                            <td>ROAD-LOGISTIC-QATAR</td>
                            <td>ROAD-LOGISTIC-QATAR</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_22</td>
                            <td>ROAD-LOGISTIC-SAUDI</td>
                            <td>ROAD-LOGISTIC-SAUDI</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_23</td>
                            <td>ROAD-LOGISTIC-SOUTH-AFRICA</td>
                            <td>ROAD-LOGISTIC-SOUTH-AFRICA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_24</td>
                            <td>ROAD-LOGISTIC-TANZANIA</td>
                            <td>ROAD-LOGISTIC-TANZANIA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_25</td>
                            <td>ROAD-LOGISTIC-TURKEY</td>
                            <td>ROAD-LOGISTIC-TURKEY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_26</td>
                            <td>ROAD-LOGISTIC-UAE</td>
                            <td>ROAD-LOGISTIC-UAE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_27</td>
                            <td>SEA-EXPORT</td>
                            <td>SEA-EXPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_28</td>
                            <td>SEA-FCL</td>
                            <td>SEA-FCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_29</td>
                            <td>SEA-IMPORT</td>
                            <td>SEA-IMPORT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_30</td>
                            <td>SEA-LCL</td>
                            <td>SEA-LCL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_31</td>
                            <td>Test Transport Mode</td>
                            <td>Test Transport Mode</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_32</td>
                            <td>TestTransport Pluto</td>
                            <td>TestTransport Pluto</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>Mode of
                                Transport_33</td>
                            <td>xbrder-FTL</td>
                            <td>xbrder-FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_34</td>
                            <td>xbrder-LTL</td>
                            <td>xbrder-LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_35</td>
                            <td>xbrder-MultiModal</td>
                            <td>xbrder-MultiModal</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Mode of
                                Transport_36</td>
                            <td>xbrder-Road+Rail</td>
                            <td>xbrder-Road+Rail</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBPDT">
            <label for="TPOUBPDT">Product</label>
            <ul>
                <li>
                    <h2>Code table : CT_Product</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Product_1</td>
                            <td></td>
                            <td>Aerospace</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_2</td>
                            <td></td>
                            <td>Classic</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_3</td>
                            <td></td>
                            <td>CONTRACT
                                MANUFACTURING</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_4</td>
                            <td></td>
                            <td>Fairs &amp; Events</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_5</td>
                            <td></td>
                            <td>FAK - General cargo</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_6</td>
                            <td></td>
                            <td>Freight all kinds</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_7</td>
                            <td></td>
                            <td>Greenland Product</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_8</td>
                            <td></td>
                            <td>Greenland Product 2
                                do not use</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_9</td>
                            <td></td>
                            <td>Groupage</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_10</td>
                            <td></td>
                            <td>Healthcare</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_11</td>
                            <td></td>
                            <td>IntraCity</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_12</td>
                            <td></td>
                            <td>KN AsiaDirect</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_13</td>
                            <td></td>
                            <td>KN AsiaLink</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_14</td>
                            <td></td>
                            <td>KN Svkonekt</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_15</td>
                            <td></td>
                            <td>KN EuroDirect</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_16</td>
                            <td></td>
                            <td>KN EuroLink</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_17</td>
                            <td></td>
                            <td>KN PharmaChain</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_18</td>
                            <td></td>
                            <td>KN Projects,
                                Oil&amp;Gas</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_19</td>
                            <td></td>
                            <td>KN Secure Chain</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_20</td>
                            <td></td>
                            <td>KN Specialized
                                Services</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_21</td>
                            <td></td>
                            <td>LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_22</td>
                            <td></td>
                            <td>LTL/FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_23</td>
                            <td></td>
                            <td>Mining </td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_24</td>
                            <td></td>
                            <td>Oil And Gas</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_25</td>
                            <td></td>
                            <td>Pharma</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_26</td>
                            <td></td>
                            <td>Project Logistics</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_27</td>
                            <td></td>
                            <td>Road Logistic UAE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Product_28</td>
                            <td></td>
                            <td>Special service</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBSerTY">
            <label for="TPOUBSerTY">Service Type</label>
            <ul>
                <li>
                    <h2>Code table : CT_Service Type</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>ST_1</td>
                            <td>AA</td>
                            <td>Overland - Aerospace Logistics</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_2</td>
                            <td>AF</td>
                            <td>Full Load</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_3</td>
                            <td>AH</td>
                            <td>Health Care</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_4</td>
                            <td>AL</td>
                            <td>Part Load</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_5</td>
                            <td>AP</td>
                            <td>Pharma Chain</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_6</td>
                            <td>AS</td>
                            <td>Special Service (Svkonekt)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_7</td>
                            <td>C</td>
                            <td>COURIER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_8</td>
                            <td>CL</td>
                            <td>Classic</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>ST_9</td>
                            <td>Express</td>
                            <td>Express</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_10</td>
                            <td>FI</td>
                            <td>First</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>ST_11</td>
                            <td>FTL</td>
                            <td>FTL Full Truck Load</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_12</td>
                            <td>FX</td>
                            <td>Fixed</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_13</td>
                            <td>GN</td>
                            <td>General</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_14</td>
                            <td>GREEN TEST SERVICE</td>
                            <td>GREEN TEST SERVICE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_15</td>
                            <td>IDPACK</td>
                            <td>INDUSTRIAL PACKING</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_16</td>
                            <td>LTL</td>
                            <td>Less Than Truck Load</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td>ST_17</td>
                            <td>MI</td>
                            <td>Military</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_18</td>
                            <td>Normal</td>
                            <td>Normal</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_19</td>
                            <td>OF</td>
                            <td>FTL Oil&amp;Gas</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_20</td>
                            <td>OG</td>
                            <td>Oil&amp;Gas</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_21</td>
                            <td>OL</td>
                            <td>LTL Oil&amp;Gas</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_22</td>
                            <td>PF</td>
                            <td>Pharma Chilled FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_23</td>
                            <td>PH</td>
                            <td>Pharma</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_24</td>
                            <td>PL</td>
                            <td>Pharma Chilled LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_25</td>
                            <td>SF</td>
                            <td>Secure Chain FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_26</td>
                            <td>SG</td>
                            <td>Special</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_27</td>
                            <td>SL</td>
                            <td>Secure Chain LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_28</td>
                            <td>SP</td>
                            <td>Specialized Services</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_29</td>
                            <td>TA</td>
                            <td>Customs Clearance</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_30</td>
                            <td>Temperature Controlled</td>
                            <td>Temperature Controlled</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_31</td>
                            <td>TestService</td>
                            <td>TestService</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_32</td>
                            <td>XA</td>
                            <td>KN Aerospace</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_33</td>
                            <td>XF</td>
                            <td>FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_34</td>
                            <td>XH</td>
                            <td>Healthcare</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_35</td>
                            <td>XL</td>
                            <td>KN AsiaDirect FTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_36</td>
                            <td>XP</td>
                            <td>Pharma</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_37</td>
                            <td>YL</td>
                            <td>KN AsiaLink LTL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>ST_38</td>
                            <td>ZZ</td>
                            <td>Ocean</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBIncoTrms">
            <label for="TPOUBIncoTrms">Inco terms</label>
            <ul>
                <li>
                    <h2>Code table : CT_Inco terms</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Inco_terms_1</td>
                            <td>CFR</td>
                            <td>CFR</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_2</td>
                            <td>CFT</td>
                            <td>CFT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_3</td>
                            <td>CIF</td>
                            <td>CIF</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_4</td>
                            <td>CIP</td>
                            <td>CIP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_5</td>
                            <td>CPT</td>
                            <td>CPT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_6</td>
                            <td>CTO</td>
                            <td>CTO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_7</td>
                            <td>DAF</td>
                            <td>DAF</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_8</td>
                            <td>DAP</td>
                            <td>DAP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_9</td>
                            <td>DAT</td>
                            <td>DAT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_10</td>
                            <td>DCT</td>
                            <td>DCT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_11</td>
                            <td>DDP</td>
                            <td>DDP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_12</td>
                            <td>DDU</td>
                            <td>DDU</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_13</td>
                            <td>DEQ</td>
                            <td>DEQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_14</td>
                            <td>DES</td>
                            <td>DES</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_15</td>
                            <td>DIC</td>
                            <td>DIC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_16</td>
                            <td>DIT</td>
                            <td>DIT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_17</td>
                            <td>DPU</td>
                            <td>DPU</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_18</td>
                            <td>EXQ</td>
                            <td>EXQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_19</td>
                            <td>EXW</td>
                            <td>EXW</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_20</td>
                            <td>FAS</td>
                            <td>FAS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_21</td>
                            <td>FCA</td>
                            <td>FCA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_22</td>
                            <td>FOB</td>
                            <td>FOB</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_23</td>
                            <td>FOC</td>
                            <td>FOC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_24</td>
                            <td>FOT</td>
                            <td>FOT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_25</td>
                            <td>PRC</td>
                            <td>PRC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Inco_terms_26</td>
                            <td>PUO</td>
                            <td>PUO</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBTimeZone">
            <label for="TPOUBTimeZone">Timezone</label>
            <ul>
                <li>
                    <h2>Code table : Timezone</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>CT_Time Zone &nbsp;&nbsp;&nbsp;</td>
                            <td>CT_Time Zone Value&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>TZCODE_01</td>
                            <td>SG</td>
                            <td>SINGAPORE</td>
                            <td>UTC +08:00</td>
                            <td>SINGAPORE</td>
                            <td>Asia/Singapore</td>
                            <td>+8:00/SGST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_02</td>
                            <td>TH</td>
                            <td>THAILAND</td>
                            <td>UTC+07:00</td>
                            <td>THAILAND</td>
                            <td>Asia/Bangkok</td>
                            <td>+7:00/THST</td>
                        </tr>

                        <tr>
                            <td>TZCODE_03</td>
                            <td>MY</td>
                            <td>MALAYSIA</td>
                            <td>UTC+08:00</td>
                            <td>MALAYSIA</td>
                            <td>Asia/Kuala_Lumpur</td>
                            <td>+8:00/MYST</td>
                        </tr>

                        <tr>
                            <td>TZCODE_04</td>
                            <td>VN</td>
                            <td>VIETNAM</td>
                            <td>UTC+07:00</td>
                            <td>VIETNAM</td>
                            <td>Asia/Ho_Chi_Minh</td>
                            <td>+7:00/VNST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_05</td>
                            <td>TW</td>
                            <td>TAIWAN</td>
                            <td>UTC+08:00</td>
                            <td>TAIWAN</td>
                            <td>Asia/Taipei</td>
                            <td>+8:00/TWST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_06</td>
                            <td>CN</td>
                            <td>CHINA</td>
                            <td>UTC+08:00</td>
                            <td>CHINA</td>
                            <td>Asia/Shanghai</td>
                            <td>+8:00/CNST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_07</td>
                            <td>ID</td>
                            <td>INDONESIA</td>
                            <td>UTC+07:00</td>
                            <td>INDONESIA</td>
                            <td>Asia/Jakarta</td>
                            <td>+7:00/IDST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_08</td>
                            <td>PH</td>
                            <td>PHILIPPINES</td>
                            <td>UTC+08:00</td>
                            <td>PHILIPPINES</td>
                            <td>Asia/Manila</td>
                            <td>+8:00/PHST</td>
                        </tr>
                        <tr>
                            <td>TZCODE_09</td>
                            <td>KHKN</td>
                            <td>CAMBODIA</td>
                            <td>UTC+07:00</td>
                            <td>CAMBODIA</td>
                            <td>Asia/Bangkok</td>
                            <td>+7:00/KHKNST</td>
                        </tr>

                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBPartyType">
            <label for="TPOUBPartyType"> Party Type</label>
            <ul>
                <li>
                    <h2>Code table : Party Type</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td >Party_type_1</td>
                            <td>Border</td>
                            <td>Border</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_2</td>
                            <td>Carrier</td>
                            <td>Carrier</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_3</td>
                            <td>Consignee</td>
                            <td>Consignee</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_4</td>
                            <td>Consignor</td>
                            <td>Consignor</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_5</td>
                            <td>CUSTOMER</td>
                            <td>CUSTOMER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_6</td>
                            <td>DELIVERY</td>
                            <td>DELIVERY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_7</td>
                            <td>FREIGHT_PAYER</td>
                            <td>FREIGHT_PAYER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_8</td>
                            <td>In Transit</td>
                            <td>In Transit</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_9</td>
                            <td>Internal BU</td>
                            <td>Internal BU</td>
                            <td></td>
                            <td></td>
                        </tr>

                        <tr>
                            <td >Party_type_10</td>
                            <td>NOTIFY_PARTY</td>
                            <td>NOTIFY_PARTY</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_11</td>
                            <td>Overseas OL</td>
                            <td>Overseas OL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_12</td>
                            <td>PICKUP</td>
                            <td>PICKUP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_13</td>
                            <td>Port</td>
                            <td>Port</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_14</td>
                            <td>Shipper</td>
                            <td>Shipper</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_15</td>
                            <td>xDock</td>
                            <td>xDock</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td >Party_type_16</td>
                            <td>Yard</td>
                            <td>Yard</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBVALADDSER">
            <label for="TPOUBVALADDSER">ValueAddedServices</label>
            <ul>
                <li>
                    <h2>Code table : VALUE ADDED SERVICES</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>VAS_1</td>
                            <td>MAN</td>
                            <td>MANPOWER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>VAS_2</td>
                            <td>TLG</td>
                            <td>TALEGATE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>VAS_3</td>
                            <td>INS</td>
                            <td>INSURANCE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>VAS_4</td>
                            <td>CSC</td>
                            <td>CUSTOMS CLEARANCE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>VAS_5</td>
                            <td>LSH</td>
                            <td>LASHING</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>VAS_6</td>
                            <td>CRN</td>
                            <td>CRANE</td>
                            <td></td>
                            <td></td>
                        </tr>

                    </Table>
                </li>
            </ul>
        </li>
        <li class="section">
            <input type="checkbox" id="TPOUBMANREF">
            <label for="TPOUBMANREF">Manage Reference</label>
            <ul>
                <li>
                    <h2>Code table : Manage Reference</h2>
                    <Table border=0.5 style="color:black; width:100%;">
                        <tr style="background-color:lightgrey">
                            <td>ID</td>
                            <td>Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                            <td>Target Code&nbsp;&nbsp;&nbsp;</td>
                            <td>Description&nbsp;&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td>Manage_ref_1</td>
                            <td>ETA</td>
                            <td>ETA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_2</td>
                            <td>A15</td>
                            <td>Rolls Royce Classification codes</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_3</td>
                            <td>AAB</td>
                            <td>Proforma invoice number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_4</td>
                            <td>AAC</td>
                            <td>Documentary Credit Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_5</td>
                            <td>AAK</td>
                            <td>Carrier Pro no.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_6</td>
                            <td>AAM</td>
                            <td>Waybill number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_7</td>
                            <td>AAO</td>
                            <td>Consignee's shipment reference no.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_8</td>
                            <td>AAP</td>
                            <td>Part consignment number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_9</td>
                            <td>AAU</td>
                            <td>Despatch note number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_10</td>
                            <td>ABC</td>
                            <td>Customer specific ref.1</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_11</td>
                            <td>ABF</td>
                            <td>ABF Freight Systems Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_12</td>
                            <td>ABH</td>
                            <td>Pick Up Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_13</td>
                            <td>ABO</td>
                            <td>Originator's Reference Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_14</td>
                            <td>ABQ</td>
                            <td>Importer reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_15</td>
                            <td>ABU</td>
                            <td>Article number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_16</td>
                            <td>ABW</td>
                            <td>Stock keeping unit number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_17</td>
                            <td>ACD</td>
                            <td>Additional reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_18</td>
                            <td>ACN</td>
                            <td>Collection Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_19</td>
                            <td>ACONB</td>
                            <td>Acon Branch and Centre Code</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_20</td>
                            <td>ACONC</td>
                            <td>Acon Credit Request Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_21</td>
                            <td>ACONT</td>
                            <td>Acon Tracking and Short Code</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_22</td>
                            <td>ADE</td>
                            <td>Account Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_23</td>
                            <td>ADI</td>
                            <td>Additional Information</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_24</td>
                            <td>AEP</td>
                            <td>Project number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_25</td>
                            <td>AFS</td>
                            <td>AFS#</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_26</td>
                            <td>AGE</td>
                            <td>Agent's reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_27</td>
                            <td>AHA</td>
                            <td>Packaging Specification number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_28</td>
                            <td>ASL</td>
                            <td>Aviation Service level</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_29</td>
                            <td>ASO</td>
                            <td>Password</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_30</td>
                            <td>AWB</td>
                            <td>Air Waybill number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_31</td>
                            <td>BCN</td>
                            <td>Buying Customer name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_32</td>
                            <td>BKN</td>
                            <td>Booking number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_33</td>
                            <td>BLN</td>
                            <td>Bill of Lading</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_34</td>
                            <td>BN</td>
                            <td>Booking Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_35</td>
                            <td>BOE</td>
                            <td>Border Express Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_36</td>
                            <td>BOL</td>
                            <td>BOL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_37</td>
                            <td>BOO</td>
                            <td>Original Manfest No.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_38</td>
                            <td>BRG</td>
                            <td>Carrier Bring</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_39</td>
                            <td>BRN</td>
                            <td>Branch</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_40</td>
                            <td>BU</td>
                            <td>BUSINESS UNIT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_41</td>
                            <td>BULK RETURN ORDER</td>
                            <td>BULK RETURN ORDER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_42</td>
                            <td>CC</td>
                            <td>COST CENTRE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_43</td>
                            <td>CCN</td>
                            <td>Customer Care Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_44</td>
                            <td>CDT</td>
                            <td>Cancel Date Time</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_45</td>
                            <td>CG</td>
                            <td>Consignee's Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_46</td>
                            <td>CHASSIS</td>
                            <td>Vehicle Chassis Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_47</td>
                            <td>CHRIE MEYRICK</td>
                            <td>CONTACT PERSON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_48</td>
                            <td>CID</td>
                            <td>Carrier ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_49</td>
                            <td>CIN</td>
                            <td>Commercial Invoice Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_50</td>
                            <td>CIP</td>
                            <td>CID /Location Id of CIP</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_51</td>
                            <td>CIV</td>
                            <td>Commercial Invoice Value</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_52</td>
                            <td>CM</td>
                            <td>Parcel Tracking Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_53</td>
                            <td>CMP</td>
                            <td>Company</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_54</td>
                            <td>CN</td>
                            <td>Supply Call Of Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_55</td>
                            <td>CNA</td>
                            <td>IOR Customer Name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_56</td>
                            <td>CO</td>
                            <td>Buyer's Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_57</td>
                            <td>COI</td>
                            <td>Consignee ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_58</td>
                            <td>COM</td>
                            <td>Original Communication Refernece</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_59</td>
                            <td>CONTAINER</td>
                            <td>CONTAINER NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_60</td>
                            <td>CORID</td>
                            <td>CORID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_61</td>
                            <td>CR</td>
                            <td>Customer reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_62</td>
                            <td>CSF</td>
                            <td>Ship From Country</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_63</td>
                            <td>CSN</td>
                            <td>Ship From Country Name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_64</td>
                            <td>CT</td>
                            <td>Contract Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_65</td>
                            <td>CTO</td>
                            <td>Ship To Country</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_66</td>
                            <td>CTR</td>
                            <td>CTR</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_67</td>
                            <td>CTY</td>
                            <td>Ship To Country Name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_68</td>
                            <td>CUSTREF</td>
                            <td>Customer Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_69</td>
                            <td>CW</td>
                            <td>Package Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_70</td>
                            <td>DELNUM</td>
                            <td>Delivery Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_71</td>
                            <td>DHL</td>
                            <td>DHL Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_72</td>
                            <td>DIV</td>
                            <td>Division</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_73</td>
                            <td>DLS</td>
                            <td>Design Logistic Santq Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_74</td>
                            <td>DQ</td>
                            <td>Delivery Note</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_75</td>
                            <td>DRIPN</td>
                            <td>Driver Phone Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_76</td>
                            <td>DRS</td>
                            <td>Document Retrieval Service</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_77</td>
                            <td>DTB</td>
                            <td>Delivery Document Date</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_78</td>
                            <td>EBN</td>
                            <td>Exporter's reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_79</td>
                            <td>EBR</td>
                            <td>Web Booking Referenece</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_80</td>
                            <td>ELR</td>
                            <td>Logistics Representative</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_81</td>
                            <td>EMN</td>
                            <td>e-Booking Manfest Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_82</td>
                            <td>EQD</td>
                            <td>Equipment Double Deck</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_83</td>
                            <td>EQT</td>
                            <td>Equipment Type</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_84</td>
                            <td>ESN</td>
                            <td>ENGINE SERIAL NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_85</td>
                            <td>EXA</td>
                            <td>Exapaq Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_86</td>
                            <td>FDX</td>
                            <td>FedEx Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_87</td>
                            <td>FF</td>
                            <td>Freight forwarder's reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_88</td>
                            <td>FI</td>
                            <td>File line Identifier</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_89</td>
                            <td>FN</td>
                            <td>Freight bill number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_90</td>
                            <td>GLR</td>
                            <td>Green light required</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_91</td>
                            <td>IA</td>
                            <td>Vendor number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_92</td>
                            <td>ICL</td>
                            <td>Is Customer Location</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_93</td>
                            <td>IL</td>
                            <td>IL Indicator</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_94</td>
                            <td>IM-21-271</td>
                            <td>IM-21-271 FIRST</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_95</td>
                            <td>INN</td>
                            <td>Com Ref</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_96</td>
                            <td>INVOICE</td>
                            <td>INVOICE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_97</td>
                            <td>IV</td>
                            <td>Invoice Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_98</td>
                            <td>IVL</td>
                            <td>Invoice Line Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_99</td>
                            <td>JFR</td>
                            <td>JOB FILE NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_100</td>
                            <td>JG1</td>
                            <td>KN Reference Gateway 1</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_101</td>
                            <td>JG2</td>
                            <td>KN Reference Gateway 2</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_102</td>
                            <td>JG3</td>
                            <td>KN Reference Gateway 3</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_103</td>
                            <td>JG4</td>
                            <td>KN Reference Gateway 4</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_104</td>
                            <td>JG5</td>
                            <td>KN Reference Gateway 5</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_105</td>
                            <td>JOD</td>
                            <td>KN Reference Ordering Depot</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_106</td>
                            <td>JRD</td>
                            <td>KN Reference Receiving Depot</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_107</td>
                            <td>JSD</td>
                            <td>KN Reference Sending Depot</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_108</td>
                            <td>KN1</td>
                            <td>KN Interval reference 1</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_109</td>
                            <td>KNF</td>
                            <td>KN FreightNet Location</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_110</td>
                            <td>LD</td>
                            <td>LANE ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_111</td>
                            <td>LDT</td>
                            <td>Lead Time</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_112</td>
                            <td>LFX</td>
                            <td>LFX</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_113</td>
                            <td>LO</td>
                            <td>Load planning number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_114</td>
                            <td>LOAD-NUMBER</td>
                            <td>number load from US system</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_115</td>
                            <td>LPC</td>
                            <td>Load Plan Connote</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_116</td>
                            <td>LPRO</td>
                            <td>Lenovo PRO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_117</td>
                            <td>LRF</td>
                            <td>Loading Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_118</td>
                            <td>MF</td>
                            <td>Manufacture's part number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_119</td>
                            <td>MLI</td>
                            <td>Multi Location Indicator</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_120</td>
                            <td>MMT</td>
                            <td>Material Movement Ticket</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_121</td>
                            <td>MN</td>
                            <td>MANIFEST NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_122</td>
                            <td>MODE</td>
                            <td>MODE OF TRANSPORTATION</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_123</td>
                            <td>MR</td>
                            <td>Online Quote Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_124</td>
                            <td>MRN</td>
                            <td>Movement Reference No.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_125</td>
                            <td>MVTY</td>
                            <td>MOVEMENET TYPE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_126</td>
                            <td>NDR</td>
                            <td>NDR package</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_127</td>
                            <td>NOTE</td>
                            <td>NOTE</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_128</td>
                            <td>O06</td>
                            <td>Buyer Name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_129</td>
                            <td>OCR</td>
                            <td>Order Cross Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_130</td>
                            <td>ON</td>
                            <td>Purchase Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_131</td>
                            <td>OPR</td>
                            <td>OPERATOR NAME</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_132</td>
                            <td>OR</td>
                            <td>General Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_133</td>
                            <td>ORD</td>
                            <td>Original Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_134</td>
                            <td>ORD_DLVINST</td>
                            <td>Driver Delivery Instructions</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_135</td>
                            <td>ORD_PIKINST</td>
                            <td>Driver Pickup Instructions</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_136</td>
                            <td>OT</td>
                            <td>Order Type</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_137</td>
                            <td>OTM</td>
                            <td>OTM Domain</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_138</td>
                            <td>PAULA LASSALLY</td>
                            <td>CONTACT PERSON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_139</td>
                            <td>PCF</td>
                            <td>Parcel Force</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_140</td>
                            <td>PICKING &amp; DELIVERY LOCATIONS</td>
                            <td>PICKING AT INTERPEL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_141</td>
                            <td>PICKNUM</td>
                            <td>Pick Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_142</td>
                            <td>PK</td>
                            <td>Packing  List Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_143</td>
                            <td>PLATE NO.</td>
                            <td>PLATE NO.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_144</td>
                            <td>PN</td>
                            <td>Part Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_145</td>
                            <td>PO</td>
                            <td>PO</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_146</td>
                            <td>PON</td>
                            <td>PO Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_147</td>
                            <td>POS</td>
                            <td>KN Reference Job File Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_148</td>
                            <td>PPF</td>
                            <td>Principals Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_149</td>
                            <td>PQ</td>
                            <td>PQ</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_150</td>
                            <td>PRE ADVISE CONFIRMATION</td>
                            <td>PRE ADVISE CONFIRMATION</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_151</td>
                            <td>PRE ADVISE SENT</td>
                            <td>PRE ADVISE SENT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_152</td>
                            <td>PRF</td>
                            <td>Party Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_153</td>
                            <td>PRT</td>
                            <td>Product Type</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_154</td>
                            <td>PSI</td>
                            <td>Planned Shipment ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_155</td>
                            <td>RC</td>
                            <td>Distribution Area Code</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_156</td>
                            <td>REMARKS</td>
                            <td>remarks</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_157</td>
                            <td>REPLACEMENT</td>
                            <td>REPLACEMENT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_158</td>
                            <td>RLG</td>
                            <td>ROADLOG TRACKING NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_159</td>
                            <td>ROT</td>
                            <td>Routing</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_160</td>
                            <td>RUCK</td>
                            <td>RUCK</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_161</td>
                            <td>SAC</td>
                            <td>SALOG order creator</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_162</td>
                            <td>SALORD</td>
                            <td>Sales Order</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_163</td>
                            <td>SCAC</td>
                            <td>SCAC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_164</td>
                            <td>SD</td>
                            <td>Department Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_165</td>
                            <td>SDT</td>
                            <td>SALOG Delivery Type</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_166</td>
                            <td>SEAL</td>
                            <td>SEAL NO.</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_167</td>
                            <td>SI</td>
                            <td>SID(Shippers`s id no. for shipment)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_168</td>
                            <td>SL</td>
                            <td>SERVICE LEVEL</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_169</td>
                            <td>SM</td>
                            <td>Sales Office number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_170</td>
                            <td>SNN</td>
                            <td>Shipment No. Receiving Forwarder</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_171</td>
                            <td>SPC</td>
                            <td>Service Provider Code</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_172</td>
                            <td>SQ</td>
                            <td>CONNOTE #</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_173</td>
                            <td>SRF</td>
                            <td>Shippers Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_174</td>
                            <td>SRN</td>
                            <td>Shipment reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_175</td>
                            <td>ssl</td>
                            <td>Carrier Code (SCAC)</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_176</td>
                            <td>STK</td>
                            <td>Is Stackable</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_177</td>
                            <td>STT</td>
                            <td>Startrack package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_178</td>
                            <td>TARE WEIGHT</td>
                            <td>TARE WEIGHT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_179</td>
                            <td>TCR</td>
                            <td>Temparature Controlled Range</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_180</td>
                            <td>TEST</td>
                            <td>TEST</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_181</td>
                            <td>TEST REF</td>
                            <td>TETS REF DESC</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_182</td>
                            <td>TEX</td>
                            <td>Text Keys</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_183</td>
                            <td>TGP</td>
                            <td>Transgroup Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_184</td>
                            <td>TID</td>
                            <td>Transport ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_185</td>
                            <td>TIP</td>
                            <td>TIPSA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_186</td>
                            <td>TN</td>
                            <td>Transaction reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_187</td>
                            <td>TNT</td>
                            <td>Package ID TNT</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_188</td>
                            <td>TON</td>
                            <td>Transport Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_189</td>
                            <td>TORI CLARIDGE</td>
                            <td>CONTACT PERSON</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_190</td>
                            <td>TRA</td>
                            <td>Traler Reference</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_191</td>
                            <td>TRN</td>
                            <td>Road Tracking Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_192</td>
                            <td>TSB</td>
                            <td>TSB BARCELONA</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_193</td>
                            <td>TXT</td>
                            <td>TRANS X TAR</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_194</td>
                            <td>UCR</td>
                            <td>UNIQUI CONSIGNMENT REFERENCE NUMBER</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_195</td>
                            <td>UPS</td>
                            <td>UPS Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_196</td>
                            <td>USP</td>
                            <td>USPS  Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_197</td>
                            <td>USR</td>
                            <td>User Reeference Order Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_198</td>
                            <td>UUID</td>
                            <td>UUID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_199</td>
                            <td>VON</td>
                            <td>Voyage Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_200</td>
                            <td>VP</td>
                            <td>Product number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_201</td>
                            <td>VR</td>
                            <td>Vendor ID Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_202</td>
                            <td>WBN</td>
                            <td>WBN</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_203</td>
                            <td>WH</td>
                            <td>Warehouse</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_204</td>
                            <td>X01</td>
                            <td>KN INVOICE FOR CLIENTS</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_205</td>
                            <td>XBRDR</td>
                            <td>XBorder</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_206</td>
                            <td>XC</td>
                            <td>Cargo Control Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_207</td>
                            <td>XPO</td>
                            <td>XPO Logistics</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_208</td>
                            <td>XSA</td>
                            <td>3PL Account</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_209</td>
                            <td>XSC</td>
                            <td>3PL Code</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_210</td>
                            <td>XSN</td>
                            <td>3PL Name</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_211</td>
                            <td>XSR</td>
                            <td>Tracking Number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_212</td>
                            <td>YRC</td>
                            <td>YRC Package ID</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_213</td>
                            <td>ZZZ</td>
                            <td>Mutually Defined reference number</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_214</td>
                            <td>CRI</td>
                            <td>Carrier Contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_215</td>
                            <td>SHI</td>
                            <td>Shipper Contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_216</td>
                            <td>CNI</td>
                            <td>Consignee Contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_217</td>
                            <td>NPI</td>
                            <td>Notifying Party
                                contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_218</td>
                            <td>PKI</td>
                            <td>PICK UP contact Info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_219</td>
                            <td>DLI</td>
                            <td>Delhivery Contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <td>Manage_ref_220</td>
                            <td>CUI</td>
                            <td>Customer Contact info</td>
                            <td></td>
                            <td></td>
                        </tr>
                    </Table>
                </li>
            </ul>
        </li>
    </ul>
</li>

</ul>
</body>
</html>
