<section>
    <div class="col-md-12">
        <?php
            foreach ($vehicles as $vehicle) {
                echo '<button class="switchVehicle" data-vehicle="'.str_replace(' ', '', $vehicle->register_number).'">'.
                    ($vehicle->register_number ?: '?').
                    '</button>';
            }
        ?>
    </div>
<?php

    foreach ($vehicles as $vehicle) {

        $box = 'default';
        $head_width = 4;
        if ($vehicle->status) {
            $box = 'primary';
            $head_width = 12;
        }

    ?>

     <div class="col-md-<?= $head_width ?> current_veh" id="<?= str_replace(' ', '', $vehicle->register_number) ?>">
        <div class="box box-<?= $box ?>">
        <div class="box-header ui-sortable-handle" style="cursor: move;">
            <i class="fa fa-truck"></i><h3 class="box-title home"><?= $vehicle->register_number ?></h3>
            <div class="box-tools">
                <?php
                    if (1 === (int) $vehicle->status) {
                        echo '<span class="badge bg-'.$vehicle->speed_badge_color.'">' .
                            uom_string($vehicle->speed_multiplied, 'kph', 0) .
                            '</span>';
                    }
                ?>
            </div>
        </div>

        <div class="box-body">
    <?php
        $count = 0;

        $cveh = $vehicle->register_number;
        foreach ($vshiftsdata as $rw) {
                if ($cveh == $rw->register_number) {
                    $shift_info = "[ " . date("Y-m-d h:i A", strtotime($rw->startdate)) . " ]";
                    $splace     = $eplace = "";
                    $shttype    = "Regular";
                    $splace     = $rw->splace;
                    $eplace     = $rw->eplace;
                    $fromto     = $splace.' <i class="fas fa-angle-double-right"></i> '.$eplace;
                    if ($rw->status) {

                        $location_name = $vehicle->location_name;

                        if ($vehicle->status) {
                            $acttime = $vehicle->stime;
                        }else{
                            $acttime = getvalue("stime", "id", $rw->tripid, "tb_trips", "");
                        }

                        echo "<div class='row'><div class='col-md-6 ellipsis'><b>Live Shipment : </b> " .
                            "<span name='" .base_url("visibility/tripMap/".$vehicle->tripid) . "' target='_blank' " .
                            "class='trip_map_live'><i class='fa fa-map-marker' aria-hidden='true'></i> " . $location_name .
                            " </span></div><div class='col-md-6' style='text-align:right;'><b>Actual Start Time:</b> " .
                            date("Y-m-d h:i:s A", strtotime($acttime)) . "</div></div>";
    ?>
                        <table border="0" width="100%" style="margin-bottom: 20px">
                            <tr>
                                <td width="100%">
                                    <span class="tripdetails" id="get_<?= $rw->id ?>_<?= $rw->tripid ?>"
                                          data-toggle="popover" data-placement="bottom"
                                          style="cursor:pointer;"
                                          onclick="openHistory('<?=$rw->id?>','','')"
                                    ><?= $fromto ?> (<?= $rw->shipmentid ?>) <?= $shift_info ?> </span>
                                </td>
                                <td width="10%">
                                    <form action="<?php echo base_url();?>driverapiv2/closeTripfromweb" method="POST">
                                        <?php if ($vehicle->status == 1) : ?>
                                        <input type="hidden" name="driver_id" value="<?= $vehicle->driver_id ?>" />
                                        <input type="hidden" name="trip_id" value="<?= $vehicle->tripid ?>" />
                                        <input type="hidden" name="imei" value="<?= $vehicle->start_imei ?? '' ?>" />
                                        <input type="hidden" name="odometer" value="<?= $vehicle->start_reading ?>" />
                                        <button class="btn btn-sm btn-danger" type="submit" style="border-bottom: 1px solid #3c8dbc;border-radius: 0;height: 31px;">Finish</button>
                                        <?php endif; ?>
                                    </form>
                                </td>
                            </tr>
                        </table>
                        <?php

                        $details = $rw->details;

                        echo '<ul class="progress-indicator" style="overflow-x: auto;">';

                        if(count($details->stops)){
                            echo '<tr>';
                            $bcClassValues = ['', 1 => 'waiting', 2 => 'completed', 3=> 'failed'];
                            foreach ($details->stops as $i => $stop) {
                                $s1 = $stop;
                                $bc_class = $bcClassValues[$stop['stopstatus']] ?? "truck_gray_lg";

                                echo '<li class="'.$bc_class.'" id="694" onclick="openHistoryMap(\''.$rw->id.'\',\''.$stop['id'].'\',\'\',\''.$stop["stopstatus"].'\',\''.($vehicle->start_imei ?? '').'\')" '.
                                    'style="cursor:pointer;"><span class="bubble"><span style="color: white;z-index: 999;font-weight:600;padding: 2px;">'.($i+1).'</span></span>'.
                                    $stop["stopname"].
                                    '</li>';
                            }
                            echo '</tr>';
                        }
                        echo '</ul>';
                    } else {
                        if ($count == 0) {
                            echo "<b>Next Shipments:</b><br>";
                        }
                        echo "<span class=' tripdetails' id='get_" . $rw->id . "_" . $rw->register_number . "' data-toggle='popover' data-placement='bottom' style='cursor:pointer;'>" . $fromto . " " . $shift_info . " (" . $shttype . ")</span><br/>";
                        $count++;
                    }
                }
            }

        ?>
         </div>
        </div>
      </div>
      <?php
    }

?>
     </section>
<script type="text/javascript">

    $(".switchVehicle").click(function() {
       var vehicle = $(this).attr('data-vehicle');
       var offset = $("#" + vehicle).offset()?.top;
       window.scrollTo(0, offset - 110);
    });

    $(".home").click(function() {
        window.scrollTo(0,0);
    })

function changestatus(trip, emp, status) {
    var url = baseurl + 'dashboard/changestatus';
    $.ajax({
        url: url,
        data: {
            trip_id: trip,
            emp_id: emp,
            status: status
        },
        method: "POST",
        beforeSend: function() {
            $(".overlay").show();
        },
        success: function(data) {
            $(".overlay").hide();
            $(".main_content").html("").html(data);
        }
    });
}

$(".trip_map_live").click(function() {
    var url = $(this).attr("name");
    $("#rtpopuptitle").html("Live Trips Map view");
    $('#RtPopupModal').modal('toggle');
    $("#viewrtdata").addClass('no-padding').css('height', '75vh');
    $('#RtPopupType').addClass('modal-lg').css('width','90%');
    $("#viewrtdata").html('<iframe src="' + url + '" scrolling="no" frameBorder="0" width="100%" height="100%">/iframe>');
});

function openHistoryMap(shift_id, stop_id, pickup_id,status,imei) {
    $.ajax({
        url: "<?=base_url('visibility/openHistoryMap')?>",
        type: "POST",
        data: {
            shift_id: shift_id,
            stop_id: stop_id,
            pickup_id: pickup_id,
            status: status,
            imei:imei
        },
        beforeSend: function() {
            $(".containerModal").modal("show");
            $(".containerModal").find(".modal-title").html("Status History & Attached documents");
            $(".containerModal").find(".modal-body").html("<center><progress></center>");
        },
        success: function(data) {
            $(".containerModal").find(".modal-body").html(data);
        },
        error: function() {
            $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
        }
    });
}

function openHistory(shift_id,stop_id,pickup_id){
    $.ajax({
        url:"<?=base_url('visibility/openHistory')?>",
        type:"POST",
        data:{shift_id:shift_id,stop_id:stop_id,pickup_id:pickup_id},
        beforeSend:function(){
            $(".containerModal").modal("show");
            $(".containerModal").find(".modal-title").html("Status History & Attached documents");
            $(".containerModal").find(".modal-body").html("<center><progress></center>");
        },
        success:function(data){
            $(".containerModal").find(".modal-body").html(data);
        },error:function(){
            $(".containerModal").find(".modal-body").html("<center style='color:red;font-weight:bold'>Request failed!</center>");
        }
    });
}
</script>
<style type="text/css">
    .progress-indicator > li .bubble {
        display: grid !important;
    }
    .progress-indicator > li {
        color: #333333 !important;
    }
    .dataHover:hover .dataHoverBlock {
        display: block;
    }
    .dataHoverBlock {
        position: relative;
        display: none;
    }
    .dataHoverBlock table {
        color: black;
        display: block;
        position: relative;
        width: auto;
        background-color: #DDD;
        padding: 5px;
        border-radius: 4px;
        z-index: 1000;
    }
    .dataHoverBlock table tr td {
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        max-width: 150px;
    }
    .progress-indicator > li.waiting .bubble:before, .progress-indicator > li.waiting .bubble:after {
        background-color: #dda339 !important;
        border-color: #333 !important;
    }
    .progress-indicator > li.waiting .bubble {
        background-color: #dda339 !important;
        color: #dda339 !important;
        border-color: #333 !important;
    }
    .switchVehicle {
        margin: 4px;
    }
    .current_veh {
        margin-top: 40px;
    }
</style>
