<html>
<head>
    <title><?php echo "#".($bookingId ?? ''); ?> | Booking ePOD Information | Svkonekt</title>
</head>
<body>
<?php
    /** @var \App\PodUploads\MakePod\Measurements $measurements */
    $quantityString = "quantity: " . $measurements['quantity'] . ", volume: " . $measurements['volume'] . "m<sup>3</sup>, weight: " . $measurements['weight'] . "kg";
    require_once ("./application/helpers/epod_helper.php");
?>
<style>
    div, th, td {
        vertical-align: top;
        line-height: 1.42;
        padding: 8px;
    }
    .no-highlight {
        -webkit-tap-highlight-color: rgba(0,0,0,0);
    }
    .text-left {
        text-align: left;
    }
    section, .base1, .pod-upload {
        font-family: 'Source Sans Pro','Helvetica Neue',Helvetica, sans-serif;
    }
    .base1 {
        -webkit-tap-highlight-color: rgba(0,0,0,0);
        border-collapse: collapse;
        border-spacing: 0;
        border-top: 1px solid #ddd;
        box-sizing: border-box;
    }
    .no-border {
        border: 0;
    }
    .pod-upload {
        border-collapse: collapse;
        border-spacing: 0;
        box-sizing: border-box;
        position: relative;
        min-height: 1px;
        float: left;
        margin: 8px;
    }
</style>
<section class="no-highlight" style="font-size: 14px;color: #333;font-weight: 400;box-sizing: border-box;display: block;position: relative;background: #fff">
    <table style="box-sizing: border-box;font-weight: 500;line-height: 1.1;color: inherit;font-family: 'Source Sans Pro',sans-serif;padding-bottom: 9px;border-bottom: 1px solid #eee;margin: 10px 0 20px 0;font-size: 22px;width: 100%">
        <tr>
            <td class="base1 no-border"><img src="./assets/images/etnlogo.png" style="height: 40px"></td>
            <td class="base1 no-border" style="font-size: 14px; text-align: right">Date: <?= $documentDate ?? date("d/M/Y") ?></td>
        </tr>
    </table>
    <!-- Table row -->
    <table style="width: 100%">
        <tr>
            <td class="base1 no-border">
                <center><h3>Svkonekt</h3></center>
                <center><h4>Booking ePOD Information</h4></center>
            </td>
        </tr>
        <tr>
            <td class="base1">
                <h4>Order Information:</h4>
                <table style="width: 100%">
                    <tr>
                        <th class="base1 text-left">Booking ID</th>
                        <td class="base1" colspan="3"><?php echo "#".$bookingId; ?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">External Order ID</th>
                        <td class="base1" colspan="3"><?php echo ($externalOrderId ?? ''); ?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">Shipper address</th>
                        <td class="base1"><?php echo $shipperAddress;?></td>
                        <th class="base1 text-left">Consignee address</th>
                        <td class="base1"><?php echo $consigneeAddress;?></td>
                    </tr>
                    <tr>
                        <?php
                        $curtz = $this->session->userdata('usr_tzone')['timezone'] ?? 'UTC';
                        $pickupTime = $actualPickupDateTime ? getdatetimebytimezone($curtz, $actualPickupDateTime, 'UTC') : '';
                        $deliveryTime = $actualDeliveryDateTime ? getdatetimebytimezone($curtz,$actualDeliveryDateTime,'UTC') : '';
                        ?>
                        <th class="base1 text-left">Actual pickup date</th>
                        <td class="base1"><?= $pickupTime ? date("Y-m-d",strtotime($pickupTime['date'])) : '-'?></td>
                        <th class="base1 text-left">Actual delivery date</th>
                        <td class="base1"><?= $deliveryTime ? date("Y-m-d",strtotime($deliveryTime['date'])) : '-'?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">Pickup Time</th>
                        <td class="base1"><?= $pickupTime ? date("H:i A",strtotime($pickupTime['time'])).' '. $curtz : '-' ?></td>
                        <th class="base1 text-left">Delivery Time</th>
                        <td class="base1"><?= $deliveryTime ? date("H:i A",strtotime($deliveryTime['time'])).' '. $curtz : '-' ?></td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">
                            Summary of cargo details
                        </th>
                        <td colspan="3" class="base1"> <?php echo $quantityString; ?> </td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">
                            Consignee's signature
                        </th>
                        <?php
                        $obj = new stdClass();
                        $arr = explode('/', $signatureFile);
                        $fileOnly = $arr[count($arr) - 1];
                        $obj->imgpath = $fileOnly;
                        $obj->hash = $signatureHash;
                        $style = "height: 80px";
                        ?>
                        <td colspan="3" class="base1">
                            <?= $signatureFile ? epod_as_html_to_pdf($obj, $style) : '-' ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="base1 text-left">Comments</th>
                        <td colspan="3" class="base1"> <?= $deliveryComments ?? '' ?> </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</section>
</body>
</html>

