<html>
<head>
    <title><?php
        echo "#" . ($orderData['order_id'] ?? '') . " " . $this->lang->line('general_delivery') . " " . $this->lang->line('document'); ?> | Svkonekt</title>
</head>
<body>
<?php
require_once("./application/helpers/epod_helper.php");
?>
<style>
    div, td {
        vertical-align: top;
        padding: 2px;
    }

    .no-highlight {
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
    }

    .text-left {
        text-align: left;
    }

    section, .base1, .pod-upload {
        font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, sans-serif;
    }

    .base1 {
        -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
        border-collapse: collapse;
        border-spacing: 0;
        border-top: 1px solid #ddd;
        box-sizing: border-box;
    }

    .no-border {
        border: 0;
    }

    .pod-upload {
        border-collapse: collapse;
        border-spacing: 0;
        box-sizing: border-box;
        position: relative;
        min-height: 1px;
        float: left;
        margin: 8px;
    }

    .table-border {
        font-family: arial, sans-serif;
        border: 1px solid;
        border-collapse: collapse;
        text-align: left;
    }

    .td-class {
        text-align: left;
        vertical-align: middle;
    }

    th {
        color: white;;
        font-size: 10pt;
        background: #152c55;
    }

</style>
<section class="no-highlight" style="font-size: 14px;color: #333;font-weight: 400;box-sizing: border-box;display: block;position: relative;background: #fff">
    <table style="box-sizing: border-box;font-weight: 500;line-height: 1.1;color: inherit;padding-bottom: 9px;border-bottom: 1px solid #eee;margin: 10px 0 20px 0;font-size: 22px;width: 100%">
        <tr>
            <td class="base1 no-border"><img src="./assets/images/etnlogo.png" style="height: 40px"></td>
            <td class="base1 no-border" style="font-size: 16px;font-family: arial, sans-serif;font-weight: 400;" align="right"><b><?= $this->lang->line('general_delivery') . " " . $this->lang->line('document') ?> </b></td>
        </tr>
    </table>
    <!-- Table row -->
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th class="table-border"><?= $this->lang->line('booking_id') ?></th>
                    <th class="table-border"><?= $this->lang->line('kn_tripid') ?></th>
                    <th class="table-border"><?= $this->lang->line('carrier') . " " . $this->lang->line('manifest') . " " . $this->lang->line('id') ?></th>
                    <th class="table-border"><?= $this->lang->line('sender') ?></th>
                    <th class="table-border"><?= $this->lang->line('mode_of_transport') ?></th>
                    <th class="table-border"><?= $this->lang->line('bpartner_service') ?></th>
                </tr>
                <tr>
                    <td class="td-class table-border"><?= $orderData['order_id'] ?? '' ?></td>
                    <td class="td-class table-border"><?= $orderData['shipmentid'] ?? '' ?></td>
                    <?php if ($showCarrier ?? false) :?>
                        <td class="td-class table-border"><?= $manifestId ?? '' ?></td>
                    <?php  else :  ?>
                        <td class="td-class table-border"></td>
                    <?php endif;
                    $companyCode = $orderData['company_code'] ?? "";
                    $shipperName = $partyNames['shipper'] ?? "";
                    if ($companyCode != ""):
                        if (checkAccessConditions('RELATED_2_SG_MY', $companyCode)):
                            $shipperName = $partyNames['Customer'] ?? "";
                        endif;
                    endif;
                    ?>
                    <td class="td-class table-border"><?= $shipperName ?></td>
                    <td class="td-class table-border"><?= $transportMode ?? '' ?></td>
                    <td class="td-class table-border"><?= $orderData['service'] ?? '' ?></td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th class="table-border"><?= $this->lang->line('vehicle') . " " . $this->lang->line('number') ?></th>
                    <?php if(!checkAccessConditions('DENIED_CARRIERNAMES_BY_COUNTRY_FOR_DR', $companyCode)): ?>
                    <th class="table-border"><?= $this->lang->line('carrier_name') ?></th>
                    <?php endif; ?>
                    <th class="table-border"><?= $this->lang->line('vehicle') . "/" . $this->lang->line('container_type') ?></th>
                </tr>
                <tr>
                    <td class="td-class table-border"><?= $vehicleData['register_number'] ?? ''; ?></td>
                    <?php if(!checkAccessConditions('DENIED_CARRIERNAMES_BY_COUNTRY_FOR_DR', $companyCode)): ?>
                    <?php if ($showCarrier ?? false) :?>
                        <td class="td-class table-border"><?= $partyNames['carrier'] ?? '' ?></td>
                    <?php  else :  ?>
                        <td class="td-class table-border"></td>
                    <?php endif;  endif; ?>
                    <td class="td-class table-border"><?= $vehicleData['trucktype'] ?? ''; ?></td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th class="table-border" style="width: 50%"><?= $this->lang->line('from') ?> </th>
                    <th class="table-border" style="width: 50%"><?= $this->lang->line('to') ?></th>
                </tr>
                <tr>
                    <td class="td-class table-border"><?= $shipperAddress ?? '' ?></td>
                    <td class="td-class table-border"><?= $consigneeAddress ?? '' ?></td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th class="table-border" style="width: 100%"><?= $this->lang->line('reference_info') ?> </th>
                </tr>
                <tr>
                    <td class="td-class table-border"><?= $orderData['order_references'] ?? '-/-' ?></td>
                </tr>
            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th style="width: 10%" class="table-border"><?= $this->lang->line('status_code') ?></th>
                    <th style="width: 38%" class="table-border"><?= $this->lang->line('event_description') ?></th>
                    <th style="width: 14%" class="table-border"><?= $this->lang->line('date') . " & " . $this->lang->line('gen_time') ?></th>
                    <th style="width: 38%" class="table-border"><?= $this->lang->line('general_location') ?></th>
                </tr>
                <?php
                foreach (($statuses ?? []) as $status) : ?>
                    <tr>
                        <td class="td-class table-border"><?= $status['status_code'] ?></td>
                        <td class="td-class table-border"><?= $status['status_name'] ?></td>
                        <td class="td-class table-border"><?= date("d M Y H:i", strtotime($status['date'])) ?></td>
                        <td class="td-class table-border"><?= $status['location'] ?></td>
                    </tr>
                <?php
                endforeach; ?>
            </table>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <table style="width: 100%" class="table-border">
                <tr>
                    <th class="table-border"><?= $this->lang->line('sno') ?></th>
                    <th class="table-border"><?= $this->lang->line('item') . " " . $this->lang->line('general_description') ?></th>
                    <th class="table-border"><?= $this->lang->line('general_quantity') ?></th>
                    <th class="table-border"><?= $this->lang->line('actual_weight') ?></th>
                    <th class="table-border"><?= $this->lang->line('actual_volume') ?></th>
                </tr>
                <?php
                $i = 1;
                foreach (($cargoDetails ?? []) as $eachCargoRow) : ?>
                    <tr>
                        <td class="td-class table-border"><?= $i ?></td>
                        <td class="td-class table-border"><?= $eachCargoRow['goods_description'] ?></td>
                        <td class="td-class table-border"><?= $eachCargoRow['quantity'] ?></td>
                        <td class="td-class table-border"><?= $eachCargoRow['weight'] . " " . $eachCargoRow['weight_unit'] ?></td>
                        <td class="td-class table-border"><?= $eachCargoRow['volume'] . " " . $eachCargoRow['volume_unit'] ?></td>
                    </tr>
                    <?php
                    $i++;endforeach; ?>
            </table>
        </div>
    </div>
    <?php $otherDocumentsAvailable = false;
    if (!empty($epods ?? null)) : ?>
        <?php  foreach  (($epods ?? []) as $row) :
            if ($row->type_name != "Signature") :
                $otherDocumentsAvailable = true;
            endif;
            if ($row->type_name == "Signature") :?>
                <?php $checkSignature = true;?>
            <?php  endif; endforeach;
        if (($checkSignature ?? false)) :?>
            <div class="row">
                <div class="col-md-12">
                    <table style="width: 100%" class="table-border">
                        <tr>
                            <th class="table-border"><?= $this->lang->line('general_receiver') ?></th>
                            <th class="table-border"><?= $this->lang->line('received_on') ?></th>
                            <th class="table-border"><?= $this->lang->line('signature') ?></th>
                        </tr>
                        <?php foreach  (($epods ?? []) as $row) : if ($row->type_name == "Signature" && validatePictures($row->imgpath)) :?>
                            <tr>
                                <td class="td-class table-border"><?= ($row->receiver_name ?? $partyNames['consignee']) ?? '' ?></td>
                                <td class="td-class table-border"><?= date("d M Y H:i", strtotime(getdatetimebytimezone($timeZone, $row->createdon, 'UTC')['datetime'])) ?></td>
                                <td class="td-class table-border"> <?= epod_as_html_to_pdf($row, "height: 60px;width: 140px") ?></td>
                            </tr>
                        <?php  endif; endforeach; ?>
                    </table>
                </div>
            </div>
        <?php endif;  endif; ?>
    <?php

    if (!empty($epods ?? null) && $otherDocumentsAvailable) :

        ?>

        <div style="page-break-before: always;border-collapse: collapse;border-spacing: 0;box-sizing: border-box;margin-left: -15px;margin-right: -15px;">

            <?php
            $style = "height: 800px";
            $colWidth = "width: calc(100% - 16px);";
            foreach (($epods ?? []) as $row) :
                if ($row->type_name != "Signature") :
                    ?>
                    <div class="pod-upload" style="<?php
                    echo $colWidth; ?>">
                        <h4><?= $this->lang->line('documents') ?></h4>
                        <?= epod_as_html_to_pdf($row, $style) ?>
                        <table style="width: 100%">
                            <tr>
                                <th class="base1 text-left"><?= $this->lang->line('general_location') ?></th>
                                <td class="base1"><?php
                                    echo getLocationName($row->latitude, $row->longitude); ?></td>
                            </tr>
                            <tr>
                                <th class="base1 text-left"><?= $this->lang->line('doc_type') ?></th>
                                <td class="base1"><?php
                                    echo $row->type_name; ?></td>
                            </tr>
                            <tr>
                                <th class="base1 text-left"><?= $this->lang->line('uploaded_time') ?></th>
                                <td class="base1"><?= date("d M,y h:i A", strtotime(getdatetimebytimezone($timeZone, $row->createdon, 'UTC')['datetime'])) . ' ' . $timeZone ?>
                            </tr>
                            <tr>
                                <td colspan="2" class="base1">&nbsp;</td>
                            </tr>
                        </table>
                    </div>
                <?php
                endif; endforeach; ?>
        </div>
    <?php
    endif;
    ?>
</section>
</body>
</html>
