<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
    <title>eTN TMS: Demo & Contacts List</title>
    <link rel="shortcut icon" type="image/png" href="/media/images/favicon.png">
    <link href="<?= base_url() ?>/assets/newtheme/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="http://www.datatables.net/rss.xml">
    <script type="text/javascript" src="<?php echo base_url();?>assets/newtheme/plugins/datatables/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.flash.min.js" integrity="<?=SHA_BUTTONS_FLASH_MIN_JS?>" crossorigin="anonymous"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/jszip.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/pdfmake/pdfmake.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/pdfmake/vfs_fonts.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/cdn_files/buttons.html5.min.js"></script>
    <script src="<?php echo base_url();?>assets/cdn_files/buttons.print.min.js" ></script><link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/newtheme/plugins/datatables/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/newtheme/plugins/datatables/buttons.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo base_url();?>assets/newtheme/plugins/datatables/jquery.dataTables.min.css">
    <style type="text/css">
        table.dataTable tbody td {
            word-break: break-word;
            vertical-align: top;
        }
    </style>
</head>
<body align="center">
<div class="col-md-12">
    <h2>eTN TMS: Demo & Contacts List</h2>
    <!-- Table -->
    <table id='contactlist' class="dataTable" style="width:98%">
        <thead>
        <tr>
            <th>ID</th>
            <th>Customer name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Company</th>
            <th>Job title</th>
            <th>Industry</th>
            <th>Country</th>
            <th>Registration number</th>
            <th>Message</th>
            <th>Subscribe</th>
            <th>Type</th>
            <th>Created</th>
            <th>Updated</th>
        </tr>
        </thead>
        <tbody>
        <?php
        foreach ($contacts as $li): ?>
            <tr>
                <td><?= $li['id'] ?></td>
                <td><?= $li['first_name'] . ' ' . $li['last_name'] ?></td>
                <td><?= $li['email'] ?></td>
                <td><?= $li['phone'] ?></td>
                <td><?= $li['company'] ?></td>
                <td><?= $li['job_title'] ?></td>
                <td><?= $li['industry'] ?></td>
                <td><?= $li['country'] ?></td>
                <td><?= $li['registration_number'] ?></td>
                <td><?= $li['message'] ?></td>
                <td><?= $li['subscribe'] ?></td>
                <td><?= $li['type'] ?></td>
                <td><?= date('d-m-Y H:i A', strtotime($li['created_on'])) ?></td>
                <td><?= date('d-m-Y H:i A', strtotime($li['updated_on'])) ?></td>
            </tr>
        <?php
        endforeach; ?>
        </tbody>
    </table>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#contactlist').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ],
            select: true,
            order: [[0, "desc"]]
        });
    });
</script>
</body>
</html>
