<!DOCTYPE html>
<html lang="en">
<?php
$this->load->view( 'driverappv2/header' );
?>
<head>
    <link rel="icon" type="image/gif" href="<?= base_url() ?>assets/driverapp/images/logo_sm.ico">
    <style>
        .loading_rocx {
            width: 100%;
            position: absolute;
            z-index: 9999 !important;
            height: 100%;
            object-fit: contain;
            background-color: transparent !important;
            opacity: 0.9;
        }

        .loaderx {
            position: absolute;
            border: 4px solid #003369;
            border-radius: 50%;
            border-top: 4px solid #ffffff;
            width: 40px;
            height: 40px;
            -webkit-animation: spin 1s linear infinite;
            animation: spin 1s linear infinite;
            margin: auto;
            top: 40%;
            z-index: 10;
            right: 44%;
            text-align: center;
        }

        /* Safari */
        @-webkit-keyframes spin {
            0% {
                -webkit-transform: rotate(0deg);
            }
            100% {
                -webkit-transform: rotate(360deg);
            }
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }
        .loader {
            width: 100%;
            height: 100%;
            background-color: #fff;
            z-index: 9999;
            opacity: .8;
            position: fixed;
        }
        .container-fluid {
            overflow: hidden; /* Add the ability to scroll */
            -moz-overflow: hidden; /* Add the ability to scroll */
        }

        /* Hide scrollbar for Chrome, Safari and Opera */
        .container-fluid::-webkit-scrollbar {
            display: none;
        }

        /* Hide scrollbar for IE, Edge and Firefox */
        .container-fluid {
            -ms-overflow-style: none; /* IE and Edge */
            scrollbar-width: none; /* Firefox */
        }
    </style>

</head>
<body>

<div id="preloader" class="loader loading_roc" style="display: none;">
    <div id="preloaderx" class="loaderx loading_rocx"></div>
</div>
<div id="body_div" style="display: none">
	<?php
	if ( strlen( $body_content ) > 3 ) {
		$this->load->view( $body_content );
	}
	?>
</div>
<?php
$this->load->view( "driverappv2/footer" );
?>
</body>
<script>
    window.onbeforeunload = function () {
        document.getElementById('preloader').style.display = "inline-block";
    };
    document.onreadystatechange = function () {
        var state = document.readyState;
        if (state == 'interactive') {
            document.getElementById('preloader').style.display="block";
        } else if (state == 'complete') {
           setTimeout(function () {
                console.log('called none');
                document.getElementById('interactive');
                document.getElementById('preloader').style.display = "none";
            }, 1);
        }
    };
    getsecureview();
    function getsecureview() {
        document.getElementById('preloader').style.display = "inline-block";
        var json_as_str = "token=" + '<?= $token ?>';
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                var res = JSON.parse(this.responseText);
                var status = res.status;
                if (status == "1") {
                    var response = res.response;
                    var url = response.url;
                    document.getElementById('preloader').style.display = "inline-block";
                    console.log(url);
                    render_secure_view(url);
                } else {
                    if (status == '2') {
                        var message = res.message;
                        set_message(message);
                    } else {
                        set_message('Please Provide valid secure link');
                    }
                }
            }
        };
        xhttp.open("POST", "<?= base_url( 'Driverappv2/get_secure_view' ) ?>");
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send(json_as_str);
    }

    function render_secure_viewk(url) {
        document.getElementById('preloader').style.display = "inline-block";
        var xhttp = new XMLHttpRequest();
        xhttp.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                if ((this.responseText).trim() == "") {
                    document.getElementById('preloader').style.display = 'none';
                    set_message('We are getting empty response.', 'Reload');
                } else {
                    document.getElementById('body_div').innerHTML = this.responseText;
                    // $('#body_div').html( this.responseText);
                    document.getElementById('body_div').style.display = 'block';
                    // $('#body_div').show();
                    document.getElementById('preloader').style.display = 'none';
                    // $('#preloader').hide();
                    // $('#body_div').show();
                }
            }
        };
        xhttp.open("GET", url);
        xhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        xhttp.send();
    }

   async function render_secure_view(url) {
       document.getElementById('preloader').style.display = "inline-block";
       let myPromise = new Promise(function(myResolve, myReject) {
           let req = new XMLHttpRequest();
           req.open('GET', url);
           req.onload = function() {
               if (req.readyState == 4 &&  req.status == 200) {
                   if ((req.response).trim() == "") {
                       set_message('Please Refresh again connect to Server', 'Reload');
                   } else {
                       myResolve(req.response);
                   }
               } else {
                   myResolve("Something went wrong");
               }
           };
           req.send();
       });
       document.getElementById('body_div').style.display = 'block';
       document.getElementById("body_div").innerHTML = await myPromise;
       setTimeout(function () {
           setStops();
       },10);
       document.getElementById('preloader').style.display = 'none';
   }
</script>
</html>