<body onload="initialize()">
<div id="map_canvas" style="width:100%; height:85vh">
</div>
</body>

<script type="text/javascript">

var map;
var path;
<?php 
$a=$b=$c=$d=$from=$to="";
if($trip!=""){
	if($trip->num_rows()>0){
		$from=$trip->row()->act_splace;
		$to=$trip->row()->act_eplace;
	}
}

if($latlngs!=""){
	$j=$latlngs->num_rows();
	if($j>0){
?>
var route = [
<?php
		$n=1;
		foreach($latlngs->result() as $row){
?>
new google.maps.LatLng(<?php echo $row->latitude;?>,<?php echo $row->longitude;?>)
<?php
			if($n==1){
				$a=$row->latitude;
				$b=$row->longitude;
			}
			if($n==$j){
				$c=$row->latitude;
				$d=$row->longitude;
			}
			if($n==1&&$n<$j){
				echo ",";
			}
			
		}
?>
];
<?php		
	}
}
if($a!=""&&$b!=""&&$c!=""&&$d!=""){
?>

var brisbane = new google.maps.LatLng(<?php echo $a;?>, <?php echo $b;?>);
var dalby = new google.maps.LatLng(<?php echo $c;?>, <?php echo $d;?>);
<?php
}
?>
var $mapDiv = $('#map_canvas');
// switch placed around console.logging
var debug = false;

var mapDim = {
    height: $mapDiv.height(),
    width: $mapDiv.width()
}
<?php
if($from!=""&&$to!=""){
?>
var brisbaneMarker = new google.maps.Marker({
    position: brisbane,
    title: '<?php echo $from;?>',
    animation: google.maps.Animation.DROP
});

var dalbyMarker = new google.maps.Marker({
    position: dalby,
    title: '<?php echo $to;?>',
    animation: google.maps.Animation.DROP
});
var lineinfowindow = new google.maps.InfoWindow({
    content: '<?php echo $from." to ".$to;?>'
});
<?php
}
?>

var markers = [brisbaneMarker, dalbyMarker];

// we possibly have these bounds in the dataset?
var bounds = (markers.length > 0) ? createBoundsForMarkers(markers) : null;

var infowindow = new google.maps.InfoWindow({
    content: '<div>Title here</div>'
});

function initialize() {
    map = new google.maps.Map(document.getElementById("map_canvas"), {
        zoom: (bounds) ? getBoundsZoomLevel(bounds, mapDim) : 0,
        center: (bounds) ? bounds.getCenter() : new google.maps.LatLng(0, 0),
        mapTypeId: google.maps.MapTypeId.ROADMAP
    });

    // i'd suggest creating multiple polylines for each set of  directions.  so A to B, B to C just for the event binding.  also this allows for the change of strokeColor as required in spec
    path = new google.maps.Polyline({
        path: route,
        strokeColor: "#FF0000",
        strokeOpacity: 1.0,
        strokeWeight: 5,
        geodesic: true
    });

    // set the map for the predefined markers
    brisbaneMarker.setMap(map);
    dalbyMarker.setMap(map);

    // set map
    path.setMap(map);

    google.maps.event.addListener(dalbyMarker, 'mouseover', function (e) {
        if (debug) {
            console.log('[dalbyMarker:mouseover]: ', e);
        }
        var $this = $(this);
        infowindow.setContent($this[0].title);
        infowindow.open(map, dalbyMarker);
    });
    google.maps.event.addListener(brisbaneMarker, 'mouseover', function (e) {
        if (debug) {
            console.log('[brisbaneMarker:mouseover]: ', e);
        }
        var $this = $(this);
        infowindow.setContent($this[0].title);
        infowindow.open(map, brisbaneMarker);
    });

    google.maps.event.addListener(dalbyMarker, 'mouseout', function (e) {
        if (debug) {
            console.log('[dalbyMarker:mouseout]: ', e);
        }
        infowindow.close();
    });
    google.maps.event.addListener(brisbaneMarker, 'mouseout', function (e) {
        if (debug) {
            console.log('[brisbaneMarker:mouseout]: ', e);
        }
        infowindow.close();
    });
    // polyline events
    google.maps.event.addListener(path, 'mouseover', function (e) {
        if (debug) {
            console.log('[path:mouseover]: ', e);
        }
        path.setOptions({
            strokeOpacity: 0.5
        });
        lineinfowindow.setPosition(e.latLng);
        lineinfowindow.open(map);
    });
    google.maps.event.addListener(path, 'mouseout', function (e) {
        path.setOptions({
            strokeOpacity: 1
        });
        // for some reason this is crap
        //lineinfowindow.close();
    });
}

function createMarkerForPoint(point) {
    return new google.maps.Marker({
        position: new google.maps.LatLng(point.lat, point.lng)
    });
}

function createBoundsForMarkers(markers) {
    var bounds = new google.maps.LatLngBounds();
    $.each(markers, function () {
        bounds.extend(this.getPosition());
    });
    return bounds;
}

function getBoundsZoomLevel(bounds, mapDim) {
    var WORLD_DIM = {
        height: 256,
        width: 256
    };
    var ZOOM_MAX = 21;

    function latRad(lat) {
        var sin = Math.sin(lat * Math.PI / 180);
        var radX2 = Math.log((1 + sin) / (1 - sin)) / 2;
        return Math.max(Math.min(radX2, Math.PI), -Math.PI) / 2;
    }

    function zoom(mapPx, worldPx, fraction) {
        return Math.floor(Math.log(mapPx / worldPx / fraction) / Math.LN2);
    }

    var ne = bounds.getNorthEast();
    var sw = bounds.getSouthWest();

    var latFraction = (latRad(ne.lat()) - latRad(sw.lat())) / Math.PI;

    var lngDiff = ne.lng() - sw.lng();
    var lngFraction = ((lngDiff < 0) ? (lngDiff + 360) : lngDiff) / 360;

    var latZoom = zoom(mapDim.height, WORLD_DIM.height, latFraction);
    var lngZoom = zoom(mapDim.width, WORLD_DIM.width, lngFraction);

    return Math.min(latZoom, lngZoom, ZOOM_MAX);
}
google.maps.event.addDomListener(window, 'load', initialize);
</script>
