<?php

use App\Libraries\OrderCreationSourceHelper;

$this->load->library('AtsService');
$atsservice = new AtsService();
$this->load->view($atsservice->get_ats_service());
$this->load->helper('required_marker');
$postData = $postData ?? [];
$rateServiceRowIdForBook = $postData['rateServiceRowIdForBook'] ?? 0;
//$pickup_details = [];

//echo "<pre>";print_r($_SESSION);exit;

if (!empty($postData)):
    $customerFromProfile = $postData['customerIdForBook'] ?? 0;
    $vendorFromProfile = $postData['vendorIdForBook'] ?? 0;
    if ($customerFromProfile > 0):
        $pickup_details['name'] = $postData['customerNameForBook'] ?? "";
        $pickup_details['party_id'] = $postData['customerCodeForBook'] ?? "";
        $customerCity = $postData['customerCityForBook'] ?? "";
        $customerState = $postData['customerStateForBook'] ?? "";
        $customerStreet = $postData['customerStreetForBook'] ?? "";
        $pickup_details['address'] = $customerStreet . "," . $customerCity . "," . $customerState;
        $pickup_details['country'] = $postData['customerCountryForBook'] ?? "";
        $pickup_details['pincode'] = $postData['customerPincodeForBook'] ?? "";
        $customerIdFromProfile = $postData['customerIdForBook'] ?? 0;
    endif;
    if ($vendorFromProfile > 0):
        $vendorIdFromProfile = $postData['vendorIdForBook'] ?? 0;
        $vendorCodeFromProfile = $postData['vendorCodeForBook'] ?? "";
    endif;
endif;

?>

<?php
if ($this->session->userdata('company_code') == 'NZKN') { ?>
<style>
.modal {
    z-index: 1001 !important;
}

.modal-backdrop {
    z-index: 1000 !important;
}

.pac-container {
    z-index: 1055 !important;
    width: auto !important;
}

.pac-container:after {
    /* Disclaimer: not needed to show 'powered by Google' if also a Google Map is shown */

    background-image: none !important;
    height: 0px;
}

.modal-open .modal.insert_success_div#insert_success_div {
    z-index: 9999 !important;
}
</style>

<?php } ?>

<link href="<?= base_url(); ?>assets/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css" />

<link href="<?= base_url(); ?>assets/newtheme/css/orders-style.css" rel="stylesheet" type="text/css" />
<?php if($this->session->userdata('company_code') == 'CNKN') { ?>
<style>
div.dataTables_wrapper div.dataTables_info {
    padding-top: 8px;
    margin-right: 85px !important;
    white-space: nowrap
}

.paginate_button.next {
    display: none !important;
}

.paginate_button {
    margin-right: 7px !important;
}

#wrapper {
    overflow: visible !important;
}

.paginate_button.previous {
    display: none !important;
}
</style>
<?php } else { ?>
<style>
div.dataTables_wrapper div.dataTables_info {
    padding-top: 8px;
    white-space: nowrap
}

.paginate_button.next {
    display: inline-block !important;
}

.paginate_button.previous {
    display: inline-block !important;
}

</style>
<?php } ?>

<style>
    #wrapper {
        overflow: visible !important;
    }

    .dataTables_wrapper {
        position: relative;
    }

    .tabsModalView .table td button {
        width: 30px;
    }

    #editing .measurement .input-group .form-control {
        margin-top: 14px;
    }
    
    .dataTables_wrapper {
        overflow-x: scroll;
    }

    .button_css {
        display: flex;
    }
</style>
<link href="<?= base_url() ?>assets/newtheme/css/appdev-style.css" rel="stylesheet" type="text/css" />

<?php 
    $custid = $this->session->userdata('user_id');
    $branch_code = $this->session->userdata('branch_code');
    log_message("error","CustId:".$cust_id);
    $products = getProductMasterData($cust_id, $company_code, $branch_code);
    $incoterm = getIncotermMasterData($cust_id, $company_code, $branch_code);
    $service  = getServiceMasterData($cust_id, $company_code, $branch_code);
    $departments = getDepartmentMasterData($cust_id, $company_code, $branch_code);
    $order_types = getOrderTypes($cust_id, $company_code, $branch_code);
    $transport = gettransportmode($company_code, $branch_code);
    $referencemaster = getReferenceMasterData($cust_id, $company_code, $branch_code);
   // echo "<pre>";print_r($transport);exit;
?>


<div class="content-page">
    <!-- Start content -->
    <div class="content">

        <div class="container">






            <!-------Advanced Search-------->
            <div class="sidebars sideBarStyle" id="sidebars_search" style="display:none">
                <div class="advance_searchcol sidebar right" id="sidebar_search">
                    <div class="title_header">
                        <h2><span class="iconSvk icon-filter-icon"></span> Filter</h2>
                        <a href="javascript:void(0)" class="closebtn" data-action="close" data-side="right">&times;</a>
                    </div>
                    <form method="GET" id="advsearch_orders">

                        <div class='row'>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Booking ID </label>
                                    <input type="text" placeholder="" class="form-control" value="">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Pickup</label>
                                    <input type="text" placeholder="" class="form-control" value="">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Delivery</label>
                                    <input type="text" placeholder="" class="form-control" value="">
                                </div>
                            </div>
                        </div>

                        <div class="footer-search">
                            <div class="top20 ">
                                <div class="view_more text-right">
                                    <button type="Reset" form="advsearch_orders" name="reset"
                                        class="btn btnCancel mr-2  resetbtn"><?= $this->lang->line('general_reset'); ?></button>
                                    <button type="submit" name="searchsubmit" class="btn btn_color"
                                        value="Search"><?= $this->lang->line('search_orders') ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-------Advanced Search- End------->
        </div>

        <!----Middle Block- Start-->
        <?php /* if ($this->session->userdata('company_code') == 'INKN') {
                                    $submit = 'onsubmit="return saveorderNew(0);"';
                                 
                                } else {
                                    $submit = 'onsubmit="return saveorderNew(1);"';
                                    
                            }*/
                            $submit = 'onsubmit="return validateCustomerOrder();"';
                            $submitFunction = "insertorder";
                            if(!empty($order_details['id']) && $copy_order == 0){
                                $submitFunction = "updateorder";
                            }                            
                            ?>
      
     




        <div class="mt-35 mb-10">
       
            <div class="container etnCustomarAdd tabsModalView customerScreen" id="editOrderModal">


            <form method="POST" action="<?php echo base_url(); ?>KNCustorders/<?= $submitFunction ?>"
                                    <?php echo $submit; ?> id="order_form" novalidate>


                                    <div class="col-sm-6 pull-right ">
                                        <div class="view_moretab text-right">
                                            <span class="creditlimit_exceededbtn"
                                                style="display:none;background-color:#ff0018; border-radius: 45%;padding: 6px;color:black;font-size: 12px; "><b>Credit
                                                    block exceeded</b></span>

                                                    <button type="reset" name="reset" class="btn btnCancel"><a style="color: white;" href="<?php echo base_url(); ?>svkCustomer/CustomerOrders/"><?php echo $this->lang->line('general_cancel'); ?></a></button>
                                               
                                                <button type="submit" name="submit" class="btn btn-default btn_color submitorderdetails">
                                                <?php echo (isset($order_details) ? ($order_details['id'] && $copy_order == 0 ? $this->lang->line('general_update') 
                                                    : $this->lang->line('general_save')) : $this->lang->line('general_save')) ?>
                                                </button>
                                        </div>
                                    </div>
        </form>


                <input form="order_form" type="hidden" name="copy_cargo_remove" id="copy_cargo_remove" value="">
               
                <input form="order_form" type="hidden" name="order_id" id="order_id" value="<?php if (isset($order_details['id'])) {
                                                                                                                                                 echo $order_details['id'];
                                                                                                                                                }?>">
                                                                    <input type="hidden" name="order_inv_id" id="order_inv_id" value="">

                                                                    <input form="order_form" name="company_code"
                                                                id="company_code" type="hidden" class="form-control"
                                                                aria-label="..."
                                                                value="<?php if (isset($order_details['company_code'])) { echo $order_details['company_code'];}?>"
                                                                readonly>

                                                                    <input form="order_form" type="hidden" name="order_pickup_id" id="order_pickup_id" value="<?php if (isset($pickup_details['id'])) {
                                                                                                                                                                  echo $pickup_details['id'];
                                                                                                                                                              }?>">
                                                                    <input form="order_form" type="hidden" name="order_drop_id" id="order_drop_id" value="<?php if (isset($drop_details['id'])) {
                                                                                                                                                              echo $drop_details['id'];
                                                                                                                                                          }?>">
                                                                    <input form="involved_parties" type="hidden" name="involved_party_id" id="involved_party_id" value="">
                                                                    <input type="hidden" name="party_row_id" id="party_row_id" value="">
                                                                    <input form="order_form" type="hidden" name="order_party_row_id" id="order_party_row_id" value="">
                                                                    <input form="order_form" type="hidden" name="order_inv_row_id" id="order_inv_row_id" value="">
                                                                    <input form="order_form" type="hidden" name="reference_ids" id="reference_ids" value="">
                                                                    <input form="order_form" type="hidden" name="order_shipper_id" id="order_shipper_id" value="<?php if (isset($shipper_details['id'])) {
                                                                                                                                                                    echo $shipper_details['id'];
                                                                                                                                                                }?>">
                                                                    <input type="hidden" name="order_cargo_id" id="order_cargo_id" form="order_form" value="<?php echo $order_details['cargo_id'] ?? ''; ?>">
                                                                    <input type="hidden" name="cargo_row_id" id="cargo_row_id" form="order_form" value="">
                                                                    <input form="order_form" type="hidden" name="booking_id" parsley-trigger="change" id="booking_id" required placeholder="" class="form-control" value="<?php if (isset($order_details['order_id'])) {
                                                                                                                                                                                                                        echo $order_details['order_id'];
                                                                                                                                                                                                                        }?>" disabled>
                                                                                                                                                                                                                         
                
                <div class="clearfix">&nbsp;</div>
                <input form="order_form" type="hidden" name="attachment_ids" id="attachment_ids" value="">
                <input type="hidden" name="rev_row_id" id="rev_row_id" form="order_form" value="">
                <input type="hidden" name="ordcost_row_id" id="ordcost_row_id" form="order_form" value="">

                <div class="row newcustOrderCard">
                    <div class="col-md-4">
                        <div class="cardCol">
                            <div class="addressPickup">
                                <h4><?= $this->lang->line('customer'); ?> <span>*</span></h4>
                                             
                                <div class="input-group inputIconGroup">
                                    <input form="order_form" type="text" class="form-control" aria-label="..."
                                        id="customer_id" name="customer_id"
                                        value="<?php echo $pickup_details['party_id'] ?? '' ?>" readonly>
                                    <div class="input-group-addon">
                                        <button type="button" class="ionBt" id="searchcustomerlist"
                                            onclick="searchcustomerlist(event)"><span
                                                class="icon-search"></span></button>
                                        <button type="button" class="ionBt" id="viewcustomerlistNew"
                                            onclick="viewcustomerlistNew(event)"><span
                                                class="icon-listfile"></span></button>
                                    </div>
                                </div>
                               
                                <span id="customerAddressSpan">    
                                    <?php if (!empty($pickup_details)) { ?>
                                        <h5><?= $pickup_details['name'] ?></h5>
                                        <p>
                                            <?= implode(', ', array_filter([
                                                $pickup_details['address'] ?? '',
                                                $pickup_details['country'] ?? '',
                                                $pickup_details['pincode'] ?? ''
                                            ])) ?>
                                        </p>
                                    <?php } ?>
                                </span>
                                
                            </div>

                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="cardCol">
                            <div class="addressPickup">
                                <h4><?= $this->lang->line('pickup'); ?><span>*</span></h4>
                                <div class="input-group inputIconGroup">
                                    <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);"
                                        form="shipper_form" type="text" name="shipper_id" id="shipper_id"
                                        class="form-control" aria-label="..."
                                        value="<?php if (isset($shipper_details['party_id'])) {
                                                                                                                                                                                                                                                                       echo $shipper_details['party_id'];
                                                                                                                                                                                                                                                                   }?>">
                                    <div class="input-group-addon">
                                        <button type="button" class="ionBt" id="searchpartyconsigneelist"
                                            onclick="searchpartyconsigneelistNew(event,'shipper')"><span
                                                class="iconSvk icon-search"></span></button>
                                        <button type="button" class="ionBt" id="viewpartylistNew"
                                            onclick="viewpartylistNew(event,'shipper')"><span
                                                class="iconSvk icon-listfile"></span></button>
                                    </div>                                   
                                </div>
                                
                                <div id="shipperDetailsSpan">
                                    <?php if (!empty($shipper_details)) {  ?>
                                        <h5><?= $shipper_details['name'] ?></h5>
                                        <p>
                                            <?=
                                            implode(',', array_filter([
                                                $shipper_details['street'] ?? '',
                                                $shipper_details['city'] ?? '',
                                                $shipper_details['state'] ?? '',
                                                $shipper_details['country'] ?? '',
                                                $shipper_details['pincode'] ?? ''
                                            ]))
                                            ?>
                                        </p>
                                    <?php } ?>
                                </div>
                               

                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-md-12">
                                        <div class="calIcon">
                                        <input
                                                                <?php if ($this->session->userdata('company_code') != 'THKN') {?>
                                                                onkeypress="return isNonSpecialCharCheck(event);"
                                                                <?php }?> form="order_form" type="text"
                                                                name="early_pickup" id="early_pickup" autocomplete="off"
                                                                class="form-control <?php if ($this->session->userdata('company_code') != 'THKN') {echo "datetimepicker";}?>"
                                                                placeholder="<?php if ($this->session->userdata('company_code') == 'THKN') {echo "YYYY-MM-DD HH:MM:SS";}?>"
                                                                value="<?php if (isset($order_details['early_pickup'])) {
                                                                        if ($order_details['early_pickup'] != '0000-00-00 00:00:00') {
                                                                            echo $order_details['early_pickup'];
                                                                    }
                                                                }?>">
                                        <span class="calc"><i class="fa fa-calendar-o"
                                                                    aria-hidden="true"></i></span>
                                                        </div>
                                        </div>                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="cardCol">
                            <div class="addressPickup">
                                <h4><?= $this->lang->line('delivery'); ?><span>*</span></h4>
                                <div class="input-group inputIconGroup">
                                    <input onkeypress="return isNonSpecialCharCheck(event);" form="consignee_form"
                                        name="consignee_id" id="consignee_id" type="text" class="form-control"
                                        aria-label="..."
                                        value="<?php if (isset($drop_details['party_id'])) {
                                                                                                                                                                                                                                                      echo $drop_details['party_id'];
                                                                                                                                                                                                                                                  }?>">
                                    <div class="input-group-addon">
                                        <button type="button" class="ionBt" id="searchviewcompany"
                                            onclick="searchpartyconsigneelistNew(event,'consignee')"><span
                                                class="iconSvk icon-search"></span></button>
                                        <button type="button" class="ionBt" id="viewcompanylist"
                                            onclick="viewpartylistNew(event,'consignee')"><span
                                                class="iconSvk icon-listfile"></span></button>
                                    </div>
                                </div>
                                
                                <div id="dropDetailsSpan">
                                    <?php if (!empty($drop_details)) {  ?>
                                        <h5><?= $drop_details['name'] ?></h5>
                                        <p>
                                            <?=
                                            implode(',', array_filter([
                                                $drop_details['street'] ?? '',
                                                $drop_details['city'] ?? '',
                                                $drop_details['state'] ?? '',
                                                $drop_details['country'] ?? '',
                                                $drop_details['pincode'] ?? ''
                                            ]))
                                            ?>
                                        </p>
                                    <?php } ?>
                                </div>
                               

                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-md-12">
                                        <div class="calIcon">
                                        <input
                                            <?php if ($this->session->userdata('company_code') != 'THKN') {?>
                                            onkeypress="return isNonSpecialCharCheck(event);"
                                            <?php }?> form="order_form" type="text"
                                            class="<?php if ($this->session->userdata('company_code') != 'THKN') {echo "datetimepicker";}?> form-control"
                                            placeholder="<?php if ($this->session->userdata('company_code') == 'THKN') {echo "YYYY-MM-DD HH:MM:SS";}?>"
                                            id="early_delivery" autocomplete="off" name="early_delivery"
                                            value="<?php if (isset($order_details['early_delivery'])) {
                                                    if ($order_details['early_delivery'] != '0000-00-00 00:00:00') {
                                                        echo $order_details['early_delivery'];
                                                }
                                            }?>">
                                             <span class="calc"><i class="fa fa-calendar-o"
                                                                    aria-hidden="true"></i></span>
                                                        </div>
                                        </div>

                                       
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row mt-25">
                    <div class="col-sm-12">
                        <div class="cardCol">
                            <h3><?= $this->lang->line('terms_of_trade'); ?> <span><!--*--></span></h3>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('order_type'); ?> <span><!--*--></span></label>
                                        <select form="order_form" class="form-control" id="order_type" name="order_type">
                                                                        <option value="">Select</option>
                                                                        <?php if (! empty($order_types)) {
                                                                            foreach ($order_types as $res) {?>
                                                                                <option <?php if (isset($order_details['order_type'])) {
                                    if ($order_details['order_type'] == $res['type_id']) {
                                        echo "selected";
                                }
                                }?> value="<?php echo $res['type_id']; ?>"><?php echo $res['type_name']; ?></option>
                                                                                    <?php }
                                                                            }?>
                                                                    </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('mode_of_transport'); ?><span><!--*--></span></label>
                                        <select form="order_form" class="form-control" name="modeof_trasnport" id="modeof_trasnport">
                                                                        <option value="">Select</option>
                                                                        <?php if (! empty($transport)) {
                                                                                foreach ($transport as $mode) {
                                                                              ?>
                                                                                    <option <?php if ($order_details['transport_mode'] == $mode['code']) {
                                        echo "selected";
                                    }?> value="<?php echo $mode['code']; ?>"><?php echo $mode['name']; ?></option>
                                                                                <?php }
                                                                                      
                                                                                }?>
                                                                    </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('bpartner_product'); ?> <span><!--*--></span></label>
                                        <select form="order_form" name="product" id="product" class="form-control">
                                                                        <option value="">Select</option>
                                                                        <?php if (! empty($products)) {
                                                                                foreach ($products as $res) {
                                                                                ?>
                                                                                <option <?php if (isset($order_details['product'])) {
                                if (strtoupper($order_details['product']) == strtoupper($res['name'])) {
                                    echo "selected";
                            }
                                }?> value="<?php echo $res['name']; ?>"><?php echo $res['name']; ?></option>
                                                                            <?php }
                                                                            }?>
                                                                    </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""> <?= $this->lang->line('bpartner_service'); ?> <span><!--*--></span></label>
                                        <select form="order_form" name="service" id="service" class="form-control">
                                            <option value="">Select</option>
                                            <<?php if (! empty($service)) {
                                                                                                                                    foreach ($service as $res) {
                                                                                                                                    ?>
                                                <option <?php if (isset($order_details['service'])) {
                                                                  if ($order_details['service'] == $res['row_id']) {
                                                                     echo "selected";
                                                               }
                                                         }?> value="<?php echo $res['row_id']; ?>">
                                                <?php echo $res['id'] . "-" . $res['name']; ?></option>
                                                <?php }
                                                                                                                              }?>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('general_department_code'); ?> <span><!--*--></span></label>
                                        <select form="order_form" class="form-control" name="department_code" id="department_code">
                                            <option value="">Select</option>
                                            <?php if(!empty($departments)) {
                                                                                                foreach ($departments as $res) { ?>
                                                       <option <?php if ($order_details['department_code'] == $res) {
                                                                                    echo "selected";
                                                                                }?> value="<?php echo $res; ?>"><?php echo $res; ?></option>
                                                                            <?php }
                                                                            }?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('bpartner_incoterms'); ?> <span><!--*--></span></label>
                                        <select form="order_form" class="form-control" name="incoterm" id="incoterm">
                                            <option value="">Select</option>
                                            <?php if (! empty($incoterm)): ?>
                                            <?php foreach ($incoterm as $name): ?>
                                            <option
                                                <?php echo(isset($order_details['incoterm']) && $order_details['incoterm'] == $name) ? "selected" : ''; ?>
                                                value="<?php echo $name; ?>"><?php echo $name; ?>
                                            </option>
                                            <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for=""><?= $this->lang->line('trade_terms'); ?>  <span><!--*--></span></label>
                                        <select form="order_form" name="delivery_terms" id="delivery_terms"
                                            class="form-control">
                                            <option value="">Select</option>
                                            <?php if (! empty($delivery_array)) {
                                                                                foreach ($delivery_array as $res) {
                                                                                ?>
                                            <option <?php if (isset($order_details['delivery_term'])) {
                            if ($order_details['delivery_term'] == $res['id']) {
                                echo "selected";
                                    }
                                }?> value="<?php echo $res['id']; ?>"><?php echo $res['id'] . " " . $res['name'] . "-" . $res['incoterm']; ?>
                                            </option>
                                            <?php }
                                                                            }?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                
                <div class="row mt-25">
                    <div class="col-sm-12">
                        <div class="cardCol minHeightTerms">
                            <div class="cardTitleBtt">
                                <h3><?= $this->lang->line('cargo_details'); ?> <span><!--*--></span></h3>
                                <button type="button" class="btn addBt" onclick="rowAdd_Old(this);"><span class="iconSvk icon-add-icon"></span></button>
                            </div>
                            <div class="table-responsive">
                                    <table id="cargo_details" class="table">
                                    <thead>
                                        <tr>                                       
                                        <th></th>
                                        <th style="min-width: 140px;"><i
                                                class="icon tru-icon-cargo-type"></i><?php echo $this->lang->line( 'package_type' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-goods"></i><?php echo $this->lang->line( 'qbook_goodsdescription' ); ?>
                                        </th>
                                        <?php if($marks_numbers_column ){ ?>
                                        <th><i
                                                class="icon tru-icon-quantity"></i><?php echo $this->lang->line('marks_numbers'); ?>
                                        </th>
                                        <?php } ?>
                                        <th><i
                                                class="icon tru-icon-quantity"></i><?php echo $this->lang->line( 'general_quantity' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-quantity"></i><?php echo $this->lang->line( 'itemid' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-quantity"></i><?php echo $this->lang->line( 'scanned_quantity' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-length"></i><?php echo $this->lang->line( 'general_length' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-width"></i><?php echo $this->lang->line( 'general_width' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-height"></i><?php echo $this->lang->line( 'general_height' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-weight"></i><?php echo $this->lang->line( 'actual_weight' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-weight"></i><?php echo $this->lang->line( 'general_weight' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-weight"></i><?php echo $this->lang->line( 'volumetric_weight' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-volume"></i><?php echo $this->lang->line( 'actual_volume' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-volume"></i><?php echo $this->lang->line( 'general_volume' ); ?>
                                        </th>
                                        <th><i
                                                class="icon tru-icon-volume"></i><?php echo $this->lang->line( 'ldm' ); ?>
                                        </th>
                                        <th><?php echo $this->lang->line( 'qbook_stackable' ); ?>
                                        </th>
                                        <th><?php echo $this->lang->line( 'grounded' ); ?>
                                        </th>
                                        <th><?php echo $this->lang->line( 'splittable' ); ?>
                                        </th>
                                        <th><?php echo $this->lang->line( 'dg_goods' ); ?>
                                        </th>
                                        </tr>
                                    </thead>

                                    <tbody>                                       

                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>



                </div>
                
                <div class="row mt-25">
                    <div class="col-sm-12">
                        <div class="cardCol minHeightTerms">
                            <div class="cardTitleBtt">
                                <h3><?= $this->lang->line('involved_parties'); ?><span><!--*--></span></h3>
                                <button class="btn addBt" type="button" onclick="rowAddParty(this);"><span
                                        class="iconSvk icon-add-icon"></span></button>
                            </div>
                            <div class="table-responsive">
                                <table class="table" id="involvedParties_details">
                                    <thead>
                                        <tr>
                                            <th style="min-width: 40px;"></th>
                                            <th><i class=" fa fa-user"></i><?php echo $this->lang->line('party_id'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-user"></i><?php echo $this->lang->line('party_name'); ?>
                                            </th>
                                            <th><i class=" fa fa-user"></i><?php echo $this->lang->line('role'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-road"></i><?php echo $this->lang->line('general_street'); ?>
                                            </th>
                                            <th><i
                                                    class="fas fa-city"></i><?php echo $this->lang->line('general_city'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-map-marker"></i><?php echo $this->lang->line('general_state'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-globe"></i><?php echo $this->lang->line('general_country'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-map-marker"></i><?php echo $this->lang->line('zipcode'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-mobile"></i><?php echo $this->lang->line('general_mobile'); ?>
                                            </th>
                                            <th><i class="fa fa-fax"></i><?php echo $this->lang->line('general_fax'); ?>
                                            </th>
                                            <th><i
                                                    class="fa fa-envelope"></i><?php echo $this->lang->line('general_email'); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody id="dynamicPartyData"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                
                

                <div class="row mt-25">
                    
                    <div class="col-sm-4">

                        <div class="cardCol">
                            <h3><?= $this->lang->line('value_added_service'); ?> <span><!--*--></span></h3>
                            <div class="scrollCustom">

                                <?php if(!empty($vas)){
                                    foreach($vas as $eachvas){ ?>

                                <div class="form-group flexBetween">
                                    <div class="checkBoxin">
                                        <label class="checkbox-inline">
                                            <input form="order_form" <?= !empty($eachvas['quantity'])?"checked":"" ?>  type="checkbox" name="valueAddedService[]" id="inlineCheckbox<?= $eachvas['vas_row_id'] ?>" value="<?= $eachvas['vas_row_id'] ?>"> <?= $eachvas['vas_id'] ?>
                                        </label>
                                    </div>

                                    <div class="input-group numInputGroup">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-default btn-number" disabled="disabled"
                                                data-type="minus" data-field="vas_<?= $eachvas['vas_row_id'] ?>">
                                                <span class="glyphicon glyphicon-minus"></span>
                                            </button>
                                        </span>
                                        <input form="order_form"  type="text" name="vas_<?= $eachvas['vas_row_id'] ?>" class="form-control input-number" value="<?= !empty($eachvas['quantity'])?$eachvas['quantity']:0 ?>"
                                            min="1" max="10">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-default btn-number" data-type="plus"
                                                data-field="vas_<?= $eachvas['vas_row_id'] ?>">
                                                <span class="glyphicon glyphicon-plus"></span>
                                            </button>
                                        </span>
                                    </div>
                                </div>


                                    <?php }
                                } ?>
                     
                            </div>

                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="cardCol minHeightTerms" id="references"  >
                            <div class="cardTitleBtt">
                                <h3 onclick="toggleReferenceDetails('reference',<?php echo $order_details['id'] ?>)"><?= $this->lang->line('reference'); ?>  <span><!--*--></span></h3>
                                <button type="button" class="btn addBt" onclick="rowRefAddNew(this)"><span
                                        class="iconSvk icon-add-icon"></span></button>
                            </div>

                            <table class="table" id="reference_table" style="width: 482px;">
                                <thead>
                                    <tr>
                                        <th><?= $this->lang->line('ref_id'); ?> </th>
                                        <th><?= $this->lang->line('ref_name'); ?> </th>
                                        <th><?= $this->lang->line('referencevalue'); ?> </th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                    
                   <div class="col-sm-4">
                        <div class="cardCol minHeightTerms">

                            <div class="cardTitleBtt">
                                <h3><?= $this->lang->line('general_charges'); ?> <span><!--*--></span></h3>
                                <button type="button" class="btn addBt roundedBt"><?= $this->lang->line('get_quote'); ?></button>
                            </div>
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?= $this->lang->line('charge_id'); ?></th>
                                            <th><?= $this->lang->line('charge_name'); ?></th>
                                            <th><?= $this->lang->line('description'); ?></th>
                                            <th><?= $this->lang->line('general_amount'); ?></th>
                                            <th><?= $this->lang->line('general_currency'); ?></th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <tr>
                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                        </tr>

                                        <tr>
                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                            <td>
                                                <input class="form-control" id="" name="" type="text" placeholder=""
                                                    value="">
                                            </td>

                                        </tr>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                    
                </div>
                


            </div>



                
        </div> <!-- mt-35 -->
        <!----Middle Block- End-->
     
    </div>
    <!--container-->

</div>
</div>


<div class="modal fade" id="view_items">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_items_title"><?php echo $this->lang->line('listofitems'); ?></h4>
            </div>
            <div class="modal-body " style="overflow-x:auto;">
                <div class="box custom-box">
                    <table class="table table-striped" width="100%" id="item_tab">
                        <thead>
                            <tr>
                                <th scope="col"></th>
                                <th scope="col"><?php echo $this->lang->line('package_type'); ?></th>
                                <!-- <th scope="col"><?php echo $this->lang->line('itemname'); ?></th> -->
                                <th scope="col"><?php echo $this->lang->line('truck_length'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_width'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_height'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('actual_weight'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_weight'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('volumetric_weight'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('actual_volume'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_volume'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('description'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="items-show_data">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn"
                    data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectitem btn btn-primary btn_color waves-effect waves-light"
                    onclick="selectiteminlist()"><?php echo $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>

<div id="create_new_item" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="companyCodeAddmodalLabel">
                    <?php echo $this->lang->line('add_item'); ?>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('package_type'); ?></label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);" name="niid" id="niid"
                                parsley-trigger="change" required placeholder="" class="add_item form-control"
                                onkeyup="upper(this);" value="">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('itemname'); ?></label>
                            <input type="text" name="niname" id="niname" parsley-trigger="change" required
                                placeholder="" class="add_item form-control">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label for="Description"><?php echo $this->lang->line('truck_desc'); ?></label>
                            <input type="text" name="nidescrpt" id="nidescrpt" parsley-trigger="change" required
                                placeholder="" class="form-control add_item">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label><?php echo $this->lang->line('truck_length'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="nilength" id="nilength"
                                    parsley-trigger="change" required placeholder="" class="add_item form-control"
                                    onkeyup="upper(this);" value="">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="nil_uom" id="nil_uom" class="form-control custom-select">
                                    <option value="M">M</option>
                                    <option value="Cm">Cm</option>
                                    <option value="FT">Feet</option>
                                    <option value="Inches">Inches</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label><?php echo $this->lang->line('general_width'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="niwidth" id="niwidth"
                                    parsley-trigger="change" required placeholder="" class="add_item form-control">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="niwidth_uom" id="niwidth_uom" class="form-control custom-select">
                                    <option value="M">M</option>
                                    <option value="CM">Cm</option>
                                    <option value="FT">Feet</option>
                                    <option value="Inches">Inches</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label for="Height"><?php echo $this->lang->line('general_height'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="niheight" id="niheight"
                                    parsley-trigger="change" required placeholder="" class="form-control add_item">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="niheight_uom" id="nih_uom"
                                    class="form-control form-control custom-select">
                                    <option value="m">M</option>
                                    <option value="cm">Cm</option>
                                    <option value="FT">Feet</option>
                                    <option value="Inches">Inches</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label><?php echo $this->lang->line('actual_weight'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="niweight" id="niweight"
                                    parsley-trigger="change" required placeholder="" class="add_item form-control">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="niweight_uom" class="form-control custom-select" id="niw_uom">
                                    <option value="G">G</option>
                                    <option value="Kg">Kg</option>
                                    <option value="Tons">Tons</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label><?php echo $this->lang->line('general_weight'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="niweight"
                                    id="nisecondweight" parsley-trigger="change" required placeholder=""
                                    class="add_item form-control">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="nisecondweight_uom" class="form-control custom-select" id="niw_uom">
                                    <option value="G">G</option>
                                    <option value="Kg">Kg</option>
                                    <option value="Tons">Tons</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label><?php echo $this->lang->line('volumetric_weight'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="nivolumetric_weight"
                                    id="nivolumetric_weight" parsley-trigger="change" required placeholder=""
                                    class="add_item form-control">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="nivolumetricweight_uom" class="form-control custom-select"
                                    id="nivolumetricweight_uom">
                                    <option value="G">G</option>
                                    <option value="Kg">Kg</option>
                                    <option value="Tons">Tons</option>
                                </select>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label for="Volume"><?php echo $this->lang->line('actual_volume'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="nivolume" id="nivolume"
                                    parsley-trigger="change" required placeholder="" class="form-control add_item">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="nivolume_uom" id="niv_uom"
                                    class="form-control main-control custom-select">
                                    <option value="cbm">cbm</option>
                                    <option value="CB FT">cbft</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="input-group">
                            <div class="col-md-8">
                                <label for="Volume"><?php echo $this->lang->line('general_volume'); ?></label>
                                <input type="text" onkeypress="return isNumberKey(event);" name="nivolume"
                                    id="nisecondvolume" parsley-trigger="change" required placeholder=""
                                    class="form-control add_item">
                            </div>
                            <div class="col-md-4">
                                <label>&nbsp;</label>
                                <select name="nisecondvolume_uom" id="niv_uom"
                                    class="form-control main-control custom-select">
                                    <option value="cbm">cbm</option>
                                    <option value="CB FT">cbft</option>
                                </select>
                            </div>
                        </div>
                    </div>
                   
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Item Number </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);" name="niitemnumber"
                                id="niitemnumber" parsley-trigger="change" placeholder="" class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>HSN Code </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);" name="niitemhsncode"
                                id="niitemhsncode" parsley-trigger="change" placeholder=""
                                class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Color Code </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);" name="niitemcolorcode"
                                id="niitemcolorcode" parsley-trigger="change" placeholder=""
                                class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Color Code Name </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);"
                                name="niitemclrcodename" id="niitemclrcodename" parsley-trigger="change" placeholder=""
                                class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Size Code </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);" name="niitemsizecode"
                                id="niitemsizecode" parsley-trigger="change" placeholder=""
                                class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Size Code Name </label>
                            <input type="text" onkeypress="return isNonSpecialCharCheck(event);"
                                name="niitemsizecodename" id="niitemsizecodename" parsley-trigger="change"
                                placeholder="" class="form-control add_item">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Unit Price </label>
                            <input type="text" onkeypress="return isNumberKey(event);" name="niitemunitprice"
                                id="niitemunitprice" parsley-trigger="change" placeholder=""
                                class="form-control add_item">
                        </div>
                    </div>
                    <!-- End of change | Chakradhar T <chakradhar@tphrs.com> -->
                </div>
                <!--  <div class="row">
<div class="col-sm-4">
<div class="form-group">
<label>Length</label>
<input type="text" onkeypress="return isNumberKey(event);" onkeypress="return isNonSpecialCharCheck(event);"  name="nilength" id="nilength" parsley-trigger="change" required placeholder="" class="add_item form-control" onkeyup="upper(this);"  value="">
<select name="nil_uom" id="nil_uom" class="main-control custom-select">
<option value="m">m</option>
<option value="cm">cm</option>
</select>
</div>
</div>


</div> -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn"
                    data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
                <button type="button" onclick="newitemadd(event)"
                    class="btn btn-primary  btn_color waves-effect waves-light"
                    id="add_item"><?php echo $this->lang->line('general_add'); ?></button>
                <!--  <input type="submit" class="submittype btn btn-xs btn-primary" id="new_company_add" onclick="newcompanyadd(event)" data-dismiss="close"  data-info="add" value="ADD"> -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<!-- referenceModal modal -->
<div class="modal fade modalStyleSvk orgModalStyle" id="referenceModal" tabindex="-1"
    aria-labelledby="referenceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header overlapHeading">
                <div class="modal-title"><?php echo $this->lang->line('reference'); ?></div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">×</span>
                </button>
            </div>

            <div class="modal-body mt-minus42">
                <table class="table">
                    <thead>
                        <tr>
                            <th></th>
                            <th>#</th>
                            <th><?php echo $this->lang->line('general_name'); ?></th>
                            <th><?php echo $this->lang->line('general_value'); ?></th>
                            <th><?php echo $this->lang->line('description'); ?></th>
                        </tr>
                    </thead>

                    <tbody>
                        <tr>
                            <td><input type="radio" name="inlineRadioOptions" id="inlineRadio1" value="option1"></td>
                            <td>3</td>
                            <td>Name1</td>
                            <td>Value1</td>
                            <td>Description1</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- referenceModal modal -->

<div class="modal fade" id="view_customer_new">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_customer_title">Party details</h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box" style="overflow-x:auto;">
                    <!--  <div id="search">  -->
                    <table class="table table-striped table-bordered" width="100%" id="list_party_new">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?php echo $this->lang->line('id'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('bpartner_pname'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_street'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_city'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_country'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_email'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_company_code'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_branch_code'); ?></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                        <!--  <tbody id="customer-show_data">
</tbody> -->
                    </table>
                    <!-- </div> -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn"
                    data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light"
                    onclick="selectshipperinlistNew()"><?php echo $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="view_invparty">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_invparty_title"><?php echo $this->lang->line('party_details'); ?></h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box" style="overflow-x:auto;">
                    <!--   <div id="search">  -->
                    <table class="table table-striped table-bordered" id="invpartylist" width="100%">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?php echo $this->lang->line('id'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_name'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('party_type'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_street'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_state'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_country'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_company_code'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_branch_code'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="">

                        </tbody>
                        <!-- <tbody id="party-show_data">

</tbody> -->
                    </table>

                    <!-- </div> -->
                </div>

            </div>


            <div class="modal-footer">
                <button type="button" class="btn btn-primary btn_color waves-effect waves-light"
                    data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectpopup btn btn-default waves-effect btn_color resetbtn"
                    onclick="selectinvpartyinlist()"><?php echo $this->lang->line('general_select'); ?></button>

            </div>

        </div>
    </div>
</div>

<div class="modal fade" id="deleteCargoModal" tabindex="-1" role="dialog" aria-labelledby="deleteCargoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header success_message_header">
                <h5 class="modal-title" id="deleteCargoModalLabel"></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this cargo item?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="button" id="confirmDeleteCargo" class="btn btn-danger"><?php echo $this->lang->line('general_delete'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteConfirmModal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-sm" role="document">
    <div class="modal-content">
        <div class="modal-header success_message_header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this reference?
      </div>
      <div class="modal-footer">
        <button type="button" id="confirmDeleteBtn" class="btn btn-danger"><?php echo $this->lang->line('general_delete'); ?></button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="deletePartyModal" tabindex="-1" role="dialog" aria-labelledby="deletePartyModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-sm" role="document">
    <div class="modal-content">
        <div class="modal-header success_message_header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        Are you sure you want to delete this party detail?
      </div>
      <div class="modal-footer">
        <button type="button" id="confirmDeleteParty" class="btn btn-danger"><?php echo $this->lang->line('general_delete'); ?></button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="view_party_new">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_party_title">Party details</h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box" style="overflow-x:auto;">
                    <!--   <div id="search">  -->
                    <table class="table table-striped add-edit-table table-bordered table_bg" id="partylistdataNew"
                        width="100%">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?php echo $this->lang->line('id'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_name'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('party_type'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_street'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_city'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_country'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_company_code'); ?></th>
                                <th scope="col"><?php echo $this->lang->line('general_branch_code'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="">
                        </tbody>
                        <!-- <tbody id="party-show_data">
</tbody> -->
                    </table>
                    <!-- </div> -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn"
                    data-dismiss="modal"><?php echo $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectparty btn btn-primary  btn_color waves-effect waves-light test"
                    onclick="selectpartyinlistNew()"><?php echo $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>


<style>
.table .btn-primary {
    padding: 0px !important;
}
</style>

<script src="<?= base_url() ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<link href="<?= base_url() ?>assets/css/jquery.datetimepicker.css" rel="stylesheet">
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.js"></script>
<script src="<?= base_url() ?>assets/js/jquery.datetimepicker.full.js"></script>


<script src="<?= base_url(); ?>assets/sweetalerts/sweetalert.min.js"></script>
<script>
var baseurl = "<?= base_url();?>";
</script>
<!-- Google APi for address autocomplete - ishak@thhrs.com -->
<?php if ($this->session->userdata('company_code') == "NZKN") { ?>
<script
    src="https://maps.googleapis.com/maps/api/js?key=<?= GOOGLE_MAP_KEY; ?>&libraries=places&callback=initAutocomplete"
    async defer></script>


</script>
<?php
         } ?>


<link href="<?= base_url() ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css" />
<script src="<?= base_url() ?>assets/newtheme/js/custom.js?v=1.1"></script>
<script src="<?= base_url() ?>assets/js/jquery-ui.js"></script>
<script src="<?= base_url() ?>assets/newtheme/js/main.js"></script>
<script src="<?= base_url() ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url() ?>assets/js/order_script.js?v=1.0"></script>

<script>
function rowElim(but) {
    $(but).closest('tr').remove();
}
function getreference_autocomplete() {
    var ref_ids = <?php echo json_encode($referencemaster); ?>;
    $('#reference_id').autocomplete({
        source: ref_ids,
        select: function(event, ui) {
            $(this).val(ui.item.label);
            var id = ui.item.value;
            $.ajax({
                url: baseurl + 'Orderrevenues/getrefnamebyid',
                type: 'post',
                data: {
                    item_id: id,
                    request: 2
                },
                dataType: 'json',
                success: function(response) {
                    if (response != "") {
                        $('#reference_name').val(response);
                    }
                }
            });
            return false;

        }
    });
}

function validateCustomerOrder(){   
        var customer_id = $('#customer_id').val();
        var retFlag = true;
        if (customer_id == "") {
            retFlag = false;
            gettoast('top-right', 'customer_id', 'Please Select Customer');
            return false;
        }
       
        var shipper_id = $('#shipper_id').val();
        if (shipper_id == "") {
           retFlag = false;
            gettoast('top-right', 'shipper_id', 'Please Select Pickup');
            return false;
        }
        var consignee_id = $('#consignee_id').val();
        if (consignee_id == "") {
            retFlag = false;
            gettoast('top-right', 'consignee_id', 'Please Select Delivery');
            return false;
        }
        
        var early_pickup = $('#early_pickup').val();
        if (early_pickup == "") {
           retFlag = false;
            gettoast('top-right', 'early_pickup', 'Please Select Early Pickup');
            return false;
        } else {
            if (!early_pickup.match(/^(19|20)[0-9]{2}[\-.](?:(0[1-9]|1[012])[\-.](0[1-9]|[12][0-9]|3[01])\s([01]\d|2[0-3]):[0-5][0-9]:[0-5][0-9])/)) {
               retFlag = false;
                gettoast('top-right', 'early_pickup', 'Early Pickup is not valid. Format must be yyyy-mm-dd hh:mm:ss ');
                return false;
            }
        }

    var early_delivery = $('#early_delivery').val();
    if (early_delivery == "") {
        retFlag = false;
        gettoast('top-right', 'early_delivery', 'Please Select Delivery Date');
        return false;
    } else {
        if (!early_delivery.match(/^(19|20)[0-9]{2}[\-.](?:(0[1-9]|1[012])[\-.](0[1-9]|[12][0-9]|3[01])\s([01]\d|2[0-3]):[0-5][0-9]:[0-5][0-9])/)) {
            retFlag = false;
            gettoast('top-right', 'early_delivery', 'Delivery is not valid. Format must be yyyy-mm-dd hh:mm:ss ');
            return false;
        }

        var startDate = new Date(early_pickup);
        var endDate = new Date(early_delivery);

        if (endDate < startDate) {
            retFlag = false;
            gettoast('top-right', 'early_delivery', 'Delivery Date and time is greater than or equal to Early Pickup  ');
            return false;
        }
    }

    if(!retFlag){         
        gettoast('top-right', 'shipper_id', 'Please fill the mandatory fields');
        return false;
    }
   
}


// INPUT PLUS MINUS

$('.btn-number').click(function(e) {
    e.preventDefault();

    fieldName = $(this).attr('data-field');
    type = $(this).attr('data-type');
    var input = $("input[name='" + fieldName + "']");
    var currentVal = parseInt(input.val());
    if (!isNaN(currentVal)) {
        if (type == 'minus') {

            if (currentVal > input.attr('min')) {
                input.val(currentVal - 1).change();
            }
            if (parseInt(input.val()) == input.attr('min')) {
                $(this).attr('disabled', true);
            }

        } else if (type == 'plus') {

            if (currentVal < input.attr('max')) {
                input.val(currentVal + 1).change();
            }
            if (parseInt(input.val()) == input.attr('max')) {
                $(this).attr('disabled', true);
            }

        }
    } else {
        input.val(0);
    }
});
$('.input-number').focusin(function() {
    $(this).data('oldValue', $(this).val());
});
$('.input-number').change(function() {

    minValue = parseInt($(this).attr('min'));
    maxValue = parseInt($(this).attr('max'));
    valueCurrent = parseInt($(this).val());

    name = $(this).attr('name');
    if (valueCurrent >= minValue) {
        $(".btn-number[data-type='minus'][data-field='" + name + "']").removeAttr('disabled')
    } else {
        alert('Sorry, the minimum value was reached');
        $(this).val($(this).data('oldValue'));
    }
    if (valueCurrent <= maxValue) {
        $(".btn-number[data-type='plus'][data-field='" + name + "']").removeAttr('disabled')
    } else {
        alert('Sorry, the maximum value was reached');
        $(this).val($(this).data('oldValue'));
    }


});
$(".input-number").keydown(function(e) {
    // Allow: backspace, delete, tab, escape, enter and .
    if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 190]) !== -1 ||
        // Allow: Ctrl+A
        (e.keyCode == 65 && e.ctrlKey === true) ||
        // Allow: home, end, left, right
        (e.keyCode >= 35 && e.keyCode <= 39)) {
        // let it happen, don't do anything
        return;
    }
    // Ensure that it is a number and stop the keypress
    if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
        e.preventDefault();
    }
});
// INPUT PLUS MINUS



function rowAddParty(e) {
    var tableId = $(e).closest('table').attr('id');
    var roles = [];
    roles = <?php echo json_encode($roles); ?>;
    var select =
        '<select style="margin-top: 3px;" class="inv_partes form-control  main-control custom-select-main" form="involved_parties" name="role" id="role"><option value="">Select</option>';
    $.each(roles, function(key, value) {
        select += '<option value="' + value.name + '">' + value.name + '</option>';
    });
    select += '</select>';
    var trOpen = "<tr id='editing'>";

    //   var buttonTds = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu"><li><a id="bEdit" onclick="return checkbeforesaveParty(event)" type="button" class="btn btn-sm btn-default" onclick="rowEditInv(this);"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li><li><a id="bAdd" type="button" class="btn btn-sm btn-default" onclick="rowAddParty(this);"><span class="glyphicon glyphicon-plus"> </span>Add</a></li><li><a id="bAcep" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowAcep(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li><li><a id="bCanc" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowCancel(this);"><span class="glyphicon glyphicon-remove"> </span>Remove</a></li></ul></li></ul></td>';
    var buttonTds = `
    <td name="buttons" style="display:flex";>
        	<button style='margin-right:5px' type='button' onclick='return checkbeforesaveParty(event)'>
				<span class='iconSvk  icon-completed-icon'></span>
			</button>

            <button type="button" class='btn btn-danger btn-xs deleteround' onclick='rowElim(this);'>
					<small>
							<i class='glyphicon glyphicon-trash'></i>
					</small>
			</button>
    </td>
`;

    var tds =
        '<form method="POST" action="<?php echo base_url(); ?>orders/insertinvolvedparties<?php echo @$id ?>" id="involved_parties"  autocomplete="off" novalidate>  ' +
        buttonTds +
        '  <td class="measurement"><input type="text" form="involved_parties" name="party_id" id="party_id" onkeypress="getauctoparty(); return isNonSpecialCharCheck(event);" class="form-control input-sm inv_partes" aria-label="" value=""><input type="hidden" form="involved_parties" name="party_row_id" id="party_row_id" value=""><input form="involved_parties" type="hidden" name="party_company_id" id="party_company_id" value=""><input  form="involved_parties" type="hidden" name="party_branch_id" id="party_branch_id" value=""><button class="btn" type="button" data-toggle="modal" style="width:40px !important;"><a href="#" title="Find" id="viewinvpartylist" onclick="viewinvpartylist(event)"> <i class="icon tru-icon-find-new" style="color:white !important;"></i></a></button></td><td><input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);" form="involved_parties" type="text" name="party_name" id="party_name" class="form-control input-sm inv_partes" aria-label="" value=""></td><td>' +
        select +
        '</td> <td><input form="involved_parties" onkeypress="return isNonSpecialCharCheck(event);" type="text" onkeyup="upper(this);" class="form-control input-sm inv_partes ui-autocomplete-input" id="street"  name="street" autocomplete="off"></td><td><input form="involved_parties" onkeypress="return isNonSpecialCharCheck(event);" type="text" onkeyup="upper(this);" class="form-control input-sm inv_partes ui-autocomplete-input" id="city"  name="city" autocomplete="off"></td><td><input form="involved_parties" onkeypress="return isNonSpecialCharCheck(event);" type="text" onkeyup="upper(this);" class="form-control input-sm inv_partes ui-autocomplete-input" id="state"  name="state" autocomplete="off"></td><td><input form="involved_parties" onkeypress="return isNonSpecialCharCheck(event);" type="text" onkeyup="upper(this);" class="form-control chkcountry input-sm inv_partes ui-autocomplete-input" id="country"  name="country" autocomplete="off"></td><td><input form="involved_parties" onkeypress="return isNonSpecialCharCheck(event);" type="text" onkeyup="upper(this);" class="form-control input-sm inv_partes ui-autocomplete-input" id="zipcode" onkeypress="return isNumberKey(event);" name="zipcode" autocomplete="off"></td><td><input form="involved_parties" type="text" onkeyup="upper(this);" class="form-control input-sm inv_partes" name="mobile" onkeypress="return isNumberKey(event);"  id="mobile"></td><td><input form="involved_parties" type="text" class="form-control input-sm inv_partes" name="fax"  id="fax"></td><td><input form="involved_parties" type="text"  class="form-control input-sm inv_partes" name="email"   id="email"></td>';
    var buttons = '</form>';

    var trClose = "</tr></tbody></table></td>";

    var html = trOpen + tds + buttons + trClose;

    $('#involvedParties_details').prepend(html);
    // rowAddNewBetween('involvedParties_details', e, html);

}

function rowAdd_Old(e) {
    var tableId = $(e).closest('table').attr('id');
    var order_id = $('#editOrderModal #order_id').val();
    var trOpen = "<tr id='editing'>";
    var marks_numbers_column = "<?php echo $marks_numbers_column ?>";
    if (marks_numbers_column) {
        var marksNumbers =
            '<td><input form="cargo_form" onkeypress="return isNonSpecialCharCheck(event);"  onkeyup="upper(this);" type="text" name="marks_numbers" id="marks_numbers" class="form-control input-sm" aria-label="" value=""></td>';
    } else {
        var marksNumbers = '';
    }
  

    var tds = `
<form method="POST" action="<?php echo base_url(); ?>orders/savecargo/0/${order_id}" id="cargo_form" novalidate class="cargo_form" autocomplete="off">
    <td name="buttons" style="display:flex; gap: 2px;margin-top:14.5px; border:0px;">
            <button style='margin-right:5px' type='button' onclick='return saveCargo(this);'>
                <span class='iconSvk  icon-completed-icon'></span>
            </button>
            <button class='btn btn-danger btn-xs deleteround' onclick='rowElim(this);'>
                <small><i class='glyphicon glyphicon-trash'></i></small>
            </button>       
    </td>

    <td style="min-width:200px !important;" class="measurement">
        <input form="cargo_form" type="hidden" id="main_weight" value="">
        <input type="hidden" id="order_forcargo" name="order_forcargo" form="cargo_form" value="${order_id}">
        <input form="cargo_form" type="hidden" id="main_volume" value="">
        <input type="hidden" form="cargo_form" name="item_num_id" id="item_num_id" value="">
        <input form="cargo_form" type="hidden" id="main_height" value="">
        <input form="cargo_form" type="hidden" id="main_width" value="">
        <input form="cargo_form" type="hidden" id="main_length" value="">

        <input form="cargo_form" type="text" onkeypress="getcargoautocomplete(); return isNonSpecialCharCheck(event);" id="cargo_type" name="cargo_type" class="form-control input-sm" value="">

        <button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Find" data-toggle="modal" data-info="<?php echo $this->lang->line('listofitems'); ?>" onclick="viewitemlist(event)"  style="width:40px !important">
            <i class="icon tru-icon-find-new"></i>
        </button>

        <button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Add" data-toggle="modal" onclick="createnewitem(event)" style="width:40px !important">
            <i class="icon tru-icon-add"></i>
        </button>
    </td>

    <td>
        <input form="cargo_form" onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="goods_desc" id="goods_desc" class="form-control input-sm" value="">
    </td>

    ${marksNumbers}

    <td><input form="cargo_form" type="number" name="quantity" id="quantity" min="1" class="form-control input-sm" onkeypress="return quantitytype(event);" value=""></td>
    <td><input type="number" name="item_id" id="item_id" class="form-control input-sm" value="" readonly></td>
    <td><input type="number" name="scanned_quantity" id="scanned_quantity" class="form-control input-sm" value="" readonly></td>

    <!-- Length -->
    <td class="measurement length">
        <div class="input-group">
            <input form="cargo_form" type="text" onkeypress="return isNumberKey(event);" class="form-control input-sm decimal" name="length" id="length" oninput="changebylength()" value="">
            <select form="cargo_form" oninput="changebylength()" id="length_uom" name="length_uom" class="form-control">
                <option value="M">M</option>
                <option value="Cm">CM</option>
                <option value="FT">FT</option>
                <option value="Inches">INCH</option>
            </select>
        </div>
    </td>

    <!-- Width -->
    <td class="measurement width">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" oninput="changebywidth()" name="width" id="width" class="form-control input-sm decimal" value="">
            <select form="cargo_form" class="form-control" oninput="changebywidth()" name="width_uom" id="width_uom">
                <option value="M">M</option>
                <option value="Cm">CM</option>
                <option value="FT">FT</option>
                <option value="Inches">INCH</option>
            </select>
        </div>
    </td>

    <!-- Height -->
    <td class="measurement height">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" oninput="changebyheight()" name="height" id="height" class="form-control input-sm decimal" value="">
            <select form="cargo_form" class="form-control" oninput="changebyheight()" name="height_uom" id="height_uom">
                <option value="M">M</option>
                <option value="Cm">CM</option>
                <option value="FT">FT</option>
                <option value="Inches">INCH</option>
            </select>
        </div>
    </td>

    <!-- Weight -->
    <td class="measurement weight">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" oninput="changebyweight()" class="form-control input-sm decimal" id="weight" name="weight" value="">
            <select form="cargo_form" class="form-control" name="weight_uom" id="weight_uom">
                <option value="G">G</option>
                <option value="Kg">KG</option>
                <option value="Tons">TON</option>
            </select>
        </div>
    </td>

    <!-- Second Weight -->
    <td class="measurement weight">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" class="form-control input-sm decimal" id="secondweight" name="secondweight" value="">
            <select form="cargo_form" class="form-control" name="secondweight_uom" id="secondweight_uom">
                <option value="G">G</option>
                <option value="Kg">KG</option>
                <option value="Tons">TON</option>
            </select>
        </div>
    </td>

    <!-- Volumetric Weight -->
    <td class="measurement weight">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" class="form-control input-sm decimal" id="volumetric_weight" name="volumetric_weight" value="">
            <select form="cargo_form" class="form-control" name="volweight_uom" id="volweight_uom">
                <option value="G">G</option>
                <option value="Kg">KG</option>
                <option value="Tons">TON</option>
            </select>
        </div>
    </td>

    <!-- Volume -->
    <td class="measurement volume">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" name="volume" id="volume" class="form-control input-sm decimal" value="">
            <select form="cargo_form" class="form-control" name="volume_uom" id="volume_uom">
                <option value="cbm">CB M</option>
                <option value="cbcm">CB CM</option>
                <option value="cbft">CB FT</option>
                <option value="cbin">CB IN</option>
            </select>
        </div>
    </td>

    <!-- Second Volume -->
    <td class="measurement volume">
        <div class="input-group">
            <input form="cargo_form" onkeypress="return isNumberKey(event);" type="text" name="secondvolume" id="secondvolume" class="form-control input-sm decimal" value="">
            <select form="cargo_form" class="form-control" name="secondvolume_uom" id="secondvolume_uom">
                <option value="cbm">CB M</option>
                <option value="cbcm">CB CM</option>
                <option value="cbft">CB FT</option>
                <option value="cbin">CB IN</option>
            </select>
        </div>
    </td>

    <!-- LDM -->
    <td>
        <input form="cargo_form" onkeypress="return isNumberKey(event);" onkeyup="upper(this);" type="text" name="ldm" id="ldm" class="form-control input-sm" value="">
    </td>

    <!-- Checkboxes -->
    <td class="measurement" style="text-align:center;min-width:95px !important;">
        <input type="checkbox" form="cargo_form" name="stackable" class="form-control" id="stackable" value="1" style="width:13px">
        <label><?php echo $this->lang->line('qbook_stackable'); ?></label>
    </td>

    <td class="measurement" style="text-align:center;min-width:95px !important;">
        <input form="cargo_form" type="checkbox" name="grounded" class="form-control" id="grounded" value="1" style="width:13px">
        <label><?php echo $this->lang->line('grounded'); ?></label>
    </td>

    <td class="measurement" style="text-align:center;min-width:95px !important;">
        <input form="cargo_form" type="checkbox" name="splittable" class="form-control" id="splittable" value="1" style="width:13px">
        <label><?php echo $this->lang->line('splittable'); ?></label>
    </td>

    <td class="measurement dgGoodsColumn" style="text-align:center;min-width:95px !important;">
        <input form="cargo_form" type="checkbox" name="dg_goods" class="form-control" onchange="checkDggoods()" id="dg_goods" value="1" style="width:13px">
        <label><?php echo $this->lang->line('dg_goods'); ?></label>
    </td>
</form>`;



    var buttons = '</form>';
    var trClose = "</tr></tbody></table></td>";
    var html = trOpen + tds + buttons + trClose;
    $('#cargo_details').prepend(html);   
}


function getcargoautocomplete() {
    $('#cargo_type').autocomplete({
        source: function(request, response) {
            $.ajax({
                url: baseurl + 'orders/getitemid',
                type: 'POST',
                dataType: 'json',
                data: {
                    term: request.term,
                },
                success: function(data) {
                    if (data.length == '0') {
                        $('#cargo_type').val('');
                        $('#cargo_type').focusout();
                        gettoast('top-right', 'cargo_type',
                            'Please enter Correct Package Type');
                    } else {
                        response($.map(data, function(item) {

                            
                            return {
                                id: item.id,
                                value: item.item_id
                            };
                        }));
                    }

                }
            });
        },
        select: function(event, ui) {
            $('#cargo_form').attr("action", baseurl + "orders/savecargo");
            $(this).val(ui.item.label);
            var id = ui.item.value;
            $.ajax({
                url: baseurl + 'orders/getitemdetailsbyId',
                type: 'post',
                data: {
                    item_id: id,
                    request: 2
                },
                dataType: 'json',
                success: function(response) {
                    var len = response.length;
                    if (len > 0) {
                        $('#weight').val(response[0].weight);
                        $('#weight_uom option[value="' + response[0].weight_uom + '"]').prop(
                            "selected", true);
                        $('#main_weight').val(response[0].weight);
                        $('#volume').val(response[0].volume);
                        $('#volume_uom option[value="' + response[0].volume_uom + '"]').prop(
                            "selected", true);
                        $('#main_volume').val(response[0].volume);
                        $('#length').val(response[0].length);
                        $('#length_uom option[value="' + response[0].length_uom + '"]').prop(
                            "selected", true);
                        $('#main_length').val(response[0].length);
                        $('#width').val(response[0].width);
                        $('#width_uom option[value="' + response[0].width_uom + '"]').prop(
                            "selected", true);
                        $('#main_width').val(response[0].width);
                        $('#height').val(response[0].height);
                        $('#height_uom option[value="' + response[0].height_uom + '"]').prop(
                            "selected", true);
                        $('#main_height').val(response[0].height);
                        $('#quantity').val(1);
                        $('#goods_desc').val(response[0].description);
                        $('#quantity').attr("onkeyup", "changedimensions(this,0)");
                    }
                }
            });
            return false;
        }
    });
}

$(document).ready(function() {
    $(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i:s",
        /* minDate : 0,
minTime: 0,*/
        autoclose: true,
    });


  

});

function toggleReferenceDetails(type, orderId) {
            if (type === 'reference') {
            vieworderreferencedetails(orderId);
        } else if (type === 'attachment') {
            vieworderdocsdetails(orderId);
        } else if (type === 'involvedParties') {
            vieworderinvolvedpartiess(orderId);
        } else if (type === 'statusDetails') {
            vieworderstatusdetailss(orderId);
        }

    }
    

function deleteinnercargopackage(id) {
        console.log("Deleting inner cargo with ID:", id); 
        $('.cargo_form').val("");
        $('#editcargo').html("");
        
        $.ajax({
            url: baseurl + 'orders/deleteinnercargopackage',
            type: "POST",
            data: {'inner_id': id},
            dataType: 'json',
            success: function (data) {
                getinnercargotable(data);
            }
        });
    }



function getinnercargo(e, id) {
        
        $.ajax({
            url: baseurl + 'orders/getinnercargo',
            type: "POST",
            data: {'cargo_id': id},
            dataType: "JSON",
            success: function (data) {
                if ($('#rowid_' + id).hasClass('inner_cargo' + id)) {

                } else {
                    if (data.length > 0) {
                        var trOpen = "<tr id='rowid_" + id + "' class='inner_cargo" + id + "'>";
                        var tbody = '<td colspan="11" class="innertable_bg"><table class="table table-striped add-edit-table table-bordered table_bg dynamicTableAdd"> <thead><tr><th class="shoring_icon_no"><i class="fa fa-cogs"></i> <button class="thAddBt" onclick="addinnercargo(this,' + id + ');"><span class="iconSvk icon-add-icon"></span></button> <?php echo $this->lang->line("general_action"); ?></th><th style="min-width:150px;"><i class="icon tru-icon-cargo-type"></i><?php echo $this->lang->line("package_type"); ?></th><th><i class="icon tru-icon-goods"></i><?php echo $this->lang->line("qbook_goodsdescription"); ?></th><th><i class="icon tru-icon-quantity"></i><?php echo $this->lang->line("general_quantity"); ?></th><th><i class="icon tru-icon-length"></i><?php echo $this->lang->line("general_length"); ?></th><th><i class="icon tru-icon-width"></i><?php echo $this->lang->line("general_width"); ?></th><th><i class="icon tru-icon-height"></i><?php echo $this->lang->line("general_height"); ?></th><th><i class="icon tru-icon-weight"></i><?php echo $this->lang->line("general_weight"); ?></th><th><i class="icon tru-icon-volume"></i><?php echo $this->lang->line("general_volume"); ?></th></tr></thead><tbody class="innercargobody">';
                        var tds = "";
                        var buttons = "";
                        $.each(data, function (key, value) {
                            var length = value.inner_length.split(" ");
                            var width = value.inner_width.split(" ");
                            var height = value.inner_height.split(" ");
                            var weight = value.inner_weight.split(" ");
                            var volume = value.inner_volume.split(" ");
                            var arr = ["'" + value.inner_cargo + "'", "'" + value.inner_gd + "'", "'" + value.inner_quantity + "'", "'" + length[0] + "'", "'" + width[0] + "'", "'" + height[0] + "'", "'" + weight[0] + "'", "'" + volume[0] + "'", "'" + id + "'", "'" + value.inner_id + "'"];
                          //  tds += '<tr><td name="buttons"><ul class="nav nav-tabs"><li class="dropdown  tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu"><li><a id="bEdit" type="button" class="btn btn-sm btn-default tblEdit" onclick="rowEditInnerTable(this,[' + arr + ']);"><span class="glyphicon glyphicon-pencil"> </span>Edit</a></li><li><a id="bElim"  class="btn btn-sm btn-default" onclick="rowElimInnerTable(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li><li><a id="bAdd"  type="button" class="btn btn-sm btn-default" onclick="addinnercargo(this,' + id + ');"><span class="glyphicon glyphicon-plus"> </span>Add Inner Packing</a></li><li><a id="bAcep"  class="btn btn-sm btn-default tblAccept" style="display:none;" onclick="rowAcepInnerTable(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li><li><a id="bCanc" type="button" class="btn btn-sm btn-default tblCancel" style="display:none;" onclick="rowCancelInnerTable(this);"><span class="glyphicon glyphicon-remove"> </span>Remove</a></li></ul></li></ul></td><td>' + value.inner_cargo + '</td><td>' + value.inner_gd + '</td><td>' + value.inner_quantity + '</td><td class="measurement length">' + value.inner_length + '</td><td class="measurement width">' + value.inner_width + '</td><td class="measurement height">' + value.inner_height + '</td><td class="measurement weight">' + value.inner_weight + '</td><td class="measurement volume">' + value.inner_volume + '</td></tr>';

                        tds += '<tr>' +
                        '<td name="buttons" class="inner_cargo_btns">' +
                            '<button class="btn btn-primary btn-xs editparties cargo_btn" onclick="rowEditInnerTable(this, [' + arr.join(',') + ']);">' +
                                '<small><i class="glyphicon glyphicon-pencil"></i></small>' +
                            '</button> ' +
                            '<button class="btn btn-danger btn-xs deleteround cargo_btn" onclick="deleteinnercargopackage(' +
                                  value.inner_id +
                                  ', this)">' +
                                '<small><i class="glyphicon glyphicon-trash"></i></small>' +
                            '</button>' +
                            '<button style="margin-right:5px" type="button"  type="button" class="btn btn-sm btn-default cargo_btn" onclick="addinnercargo(this,' + id + ');">'+
                            '<span class="glyphicon glyphicon-plus"> </span>'+
                            '</button>' +
                        '</td>' +
                        '<td>' + value.inner_cargo + '</td>' +
                        '<td>' + value.inner_gd + '</td>' +
                        '<td>' + value.inner_quantity + '</td>' +
                        '<td class="measurement length">' + value.inner_length + '</td>' +
                        '<td class="measurement width">' + value.inner_width + '</td>' +
                        '<td class="measurement height">' + value.inner_height + '</td>' +
                        '<td class="measurement weight">' + value.inner_weight + '</td>' +
                        '<td class="measurement volume">' + value.inner_volume + '</td>' +
                       
                    '</tr>';


                        });
                        var trClose = "</tbody></table></td></tr>";
                        var html = trOpen + tbody + tds + trClose;
                        rowAddNewBetween('cargo_details', e, html);
                    } else {
                        /*
                        var tableId = $(e).closest('table').attr('id');
                        var trOpen = "<tr id='rowid_" + id + "' class='inner_cargo" + id + "'>";
                        var tds = '<td colspan="11"><form method="POST" action="<?php echo base_url(); ?>orders/saveinnercargo" id="innercargo_form" novalidate class="innercargo_form" ><table class="table table-striped add-edit-table table-bordered table_bg dynamicTableAdd"> <tr><th class="shoring_icon_no"><i class="fa fa-cogs"></i><?php echo $this->lang->line("general_action"); ?></th><th style="min-width:150px;"><i class="icon tru-icon-cargo-type"></i><?php echo $this->lang->line("package_type"); ?></th><th><i class="icon tru-icon-goods"></i><?php echo $this->lang->line("qbook_goodsdescription"); ?></th><th><i class="icon tru-icon-quantity"></i><?php echo $this->lang->line("general_quantity"); ?></th><th><i class="icon tru-icon-length"></i><?php echo $this->lang->line("general_length"); ?></th><th><i class="icon tru-icon-width"></i><?php echo $this->lang->line("general_width"); ?></th><th><i class="icon tru-icon-height"></i><?php echo $this->lang->line("general_height"); ?></th><th><i class="icon tru-icon-weight"></i><?php echo $this->lang->line("general_weight"); ?></th><th><i class="icon tru-icon-volume"></i><?php echo $this->lang->line("general_volume"); ?></th></tr></thead><tbody class="innercargobody"><tr id="editing"><td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu"><li onclick="return saveInnerCargo(this);"><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="rowEdit(this);"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li><li><a id="bAcep" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowAcep(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li><li><a id="bCanc" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowCancel(this);"><span class="glyphicon glyphicon-remove"> </span>Remove</a></li></ul></li></ul></td><td class="measurement" style="min-width:255px;"><input  form="innercargo_form" type="hidden" name="main_cargo_id" id="main_cargo_id" value="' + id + '"><input type="hidden" id="main_weight" value=""><input type="hidden" id="main_volume" value=""><input type="hidden" id="main_height" value=""><input type="hidden" id="main_width" value=""><input type="hidden" id="main_length" value=""><input type="text" onkeypress="getcargoautocomplete(); return isNonSpecialCharCheck(event);" form="innercargo_form" id="cargo_type" name="cargo_type" class="form-control input-sm" aria-label="" value=""><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="viewitemlist(event)"><i class="icon tru-icon-find-new"></i></button><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Add" data-toggle="modal" onclick="createnewitem(event)"><i class="icon tru-icon-add"></i></button></td><td><input onkeypress="return isNonSpecialCharCheck(event);" form="innercargo_form" type="text" name="goods_desc" id="goods_desc" class="form-control input-sm" aria-label="" value=""></td><td><input form="innercargo_form" type="number" onkeypress="return quantitytype(event);"  name="quantity" onkeyup="changedimensions(this,0)" id="quantity" min="1" class="form-control input-sm" aria-label="" value=""></td><td class="measurement length"><div class="input-group"><input form="innercargo_form" type="text" class="form-control input-sm decimal" name="length" id="length" aria-label="" oninput="changebylength()" value=""><select form="innercargo_form" oninput="changebylength()" id="length_uom" name="length_uom" class="form-control "><option value="M">M</option><option value="Cm">Cm</option><option value="FT">Feet</option><option value="Inches">Inches</option></select></div></td><td class="measurement width"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebywidth()"  name="width" id="width" class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" oninput="changebywidth()" name="width_uom" id="width_uom"><option value="M">M</option><option value="Cm">Cm</option><option value="FT">Feet</option><option value="Inches">Inches</option></select></div></td><td class="measurement height"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyheight()"  name="height" id="height" class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" oninput="changebyheight()" name="height_uom" id="height_uom"><option value="M">M</option><option value ="Cm">Cm</option><option value="FT">Feet</option><option value="Inches">Inches</option></select></div></td><td class="measurement weight"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyweight()"  class="form-control input-sm decimal" aria-label="" id="weight" name="weight" value=""><select form="innercargo_form" class="form-control" name="weight_uom" id="weight_uom"><option value="Kg">Kg</option><option value="Tons">Tons</option></select></div></td><td class="measurement volume"><div class="input-group"><input form="innercargo_form" type="text" name="volume" id="volume"  class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" name="volume_uom" id="volume_uom"><option value="cbm">cbm</option><option value="CB FT">cbft</option></select></div></td>';
                        var buttons = '</form>';                 
                        var divClose = "";
                        var trClose = "</tr></tbody></table></td>";
                        var html = trOpen + tds + buttons + divClose + trClose;
                        */

                        var tableId = $(e).closest('table').attr('id');
                        var trOpen = "<tr id='rowid_" + id + "' class='inner_cargo" + id + "'>";
                        var btntds = '<td name="buttons" class="inner_cargo_btns" style="height:60px">' +
                        '<button class="btn btn-primary btn-xs editparties cargo_btn" onclick="return saveInnerCargo(this);">' +
                            '<small><i class="iconSvk icon-completed-icon"></i></small>' +
                        '</button> ' +
                        '<button class="btn btn-danger btn-xs deleteround cargo_btn" onclick="rowElim(this);">' +
                            '<small><i class="glyphicon glyphicon-trash"></i></small>' +
                        '</button>' +
                        '</td>';
                        var tds = '<td colspan="11"><form method="POST" action="<?php echo base_url(); ?>orders/saveinnercargo" id="innercargo_form" novalidate class="innercargo_form" ><table class="table table-striped add-edit-table table-bordered table_bg dynamicTableAdd"> <tr><th class="shoring_icon_no"><i class="fa fa-cogs"></i><?php echo $this->lang->line("general_action"); ?></th><th style="min-width:150px;"><i class="icon tru-icon-cargo-type"></i><?php echo $this->lang->line("package_type"); ?></th><th><i class="icon tru-icon-goods"></i><?php echo $this->lang->line("qbook_goodsdescription"); ?></th><th><i class="icon tru-icon-quantity"></i><?php echo $this->lang->line("general_quantity"); ?></th><th><i class="icon tru-icon-length"></i><?php echo $this->lang->line("general_length"); ?></th><th><i class="icon tru-icon-width"></i><?php echo $this->lang->line("general_width"); ?></th><th><i class="icon tru-icon-height"></i><?php echo $this->lang->line("general_height"); ?></th><th><i class="icon tru-icon-weight"></i><?php echo $this->lang->line("general_weight"); ?></th><th><i class="icon tru-icon-volume"></i><?php echo $this->lang->line("general_volume"); ?></th></tr></thead><tbody class="innercargobody"><tr id="editing"> '+btntds+' <td class="measurement" style="min-width:255px;"><input  form="innercargo_form" type="hidden" name="main_cargo_id" id="main_cargo_id" value="' + id + '"><input type="hidden" id="main_weight" value=""><input type="hidden" id="main_volume" value=""><input type="hidden" id="main_height" value=""><input type="hidden" id="main_width" value=""><input type="hidden" id="main_length" value=""><input type="text" onkeypress="getcargoautocomplete(); return isNonSpecialCharCheck(event);" form="innercargo_form" id="cargo_type" name="cargo_type" class="form-control input-sm" aria-label="" value=""><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="viewitemlist(event)"><i class="icon tru-icon-find-new"></i></button><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Add" data-toggle="modal" onclick="createnewitem(event)"><i class="icon tru-icon-add"></i></button></td><td><input onkeypress="return isNonSpecialCharCheck(event);" form="innercargo_form" type="text" name="goods_desc" id="goods_desc" class="form-control input-sm" aria-label="" value=""></td><td><input form="innercargo_form" type="number" onkeypress="return quantitytype(event);"  name="quantity" onkeyup="changedimensions(this,0)" id="quantity" min="1" class="form-control input-sm" aria-label="" value=""></td><td class="measurement length"><div class="input-group"><input form="innercargo_form" type="text" class="form-control input-sm decimal" name="length" id="length" aria-label="" oninput="changebylength()" value=""><select form="innercargo_form" oninput="changebylength()" id="length_uom" name="length_uom" class="form-control "><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement width"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebywidth()"  name="width" id="width" class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" oninput="changebywidth()" name="width_uom" id="width_uom"><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement height"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyheight()"  name="height" id="height" class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" oninput="changebyheight()" name="height_uom" id="height_uom"><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement weight"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyweight()"  class="form-control input-sm decimal" aria-label="" id="weight" name="weight" value=""><select form="innercargo_form" class="form-control" name="weight_uom" id="weight_uom"><option value="G">G</option><option value="Kg">KG</option><option value="Tons">TON</option></select></div></td><td class="measurement volume"><div class="input-group"><input form="innercargo_form" type="text" name="volume" id="volume"  class="form-control input-sm decimal" aria-label="" value=""><select form="innercargo_form" class="form-control" name="volume_uom" id="volume_uom"><option value="cbm">CB M</option><option value="cbcm">CB CM</option><option value="cbft">CB FT</option><option value="cbin">CB IN</option></select></div></td>';
                      
                        var buttons = '</form>';                 
                        var divClose = "";
                        var trClose = "</tr>";
                        var html = trOpen + tds + buttons  + divClose + trClose;                      
                        rowAddNewBetween('cargo_details', e, html);
                    }
                }
            }
        });

    }

    
    function saveInnerCargo(e) {
        var cargo_type = $('#cargo_type').val();
        var weight = $('#weight').val();
        var quantity = $('#quantity').val();
        var volume = $('#volume').val();
        var length = $('#length').val();
        var width = $('#width').val();
        var height = $('#height').val();
        if (cargo_type.length == "") {
            gettoast('top-right', 'cargo_type', 'Please enter Correct Package Type');
            return false;
        } else if (quantity == '') {
            $('#quantity').val(1);
        } else {
            var data = $("#innercargo_form").serializeArray();
            $.ajax({
                url: $("#innercargo_form").attr("action"),
                type: "POST",
                data: data,
                dataType: "JSON",
                success: function (data) {
                    console.log(main_cargo_id);
                    cargo_id = data.main_cargo_id;
                    //('#innercargo_form').html('');
                    getinnercargotable(cargo_id);
                    closeAdvPopup();
                },
            })
            return false;
        }
    }

    function getinnercargotable(cargo_id) {
        $('.innercargobody').html("");
        $.ajax({
            url: baseurl + 'orders/getinnercargo',
            type: "POST",
            data: {'cargo_id': cargo_id},
            dataType: "JSON",
            success: function (data) {
                console.log(data);
                var htm = "";
                $.each(data, function (key, value) {
                    var length = value.inner_length.split(" ");
                    var width = value.inner_width.split(" ");
                    var height = value.inner_height.split(" ");
                    var weight = value.inner_weight.split(" ");
                    var volume = value.inner_volume.split(" ");
                    var arr = ['"' + value.inner_cargo + '"', '"' + value.inner_gd + '"', '"' + value.inner_quantity + '"', '"' + length[0] + '"', '"' + width[0] + '"', '"' + height[0] + '"', '"' + weight[0] + '"', '"' + volume[0] + '"', '"' + cargo_id + '"', '"' + value.inner_id + '"'];
                    //htm += "<tr><td name='buttons'><ul class='nav nav-tabs'><li class='dropdown tablebtnrleft'><a class='dropdown-toggle' data-toggle='dropdown' href='#'><span class='icon tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'><li><a id='bEdit' type='button' class='btn btn-sm btn-default tblEdit' onclick='rowEditInnerTable(this,[" + arr + "]);'><span class='glyphicon glyphicon-pencil'> </span>Edit</a></li><li><a id='bElim'  class='btn btn-sm btn-default' onclick='rowElimInnerTable(this);'><span class='glyphicon glyphicon-trash'> </span>Remove</a></li><li><a id='bAdd'  type='button' class='btn btn-sm btn-default' onclick='addinnercargo(this," + cargo_id + ");'><span class='glyphicon glyphicon-plus'> </span>Add Inner Packing</a></li></ul></li></ul></td><td title='Inner Cargo Type'>" + value.inner_cargo + "</td><td title='Inner Goods Description'>" + value.inner_gd + "</td><td title='Inner Quantity'>" + value.inner_quantity + "</td><td title='Inner Length'>" + value.inner_length + "</td><td title='Inner Width'>" + value.inner_width + "</td><td title='Inner Height'>" + value.inner_height + "</td><td title='Inner Weight'>" + value.inner_weight + "</td><td title='Inner Volume'>" + value.inner_volume + "</td></tr>";
                
                    htm += `
                <tr>
                <td name="buttons" class="inner_cargo_btns">
                    <button type="button"  class='btn btn-primary btn-xs editparties cargo_btn' onclick='rowEditInnerTable(this, [${arr}]);'
					<small>
							<i class='glyphicon glyphicon-pencil'></i>
					</small>
			</button> 
  
			<button type="button" class='btn btn-danger btn-xs deleteround cargo_btn' onclick='rowElimInnerTable(this);'>
					<small>
							<i class='glyphicon glyphicon-trash'></i>
					</small>
			</button>
  
			<button type="button" class='btn btn-danger btn-xs deleteround cargo_btn' onclick='addinnercargo(this, ${cargo_id});'>
					<small>
						<i class='iconSvk icon-ordertype-icon'></i>
					</small>
			</button>
                </td>
                <td title="Inner Cargo Type">${value.inner_cargo}</td>
                <td title="Inner Goods Description">${value.inner_gd}</td>
                <td title="Inner Quantity">${value.inner_quantity}</td>
                <td title="Inner Length">${value.inner_length}</td>
                <td title="Inner Width">${value.inner_width}</td>
                <td title="Inner Height">${value.inner_height}</td>
                <td title="Inner Weight">${value.inner_weight}</td>
                <td title="Inner Volume">${value.inner_volume}</td>
                </tr>`;
                
                
                });
                $('.innercargobody').html(htm);
            }
        });
    }
    
    function splitValueUnit(str, defaultUnit = "M") {
        if (!str) return ["", defaultUnit];
        str = str.replace(/\u00A0/g, " ").trim();
        let parts = str.split(" ");
        return [parts[0] || "", parts[1] || defaultUnit];
    }

    
    function rowEditInnerTable(but, arr) {   
        var $row = $(but).closest('tr');
        var $cols = $row.find('td');
        var tableId = $(but).closest('table').attr('id');
        var main_weight = arr[6] / arr[2];
        var main_volume = arr[7] / arr[2];
        let [lengthValue, lengthUnit] = splitValueUnit(arr[3]);
        let [widthValue, widthUnit] = splitValueUnit(arr[4]);
        let [heightValue, heightUnit] = splitValueUnit(arr[5]);
        let [weightValue, weightUnit] = splitValueUnit(arr[6], "kg");
        let [volumeValue, volumeUnit] = splitValueUnit(arr[7], "cbm");
        weightValue = parseFloat(weightValue) || 0;
        volumeValue = parseFloat(volumeValue) || 0;
        let qty = parseFloat(arr[2]) || 1;
        var main_weight = weightValue / qty;
        var main_volume = volumeValue / qty;
        var tds = '<td name="buttons"><button style="margin-right:5px" type="button" onclick="return saveInnerCargo(this);" ><span class="iconSvk  icon-completed-icon"></span></button></td>';
        tds += '<td colspan="9"><form method="POST" action="<?php echo base_url(); ?>orders/saveinnercargo/' + arr[9] + '" id="innercargo_form" novalidate class="innercargo_form" ><table class="table table-striped add-edit-table table-bordered table_bg dynamicTableAdd"><tr id="editing"><td><input form="innercargo_form" type="hidden" name="main_cargo_id" id="main_cargo_id" value="' + arr[9] + '"><input type="hidden" id="main_weight" value="' + main_weight + '"><input type="hidden" id="main_volume" value="' + main_volume + '"><input type="hidden" id="main_height" value="' + arr[5] + '"><input type="hidden" id="main_width" value="' + arr[4] + '"><input type="hidden" id="main_length" value="' + arr[3] + '"><input type="text" onkeypress="getcargoautocomplete()" form="innercargo_form" id="cargo_type" name="cargo_type" class="form-control input-sm" aria-label="" value="' + arr[0] + '"></td><td><input form="innercargo_form" type="text" name="goods_desc" id="goods_desc" class="form-control input-sm" aria-label="" value="' + arr[1] + '"></td><td><input form="innercargo_form" type="number" onkeypress="return quantitytype(event);" name="quantity" onkeyup="changedimensions(this,0)" id="quantity" min="1" class="form-control input-sm" aria-label="" value="' + arr[2] + '"></td><td class="measurement length"><div class="input-group"><input form="innercargo_form" type="text" class="form-control input-sm" name="length" id="length" aria-label="" oninput="changebylength()" value="' + lengthValue + '"><select form="innercargo_form" oninput="changebylength()" id="length_uom" name="length_uom" class="form-control "><option value="M">M</option><option value="Cm">CM</option> <option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement width"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebywidth()"  name="width" id="width" class="form-control input-sm" aria-label="" value="' + widthValue + '"><select form="innercargo_form" oninput="changebywidth()" class="form-control" name="width_uom" id="width_uom"><option value="M">M</option><option value="Cm">CM</option> <option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement height"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyheight()"  name="height" id="height" class="form-control input-sm" aria-label="" value="' + heightValue + '"><select form="innercargo_form" oninput="changebyheight()" class="form-control" name="height_uom" id="height_uom"><option value="M">M</option><option value="Cm">CM</option> <option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement weight"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyweight()"  class="form-control input-sm" aria-label="" id="weight" name="weight" value="' + weightValue + '"><select form="innercargo_form" class="form-control" name="weight_uom" id="weight_uom"><option value="G">G</option><option value="Kg">KG</option><option value="Tons">TON</option></select></div></td><td class="measurement volume"><div class="input-group"><input form="innercargo_form" type="text" name="volume" id="volume"  class="form-control input-sm" aria-label="" value="' + volumeValue + '"><select form="innercargo_form" class="form-control" name="volume_uom" id="volume_uom"><option value="cbm">CB M</option><option value="cbcm">CB CM</option><option value="cbft">CB FT</option><option value="cbin">CB INCH</option></select></div></td>';
      
        var buttons = '</form>';
        var trClose = "";
        var html = tds + buttons + trClose;
        $row.html(html);
        $('#length_uom option[value="' + lengthUnit + '"]').prop("selected", true);
        $('#width_uom option[value="' + widthUnit + '"]').prop("selected", true);
        $('#height_uom option[value="' + heightUnit + '"]').prop("selected", true);
        $('#weight_uom option[value="' + weightUnit + '"]').prop("selected", true);
        $('#volume_uom option[value="' + volumeUnit + '"]').prop("selected", true);
    }

    
    function addinnercargo(e, id) {
        var trOpen = "<tr class=''>";
        var buttonTd = `
                <td name="buttons" class="inner_cargo_btns" style='height:60px'>
                    <button style='margin-right:5px' type='button' class="cargo_btn" onclick='return saveInnerCargo(this);'>
                        <span class='iconSvk  icon-completed-icon'></span>
                    </button>

                    <button class='btn btn-danger btn-xs deleteround cargo_btn' onclick='rowElim(this);'>
                        <small>
                                <i class='glyphicon glyphicon-trash'></i>
                        </small>
                    </button>                    
                </td>
                `;
        var tds = '<td colspan="9"><form method="POST" action="<?php echo base_url(); ?>orders/saveinnercargo" id="innercargo_form" novalidate class="innercargo_form" ><table class="table table-striped add-edit-table table-bordered table_bg dynamicTableAdd"><tbody><tr id="editing" style="display:flex"> '+buttonTd+'  <td style="min-width:150px;" class="inner_cargo_btns"><input type="hidden" name="main_cargo_id" form="innercargo_form" id="main_cargo_id" value="' + id + '"><input type="hidden" id="main_weight" value=""><input type="hidden" id="main_volume" value=""><input type="hidden" id="main_height" value=""><input type="hidden" id="main_width" value=""><input type="hidden" id="main_length" value=""><input form="innercargo_form" type="text" onkeypress="getcargoautocomplete()" id="cargo_type" name="cargo_type" class="form-control input-sm" aria-label="" value=""><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="viewitemlist(event)"><i class="icon tru-icon-find-new"></i></button><button class="btn btn-outline-secondary-cargo" type="button" data-placement="top" title="Add" data-toggle="modal" onclick="createnewitem(event)"><i class="icon tru-icon-add"></i></button></td><td><input form="innercargo_form" type="text" name="goods_desc" id="goods_desc" class="form-control input-sm" aria-label="" value="" style="margin-top: 14px;"></td><td><input form="innercargo_form" type="number"  name="quantity" onkeypress="return quantitytype(event);" onkeyup="changedimensions(this,0)" id="quantity" min="1" class="form-control input-sm" aria-label="" value="" style="margin-top: 14px;"></td><td class="measurement length"><div class="input-group"><input form="innercargo_form" type="text" class="form-control input-sm" name="length" id="length" aria-label="" oninput="changebylength()" value=""><select form="innercargo_form" id="length_uom" oninput="changebylength()" name="length_uom" class="form-control "><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement width"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebywidth()"  name="width" id="width" class="form-control input-sm" aria-label="" value=""><select form="innercargo_form" oninput="changebywidth()" class="form-control" name="width_uom" id="width_uom"><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement height"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyheight()"  name="height" id="height" class="form-control input-sm" aria-label="" value=""><select form="innercargo_form" oninput="changebyheight()" class="form-control" name="height_uom" id="height_uom"><option value="M">M</option><option value="Cm">CM</option><option value="FT">FT</option><option value="Inches">INCH</option></select></div></td><td class="measurement weight"><div class="input-group"><input form="innercargo_form" type="text" oninput="changebyweight()"  class="form-control input-sm" aria-label="" id="weight" name="weight" value=""><select form="innercargo_form" class="form-control" name="weight_uom" id="weight_uom"><option value="G">G</option><option value="Kg">KG</option><option value="Tons">TON</option></select></div></td><td class="measurement volume"><div class="input-group"><input form="innercargo_form" type="text" name="volume" id="volume"  class="form-control input-sm" aria-label="" value=""><select form="innercargo_form" class="form-control" name="volume_uom" id="volume_uom"><option value="cbm">CB M</option><option value="cbcm">CB CM</option><option value="cbft">CB FT</option><option value="cbin">CB INCH</option></select></div></td>';
        var buttons = '</form>';

        var trClose = "</tr></tbody></table></td>";
        var html = trOpen + tds + buttons + trClose;
        rowAddNewBetween('innercargobody', e, html);

}   


setTimeout(() => {
    toggleReferenceDetails('reference');
    getorderinvolvedparties();
    getordercargodetailsNew();
}, 100);

function changebylength() {
    var height = $('#height').val();
    var length_uom = $('#length_uom').val();
    var height_uom = $('#height_uom').val();
    var width_uom = $('#width_uom').val();
    var length = $('#length').val();
    var width = $('#width').val();
    var weight = $('#weight').val();
    $('#quantity').attr("onkeyup", "changedimensions(this,0);");
    var quantity = $('#quantity').val();
    var main_length = length;
    $('#main_length').val(main_length);
    if (length_uom == 'Cm' && height_uom == 'Cm' && width_uom == 'Cm') {
        if (height != "" && width != "" && length != "") {
            var volume = ((length * width * height) / 1000000) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'M' && height_uom == 'M' && width_uom == 'M') {
        if (height != "" && width != "" && length != "") {
            var volume = (length * width * height) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'Inches' && height_uom == 'Inches' && width_uom == 'Inches') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 61024) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    } else if (length_uom == 'FT' && height_uom == 'FT' && width_uom == 'FT') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 35.315) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    }
}

function changebyheight() {
    var height = $('#height').val();
    var length_uom = $('#length_uom').val();
    var height_uom = $('#height_uom').val();
    var width_uom = $('#width_uom').val();
    var length = $('#length').val();
    var width = $('#width').val();
    // var height = $('#height').val();
    var weight = $('#weight').val();
    var quantity = $('#quantity').val();
    main_height = height;
    $('#main_height').val(height);
    $('#quantity').attr("onkeyup", "changedimensions(this,0);");
    if (length_uom == 'Cm' && height_uom == 'Cm' && width_uom == 'Cm') {
        if (height != "" && width != "" && length != "") {
            var volume = ((length * width * height) / 1000000) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'M' && height_uom == 'M' && width_uom == 'M') {
        if (height != "" && width != "" && length != "") {
            var volume = (length * width * height) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'Inches' && height_uom == 'Inches' && width_uom == 'Inches') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 61024) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    }else if (length_uom == 'FT' && height_uom == 'FT' && width_uom == 'FT') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 35.315) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    }
}

function changebywidth() {
    var length = $('#length').val();
    var length_uom = $('#length_uom').val();
    var height_uom = $('#height_uom').val();
    var width_uom = $('#width_uom').val();
    var width = $('#width').val();
    var height = $('#height').val();
    var weight = $('#weight').val();
    var quantity = $('#quantity').val();
    var main_width = width;
    $('#main_width').val(main_width);
    $('#quantity').attr("onkeyup", "changedimensions(this,0);");
    if (length_uom == 'Cm' && height_uom == 'Cm' && width_uom == 'Cm') {
        if (height != "" && width != "" && length != "") {
            var volume = ((length * width * height) / 1000000) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'M' && height_uom == 'M' && width_uom == 'M') {
        if (height != "" && width != "" && length != "") {
            var volume = (length * width * height) * quantity;
            $('#volume').val(volume);
        }
    } else if (length_uom == 'Inches' && height_uom == 'Inches' && width_uom == 'Inches') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 61024) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    }else if (length_uom == 'FT' && height_uom == 'FT' && width_uom == 'FT') {
        if (height != "" && width != "" && length != "") {
            var total_value = length * width * height;
            var voln = (total_value / 31.315) * quantity;
            var volume = voln.toFixed(2);
            $('#volume').val(volume);
        }
    }
}

function changebyweight() {
    var weight = $('#weight').val();
    var quantity = $('#quantity').val();
    var single_weight = weight;
    $('#main_weight').val(single_weight);

}


</script>