<div class="row splited" style="font-size: 1.2rem !important;">

    <div class="col-xs-2 slide_bar zero_right_padding">

        <table class="table table-hover">

            <thead class="thead-inverse">

                <tr>

                    <th colspan="2">

                        <center>Live Vehicles</center>

                    </th>

                </tr>

            </thead>

            <tbody>

                <?php

            	if($vehicles->num_rows()>0){

            		foreach($vehicles->result() as $vehicle){

            	?>

                    <tr>

                        <th scope="row">

                            <input type="checkbox" class="child" name="checkbox" id="<?=$vehicle->id?>" checked>

                        </th>

                        <td>

                            <?=$vehicle->register_number?>

                        </td>

                    </tr>

                    <?php

            		}

            	}

            	?>

            </tbody>

        </table>

    </div>

    <div class="col-xs-10 zero_left_padding">

        <div id="map"></div>

    </div>

</div>

<style type="text/css">

    @media screen and (max-width: 768px) {

        .navbar {

            display: none !important;

        }

        .img-responsive {

            max-width: 20% !important;

        }

    }

    

    #map {

        height: 100%;

        width: 100%;

        padding-left: 30px !important;

    }

    

    .slide_bar {

        height: calc(100vh - 50px - 46px);

        background-clip: content-box;

        background-color: white;

    }

    

    .zero_left_padding {

        padding-left: 0 !important;

    }

    

    .zero_right_padding {

        padding-right: 0 !important;

    }
  @media (min-width: 992px)
.modal-lg {
    width: 900px;
}

@media (min-width: 768px)
.modal-dialog {
    width: 600px;
    margin: 30px auto;
}
</style>

<script type="text/javascript">

    var map;



    var markers = [];



    var beaches = [];



    var vehicles = <?php echo json_encode($vehicles->result_array());?>;



    function initMap() {

        map = new google.maps.Map(document.getElementById('map'), {

            zoom: 6,

            center: {

                lat: 17.00,

                lng: 80.0

            },
            styles:[{
                                featureType: "all",
                                stylers: [{
                                    saturation: 0
                                }, {
                                    hue: "#e7ecf0"
                                }]
                            }, {
                                featureType: "road",
                                stylers: [{
                                    saturation: -70
                                }]
                            }, {
                                featureType: "transit",
                                stylers: [{
                                    visibility: "off"
                                }]
                            }, {
                                featureType: "poi",
                                stylers: [{
                                    visibility: "off"
                                }]
                            }, {
                                featureType: "water",
                                stylers: [{
                                    visibility: "simplified"
                                }, {
                                    saturation: -60
                                }]
                            }]
        });

    }



    function setMarkers(map) {



        var image;



        var bounds = new google.maps.LatLngBounds();



        for (var i = 0; i < beaches.length; i++) {

            var beach = beaches[i];



            if (beach['speed'] > 30) {

                image = {

                    url: '<?php echo base_url();?>/assets/images/icons/Red_Truck.png',

                    size: new google.maps.Size(30, 20),

                    origin: new google.maps.Point(0, 0),

                    anchor: new google.maps.Point(0, 32)

                };

            } else {

                image = {

                    url: '<?php echo base_url();?>/assets/images/icons/Blu_Truck.png',

                    size: new google.maps.Size(30, 20),

                    origin: new google.maps.Point(0, 0),

                    anchor: new google.maps.Point(0, 32)

                };

            }



            var infowindow = new google.maps.InfoWindow({

                content: "<table>" +

                    "<tr>" +

                    "<th>Register Number</th><th>:" + beach["register_number"] + "</th>" +

                    "</tr><tr>" +

                    "<th>Current Shift</th><td>:" + beach["splace"] + " - " + beach["eplace"] + "</td>" +

                    "</tr><tr>" +

                    "<th>Current Shift Timings</th><td>:" + beach["stime"] + " - " + beach["etime"] + "</td>" +

                    "</tr><tr>" +

                    "<th>Shipment</th><td>:" + beach["shipment"] + "</td>" +

                    "</tr><tr>" +

                    "<th>Current Location</th><td>:" + beach["location"] + "</td>" +

                    "</tr><tr>" +

                    "<th>Speed</th><td>:" + (parseFloat(beach["speed"]) * 1.60934) + " Km/H</td>" +

                    "</tr><tr>" +

                    "<th>Range of Accuracy</th><td>:" + beach["accuracy"] + " KM</td>" +

                    "</tr><tr>" +

                    "<th>Angle (towords North)</th><td>:" + parseFloat(beach["bearing"]) + "°</td>" +

                    "</tr><tr>" +

                    "<th>Time of Last Received Data</th><td>:" + beach["timestamp"] + "</td>" +

                    "</tr>" +

                    "</table>"

            });



            var marker = new google.maps.Marker({

                position: {

                    lat: parseFloat(beach['latitude']),

                    lng: parseFloat(beach['longitude'])

                },

                map: map,

                icon: image,

                infowindow: infowindow

            });



            markers.push(marker);



            bounds.extend(marker.position);



            google.maps.event.addListener(marker, 'click', function() {

                this.infowindow.open(map, this);

            });

        }



        map.fitBounds(bounds);

    }



    function removeAllMarkers() {

        for (var i = 0; i < markers.length; i++) {

            markers[i].setMap(null);

        }

        markers = [];

    }

    $(".child").change(function() {

        getVehicles();

    });



    function getVehicles() {

        var imei = [];

        $(".child").each(function() {

            if ($(this).is(":checked")) {

                imei.push($(this).attr('id'));

            }

        });

        if (imei.length > 0) {

            $.ajax({

                url: "<?php echo base_url();?>live/sendLiveData",

                type: "POST",

                data: {

                    imei: imei

                },

                dataType: "JSON",

                success: function(data) {

                    removeAllMarkers();

                    beaches = data;

                    setMarkers(map);

                }

            });

        }

    }

    $(document).ready(function() {

        getVehicles();

        window.setInterval(function() {

            getVehicles();

        }, 10000);



    });

</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>&callback=initMap"></script>