<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Livetrack :: SVKONEKT</title>

    <link href="<?php echo base_url("assets/livetrack/css/bootstrap.min.css");?>" rel="stylesheet">
    <link href="<?php echo base_url("assets/livetrack/css/style.css");?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo base_url("assets/css/font-awesome.min.css");?>">
    <script src="<?php echo base_url("assets/livetrack/js/jquery.min.js");?>"></script>
    <script src="<?php echo base_url("assets/livetrack/js/bootstrap.min.js");?>"></script>
    <script src="<?php echo base_url("assets/livetrack/js/scripts.js");?>"></script>
  </head>
  <body>

    <div class="container-fluid">
        <div class="row details-row">
            <div class="col-md-12 no-padding" style="display: flex">
                <div class="tt_order_details tt_box">
                    <div class="tt_box_title">Order Details</div>
                    <div class="tt_box_body">
                        <div class="tt_head">Order ID</div>
                        <div class="tt_value" title="<?php echo $order->order_id;?>"><?php echo $order->order_id;?></div>
                        <div class="tt_head">Order Reference No</div>
                        <div class="tt_value" title="<?php echo $ref;?>"><?php echo $ref;?></div>
                    </div>
                </div>
                <div class="tt_location_details tt_box1" style="width:30%;">
                    <div class="tt_box_title">Address Details</div>
                    <div class="tt_box_body">
                        <div class="tt_ld_address">
                            <i class="fa fa-dot-circle-o"></i>
                            <?php echo implode(",",[$order->pickup_address1,$order->pickup_city,$order->pickup_country,$order->pickup_pincode]);?>
                        </div>
                        <div class="tt_ld_date"><?php if(count($trip)>0){ echo date("M d, Y, h:i a",strtotime($trip['stime'])); } ?></div>
                        <div class="tt_ld_address">
                            <i class="fa fa-dot-circle-o" style="color:red;"></i>
                            <?php echo implode(",",[$order->delivery_address1,$order->delivery_city,$order->delivery_country,$order->delivery_pincode]);?>
                        </div>
                        <div class="tt_ld_date"><?php if(count($trip)>0){ if($trip['etime'] != ""){ echo date("M d, Y, h:i a",strtotime($trip['etime'])); }else{ echo date("M d, Y, h:i a",strtotime($order->drop_endtime)); } }else{
                            echo date("M d, Y, h:i a",strtotime($order->drop_endtime));
                        } ?></div>
                    </div>
                </div>
                <div class="tt_order_status tt_box">
                    <div class="tt_box_title"> Last Locaton</div>
                    <div class="tt_box_body">
                        <center>
                            
                            <?php $cursts = "Pending";
                            $stscolor = "background-color: #FFBF00;box-shadow: 2px 2px 8px #d6d6d6;";
                            if(count($trip)>0){
                                if($trip['status']=="1"){
                                    $cursts = "In Transit";
                                    $stscolor = "background-color: #FFBF00;box-shadow: 2px 2px 8px #d6d6d6;";
                                }else if($trip['status']=="0"){
                                    $cursts = "Completed";
                                    $stscolor = "background-color: #4CAF50;box-shadow: 2px 2px 8px #d6d6d6;";
                                }
                            }
                            ?>
                            <div class='tt_os_btn' style="<?php echo $stscolor;?>"><?php echo $cursts;?></div>
                        </center>
                        <div class="tt_os_title">Last Known Location</div>
                        <div class="tt_os_location"><i class="fa fa-map-marker"></i><?php 
                        if(count($record)>0){
                            echo getLocationName($record['latitude'],$record['longitude']);
                        }else{
                            echo "No Location found!";
                        }
                        ?></div>
                        <div class="tt_os_received_time"><?php 
                        if(count($record) > 0){
                            echo date("M d, Y, h:i a",strtotime($record['timestamp']));
                        }
                        ?></div>
                    </div>
                </div>
                <div class="tt_distance_details tt_box">
                    <div class="tt_box_title"> Distance Details</div>
                    <div class="tt_box_body">
                        <div class="tt_head">Travelled Distance</div>
                        <div class="details-distance tt_value"><?php echo $travel_dist;?> Kms / <span class="total_dist" data-order="<?php print_r($order);?>">
                            <?php $distance_text = "";
                            $ret = (Object) array("plat"=>$order->plat,"plng"=>$order->plng,"dlat"=>$order->dlat,"dlng"=>$order->dlng);
                            if($order->plat == null || strlen(trim($order->plat)) == 0 || $order->plng == null || strlen(trim($order->plng)) == 0 || $order->dlat == null || strlen(trim($order->dlat)) == 0 || $order->dlng == null || strlen(trim($order->dlng)) == 0){
                                $ret = orderAddressUpdate($order->id);
                                $ret = (Object) $ret;
                            }
                            $response = distancemetrixship($ret->plat,$ret->plng,$ret->dlat,$ret->dlng);
                            //echo "<div class='hide'>".json_encode($response)."</div>";
                            $distance_text = $response['disttext'];
                            echo $distance_text;
                            ?>
                        </span></div>
                        <div class="tt_head">Pings used till now</div>
                        <div class="tt_value"><?php echo $pings;?></div>
                    </div>
                </div>
                <div class="tt_driver_details tt_box">
                    <div class="tt_box_title"> Driver Details</div>
                    <div class="tt_box_body">
                        <div class="tt_head">Driver Name & ID</div>
                        <div class="tt_value"><?php if(count($driver)>0){ echo $driver['name']." - ".$driver['contact_num'];} ?></div>
                        <div class="tt_head">Vehicle Number</div>
                        <div class="tt_value"><?php if(count($vehicle)>0){ echo $vehicle['register_number'];} ?></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row tt_bottom_pane">
            <div class="col-md-4">
                <div class="tabbable" id="tabs-848995">
                    <ul class="nav nav-tabs">
                        <li class="nav-item active">
                            <a class="nav-link active show" href="#tab1" data-toggle="tab" aria-expanded="false">Status View</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab2" data-toggle="tab" aria-expanded="true">Details</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#tab5" data-toggle="tab">Documents</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " href="#tab6" data-toggle="tab">Timeline View</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane rt-tab-pane active" id="tab1" aria-expanded="false"></div>
                        <div class="tab-pane rt-tab-pane" id="tab2" aria-expanded="true"></div>
                        <div class="tab-pane rt-tab-pane" id="tab5"></div>
                        <div class="tab-pane rt-tab-pane" id="tab6"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="row cards-row" style="margin-bottom:15px">
                    <div class="col-xs-6">
                        <div class="row">
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-clock-o"></i>
                                    </div>
                                    <div class="col-xs-7 no-padding">
                                        <div class="tt_card_title">ETA</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value cards-eta"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-road"></i>
                                    </div>
                                    <div class="col-xs-7 no-padding">
                                        <div class="tt_card_title">KMs</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value cards-distance"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-code-fork"></i>
                                    </div>
                                    <div class="col-xs-7 no-padding">
                                        <div class="tt_card_title">Route</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value switch_map_view" style="color:#3c969f;cursor:pointer">View both routes</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-tachometer"></i>
                                    </div>
                                    <div class="col-xs-6 no-padding">
                                        <div class="tt_card_title">Speed</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value cards-speed"><?php @round($record->speed,2);?> KMPH</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> 
                    <div class="col-xs-6">
                        <div class="row">
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row tt_click" onclick="openHOS('<?php $order->id;?>')">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-truck"></i>
                                    </div>
                                    <div class="col-xs-7 no-padding">
                                        <div class="tt_card_title">HOS</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value">6</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-6 no-padding">
                                        <i class="fa fa-battery-full"></i>
                                    </div>
                                    <div class="col-xs-6 no-padding">
                                        <div class="tt_card_title">Battery</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                       <div class="tt_card_value cards-battery"><?php $battery = 0;
                                       if(count($record)>0){ $battery = round($record['battery'],2); } echo $battery;?> %</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row">
                                    <div class="col-xs-4 no-padding">
                                        <i class="fa fa-hand-lizard-o"></i>
                                    </div>
                                    <div class="col-xs-8 no-padding">
                                        <div class="tt_card_title">Fence Warning</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <!-- <div class="tt_card_value">-</div> -->
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-3 tt_card">
                                <div class="row tt_card_row tt_click" onclick="openAlarms('<?php $order->id;?>')">
                                    <div class="col-xs-5 no-padding">
                                        <i class="fa fa-bell"></i>
                                    </div>
                                    <div class="col-xs-7 no-padding">
                                        <div class="tt_card_title">Alarm</div>
                                    </div>
                                    <div class="col-xs-12 no-padding">
                                        <div class="tt_card_value">4</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12" id="googleMap">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="modal fade in" id="myModal" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content" style="border-radius: 10px;">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="mtitle">Loading...</h4>
        </div>
        <div class="modal-body" id="viewdata">
            
        </div>
      </div>
    </div>
</div>
<script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-core.js"></script>
<script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-service.js"></script>
<script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-ui.js"></script>
<script type="text/javascript" src="https://js.api.here.com/v3/3.1/mapsjs-mapevents.js"></script>
<link rel="stylesheet" type="text/css" href="https://js.api.here.com/v3/3.1/mapsjs-ui.css" />
<?php 
    $finalsts = "a";
    if(count($trip)>0){
        if($trip['status'] == "0"){
            $finalsts = "b";
        }
    }
    $cntrylatlng['ulat'] = 20.5937; 
    $cntrylatlng['ulng'] = 78.9629;
    if(isset($lguid)){
        $cntrylatlng = getLogUserLatLng($lguid);
    }
?>
    <script type="text/javascript">
        var trip_id = '<?php echo @$trip_id;?>';
        var q = [];
        var googleMap;
        var vehicle;
        var nextTimeStamp = "";
        var trackerFrequency = 10000;
        var angle = 0;
        var tokBox = null;
        var trafficLayer;
        var trafficFlag = false;
        var isSimBased = false;
        var actualBounds;
        var id = '<?php echo $id;?>';
        var order_id = '<?php echo $order_id;?>';
        var mph = 13.8889;
        var tripClose = false;
        var directionsService;
        var directionsDisplay;
        var allBounds;
        var showAllBounds = false;
        var platform;
        $(document).ready(function() {
            allBounds = [];
            <?php
            $etime = $tstatus = "";
            if(count($trip)>0){
                $tstatus = $trip['status'];
                if($trip['status']=="0"){
                    echo "tripClose = true;";
                }
                $etime = $trip['etime'];
            }
            ?>
            if(tripClose){
                $(".cards-eta").html('<?php echo @$trip->etime;?>');
            }
            $(".tt_box").css("width",(window.outerWidth/5) - 16)
            setAllTabs();
            if (window.top !== window.self) {
                $("footer.main-footer").remove();
                $(".main-header").remove();
            
                
                $(".tracking-list").css("height", "auto");
                $(".rightBottom").css("margin-bottom", "0px");
            }
            var drh = $(".details-row").outerHeight();
            var crh = $(".cards-row").outerHeight();
            var th = $(".details-row").closest("body").outerHeight() - drh - crh - 45;
            $("#googleMap").css("height", th+"px");

            // Initialize the platform object:
            platform = new H.service.Platform({
              'apikey': '<?php echo HERE_API_KEY; ?>'
            });
            var defaultLayers = platform.createDefaultLayers();
            
            //Step 2: initialize a map - this map is centered over Europe
            googleMap = new H.Map(document.getElementById('googleMap'),
                defaultLayers.vector.normal.map,{
                center: {lat:50, lng:5},
                //zoom: 4,
                pixelRatio: window.devicePixelRatio || 1
            });
            googleMap.getViewPort().setPadding(50, 50, 50, 50);
            // add a resize listener to make sure that the map occupies the whole container
            window.addEventListener('resize', () => googleMap.getViewPort().resize());
            
            //Step 3: make the map interactive
            // MapEvents enables the event system
            // Behavior implements default interactions for pan/zoom (also on mobile touch environments)
            var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(googleMap));
            
            // Create the default UI components
            var ui = H.ui.UI.createDefault(googleMap, defaultLayers);
            googleMap.addLayer(defaultLayers.vector.normal.traffic);
            // // Enable the event system on the map instance:
            // var mapEvents = new H.mapevents.MapEvents(googleMap);
            
            // // Instantiate the default behavior, providing the mapEvents object:
            // new H.mapevents.Behavior(mapEvents);
            
            isSimBased = <?php echo $isSimBased;?>;
            var trip_closed = '<?php echo @$trip->status;?>'; 
            var iconn = getIconByAngle(0);
            // if(isSimBased){
            //     iconn = {path: google.maps.SymbolPath.CIRCLE, scale: 8.5, fillColor: "#F00", fillOpacity: 0.4, strokeWeight: 0.4 };
            // }
            var pos = {lat:0.2,lng:0.1};
            actualBounds = [];
            vehicle = new H.map.Marker(pos, {
                icon: iconn
            });
            googleMap.addObject(vehicle);
            var coords = [];
            var timestamp = "";
        <?php
        foreach($records->result() as $i=>$row){
            if($i == 0){
        ?>  
            pos = {lat:<?php echo @$row->latitude?>,lng:<?php echo @$row->longitude?>};
            var marker = new H.map.Marker(pos, {
                icon: new H.map.Icon('http://maps.google.com/mapfiles/ms/icons/green-dot.png')
            });
            googleMap.addObject(vehicle);
        <?php
            }
            if($i<=$records->num_rows()){
        ?>
            pos = {lat:<?php echo @$row->latitude?>,lng:<?php echo @$row->longitude?>};
            coords.push(pos);
            $(".speed").html("<?php echo @$row->speed?>");
            $(".timestamp").html("<?php echo @$row->timestamp?>");
            <?php } ?>
            timestamp = "<?php echo @strtotime($row->timestamp)?>";
        <?php } ?>
            if(coords.length > 0){
                vehicle.setGeometry(pos);
                var lineString = new H.geo.LineString();
                $.each(coords,function(i,val){
                    lineString.pushPoint(val);    
                });
                var line= new H.map.Polyline(lineString, { 
                    style: { 
                        lineWidth: 6,
                        strokeColor: "#C32148",
                        strokeOpacity: 0.5 
                    }
                })
                googleMap.addObject(line);
                actualBounds.push(line);
                allBounds.push(line);
            }
            getTripLocation(isSimBased,timestamp);
            $.ajax({
                url:"<?php echo base_url('livetrack/shipmentView/'.$order_id);?>",
                type:"POST",
                data:{'timezone':'<?php echo $timezone;?>'},
                success:function(html){
                    $("#tab6").html(html);
                    calcRoute();
                }
            });
            getAddress();
            $(".switch_map_view").click(function(){
                if(showAllBounds == false){
                    showAllBounds = true;
                    var group = new H.map.Group();
                    group.addObjects(actualBounds);
                    googleMap.addObject(group);
                    googleMap.getViewModel().setLookAtData({
                        bounds: group.getBoundingBox()
                    });
                    $(this).html("View All");
                }else{
                    showAllBounds = false;
                    var group = new H.map.Group();
                    group.addObjects(allBounds);
                    googleMap.addObject(group);
                    googleMap.getViewModel().setLookAtData({
                        bounds: group.getBoundingBox()
                    });
                    $(this).html("View Vehicle");
                 } 
            });
        });
    
        function getTripLocation(isSimBased,timestamp) {
            if (timestamp == "") {
                console.clear();
            }
            $.ajax({
                url: "<?=base_url()?>livetrack/getTripLocation/<?php echo @$trip_id;?>/" + timestamp,
                data:{'timezone':'<?php echo $timezone;?>'},
                type:"POST",
                dataType: "JSON",
                success: function(data) {
                    $.each(data.data, function(i, v) {
                        q.push(v);
                    });
                    if (q.length > 0) {
                        var lastPoint = {lat:q[q.length - 1].lat, lng:q[q.length - 1].lng};
                        var d = q.shift();
                        var pos = {lat:d.lat,lng: d.lng};
                        if (timestamp != "") {
                            $(".speed").html(d.speed);
                            $(".timestamp").html(d.receivedon);
                            startQueueProcessing();
                            
                            if(showAllBounds){
                                var group = new H.map.Group();
                                group.addObjects(allBounds);
                                googleMap.addObject(group);
                                googleMap.getViewModel().setLookAtData({
                                    bounds: group.getBoundingBox()
                                });
                            }
                        } else{
                            vehicle.setGeometry(pos);
                        }
                        $(".cards-battery").html(parseFloat(d.battery).toFixed(0) + " %");
                        $(".cards-speed").html(parseFloat(d.speed).toFixed(2) + " KMPH");
                    }
                    
                    if (data.data.length != 0) {
                        nextTimeStamp = data.data[data.data.length - 1].timestamp;
                    }
                    setTimeout(function() {
                        getTripLocation(isSimBased,nextTimeStamp);
                    }, trackerFrequency);
                }
            });
        }
    
        function startQueueProcessing() {
            queueFunction();
            setInterval(function() {
                queueFunction();
            }, trackerFrequency);
        }
    
        function queueFunction() {
            var data = q.shift();
            if (data != null && vehicle != null) {
                $(".speed").html(data.speed);
                $(".timestamp").html(data.receivedon);
                angle = Math.round(data.course / 10);
                vehicle.setIcon(getIconByAngle(angle));
                //getAddress(vehicle.position.lat(), vehicle.position.lng())
                var newPosition = {lat:data.lat,lng: data.lng};
                var oldPosition = {lat:vehicle.b.lat,lng: vehicle.b.lng};
                
                // bounds = new google.maps.LatLngBounds();
                // bounds.extend(vehicle.position);
                // bounds.extend(newPosition);
                actualBounds = [];
                actualBounds.push(vehicle);
                allBounds.push(vehicle);
                
                if(!showAllBounds){
                    vehicle.animateTo(googleMap, newPosition, {
                        duration: trackerFrequency,
                        drawRoute:"draw"
                    });
                }else{
                    vehicle.animateTo(googleMap, newPosition, {
                        duration: trackerFrequency,
                        dragMap: "no-stick",
                        drawRoute:"draw"
                    });
                }
            }
        }
        function secondsTimeSpanToHMS(s) {
            var h = Math.floor(s/3600); //Get whole hours
            s -= h*3600;
            var m = Math.floor(s/60); //Get remaining minutes
            s -= (m*60).toFixed(0);
            return h+":"+(m < 10 ? '0'+m : m)+":"+(s < 10 ? '0'+s.toFixed(0) : s.toFixed(0)); //zero padding on minutes and seconds
        }
    
        function calcRoute() {
            var routeRequestParams = {
                mode: 'fastest;car',
                representation: 'display',
                routeattributes : 'waypoints,summary,shape,legs',
                maneuverattributes: 'direction,action'
            };
            $(".points").each(function(index,ele){
                var point = $(this).data("lat")+","+$(this).data("lng");
                routeRequestParams["waypoint"+index] = point;
            });
            var router = platform.getRoutingService();
            router.calculateRoute(routeRequestParams,function(result) {
                  var route,linestring;
                  if(result.response.route) {
                      route = result.response.route[0];
                      linestring = new H.geo.LineString();
                      route.shape.forEach(function(point) {
                        var parts = point.split(',');
                        linestring.pushLatLngAlt(parts[0], parts[1]);
                      });
                      var routeLine = new H.map.Polyline(linestring, {
                        style: { strokeColor: '#669DF6', lineWidth: 5,strokeOpacity: 0.5  }
                      });
                      googleMap.addObjects([routeLine]);
                      allBounds.push(routeLine);
                  }
                  setTimeout(function() {
                        var group = new H.map.Group();
                        group.addObjects(allBounds);
                        googleMap.addObject(group);
                        googleMap.getViewModel().setLookAtData({
                            bounds: group.getBoundingBox()
                        });
                    }, 1000);
                },
                function(error) {
                    console.log(error.message);
                }
            );
        }
    
        function getIconByAngle(angle) {
            return new H.map.Icon("<?=base_url()?>assets/vehicle/vehicle copy " + angle + ".png");
        }
        function reloadLocation(ele){
            getAddress();
        }
        function getAddress () {
            var geocoder = platform.getGeocodingService();
            reverseGeocodingParameters = {
              prox: vehicle.b.lat+','+vehicle.b.lng, // Berlin
              mode: 'retrieveAddresses',
              maxresults: '1',
              jsonattributes : 1
            };
            geocoder.reverseGeocode(reverseGeocodingParameters, function(result) {
                var locations = result.response.view[0].result;
                for (i = 0;  i < locations.length; i += 1) {
                    address = locations[i].location.address;
                    content =  address.label;
                    $(".locationName").html(content+" <div class='btn btn-xs btn-default' onclick='reloadLocation(this)'><i class='fa fa-fa fa-refresh'></i></div>");
                }
            }, function(e) {
              alert(e);
            });
        }
        function setAllTabs(){
            $.ajax({
                url:"<?php echo base_url('livetrack/orderdetails');?>",
                data:{"order_id":id,'type':'done','timezone':'<?php echo $timezone;?>'},
                type:"POST",
                success:function(data){
                    $("#tab2").html(data);
                }
            });
            $.ajax({
                url:"<?php echo base_url('livetrack/statusviewdetails');?>",
                data:{"order_id":order_id,"id":id,'timezone':'<?php echo $timezone;?>'},
                type:"POST",
                success:function(data){
                    $("#tab1").html(data);
                    var distance = $(".details-distance").text().replace("Kms","").replace("km","");
                    $(".cards-distance").html(distance);
                    if(tripClose == false){
                        var parts = distance.split("/");
                        if(parts.length == 2){
                            var travelled = parseFloat(parts[0]);
                            var total = parseFloat(parts[1]);
                            var remaining = total - travelled;
                            if(remaining > 0){
                                remaining = (remaining*1000) / mph ;
                                remaining = secondsTimeSpanToHMS(remaining);
                                total = (total*1000) / mph;
                                total = secondsTimeSpanToHMS(total);
                                $(".cards-eta").html(remaining+" / "+total);
                            }else{
                                var total = parseFloat(parts[0]);
                                total = (total*1000) / mph;
                                total = secondsTimeSpanToHMS(total);
                                $(".cards-eta").html(total);
                            }
                        }else if(parts.length == 1){
                            var total = parseFloat(parts[0]);
                            total = (total*1000) / mph;
                            total = secondsTimeSpanToHMS(total);
                            $(".cards-eta").html(total);
                        }else{
                            var total = parseFloat(distance);
                            total = (total*1000) / mph;
                            total = secondsTimeSpanToHMS(total);
                            $(".cards-eta").html(total);
                        }
                    }
                }
            });
            <?php
            if(isset($_GET) && isset($_GET["inner"])){
                echo "var inner = 0;";
            }else{
                echo "var inner = 1;";
            }
            ?>
            $.ajax({
                url:"<?php echo base_url('livetrack/orddocsdetails');?>",
                data:{"order_id":order_id,"id":id,'type':'done','timezone':'<?php echo $timezone;?>','inner':inner},
                type:"POST",
                success:function(data){
                    $("#tab5").html(data);
                }
            });
        }
        function openHOS(order_id){
            $.ajax({
                url:"<?php echo base_url('livetrack/hosdetails');?>",
                data:{"order_id":order_id,'timezone':'<?php echo $timezone;?>'},
                type:"POST",
                beforeSend:function(){
                    $("#myModal").modal("show");
                    $("#mtitle").html("HOS Details");
                    $("#viewdata").html("<center><progress></progress></center>");
                },
                success:function(data){
                    $("#viewdata").html(data);
                }
            });
        }
        function openAlarms(order_id){
            $.ajax({
                url:"<?php echo base_url('livetrack/alarmdetails');?>",
                data:{"order_id":order_id,'timezone':'<?php echo $timezone;?>'},
                type:"POST",
                beforeSend:function(){
                    $("#myModal").modal("show");
                    $("#mtitle").html("Alarm Details");
                    $("#viewdata").html("<center><progress></progress></center>");
                },
                success:function(data){
                    $("#viewdata").html(data);
                }
            });
        }
        
        // Animated Marker Movement. Robert Gerlach 2012-2013 https://github.com/combatwombat/marker-animate
        // MIT license
        //
        // params:
        // newPosition        - the new Position as google.maps.LatLng()
        // options            - optional options object (optional)
        // options.duration   - animation duration in ms (default 1000)
        // options.easing     - easing function from jQuery and/or the jQuery easing plugin (default 'linear')
        // options.complete   - callback function. Gets called, after the animation has finished
        var zoomLevel = 19;
        H.map.Marker.prototype.animateTo = function(googleMap = null, newPosition, options) {
            defaultOptions = {
                duration: 1000,
                easing: 'linear',
                dragMap: 'stick', //no-stick
                complete: null,
                drawRoute: 'no'
            }
            options = options || {};
        
            // complete missing options
            for (key in defaultOptions) {
                options[key] = options[key] || defaultOptions[key];
            }
        
            // throw exception if easing function doesn't exist
            if (options.easing != 'linear') {
                if (typeof jQuery == 'undefined' || !jQuery.easing[options.easing]) {
                    throw '"' + options.easing + '" easing function doesn\'t exist. Include jQuery and/or the jQuery easing plugin and use the right function name.';
                    return;
                }
            }
        
            window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
            window.cancelAnimationFrame = window.cancelAnimationFrame || window.mozCancelAnimationFrame;
        
            // save current position. prefixed to avoid name collisions. separate for lat/lng to avoid calling lat()/lng() in every frame
            this.AT_startPosition_lat = this.b.lat;
            this.AT_startPosition_lng = this.b.lng;
            var newPosition_lat = newPosition.lat;
            var newPosition_lng = newPosition.lng;
        
            // crossing the 180Â° meridian and going the long way around the earth?
            if (Math.abs(newPosition_lng - this.AT_startPosition_lng) > 180) {
                if (newPosition_lng > this.AT_startPosition_lng) {
                    newPosition_lng -= 360;
                } else {
                    newPosition_lng += 360;
                }
            }
            var animateStep = function(marker, startTime) {
                var ellapsedTime = (new Date()).getTime() - startTime;
                var durationRatio = ellapsedTime / options.duration; // 0 - 1
                var easingDurationRatio = durationRatio;
        
                // use jQuery easing if it's not linear
                if (options.easing !== 'linear') {
                    easingDurationRatio = jQuery.easing[options.easing](durationRatio, ellapsedTime, 0, 1, options.duration);
                }
        
                if (durationRatio < 1) {
                    var deltaPosition = {lat:marker.AT_startPosition_lat + (newPosition_lat - marker.AT_startPosition_lat) * easingDurationRatio,lng:
                        marker.AT_startPosition_lng + (newPosition_lng - marker.AT_startPosition_lng) * easingDurationRatio};
                    if (googleMap != null && options.dragMap == 'stick') {
                        googleMap.setCenter(deltaPosition);
                        googleMap.setZoom(zoomLevel);
                    }
                    if (googleMap != null && options.drawRoute == 'draw') {
                        var coords = [];
                        coords.push(marker.b);
                        coords.push(deltaPosition);
                        
                        var lineString = new H.geo.LineString();
                        $.each(coords,function(i,val){
                            lineString.pushPoint(val);    
                        });
                        var line= new H.map.Polyline(lineString, { 
                            style: { 
                                lineWidth: 9,
                                strokeColor: "#244062",
                                strokeOpacity: 0.8 
                            }
                        })
                        googleMap.addObject(line);
                    }
                    marker.setGeometry(deltaPosition);
                    // use requestAnimationFrame if it exists on this browser. If not, use setTimeout with ~60 fps
                    if (window.requestAnimationFrame) {
                        marker.AT_animationHandler = window.requestAnimationFrame(function() {
                            animateStep(marker, startTime)
                        });
                    } else {
                        marker.AT_animationHandler = setTimeout(function() {
                            animateStep(marker, startTime)
                        }, 17);
                    }
        
                } else {
                    marker.setGeometry(newPosition);
        
                    if (typeof options.complete === 'function') {
                        options.complete();
                    }
        
                }
            }
        
            // stop possibly running animation
            if (window.cancelAnimationFrame) {
                window.cancelAnimationFrame(this.AT_animationHandler);
            } else {
                clearTimeout(this.AT_animationHandler);
            }
        
            animateStep(this, (new Date()).getTime());
        }
        
        
    </script>
    <style type="text/css">
        .tt_box {
            padding: 0px;
            border: 1px solid #dcdcdc;
            background: white;
            margin: 8px;
            border-radius: 4px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_box1 {
            padding: 0px;
            border: 1px solid #dcdcdc;
            background: white;
            margin: 8px;
            border-radius: 4px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_box_title {
            padding: 4px;
            text-align: center;
            background: #808080e3; /*#dcdcdc;*/
            color:white;
        }
        .tt_box_body{
            padding:8px;
        }
        .tt_card{
            padding: 0px 20px;
        }
        .tt_card_value{
            text-align: right;
            font-size: 12px;
            font-weight: 400;
            overflow: hidden;
            max-height: 20px;
        }
        .tt_card_title {
            text-align:right;
            font-size:12px;
            padding: 8px 0px;
        }
        .tt_card_row i {
            color: #244062;
            font-size: 32px;
            padding: 0px 0px;
        }
        .tt_card_row img {
            color: #244062;
            padding: 5px 0px;
        }
        .tt_card_row{
            background: #ffffff;
            border: 1px solid gainsboro;
            border-radius: 8px;
            padding: 8px;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
        }
        .tt_bottom_pane{
            margin: 0px;
            padding: 16px 0px;
            height:calc(100vh - 180px);
        }
        .tt_dd_value{
            font-size: 16px;
            font-weight: 600;
            text-align: right;
        }
        .tt_dd_label{
            font-size: 12px;
            color: gray;
            text-align: right;
        }
        .tt_os_received_time{
            font-size: 12px;
            color: gray;
            text-align: center;
        }
        .tt_os_location i {
            color: #3C969F;
            margin-right: 8px;
        }
        .tt_os_title{
            font-size: 12px;
            text-align: center;
        }
        .tt_os_location{
            text-align: center;
            overflow: hidden;
        }
        .tt_os_btn{
            min-width: 10px;
            padding: 4px 8px;
            font-size: 12px;
            color: #fff;
            text-align: center;
            
            border-radius: 4px;
            max-width: 100px;
            
            margin: 4px 0px;
        }
        .tt_ld_date{
            font-size: 12px;
            color: gray;
            margin-left: 24px;  
        }
        .tt_ld_address{
            display:block;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-box-orient: vertical;
            -webkit-line-clamp: 2;
        }
        .tt_ld_address i{
            color:#65b3f1;
            margin-right: 8px;
        }
        .tt_value{
            font-size: 16px;
            overflow: auto;
        }
        .tt_head{
            font-size: 12px;
            color: gray;
            margin-top: 8px;
        }
        .hide{
            display:none;
        }
        #googleMap {
            border: 1px solid #dcdcdc;
            box-shadow: 0px 0px 8px 4px #dcdcdc;
            border-radius: 4px;
        }
        .rt-tab-pane {
           display: block;
            max-height: calc(100vh - 226px);
            overflow-y: auto;
            padding: 8px;
            overflow-x: hidden;
        }
        .table-bordered.custom-blue-color > thead > tr > th, .table-bordered.custom-blue-color > tbody > tr > th, .table-bordered.custom-blue-color > tfoot > tr > th, .table-bordered.custom-blue-color > thead > tr > td, .table-bordered.custom-blue-color > tbody > tr > td, .table-bordered.custom-blue-color > tfoot > tr > td {
            border: 1px solid #cecbcb;
        }
        .custom-blue-color th {
            background: rgb(36, 64, 98);
            color: white;
        }
        .nav-tabs>li>a {
            margin-right: 2px;
            line-height: 1.42857143;
            border: 1px solid transparent;
            border-radius: 4px 4px 0 0;
            padding: 2px 8px;
        }
        .no-padding{
            padding-left:2px;
            padding-right:2px;
        }
        .tt_click{
            cursor:pointer;
        }
        .tt_click:hover{
            background:#fbf9f9;
        }
    </style>
  </body>
</html>