<div id="map" style="height: 500px;"></div>
<div class="box-footer map-footer">
  <table style="color: #222d32;font-weight: 1000;-webkit-text-stroke: .25px #ffffff;background: linear-gradient(to right,#fff,#ffffff05 100%);width: auto;">
    <tbody>
      <tr>
        <td class="map_route_distance"></td>
      </tr>
      <tr>
        <td class="map_route_duration"></td>
      </tr>
    </tbody>
  </table>
</div>
<?php
$cntrylatlng['ulat'] = 20.5937;
$cntrylatlng['ulng'] = 78.9629;
if ($this->session->userdata("user_id") !== FALSE) {
  $lguid = $this->session->userdata("user_id");
  $cntrylatlng = getLogUserLatLng($lguid);
}
?>
<?php if (!empty($stops)): ?>
  <?php foreach ($stops as $index => $s): ?>
    <span class="shipstopopen"
      data-lat="<?php echo $s['plat']; ?>"
      data-lng="<?php echo $s['plng']; ?>"
      <?php if (isset($s['dlat'])): ?>
      data-dlat="<?php echo $s['dlat']; ?>"
      data-dlng="<?php echo $s['dlng']; ?>"
      <?php endif; ?>
      data-place="<?php echo $s['stopname']; ?>"
      data-tmode="<?php echo $s['tmode']; ?>">
    </span>
  <?php endforeach; ?>
<?php endif; ?>


<script type="text/javascript">
  var ulglat = <?php echo $cntrylatlng['ulat']; ?>;
  var ulglng = <?php echo $cntrylatlng['ulng']; ?>;
  var points = [];
  var map;
  var directionsService;
  var directionsRenderer;
  var markers = [];
  var polylines = [];


  //  $(document).ready(function(){
  $(".shipstopopen").each(function(index) {
    let point = {
      "lat": $(this).data("lat"),
      "lng": $(this).data("lng"),
      "place": $(this).data("place"),
      'tmode': $(this).data('tmode')
    };

    points.push(point);

   if (index === $(".shipstopopen").length - 1 && $(this).data("dlat") !== undefined && $(this).data("dlng") !== undefined) {
      points.push({
        "lat": $(this).data("dlat"),
        "lng": $(this).data("dlng"),
        "place": $(this).data("place") + " (Dest)",
        'tmode': $(this).data('tmode')
      });
    }
  });
console.log(points[0].lat);console.log(points[0].lng);
console.log(points[points.length - 1].lat);console.log(points[points.length - 1].lng);
    var mainStart = points.length ? new google.maps.LatLng(points[0].lat, points[0].lng) : null;
    var mainEnd = points.length ? new google.maps.LatLng(points[points.length - 1].lat, points[points.length - 1].lng) : null;
    
  // });
  function initMap() {
    directionsService = new google.maps.DirectionsService;
    directionsDisplay = new google.maps.DirectionsRenderer;
    map = new google.maps.Map(document.getElementById('map'), {
      zoom: 4,
      center: {
        lat: ulglat,
        lng: ulglng
      },
      disableDefaultUI: true,
      styles: [{
        featureType: "all",
        stylers: [{
          saturation: 0
        }, {
          hue: "#e7ecf0"
        }]
      }, {
        featureType: "road",
        stylers: [{
          saturation: -70
        }]
      }, {
        featureType: "transit",
        stylers: [{
          visibility: "off"
        }]
      }, {
        featureType: "poi",
        stylers: [{
          visibility: "off"
        }]
      }, {
        featureType: "water",
        stylers: [{
          visibility: "simplified"
        }, {
          saturation: -60
        }]
      }]
    });
    directionsDisplay.setMap(map);
    console.log(points);
    if (points.length == 2) {
      calculateAndDisplayRoute(directionsService, directionsDisplay, map);
    } else {
      plotroute();
    }
  }

  function plotroute() {
    if (!points.length) return;

    clearPolylines();
    clearBranchMarkers();

    let bounds = new google.maps.LatLngBounds();
    console.log(mainStart);
    console.log(mainEnd);
    if (mainStart && mainEnd) {
      bounds.extend(mainStart);
      bounds.extend(mainEnd);
    }

    for (let i = 0; i < points.length - 1; i++) {
      let start = new google.maps.LatLng(points[i].lat, points[i].lng);
      let end = new google.maps.LatLng(points[i + 1].lat, points[i + 1].lng);
      let tmode = points[i].tmode;

      // Extend bounds to include both points
     /* bounds.extend(start);
      bounds.extend(end);*/

      // Add markers for start & end of segment
      const startMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: points[i].place,
        icon: getMarkerIcon(tmode, "start")
      });
      markers.push(startMarker);

      const endMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: points[i + 1].place,
        icon: getMarkerIcon(tmode, "end")
      });
      markers.push(endMarker);

      // Draw path based on transport mode
      if (tmode === "FTL" || tmode === "LTL") {
        const startMarker = new google.maps.Marker({
          position: start,
          map: map,
          title: "Pickup Location",
          icon: {
            url: "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>",
            scaledSize: new google.maps.Size(25, 25)
          }
        });
        markers.push(startMarker);
        const endMarker = new google.maps.Marker({
          position: end,
          map: map,
          title: "Delivery Location",
          icon: {
            url: "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
            scaledSize: new google.maps.Size(25, 25)
          }
        });
        markers.push(endMarker);
        // Road transport (Driving)
        const request = {
          origin: start,
          destination: end,
          travelMode: google.maps.TravelMode.DRIVING
        };
        directionsService.route(request, function(result, status) {
          if (status === google.maps.DirectionsStatus.OK) {
            directionsRenderer.setDirections(result);
            fitBoundsZoom(start, end);
          } else {
            alert("Unable to plot road route.");
          }
        });
      } else if (tmode === "RAIL") {

      const railStartMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railStartMarker);

      const railEndMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railEndMarker);

      const railPath = new google.maps.Polyline({
        path: [start, end],
        geodesic: true,
        strokeColor: "#007400",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: map
      });

      polylines.push(railPath);

      let count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;

        const icons = railPath.get('icons');
        icons[0].offset = (count / 2) + '%';
        railPath.set('icons', icons);
      }, 100);
    } else if (tmode === "AIR") {
        
        // Animated dashed line for AIR
        const airPath = new google.maps.Polyline({
          path: [start, end],
          geodesic: true,
          strokeColor: "#7b1c1cff",
          strokeOpacity: 0,
          strokeWeight: 1,
          icons: [{
            icon: {
              path: "M 0,-1 0,1",
              strokeOpacity: 1,
              scale: 4
            },
            offset: "0",
            repeat: "20px"
          }],
          map: map
        });
        polylines.push(airPath);

        let count = 0;
        window.setInterval(() => {
          count = (count + 1) % 200;
          const icons = airPath.get("icons");
          icons[0].offset = (count / 2) + "%";
          airPath.set("icons", icons);
        }, 100);
      }
    }

    map.fitBounds(bounds);
  }

  // Utility: returns marker icon based on mode & position
  function getMarkerIcon(tmode, position) {
    if (tmode === "FTL" || tmode === "LTL") {
      return {
        url: position === "start" ?
          "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>" : "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
        scaledSize: new google.maps.Size(25, 25)
      };
    } else if (tmode === "RAIL") {
      return {
        url: "https://img.icons8.com/ios-filled/50/train.png",
        scaledSize: new google.maps.Size(25, 25)
      };
    } else if (tmode === "AIR") {
      return {
        url: position === "start" ?
          "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png" : "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
        scaledSize: new google.maps.Size(25, 25)
      };
    }
  }


  function clearPolylines() {
    if (polylines && polylines.length) {
      polylines.forEach(p => p.setMap(null)); // remove from map
    }
    polylines = [];
  }

  function clearBranchMarkers() {
    markers.forEach(marker => marker.setMap(null));
    markers.length = 0;
  }

  function calculateAndDisplayRoute(directionsService, directionsDisplay, map) {
    var tmode = points[0].tmode;
    var startLat = points[0].lat;
    var startLng = points[0].lng;
    var endLat = points[points.length - 1].lat;
    var endLng = points[points.length - 1].lng;
    if (directionsRenderer) {
      directionsRenderer.setMap(null);
    }
    directionsRenderer = new google.maps.DirectionsRenderer({
      suppressMarkers: true
    });
    directionsRenderer.setMap(map);

    clearPolylines();
    clearBranchMarkers();


    const start = new google.maps.LatLng(startLat, startLng);
    const end = new google.maps.LatLng(endLat, endLng);


    if (tmode === "FTL" || tmode === "LTL") {
      const startMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "Pickup Location",
        icon: {
          url: "<?php echo base_url('assets/images/icons/blue_marker.png'); ?>",
          scaledSize: new google.maps.Size(25, 25)
        }
      });
      markers.push(startMarker);

      const endMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "Delivery Location",
        icon: {
          url: "<?php echo base_url('assets/images/icons/green_marker.png'); ?>",
          scaledSize: new google.maps.Size(25, 25)
        }
      });
      markers.push(endMarker);
      // Road transport (Driving)
      const request = {
        origin: start,
        destination: end,
        travelMode: google.maps.TravelMode.DRIVING
      };

      directionsService.route(request, function(result, status) {
        if (status === google.maps.DirectionsStatus.OK) {
          directionsRenderer.setDirections(result);
          fitBoundsZoom(start, end);
        } else {
          alert("Unable to plot road route.");
        }
      });

    } else if (tmode === "RAIL") {

      const railStartMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railStartMarker);

      const railEndMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railEndMarker);

      const railPath = new google.maps.Polyline({
        path: [start, end],
        geodesic: true,
        strokeColor: "#007400",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: map
      });

      polylines.push(railPath);

      let count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;

        const icons = railPath.get('icons');
        icons[0].offset = (count / 2) + '%';
        railPath.set('icons', icons);
      }, 100);
    } else if (tmode === "AIR") {

      const airStartMarker = new google.maps.Marker({
        position: end,
        map: map,
        title: "AIRPORT",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
          scaledSize: new google.maps.Size(30, 30)
        }
      });

      markers.push(airStartMarker);

      const airEndMarker = new google.maps.Marker({
        position: start,
        map: map,
        title: "AIRPORT",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
          scaledSize: new google.maps.Size(30, 30)
        }
      });

      markers.push(airEndMarker);

      const airPath = new google.maps.Polyline({
        path: [end, start],
        geodesic: true,
        strokeColor: "#7b1c1cff",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: map
      });
      polylines.push(airPath);

      let count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;

        const icons = airPath.get('icons');
        icons[0].offset = (count / 2) + '%'; // shift dots
        airPath.set('icons', icons);
      }, 100); // adjust speed here
      fitBoundsZoom(start, end);
    }
  }

  initMap();
</script>
</body>

</html>