<?php
if (isset($errors) && !empty($errors)) {
    foreach ($errors as $error) {
        echo "<p class='alert alert-danger'>$error</p>";
    }
    exit();
}
?>
<ul class="nav nav-tabs">
    <li class="active"><a data-toggle="tab" href="#home"> <?= $this->lang->line('driver_link'); ?></a></li>
    <li><a data-toggle="tab" href="#menu1"><?= $this->lang->line('carrier_link'); ?></a></li>
</ul>
<div class="tab-content">
    <div id="home" class="tab-pane fade in active">
        <div>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-12 control-label"><?= $this->lang->line('link_sharing'); ?></label>
            </div>

            <div class="row">
                <div class="form-group">
                    <div class="col-sm-10">
                        <input type="text" name="link_share" id="link_share" value="<?= $link_id; ?>" placeholder="Secure Link" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info copy_button" id="copy_button" onclick="copy_sharable_link('link_share')"><?= $this->lang->line('copy_link'); ?></button>
                </div>
            </div>
            <div class="row" style="margin-top: 50px;">
                <div class="form-group">
                    <div class="col-sm-8">
                        <input type="text" name="mobile_link" id="mobile_link" placeholder="<?= $this->lang->line('general_enter') . ' ' . $this->lang->line('sms_placeholder_carrier'); ?>" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info"><?= $this->lang->line('via_sms'); ?></button>
                    <button class="col-sm-2 btn btn-info"><?= $this->lang->line('via_whatsapp'); ?></button>
                </div>
            </div>

            <div class="row" style="margin-top: 50px;">
                <div class="form-group">
                    <div class="col-sm-10">
                        <input type="text" name="email_id_link" id="email_id_link" placeholder="<?= $this->lang->line('general_enter') . ' ' . $this->lang->line('truckowner_emailaddr'); ?>" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info" onclick="sendemail('link_share', 'email_id_link', this, 'driver', '<?= $voyage_number ?>')"><?= $this->lang->line('via_email'); ?></button>
                </div>
            </div>
            <div class="box-footer">
            </div>
        </div>
    </div>
    <div id="menu1" class="tab-pane fade">
        <div>
            <div class="form-group">
                <label for="inputEmail3" class="col-sm-12 control-label"><?= $this->lang->line('link_sharing'); ?></label>
            </div>

            <div class="row">
                <div class="form-group">
                    <div class="col-sm-10">
                        <input type="text" name="link_share1" id="link_share1" value="<?= $carrier_link_id; ?>" placeholder="Secure Link" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info copy_button" id="copy_button" onclick="copy_sharable_link('link_share1')"><?= $this->lang->line('copy_link'); ?></button>
                </div>
            </div>
            <div class="row" style="margin-top: 50px;">
                <div class="form-group">
                    <div class="col-sm-8">
                        <input type="text" name="mobile_link1" id="mobile_link1" placeholder="Enter phone numbers" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info"><?= $this->lang->line('via_sms'); ?></button>
                    <button class="col-sm-2 btn btn-info"><?= $this->lang->line('via_whatsapp'); ?></button>
                </div>
            </div>

            <div class="row" style="margin-top: 50px;">
                <div class="form-group">
                    <div class="col-sm-10">
                        <input type="text" name="email_id_link1" id="email_id_link1" placeholder="Enter email addresses" class="form-control">
                    </div>
                    <button class="col-sm-2 btn btn-info" onclick="sendemail('link_share1', 'email_id_link1', this, 'carrier', '<?= $voyage_number ?>')"><?= $this->lang->line('via_email'); ?></button>
                </div>
            </div>
            <div class="box-footer">
            </div>
        </div>
    </div>
</div>

<script  type="text/javascript">
    function copy_sharable_link(id) {
        var copyText = $("#" + id)[0];
        /* Select the text field */
        copyText.select();
        copyText.setSelectionRange(0, 99999); /*For mobile devices*/
        document.execCommand("copy");
        $("#copy_button").text('Copied');
    }
</script>

<script  type="text/javascript">
    function sendemail(message, recipient, ref, link_type, voyage_number) {
        let msg = $('#' + message).val();
        let emails = $('#' + recipient).val();
        $.ajax({
            url: "<?= base_url('visibility/sent_secure_link_email') ?>",
            type: "POST",
            async: false,
            data: {message: msg, recipient: emails, link_type: link_type, voyage_number: voyage_number},
            beforeSend: function () {
                $(ref).prop('disable', true);
            },
            success: function (data) {
                $('#' + recipient).val('');
                alert('Mail sent successfully');
                $(ref).prop('disable', false);
            }, error: function () {
                $(ref).prop('disable', false);
            }
        });
    }
</script>
