<div class="content-page">
    <div class="content" style="background-color: #dddfe4; padding-top:3%;">
        <div class="container">
            <div class="col-md-12">
                <div class="filter-section tab_list_col">
                    <!-- Nav tabs -->
                    <div class="col-sm-8 pd-left-0">
                        <ul id="tabs" class="nav nav-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#details" role="tab" data-toggle="tab"><small><i class="glyphicon glyphicon-home"></i></small><?= $this->lang->line('quick_rates') ?> </a></li>
                        </ul>
                    </div>
                    <form method="POST" id="quickRatesForm" action="<?= site_url('KNeTNQuickRates/serviceAndLaneInsert'); ?>" onsubmit="return saveServiceAndLane(this);">
                        <div class="col-sm-3">
                            <div class="view_moretab text-right">
                                <button type="reset" name="reset" class="btn btn-default btn_color ">
                                    <a style="color: white;" href="<?= base_url('KNeTNQuickRates') ?>"><?= $this->lang->line('general_cancel') ?></a>
                                </button>
                                <button type="submit" id="submit" name="submit" class="btn btn-default btn_color">
                                    <a style="color: white;"><?= $this->lang->line('general_save') ?></a>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="col-sm-1  postiontop">
                        <div class="view_moretab text-right">
                            <div class="dropdown">
                                <button class="dropbtn">
                                    <span class="icon tru-icon-quick-menu"></span>
                                </button>
                                <div class="dropdown-content">
                                    <?php   $base_url = base_url();
                                    $file = $base_url."assets/ordertemplate/RateExcelTemplate.xlsx";
                                    if(file_exists("assets/ordertemplate/RateExcelTemplate.xlsx")){
                                        $imglink =$file;
                                    }
                                    ?>
                                    <a href="<?= $imglink ?>"><i class="icon tru-icon-template"></i><?= $this->lang->line('order_template') ?></a>
                                    <a href="#" id='buttonid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('upload_excel'); ?></a>
                                    <form
                                        action="<?= base_url(); ?>Ratemanagementexcel/index"
                                        id="excelform" method="POST" enctype="multipart/form-data">
                                        <input type="file" name="import_file" id="exlfile"
                                               onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                               style="display: none">
                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="wrap-contact2 shadow-lg p-3 mb-5 bg-white rounded">
                            <center><h5 style="color: #fff;background-color: rgba(21, 45, 84, 1); padding-top:5px; padding-bottom:5px;"><?= $this->lang->line('service_attributes') ?></h5></center>
                            <div class="row" style=" border: 5px solid white;">
                                <div class="row">
                                    <div class="col-md-6 design-color">
                                        <input type="hidden" form="quickRatesForm" name="rate_lane_id" id="rate_lane_id" value="">
                                        <input type="hidden" form="quickRatesForm" name="rate_ser_id" id="rate_ser_id" value="">
                                        <?php $listType = $listType ?? ''; ?>
                                        <input type="hidden" name="listType" id="listType" value="<?= $listType ?>" form="quickRatesForm">
                                        <div class="form-group">
                                            <label for="serviceId"><?= $this->lang->line('rate_service_id') ?></label>
                                            <input type="text" readonly class="form-control" form="quickRatesForm" name="serviceId" id="serviceId" value="" autocomplete="off">
                                        </div>
                                        <div class="form-group">
                                            <label for="serviceName"><?= $this->lang->line('rate_service_name') ?> *</label>
                                            <input type="text" class="form-control" form="quickRatesForm" name="serviceName" id="serviceName" value="" autocomplete="off">
                                        </div>
                                        <?php
                                        $service_type = getServiceMasterData(); ?>
                                        <div class="form-group">
                                            <label for="serviceType"><?= $this->lang->line('service_type') ?> *</label>
                                            <select name="serviceType" form="quickRatesForm"
                                                    id="serviceType" class="form-control">
                                                <option value="">Select</option>
                                                <?php
                                                if (!empty($service_type)) {
                                                    foreach ($service_type as $res) { ?>
                                                        <option value="<?= $res['row_id']; ?>"><?= $res['id'] . "-" . $res['name']; ?></option>
                                                        <?php
                                                    }
                                                } ?>
                                            </select>
                                        </div>
                                        <?php
                                        $products = getProductMasterData(); ?>
                                        <div class="form-group">
                                            <label for="product"><?= $this->lang->line('bpartner_product') ?></label>
                                            <select form="quickRatesForm" name="product" id="product" class="form-control">
                                                <option value="">Select</option>
                                                <?php
                                                if (!empty($products)) {
                                                    foreach ($products as $res) {
                                                        ?>
                                                        <option value="<?= $res['name']; ?>"> <?= $res['name']; ?></option>
                                                        <?php
                                                    }
                                                } ?>
                                            </select>
                                        </div>
                                        <div class="row form-group">
                                            <div class="col-sm-4">
                                                <label for="minimumDistance"><?= $this->lang->line('duration') ?> *</label>
                                                <input type="text" class="form-control" form="quickRatesForm" name="days" id="days" placeholder="Days" value="" autocomplete="off">
                                            </div>
                                            <div class="col-sm-4">
                                                <label>&nbsp;</label>
                                                <input type="text" class="form-control" form="quickRatesForm" name="hours" id="hours" placeholder="Hrs" value="" autocomplete="off">
                                            </div>
                                            <div class="col-sm-4">
                                                <label>&nbsp;</label>
                                                <input type="text" class="form-control" form="quickRatesForm" name="minutes" id="minutes" placeholder="Mins" value="" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 design-color">
                                        <div class="form-group">
                                            <label for="laneId"><?= $this->lang->line('lane_id') ?> *</label>
                                            <select class="form-control" name="laneId" id="laneId" form="quickRateForm">
                                                <option value="">Select</option>
                                                <?php
                                                if (!empty($lane)) {
                                                    foreach ($lane as $lane_r) {
                                                        ?>
                                                        <option value="<?= $lane_r['lane_id']; ?>"> <?= $lane_r['lane_id'] . "-" . addslashes($lane_r['lane_name']); ?></option>

                                                        <?php
                                                    }
                                                } ?>
                                            </select>
                                        </div>
                                        <input type="hidden" form="quickRatesForm" name="lanesId" id="lanesId" value="">

                                        <div class="form-group">
                                            <label for="sourceGeo"><?= $this->lang->line('source_geo') ?></label>
                                            <input type="text" readonly class="form-control" form="quickRatesForm" name="sourceGeo" id="sourceGeo" value="" autocomplete="off">
                                        </div>

                                        <div class="form-group">
                                            <label for="source"><?= $this->lang->line('general_source'); ?></label>
                                            <input type="text" readonly class="form-control" form="quickRatesForm" name="source" id="source" value="" autocomplete="off">
                                        </div>
                                        <div class="form-group">
                                            <label for="destinationGeo"><?= $this->lang->line('destination_geo') ?></label>
                                            <input type="text" readonly class="form-control" form="quickRatesForm" name="destinationGeo" id="destinationGeo" value="" autocomplete="off">
                                        </div>
                                        <div class="form-group">
                                            <label for="destination"><?= $this->lang->line('bpartner_destination') ?></label>
                                            <input type="text" readonly class="form-control" form="quickRatesForm" name="destination" id="destination" value="" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="wrap-contact2 shadow-lg p-3 mb-5 bg-white rounded">
                            <center><h5 style="color: #fff;background-color: rgba(21, 45, 84, 1); padding-top:5px; padding-bottom:5px;"><?= $this->lang->line('rate_attributes') ?></h5></center>
                            <div class="row" style=" border: 5px solid white;">
                                <div class="row">
                                    <div class="col-md-6 design-color">
                                        <div class="form-group">
                                            <label for="tariffType"><?= $this->lang->line('tariff_type') ?> *</label>
                                            <select name="tariffType" id="tariffType" class="form-control" form="quickRatesForm">
                                                <option value="">Select</option>
                                                <option value="BUY"><?= $this->lang->line('general_buy') ?></option>
                                                <option value="SELL"><?= $this->lang->line('general_sell') ?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="effectiveDate"><?= $this->lang->line('general_effective_date') ?> *</label>
                                            <input type="text" autocomplete="off" name="effectiveDate" id="effectiveDate" value="" placeholder="<?= $this->lang->line('general_effective_date') ?>" class="form-control" form="quickRatesForm">
                                            <span class="calc"><i class="icon tru-icon-calendar"></i></span>
                                        </div>
                                        <div class="form-group">
                                            <label for="expiryDate"><?= $this->lang->line('general_expiry_date'); ?> *</label>
                                            <input type="text" autocomplete="off" name="expiryDate" id="expiryDate" value="" placeholder="<?= $this->lang->line('general_expiry_date') ?>" class="form-control" form="quickRatesForm">
                                            <span class="calc"><i class="icon tru-icon-calendar"></i></span>


                                        </div>
                                        <div class="input-group">
                                            <label for="vendorProfile"><?= $this->lang->line('vendor_profile'); ?> </label>
                                            <input form="quickRatesForm" type="text" name="vendorProfile" class="form-control add_book Txtfld" id="vendorProfile" value="" onkeyup="upper(this);" size="20">
                                            <div class="input-group-btn" id="vendorProfileId">
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a href="#" title="List" id="viewvendorpflist" onclick="getvendorpflist(event,'list')"> <i class="icon tru-icon-tender-list"></i></a>
                                                </button>
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a title="Search" href="#" id="searchvendorpfbranch" onclick="getvendorpflist(event,'search')"> <i class="icon tru-icon-search"></i> </a>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="input-group customerDiv">
                                            <label for="customerProfile"><?= $this->lang->line('cust_profile'); ?> </label>
                                            <input form="quickRatesForm" type="text" name="customerProfile" class="form-control add_book Txtfld" id="customerProfile" value="" onkeyup="upper(this);" size="20">
                                            <div class="input-group-btn" id="customerProfileId">
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a href="#" title="List" id="viewcustomerpflist" onclick="getcustomerpflist(event,'list')"> <i class="icon tru-icon-tender-list"></i></a>
                                                </button>
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a title="Search" href="#" id="searchcustomerpfbranch" onclick="getcustomerpflist(event,'search')"> <i class="icon tru-icon-search"></i> </a>
                                                </button>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-6 design-color">
                                        <div class="input-group">
                                            <label for="vehicleProfile"><?= $this->lang->line('vehicle_profile'); ?> </label>
                                            <input form="quickRatesForm" type="text" name="vehicleProfile" class="form-control add_book Txtfld" id="vehicleProfile" value="" onkeyup="upper(this);" size="20">
                                            <div class="input-group-btn">
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a href="#" title="List" id="viewvehiclepflist" onclick="getvehiclepflist(event,'list')"> <i class="icon tru-icon-tender-list"></i></a>
                                                </button>
                                                <button class="btn " type="button" data-placement="top" data-toggle="modal">
                                                    <a title="Search" href="#" id="searchvehiclepfbranch" onclick="getvehiclepflist(event,'search')"> <i class="icon tru-icon-search"></i> </a>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label for="conversionFactor"><?= $this->lang->line('conversion_factor') ?></label>
                                            <select form="quickRatesForm" id="conversionFactor" name="conversionFactor" class="form-control">
                                                <option value="">Select</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="active"><?= $this->lang->line('general_active') ?></label>
                                            <input type="checkbox" name="active" id="active" class="chkbxcolor" form="quickRatesForm">
                                        </div>
                                        <div class="form-group">
                                            <label for="quote"><?= $this->lang->line('quote') ?></label>
                                            <input type="checkbox" name="quote" id="quote" class="chkbxcolor" form="quickRatesForm">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white mb70">
                        <div class="main-datatable">
                            <input type="hidden" form="quickRatesForm" name="rate_r_id" id="rate_r_id" value="">
                            <!--                            <input type="hidden" form="rate_r_data" name="rate_r_id" id="rate_r_id" value=""> -->
                            <input type="hidden" form="quickRatesForm" name="rate_r_con_id" id="rate_r_con_id" value="">
                            <input type="hidden" form="quickRatesForm" name="rate_r_charge_id" id="rate_r_charge_id" value="">
                            <input type="hidden" form="quickRatesForm" name="service_id" id="service_id" value="">
                            <div class="table-responsive minheight">
                                <table
                                    class="table table-striped table-bordered table_bg "
                                    style="background-color: #CCE1F6; width: 100%;"
                                    id="chr_list">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th><?= $this->lang->line('charge_type'); ?></th>
                                        <th><?= $this->lang->line('tier_id'); ?></th>
                                        <th><?= $this->lang->line('geo_tier_id'); ?></th>
                                        <th><?= $this->lang->line('charge_id'); ?></th>
                                        <th><?= $this->lang->line('exchange_rate') . " " . $this->lang->line('general_id'); ?> </th>
                                        <th><?= $this->lang->line('charge_basis'); ?></th>
                                        <th><?= $this->lang->line('min_amount'); ?></th>
                                        <th><?= $this->lang->line('general_amount'); ?></th>
                                        <th><?= $this->lang->line('fuel_surcharge'); ?></th>
                                        <th><?= $this->lang->line('general_currency'); ?></th>


                                    </tr>
                                    </thead>
                                    <tbody style="background-color: white;"
                                           id="addcustref"></tbody>
                                </table>
                                <!--close-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Vendor Profile List -->
<div class="modal fade" id="view_vendorpf">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_vendorpf_title"><?= $this->lang->line('vendor_profile') . ' ' . $this->lang->line('bpartner_plist'); ?></h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box">
                    <table class="table table-striped table-bordered" width="100%" id="vendorpftbl">
                        <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?= $this->lang->line('vendor_profile') . ' ' . $this->lang->line('general_id'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_name'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_company_code'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_branch_code'); ?></th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light" onclick="selectvendorpfinlist()"><?= $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- Customer Profile List -->
<div class="modal fade" id="view_customerpf">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_customerpf_title"><?= $this->lang->line('party_details'); ?></h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box">
                    <table class="table table-striped table-bordered" width="100%" id="customerpftbl">
                        <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?= $this->lang->line('customer_profile') . ' ' . $this->lang->line('general_id'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_name'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_company_code'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_branch_code'); ?></th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light" onclick="selectcustomerpfinlist()"><?= $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- Vehicle Profile List -->
<div class="modal fade" id="view_vehiclepf">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="closevalues close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="view_vehiclepf_title"><?= $this->lang->line('vehicle_profile') . ' ' . $this->lang->line('bpartner_plist'); ?></h4>
            </div>
            <div class="modal-body ">
                <div class="box custom-box">
                    <table class="table table-striped table-bordered" width="100%" id="vehiclepftbl">
                        <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col"><?= $this->lang->line('vehicle_profile') . ' ' . $this->lang->line('general_id'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_name'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_company_code'); ?></th>
                            <th scope="col"><?= $this->lang->line('general_branch_code'); ?></th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default waves-effect btn_color resetbtn" data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                <button type="button" class="selectpopup btn btn-primary  btn_color waves-effect waves-light" onclick="selectvehiclepfinlist()"><?= $this->lang->line('general_select'); ?></button>
            </div>
        </div>
    </div>
</div>
</div>
<div class="modal fade insert_success_div" id="insert_success_div" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header success_message_header">
            </div>
            <div class="modal-body">
                <p style="font-size: 19px;"><span class="glyphicon glyphicon-ok-circle popup_circle" style="font-size: 22px;
    color: green;"></span>&nbsp;<span class="pop_message"><?= $this->lang->line('insert_message'); ?></span></p>
            </div>
            <div class="modal-footer success_message_footer">
                <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal"><?= $this->lang->line('general_ok'); ?></button>
                <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
            </div>

        </div>
    </div>
</div>
<div class="modal containerModal" id="orders_success_list" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" style="font-weight: bold;"><?= $this->lang->line('rates') . ' ' . $this->lang->line('bpartner_plist'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table  class="table table-striped table-bordered" id="orderssucces_list">
                    <thead>

                    <th><?= $this->lang->line('rate_service') ?> <?= $this->lang->line('general_id') ?></th>
                    <th><?= $this->lang->line('rate_offering') ?> <?= $this->lang->line('general_id') ?></th>
                    <th><?= $this->lang->line('rate_record') ?> <?= $this->lang->line('general_id') ?></th>

                    </thead>
                    <tbody>
                    <?php if(!empty($excelUploadData)) {
                        foreach($excelUploadData as $ord){ ?>
                            <tr>
                                <td><?= $ord->serviceId ?></td>
                                <td><?= $ord->offeringId ?></td>
                                <td><?= $ord->recordId ?></td>
                            </tr>
                        <?php } } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<style>
    .wrap-contact2 {
        background: #ffffff;
        overflow: hidden;
        padding: 10px 21px 8px;
        height: 440px;
    }

    .calc {
        position: absolute;
        right: 0;
        top: 26px;
        border-left: 1px solid #ccc;
        width: 32px;
        height: 32px;
        background: none;
        text-align: center;
        padding: 6px 0px;
    }
    #insert_success_div{
        width: 85%;
        margin-left:60px;
    }

    .disableLegsTable {
        background-color: #fdfbfb;
        pointer-events: none;
        opacity: 0.3;
    }

</style>
<script src="<?= base_url(); ?>assets/js/knquickrates.js"></script>
<link href="<?= base_url() ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css"/>
<script src="<?= base_url() ?>assets/newtheme/js/custom.js"></script>
<script src="<?= base_url() ?>assets/newtheme/js/main.js"></script>
<script src="<?= base_url() ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url(); ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<script
    src="<?= base_url(); ?>assets/js/businesspartners_script.js"></script>

<script>
    $(document).ready(function () {
        $('#effectiveDate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        });
        $('#expiryDate').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        });
        var table = $('#chr_list').DataTable({
            "bPaginate": true,
            "paging": true,
            "bLengthChange": true,
            "bFilter": false,
            "bInfo": false,
            "bAutoWidth": true,
            "language": {
                "lengthMenu": '<select class="form-control">' +
                    '<option value="10">10</option>' +
                    '<option value="20">20</option>' +
                    '<option value="30">30</option>' +
                    '<option value="40">40</option>' +
                    '<option value="50">50</option>' +
                    '<option value="-1">All</option>' +
                    '</select>'
            },
            dom: 'Blfrtip',
            buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
                'print'
            ],
        });
        table
            .clear()
            .draw();
        var a = '<ul class="nav nav-tabs"><li class="dropdown"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu">';
        var b =
            '<li><a id="bAdd" type="button" class="btn btn-sm btn-default" onclick="rowaddCharges(this);">' +
            '<span class="glyphicon glyphicon-plus" > </span>' +
            'Add New' +
            '</a></li>';
        var c = '</ul></li></ul>';
        $('#chr_list .dataTables_empty').html(a + b + c);

    });


    function getvendorpflist(e, type) {
        e.preventDefault();
        var table = $('#vendorpftbl').DataTable();
        var value = $('#vendorProfile').val();
        if (type == 'search' && value == '') {
            gettoast('top-right', 'vendor_profile_id', 'Enter Vendor Profile ID');
            return false;
        }
        var company_code = $('#company_code').val();
        var branch_code = $('#branch_code').val();
        var senddata = {'company_code': company_code, 'branch_code': branch_code};
        if (type == "search") {
            senddata = {'company_code': company_code, 'branch_code': branch_code, 'term': value};
        }
        table.destroy();
        $("#view_vendorpf").modal('show');
        $("#view_vendorpf_title").html('Vendor Profiles list');
        $.ajax({
            url: baseurl + 'rateoffering/getvendorpflist',
            type: "POST",
            data: senddata,
            dataType: 'JSON',
            success: function (data) {
                $("#vendorpftbl").DataTable({
                    data: data,
                    "bPaginate": true,
                    "paging": true,
                    "bLengthChange": true,
                    "bFilter": true,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                            '<option value="10">10</option>' +
                            '<option value="20">20</option>' +
                            '<option value="30">30</option>' +
                            '<option value="40">40</option>' +
                            '<option value="50">50</option>' +
                            '<option value="-1">All</option>' +
                            '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                    "columns": [
                        {"data": "check"},
                        {"data": "vend_profile_id"},
                        {"data": "name"},
                        {"data": "company_code"},
                        {"data": "branch_code"}
                    ],
                });
            }
        });
    }

    function selectvendorpf(id) {
        $('.selectvendor').attr('onclick', 'selectvendorpfinlist()');
        $('.listvendorpf').removeClass('selectedvendorpf-list');
        $('#listvendorpf_' + id).addClass('selectedvendorpf-list');
    }

    function selectvendorpfinlist() {
        $('#view_vendorpf').modal('hide');
        var id = $('.selectedvendorpf-list').val();
        $('#vendorProfile').val(id);
    }

    function getcustomerpflist(e, type) {
        e.preventDefault();
        var table = $('#customerpftbl').DataTable();
        var value = $('#customerProfile').val();
        if (type == 'search' && value == '') {
            gettoast('top-right', 'customer_profile_id', 'Enter Customer Profile ID');
            return false;
        }
        var company_code = $('#company_code').val();
        var branch_code = $('#branch_code').val();
        var senddata = {'company_code': company_code, 'branch_code': branch_code};
        if (type == "search") {
            senddata = {'company_code': company_code, 'branch_code': branch_code, 'term': value};
        }
        table.destroy();
        $("#view_customerpf").modal('show');
        $("#view_customerpf_title").html('Customer Profiles list');
        $.ajax({
            url: baseurl + 'rateoffering/getcustomerpflist',
            type: "POST",
            data: senddata,
            dataType: 'JSON',
            success: function (data) {
                $("#customerpftbl").DataTable({
                    data: data,
                    "bPaginate": true,
                    "paging": true,
                    "bLengthChange": true,
                    "bFilter": true,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                            '<option value="10">10</option>' +
                            '<option value="20">20</option>' +
                            '<option value="30">30</option>' +
                            '<option value="40">40</option>' +
                            '<option value="50">50</option>' +
                            '<option value="-1">All</option>' +
                            '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                    "columns": [
                        {"data": "check"},
                        {"data": "cust_profile_id"},
                        {"data": "name"},
                        {"data": "company_code"},
                        {"data": "branch_code"}
                    ],
                });
            }
        });
    }

    function selectcustomerpf(id) {
        $('.selectcustomer').attr('onclick', 'selectcustomerpfinlist()');
        $('.listcustomerpf').removeClass('selectedcustomerpf-list');
        $('#listcustomerpf_' + id).addClass('selectedcustomerpf-list');
    }

    function selectcustomerpfinlist() {
        $('#view_customerpf').modal('hide');
        var id = $('.selectedcustomerpf-list').val();
        $('#customerProfile').val(id);
    }

    function getvehiclepflist(e, type) {
        e.preventDefault();
        var table = $('#vehiclepftbl').DataTable();
        var value = $('#vehicleProfile').val();
        if (type == 'search' && value == '') {
            gettoast('top-right', 'vehicle_profile_id', 'Enter Vendor Profile ID');
            return false;
        }
        var company_code = $('#company_code').val();
        var branch_code = $('#branch_code').val();
        var senddata = {'company_code': company_code, 'branch_code': branch_code};
        if (type == "search") {
            senddata = {'company_code': company_code, 'branch_code': branch_code, 'term': value};
        }
        table.destroy();
        $("#view_vehiclepf").modal('show');
        $("#view_vehiclepf_title").html('Vehicle Profiles list');
        $.ajax({
            url: baseurl + 'rateoffering/getvehiclepflist',
            type: "POST",
            data: senddata,
            dataType: 'JSON',
            success: function (data) {
                $("#vehiclepftbl").DataTable({
                    data: data,
                    "bPaginate": true,
                    "paging": true,
                    "bLengthChange": true,
                    "bFilter": true,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                            '<option value="10">10</option>' +
                            '<option value="20">20</option>' +
                            '<option value="30">30</option>' +
                            '<option value="40">40</option>' +
                            '<option value="50">50</option>' +
                            '<option value="-1">All</option>' +
                            '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                    "columns": [
                        {"data": "check"},
                        {"data": "veh_profile_id"},
                        {"data": "name"},
                        {"data": "company_code"},
                        {"data": "branch_code"}
                    ],
                });
            }
        });
    }

    function selectvehiclepf(id) {
        $('.selectvehicle').attr('onclick', 'selectvehiclepfinlist()');
        $('.listvehiclepf').removeClass('selectedvehiclepf-list');
        $('#listvehiclepf_' + id).addClass('selectedvehiclepf-list');
    }

    function selectvehiclepfinlist() {
        $('#view_vehiclepf').modal('hide');
        var id = $('.selectedvehiclepf-list').val();
        $('#vehicleProfile').val(id);
    }

    $('#tariffType').change(function () {
        var type = $(this).val();
        if (type == 'BUY') {
            $('#vendorProfile').removeAttr('readonly');
            $('#customerProfile').attr('readonly', true);
            $('#customerProfileId').css('display', 'none');
            $('#vendorProfileId').css('display', '');
        }
        if (type == 'SELL') {
            $('#vendorProfile').attr('readonly', true);
            $('#customerProfile').removeAttr('readonly');
            $('#vendorProfileId').css('display', 'none');
            $('#customerProfileId').css('display', '');
        }
        $.ajax({
            url: '<?=base_url('KNeTNQuickRates/conversionlist')?>',
            type: 'POST',
            dataType: 'json',
            data: {'type': type},
            success: function (data) {
                var html = '<option value="0"><?=$this->lang->line('general_select')?></option>';
                for (var i = 0; i < data.length; i++) {
                    html += '<option value="' + data[i]['id'] + '">' + data[i]['conversion_id'] + '-' + data[i]['name'] + '</option>';
                }
                $('#conversionFactor').html(html);
                $('#conversionFactor').val();
            }
        });
    });

    $('#laneId').change(function () {
        var lane = $(this).val();
        $.ajax({
            url: '<?=base_url('KNeTNQuickRates/laneDetails')?>',
            type: 'POST',
            dataType: 'json',
            data: {'lane': lane},
            success: function (data) {
                $("#sourceGeo").val(data['0']['source_geo']);
                $("#source").val(data['0']['source']);
                $("#destinationGeo").val(data['0']['destination_geo']);
                $("#destination").val(data['0']['destination']);
                $("#lanesId").val(data['0']['id']);
            }
        });
    });

    /*  Rate Record Charges   Add  */
    function rowaddCharges(e) {
        var tableId = $(e).closest('table').attr('id');

        var trOpen = '<tr id="editing"><form method="POST" action="<?= base_url();?>KNeTNQuickRates/saverrcharge" id="rr_charge_form" novalidate class="cargo_form" autocomplete="off">';
        var tds = '<td><select form="rr_charge_form" style="width: -webkit-fill-available;" id="charge_type" name="charge_type" onchange="chargetypere();" class="form-control"><option value="">Select</option><option value="Fixed">Fixed</option><option value="Tier">Tier</option><option value="Geo Tier">Geo Tier</option></select></td><td ><select form="rr_charge_form" style="width: -webkit-fill-available;" id="tier_id" name="tier_id" class="form-control"><option value="">Select</option><?php if(count(
            $tier
        ) > 0){ foreach ($tier as $tier_res) {?><option value="<?= $tier_res['id']; ?>"> <?= $tier_res['tier_id'] . '-' . htmlspecialchars($tier_res['tier_name'], ENT_QUOTES, 'UTF-8'); ?> </option> <?php }} ?></select></td> <td class="tdpad"><select form="rr_charge_form" style="width: -webkit-fill-available;" id="geo_tier_id" name="geo_tier_id" class="form-control"><option value="">Select</option><?php if(count(
            $geo_tier
        ) > 0){ foreach ($geo_tier as $geo_tier_res) {?><option value="<?= $geo_tier_res['id']; ?>"> <?= $geo_tier_res['geo_tier_id'] . '-' . htmlspecialchars($geo_tier_res['geo_tier_name'], ENT_QUOTES, 'UTF-8'); ?> </option> <?php }} ?></select></td><td><select form="rr_charge_form" style="width: -webkit-fill-available;" id="rr_charge_id" onchange="checkfrtcondition(0);" name="rr_charge_id" class="form-control"><option value="">Select</option><?php if(count(
            $chr
        ) > 0){ foreach ($chr as $chr_id) {?><option value="<?= $chr_id['id']; ?>"> <?= $chr_id['charge_code'] . '-' . $chr_id['name']; ?> </option> <?php }} ?></select></td><td><select form="rr_charge_form" style="width: -webkit-fill-available;" id="rr_exch_id" name="rr_exch_id" class="form-control"><option value="">Select</option><?php if(count(
            $exch_id
        ) > 0){ foreach ($exch_id as $exch_data) {?><option value="<?= $exch_data['id']; ?>"> <?= $exch_data['exchange_rate_id'] . '-' . $exch_data['exchange_rate_name']; ?> </option> <?php }} ?></select></td><td><select  form="rr_charge_form" style="width: -webkit-fill-available;" id="rr_char_basis" name="rr_char_basis" onchange="checkfrtcondition(0);" class="form-control"><option value="">Select</option><option value="KG">KG</option><option value="LDM">LDM</option><option value="CBM">CBM</option><option value="PER PIECE">PER PIECE</option><option value="STOP">STOP</option><option value="TRIP">TRIP</option><option value="KM">KM</option><option value="HOURS">HOURS</option><option value="FRT">FRT</option></select></td><td ><input form="rr_charge_form" style="width: -webkit-fill-available;" class="form-control decimal" type="text" id="rr_min_amount" name="rr_min_amount" onkeypress="return isNonSpecialCharCheck(event);" value=""></td><td><input form="rr_charge_form" style="width: -webkit-fill-available;" class="decimal form-control" type="text" id="rr_amount" name="rr_amount" onkeypress="return isNonSpecialCharCheck(event);" value=""></td><td><select name="fuel_surcharge" form="rr_charge_form" class="form-control fuel_surcharge_id" id="fuel_surcharge"><option value="">Select</option></select></td><td ><select  style="width: -webkit-fill-available;" type="text" form="rr_charge_form" name="rr_currency" class="form-control" id="rr_currency" ><option value="">Select</option><?php if(count(
            $currencies
        ) > 0){ foreach($currencies as $currency){ ?><option value="<?= $currency['currency'];?>" ><?= $currency['currency'];?></option><?php    }} ?></select></td>';
        var buttons = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu"><li onclick="return savcharge(this);"><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="rowEdit(this);"><span class="glyphicon glyphicon-ok"> </span><?= $this->lang->line(
            'general_save'
        ); ?></a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span><?= $this->lang->line('general_remove'); ?></a></li></ul></li></ul></td>';
        var trClose = "</form></tr>";
        var html = trOpen + buttons + tds + trClose;
        rowAddNewBetween('chr_list', e, html);
    }

    function rowcharEdit(e, id, rr_charge_type, rr_charge_id, rr_tier_id, charge_basis, min_amount, amount, currency, exch_id, geo_id, percentage, fuel_surcharge_id) {
        //editchargetypere(rr_charge_type);
        var $row = $(e).closest('tr');
        var $cols = $row.find('td');
        var tableId = $(e).closest('table').attr('id');
        var trOpen = '<form method="POST" action="<?= base_url();?>KNeTNQuickRates/saverrcharge/' + id + '" id="charge_up_form"  class="" autocomplete="off">';
        var tds = '<td class="tdpad"><select form="charge_up_form" style="min-width:180px !important;" id="charge_type" name="charge_type" onchange="chargetypere();" class="form-control"><option value="">Select</option><option value="Fixed">Fixed</option><option value="Tier">Tier</option><option value="Geo Tier">Geo Tier</option></select></td><td class="tdpad"><select form="charge_up_form" style="width: -webkit-fill-available;" id="tier_id" name="tier_id" class="form-control"><option value="">Select</option><?php if(count(
            $tier
        ) > 0){ foreach ($tier as $tier_res) {?><option value="<?= $tier_res['id']; ?>"> <?= $tier_res['tier_id'] . '-' . htmlspecialchars($tier_res['tier_name'], ENT_QUOTES, 'UTF-8'); ?> </option> <?php }} ?></select></td><td class="tdpad"><select form="charge_up_form" style="width: -webkit-fill-available;" id="geo_tier_id" name="geo_tier_id" class="form-control"><option value="">Select</option><?php if(count(
            $geo_tier
        ) > 0){ foreach ($geo_tier as $geo_tier_res) {?><option value="<?= $geo_tier_res['id']; ?>"> <?= $geo_tier_res['geo_tier_id'] . '-' . htmlspecialchars($geo_tier_res['geo_tier_name'], ENT_QUOTES, 'UTF-8'); ?> </option> <?php }} ?></select></td><td class="tdpad"><select form="charge_up_form" style="min-width:180px !important;" id="rr_charge_id" onchange="checkfrtcondition(0);" name="rr_charge_id" class="form-control"><option value="">Select</option><?php if(count(
            $chr
        ) > 0){ foreach ($chr as $chr_id) {?><option value="<?= $chr_id['id']; ?>"> <?= $chr_id['charge_code'] . '-' . $chr_id['name']; ?> </option> <?php }} ?></select></td><td class="tdpad"><select form="charge_up_form" style="width: -webkit-fill-available;" id="rr_exch_id" name="rr_exch_id" class="form-control"><option value="">Select</option><?php if(count(
            $exch_id
        ) > 0){ foreach ($exch_id as $exch_data) {?><option value="<?= $exch_data['id']; ?>"> <?= $exch_data['exchange_rate_id'] . '-' . $exch_data['exchange_rate_name']; ?> </option> <?php }} ?></select></td><td class="tdpad"><select form="charge_up_form" style="min-width:180px !important;" id="rr_char_basis" name="rr_char_basis" onchange="checkfrtcondition(0);" class="form-control"><option value="">Select</option><option value="KG">KG</option><option value="LDM">LDM</option><option value="CBM">CBM</option><option value="PER PIECE">PER PIECE</option><option value="STOP">STOP</option><option value="TRIP">TRIP</option><option value="KM">KM</option><option value="HOURS">HOURS</option><option value="FRT">FRT</option></select></td><td class="tdpad"><input onkeypress="return isNonSpecialCharCheck(event);" form="charge_up_form" style="min-width:100px !important;" class="decimal form-control" type="text" id="rr_min_amount" name="rr_min_amount" value="' + min_amount + '"></td><td class="tdpad"><input onkeypress="return isNonSpecialCharCheck(event);" form="charge_up_form" style="min-width:100px !important;" class="form-control decimal" type="text" id="rr_amount" name="rr_amount" value="' + amount + ' "></td><td><select name="fuel_surcharge" form="charge_up_form" class="form-control fuel_surcharge_id" id="fuel_surcharge"><option value="">Select</option></select></td><td class="tdpad"><select  style="width: -webkit-fill-available;" type="text" form="charge_up_form" name="rr_currency" class="form-control" id="rr_currency" ><option value="">Select</option><?php if(count(
            $currencies
        ) > 0){ foreach($currencies as $currency){ ?><option value="<?= $currency['currency'];?>" ><?= $currency['currency'];?></option><?php    }} ?></select></td>';
        var buttons = '<td name="buttons" class="tdpad_bt"><ul class="nav nav-tabs"><li class="dropdown"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu"><li><a id="bAcep" type="button" class="btn btn-sm btn-default" onclick="return updatecharge(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li></ul></li></ul></td>';
        // var divClose = "";<tr id="editing" style="background-color:white;"></tr>
        var trClose = "</form>";
        var html = trOpen + buttons + tds + trClose;
        $row.html(html);
        $('#rr_currency option[value="' + currency + '"]').prop("selected", true);
        $('#geo_tier_id option[value="' + geo_id + '"]').prop("selected", true);
        $('#rr_exch_id option[value="' + exch_id + '"]').prop("selected", true);
        $('#charge_type option[value="' + rr_charge_type + '"]').prop("selected", true);
        $('#rr_charge_id option[value="' + rr_charge_id + '"]').prop("selected", true);
        $('#rr_char_basis option[value="' + charge_basis + '"]').prop("selected", true);
        $('#tier_id option[value="' + rr_tier_id + '"]').prop("selected", true);
        $('#charge_type').trigger("change");
        checkfrtcondition(fuel_surcharge_id);
    }

    function rowElim(but) { //Elimina la fila actual
        var $row = $(but).closest('tr'); //accede a la fila
        //params.onBeforeDelete($row);
        $row.remove();
        // params.onDelete();
    }

    function checkfrtcondition(fuel_surcharge_id) {
        $('#rr_min_amount').removeAttr('readonly');
        $('#rr_amount').removeAttr('readonly');
        $('#rr_amount').removeAttr('readonly');
        $('#rr_currency').prop('disabled', false);
        var tariffType = $('#tariffType').val();
        var customerProfile = $('#customerProfile').val();
        var vendorProfile = $('#vendorProfile').val();
        var charge_id = $("#rr_charge_id option:selected").text();
        if (charge_id != "") {
            var arr = charge_id.split('-');
            var charge_code = $.trim(arr[0]);
            var charge_basis = $.trim($("#rr_char_basis option:selected").text());
            if (charge_basis == "FRT" && charge_code == "FAF") {
                $('#rr_min_amount').attr('readonly', 'readonly');
                $('#rr_amount').attr('readonly', 'readonly');
                $('#fuel_surcharge').removeAttr('disabled');
                $.ajax({
                    url: baseurl + 'KNeTNQuickRates/getamountfromfuelsurcharge',
                    type: "POST",
                    dataType: 'json',
                    data: {
                        'tariffType': tariffType,'customerProfile': customerProfile,'vendorProfile': vendorProfile
                    },
                    success: function (resp) {
                        var htm = "<option value=''>Select</option>";
                        if (resp.length > 0) {
                            $.each(resp, function (key, value) {
                                var select = "";
                                if (fuel_surcharge_id > 0) {
                                    if (value.row_id == fuel_surcharge_id) {
                                        select = "selected";
                                    }
                                }
                                htm += "<option value='" + value.row_id + "' " + select + ">" + value.faf_id + "-" + value.faf_name + "</option>";
                            });
                        }
                        $('#fuel_surcharge').html(htm);
                    }
                });
                $('#rr_currency').prop('disabled', true);
            } else {
                $('#fuel_surcharge').prop('disabled', true);
            }
        }
    }
    var baseurl = "<?= base_url();?>";
    function saveServiceAndLane(e) {
        var baseurl = "<?= base_url();?>";
        var rateServiceName = $('#serviceName').val();
        var laneId = $('#laneId').val();
        var days = $('#days').val();
        var hours = $('#hours').val();
        var minutes = $('#minutes').val();
        var tariffType = $('#tariffType').val();
        var effectiveDate = $('#effectiveDate').val();
        var expiryDate = $('#expiryDate').val();
        var serviceType = $('#serviceType').val();
        if (rateServiceName == "") {
            gettoast('top-right', 'rateServiceName', 'Please Enter Service Name');
            return false;
        }
        if (serviceType == "") {
            gettoast('top-right', 'serviceType', 'Please Select Service Type');
            return false;
        }
        if (days == "" && hours == "" && minutes == "") {
            gettoast('top-right', 'days', 'Please Enter atleast one field in days, hours and minutes');
            return false;
        }
        if (laneId == "") {
            gettoast('top-right', 'laneId', 'Please Select LaneId');
            return false;
        }
        if (tariffType == "") {
            gettoast('top-right', 'tariffType', 'Please Select tariffType');
            return false;
        }
        if (effectiveDate == "") {
            gettoast('top-right', 'effectiveDate', 'Please Enter EffectiveDate ');
            return false;
        }
        if (expiryDate == "") {
            gettoast('top-right', 'expiryDate', 'Please Enter ExpiryDate');
            return false;
        }
        if ((rateServiceName.length > 0)) {
            chkduplicate = check_name(rateServiceName, e);
        }
        if (chkduplicate == 1) {
            gettoast('top-right', 'rateServiceName', 'Service Name already exists');
            return false;
        }
        else{

            var data = $("#quickRatesForm").serializeArray();
            $.ajax({
                url:baseurl+'KNeTNQuickRates/serviceAndLaneInsert',
                type:"POST",
                data:data,
                dataType:'json',
                success:function(data){
                    $(".pop_message").html('Rate Service:' + data.serviceId + ', Rate Offering' + data.offeringId + ', Rate Record:' + data.recordId + ' Records Inserted Successfully !!');
                    $("#insert_success_div").modal('show');
                    $(".success_redirect").on('click', function(){
                        window.location.reload();
                    });
                }, error: function (errMsg) {

                }
            });
            return false;
        }
    }
    /* duplication check  */
    function check_name(rateServiceName,e){
        var data;
        $.ajax({
            url : baseurl + 'KNeTNQuickRates/checkname',
            async: false,
            type : "POST",
            data : {
                'rateServiceName' : rateServiceName
            },
            dataType : 'JSON',
            success : function(resp) {
                data = resp;
            }
        });
        return data;
    }
    $('#buttonid').on('click', function () {
        $("#exlfile").click();
    });
    var listType = $('#listType').val();
    if(listType == '1'){
        getRateslist();
    }
    function getRateslist(){
        $('#orders_success_list').modal('show');
    }

</script>


