<script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAP_KEY;?>&libraries=places&language=en&callback=initMap&signed_in=false"></script>
<section class="content-header">
    <h1>
    <?=$this->lang->line('route')?>
        <small><?=$this->lang->line('traffic')?></small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-home"></i> Dashboard</a></li>
        <li><a href="#"><?=$this->lang->line('route')?></a></li>
        <li class="active"><?=$this->lang->line('traffic')?></li>
    </ol>
</section>
<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <div class="box">
        <div class="box-body">
            <div class="row">
                <div class="col-md-3">
                    <form class="myForm" onsubmit="return loadRoute();">
                        <div class="row">
                            <div class="col-md-12">
                                <input type="text" class="form-control" name="loactions[]" id="source" placeholder="<?=$this->lang->line('choose_starting_point_or_click_on_map')?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <input type="text" class="form-control" name="loactions[]" id="destination" placeholder="<?=$this->lang->line('choose_destination')?>">
                            </div>
                        </div>
                        <div class="destinations">
                        </div>
                        <div class="row" onclick="addDestination()" style="cursor: pointer;">
                            <div class="col-md-12" style="padding: 10px 20px;">
                                <i class="fa fa-plus-circle" aria-hidden="true"></i> <?=$this->lang->line('add_destination')?>
                            </div>
                        </div>
                        <div class="row" style="padding-bottom: 10px">
                            <div class="col-md-12">
                                <input type="text" id="datetime" class="datetime form-control" value="<?=date('Y-m-d H:i')?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="btn btn-primary btn-sm search" style="width: 100%"><?=$this->lang->line('submit')?></div>
                            </div>
                        </div>
                    </form>
                    <div class="right-panel" id="right-panel"></div>
                </div>
                <div class="col-md-9">
                    <div class="map" id="map" style="height: calc(100vh - 150px);"></div>
                    <button class="btn btn-primary btn-sm" id="traffic-b"><?=$this->lang->line('traffic')?></button>
                    <button class="btn btn-primary btn-sm" id="transit-b"><?=$this->lang->line('transit')?></button>
                    <button class="btn btn-primary btn-sm" id="bike-b"><?=$this->lang->line('truck_or_trailer')?></button>
                </div>
            </div>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
</section>
<!-- /.content -->
<script type="text/javascript">
var map;
var options = {types: []};
var source1;
var destination1;
var geocoder;
var key = "<?php echo GOOGLE_MAP_KEY;?>";
var isEnabled = true;
function initMap() {
    var directionsService = new google.maps.DirectionsService;
    var directionsDisplay = new google.maps.DirectionsRenderer;
    map = new google.maps.Map(document.getElementById('map'), {
        center: {lat: 23.95, lng: 76.17},
        zoom: 13,
        mapTypeId: google.maps.MapTypeId.ROADMAP
    });
    directionsDisplay.setMap(map);
    directionsDisplay.setPanel(document.getElementById('right-panel'));
    new google.maps.places.Autocomplete((document.getElementById('source')),options);
    new google.maps.places.Autocomplete((document.getElementById('destination')),options);
    var trafficLayer = new google.maps.TrafficLayer();
    var transitLayer = new google.maps.TransitLayer();
    var bikeLayer = new google.maps.BicyclingLayer();
    trafficLayer.setMap(map);
    transitLayer.setMap(null);
    bikeLayer.setMap(null);
    $(".search").click(function(){
        /*map.setTrafficEnabled(isEnabled);*/
        search(directionsService,directionsDisplay);
    });
    $('#traffic-b').click(function(){
        trafficLayer.setMap(map);
        transitLayer.setMap(null);
        bikeLayer.setMap(null);
    });
    $('#transit-b').click(function(){
        trafficLayer.setMap(null);
        transitLayer.setMap(map);
        bikeLayer.setMap(null);
    });
    $('#bike-b').click(function(){
        trafficLayer.setMap(null);
        transitLayer.setMap(null);
        bikeLayer.setMap(map);
    });
}
$(document).ready(function(){
    $("#datetime").datetimepicker({
        minDate:new Date(),
        startDate:new Date(),
        date:new Date()
    });
});
function search(directionsService,directionsDisplay) {
    if($("#source").val().length==0){
        $("#source").focus();
        return;
    }
    if($("#destination").val().length==0){
        $("#destination").focus();
        return;
    }
    var ajaxData={};
    var loc =[];
    $("input[name='loactions[]']").each(function(){
        if($(this).val().trim().length>0)
            loc.push($(this).val());
    });
    var url = "https://www.google.com/maps/embed/v1/directions?key="+key;
    var url1 = "https://maps.googleapis.com/maps/api/directions/json?key="+key;
    url += "&origin="+loc[0].replace(/\s+/g,"+");
    url += "&destination="+loc[loc.length-1].replace(/\s+/g,"+");
    url1 += "&origin="+loc[0].replace(/\s+/g,"+");
    url1 += "&destination="+loc[loc.length-1].replace(/\s+/g,"+");
    ajaxData["origin"]=loc[0];
    ajaxData["destination"]=loc[loc.length-1];
    var waypoints=[];
    for(var i=0;i<loc.length;i++){
        if(i!=0 && i!=loc.length-1){
            waypoints.push("via:"+loc[i].replace(/\s+/g,"+"));
        }
    }
    if(waypoints.length>0){
        url += "&waypoints="+waypoints.join("|");
        url1 += "&waypoints="+waypoints.join("|");
        ajaxData["waypoints"]=waypoints;
        
    }
    ajaxData["travelMode"]= 'DRIVING';
    url1 += "&departure_time="+getTime();
    url1 += "&mode=DRIVING";
    $("#map").html('<iframe width="100%" height="100% frameborder="0" style="border:0" src="'+url+'"></iframe>');
    
    $.ajax({
        url:"<?=base_url('routeoptimize/test')?>",
        type: 'POST',
        data:{
            "url":url1
        },
        crossDomain: true,
        dataType: 'json',
        beforeSend:function(){

        },
        success:function(response){
            $(".right-panel").html('<div class="row" style="padding:15px;"><div class="col-md-6"><div class="btn-primary" style="padding: 5px;text-align: center;">'+response.routes[0].legs[0].duration.text+' <br> <span style="font-weight: 600;">Regular</span></div></div><div class="col-md-6"><div class="btn-warning" style="padding: 5px;text-align: center;">'+response.routes[0].legs[0].duration_in_traffic.text+'<br> <span style="font-weight: 600;">Traffic</span></div></div></div>');
        }
    });
    // directionsService.route(ajaxData, function(response, status) {
    //     if (status === 'OK') {
    //         directionsDisplay.setDirections(response);
    //     } else {
    //         window.alert('Directions request failed due to ' + status);
    //     }
    // });
    
}
function getTime(){
    if($("#datetime").val().trim().length>0){
        return Math.floor(new Date($("#datetime").val()) / 1000);
    }else return Math.floor(new Date() / 1000);
}
function removeDestination(ele) {
    $(ele).closest(".row").remove();
}
function addDestination() {
    if($("#source").val().length==0){
        $("#source").focus();
        return;
    }
    if($("#destination").val().length==0){
        $("#destination").focus();
        return;
    }
    var i =$(".destinations").find(".row").length+1;
    var row = '<div class="row newDest">'+
        '<div class="col-md-10">'+
            '<input type="text" class="form-control" name="loactions[]" id="destination'+i+'" placeholder="<?=$this->lang->line('choose_destination')?>">'+
        '</div>'+
        '<div class="col-md-2" style="text-align: center;height: 34px;padding: 6px 20px;cursor: pointer;">'+
            '<i class="fa fa-times" aria-hidden="true" onclick="removeDestination(this)"></i>'+
        '</div>'+
    '</div>';
    $(".destinations").append(row);
    new google.maps.places.Autocomplete((document.getElementById('destination'+i)),options);
}
</script>