<section class="content-header">
    <h1>
        <?=$this->lang->line('route')?>
        <small><?=$this->lang->line('traffic')?></small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-home"></i> <?=$this->lang->line('menu_dashboard')?></a></li>
        <li><a href="#"><?=$this->lang->line('route')?></a></li>
        <li class="active"><?=$this->lang->line('traffic')?></li>
    </ol>
</section>
<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <div class="box">
        <div class="box-body">
            <div class="row">
                <div class="col-md-3">
                    <form class="myForm" onsubmit="return loadRoute();">
                        <div class="row">
                            <div class="col-md-12">
                                <input type="text" class="form-control" name="loactions[]" id="source" placeholder="<?=$this->lang->line('choose_starting_point_or_click_on_map')?>" data-lat="" data-lng="">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <input type="text" class="form-control" name="loactions[]" id="destination" placeholder="<?=$this->lang->line('choose_destination')?>" data-lat="" data-lng="">
                            </div>
                        </div>
                        <div class="destinations">
                        </div>
                        <div class="row" onclick="addDestination()" style="cursor: pointer;">
                            <div class="col-md-12" style="padding: 10px 20px;">
                                <i class="fa fa-plus-circle" aria-hidden="true"></i> <?=$this->lang->line('add_destination')?>
                            </div>
                        </div>
                        <div class="row" style="padding-bottom: 10px">
                            <div class="col-md-12">
                                <input type="text" id="datetime" class="datetime form-control" value="<?=date('Y-m-d H:i')?>">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="btn btn-primary btn-sm search" style="width: 100%"><?=$this->lang->line('submit')?></div>
                            </div>
                        </div>
                    </form>
                    <div class="right-panel" id="right-panel"></div>
                </div>
                <div class="col-md-9">
                    <div class="map" id="map" style="height: calc(100vh - 150px);margin-bottom: 8px"></div>
                    <button class="btn btn-primary btn-sm" id="traffic-b"><?=$this->lang->line('traffic')?></button>
                    <button class="btn btn-primary btn-sm" id="transit-b"><?=$this->lang->line('transit')?></button>
                    <button class="btn btn-primary btn-sm" id="bike-b"><?=$this->lang->line('truck_or_trailer')?></button>
                </div>
            </div>
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
</section>
<!-- /.content -->
<?php 
    $cntrylatlng['ulat'] = 20.5937; 
    $cntrylatlng['ulng'] = 78.9629;
    if($this->session->userdata("user_id") !== FALSE){ 
        $lguid = $this->session->userdata("user_id");
        $cntrylatlng = getLogUserLatLng($lguid);
    }
?>
<script type="text/javascript">
var ulglat = <?php echo $cntrylatlng['ulat'];?>;
var ulglng = <?php echo $cntrylatlng['ulng'];?>;
var map;
var options = {types: []};
var source1;
var destination1;
var geocoder;
var key = "<?php echo GOOGLE_MAP_KEY;?>";
var isEnabled = true;
    var markers = [];
    var line;


function hasProperty(obj, key) {
    return obj.hasOwnProperty(key);
}
    
function initMap() {
    // var directionsService = new google.maps.DirectionsService;
    // var directionsDisplay = new google.maps.DirectionsRenderer;
    // map = new google.maps.Map(document.getElementById('map'), {
    //     center: {lat: 23.95, lng: 76.17},
    //     zoom: 13,
    //     mapTypeId: google.maps.MapTypeId.ROADMAP
    // });
    // directionsDisplay.setMap(map);
    // directionsDisplay.setPanel(document.getElementById('right-panel'));
    var ac1 = new google.maps.places.Autocomplete((document.getElementById('source')),options);
    var ac2 = new google.maps.places.Autocomplete((document.getElementById('destination')),options);
    addAutocompleteListers(ac1,$("#source"));
    addAutocompleteListers(ac2,$("#destination"));


    // var trafficLayer = new google.maps.TrafficLayer();
    // var transitLayer = new google.maps.TransitLayer();
    // var bikeLayer = new google.maps.BicyclingLayer();
    // trafficLayer.setMap(map);
    // transitLayer.setMap(null);
    // bikeLayer.setMap(null);


    // Initialize the platform object:
    var platform = new H.service.Platform({
        apikey: apiKey
    });
    var defaultLayers = platform.createDefaultLayers();
    
    //Step 2: initialize a map - this map is centered over Europe
    map = new H.Map(document.getElementById('map'),
        defaultLayers.vector.normal.map,{
        center: {lat:ulglat, lng:ulglng},
        zoom: 4,
        pixelRatio: window.devicePixelRatio || 1
    });
    map.getViewPort().setPadding(50, 50, 50, 50)
    // add a resize listener to make sure that the map occupies the whole container
    window.addEventListener('resize', () => map.getViewPort().resize());
    
    //Step 3: make the map interactive
    // MapEvents enables the event system
    // Behavior implements default interactions for pan/zoom (also on mobile touch environments)
    var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
    
    // Create the default UI components
    var ui = H.ui.UI.createDefault(map, defaultLayers);

    map.addLayer(defaultLayers.vector.normal.traffic);

    $(".search").click(function(){
        /*map.setTrafficEnabled(isEnabled);*/
        // search(directionsService,directionsDisplay);
        search(platform);
    });
    $('#traffic-b').click(function(){
        trafficLayer.setMap(map);
        transitLayer.setMap(null);
        bikeLayer.setMap(null);
    });
    $('#transit-b').click(function(){
        trafficLayer.setMap(null);
        transitLayer.setMap(map);
        bikeLayer.setMap(null);
    });
    $('#bike-b').click(function(){
        trafficLayer.setMap(null);
        transitLayer.setMap(null);
        bikeLayer.setMap(map);
    });
}
$(document).ready(function(){
    $("#datetime").datetimepicker({
        minDate:new Date(),
        startDate:new Date(),
        date:new Date()
    });
    initMap();
});
// function search(directionsService,directionsDisplay) {
function search(platform) {
    if($("#source").val().length==0){
        $("#source").focus();
        return;
    }
    if($("#destination").val().length==0){
        $("#destination").focus();
        return;
    }
    var ajaxData={};
    var loc =[];
    $("input[name='loactions[]']").each(function(){
        if($(this).val().trim().length>0){
            var data = {};
            data["place"] = $(this).val();
            data["lat"] = $(this).data("lat");
            data["lng"] = $(this).data("lng");
            loc.push(data);
        }
    });
    var url1 = "https://maps.googleapis.com/maps/api/directions/json?";
    url1 += "&origin="+loc[0].place.replace(/\s+/g,"+");
    url1 += "&destination="+loc[loc.length-1].place.replace(/\s+/g,"+");
    ajaxData["origin"]=loc[0].place;
    ajaxData["destination"]=loc[loc.length-1].place;
    var waypoints=[];
    for(var i=0;i<loc.length;i++){
        if(i!=0 && i!=loc.length-1){
            waypoints.push("via:"+loc[i].place.replace(/\s+/g,"+"));
        }
    }
    if(waypoints.length>0){
        url1 += "&waypoints="+waypoints.join("|");
        ajaxData["waypoints"]=waypoints;
        
    }
    ajaxData["travelMode"]= 'DRIVING';
    url1 += "&departure_time="+getTime();
    url1 += "&mode=DRIVING";
    $.ajax({
        url:"<?=base_url('routeoptimize/test')?>",
        type: 'POST',
        data:{
            "url":url1
        },
        crossDomain: true,
        dataType: 'json',
        beforeSend:function(){

        },
        success:function(response){
            $(".right-panel").html('<div class="row" style="padding:15px;"><div class="col-md-6"><div class="btn-primary" style="padding: 5px;text-align: center;">'+response.routes[0].legs[0].duration.text+' <br> <span style="font-weight: 600;">Regular</span></div></div><div class="col-md-6"><div class="btn-warning" style="padding: 5px;text-align: center;">'+response.routes[0].legs[0].duration_in_traffic.text+'<br> <span style="font-weight: 600;">Traffic</span><span style="font-size: 10px;display: block;">('+$("#datetime").val()+')</span></div></div></div>');
        }
    });
    

    var routeRequestParams = {
        mode: 'fastest;car',
        representation: 'display',
        routeattributes : 'waypoints,summary,shape,legs',
        maneuverattributes: 'direction,action'
    };
    for(var i=0;i<loc.length;i++){
        routeRequestParams["waypoint"+i] = loc[i].lat+","+loc[i].lng;
    }
    var router = platform.getRoutingService();
    if(markers.length>0){
        map.removeObjects(markers);
        map.removeObjects([line]);
        markers = [];
        line = null;    
    }
    router.calculateRoute(routeRequestParams,function(result) {
        var route,routeShape,startPoint,endPoint,linestring;
        setTimeout(function() {
            if(hasProperty(result.response, "route") && result.response.route) {
                // Pick the first route from the response:
                route = result.response.route[0];
                // Pick the route's shape:
                routeShape = route.shape;

                // Create a linestring to use as a point source for the route line
                linestring = new H.geo.LineString();

                // Push all the points in the shape into the linestring:
                routeShape.forEach(function(point) {
                    var parts = point.split(',');
                    linestring.pushLatLngAlt(parts[0], parts[1]);
                });

                // Retrieve the mapped positions of the requested waypoints:
                startPoint = route.waypoint[0].mappedPosition;
                endPoint = route.waypoint[1].mappedPosition;
                $.each(route.waypoint,function(index,val){
                    var marker = new H.map.Marker({
                        lat: val.mappedPosition.latitude,
                        lng: val.mappedPosition.longitude
                    });
                    markers.push(marker);
                });
                map.addObjects(markers);

                // Create a polyline to display the route:
                line = new H.map.Polyline(linestring, {
                    style: { strokeColor: 'blue', lineWidth: 3 }
                });

                // Add the route polyline and the two markers to the map:
                map.addObjects([line]);

                // Set the map's viewport to make the whole route visible:
                map.getViewModel().setLookAtData({bounds: line.getBoundingBox()});
            }
        }, 1000);
        
    },
    function(error) {
        console.log(error.message);
    });
    
}
function getTime(){
    if($("#datetime").val().trim().length>0){
        return Math.floor(new Date($("#datetime").val()) / 1000);
    }else return Math.floor(new Date() / 1000);
}
function removeDestination(ele) {
    $(ele).closest(".row").remove();
}
function addDestination() {
    if($("#source").val().length==0){
        $("#source").focus();
        return;
    }
    if($("#destination").val().length==0){
        $("#destination").focus();
        return;
    }
    var i =$(".destinations").find(".row").length+1;
    var row = '<div class="row newDest">'+
        '<div class="col-md-10">'+
            '<input type="text" class="form-control" name="loactions[]" id="destination'+i+'" placeholder="<?=$this->lang->line('choose_destination')?>" data-lat="" data-lng="">'+
        '</div>'+
        '<div class="col-md-2" style="text-align: center;height: 34px;padding: 6px 20px;cursor: pointer;">'+
            '<i class="fa fa-times" aria-hidden="true" onclick="removeDestination(this)"></i>'+
        '</div>'+
    '</div>';
    $(".destinations").append(row);
    var ac3 = new google.maps.places.Autocomplete((document.getElementById('destination'+i)),options);
    addAutocompleteListers(ac3,$("#destination"+i));
}
function addAutocompleteListers(ac,ele){
    google.maps.event.addListener(ac, 'place_changed', function(){
        var place = this.getPlace();
        ele.attr("data-lat",place.geometry.location.lat());
        ele.attr("data-lng",place.geometry.location.lng());
        // for (var i in place.address_components) {    
        //     var component = place.address_components[i];    
        //     for (var j in component.types) {  
        //         var type_element = document.getElementById(component.types[j]);      
        //         if (type_element) {        
        //             type_element.value = component.long_name;
        //         }    
        //     }  
        // }
    });   
}
</script>