<script src="<?= base_url(); ?>assets/plugins/select2/select2.min.js"></script>
<link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/select2/select2.min.css">
<script type="text/javascript">
    $('.searchbookingids').select2({
        placeholder: "<?= $this->lang->line('booking_id'); ?>",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-bookingid-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        allowClear: true,
        ajax: {
            url: "<?= base_url(); ?>" + 'orderrevenues/getorderids',
            type: 'post',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                }
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });

    $(".order_references").select2({
        placeholder: "<?php echo $this->lang->line('reference_no'); ?>",
        width: "142px",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-order_references-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        allowClear: true,
        ajax: {
            url: baseurl + 'Orderrevenues/searchOrderReferences',
            type: "post",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });
    $('.reference').select2({
        placeholder: "<?= $this->lang->line('reference_no'); ?>",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-reference-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        allowClear: true,
        ajax: {
            url: "<?= base_url(); ?>" + referenceSearchURL,
            type: 'post',
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                }
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });
    <?php if(!empty($this->session->userdata('cust_id')) && $this->session->userdata('cust_id') != ""){ ?>
       var bookingSearchURL = "orderrevenues/getorderidsbycustid";
    <?php }  ?>
    $(".bookingid").select2({
        placeholder: "<?= $this->lang->line('booking_id'); ?>",
        width: "100%",
        style: "margin-left:5px",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-bookingid-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        ajax: {
            url: "<?= base_url(); ?>" + bookingSearchURL,
            type: "post",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });
    $(".customer_order_references").select2({
        placeholder: "<?php echo $this->lang->line('reference_no'); ?>",
        width: "100%",
        style: "margin-left:5px",
        tags: true,
        multiple: true,
        tokenSeparators: [',', ', ', ' '],
        createTag: function (params) {
            var options = $('#select2-customer_order_references-results li')
            var matchedVal = options.filter(function () {
                return $(this).html() === params.term
            }).text()
            return (matchedVal) ? {id: params.term, text: params.term} : null
        },
        ajax: {
            url: baseurl + 'Customer/getrefinfo',
            type: "post",
            dataType: 'json',
            delay: 300,
            data: function (params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: $.map(response, function (obj) {
                        return obj;
                    })
                };
            },
            cache: true
        }
    });
    $(document).on('paste', 'span.select2', function (e) {
        e.preventDefault();
        var select = $(e.target).closest('.select2').prev();
        var clipboard = (e.originalEvent || e).clipboardData.getData('text/plain');
        clipboard = clipboard.replace(/\s+/g, ',');
        var createOption = function (value, selected) {
            selected = typeof selected !== 'undefined' ? selected : true;
            return $("<option></option>")
                .attr("value", value)
                .attr("selected", selected)
                .text(value)[0]
        };
        $.each(
            clipboard.split(new RegExp(select.data('select2').options.options.tokenSeparators.map(function (a) {
                return (a).replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
            }).join('|'))),
            function (key, value) {
                if (value && (!select.val() || (select.val() && select.val().indexOf('' + value) == -1))) {
                    select.append(createOption(value));
                }
            });
        select.trigger('change');
    });
</script>
