<section class="content-header">
	<h1>
	<?php echo $page_title?>
	<small><?php echo $sub_title?></small>
	</h1>
	<ol class="breadcrumb">
		<li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
		<li><a href="#"><?php echo $page_title?></a></li>
		<li class="active"><?php echo $sub_title?></li>
	</ol>
</section>
<!-- Main content -->
<section class="content">
	<!-- Default box -->
	<div class="box planscreen">
		<form action="" method="POST">
			<div class="box-body">
				<div class="row">
					<div class="col-md-7" style="padding-right: 2px;">
						<ul class="nav nav-tabs" id="myTab" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="total-orders-tab" data-toggle="tab" href="#total-orders" role="tab" aria-controls="total-orders" aria-selected="true">Total Orders</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="customer-orders-tab" data-toggle="tab" href="#customer-orders" role="tab" aria-controls="customer-orders" aria-selected="true">By Customer Orders</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-orders-tab" data-toggle="tab" href="#range-orders" role="tab" aria-controls="range-orders" aria-selected="false">By Range Orders</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTabContent">
						    <div class="tab-pane fade active in" id="total-orders" role="tabpanel" aria-labelledby="total-orders-tab">
						    	<table class="table head-table" style="margin-bottom:0px">
						    		<tbody>
										<tr>
											<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
												<i class="fa fa-edit" onclick="editorder(this)"></i>
												<i class="fa fa-trash"></i>
											</th>
										</tr>
									</tbody>
								</table>
								<table class="table table-striped table-bordered table-hover order-clickable-table" id="table-draggable1">
									<tr>
			                            <th>Order ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Pickup Time</th>
			                            <th>Weight</th>
			                            <th>Volume</th>
			                            <th>Quantity</th>
			                            <th>Mode</th>
			                        </tr>
			                        <tbody class="connectedSortable" id="connectedSortable">
			                        <?php foreach($orders as $or){ ?>
			                        <tr id="<?php echo $or['id'];?>" data-orderid="<?php echo $or['id'];?>">
			                            <td><?php echo $or['order_id']; ?></td>
			                            <td><?php echo $or['pickup_city']; ?></td>
			                            <td><?php echo $or['delivery_city']; ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($or['pickup_datetime'])); ?></td>
			                            <td><?php echo $or['weight']." KGS"; ?></td>
			                            <td><?php echo $or['volume']." CUFT"; ?></td>
			                            <td><?php echo $or['quantity']; ?></td>
			                            <td><?php echo $or['transport_mode']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="customer-orders" role="tabpanel" aria-labelledby="customer-orders-tab">
						    	<table class="table head-table" style="margin-bottom:0px">
						    		<tbody>
										<tr>
											<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
												<i class="fa fa-edit" onclick="editorder(this)"></i>
												<i class="fa fa-trash"></i>
												<select onchange="this.form.submit()" name="by_customer_order_search">
													<?php
													$customer_id = isset($_POST["by_customer_order_search"]) ? $_POST["by_customer_order_search"] : "";
													foreach($customers->result() as $row){
														if($row->id==$customer_id){
															echo "<option value='".$row->id."' selected>".$row->name."</option>";
														}else{
															echo "<option value='".$row->id."'>".$row->name."</option>";
														}
													}
													?>
												</select>
											</th>
										</tr>
									</tbody>
								</table>
								<table class="table table-striped table-bordered table-hover order-clickable-table" id="table-draggable1">
									<tr>
			                            <th>Order ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Pickup Time</th>
			                            <th>Weight</th>
			                            <th>Volume</th>
			                            <th>Quantity</th>
			                            <th>Mode</th>
			                        </tr>
			                        <tbody class="connectedSortable" id="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="range-orders" role="tabpanel" aria-labelledby="range-orders-tab">
						    	
					    		<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
											<i class="fa fa-edit" onclick="editorder(this)"></i>
											<i class="fa fa-trash"></i>
											<?php
												$range = isset($_POST["by_range_order_search"]) ? $_POST["by_range_order_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_order_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
									<table class="table table-striped table-bordered table-hover order-clickable-table" id="table-draggable1">
									<tr>
			                            <th>Order ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Pickup Time</th>
			                            <th>Weight</th>
			                            <th>Volume</th>
			                            <th>Quantity</th>
			                            <th>Mode</th>
			                        </tr>

			                        <tbody class="connectedSortable" id="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						</div>
						
					</div>	
					<div class="col-md-5">
						<div class="box-header" style="background-color: #f9f9f9;padding: 4px;">
						    <h3 class="box-title" style="font-size: 14px;">Shipment Route</h3>
						</div>
						<span id="main" style="text-align: center;"></span>
						<div class="box-body" id="map_route" style="padding: 2px;">	
                        </div>
					</div>
			    </div>
			    <div class="row">
					<div class="col-md-6">
						<ul class="nav nav-tabs active" id="myTab1" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="total-shipments-tab" data-toggle="tab" href="#total-shipments" role="tab" aria-controls="total-shipments" aria-selected="false">Total Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="customer-shipments-tab" data-toggle="tab" href="#customer-shipments" role="tab" aria-controls="customer-shipments" aria-selected="true">By Customer Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-shipments-tab" data-toggle="tab" href="#range-shipments" role="tab" aria-controls="range-shipments" aria-selected="false">By Range Shipments</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTab1Content">
						    <div class="tab-pane fade active in" id="total-shipments" role="tabpanel" aria-labelledby="total-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-plus-square" onclick="return addshipment();"></i>
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
											<i class="fa fa-trash"></i>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover clickable-table">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments" class="table-draggable2 shipment_row" data-shipmentid='<?php echo $sh['id'];?>'>
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($sh['startdate'])); ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($sh['enddate'])); ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="customer-shipments" role="tabpanel" aria-labelledby="customer-shipments-tab">
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="3">
											<i class="fa fa-plus-square" onclick="return addshipment();"></i>
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
											<i class="fa fa-trash"></i>
											<select onchange="this.form.submit()" name="by_customer_sipment_search">
												<?php
												$customer_id = isset($_POST["by_customer_sipment_search"]) ? $_POST["by_customer_sipment_search"] : "";
												foreach($customers->result() as $row){
													if($row->id==$customer_id){
														echo "<option value='".$row->id."' selected>".$row->name."</option>";
													}else{
														echo "<option value='".$row->id."'>".$row->name."</option>";
													}
												}
												?> 
											</select>
										</th>
										<th colspan="6"><b style="color:green;">New Shipments</b></th>
									</tr>
								</table>
								<table class="table table-bordered table-hover left-shipment-table clickable-table">
									<thead>
										<tr>
											<th></th>
				                            <th>Shipment ID</th>
				                            <th>Start Date</th>
				                            <th>End Date</th>
				                            <th>Source</th>
				                            <th>Destination</th>
				                            <th>Vehicle Type</th>
				                            <th>Mode</th>
				                            <th>Weight</th>
				                            <th>Volume</th>
				                            <th>Units</th>
				                        </tr>
				                    </thead>
			                        <tbody class="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="range-shipments" role="tabpanel" aria-labelledby="range-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-plus-square" onclick="return addshipment();"></i>
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
											<i class="fa fa-trash"></i>
											<?php
												$range = isset($_POST["by_range_shipment_search"]) ? $_POST["by_range_shipment_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_shipment_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover clickable-table">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						</div>
					</div>
					<div class="col-md-6">
						<ul class="nav nav-tabs active" id="myTab2" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="intransit-total-shipments-tab" data-toggle="tab" href="#intransit-total-shipments" role="tab" aria-controls="intransit-total-shipments" aria-selected="false">Total Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-customer-shipments-tab" data-toggle="tab" href="#intransit-customer-shipments" role="tab" aria-controls="intransit-customer-shipments" aria-selected="true">By Customer Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-range-shipments-tab" data-toggle="tab" href="#intransit-range-shipments" role="tab" aria-controls="intransit-range-shipments" aria-selected="false">By Range Shipments</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTab2Content">
						    <div class="tab-pane fade active in" id="intransit-total-shipments" role="tabpanel" aria-labelledby="intransit-total-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover clickable-table">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($in_transit_shipments as $sh){
			                        	$capacity = getOccupancy($sh['id']);
			                        ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments" class="table-draggable2 shipment_row" data-shipmentid='<?php echo $sh['id'];?>'>
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?> (<?php echo $capacity; ?>%)<progress value="<?php echo $capacity; ?>" max="100" style='height: 0.8rem;'></progress></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="intransit-customer-shipments" role="tabpanel" aria-labelledby="intransit-customer-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="3">
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
											<select onchange="this.form.submit()" name="by_customer_intransit_sipment_search">
												<?php
												$customer_id = isset($_POST["by_customer_intransit_sipment_search"]) ? $_POST["by_customer_intransit_sipment_search"] : "";
												foreach($customers->result() as $row){
													if($row->id==$customer_id){
														echo "<option value='".$row->id."' selected>".$row->name."</option>";
													}else{
														echo "<option value='".$row->id."'>".$row->name."</option>";
													}
												}
												?>
											</select>
										</th>
										<th colspan="6"><b style="color:green;">In-Transit Shipments</b></th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover clickable-table">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="intransit-range-shipments" role="tabpanel" aria-labelledby="intransit-range-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-edit" onclick="return editShipment(this);"></i>
											<?php
												$range = isset($_POST["by_range_intransit_shipment_search"]) ? $_POST["by_range_intransit_shipment_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_intransit_shipment_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover clickable-table">
									<tr>
			                            <th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                    	</tbody>
								</table>
						    </div>
						</div>
					</div>
			    </div>
			</div>
		</form>
		<!-- /.box-body -->
	</div>
</section>
<div class="modal containerModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-weight: bold;">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Modal body text goes here.</p>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
		$('.order-clickable-table > tbody >tr, .order-range-clickable-table > tbody >tr, .clickable-table > tbody >tr').on('click', function (ele) {
		    $('.custom--success').removeClass('custom--success');
		    $(this).addClass('custom--success');
		});
		$("body").addClass("sidebar-collapse");
	  	var $tabs = $('.table-draggable2')
	  	$("tbody#connectedSortable").sortable({
			connectWith: ".connectedSortable",
			appendTo: $tabs,
			helper: "clone",
			zIndex: 999990
	    });
	    /*.disableSelection();*/
	  	$($tabs).droppable({
		    accept: ".connectedSortable tr",
		    hoverClass: "hovered",
		    drop: function(event, ui) {
	 			var sid = ui.draggable.data('shipmentid');
	 			var ordid = ui.draggable.attr('id');
	 			$.ajax({
					 method: "POST",
					 url: baseurl+"shipmentplan/orderintoshipment",
					 data:{'ship_id': sid,'ordid': ordid}, 
				}).done(function( data ) {
					 var result = $.parseJSON(data);
					 console.log(result);
					 ui.draggable.html("");
				});
		      	return false;
		    }
	  	});
	});
	function editShipment(ele) {
		var table = $(ele).closest("table").next(".clickable-table");
		if(table.find(".custom--success").length>0){
			var shipment_id = table.find(".custom--success").data("shipmentid");

			$.ajax({
	            url:"<?=base_url('shipmentplan/editShipment')?>",
	            data:{"shipment_id":shipment_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Shipment::"+shipment_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}
	function editorder(ele){
		var table = $(ele).closest("table").next(".order-clickable-table");
		if(table.find(".custom--success").length>0){
			var order_id = table.find(".custom--success").data("orderid");
			$.ajax({
	            url:"<?=base_url('shipmentplan/createorder')?>",
	            data:{"order_id":order_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Order::"+order_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}
	function getshipmentroute(sid){
		$.ajax({
			url:baseurl+"shipmentplan/maproute",
			type:"POST",
			data:{"shipment_id":sid},
			beforeSend:function(){
				$('#main').addClass('loader');
			},
			success:function(data){
				$('#bar').val(100);
				$('#main').removeClass("loader");
				$('#map_route').html(data);
			}
		});
	}
	function getshipmentdetail(ele,sid) {
		if($(ele).find(".fa").hasClass("fa-plus-square")){
			$.ajax({
				url:baseurl+"shipmentplan/stopdetail",
				type:"POST",
				data:{"shipment_id":sid},
				beforeSend:function(){
					$(".shipment_row").each(function(){
						$(this).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
					});
					$(ele).find(".fa-plus-square").removeClass("fa-plus-square").addClass("fa-minus-square");
					$(".stop_row,.detail_row").each(function(){
						$(this).remove();
						$(this).remove();
					});
					$('#main').addClass('loader');
				},
				success:function(data){
					$(ele).closest("tr").after(data);
				}
			});
		}else{
			$(ele).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
			$(".stop_row,.detail_row").each(function(){
				$(this).remove();
				$(this).remove();
			});
		}
		
	}

	function addshipment(){
		$.ajax({
            url:"<?=base_url('shipmentplan/addshipment')?>",
            data:{},
            type:"POST",
            beforeSend:function(){
            	$(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("New Shipment");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
            	$(".buffer").hide();
            	$(".containerModal").find(".modal-body").html(data);
            }
        });
	}
	getshipmentroute(108);
</script>
<style type="text/css">
	.planscreen{
		font-size: 10px;
	}
	.planscreen table tr th{
		font-weight: bold;
	}
	.planscreen table tr th i{
		padding: 2px;
	}
	.table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
		padding: 2px !important;
	}
	.loader {
	  	border: 2px solid #f3f3f3;
	    border-radius: 50%;
	    border-top: 2px solid blue;
	    border-right: 2px solid green;
	    border-bottom: 2px solid red;
	    border-left: 2px solid pink;
	    width: 40px;
	    height: 40px;
	  	-webkit-animation: spin 2s linear infinite;
	  	animation: spin 2s linear infinite;
	}
	@-webkit-keyframes spin {
	  0% { -webkit-transform: rotate(0deg); }
	  100% { -webkit-transform: rotate(360deg); }
	}
	@keyframes spin {
	  0% { transform: rotate(0deg); }
	  100% { transform: rotate(360deg); }
	}
	#connectedSortable tr{
		cursor: move;
	}
.nav-tabs>li.active>a, .nav-tabs>li.active>a:hover, .nav-tabs>li.active>a:focus {
    color: #7bbfe8;
    background-color: #fff;
    border: 1px solid #ddd;
    border-bottom-color: transparent;
    cursor: default;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
}
.nav-tabs>li>a {
    margin-right: 2px;
    line-height: 1.42857143;
    border: 1px solid transparent;
    border-radius: 4px 4px 0 0;
    padding: 4px 8px;
    color: #7bbfe8;
	border-color: #eee #eee #ddd;
	background: #f7f7f7;
}
.nav-tabs>li>a::after{
    -webkit-transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    -webkit-transform-origin: 0 0;
}
.map-footer{
	position: absolute;
	bottom: 0;
}
.shipment_row:nth-child(odd) > td{
	background-color: #f5f5f5;
}
.small_txt{
	font-size: 8px;
}
.stop_row:hover>td,.detail_row:hover>td{
	background: #fff !important;
}
tr.custom--success td,tr.custom--success:hover > td,tr.hovered td,tr.hovered:hover > td {
  background: #b5b5b5 !important; /*custom color here add !important if you don't want the hover color*/
}
.head-table .fa{
	cursor: pointer;
}
</style>




<!-- /*****************************/ -->

<section class="content-header">
	<h1>
	<?php echo $page_title?>
	<small><?php echo $sub_title?></small>
	</h1>
	<ol class="breadcrumb">
		<li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
		<li><a href="#"><?php echo $page_title?></a></li>
		<li class="active"><?php echo $sub_title?></li>
	</ol>
</section>
<!-- Main content -->
<section class="content">
	<!-- Default box -->
	<div class="box planscreen">
		<form action="" method="POST">
			<div class="box-body">
				<div class="row">
					<div class="col-md-7" style="padding-right: 2px;">
						<ul class="nav nav-tabs" id="myTab" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="customer-orders-tab" data-toggle="tab" href="#customer-orders" role="tab" aria-controls="customer-orders" aria-selected="true">Buy Customer Orders</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-orders-tab" data-toggle="tab" href="#range-orders" role="tab" aria-controls="range-orders" aria-selected="false">Buy Range Orders</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTabContent">
						    <div class="tab-pane fade active in" id="customer-orders" role="tabpanel" aria-labelledby="customer-orders-tab">
						    	<table class="table head-table" style="margin-bottom:0px">
						    		<tbody>
										<tr>
											<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
												<i class="fa fa-edit" onclick="editorder()"></i>
												<i class="fa fa-trash"></i>
												<select onchange="this.form.submit()" name="by_customer_order_search">
													<?php
													$customer_id = isset($_POST["by_customer_order_search"]) ? $_POST["by_customer_order_search"] : "";
													foreach($customers->result() as $row){
														if($row->id==$customer_id){
															echo "<option value='".$row->id."' selected>".$row->name."</option>";
														}else{
															echo "<option value='".$row->id."'>".$row->name."</option>";
														}
													}
													?>
												</select>
											</th>
										</tr>
									</tbody>
								</table>
								<table class="table table-striped table-bordered table-hover order-clickable-table" id="table-draggable1">
									<tr>
			                            <th>Order ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Pickup Time</th>
			                            <th>Weight</th>
			                            <th>Volume</th>
			                            <th>Quantity</th>
			                            <th>Mode</th>
			                        </tr>
			                        <tbody class="connectedSortable" id="connectedSortable">
			                        <?php foreach($orders as $or){ ?>
			                        <tr id="<?php echo $or['id'];?>" data-orderid="<?php echo $or['id'];?>">
			                            <td><?php echo $or['order_id']; ?></td>
			                            <td><?php echo $or['pickup_city']; ?></td>
			                            <td><?php echo $or['delivery_city']; ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($or['pickup_datetime'])); ?></td>
			                            <td><?php echo $or['weight']." KGS"; ?></td>
			                            <td><?php echo $or['volume']." CUFT"; ?></td>
			                            <td><?php echo $or['quantity']; ?></td>
			                            <td><?php echo $or['transport_mode']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="range-orders" role="tabpanel" aria-labelledby="range-orders-tab">
						    	
					    		<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9"><!-- <i class="fa fa-plus-square" onclick="return addorder();"></i> -->
											<i class="fa fa-edit"></i>
											<i class="fa fa-trash"></i>
											<?php
												$range = isset($_POST["by_range_order_search"]) ? $_POST["by_range_order_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_order_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
									<table class="table table-striped table-bordered table-hover" id="table-draggable1">
									<tr>
			                            <th>Order ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Pickup Time</th>
			                            <th>Weight</th>
			                            <th>Volume</th>
			                            <th>Quantity</th>
			                            <th>Mode</th>
			                        </tr>

			                        <tbody class="connectedSortable" id="connectedSortable">
			                        <?php foreach($orders as $or){ ?>
			                        <tr id="<?php echo $or['id'];?>">
			                            <td><?php echo $or['order_id']; ?></td>
			                            <td><?php echo $or['pickup_city']; ?></td>
			                            <td><?php echo $or['delivery_city']; ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($or['pickup_datetime'])); ?></td>
			                            <td><?php echo $or['weight']." KGS"; ?></td>
			                            <td><?php echo $or['volume']." CUFT"; ?></td>
			                            <td><?php echo $or['quantity']; ?></td>
			                            <td><?php echo $or['transport_mode']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						</div>
						
					</div>	
					<div class="col-md-5">
						<div class="box-header" style="background-color: #f9f9f9;padding: 4px;">
						    <h3 class="box-title" style="font-size: 14px;">Shipment Route</h3>
						</div>
						<span id="main" style="text-align: center;"></span>
						<div class="box-body" id="map_route" style="padding: 2px;">	
                        </div>
					</div>
			    </div>
			    <div class="row">
					<div class="col-md-6" style="padding-right: 2px;">
						<ul class="nav nav-tabs active" id="myTab1" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="customer-shipments-tab" data-toggle="tab" href="#customer-shipments" role="tab" aria-controls="customer-shipments" aria-selected="true">Buy Customer Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="range-shipments-tab" data-toggle="tab" href="#range-shipments" role="tab" aria-controls="range-shipments" aria-selected="false">Buy Range Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="total-shipments-tab" data-toggle="tab" href="#total-shipments" role="tab" aria-controls="total-shipments" aria-selected="false">Total Shipments</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTab1Content">
						    <div class="tab-pane fade active in" id="customer-shipments" role="tabpanel" aria-labelledby="customer-shipments-tab">
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="3">
											<i class="fa fa-plus-square" onclick="return addshipment();"></i>
											<i class="fa fa-edit" onclick="return editShipment();"></i>
											<i class="fa fa-trash"></i>
											<select onchange="this.form.submit()" name="by_customer_sipment_search">
												<?php
												$customer_id = isset($_POST["by_customer_sipment_search"]) ? $_POST["by_customer_sipment_search"] : "";
												foreach($customers->result() as $row){
													if($row->id==$customer_id){
														echo "<option value='".$row->id."' selected>".$row->name."</option>";
													}else{
														echo "<option value='".$row->id."'>".$row->name."</option>";
													}
												}
												?>
											</select>
										</th>
										<th colspan="6"><b style="color:green;">New Shipments</b></th>
									</tr>
								</table>
								<table class="table table-bordered table-hover left-shipment-table clickable-table">
									<thead>
										<tr>
											<th></th>
				                            <th>Shipment ID</th>
				                            <th>Start Date</th>
				                            <th>End Date</th>
				                            <th>Source</th>
				                            <th>Destination</th>
				                            <th>Vehicle Type</th>
				                            <th>Mode</th>
				                            <th>Weight</th>
				                            <th>Volume</th>
				                            <th>Units</th>
				                        </tr>
				                    </thead>
			                        <tbody class="connectedSortable">
			                        <?php foreach($shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments" class="table-draggable2 shipment_row" data-shipmentid='<?php echo $sh['id'];?>'>
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($sh['startdate'])); ?></td>
			                            <td><?php echo date('d,M H:i a',strtotime($sh['enddate'])); ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="range-shipments" role="tabpanel" aria-labelledby="range-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-plus-square"></i>
											<i class="fa fa-edit"></i>
											<i class="fa fa-trash"></i>
											<?php
												$range = isset($_POST["by_range_shipment_search"]) ? $_POST["by_range_shipment_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_shipment_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments1" class="table-draggable2">
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="total-shipments" role="tabpanel" aria-labelledby="total-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-plus-square"></i>
											<i class="fa fa-edit"></i>
											<i class="fa fa-trash"></i>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments2" class="table-draggable2">
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						</div>
					</div>
					<div class="col-md-6" style="padding-left: 2px;">
						<ul class="nav nav-tabs active" id="myTab2" role="tablist">
						    <li class="nav-item active">
						        <a class="nav-link active" id="intransit-customer-shipments-tab" data-toggle="tab" href="#intransit-customer-shipments" role="tab" aria-controls="intransit-customer-shipments" aria-selected="true">Buy Customer Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-range-shipments-tab" data-toggle="tab" href="#intransit-range-shipments" role="tab" aria-controls="intransit-range-shipments" aria-selected="false">Buy Range Shipments</a>
						    </li>
						    <li class="nav-item">
						        <a class="nav-link" id="intransit-total-shipments-tab" data-toggle="tab" href="#intransit-total-shipments" role="tab" aria-controls="intransit-total-shipments" aria-selected="false">Total Shipments</a>
						    </li>
						</ul>
						<div class="tab-content" id="myTab2Content">
						    <div class="tab-pane fade active in" id="intransit-customer-shipments" role="tabpanel" aria-labelledby="intransit-customer-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="3">
											<i class="fa fa-edit"></i>
											<i class="fa fa-trash"></i>
											<select onchange="this.form.submit()" name="by_customer_intransit_sipment_search">
												<?php
												$customer_id = isset($_POST["by_customer_intransit_sipment_search"]) ? $_POST["by_customer_intransit_sipment_search"] : "";
												foreach($customers->result() as $row){
													if($row->id==$customer_id){
														echo "<option value='".$row->id."' selected>".$row->name."</option>";
													}else{
														echo "<option value='".$row->id."'>".$row->name."</option>";
													}
												}
												?>
											</select>
										</th>
										<th colspan="6"><b style="color:green;">In-Transit Shipments</b></th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover">
										<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($in_transit_shipments as $sh){
			                        	$capacity = getOccupancy($sh['id']);
			                        ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments3" class="table-draggable2">
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?> (<?php echo $capacity; ?>%)<progress value="<?php echo $capacity; ?>" max="100" style='height: 0.8rem;'></progress></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="intransit-range-shipments" role="tabpanel" aria-labelledby="intransit-range-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-edit"></i> 
											<i class="fa fa-trash"></i>
											<?php
												$range = isset($_POST["by_range_intransit_shipment_search"]) ? $_POST["by_range_intransit_shipment_search"] : "1";
											?>
											<select onchange="this.form.submit()" name="by_range_intransit_shipment_search">
											    <option value="1" <?php if($range == "1") echo "selected"; ?>>1</option>
											    <option value="2" <?php if($range == "2") echo "selected"; ?>>2</option>
											    <option value="5" <?php if($range == "5") echo "selected"; ?>>5</option>
											    <option value="10" <?php if($range == "10") echo "selected"; ?>>10</option>
											    <option value="20" <?php if($range == "20") echo "selected"; ?>>20</option>
											    <option value="50" <?php if($range == "50") echo "selected"; ?>>50</option>
											    <option value="100" <?php if($range == "100") echo "selected"; ?>>100</option>
											    <option value="200" <?php if($range == "200") echo "selected"; ?>>200</option>
											    <option value="500" <?php if($range == "500") echo "selected"; ?>>500</option>
											</select>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover">
									<tr>
			                            <th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($in_transit_shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments4" class="table-draggable2">
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						    <div class="tab-pane fade" id="intransit-total-shipments" role="tabpanel" aria-labelledby="intransit-total-shipments-tab">
								
								<table class="table head-table" style="margin-bottom:0px">
									<tr>
										<th colspan="9">
											<i class="fa fa-edit"></i>
											<i class="fa fa-trash"></i>
										</th>
									</tr>
								</table>
								<table class="table table-striped table-bordered table-hover">
									<tr>
										<th></th>
			                            <th>Shipment ID</th>
			                            <th>Source</th>
			                            <th>Destination</th>
			                            <th>Vehicle Type</th>
			                            <th>Mode</th>
			                            <th>Gross Weight</th>
			                            <th>Gross Volume</th>
			                            <th>Units</th>
			                        </tr>
			                        <tbody class="connectedSortable">
			                        <?php foreach($in_transit_shipments as $sh){ ?>
			                        <tr id="<?php echo $sh['id'];?>_shipments5" class="table-draggable2">
			                            <td onclick="return getshipmentdetail(this,'<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><i class="fa fa-plus-square"></i></td>
			                            <td onclick="return getshipmentroute('<?php echo $sh['id'];?>');" style='color:#002b55;cursor: pointer;'><?php echo $sh['shipmentid']; ?></td>
			                            <td><?php echo $sh['splace']; ?></td>
			                            <td><?php echo $sh['eplace']; ?></td>
			                            <td><?php echo $sh['vehicle_type']; ?></td>
			                            <td><?php echo $sh['transport_mode']; ?></td>
			                            <td><?php echo $sh['weight']." KGS"; ?></td>
			                            <td><?php echo $sh['volume']." CUFT"; ?></td>
			                            <td><?php echo $sh['units']; ?></td>
			                        </tr>
			                        <?php } ?>
			                    	</tbody>
								</table>
						    </div>
						</div>
					</div>
			    </div>
			</div>
		</form>
		<!-- /.box-body -->
	</div>
</section>
<div class="modal containerModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" style="font-weight: bold;">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Modal body text goes here.</p>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
		$('.clickable-table > tbody >tr').on('click', function (ele) {
		    $('.custom--success').removeClass('custom--success');
		    $(this).addClass('custom--success');
		});
		$('.order-clickable-table > tbody >tr').on('click', function (ele) {
		    $('.custom--success').removeClass('custom--success');
		    $(this).addClass('custom--success');
		});
		$("body").addClass("sidebar-collapse");
	});
	function editShipment() {
		if($(".clickable-table").find(".custom--success").length>0){
			var shipment_id = $(".clickable-table").find(".custom--success").data("shipmentid");

			$.ajax({
	            url:"<?=base_url('shipmentplan/editShipment')?>",
	            data:{"shipment_id":shipment_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Shipment::"+shipment_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}

	function editorder(){
		if($(".order-clickable-table").find(".custom--success").length>0){
			var order_id = $(".order-clickable-table").find(".custom--success").data("orderid");
			$.ajax({
	            url:"<?=base_url('shipmentplan/createorder')?>",
	            data:{"order_id":order_id},
	            type:"POST",
	            beforeSend:function(){
	            	$(".buffer").show();
	                $(".containerModal").modal("show");
	                $(".containerModal").find(".modal-title").html("Edit Order::"+order_id);
	                $(".containerModal").find(".modal-body").html("<center><progress></center>");
	            },
	            success:function(data){
	            	$(".buffer").hide();
	            	$(".containerModal").find(".modal-body").html(data);
	            }
	        });
		}
	}
	function getshipmentroute(sid){
		$.ajax({
			url:baseurl+"shipmentplan/maproute",
			type:"POST",
			data:{"shipment_id":sid},
			beforeSend:function(){
				$('#main').addClass('loader');
			},
			success:function(data){
				$('#bar').val(100);
				$('#main').removeClass("loader");
				$('#map_route').html(data);
			}
		});
	}
	function getshipmentdetail(ele,sid) {
		if($(ele).find(".fa").hasClass("fa-plus-square")){
			$.ajax({
				url:baseurl+"shipmentplan/stopdetail",
				type:"POST",
				data:{"shipment_id":sid},
				beforeSend:function(){
					$(".shipment_row").each(function(){
						$(this).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
					});
					$(ele).find(".fa-plus-square").removeClass("fa-plus-square").addClass("fa-minus-square");
					$(".stop_row,.detail_row").each(function(){
						$(this).remove();
						$(this).remove();
					});
					$('#main').addClass('loader');
				},
				success:function(data){
					$(ele).closest("tr").after(data);
				}
			});
		}else{
			$(ele).find(".fa-minus-square").removeClass("fa-minus-square").addClass("fa-plus-square");
			$(".stop_row,.detail_row").each(function(){
				$(this).remove();
				$(this).remove();
			});
		}
		
	}
	$(document).ready(function() {
	  	var $tabs = $('.table-draggable2')
	  	$("tbody#connectedSortable")
	    .sortable({
	      connectWith: ".connectedSortable",
	      appendTo: $tabs,
	      helper: "clone",
	      zIndex: 999990
	    });
	    /*.disableSelection();*/
	  	$($tabs).droppable({
	    accept: ".connectedSortable tr",
	    hoverClass: "hovered",
	    drop: function(event, ui) {
	    	/*alert(ui.draggable.text());*/
	    	/*$(this).addClass( "ui-state-highlight" );*/
	    	var str = $(this).attr('id');
 			var ordid = ui.draggable.attr('id');
 			if (ordid.indexOf("_shipments") !=-1) {
 			}else{
 				var key_val = str.split('_');
 				var sid = key_val[0];
				$.ajax({
				 method: "POST",
				 url: baseurl+"shipmentplan/orderintoshipment",
				 data:{'ship_id': sid,'ordid': ordid}, 
				}).done(function( data ) {
				 var result = $.parseJSON(data);
				 console.log(result);
				 $("#"+ordid).html("");
				});
			}
	      	return false;
	    }
	  	});
	});

	function addshipment(){
		$.ajax({
            url:"<?=base_url('shipmentplan/addshipment')?>",
            data:{},
            type:"POST",
            beforeSend:function(){
            	$(".buffer").show();
                $(".containerModal").modal("show");
                $(".containerModal").find(".modal-title").html("New Shipment");
                $(".containerModal").find(".modal-body").html("<center><progress></center>");
            },
            success:function(data){
            	$(".buffer").hide();
            	$(".containerModal").find(".modal-body").html(data);
            }
        });
	}
	getshipmentroute(108);
</script>
<style type="text/css">
	.planscreen{
		font-size: 10px;
	}
	.planscreen table tr th{
		font-weight: bold;
	}
	.planscreen table tr th i{
		padding: 2px;
	}
	.table>thead>tr>th, .table>tbody>tr>th, .table>tfoot>tr>th, .table>thead>tr>td, .table>tbody>tr>td, .table>tfoot>tr>td {
		padding: 2px !important;
	}
	.loader {
	  	border: 2px solid #f3f3f3;
	    border-radius: 50%;
	    border-top: 2px solid blue;
	    border-right: 2px solid green;
	    border-bottom: 2px solid red;
	    border-left: 2px solid pink;
	    width: 40px;
	    height: 40px;
	  	-webkit-animation: spin 2s linear infinite;
	  	animation: spin 2s linear infinite;
	}
	@-webkit-keyframes spin {
	  0% { -webkit-transform: rotate(0deg); }
	  100% { -webkit-transform: rotate(360deg); }
	}
	@keyframes spin {
	  0% { transform: rotate(0deg); }
	  100% { transform: rotate(360deg); }
	}
	#connectedSortable tr{
		cursor: move;
	}
.nav-tabs>li.active>a, .nav-tabs>li.active>a:hover, .nav-tabs>li.active>a:focus {
    color: #7bbfe8;
    background-color: #fff;
    border: 1px solid #ddd;
    border-bottom-color: transparent;
    cursor: default;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
    background: #DCDCDC;
    border: 1px solid #ABA9A9;
    border-radius: 7.5px 7.5px 0 0;
}
.nav-tabs>li>a {
    margin-right: 2px;
    line-height: 1.42857143;
    border: 1px solid transparent;
    border-radius: 4px 4px 0 0;
    padding: 4px 8px;
    color: #7bbfe8;
	border-color: #eee #eee #ddd;
	background: #f7f7f7;
}
.nav-tabs>li>a::after{
    -webkit-transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    transform: perspective(5px) rotateX(0.93deg) translateZ(-1px);
    -webkit-transform-origin: 0 0;
}
.map-footer{
	position: absolute;
	bottom: 0;
}
.shipment_row:nth-child(odd) > td{
	background-color: #f5f5f5;
}
.small_txt{
	font-size: 8px;
}
.stop_row:hover>td,.detail_row:hover>td{
	background: #fff !important;
}
tr.custom--success td,tr.custom--success:hover > td,tr.hovered td,tr.hovered:hover > td {
  background: #b5b5b5 !important; /*custom color here add !important if you don't want the hover color*/
}
.head-table .fa{
	cursor: pointer;
}
</style>