<link rel="stylesheet" href="<?= base_url() ?>assets/plugins/datatables/dataTables.bootstrap.css">
<link rel="stylesheet" href="<?= base_url() ?>assets/css/order_common_new.css">
<style type="text/css">
    .uploadederror {
        max-height: 200px;
        overflow-x: scroll;
        overflow-y: scroll;
    }

    .uploaded {
        padding: 30px;
        max-height: 400px;
        overflow-x: scroll;
        overflow-y: scroll;
        padding-top: 0;
    }

    .table > tbody > tr > td {
        padding: 2px;
    }

    .bordercolor {
        border-color: #ecabab;
    }

    .MandateryField {
        border-color: red;
        background: #f3f3b7;
    }
</style>
<?php
$serviceIds = [];
$serviceData = getServiceMasterData();
foreach ($serviceData as $eachLine) :
    $serviceIds[] = $eachLine['id'];
endforeach;
?>
<section class="content-header">
    <h1>
        <?= $pageTitle ?? "" ?>
        <small><?= $pageTitle ?? "" ?></small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="<?= base_url() ?>"><i class="fa fa-home"></i> Home</a></li>
        <li class="active">Dashboard</li>
        <li class="active">
            <?= $pageTitle ?? "" ?>
        </li>
    </ol>
</section>
<section class="content">
    <div class="box box-default">
        <div class="box-header with-border">
            <div class="alertsuccess"></div>
        </div>
        <?php
        $userId = $userId ?? $this->session->userdata('user_id');
        $companyCode = $companyCode ?? $this->session->userdata('company_code');
        $branchCode = $branchCode ?? $this->session->userdata('branch_code');
        $vendorIds = getVendorIDs($userId, $companyCode, $branchCode);
        $existingDeliveryNotes = getDeliverynotesforOrders($userId);
        $achievaCustomer = $achievaCustomer ?? "";
        $errorLine = $errorLine ?? [];
        if (isset($orderDetails)): ?>
        <div class="box-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="panel panel-default body-panel">
                        <div class="panel-heading" role="tab" id="headingOne">
                            <h4 class="panel-title">
                                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                                   href="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    <b> Missing Data from Excel </b>
                                </a>
                            </h4>
                        </div>
                        <div id="collapseOne" class="panel-collapse collapse" role="tabpanel"
                             aria-labelledby="headingOnes">
                            <?php
                            if (!empty($message)):
                                $tableMessage = "<table class='table table-bordered' style='text-color:red;'>";
                                foreach ($message as $eachMessage):
                                    $tableMessage .= "<tr><td>" . $eachMessage . "</td></tr>";
                                endforeach;
                                $tableMessage .= "</table>";
                                echo $tableMessage;
                            endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 uploaded">
                        <h4> Data from uploaded file </h4>
                        <div class="box-tools">
                            <form action="<?= base_url('Excelimportachievaorders/addOrdersData') ?>" method="POST"
                                  id="shipform">
                                <div class="table-responsive">
                                    <table class="table">
                                        <tbody>
                                        <tr>
                                            <td colspan="39" style="width:95%;">
                                                <table width="100%" border="1">
                                                    <tr style="background-color: #002b55;text-align: center;color: #fff;">
                                                        <th style="text-align: center;"> DELIVERY NOTE</th>
                                                        <th style="text-align: center;"> SERVICE</th>
                                                        <th style="text-align: center;">COMPANY CODE</th>
                                                        <th style="text-align: center;"> BRANCH CODE</th>
                                                        <th style="text-align: center;"> CUSTOMER ID</th>
                                                        <th style="text-align: center;">PICKUP ID</th>
                                                        <th style="text-align: center;">PICKUP NAME</th>
                                                        <th style="text-align: center;">PICKUP STREET</th>
                                                        <th style="text-align: center;">PICKUP CITY</th>
                                                        <th style="text-align: center;">PICKUP STATE</th>
                                                        <th style="text-align: center;">PICKUP COUNTRY</th>
                                                        <th style="text-align: center;">PICKUP ZIPCODE</th>
                                                        <th style="text-align: center;">EARLY PIKCUP</th>
                                                        <th style="text-align: center;">LATE PICKUP</th>
                                                        <th style="text-align: center;">PICKUP PHONE</th>
                                                        <th style="text-align: center;">PICKUP FAX</th>
                                                        <th style="text-align: center;">PICKUP EMAIL</th>
                                                        <th style="text-align: center;">DROP ID</th>
                                                        <th style="text-align: center;">DROP NAME</th>
                                                        <th style="text-align: center;">DROP STREET</th>
                                                        <th style="text-align: center;">DROP CITY</th>
                                                        <th style="text-align: center;">DROP STATE</th>
                                                        <th style="text-align: center;">DROP COUNTRY</th>
                                                        <th style="text-align: center;">DROP ZIPCODE</th>
                                                        <th style="text-align: center;">EARLY DELIVERY</th>
                                                        <th style="text-align: center;">LATE DELIVERY</th>
                                                        <th style="text-align: center;">DROP PHONE</th>
                                                        <th style="text-align: center;">DROP FAX</th>
                                                        <th style="text-align: center;">DROP EMAIL</th>
                                                        <th style="text-align: center;">SHIPPER CODE</th>
                                                        <th style="text-align: center;">CONSIGNEE CODE</th>
                                                        <th style="text-align: center;width: 165px;"> Cargo Type</th>
                                                        <th style="text-align: center;width: 165px;"> GOODS
                                                            DESCRIPTION
                                                        </th>
                                                        <th style="text-align: center;width: 165px;"> QUANTITY</th>
                                                        <th style="text-align: center;width: 165px;"> LENGTH</th>
                                                        <th style="text-align: center;width: 165px;"> WIDTH</th>
                                                        <th style="text-align: center;width: 165px;"> HEIGHT</th>
                                                        <th style="text-align: center;width: 165px;"> WEIGHT</th>
                                                        <th style="text-align: center;width: 165px;"> VOLUME</th>
                                                        <th style="text-align: center;width: 165px;"> STACKABLE</th>
                                                        <th style="text-align: center;width: 165px;"> TRIP NO</th>
                                                        <th style="text-align: center;width: 165px;"> ROUTE</th>
                                                        <th style="text-align: center;width: 165px;"> DRIVER</th>
                                                        <th style="text-align: center;width: 165px;"> VEHICLE</th>
                                                        <th style="text-align: center;width: 165px;"> CARRIER</th>
                                                    </tr>
                                                    <?php
                                                    $i = 0;
                                                    foreach ($orderDetails as $eachRow):
                                                        $rowNumber = $eachRow['mainRowNumber'];
                                                        ?>
                                                        <tr>
                                                            <td style="vertical-align: top;">
                                                                <input type="text"
                                                                       onchange="checkdqnotevalue(<?= $i ?>)"
                                                                    <?php
                                                                    if ((in_array($eachRow['deliveryNote'], $existingDeliveryNotes, true))):
                                                                        $classOne = "MandateryField"; ?>
                                                                        title="Delivery Note already exits"
                                                                    <?php
                                                                    else:
                                                                        $classOne = "";
                                                                    endif; ?>
                                                                    <?php
                                                                    if (in_array("deliveryNote" . $rowNumber, $errorLine, true)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> <?= $classOne ?> alphanumeric"
                                                                       title="Delivery Note should be filled"
                                                                       name="orders[<?= $i ?>][deliveryNote]"
                                                                       id="deliveryNote_<?= $i ?>"
                                                                       value="<?= $eachRow['deliveryNote'] ?>"
                                                                       required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onchange="checkServiceValue(<?= $i ?>)" onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("service" . $rowNumber, $errorLine, true)):
                                                                        $class = "MandateryField";
                                                                    else:
                                                                        if (!in_array($eachRow['service'], $serviceIds, true)):
                                                                            $class = "MandateryField";
                                                                        else:
                                                                            $class = "";
                                                                        endif;
                                                                    endif;
                                                                    ?>
                                                                       title="Service value is missing"
                                                                       class="<?= $class ?>"
                                                                       id="service_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][service]"
                                                                       value="<?= $eachRow['service'] ?>">
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("companyCode" . $rowNumber, $errorLine, true)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif;
                                                                    ?>
                                                                    <?php
                                                                    if ($eachRow['companyCode'] != $companyCode):
                                                                        $classOne = "MandateryField"; ?> title="Master Data Mismatch"
                                                                    <?php
                                                                    else:
                                                                        $classOne = ""; ?> title="Please fill Company Code"
                                                                    <?php
                                                                    endif; ?>
                                                                       class="<?= $class ?> <?= $classOne ?> companyCode mandatory"
                                                                       info="<?= $eachRow['companyCode'] ?>"
                                                                       id="companyCode_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][companyCode]"
                                                                       value="<?= strtoupper($eachRow['companyCode']) ?>"
                                                                       readonly>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("branchCode" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                    <?php
                                                                    if ($eachRow['branchCode'] != $branchCode):
                                                                        $classOne = "MandateryField"; ?> title="Master Data Mismatch"
                                                                    <?php
                                                                    else:
                                                                        $classOne = ""; ?> title="Please fill Branch Code"
                                                                    <?php
                                                                    endif; ?>
                                                                       class="<?= $class ?> <?= $classOne ?> branchCode mandatory"
                                                                       name="orders[<?= $i ?>][branchCode]"
                                                                       value="<?= $eachRow['branchCode'] ?>"
                                                                       id="branchCode_<?= $i ?>" readonly>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input
                                                                    type="text"
                                                                    <?php
                                                                    if (in_array("customer_id" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                    <?php
                                                                    if ($eachRow['customerId'] != $achievaCustomer):
                                                                        $classOne = "MandateryField"; ?> title="Master Data Mismatch"
                                                                    <?php
                                                                    else:
                                                                        $classOne = ""; ?> title="Customer ID should be filled"
                                                                    <?php
                                                                    endif; ?> class=" <?= $class ?> <?= $classOne ?> mandatory"
                                                                    id="customerId_<?= $i ?>"
                                                                    name="orders[<?= $i ?>][customerId]"
                                                                    value="<?= $eachRow['customerId'] ?>"
                                                                    onkeyup="chekcustomerexists(<?= $i ?>); upper(this);"
                                                                    required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input type="hidden" name="orders[<?= $i ?>][pickupRowId]" value="<?= $eachRow['pickupRowId'] ?>">
                                                                <input type="hidden" name="orders[<?= $i ?>][customerRowId]" value="<?= $customerRowId ?? 0 ?>">
                                                                <input type="hidden" name="orders[<?= $i ?>][pickupLatitude]" value="<?= $eachRow['pickupLatitude'] ?>">
                                                                <input type="hidden" name="orders[<?= $i ?>][pickupLongitude]" value="<?= $eachRow['pickupLongitude'] ?>">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("pickupId" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> pool numeric mandatory"
                                                                       id="pickupId_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupId]"
                                                                       value="<?= $eachRow['pickupId'] ?>"
                                                                       onkeyup="upper(this);"
                                                                       title="Pickup ID should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("pickupName" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> pool mandatory"
                                                                       onkeyup="upper(this);" id="pickupName_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupName]"
                                                                       value="<?= strtoupper($eachRow['pickupName']) ?>"
                                                                       title="Name should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeyup="upper(this);"
                                                                       onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool mandatory"
                                                                       id="pickupStreet_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupStreet]"
                                                                       value="<?= strtoupper($eachRow['pickupStreet']) ?>"
                                                                       title="Street Should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool mandatory"
                                                                       id="pickupCity_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupCity]"
                                                                       onkeyup="upper(this);"
                                                                       value="<?= strtoupper($eachRow['pickupCity']) ?>"
                                                                       title="City should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeyup="upper(this);"
                                                                       onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool mandatory"
                                                                       id="pickupState_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupState]"
                                                                       value="<?= strtoupper($eachRow['pickupState']) ?>"
                                                                       title="State should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeyup="upper(this);"
                                                                       onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool mandatory"
                                                                       id="pickupCountry_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupCountry]"
                                                                       value="<?= strtoupper($eachRow['pickupCountry']) ?>"
                                                                       title="Country should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool numeric mandatory"
                                                                       id="pickupPincode_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupPincode]"
                                                                       value="<?= $eachRow['pickupPincode'] ?>"
                                                                       title="Pincode should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> datetimepicker checkdt"
                                                                       name="orders[<?= $i ?>][earlyPickup]"
                                                                       id="earlyPickup_<?= $i ?>"
                                                                       value="<?= $eachRow['earlyPickup'] ?>"
                                                                       title="Early Pickup should e filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> datetimepicker checkdt"
                                                                       id="latePickup_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][latePickup]"
                                                                       value="<?= $eachRow['latePickup'] ?>"
                                                                       title="Late Pickup Should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("pickupPhone" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> pool numeric"
                                                                       id="pickupPhone_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][pickupPhone]"
                                                                       value="<?= $eachRow['pickupPhone'] ?>"
                                                                       title="Phone should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = "" ?> class="<?= $class ?> pool"
                                                                       name="orders[<?= $i; ?>][pickupFax]"
                                                                       value="<?= $eachRow['pickupFax'] ?>"
                                                                       title="Fax should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> email"
                                                                       name="orders[<?= $i ?>][pickupEmail]"
                                                                       id="pickupEmail_<?= $i ?>"
                                                                       value="<?= $eachRow['pickupEmail'] ?>" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input type="hidden" name="orders[<?= $i ?>][dropRowId]" value="<?= $eachRow['dropRowId'] ?>">
                                                                <input type="hidden" name="orders[<?= $i ?>][dropLatitude]" value="<?= $eachRow['dropLatitude'] ?>">
                                                                <input type="hidden" name="orders[<?= $i ?>][dropLongitude]" value="<?= $eachRow['dropLongitude'] ?>">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("dropId" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       title="ID should be filled"
                                                                       class="mandatory <?= $class ?> pool numeric"
                                                                       name="orders[<?= $i ?>][dropId]"
                                                                       value="<?= $eachRow['dropId'] ?>" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool"
                                                                       onkeyup="upper(this);" id="dropName_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropName]"
                                                                       value="<?= strtoupper($eachRow['dropName']) ?>"
                                                                       title="Name should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool "
                                                                       onkeyup="upper(this);" id="dropStreet_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropStreet]"
                                                                       value="<?= strtoupper($eachRow['dropStreet']) ?>"
                                                                       title="Street should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool"
                                                                       id="dropCity_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropCity]"
                                                                       value="<?= strtoupper($eachRow['dropCity']) ?>"
                                                                       title="City should be filled"
                                                                       onkeyup="upper(this);" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool"
                                                                       id="dropState_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropState]"
                                                                       value="<?= strtoupper($eachRow['dropState']) ?>"
                                                                       title="State should be filled"
                                                                       onkeyup="upper(this);" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool"
                                                                       id="dropCountry_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropCountry]"
                                                                       value="<?= strtoupper($eachRow['dropCountry']) ?>"
                                                                       onkeyup="upper(this);"
                                                                       title="Country should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="mandatory <?= $class ?> pool"
                                                                       id="dropPincode_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropPincode]"
                                                                       value="<?= $eachRow['dropPincode'] ?>"
                                                                       title="Pincode should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> datetimepicker checkdt"
                                                                       name="orders[<?= $i ?>][earlyDrop]"
                                                                       id="earlyDrop_<?= $i ?>"
                                                                       value="<?= $eachRow['earlyDrop'] ?>"
                                                                       title="Early Delivery should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> datetimepicker checkdt"
                                                                       id="lateDrop_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][lateDrop]"
                                                                       value="<?= $eachRow['lateDrop'] ?>"
                                                                       title="Late delivery should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool numeric"
                                                                       id="dropPhone_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropPhone]"
                                                                       value="<?= $eachRow['dropPhone'] ?>"
                                                                       title="Phone should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> pool"
                                                                       name="orders[<?= $i ?>][drop_fax]"
                                                                       value="<?= $eachRow['dropFax'] ?>"
                                                                       title="Fax should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text" <?php
                                                                $class = ""; ?> class="<?= $class ?> email"
                                                                       id="dropEmail_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][dropEmail]"
                                                                       value="<?= $eachRow['dropEmail'] ?>"
                                                                       title="Email should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input type="hidden" name="orders[<?= $i ?>][shipperRowId]" value="<?= $eachRow['shipperRowId'] ?>">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("shipperCode" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> shipperCode"
                                                                       id="shipperCode_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][shipperCode]"
                                                                       value="<?= $eachRow['shipperCode'] ?>"
                                                                       title="Shipper code is empty" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input type="hidden" name="orders[<?= $i ?>][consigneeRowId]" value="<?= $eachRow['consigneeRowId'] ?>">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("consigneeCode" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="<?= $class ?> consigneeCode"
                                                                       id="consigneeCode_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][consigneeCode]"
                                                                       value="<?= $eachRow['consigneeCode'] ?>"
                                                                       title="Consignee code is empty" required>
                                                            </td>
                                                            <td colspan="9">
                                                                <table class="table">
                                                                    <?php
                                                                    $j = 0;
                                                                    foreach ($eachRow['cargoDetails'] as $cargo):
                                                                        $cargoRowNumber = $cargo['CargoRowNumber'];
                                                                        ?>
                                                                        <tr>
                                                                            <td>
                                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                                       type="text"
                                                                                    <?php
                                                                                    if (in_array(
                                                                                        "cargoType" . $cargoRowNumber,
                                                                                        $errorLine
                                                                                    )):
                                                                                        $class = "bordercolor";
                                                                                    else:
                                                                                        $class = "";
                                                                                    endif; ?>
                                                                                       id="cargtype_<?= $i . $j ?>"
                                                                                       class="mandatory <?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][cargoType]"
                                                                                       value="<?= strtoupper(
                                                                                           $cargo['cargoType']
                                                                                       ) ?>"
                                                                                       title="Cargo Type should be filled"
                                                                                       onkeyup="upper(this);" required>
                                                                            </td>
                                                                            <td>
                                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                                       type="text"
                                                                                    <?php
                                                                                    if (in_array(
                                                                                        "goods_description" . $cargoRowNumber,
                                                                                        $errorLine
                                                                                    )):
                                                                                        $class = "bordercolor";
                                                                                    else:
                                                                                        $class = "";
                                                                                    endif; ?>
                                                                                       class="<?= $class ?>"
                                                                                       i="dgd_<?= $i . $j ?>"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][goodsDescription]"
                                                                                       value="<?= strtoupper(
                                                                                           $cargo['goodsDescription']
                                                                                       ) ?>" onkeyup="upper(this);"
                                                                                       title="Goods Desc should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input type="number"
                                                                                    <?php
                                                                                    if (in_array(
                                                                                        "quantity" . $cargoRowNumber,
                                                                                        $errorLine
                                                                                    )):
                                                                                        $class = "bordercolor";
                                                                                    else:
                                                                                        $class = "";
                                                                                    endif; ?>
                                                                                       class="<?= $class ?> pool numeric"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][quantity]"
                                                                                       value="<?= $cargo['quantity'] ?>"
                                                                                       min='1'
                                                                                       id="quantity_<?= $i . $j ?>"
                                                                                       title="Quantity Should be filled"
                                                                                       required>
                                                                            </td>
                                                                            <td>
                                                                                <input type="text" <?php
                                                                                $class = ""; ?> id="length_<?= $i . $j ?>"
                                                                                       class="decimal<?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][length]"
                                                                                       value="<?= $cargo['length'] ?>"
                                                                                       title="Legth should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input type="text" <?php
                                                                                $class = ""; ?> id="width_<?= $i . $j ?>"
                                                                                       class="decimal<?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][width]"
                                                                                       value="<?= $cargo['width'] ?>"
                                                                                       title="Width should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input type="text" <?php
                                                                                $class = ""; ?> id="height_<?= $i . $j ?>"
                                                                                       class="decimal<?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][height]"
                                                                                       value="<?= $cargo['height'] ?>"
                                                                                       title="Height should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input type="text" <?php
                                                                                $class = ""; ?> id="weight_<?= $i . $j ?>"
                                                                                       class="decimal <?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][weight]"
                                                                                       value="<?= $cargo['weight'] ?>"
                                                                                       title="Weight should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input type="text" <?php
                                                                                $class = ""; ?>id="volume_<?= $i . $j ?>"
                                                                                       class="decimal <?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][volume]"
                                                                                       value="<?= $cargo['volume'] ?>"
                                                                                       title="Volume should be filled">
                                                                            </td>
                                                                            <td>
                                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                                       type="text" <?php
                                                                                $class = ""; ?> class="<?= $class ?> pool"
                                                                                       name="orders[<?= $i ?>][cargoDetails][<?= $j ?>][stackable]"
                                                                                       value="<?= $cargo['stackable'] ?>"
                                                                                       title="Stackable Should be filled"
                                                                                       required>
                                                                            </td>
                                                                        </tr>
                                                                        <?php
                                                                        $j++;
                                                                    endforeach; ?>
                                                                </table>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("trip_no" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="mandatory <?= $class ?> tripNumber"
                                                                       id="tripNumber_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][tripNumber]"
                                                                       value="<?= $eachRow['tripNumber'] ?>" title="" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("route" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="mandatory <?= $class ?> route"
                                                                       id="route_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][route]"
                                                                       value="<?= $eachRow['route'] ?>" title="" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("driver" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="mandatory <?= $class ?> driver"
                                                                       id="driver_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][driver]"
                                                                       value="<?= $eachRow['driver'] ?>"
                                                                       title="Driver Name should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="return isNonSpecialCharCheck(event);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("vehicleNumber" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif; ?>
                                                                       class="mandatory <?= $class ?> vehicleNumber"
                                                                       id="vehicleNumber_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][vehicleNumber]"
                                                                       value="<?= $eachRow['vehicleNumber'] ?>"
                                                                       title="Vehicle No should be filled" required>
                                                            </td>
                                                            <td style="vertical-align: top;">
                                                                <input onkeypress="vendorautocomplete(<?= $i ?>); return isNonSpecialCharCheck(event);"
                                                                       onkeyup="chekvendorexists(<?= $i ?>);"
                                                                       type="text"
                                                                    <?php
                                                                    if (in_array("carrier" . $rowNumber, $errorLine)):
                                                                        $class = "bordercolor";
                                                                    else:
                                                                        $class = "";
                                                                    endif;
                                                                    if (!(in_array($eachRow['carrier'], $vendorIds))):
                                                                        $classOne = "MandateryField"; ?> title="Carrier Doesn't exits"
                                                                    <?php
                                                                    else:
                                                                        $classOne = "";
                                                                    endif; ?>
                                                                       class="mandatory<?= $class ?> <?= $classOne ?> carrier"
                                                                       id="carrier_<?= $i ?>"
                                                                       name="orders[<?= $i ?>][carrier]"
                                                                       value="<?= $eachRow['carrier'] ?>"
                                                                       title="Carrier should be filled" required>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        $i++;
                                                    endforeach;
                                                    ?>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="left">
                                                <button type="submit" class="submitbutton btn btn-primary btn-small"
                                                        onclick="event.preventDefault(); validateMyForm();"
                                                        style="background-color: #002b55;">Submit
                                                </button> &nbsp;&nbsp;&nbsp;<a class="btn btn-primary btn-small"
                                                                               style="background-color: #002b55;"
                                                                               href="<?= base_url() ?>smtcorders">Cancel</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div id="dialog" title="&nbsp;&nbsp;Alert">
                <p id="dialog-text"></p>
            </div>
            <script type="text/javascript">
                var c_code = [];
                var b_code = [];
                var bc_code = [];

                function checkdqnotevalue(id) {
                    var val = $('#deliveryNote_' + id).val();
                    if (val == "") {
                        if ($('#deliveryNote_' + id).hasClass('MandateryField')) {
                            $('#deliveryNote_' + id).removeClass('MandateryField');
                        }
                    } else {
                        $.ajax({
                            url: baseurl + 'Orderrevenues/checkdqnotevalue',
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                dq_note: val,
                            },
                            success: function (data) {
                                if (data == 0) {
                                    if ($('#deliveryNote_' + id).hasClass('MandateryField')) {
                                        $('#deliveryNote_' + id).removeClass('MandateryField');
                                        $('#deliveryNote_' + id).attr('');
                                    }
                                }
                                if (data == 1) {
                                    $('#deliveryNote_' + id).css('border-color', '');
                                    $('#deliveryNote_' + id).addClass('MandateryField');
                                    $('#deliveryNote_' + id).attr('title', 'Delivery Note already exists with another Order');
                                }
                            }
                        });
                    }
                }

                function vendorautocomplete(id) {
                    var vendor_ids = <?=json_encode($vendorIds)?>;
                    $('#carrier_' + id).autocomplete({
                        source: vendor_ids,
                        select: function (event, ui) {
                            $('#carrier_' + id).removeClass('MandateryField');
                            $('#carrier_' + id).attr('title', '');
                        }
                    });
                }

                $(".decimal").keypress(function (evt) {
                    var theEvent = evt;
                    var key = theEvent.keyCode || theEvent.which;
                    if (key === 9) {
                        return;
                    }
                    key = String.fromCharCode(key);
                    if (key.length == 0) return;
                    var regex = /^[0-9,\9\b]*\.?[0-9]*$/;
                    if (!regex.test(key)) {
                        theEvent.returnValue = false;
                        if (theEvent.preventDefault) theEvent.preventDefault();
                    }
                });

                function validateMyForm() {
                    var count = 0;
                    $(".mandatory").each(function () {
                        var nid = $(this).attr('id');
                        var value = $.trim($(this).val());
                        count = count + ($.trim($(this).val()) == "" ? 1 : 0);
                        if (value == "") {
                            if ($('#' + nid).hasClass('bordercolor')) {
                                $('#' + nid).removeClass('bordercolor');
                            }
                            $('#' + nid).addClass('MandateryField');
                        }
                    });
                    $(".MandateryField").each(function () {
                        var nid = $(this).attr('id');
                        var str = nid.split('_');
                        if ($.inArray(str[0], ['customerId', 'carrier', 'deliveryNote']) !== -1) {
                            count = count + 1;
                        }
                        var value = $.trim($(this).val());
                        if (value == "") {
                            count = count + 1;
                        }
                    });
                    $(".email").each(function () {
                        email = $.trim($(this).val());
                        if (email != "") {
                            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                            var id = $(this).attr('id');
                            if (!regex.test(email)) {
                                count = count + 1;
                                $('#' + id).addClass('MandateryField');
                                $('#' + id).attr('title', 'Please enter Email in correct format');
                            }
                        } else {
                            $('#' + id).css('border-color', 'lightskyblue');
                        }
                    });
                    $(".checkdt").each(function () {
                        var dateFormat = /^20\d{2}-(0[1-9]|1[0-2])-[0-3]\d\s([0-1][0-9]|2[0-3]):[0-5]\d$/;
                        var myDate = ($.trim($(this).val()));
                        var did = $(this).attr('id');
                    });
                    if (count > 0) {
                        $("#dialog").dialog();
                        $('.ui-dialog-title').addClass('fa fa-warning');
                        $(".ui-dialog").addClass('alert_zindex');
                        $("#dialog-text").html("Validation Failed");
                        $('.ui-dialog-titlebar-close').click(function () {
                            $('#popupreference_id').focus();
                        });
                        return false;
                    } else {
                        $('.submitbutton').attr('disabled', true);
                        $("#shipform").submit();
                        return true;
                    }
                }

                $(".numeric").keypress(function (evt) {
                    var theEvent = evt;
                    var key = theEvent.keyCode || theEvent.which;
                    var val = ($.trim($(this).val()) == "" ? 1 : 0);
                    if (key === 9) {
                        return;
                    }
                    key = String.fromCharCode(key);
                    if (key.length == 0) return;
                    var regex = /^[0-9,\9\b]*\.?[0-9]*$/;
                    if (!regex.test(key)) {
                        theEvent.returnValue = false;
                        if (theEvent.preventDefault) theEvent.preventDefault();
                        if (val == 1) {
                            $(this).css('border-color', 'red');
                        }
                    } else {
                        $(this).css('border-color', 'lightskyblue');
                    }
                });
                $(".email").keyup(function (evt) {
                    var theEvent = evt;
                    var email = ($.trim($(this).val()));
                    if (email != "") {
                        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                        if (!regex.test(email)) {
                            $(this).css('border-color', 'red');
                        } else {
                            $(this).css('border-color', 'lightskyblue');
                        }
                    }
                });
                $(".checkdt").change(function (evt) {
                    var theEvent = evt;
                    var myDate = ($.trim($(this).val()));
                    var dateFormat = /^20\d{2}-(0[1-9]|1[0-2])-[0-3]\d\s([0-1][0-9]|2[0-3]):[0-5]\d$/;
                    if (!myDate.match(dateFormat)) {
                        $(this).css('border-color', 'red');
                    } else {
                        $(this).css('border-color', 'lightskyblue');
                    }
                });
                $(".pool").keyup(function (evt) {
                    var theEvent = evt;
                    var val = ($.trim($(this).val()));
                    if (val.length == 0) {
                        $(this).css('border-color', '#ecabab');
                    } else {
                        $(this).css('border-color', 'lightskyblue');
                    }
                });
                $(".alphanumeric").keypress(function (evt) {
                    var theEvent = evt;
                    var key = theEvent.keyCode || theEvent.which;
                    key = String.fromCharCode(key);
                    if (key.length == 0) {
                        $(this).css('border-color', 'red');
                        if (theEvent.preventDefault) theEvent.preventDefault();
                    } else {
                        $(this).css('border-color', 'lightskyblue');
                    }
                });
                $(function () {
                    $('.datetimepicker').datetimepicker();
                });

                function isNonSpecialCharCheck(e) {
                    var keynum;
                    var keychar;
                    var numcheck;
                    if (window.event) {
                        keynum = e.keyCode;
                    } else if (e.which) {
                        keynum = e.which;
                    }
                    keychar = String.fromCharCode(keynum);
                    if (keychar == "'" || keychar == "`" || keychar == "~" || keychar == "+" || keychar == "/" || keychar == "\/" || keychar == "//" || keychar == "\\" || keychar == "<" || keychar == ">" || keychar == "^" || keychar == "|" || keychar == "!" || keychar == "$" || keychar == "#" || keychar == "&" || keychar == "%" || keychar == "*" || keychar == ":" || keychar == "?") {
                        return false;
                    } else {
                        return true;
                    }
                }

                function chekvendorexists(id) {
                    var code = $('#carrier_' + id).val();
                    c_code = <?=json_encode($vendorIds)?>;
                    if (jQuery.inArray(code, c_code) == '-1') {
                        if ($('#carrier_' + id).hasClass('MandateryField')) {
                        } else {
                            $('#carrier_' + id).addClass('MandateryField');
                            $('#carrier_' + id).attr('title', 'Master Data mismatch');
                        }
                    } else {
                        $('#carrier_' + id).removeClass('MandateryField');
                        $('#carrier_' + id).removeClass('mandatory');
                        $('#carrier_' + id).attr('title', '');
                    }
                }

                function chekcustomerexists(id) {
                    var code = $('#customerId_' + id).val();
                    var achievaCustomer = <?= $achievaCustomer ?>;
                    if (code != achievaCustomer) {
                        if ($('#customerId_' + id).hasClass('MandateryField')) {
                        } else {
                            $('#customerId_' + id).addClass('MandateryField');
                            $('#customerId_' + id).attr('title', 'Master Data mismatch');
                        }
                    } else {
                        $('#customerId_' + id).removeClass('MandateryField');
                        $('#customerId_' + id).removeClass('mandatory');
                        $('#customerId_' + id).attr('title', '');
                    }
                }

                function checkServiceValue(id) {
                    var code = $('#service_' + id).val();
                    var serviceIds = <?=json_encode($serviceIds)?>;
                    if (jQuery.inArray(code, serviceIds) == '-1') {
                        if ($('#service_' + id).hasClass('MandateryField')) {
                        } else {
                            $('#service_' + id).addClass('MandateryField');
                            $('#service_' + id).attr('title', 'Master Data mismatch');
                        }
                    } else {
                        $('#service_' + id).removeClass('MandateryField');
                        $('#service_' + id).removeClass('mandatory');
                        $('#service_' + id).attr('title', '');
                    }
                }
            </script>
            <div class="col-md-12"></div>
            <?php
            endif; ?>
            <div class="box-footer"></div>
        </div>
</section>
<style type="text/css">
    .nav > li > a > i {
        font-size: 25px;
        display: block;
        width: 100%;
    }

    .data_filled sup {
        display: none;
    }

    .shadow {
        border: #ddd solid 1px;
        margin: 0px;
        background-color: #ffffff;
        padding: 20px;
    }

    table.dataTable tbody > tr.selected td,
    table.dataTable tbody > tr > .selected {
        background-color: #B0BED9 !important;
    }

    body {
        font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
        font-weight: 400;
        overflow-x: hidden;
        overflow-y: auto;
    }

    .tab-content {
        padding: 5px;
    }

    .table-sm td,
    .table-sm th {
        padding: .3rem;
    }

    .modal-open .container-fluid,
    .modal-open .container,
    .modal-open .main-sidebar,
    .modal-open .main-header,
    .modal-open .content-header,
    .modal-open .main-footer {
        -webkit-filter: blur(1px);
        -moz-filter: blur(1px);
        -o-filter: blur(1px);
        -ms-filter: blur(1px);
        filter: blur(2px);
    }

    sup {
        top: 0.5em;
    }

    .nav > li > a {
        position: relative;
        display: block;
        padding: 5px 10px;
        font-weight: 600;
        color: #56b7e9;
        background: #f7f7f7;
        border: 1px solid transparent;
        border-color: #eee #eee #ddd;
    }

    .fa,
    .fas {
        font-weight: 600;
        font-size: 12px;
    }

    .modal-header {
        padding: 5px;
    }

    .modal-title {
        font-weight: bold;
        color: #56b7e9;
    }

    .model-body {
        padding: 5px !important;
    }

    .form-group {
        margin: 0px !important;
    }

    fieldset {
        font-family: sans-serif;
        border: 1px dotted #3c8dbc;
        background: transparent;
        border-radius: 5px;
        padding: 10px;
        margin-top: 15px;
        margin-bottom: 5px;
    }

    fieldset legend {
        color: #fff;
        padding: 0px 8px;
        font-size: 14px;
        border-radius: 5px;
        box-shadow: 0 0 0 5px #ddd;
        margin-left: 2px;
        text-transform: uppercase;
        background: #072e53;
    }

    .nav-tabs > li.active > a,
    .nav-tabs > li.active > a:hover,
    .nav-tabs > li.active > a:focus {
        color: #072e53;
        background-color: #fff;
        border: 1px solid #ddd;
        border-bottom-color: transparent;
        cursor: default;
        font-weight: 900;
    }

    .btn-default span {
        font-weight: bold;
        color: #56b7e9;
    }

    .dataTables_filter label {
        font-weight: bold !important;
        color: #56b7e9 !important;
    }

    th {
        font-weight: bold;
    }

    .table > tbody > tr > td {
        padding: 5px !important;
    }

    .datastable tbody td input[type="text"] {
        width: 100px;
    }

    .required_tab {
        font-weight: 900;
        font-size: 35px;
        top: -5px;
        color: red;
    }

    .k-input,
    input.k-textbox,
    textarea.k-textbox,
    input.k-textbox:hover,
    textarea.k-textbox:hover,
    .k-textbox > input,
    .k-multiselect-wrap {
        background-color: #ffffffbf;
        color: #333;
    }

    .k-autocomplete.k-state-default,
    .k-picker-wrap.k-state-default,
    .k-numeric-wrap.k-state-default,
    .k-dropdown-wrap.k-state-default {
        background-image: none;
        background-position: 50% 50%;
        background-color: #ffffff7d;
        border-color: #ccc;
    }

    .nav-tabs > li.active > a,
    .nav-tabs > li.active > a:hover,
    .nav-tabs > li.active > a:focus {
        color: #fafdfe;
        background-color: #072e53;
        border: 1px solid #ddd;
        border-bottom-color: transparent;
        cursor: default;
        font-weight: 900;
    }

    .table-striped > tbody > tr:nth-child(odd) > td,
    .table-striped > tbody > tr:nth-child(odd) > th {
        background-color: #f9f9f9c9;
    }

    .tab-content > .active {
        display: block;
        min-height: 250px;
    }

    .nav > li > a {
        position: relative;
        display: block;
        padding: 5px 10px;
        font-weight: 600;
        color: #56b7e9;
        background: #ffffff;
        border: 1px solid transparent;
        border-color: #fff #fff #ddd;
        border-top-left-radius: 10px !important;
        border-top-right-radius: 10px !important;
    }

    .nav > li > a > i {
        font-size: 25px;
        display: block;
    }

    .btn-light-blue {
        background: linear-gradient(to right, #0a87bd 0, #1ab5f8 100%);
        color: #fff;
        border-radius: 0;
        border: 0;
        padding: 3px 11px;
        position: relative;
    }

    .upload-btn-wrapper {
        position: relative;
        overflow: hidden;
        display: inline-block;
    }

    .upload-btn-wrapper input[type=file] {
        font-size: 100px;
        position: absolute;
        left: 0;
        top: 0;
        opacity: 0;
    }
</style>
