<?php
$this->load->helper('required_marker');
$company_code = $this->session->userdata('company_code');
$displayVehicleTypeForReport = checkAccessConditions('DISPLAY_VEHICLE_TYPE_FOR_REPORT',$company_code);
$postData = $postData ?? [];
$rateServiceRowIdForBook = $postData['rateServiceRowIdForBook'] ?? 0;
$shipper_details = $consignee_details = $pickup_details = [];
if (!empty($postData)):
    $shipper_details['name'] = $postData['pickupNameForBook'] ?? "";
    $shipperStreet = $postData['pickupStreetForBook'] ?? "";
    $shipperCity = $postData['pickupCityForBook'] ?? "";
    $shipperState = $postData['pickupStateForBook'] ?? "";
    $shipper_details['address'] = $shipperStreet . "," . $shipperCity . "," . $shipperState;
    $shipper_details['country'] = $postData['pickupCountryForBook'] ?? "";
    $shipper_details['pincode'] = $postData['pickupPincodeForBook'] ?? "";

    $consignee_details['name'] = $postData['consigneeNameForBook'] ?? "";
    $consigneeStreet = $postData['consigneeStreetForBook'] ?? "";
    $consigneeCity = $postData['consigneeCityForBook'] ?? "";
    $consigneeState = $postData['consigneeStateForBook'] ?? "";
    $consignee_details['address'] = $consigneeStreet . "," . $consigneeCity . "," . $consigneeState;
    $consignee_details['country'] = $postData['consigneeCountryForBook'] ?? "";
    $consignee_details['pincode'] = $postData['consigneePincodeForBook'] ?? "";
    $customerFromProfile = $postData['customerIdForBook'] ?? 0;
    $vendorFromProfile = $postData['vendorIdForBook'] ?? 0;
    if ($customerFromProfile > 0):
        $pickup_details['name'] = $postData['customerNameForBook'] ?? "";
        $pickup_details['party_id'] = $postData['customerCodeForBook'] ?? "";
        $customerCity = $postData['customerCityForBook'] ?? "";
        $customerState = $postData['customerStateForBook'] ?? "";
        $customerStreet = $postData['customerStreetForBook'] ?? "";
        $pickup_details['address'] = $customerStreet . "," . $customerCity . "," . $customerState;
        $pickup_details['country'] = $postData['customerCountryForBook'] ?? "";
        $pickup_details['pincode'] = $postData['customerPincodeForBook'] ?? "";
        $customerIdFromProfile = $postData['customerIdForBook'] ?? 0;
    endif;
    if ($vendorFromProfile > 0):
        $vendorIdFromProfile = $postData['vendorIdForBook'] ?? 0;
        $vendorCodeFromProfile = $postData['vendorCodeForBook'] ?? "";
    endif;
endif;
?>
<link
    href="<?= base_url(); ?>assets/newtheme/css/appdev-style.css"
    rel="stylesheet" type="text/css"/>
<link href="<?= base_url(); ?>assets/sweetalerts/sweetalert.css" rel="stylesheet" type="text/css"/>
<div class="content-page">
    <div class="content">
        <?php
        if ($this->session->flashdata('success_msg')):
            echo "<div class='flashmessages alert alert-success'>" . $this->session->flashdata('success_msg') . "</div>";
        endif;
        if ($this->session->flashdata('error_msg')):
            echo "<div class='flashmessages alert alert-danger'>" . $this->session->flashdata('error_msg') . "</div>";
        endif;
        if ($this->session->flashdata('edierror_msg')):
            echo ' <div class="alert alert-danger alert-dismissable"> <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>' . $this->session->flashdata('edierror_msg') . '</div>';
            unset($_SESSION['edierror_msg']);
        endif;
        unset($_SESSION['success_msg']);
        unset($_SESSION['error_msg']);
        ?>
        <div class="container">
            <div class="row">
                <?php
                $transport = gettransportmode();
                $cust_id = "0";
                if ($this->session->userdata('cust_id')):
                    $cust_id = $this->session->userdata('cust_id');
                    if ($cust_id == ""):
                        $cust_id = "0";
                    endif;
                endif;
                $ordertypes = getOrderTypes($cust_id, $company_code);
                ?>
                <div class="col-xs-12">
                    <div class="filter-section mtop15 bg-white ptlbr20">
                        <div class="col-md-9 col-sm-12">
                            <div class="row">
                                <form method="POST"
                                      onsubmit="return checkseachvalidation(this);"
                                      action="<?= base_url(); ?>smtcorders" id="search_orders">
                                    <div class="col-sm-2">
                                        <div class="form-group">
                                            <?php
                                            $post = $this->input->post();
                                            $selecfromdate = (isset($post['fromdate'])) ? $post['fromdate'] : '';
                                            ?>
                                            <input type="text"
                                                   class="form-control" form="search_orders"
                                                   placeholder="<?= $this->lang->line('general_from_date'); ?>"
                                                   name="fromdate" id="fromDate"
                                                   value="<?= $selecfromdate; ?>" autocomplete="off"> <i
                                                class="icon tru-icon-calendar"></i>
                                        </div>

                                    </div>
                                    <div class="col-sm-2">
                                        <?php
                                        $selectodate = (isset($post['todate'])) ? $post['todate'] : ''; ?>
                                        <div class="form-group">
                                            <input type="text" class="form-control" form="search_orders"
                                                   name="todate" id="toDate"
                                                   placeholder="<?= $this->lang->line('general_to_date'); ?>"
                                                   value="<?= $selectodate; ?>" autocomplete="off"> <i
                                                class="icon tru-icon-calendar"></i>
                                        </div>
                                    </div>
                                    <?php
                                    $company_code = $this->session->userdata('company_code');
                                    $inbrnchcode = $this->session->userdata('branch_code');
                                    ?>
                                    <div class="col-sm-2">
                                        <?php
                                        $bookingid = (isset($post['bookingid'])) ? $post['bookingid'] : [];
                                        if (empty($bookingid)):
                                            $bookingid = isset($getbookingid) ? $getbookingid : [];
                                        endif;
                                        if ($this->session->flashdata('booking') != ""):
                                            $bookingid = $this->session->flashdata('booking');
                                        endif;

                                        ?>
                                        <input type="hidden" name="ats_parties" id="ats_parties" value='<?php
                                        if (!empty($ats_parties)):
                                            echo $ats_parties;
                                        endif;
                                        ?>'>
                                        <div class="form-group">
                                            <select form="search_orders" name="bookingid[]"
                                                    id="bookingid" class="form-control bookingid"
                                                    multiple="multiple"
                                                    placeholder="<?= $this->lang->line('booking_id'); ?>">
                                                <?php
                                                foreach ($bookingid as $res):
                                                    $sel = "selected";
                                                    echo "<option value='" . $res . "'$sel>" . $res . "</option>";
                                                endforeach;
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-2">
                                        <?php
                                        $orderstatus = getOrderStatus();
                                        $selectstatus = $post['status'] ?? '';
                                        ?>
                                        <div class="form-group">
                                            <select class="form-control" id="searchstatus" name="status">
                                                <option value=""><?= $this->lang->line('general_select'); ?></option>
                                                <?php
                                                foreach ($orderstatus as $res):
                                                    ?>
                                                    <option
                                                        value="<?= $res ?>"
                                                        <?php
                                                        if (strtoupper($selectstatus) == $res):
                                                            echo "selected";
                                                        endif;
                                                        ?>><?= $res ?></option>
                                                <?php
                                                endforeach; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-2">
                                        <button type="submit" name="searchsubmit" id="searchsubmit"
                                                class="btn  btn-primary btn_color"
                                                value="Search"><?= $this->lang->line('search_orders'); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-12">
                            <div class="filter_icons">
                                <div class="navbar pull-right">
                                    <a id="adv_filter" href="#" data-action="open"
                                       data-side="right" data-toggle="tooltip" data-placement="top"
                                       title="Advanced Search" class="adv_filter"> <i
                                            class="icon tru-icon-search-adv"></i>
                                    </a>
                                    <div class="dropdown">
                                        <button class="dropbtn">
                                            <span class="icon tru-icon-quick-menu"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="<?= base_url(); ?>smtcorders/neworder"><i
                                                    class="icon tru-icon-add"></i><?= $this->lang->line('new_order'); ?></a>
                                            <a href="#" data-toggle="modal" id="quickBookId"
                                               data-target="#quickbook_popup"><i
                                                    class="icon tru-icon-quickbook"></i><?= $this->lang->line('quickbook'); ?></a>
                                            <?php
                                            $base_url = base_url();
                                            $company_code = $this->session->userdata('company_code');
                                            $country_code = substr($company_code, 0, 2);
                                            $imglink = $base_url . "assets/ordertemplate/ordertemplate.xlsx";
                                            $file = $base_url . "assets/ordertemplate/" . $country_code . "-ordertemplate.xlsx";
                                            if (file_exists("assets/ordertemplate/" . $country_code . "-ordertemplate.xlsx")):
                                                $imglink = $file;
                                            endif;
                                            ?>
                                            <input type="hidden" name="chkcompanycode" id="chkcompanycode" value="<?= strtoupper($this->session->userdata('company_code')); ?>">
                                            <input type="hidden" name="chkbranchcode" id="chkbranchcode" value="<?= strtoupper($this->session->userdata('branch_code')); ?>">
                                            <a href="<?= $imglink; ?>"><i
                                                    class="icon tru-icon-template"></i><?= $this->lang->line('order_template'); ?></a>
                                            <a href="#" id='buttonid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('upload_excel'); ?></a>
                                            <form
                                                action="<?= base_url(); ?>Excelimportorders/orderbooking"
                                                id="excelform" method="POST" enctype="multipart/form-data">
                                                <input type="file" name="import_file" id="exlfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <form
                                                action="<?= base_url(); ?>Indorderexcelimport/orderbooking"
                                                id="excelform" method="POST" enctype="multipart/form-data">
                                                <input type="file" name="import_file" id="indexlfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <form
                                                action="<?= base_url(); ?>Auexcleimportorders/orderbooking"
                                                id="excelform" method="POST" enctype="multipart/form-data">
                                                <input type="file" name="import_file" id="indexaufile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>

                                            <?php
                                            if (($this->session->userdata('company_code') == 'SGKN') || ($this->session->userdata('company_code') == 'INFD')): ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/MDT-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('mdt_template'); ?></a>
                                                <a href="#"
                                                   id='buttonsgid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upd_mdt'); ?></a>
                                                <form
                                                    action="<?= base_url(); ?>Excelimportorders/uploadsgexcel"
                                                    id="exlsgfile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="exlsgupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                            <?php
                                            else: ?>
                                                <a href="<?= base_url(); ?>assets/ordertemplate/Achieva-ordertemplate.xlsx"><i
                                                        class="icon tru-icon-template"></i><?= $this->lang->line('achieva_template') ?></a>
                                                <a href="#"
                                                   id='buttonachievaid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('upd_achieva') ?></a>
                                                <form
                                                    action="<?= base_url(); ?>Excelimportachievaorders/uploadexcel"
                                                    id="buttonachievafile" method="POST" enctype="multipart/form-data">
                                                    <input type="file" name="import_file" id="buttonachievaupfile"
                                                           onchange="if (confirm('Are you sure to upload file?'))
                                                                           this.form.submit();"
                                                           style="display: none">
                                                </form>
                                            <?php
                                            endif; ?>
                                            <a href="#"
                                               onclick="importFromGSheets();"><i
                                                    class="icon tru-icon-excel"></i> <?= $this->lang->line('import_gsheets'); ?></a>
                                            <a href="#" onclick="generateBulkLabel(event);"><i class="icon tru-icon-pdf"></i> <?= $this->lang->line('generate_bulk_label'); ?></a>
                                            <a href="#" onclick="newtripcreate(event);"><i
                                                    class="glyphicon glyphicon-plus"></i> <?= $this->lang->line('trip_create'); ?></a>
                                            <a href="#"
                                               onclick="newtripcreate(event, 'multi');"><i
                                                    class="glyphicon glyphicon-plus"></i> <?= $this->lang->line('trip_create') . ' ' . $this->lang->line('bill_bulk'); ?></a>
                                            <a href="#"
                                               onclick="sendorderdetailsclick(event);"><i
                                                    class="glyphicon glyphicon-plus"></i> <?= $this->lang->line('roadlog'); ?></a>
                                            <a href="#"
                                               onclick="shipmentxmlclick(event)"><i
                                                    class="glyphicon glyphicon-hand-up"></i> <?= $this->lang->line('kn_login'); ?></a>
                                            <a href="#"
                                               onclick="sendShipmentStatusxml(event)"><i
                                                    class="fa fa-hourglass-start" aria-hidden="true"></i> <?= $this->lang->line('leftmenu_status') . " " . $this->lang->line('to') . " " . $this->lang->line('kn_login') ?>
                                            <a href="<?= base_url('bulkupload') ?>"><i
                                                    class="icon tru-icon-excel"></i><?= $this->lang->line('general_bulkupload'); ?></a>
                                            <a
                                                href="<?= base_url(); ?>assets/cargo_update.xlsx"><i
                                                    class="icon tru-icon-template"></i>Cargo Update Template</a>
                                            <a href="#" id='buttoncargoid'><i class="icon tru-icon-excel"></i> <?= $this->lang->line('cargo_update'); ?></a>
                                            <a href="<?= base_url('orderlistspecification') ?>"><i
                                                    class="glyphicon glyphicon-hand-up"></i>Order List Specification</a>
                                            <a href="#" data-toggle="modal" data-target="#forceClosediv"><i
                                                    class="glyphicon glyphicon-hand-up"></i>3M Shipments Force Close</a>
                                            <form
                                                action="<?= base_url(); ?>Ordercargoupdateexcel/getexceldata"
                                                id="exlcargofile" method="POST"
                                                enctype="multipart/form-data">
                                                <input type="file" name="exlcargoupfile" id="exlcargoupfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <a href="#" class="icon tru-icon-delete" onclick="deleteselectedrecords()"> Delete Records</a>

                                        </div>
                                    </div>
                                    <div class="dropdown">
                                        <button class="dropbtn">
                                            <i style="font-size: 18px;" class="fas fa-money-check-alt"></i>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="<?= base_url(); ?>assets/Rateupload.xlsx"><i
                                                    class="icon tru-icon-template"></i><?= $this->lang->line('charges_template'); ?></a>
                                            <a href="#" id='buttoncostid'><i class="icon tru-icon-excel"></i><?= $this->lang->line('import_charges'); ?></a>
                                            <form
                                                action="<?= base_url(); ?>Excelimportorders/ordercost"
                                                id="excelcostform" method="POST"
                                                enctype="multipart/form-data">
                                                <input type="file" name="import_costfile" id="exlcostfile"
                                                       onchange="if (confirm('Are you sure to upload file?'))
                                                                   this.form.submit();"
                                                       style="display: none">
                                            </form>
                                            <?php
                                            if ($bill_type == "Knbill"): ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceknbill(event);"><i
                                                        class="glyphicon glyphicon-plus"></i> Send To KNBilling</a>
                                            <?php
                                            else: ?>
                                                <a href="#"
                                                   onclick="readytoinvoiceforselected(event);"><i
                                                        class="icon tru-icon-tender-list"></i> Ready To Invoice</a>
                                                <a href="#"
                                                   onclick="filetrasnferfor_selectedorders(event);"><i
                                                        class="icon tru-icon-tender-list"></i>Send File to ACON</a>
                                            <?php
                                            endif; ?>
                                        </div>
                                    </div>
                                    <div class="dropdown">
                                        <button class="dropbtn">
                                            <span class="icon tru-icon-export"></span>
                                        </button>
                                        <div class="dropdown-content">
                                            <a href="#" onclick="orderExportOptions('excel')"><i
                                                    class="icon tru-icon-excel"></i><?= $this->lang->line('general_excel'); ?></a>
                                            <a href="#" onclick="orderExportOptions('pdf')"><i
                                                    class="icon tru-icon-pdf"></i><?= $this->lang->line('general_pdf'); ?></a>
                                            <a href="#" onclick="orderExportOptions('print')"><i
                                                    class="icon tru-icon-print"></i><?= $this->lang->line('general_print'); ?></a>
                                        </div>
                                    </div>

                                </div>

                            </div>

                        </div>
                    </div>
                    <div class="sidebars" id="sidebars_search" style="display: none">
                        <div class="advance_searchcol sidebar right" id="sidebar_search">
                            <div class="title_header">
                                <h2><?= $this->lang->line('order_list'); ?></h2>
                                <h3><?= $this->lang->line('general_advancesrch'); ?></h3>
                                <a href="javascript:void(0)" class="closebtn"
                                   data-action="close" data-side="right">&times;</a>
                            </div>
                            <?php
                            $products = getProductMasterData();
                            $service = getServiceMasterData();
                            ?>
                            <form method="POST"
                                  action="<?= base_url(); ?>smtcorders"
                                  onsubmit="return checkreference(this);" id="advsearch_orders">
                                <div class="custom-scroll">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <?php
                                            $selectbooking_id = (isset($post['order_id'])) ? $post['order_id'] : ''; ?>
                                            <div class="form-group">
                                                <label for="order_id"><?= $this->lang->line('booking_id'); ?> </label>
                                                <input type="text" name="order_id" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('booking_id'); ?>"
                                                       class="form-control" id="order_id" form="advsearch_orders"
                                                       value="<?= $selectbooking_id; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php
                                            $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php
                                            $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <?php
                                            $charge_list_type = isset($charge_list_type) ? $charge_list_type : ''; ?>
                                            <input type="hidden"
                                                   name="list_type" id="list_type"
                                                   value="<?= $list_type; ?>"> <input type="hidden"
                                                                                      name="cllist_type" id="cllist_type"
                                                                                      value="<?= $cllist_type; ?>">
                                            <input type="hidden"
                                                   name="charge_list_type" id="charge_list_type"
                                                   value="<?= $charge_list_type; ?>">
                                            <?php $knlogin_list_type = $knlogin_list_type ?? 0; ?>
                                            <input type="hidden" name="knlogin_list_type" id="knlogin_list_type" value="<?= $knlogin_list_type ?>">
                                            <?php
                                            $selectcustomer_id = (isset($post['searchcustomer_id'])) ? $post['searchcustomer_id'] : ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_id"><?= $this->lang->line('customer_id'); ?> </label>
                                                <input type="text" name="searchcustomer_id"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('customer_id'); ?>"
                                                       class="form-control" id="searchcustomer_id"
                                                       form="advsearch_orders"
                                                       value="<?= $selectcustomer_id; ?>">
                                            </div>

                                        </div>


                                        <div class="col-sm-6">
                                            <?php
                                            $list_type = isset($list_type) ? $list_type : ''; ?>
                                            <?php
                                            $cllist_type = isset($cllist_type) ? $cllist_type : ''; ?>
                                            <input type="hidden"
                                                   name="list_type" id="list_type"
                                                   value="<?= $list_type; ?>"> <input type="hidden"
                                                                                      name="cllist_type" id="cllist_type"
                                                                                      value="<?= $cllist_type; ?>">
                                            <?php
                                            $selectcustomer_name = (isset($post['searchcustomer_name'])) ? $post['searchcustomer_name'] : ''; ?>
                                            <div class="form-group">
                                                <label for="searchcustomer_name"><?= $this->lang->line('customer_name'); ?> </label>
                                                <input type="text" name="searchcustomer_name"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('customer_name'); ?>"
                                                       class="form-control" id="searchcustomer_name"
                                                       form="advsearch_orders"
                                                       value="<?= $selectcustomer_name; ?>">
                                            </div>

                                        </div>


                                        <div class="col-sm-6">
                                            <?php
                                            $selectservice = (isset($post['service'])) ? $post['service'] : ''; ?>
                                            <div class="form-group">
                                                <label for="service"><?= $this->lang->line('bpartner_service'); ?></label>
                                                <select class="form-control" name="service" id="service"
                                                        form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($service as $res):
                                                        ?>
                                                        <option
                                                            value="<?= $res['row_id']; ?>"
                                                            <?php
                                                            if ($selectservice == $res['row_id']):
                                                                echo "selected";
                                                            endif;
                                                            ?>><?= $res['id'] . "-" . $res['name']; ?></option>
                                                    <?php
                                                    endforeach;
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php
                                            $selectorder_status = (isset($post['order_status'])) ? $post['order_status'] : ''; ?>
                                            <div
                                                class="form-group">
                                                <label for="order_status"><?= $this->lang->line('bpartner_ordstatus'); ?></label>
                                                <select class="form-control" name="order_status"
                                                        id="order_status" form="advsearch_orders" name="status">
                                                    <option value="">All</option>
                                                    <?php
                                                    foreach ($orderstatus as $res):
                                                        ?>
                                                        <option value="<?= $res ?>"
                                                            <?php
                                                            if (strtoupper($selectorder_status) == $res):
                                                                echo "selected";
                                                            endif;
                                                            ?>><?= $res ?></option>
                                                    <?php
                                                    endforeach; ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <?php
                                            $selectorder_type = (isset($post['order_type'])) ? $post['order_type'] : ''; ?>
                                            <div class="form-group">
                                                <label for="order_type"><?= $this->lang->line('bpartner_ordtype'); ?></label>
                                                <select class="form-control" name="order_type"
                                                        id="order_type" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($ordertypes as $types):
                                                        if ($types['type_name'] != ""):
                                                            ?>
                                                            <option
                                                                value="<?= $types['type_id']; ?>"
                                                                <?php
                                                                if ($selectorder_type == $types['type_id']):
                                                                    echo "selected";
                                                                endif;
                                                                ?>><?= $types['type_name']; ?></option>
                                                        <?php
                                                        endif;
                                                    endforeach;
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectproduct = (isset($post['product'])) ? $post['product'] : ''; ?>
                                                <label for="product"><?= $this->lang->line('bpartner_product'); ?></label>
                                                <select name="product" class="form-control" id="product"
                                                        form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($products as $res):
                                                        ?>
                                                        <option
                                                            value="<?= $res['name']; ?>"
                                                            <?php
                                                            if ($selectproduct == $res['name']):
                                                                echo "selected";
                                                            endif;
                                                            ?>><?= $res['name']; ?></option>
                                                    <?php
                                                    endforeach;
                                                    ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selecttrasnport = (isset($post['modeof_trasnport'])) ? $post['modeof_trasnport'] : ''; ?>
                                                <label
                                                    for="modeof_trasnport"><?= $this->lang->line('bpartner_motransport'); ?></label>
                                                <select name="modeof_trasnport" class="form-control"
                                                        id="modeof_trasnport" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($transport as $mode):
                                                        ?>
                                                        <option
                                                            value="<?= $mode['code']; ?>"
                                                            <?php
                                                            if ($selecttrasnport == $mode['code']):
                                                                echo "selected";
                                                            endif;
                                                            ?>><?= $mode['name']; ?></option>
                                                    <?php
                                                    endforeach;
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectshipper_id = (isset($post['searchshipper_id'])) ? $post['searchshipper_id'] : ''; ?>
                                                <label
                                                    for="searchshipper_id"><?= $this->lang->line('qbook_shipperid'); ?></label>
                                                <input type="text" name="searchshipper_id"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('qbook_shipperid'); ?>"
                                                       class="form-control" id="searchshipper_id"
                                                       form="advsearch_orders"
                                                       value="<?= $selectshipper_id; ?>">
                                            </div>
                                        </div>


                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectshipper_name = (isset($post['searchshipper_name'])) ? $post['searchshipper_name'] : ''; ?>
                                                <label
                                                    for="searchshipper_id"><?= $this->lang->line('shipper_name'); ?></label>
                                                <input type="text" name="searchshipper_name"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('shipper_name'); ?>"
                                                       class="form-control" id="searchshipper_name"
                                                       form="advsearch_orders"
                                                       value="<?= $selectshipper_name; ?>">
                                            </div>
                                        </div>


                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectconsignee_id = (isset($post['searchconsignee_id'])) ? $post['searchconsignee_id'] : ''; ?>
                                                <label
                                                    for="consignee_id"><?= $this->lang->line('qbook_consigneeid'); ?></label>
                                                <input type="text" name="searchconsignee_id"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('qbook_consigneeid'); ?>"
                                                       class="form-control" id="searchconsignee_id"
                                                       form="advsearch_orders"
                                                       value="<?= $selectconsignee_id; ?>">
                                            </div>
                                        </div>


                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectconsignee_name = (isset($post['searchconsignee_name'])) ? $post['searchconsignee_name'] : ''; ?>
                                                <label
                                                    for="consignee_name"><?= $this->lang->line('consignee_name'); ?></label>
                                                <input type="text" name="searchconsignee_name"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('consignee_name'); ?>"
                                                       class="form-control" id="searchconsignee_name"
                                                       form="advsearch_orders"
                                                       value="<?= $selectconsignee_name; ?>">
                                            </div>
                                        </div>


                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectdelivery_note = (isset($post['delivery_note'])) ? $post['delivery_note'] : ''; ?>
                                                <label
                                                    for="delivery_note"><?= $this->lang->line('qbook_deliverynote'); ?></label>
                                                <input type="text" name="delivery_note"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('qbook_deliverynote'); ?>"
                                                       class="form-control" id="delivery_note"
                                                       form="advsearch_orders"
                                                       value="<?= htmlentities($selectdelivery_note, ENT_COMPAT, 'UTF-8'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $salog_ref = $post['salog_ref'] ?? ''; ?>
                                                <label for="salog_ref"><?= $this->lang->line(
                                                        'salog_ref'
                                                    ) ?></label>
                                                <input type="text" name="salog_ref" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('salog_ref') ?>"
                                                       class="form-control" id="salog_ref" form="advsearch_orders"
                                                       value="<?= $salog_ref ?>">
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectpurchase_order = (isset($post['purchase_order'])) ? $post['purchase_order'] : ''; ?>
                                                <label
                                                    for="purchase_order"><?= $this->lang->line('qbook_purchaseorder'); ?></label>
                                                <input type="text" name="purchase_order"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('qbook_purchaseorder'); ?>"
                                                       class="form-control" id="purchase_order"
                                                       form="advsearch_orders"
                                                       value="<?= htmlentities($selectpurchase_order, ENT_COMPAT, 'UTF-8'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selecttrip_id = $_POST['trip_id'] ?? ''; ?>
                                                <label for="trip_id"><?= $this->lang->line('trip_id'); ?></label>
                                                <input type="text" name="trip_id" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('trip_id'); ?>"
                                                       class="form-control" id="trip_id"
                                                       value="<?= $selecttrip_id; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php
                                            $order_jfr = $post['order_jfr'] ?? ''; ?>
                                            <div
                                                class="form-group">
                                                <label for="order_jfr"><?= $this->lang->line('general_jfr'); ?></label>
                                                <input type="text" name="order_jfr" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('general_jfr'); ?>"
                                                       class="form-control" id="order_jfr" form="advsearch_orders"
                                                       value="<?= htmlentities($order_jfr, ENT_COMPAT, 'UTF-8'); ?>">

                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <?php
                                            $order_reftype = (isset($post['order_reftype'])) ? $post['order_reftype'] : ''; ?>
                                            <div class="form-group">
                                                <label for="order_reftype"><?= $this->lang->line('bpartner_reftype'); ?></label>
                                                <select class="form-control" name="order_reftype"
                                                        id="order_reftype" form="advsearch_orders">
                                                    <option value="">Select</option>
                                                    <?php
                                                    foreach ($ref_names_arr as $res):
                                                        ?>
                                                        <option
                                                            value="<?= $res['name']; ?>"
                                                            <?php
                                                            if ($order_reftype == $res['name']):
                                                                echo "selected";
                                                            endif;
                                                            ?>><?= $res['name']; ?></option>
                                                    <?php
                                                    endforeach;
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <?php
                                            $ref_val = (isset($post['ref_val'])) ? $post['ref_val'] : ''; ?>
                                            <div
                                                class="form-group">
                                                <label for="ref_val"><?= $this->lang->line('referencevalue'); ?></label>
                                                <input type="text" name="ref_val" parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('referencevalue'); ?>"
                                                       class="form-control" id="ref_val" form="advsearch_orders"
                                                       value="<?= htmlentities($ref_val, ENT_COMPAT, 'UTF-8'); ?>">

                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectcompany_code = (isset($post['company_code'])) ? $post['company_code'] : ''; ?>
                                                <label
                                                    for="company_code"><?= $this->lang->line('general_company_code'); ?></label>
                                                <input type="text" name="company_code"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('general_company_code'); ?>"
                                                       class="form-control" id="company_code"
                                                       value="<?= $selectcompany_code; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectbranch_code = (isset($post['branch_code'])) ? $post['branch_code'] : ''; ?>
                                                <label for="branch_code"><?= $this->lang->line('general_branch_code'); ?></label>
                                                <input type="text" name="branch_code"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('general_branch_code'); ?>"
                                                       class="form-control" id="branch_code"
                                                       value="<?= $selectbranch_code; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectfrom_date = (isset($post['advfrom_date'])) ? $post['advfrom_date'] : ''; ?>
                                                <label
                                                    for="advfrom_date"><?= $this->lang->line('general_from_date'); ?></label>
                                                <input type="text" name="advfrom_date"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('general_from_date'); ?>"
                                                       class="form-control fromdate" id="advfrom_date"
                                                       value="<?= $selectfrom_date; ?>"
                                                       form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <?php
                                                $selectto_date = (isset($post['advto_date'])) ? $post['advto_date'] : ''; ?>
                                                <label for="advto_date"><?= $this->lang->line('general_to_date'); ?></label>
                                                <input type="text" name="advto_date"
                                                       parsley-trigger="change"
                                                       placeholder="<?= $this->lang->line('general_to_date'); ?>"
                                                       class="form-control todate" id="advto_date"
                                                       value="<?= $selectto_date; ?>"
                                                       form="advsearch_orders">
                                            </div>
                                        </div>

                                        <!------------pickup date range----------------------------------------->

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="advpickupfrom_date"><?=$this->lang->line('pickup_from_date')?></label>
                                                <input type="text" name="advpickupfrom_date" parsley-trigger="change" placeholder="<?=$this->lang->line('pickup_from_date')?>" class="form-control fromdate" id="advpickupfrom_date" value="<?=$post['advpickupfrom_date'] ?? ''; ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="advpickupto_date"> <?=$this->lang->line('pickup_to_date')?></label>
                                                <input type="text" name="advpickupto_date" parsley-trigger="change" placeholder="<?=$this->lang->line('pickup_to_date')?>" class="form-control todate" id="advpickupto_date" value="<?=$post['advpickupto_date'] ?? ''; ?>" form="advsearch_orders">
                                            </div>
                                        </div>

                                    <!------------Delivery date range----------------------------------------->

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="advdeliveryfrom_date"> <?=$this->lang->line('delivery_from_date')?></label>
                                                <input type="text" name="advdeliveryfrom_date" parsley-trigger="change" placeholder="<?=$this->lang->line('delivery_from_date')?>" class="form-control fromdate" id="advdeliveryfrom_date" value="<?=$post['advdeliveryfrom_date'] ?? ''; ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="advdeliveryto_date"> <?=$this->lang->line('delivery_to_date')?></label>
                                                <input type="text" name="advdeliveryto_date" parsley-trigger="change" placeholder="<?=$this->lang->line('delivery_to_date')?>" class="form-control todate" id="advdeliveryto_date" value="<?=$post['advdeliveryto_date'] ?? ''; ?>" form="advsearch_orders">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="footer-search">

                                    <div class="top20 ">
                                        <div class="view_more text-center">
                                            <button type="submit" name="searchsubmit"
                                                    class="btn  btn-primary btn_color"
                                                    value="<?= $this->lang->line('general_search'); ?>"><?= $this->lang->line('search_orders'); ?></button>
                                            <button type="Reset" name="reset"
                                                    class="btn btn-default btn_color resetbtn">Reset
                                            </button>

                                        </div>


                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="content-section mtop10 bg-white mb70">
                        <div class="main-datatable">
                            <div class="table-responsive minheight">
                                <table id="orderslist"
                                       class="table table-striped table-bordered forcheckboxes"
                                       style="width: 100%">
                                    <thead>
                                    <tr>
                                        <th class="shoring_icon_no">
                                            <div class="checkbox checkbox-info">
                                                <label> <input type="checkbox" class="checkAll" value=""> <span
                                                        class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                </label>
                                            </div>
                                        </th>
                                        <th class="shoring_icon_no"></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('booking_id'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('qbook_deliverynote'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('salog_ref'); ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('customer_name'); ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('pickup'); ?></th>
                                        <th><i class="fa fa-address-card" aria-hidden="true"></i><?= $this->lang->line('general_delivery'); ?></th>
                                        <th><i class="fa fa-list-alt" aria-hidden="true"></i><?= $this->lang->line('trip_no'); ?></th>
                                        <th><i class="fa fa-hourglass-start"></i><?= $this->lang->line('general_status'); ?></th>
                                        <th><i class="fa fa-hourglass-start" aria-hidden="true"></i><?= $this->lang->line('otherstatus'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('created_date'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('pic_date'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('estimated_delivery_date'); ?></th>
                                        <th><i class="icon tru-icon-calendar"></i><?= $this->lang->line('deliverydate'); ?></th>
                                        <th><i class="icon tru-icon-truck-emp"></i><?= $this->lang->line('bpartner_motransport'); ?></th>
                                        <?php if ($displayVehicleTypeForReport) { ?>
                                          <th><i class="icon tru-icon-truck-emp"></i><b> <?php echo $this->lang->line('truck_ttype'); ?></b></th>
                                          <th><i class="icon tru-icon-truck-emp"></i><b> <?php echo $this->lang->line('vehicle_no'); ?></b></th>
                                        <?php } ?>
                                        <th><i class="fa fa-archive" aria-hidden="true"></i><?= $this->lang->line('total_packages'); ?></th>
                                        <th style="min-width: 220px;"><i class="fa fa-money"></i><?= $this->lang->line('general_jfr'); ?></th>
                                        <th style="min-width: 220px;"><i class="fa fa-money"></i><?= $this->lang->line('billing_status'); ?></th>
                                        <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('actual_weight'); ?></th>
                                        <th><i class="icon tru-icon-weight"></i><?= $this->lang->line('general_weight'); ?></th>
                                        <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('actual_volume'); ?></th>
                                        <th><i class="icon tru-icon-volume"></i><?= $this->lang->line('general_volume'); ?></th>
                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_company_code'); ?></th>
                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('general_branch_code'); ?></th>
                                        <th><i class="fa fa-building" aria-hidden="true"></i><?= $this->lang->line('from') . " " . $this->lang->line('general_source'); ?></th>
                                        <th><i class="icon tru-icon-calendar" aria-hidden="true"></i><?=  $this->lang->line('booking_updated'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('pq_ref'); ?></th>
                                        <th><i class="fa fa-pencil-square-o" aria-hidden="true"></i><?= $this->lang->line('external_customer'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="tbodyDynamicData">
                                    <?php
                                    if (!empty($order)):
                                        $i = 1;
                                        foreach ($order as $res): ?>
                                            <tr>
                                                <td>
                                                    <div class="checkbox checkbox-info">
                                                        <label>
                                                            <input type="checkbox" name="chck1" value="<?= $res['order_row_id']; ?>"
                                                                   class="recordcheckbox" id="<?= $res['order_row_id'] ?>">
                                                            <span class="cr"><i
                                                                    class="cr-icon fa fa-check"></i></span>
                                                        </label>
                                                    </div>
                                                </td>
                                                <td><input type="hidden"
                                                           id="row_newvvorder_<?= $i; ?>"
                                                           name="row_newvvorder_<?= $i; ?>"
                                                           value="<?= $res['order_row_id']; ?>"/>
                                                    <ul class="nav nav-tabs">

                                                        <li class="dropdown tablebtnrleft"><a
                                                                class="dropdown-toggle" data-toggle="dropdown" href="#"> <span
                                                                    class="icon  tru-icon-action-setting"></span>
                                                            </a>
                                                            <ul class="dropdown-menu" role="menu">
                                                                <li><a
                                                                        href="<?= base_url(); ?>smtcorders/vieworder/<?= $res['order_row_id']; ?>"
                                                                        id="viewo_<?= $res['order_row_id']; ?>"> <span
                                                                            class="icon tru-icon-view" aria-hidden="true"></span><?= $this->lang->line('general_view'); ?>
                                                                    </a></li>
                                                                <?php
                                                                $country_userids = $this->session->userdata("country_user_ids");
                                                                ?>
                                                                <?php if ($res['order_status'] != 'CANCELLED') : ?>
                                                                <li><a
                                                                        href="<?= base_url(); ?>smtcorders/editorder/<?= $res['order_row_id']; ?>"
                                                                        id="edito_<?= $res['order_row_id']; ?>"
                                                                        class="dt-edit"> <span class="icon tru-icon-edit"
                                                                                               aria-hidden="true"></span><?= $this->lang->line('general_edit'); ?>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>
                                                                <li><a
                                                                        href="#"
                                                                        onclick="deleteorderbyid(<?= $res['order_row_id']; ?>)"
                                                                        class="dt-delete"> <span class="icon tru-icon-delete"
                                                                                                 aria-hidden="true"></span><?= $this->lang->line('general_delete'); ?>
                                                                    </a></li>
                                                                <li><a
                                                                        href="<?= base_url(); ?>smtcorders/copyorder/<?= $res['order_row_id']; ?>"
                                                                        class="dt-delete"
                                                                        id="copyco_<?= $res['order_row_id']; ?>"> <span
                                                                            class="fa fa-clone" aria-hidden="true"></span><?= $this->lang->line('copy_order'); ?>
                                                                    </a></li>
                                                                <li><a href="<?= base_url(); ?>smtcorders/reverseorder/<?= $res['order_row_id']; ?>" class="dt-delete">
                                                                        <span
                                                                            class="icon tru-icon-edit"
                                                                            id="revero_<?= $res['order_row_id']; ?>"
                                                                            aria-hidden="true"></span><?= $this->lang->line('reverse_order'); ?>
                                                                    </a></li>
                                                                <li><a
                                                                        href="<?= base_url(); ?>kntruckwaybill/index/<?= $res['order_row_id']; ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate_twb'); ?>
                                                                    </a>
                                                                </li>
                                                                </li>

                                                                <li><a
                                                                        href="<?php
                                                                        echo base_url(); ?>smtcorders/orderlabel/<?= $res['order_row_id'];
                                                                        ?>">
                                                                        <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('print_label'); ?>
                                                                    </a></li>
                                                                <?php
                                                                if ($res['internalinvoice'] != "" && $res['internalinvoice'] > 0): ?>
                                                                    <li><a
                                                                            href="<?php
                                                                            echo base_url(); ?>Generatebillinginvoice/internalbubilling/<?= $res['order_row_id'];
                                                                            ?>">
                                                                            <span class="fas fa fa-file-pdf-o" aria-hidden="true"></span><?= $this->lang->line('generate') . " " . $this->lang->line('internal_invoice'); ?>
                                                                        </a></li>
                                                                <?php
                                                                endif; ?>
                                                                <?php if($res['salog_ref'] != "") : ?>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/sendepodtosalog/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_salog_epod'); ?>
                                                                        </a>
                                                                    </li>
                                                                    <?php if ($res['order_status'] == "CLOSED") : ?>
                                                                        <li>
                                                                            <a href="<?= base_url()?>shipments/retriggersalogstatuses/<?= $res['order_row_id'] ?>">
                                                                                <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('retrigger_salog_statuses'); ?>
                                                                            </a>
                                                                        </li>
                                                                    <?php endif;endif; ?>
                                                                <?php if(checkCustomerHasAltovaConnection($res['order_row_id']) != 0) :?>
                                                                    <li>
                                                                        <a href="<?= base_url()?>carriercommonedi/sendAltovaOrder/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span><?= $this->lang->line('send_order_to_roadlog'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php endif; ?>
                                                                <?php if($res['created_source'] == 18 && $res['order_status'] == "CLOSED") : ?>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggerepodtoroadlog/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog Epod
                                                                        </a>
                                                                    </li>
                                                                    <li>
                                                                        <a href="<?= base_url()?>shipments/retriggerroadlogstatuses/<?= $res['order_row_id'] ?>">
                                                                            <span class="fas fa fa-paper-plane" aria-hidden="true"></span>Re-trigger Raodlog statuses
                                                                        </a>
                                                                    </li>
                                                                <?php endif;
                                                                if ($res['created_source'] == 5) : ?>
                                                                <li>
                                                                    <a href="javascript:void(0);" onclick="fetchSALOGDocs(<?= $res['order_row_id']; ?>)" ><span class="fas fa fa-file-pdf-o"></span><?= $this->lang->line('download')." ".$this->lang->line('salog_ref')." ".$this->lang->line('documents'); ?> </a>
                                                                </li>
                                                            <?php endif; ?>
                                                                <?php if ($res['order_status'] == 'PENDING') : ?>
                                                                    <li>
                                                                        <a href="<?= base_url() ?>Orderdata/cancelOrder/<?= $res['order_row_id'] ?>">
                                                                            <span class="icon tru-icon-delete" aria-hidden="true"></span><?= $this->lang->line('cancel_order'); ?>
                                                                        </a>
                                                                    </li>
                                                                <?php endif; ?>
                                                            </ul>
                                                        </li>
                                                    </ul>
                                                </td>
                                                <td><?= $res['order_id']; ?></td>
                                                <td style="word-break: break-word;"><?= $res['delivery_note']; ?></td>
                                                <td><?= $res['salog_ref']; ?></td>
                                                <td><?= $res['customer_name']; ?></td>
                                                <td><?= $res['pickup']; ?></td>
                                                <td><?= $res['delivery']; ?></td>
                                                <td><?= $res['trip_no']; ?></td>
                                                <td><?= $res['order_status']; ?></td>
                                                <td><?= $res['otherstatus']; ?></td>
                                                <td><?= date('Y-m-d', strtotime($res['createdon'])); ?></td>
                                                <td><?= date('Y-m-d h:i A', strtotime($res['pickup_date'])); ?></td>
                                                <td><?= date('Y-m-d h:i A', strtotime($res['delivery_date'])); ?></td>
                                                <td><?= $res['final_delivery']; ?></td>
                                                <td><?= $res['transport_mode']; ?></td>
                                                <?php if ($displayVehicleTypeForReport) { ?>
                                                <td><?= $res['vehicle_type']; ?></td>
                                                <td><?= $res['vehicle_number']; ?></td>
                                                <?php } ?>
                                                <td><?= $res['total_packages']; ?></td>
                                                <td><?= $res['final_jfr']; ?></td>
                                                <td style="min-width: 220px;"><?= $res['html']; ?></td>
                                                <td><?php
                                                    if ($res['weight'] > 0):
                                                        echo round((float)$res['weight'], 3) . " Kgs";
                                                    endif;
                                                    ?></td>
                                                <td><?php
                                                    if ($res['second_weight'] > 0):
                                                        echo round((float)$res['second_weight'], 3) . " Kgs";
                                                    endif;
                                                    ?></td>
                                                <td><?php
                                                    if ($res['volume'] > 0):
                                                        echo round((float)$res['volume'], 3) . " Cbm";
                                                    endif;
                                                    ?></td>
                                                <td><?php
                                                    if ($res['second_volume'] > 0):
                                                        echo round((float)$res['second_volume'], 3) . " Cbm";
                                                    endif;
                                                    ?></td>
                                                <td><?= $res['company_code']; ?></td>
                                                <td><?= $res['branch_code']; ?></td>
                                                <td><?= (new \App\Libraries\OrderCreationSourceHelper())->getOrderSourceName($res['created_source']);?></td>
                                                <td><?=  date('Y-m-d h:i A',strtotime($res['updatedDate']))?></td>
                                                <td><?= $res['pq_ref']; ?></td>
                                                <td><?= $res['external_customer']; ?></td>
                                            </tr>
                                            <?php
                                            $i++;
                                        endforeach;
                                        ?>
                                    <?php
                                    endif; ?>
                                    </tbody>
                                </table>

                            </div>
                            <div class="sidebars" id="sidebars_list" style="display: none">
                                <div class="advance_searchcol sidebar right" id="sidebar_list">

                                    <div class="title_header">
                                        <h2>IN0303200041</h2>
                                        <h3>Booking ID</h3>
                                        <a href="javascript:void(0)" class="closebtn"
                                           data-action="close" data-popup="open-data" data-side="right">&times;</a>
                                    </div>
                                    <div class="custom-scroll"
                                         style="max-height: 250px; overflow-y: auto;">
                                        <form action="#">
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <label for="">Product</label>
                                                        <p>Product Name</p>

                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Company Code </label>
                                                            <p>INKN</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Order Status</label>
                                                            <p>Pending</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Inco Term</label>
                                                            <p>Inco Term Details</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Branch Code</label>
                                                            <p>INHYD</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Customer ID</label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Delivery Terms </label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Department Code </label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">SRMT</label>
                                                            <p>STREET NO.2,ALIPURDUAR, INDIA, 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Order Type</label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Service</label>
                                                            <p>-</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Mode Of Transport</label>
                                                            <p>Full Truck Load</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="title_header">

                                                        <h3>Routing Details</h3>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Shipper ID </label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Shipper Name </label>
                                                            <p>SRMT</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Early Pickup </label>
                                                            <p>2020-03-06 08:00:00</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Late Pickup </label>
                                                            <p>2020-03-06 10:00:00</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Location</label>
                                                            <p>Street No.2, Alipurduar, India - 735211</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Phone</label>
                                                            <p>9909990999</p>

                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="form-group">
                                                        <div class="form-group">
                                                            <label for="">Email</label>
                                                            <p>kevin@gmail.com</p>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                            <div class="footer-view_list">

                                                <div class="top20 ">
                                                    <div class="view_more text-center">
                                                        <button type="submit" name="submit"
                                                                class="btn btn-default btn_color ">Edit Details
                                                        </button>
                                                        <button type="Reset" name="reset"
                                                                class="btn btn-default btn_color resetbtn">View More
                                                            Details
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="loadplanconnote_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;"><?= $this->lang->line('load_plan_connote') . " " . $this->lang->line('to') . " "; ?><span
                                            id="orderid_ldc"></span>
                                    </h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" id="loadplanconnote_div"></div>
                            </div>
                        </div>
                    </div>
                    <div style="z-index: 9999;" class="modal fade insert_success_div"
                         id="insert_success_div" data-keyboard="false"
                         data-backdrop="static" tabindex="-1" role="dialog"
                         aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header"></div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;">
                                        <span class="glyphicon glyphicon-ok-circle popup_circle"
                                              style="font-size: 22px; color: green;"></span>&nbsp;<span
                                            class="pop_message">New Record Inserted Successfully !!</span>
                                    </p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button"
                                            class="btn btn-primary success_redirect suc_pop_ok"
                                            data-dismiss="modal">Ok
                                    </button>
                                    <button type="button"
                                            class="btn btn-danger success_redirect suc_pop_cancel"
                                            data-dismiss="modal">Cancel
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div style="z-index: 9999;" class="modal fade ats_service_model" id="ats_service_model" data-keyboard="false" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                </div>
                                <div class="modal-body">
                                    <p style="font-size: 19px;">&nbsp;<span class="pop_message"></span></p>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button" class="btn btn-primary success_redirect suc_pop_ok" data-dismiss="modal">Ok</button>
                                    <button type="button" class="btn btn-danger success_redirect suc_pop_cancel" data-dismiss="modal">Cancel</button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div style="z-index: 9999;" class="modal fade " id="ready_invoice_orders"
                         data-keyboard="false" data-backdrop="static" tabindex="-1"
                         role="dialog" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal">×
                                    </button>
                                    <h4 class="modal-title" id="view_customer_title"><?= $this->lang->line('response'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <h4 class="pop_message_load_readytoinvoice"></h4>
                                    <span class="readyinvoice_popuporders_data">
                                    </span>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button"
                                            class="btn btn-primary success_redirect suc_pop_ok"
                                            data-dismiss="modal" onclick="readytoinvoiceforselected(event)"><?= $this->lang->line('submit'); ?></button>
                                    <button type="button"
                                            class="btn btn-danger success_redirect suc_pop_cancel"
                                            data-dismiss="modal"><?= $this->lang->line('general_cancel'); ?></button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div style="z-index: 9999;" class="modal fade " id="ready_invoice"
                         data-keyboard="false" data-backdrop="static" tabindex="-1"
                         role="dialog" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header success_message_header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal">×
                                    </button>
                                    <h4 class="modal-title" id="view_customer_title">Response</h4>
                                </div>
                                <div class="modal-body">
                                    <h4 class="pop_message_load"></h4>
                                    <span class="pop_message">
                                        <table class="table table-striped" id="ready_invoice_tb"
                                               width="100%">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Booking ID</th>
                                                    <th scope="col">Recipient Role</th>
                                                    <th scope="col">JFR</th>
                                                    <th scope="col">Res. Message</th>
                                                    <th scope="col">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="readyinvoice_show_data"></tbody>
                                        </table>
                                    </span>
                                </div>
                                <div class="modal-footer success_message_footer">
                                    <button type="button"
                                            class="btn btn-primary success_redirect suc_pop_ok"
                                            data-dismiss="modal">Ok
                                    </button>
                                    <button type="button"
                                            class="btn btn-danger success_redirect suc_pop_cancel"
                                            data-dismiss="modal">Cancel
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="charges_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Order Charges</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Total Revenue</th>
                                        <th>JFR</th>
                                        <th>BU JFR</th>
                                        <th>Failure Status</th>
                                        <th>Total Cost</th>
                                        <th>JFR</th>
                                        <th>BU JFR</th>
                                        <th>Failure Status</th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach ($chexcel_uploaddata as $chrg):
                                            ?>
                                            <tr>
                                                <td><?= $chrg->booking_id; ?></td>
                                                <td><?= $chrg->total_revenue; ?></td>
                                                <td><?= $chrg->rev_debtor_jfr; ?></td>
                                                <td><?= $chrg->rev_bu_jfrs; ?></td>
                                                <td><?php
                                                    $rstyle = "";
                                                    if ($chrg->rev_failure != ""):
                                                        $rstyle = "font-weight:bold;color:#b71209d6;";
                                                    endif; ?>
                                                    <span style="<?= $rstyle; ?>"><?= $chrg->rev_failure; ?></span></td>
                                                <td><?= $chrg->total_cost; ?></td>
                                                <td><?= $chrg->cost_jfr; ?></td>
                                                <td><?= $chrg->cost_bu_jfrs; ?></td>
                                                <td><?php
                                                    $style = "";
                                                    if ($chrg->cst_failure != ""):
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    endif; ?>
                                                    <span style="<?= $style; ?>"><?= $chrg->cst_failure; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="knloginstatus_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Status Send To KN Login</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body" style="overflow-x: auto;">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th><?= $this->lang->line('booking_id') ?></th>
                                        <th><?= $this->lang->line('qbook_customer') ?></th>
                                        <th><?= $this->lang->line('cust_status') ?></th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        $knlogin_uploaddata = $knlogin_uploaddata ?? [];
                                        foreach ($knlogin_uploaddata as $eachLine):
                                            ?>
                                            <tr>
                                                <td><?= $eachLine->orderId; ?></td>
                                                <td><?= $eachLine->customer; ?></td>
                                                <td><?php
                                                    $style = "";
                                                    if ($eachLine->status === 0) {
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    } ?>
                                                    <span style="<?= $style ?>"><?= $eachLine->message; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="clorders_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Orders List</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Customer CID</th>
                                        <?php
                                        if ($this->session->userdata('company_code') != "SGKN"): ?>
                                            <th>Delivery Note</th>
                                        <?php
                                        endif; ?>
                                        <th>Trip ID</th>
                                        <th>Status</th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        log_message("error","clexcel_uploaddata:".json_encode($clexcel_uploaddata));
                                        foreach ($clexcel_uploaddata as $ord):
                                            ?>
                                            <tr>
                                                <td><?= $ord->booking_id; ?></td>
                                                <td><?= $ord->customer_id; ?></td>
                                                <?php
                                                if (($this->session->userdata('company_code') != "SGKN") && ($this->session->userdata('company_code') != "INFD")) : ?>
                                                    <td><?= $ord->delivery_note; ?></td>
                                                <?php
                                                endif; ?>
                                                <td><?= $ord->trip_id; ?></td>
                                                <td><?php
                                                    $excel_status = $ord->status;
                                                    $style = "";
                                                    if (strtolower($excel_status) == "success"):
                                                        $style = "font-weight:bold;color:#099e59eb;";
                                                    else:
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    endif;
                                                    ?>
                                                    <span style="<?= $style; ?>"><?= $excel_status; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="file_tranfer_succeslist"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">File Transfer Response</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="filetransfersucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Status</th>
                                        </thead>
                                        <tbody class="filetransfersucces_list-body">
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal" id="orders_success_list"
                         tabindex="-1" role="dialog">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Orders List</h4>
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <table class="table table-striped table-bordered"
                                           id="orderssucces_list">
                                        <thead>
                                        <th>Booking ID</th>
                                        <th>Customer CID</th>
                                        <th>Delivery Note</th>
                                        <th>Status</th>
                                        </thead>
                                        <tbody>
                                        <?php
                                        foreach ($excel_uploaddata as $ord):
                                            ?>
                                            <tr>
                                                <td><?= $ord->booking_id; ?></td>
                                                <td><?= $ord->customer_id; ?></td>
                                                <td><?= $ord->delivery_note; ?></td>
                                                <td><?php
                                                    $excel_status = $ord->status;
                                                    $style = "";
                                                    if (strtolower($excel_status) == "success"):
                                                        $style = "font-weight:bold;color:#099e59eb;";
                                                    else:
                                                        $style = "font-weight:bold;color:#b71209d6;";
                                                    endif;
                                                    ?>
                                                    <span style="<?= $style; ?>"><?= $excel_status; ?></span></td>
                                            </tr>
                                        <?php
                                        endforeach;
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="cargobulkupload">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal">&times;
                                    </button>
                                    <h4 class="modal-title">Update Cargo For Selected Orders</h4>

                                </div>

                                <div class="modal-body">
                                    <form name="updatecargobulk" id="updatecargobulk" method="post"
                                          class="updatecargobulk" action="">
                                        <div class="box custom-box">
                                            <input type="hidden" id="cargo_orderids"
                                                   class="updcargo-form" form="updatecargobulk"
                                                   name="cargo_orderids" value="">
                                            <table border="0" width="100%">
                                                <span id="cargoupd_success"
                                                      style="display: none; color: #008000bd;">Cargos Updated
                                                    Successfully...</span>
                                                <tr>
                                                    <td colspan="2"></td>
                                                </tr>
                                                <tr>
                                                    <td width="40%"
                                                        style="padding-left: 30px; font-size: 13px; font-weight: 600; color: #162d56;">
                                                        <b><?= $this->lang->line('package_type') . " : "; ?></b>
                                                    </td>
                                                    <td width="60%" style="padding-right: 60px;"><select
                                                            name="updatcargo_val" id="updatcargo_val"
                                                            form="updatecargobulk" class="form-control updcargo-form">
                                                            <option value="">Select</option>
                                                            <option value="PALLET">PALLET</option>
                                                            <option value="CARTON">CARTON</option>
                                                        </select></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button"
                                            class="btn btn-default waves-effect btn_color resetbtn"
                                            data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                    <input type="submit" form="updatecargobulk"
                                           class="submittype btn btn-primary  btn_color waves-effect waves-light"
                                           onclick="submitbulkcargos_fororder(event)" id="cargoupdate"
                                           data-dismiss="close" data-info="add"
                                           value="<?= $this->lang->line('general_update'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="trip_creation">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal">&times;
                                    </button>
                                    <h4 class="modal-title"><?= $this->lang->line('trip_mgt'); ?></h4>
                                </div>

                                <div class="modal-body">
                                    <form name="tripcreation" id="tripcreation" method="post"
                                          class="tripcreation"
                                          action="<?= base_url(); ?>smtcorders/triporderintoshipment"
                                          onsubmit=" return createTrip(event)">
                                        <input type="hidden" id="trip_orderid" name="ordid">
                                        <input type="hidden" id="trip_type" name="trip_type" value="single">
                                        <input type="hidden" id="debtor_code_status" name="debtor_code_status" value="">
                                        <div class="box custom-box">
                                            <div id="">
                                                <?php
                                                $user_id = $this->session->userdata('user_id');
                                                $list = getListForTrip($user_id);
                                                $carrierlist = $vehicletypes = [];
                                                if (!empty($list)):
                                                    $carrierlist = $list['carrierlist'];
                                                    $vehicletypes = $list['vehicletypes'];
                                                endif;
                                                ?>
                                                <table border="0"
                                                       width="100%">
                                                    <tr align="center">
                                                        <td colspan="4" id="acon_status" style="display:none;Color:red;tex-align:center;">Carrier does not have Acon Debitor Code. Please update the Details.</td>

                                                    </tr>
                                                    <tr align="center">
                                                        <td colspan="4" id="intransit_status" style="display:none;Color:red;tex-align:center;">Vehicle already in Transit Mode, Please select another Vehicle.</td>
                                                    <tr align="center">
                                                        <td colspan="4" id="carrier_status" style="display:none;Color:red;tex-align:center;"> Please select carrier details</td>
                                                    </tr>
                                                    <tr>
                                                        <td width="20%"><label><?= $this->lang->line('template_id') ?></label></td>
                                                        <td width="30%"><select form='tripcreation' name="templateId" onchange="disableOtherInputFields()" class="Txtfld form-control" id="templateId">
                                                                <option value="">--Select--</option>
                                                            </select>
                                                            <input type="hidden" form='tripcreation' name="fromsource" id="fromsource" value = "orders"></td>
                                                    </tr>
                                                    <tr class="">
                                                        <td width="20%"><label><?= $this->lang->line('carrier_name'); ?> * </label></td>
                                                        <td width="25%"><select name="carrierid"
                                                                                class="tripcreatefields tripcar_id Txtfld mandatoryflds form-control"
                                                                                id="tcarrierid" required="">
                                                                <option value="">--Select--</option>
                                                                <?php
                                                                foreach ($carrierlist as $carrier): ?>
                                                                    <option
                                                                        value="<?= $carrier['id']; ?>"><?= $carrier['name']; ?></option>
                                                                <?php
                                                                endforeach; ?>
                                                            </select>

                                                        <td width="20%"><label><?= $this->lang->line('carrier_id'); ?></label></td>
                                                        <td width="25%"><input
                                                                onkeypress="return isNonSpecialCharCheck(event);"
                                                                type="text" class="form-control tripcar_name Txtfld"
                                                                readonly onkeyup="upper(this);" id="nccode" size="20"
                                                                value=""></td>
                                                    </tr>
                                                    <tr class="">
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_type'); ?> * </label></td>
                                                        <td width="25%"><select name="vehicle_type"
                                                                                id="tpvehicle_type"
                                                                                class="tripcreatefields Txtfld tripcar_id form-control" required="">
                                                                <?php
                                                                echo "<option value=''>-Select-</option>";
                                                                foreach ($vehicletypes->result() as $row):
                                                                    echo "<option value='" . $row->id . "'>" . $row->trucktype . "</option>";
                                                                endforeach;
                                                                ?>
                                                            </select></td>
                                                        <td width="20%"><label><?= $this->lang->line('veh_type_name'); ?></label></td>
                                                        <td width="25%"><input type="text"
                                                                               class="Txtfld form-control" readonly id="tpveh_typename"
                                                                               size="20" value=""></td>
                                                    </tr>
                                                    <tr class="">
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_no'); ?></label></td>
                                                        <td width="25%"><span id="tpveh_numdiv"> <select
                                                                    name="veh_typenum" form='tripcreation' id="tvehnum"
                                                                    class="tripcreatefields Txtfld tripcar_id form-control">
                                                                    <option value=''>--Select--</option>
                                                                </select>
                                                            </span></td>
                                                        <td width="20%"><label><?= $this->lang->line('vehicle_id'); ?></label></td>
                                                        <td width="25%"><input type="text" name="vehicle_id"
                                                                               readonly class="add_company Txtfld form-control"
                                                                               id="tvehid" size="20" value=""></td>
                                                    </tr>
                                                    <tr class="">
                                                        <td width="20%"><label><?= $this->lang->line('driver_name'); ?></label></td>
                                                        <td width="25%"><span id="tdrivespan"> <select
                                                                    class="tripcreatefields add_company Txtfld tripcar_id form-control"
                                                                    id="tdri_name" onchange="getdrid()" name="tdrivernum">
                                                                    <option value=''>--Select--</option>
                                                                </select>
                                                            </span></td>
                                                        <td width="20%"><label><?= $this->lang->line('driver_id'); ?></label></td>
                                                        <td width="25%"><input type="text" readonly
                                                                               class="add_company Txtfld form-control" id="tdri_id"
                                                                               name="driver_id" size="20" value=""></td>
                                                    </tr>
                                                    <tr class="">
                                                        <td width="20%"><label><?= $this->lang->line('carrier_instructions'); ?></label></td>
                                                        <td width="25%"><textarea rows="2" form="tripcreation"
                                                                                  cols="30" id="carrier_instructions"
                                                                                  class="tripcreatefields form-control Txtfld" name="carrier_instructions"></textarea>
                                                        </td>
                                                    </tr>

                                                </table>

                                            </div>
                                        </div>

                                </div>


                                <div class="modal-footer">

                                    <button type="button"
                                            class="btn btn-default waves-effect btn_color resetbtn"
                                            data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                    <input type="submit"
                                           class="submittype btn btn-primary  btn_color waves-effect waves-light"
                                           id="new_company_add" data-dismiss="close" data-info="add"
                                           value="<?= $this->lang->line('submit_trip'); ?>">
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div id="forceClosediv" class="modal fade "
                         data-backdrop="static" data-keyboard="false" role="dialog">

                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal" aria-hidden="true">×
                                    </button>
                                    <h4 class="modal-title" id="companyCodeAddmodalLabel">
                                        3M Shipments Force Close
                                    </h4>
                                </div>
                                <div class="modal-body">
                                    <div class="box custom-box">

                                        <form method="POST" action="" id="forceClose_from" onsubmit=" return forcecloseorders(event)">
                                            <div class="box custom-box">
                                                <div id="">

                                                    <table border="0"
                                                           width="100%">
                                                        <tr align="center">
                                                            <td colspan="5" id="forceClose_dates" style="display:none;Color:red;tex-align:center;">Please select the Proper Dates</td>

                                                        </tr>


                                                        <tr class="">
                                                            <td width="20%"><label><?= $this->lang->line('general_from_date'); ?> * </label></td>
                                                            <td width="25%">

                                                                <input type="text" form="forceClose_from" name="forcefromDate" class="  add_book Txtfld form-control" id="forcefromDate" autocomplete="off" value="" onkeyup="upper(this);" size="20">

                                                            </td>
                                                            <td width="10%"></td>
                                                            <td width="20%"><label><?= $this->lang->line('general_to_date'); ?> * </label></td>
                                                            <td width="25%"><input type="text" form="forceClose_from" name="forcetoDate" class="  add_book Txtfld form-control" id="forcetoDate" autocomplete="off" value="" onkeyup="upper(this);" size="20">
                                                            </td>

                                                        </tr>


                                                    </table>

                                                </div>
                                            </div>

                                            <div class="row" style="padding-top: 25px;">
                                                <div class="col-md-12" style="text-align:right;">
                                                    <button type="button"
                                                            class="btn btn-default waves-effect btn_color resetbtn"
                                                            data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                                                    <input type="submit"
                                                           class="submittype btn btn-primary  btn_color waves-effect waves-light"
                                                           id="force_close" data-dismiss="close" data-info="add"
                                                           value="<?= $this->lang->line('submit'); ?>">

                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal containerModal containerModalForDg" tabindex="-1" role="dialog" style="z-index: 9999 !important;">
                        <div class="modal-dialog modal-lg" role="document" style="width:98%">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" style="font-weight: bold;">Modal title</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="margin-top: -21px;">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p>Modal body text goes here.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary  btn_color waves-effect waves-light" onclick="submitDgGoodsList()">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="quickbook_popup" class="modal fade quickbook_popup"
                         data-backdrop="static" data-keyboard="false" role="dialog">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="closevalues close"
                                            data-dismiss="modal" aria-hidden="true">×
                                    </button>
                                    <h4 class="modal-title" id="companyCodeAddmodalLabel">
                                        <?= $this->lang->line('quickbook'); ?>
                                    </h4>
                                </div>
                                <div class="modal-body">
                                    <?php
                                    $submit = 'onsubmit="return savequickbook(1);"';
                                    ?>
                                    <form method="POST"
                                          action="<?= base_url(); ?>smtcorders/savequickbook"
                                        <?= $submit; ?> novalidate id="quickbook_form">
                                        <input type="hidden" name="quickbookreference_ids"
                                               class="quickbookform" id="quickbookreference_ids" value=""> <input
                                            type="hidden" name="quickbook_order_reference_ids"
                                            class="quickbookform" id="quickbook_order_reference_ids"
                                            value="">
                                        <input type="hidden" name="quickbookshipper_id"
                                               class="quickbookform" id="quickbookshipper_id" value="">
                                        <input type="hidden" name="quickbookpickup_id"
                                               class="quickbookform" id="quickbookpickup_id" value="<?= $postData['pickupRowIdForBook'] ?? ""?>">
                                        <input type="hidden" name="quickbookconsignee_id"
                                               class="quickbookform" id="quickbookconsignee_id" value="">
                                        <input type="hidden" name="quickbookdelivery_id"
                                               class="quickbookform" id="quickbookdelivery_id" value="<?= $postData['consigneeRowIdForBook'] ?? ""?>">
                                        <input type="hidden" name="quickbookorder_cargo_id"
                                               class="quickbookform" id="quickbookorder_cargo_id" value="">
                                        <input type="hidden" name="quickbookcargo_row_id"
                                               class="quickbookform" id="quickbookcargo_row_id" value="">
                                        <input type="hidden" name="rateServiceRowId"
                                               class="quickbookform" form="quickbook_form" id="rateServiceRowId" value="<?= $postData['rateServiceRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="rateOfferingRowId"
                                               class="quickbookform" form="quickbook_form" id="rateOfferingRowId" value="<?= $postData['rateOfferingRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="rateRecordRowId"
                                               class="quickbookform" form="quickbook_form" id="rateRecordRowId" value="<?= $postData['rateRecordRowIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="customerProfileId"
                                               class="quickbookform" form="quickbook_form" id="customerProfileId" value="<?= $postData['customerProfileIdForBook'] ?? 0 ?>">
                                        <input type="hidden" name="laneRowIdForBook"
                                               class="quickbookform" form="quickbook_form" id="laneRowIdForBook" value="<?= $postData['laneRowIdForBook'] ?? 0 ?>">
                                        <?php
                                        $incoterm = getIncotermMasterData();
                                        $cust_id = "0";
                                        if ($this->session->userdata('cust_id')):
                                            $cust_id = $this->session->userdata('cust_id');
                                            if ($cust_id == ""):
                                                $cust_id = "0";
                                            endif;
                                        endif;
                                        $company_code = $this->session->userdata('company_code');
                                        ?>
                                        <div class="bg-white_main">
                                            <div class="panel-group" id="accordion" role="tablist"
                                                 aria-multiselectable="true">
                                                <div class="generalInfo panel panel-default">
                                                    <div class="panel-heading active" role="tab"
                                                         id="headingGeneralInfo">
                                                        <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse"
                                                               data-parent="#accordion" href="#generalInfo"
                                                               aria-expanded="true" aria-controls="collapseOne"> <i
                                                                    class="more-less fa fa-angle-right"></i> <?= $this->lang->line('qbook_bookinginfo'); ?>
                                                            </a>
                                                        </h4>
                                                    </div>
                                                    <div id="generalInfo" class="panel-collapse collapse in"
                                                         role="tabpanel" aria-labelledby="headingGeneralInfo">
                                                        <div class="panel-body">
                                                            <div class="general_input_fields">
                                                                <div class="row">
                                                                    <div class="col-md-6">
                                                                        <fieldset style="min-width: 0; min-height: 350px;">
                                                                            <legend
                                                                                style="display: block; width: auto; padding: 0; margin-bottom: 0px; font-size: 13px; line-height: inherit; border: 0;"><?= $this->lang->line('qbook_routing'); ?></legend>
                                                                            <div class="row">

                                                                                <div class="col-md-12">
                                                                                    <div
                                                                                        class="form-group pull-left covid19pickupstatus">
                                                                                    </div>
                                                                                    <div class="form-group pull-right">
                                                                                        <div class="checkbox checkbox-info">
                                                                                            <label> <input type="checkbox" value=""
                                                                                                           id="save_popupmaster1"
                                                                                                           onchange="return checkbeforesavepopupshipper(event)">
                                                                                                <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                                                                            </label>
                                                                                        </div>
                                                                                        <label class="checkbox_cls" for=""><?= $this->lang->line('general_save'); ?></label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label for="popuppickup_id"><?= $this->lang->line('pickup') . ' ' . $this->lang->line('general_id'); ?> * </label>
                                                                                        <input form="quickbook_form" type="text" name="popuppickup_id" class="form-control add_book Txtfld quickbookform" id="popuppickup_id" value="<?= $postData['pickupCodeForBook'] ?? "" ?>" onkeyup="upper(this);" size="20">
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#"
                                                                                                   id="searchpopuppartylist"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   onclick="searchpopuppickuppartylist(event, 'pickup_details')"><i
                                                                                                        class="icon tru-icon-search"></i></a>

                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" data-info="<?= $this->lang->line('bpartner_plist'); ?>" title="List" id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event,'pickup_details')"> <i
                                                                                                        class="icon tru-icon-tender-list"></i></a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_name'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popupshipper_name" id="popuppickup_name" parsley-trigger="change" required placeholder="" class="form-control quickbookform" value="<?= $postData['pickupNameForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_street'); ?> * </label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);" type="text" name="popupshipper_street" id="popuppickup_street" parsley-trigger="change" required placeholder="" class="quickbookform form-control"  value="<?= $postData['pickupStreetForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_city'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popuppickup_city" id="popuppickup_city" parsley-trigger="change" required placeholder="" class="quickbookform form-control" value="<?= $postData['pickupCityForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_province'); ?> *</label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" onkeyup="upper(this);" type="text" name="popuppickup_state" id="popuppickup_state" parsley-trigger="change" required placeholder="" class="quickbookform form-control" value="<?= $postData['pickupStateForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">

                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_country'); ?> * </label>
                                                                                        <input onkeyup="upper(this);" onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popuppickup_country" id="popuppickup_country" parsley-trigger="change" required placeholder="" class="form-control chkpopupcountry quickbookform" value="<?= $postData['pickupCountryForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('zipcode'); ?> * </label>
                                                                                        <input onkeypress="return isNumberKey(event);" type="text" name="popuppickup_zipcode" id="popuppickup_zipcode" parsley-trigger="change" required placeholder="" class="form-control quickbookform" value="<?= $postData['pickupPincodeForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_phone'); ?> </label>
                                                                                        <input onkeypress="return isNumberKey(event);" type="text" name="popuppickup_phone" id="popuppickup_phone" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_fax'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popuppickup_fax" id="popuppickup_fax" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_email'); ?></label>
                                                                                        <input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="popuppickup_email" id="popuppickup_email" parsley-trigger="change" required placeholder="" class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('pic_date'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form" name="popuppickup" class="quickbookform datetimepicker add_book Txtfld form-control" id="popuppickup" autocomplete="off" value="" onkeyup="upper(this);" size="20">

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <hr style="border-top: 1px solid #ccc">
                                                                            <div class="row">
                                                                                <div class="col-md-12">
                                                                                    <div
                                                                                        class="form-group pull-left covid19deliverstatus"></div>
                                                                                    <div class="form-group pull-right">
                                                                                        <div class="checkbox checkbox-info">
                                                                                            <label> <input type="checkbox"
                                                                                                           id="save_popupmaster"
                                                                                                           onchange="return checkbeforesavepopupconsignee()"
                                                                                                           value=""> <span class="cr"><i
                                                                                                        class="cr-icon fa fa-check"></i></span>
                                                                                            </label>
                                                                                        </div>
                                                                                        <label class="checkbox_cls" for=""><?= $this->lang->line('general_save'); ?></label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_delivery') . ' ' . $this->lang->line('general_id'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               class="add_book form-control Txtfld quickbookform"
                                                                                               onkeyup="upper(this);" id="popupdelivery_id" name="popupdelivery_id"
                                                                                               size="20" value="<?= $postData['consigneeCodeForBook'] ?? "" ?>">
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   id="searchpopuppartylist"
                                                                                                   onclick="searchpopupdeliverypartylist(event, 'delivery_details')"><i
                                                                                                        class="icon tru-icon-search"></i></a>
                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" title="List"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event, 'delivery_details')">
                                                                                                    <i class="icon tru-icon-tender-list"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_name'); ?> * </label>
                                                                                        <input onkeyup="upper(this);"
                                                                                               id="popupdelivery_name"
                                                                                               name="popupdelivery_name" type="text"
                                                                                               parsley-trigger="change" required placeholder=""
                                                                                               class="quickbookform form-control" value="<?= $postData['consigneeNameForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_street'); ?> * </label>
                                                                                        <input
                                                                                            onkeyup="upper(this);" type="text"
                                                                                            name="popupdelivery_street"
                                                                                            id="popupdelivery_street"
                                                                                            parsley-trigger="change" required placeholder=""
                                                                                            class="form-control quickbookform" value="<?= $postData['consigneeStreetForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_city'); ?> * </label>
                                                                                        <input onkeyup="upper(this);"
                                                                                               name="popupdelivery_city"
                                                                                               id="popupdelivery_city" type="text"
                                                                                               parsley-trigger="change" required placeholder=""
                                                                                               class="form-control quickbookform" value="<?= $postData['consigneeCityForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_province'); ?> *</label>
                                                                                        <input
                                                                                            onkeyup="upper(this);"
                                                                                            name="popupdelivery_state" type="text"
                                                                                            id="popupdelivery_state"
                                                                                            parsley-trigger="change" required placeholder=""
                                                                                            class="form-control quickbookform" value="<?= $postData['consigneeStateForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_country'); ?> * </label>
                                                                                        <input onkeyup="upper(this);"
                                                                                               type="text" name="popupdelivery_country"
                                                                                               id="popupdelivery_country"
                                                                                               parsley-trigger="change" required placeholder=""
                                                                                               class="form-control chkpopupcountry quickbookform" value="<?= $postData['consigneeCountryForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('zipcode'); ?> * </label>
                                                                                        <input onkeypress="return isNumberKey(event);"
                                                                                               type="text" name="popupdelivery_zipcode"
                                                                                               id="popupdelivery_zipcode"
                                                                                               parsley-trigger="change" required placeholder=""
                                                                                               class="form-control quickbookform" value="<?= $postData['consigneePincodeForBook'] ?? "" ?>">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_phone'); ?>  </label>
                                                                                        <input onkeypress="return isNumberKey(event);"
                                                                                               type="text" name="popupdelivery_phone"
                                                                                               id="popupdelivery_phone"
                                                                                               parsley-trigger="change" required placeholder=""
                                                                                               class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_fax'); ?></label>
                                                                                        <input
                                                                                            onkeypress="return isNonSpecialCharCheck(event);"
                                                                                            type="text" name="popupdelivery_fax"
                                                                                            id="popupdelivery_fax" parsley-trigger="change"
                                                                                            required placeholder=""
                                                                                            class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label for="bookingID"><?= $this->lang->line('general_email'); ?></label>
                                                                                        <input
                                                                                            type="text" name="popupdelivery_email"
                                                                                            id="popupdelivery_email"
                                                                                            parsley-trigger="change" required placeholder=""
                                                                                            class="form-control quickbookform">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('deliverydate'); ?> * </label>
                                                                                        <input type="text"
                                                                                               class="quickbookform <?php
                                                                                               if ($this->session->userdata('company_code') != 'THKN') : echo "datetimepicker"; endif; ?> add_book Txtfld form-control"
                                                                                               onkeyup="upper(this);" name="popupdelivery"
                                                                                               autocomplete="off" id="popupdelivery" size="20"
                                                                                               value="" placeholder="<?php
                                                                                        if ($this->session->userdata('company_code') == 'THKN') :echo "YYYY-MM-DD HH:MM:SS"; endif; ?>">
                                                                                    </div>
                                                                                </div>

                                                                            </div>


                                                                        </fieldset>
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <fieldset style="min-width: 0; min-height: 350px;">
                                                                            <legend
                                                                                style="display: block; width: auto; padding: 0; font-size: 13px; line-height: inherit; color: #333; border: 0;"><?= $this->lang->line('qbook_orderdeatils'); ?></legend>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_company_code'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               name="popupcompany_code"
                                                                                               class="add_book Txtfld form-control quickbookform"
                                                                                               id="popupcompany_code"
                                                                                               value="<?= $this->session->userdata('company_code'); ?>"
                                                                                               onkeyup="upper(this);" size="20" readonly>
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search"
                                                                                                   data-info="<?= $this->lang->line('general_listofcompanies'); ?>"
                                                                                                   href="#" id="searchviewcompany"
                                                                                                   onclick="searchpopupviewcompany(event)"><i
                                                                                                        class="icon tru-icon-search"></i></a>

                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#"
                                                                                                   data-info="<?= $this->lang->line('general_listofcompanies'); ?>"
                                                                                                   title="List" id="viewcompanylist"
                                                                                                   onclick="viewpopupcompanylist(event)"> <i
                                                                                                        class="icon tru-icon-tender-list"></i></a>
                                                                                            </button>
                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_branch_code'); ?> * </label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               class="add_book Txtfld form-control quickbookform"
                                                                                               onkeyup="upper(this);" name="popupbranch_code"
                                                                                               id="popupbranch_code" size="20"
                                                                                               value="<?= $this->session->userdata('branch_code'); ?>"
                                                                                               readonly>
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" data-toggle="modal">
                                                                                                <a title="Search"
                                                                                                   data-info="<?= $this->lang->line('general_searchbranchdetials'); ?>"
                                                                                                   href="#" id="searchviewbranch"
                                                                                                   onclick="searchpopupviewbranch(event)"> <i
                                                                                                        class="icon tru-icon-search"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" data-toggle="modal">
                                                                                                <a href="#"
                                                                                                   data-info="<?= $this->lang->line('general_listofbranches'); ?>"
                                                                                                   title="List" id="viewbranchlist"
                                                                                                   onclick="viewpopupbranchlist(event)"> <i
                                                                                                        class="icon tru-icon-tender-list"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <?php
                                                                            $departments = getDepartmentMasterData(); ?>
                                                                            <div
                                                                                class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('general_department_code'); ?> *</label>
                                                                                        <select name="popupdepartment_code"
                                                                                                class="add_book Txtfld quickbookform main-control form-control custom-select-main"
                                                                                                id="popupdepartment_code">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            foreach ($departments as $res):
                                                                                                ?>
                                                                                                <option
                                                                                                    value="<?= $res; ?>"><?= $res; ?></option>
                                                                                            <?php
                                                                                            endforeach;
                                                                                            ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <?php
                                                                                    $custid = $this->session->userdata('cust_id');
                                                                                    if ($custid == ""):
                                                                                        ?>
                                                                                        <div
                                                                                            class="input-group">
                                                                                            <input type="hidden" form="quickbook_form" name="vendorIdFromProfile" value="<?= $vendorIdFromProfile ?? 0 ?>">
                                                                                            <input type="hidden" form="quickbook_form" name="vendorCodeFromProfile" value="<?= $vendorCodeFromProfile ?? 0 ?>">
                                                                                            <input type="hidden" form="quickbook_form" name="customerIdFromProfile" value="<?= $customerIdFromProfile ?? 0 ?>">
                                                                                            <label><?= $this->lang->line('qbook_customer'); ?> * </label>
                                                                                            <input type="text" form="quickbook_form"
                                                                                                   name="popupcustomer_id"
                                                                                                   class="add_book Txtfld cutsomerid form-control"
                                                                                                   id="popupcustomer_id" value="<?= $pickup_details['party_id'] ?? ""?>"
                                                                                                   onkeyup="upper(this);" size="20">
                                                                                            <div class="input-group-btn">
                                                                                                <button class="btn btn-outline-secondary"
                                                                                                        type="button" data-toggle="modal"
                                                                                                        data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                        onclick="searchpopupcustomerlist(event)"
                                                                                                        data-placement="top" title="Search">
                                                                                                    <i class="icon tru-icon-search"></i>
                                                                                                </button>
                                                                                                <button class="btn btn-outline-secondary"
                                                                                                        type="button" data-placement="top"
                                                                                                        data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                        title="List" data-toggle="modal"
                                                                                                        onclick="viewpopupcustomerlist(event)">
                                                                                                    <i class="icon tru-icon-tender-list"></i>
                                                                                                </button>
                                                                                            </div>
                                                                                        </div>
                                                                                    <?php
                                                                                    else: ?>
                                                                                        <div
                                                                                            class="form-group">
                                                                                            <label><?= $this->lang->line('qbook_customer'); ?> * </label>
                                                                                            <input type="text" form="quickbook_form"
                                                                                                   name="popupcustomer_id"
                                                                                                   class="add_book Txtfld quickbookform form-control"
                                                                                                   readonly id="popupcustomer_id"
                                                                                                   value="<?php
                                                                                                   if (isset($pickup_details['party_id'])):
                                                                                                       echo $pickup_details['party_id'];
                                                                                                   endif;
                                                                                                   ?>"
                                                                                                   onkeyup="upper(this);" size="20">
                                                                                        </div>
                                                                                    <?php
                                                                                    endif; ?>
                                                                                </div>

                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-dm-6"></div>
                                                                                <div class="col-md-6 pull-right"
                                                                                     id="customer_details">
                                                                                    <?php
                                                                                    if (!empty($pickup_details)) :
                                                                                        if ($pickup_details['name'] != "") :
                                                                                            echo "<b>" . $pickup_details['name'] . "</b><br>";
                                                                                        endif;
                                                                                        if ($pickup_details['address'] != ""):
                                                                                            echo strtoupper($pickup_details['address']) . " , </b><br>";
                                                                                        endif;
                                                                                        if ($pickup_details['country'] != ""):
                                                                                            echo strtoupper($pickup_details['country']) . ",";
                                                                                        endif;
                                                                                        if ($pickup_details['pincode'] != ""):
                                                                                            echo strtoupper($pickup_details['pincode']);
                                                                                        endif;
                                                                                    endif;
                                                                                    ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label for="popupshipper_id"><?= $this->lang->line('general_shipper'); ?> </label>
                                                                                        <input form="quickbook_form" type="text" name="popupshipper_id" class="form-control add_book Txtfld quickbookform" id="popupshipper_id" value="<?= $postData['pickupCodeForBook'] ?? "" ?>" onkeyup="upper(this);" size="20">
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#"
                                                                                                   id="searchpopuppartylist"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   onclick="searchpopuppartylist(event, 'shipper_details')"><i
                                                                                                        class="icon tru-icon-search"></i></a>

                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   title="List" id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event, 'shipper_details')">
                                                                                                    <i class="icon tru-icon-tender-list"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <div class="col-md-6">
                                                                                    <div class="input-group">
                                                                                        <label><?= $this->lang->line('general_consignee'); ?> </label>
                                                                                        <input type="text"
                                                                                               class="add_book form-control Txtfld quickbookform"
                                                                                               onkeyup="upper(this);" form="quickbook_form" id="popupconsignee_id" name="popupconsignee_id"
                                                                                               size="20" value="<?= $postData['consigneeCodeForBook'] ?? "" ?>">
                                                                                        <div class="input-group-btn">
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Add"
                                                                                                    data-toggle="modal">
                                                                                                <a title="Search" href="#"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   id="searchpopuppartylist"
                                                                                                   onclick="searchpopuppartyconsigneelist(event, 'consignee_details')"><i
                                                                                                        class="icon tru-icon-search"></i></a>
                                                                                            </button>
                                                                                            <button class="btn " type="button"
                                                                                                    data-placement="top" title="Find"
                                                                                                    data-toggle="modal">
                                                                                                <a href="#" title="List"
                                                                                                   data-info="<?= $this->lang->line('bpartner_plist'); ?>"
                                                                                                   id="viewpopuppartylist"
                                                                                                   onclick="viewpopuppartylist(event, 'consignee_details')">
                                                                                                    <i class="icon tru-icon-tender-list"></i>
                                                                                                </a>
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6" id="shipper_details">
                                                                                    <?php
                                                                                    if (!empty($shipper_details)):
                                                                                        if ($shipper_details['name'] != ""):
                                                                                            echo "<b>" . $shipper_details['name'] . "</b><br>";
                                                                                        endif;
                                                                                        if ($shipper_details['address'] != "") :
                                                                                            echo strtoupper($shipper_details['address']) . " , </b><br>";
                                                                                        endif;
                                                                                        if ($shipper_details['country'] != ""):
                                                                                            echo strtoupper($shipper_details['country']) . ",";
                                                                                        endif;
                                                                                        if ($shipper_details['pincode'] != ""):
                                                                                            echo strtoupper($shipper_details['pincode']);
                                                                                        endif;
                                                                                    endif;
                                                                                    ?>
                                                                                </div>
                                                                                <div class="col-md-6 pull-right"
                                                                                     id="consignee_details">
                                                                                    <?php
                                                                                    if (!empty($consignee_details)):
                                                                                        if ($consignee_details['name'] != ""):
                                                                                            echo "<b>" . $consignee_details['name'] . "</b><br>";
                                                                                        endif;
                                                                                        if ($consignee_details['address'] != ""):
                                                                                            echo strtoupper($consignee_details['address']) . " , </b><br>";
                                                                                        endif;
                                                                                        if ($consignee_details['country'] != ""):
                                                                                            echo strtoupper($consignee_details['country']) . ",";
                                                                                        endif;
                                                                                        if ($consignee_details['pincode'] != ""):
                                                                                            echo strtoupper($consignee_details['pincode']);
                                                                                        endif;
                                                                                    endif;
                                                                                    ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_product'); ?> *</label>
                                                                                        <select form="quickbook_form" name="productpopup"
                                                                                                class="form-control quickbookform main-control custom-select-main"
                                                                                                id="productpopup">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            foreach ($products as $res) :
                                                                                                ?>
                                                                                                <option
                                                                                                    value="<?= $res['name']; ?>"><?= $res['name']; ?></option>
                                                                                            <?php
                                                                                            endforeach;
                                                                                            ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_service'); ?> * </label>
                                                                                        <select form="quickbook_form" name="servicepopup"
                                                                                                class="form-control main-control custom-select-main"
                                                                                                id="servicepopup">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            $rateServiceId = $postData['serviceIdForBook'] ?? 0;
                                                                                            foreach ($service as $res):
                                                                                                ?>
                                                                                                <option <?php
                                                                                                if ($res['row_id'] == $rateServiceId): echo "selected"; endif; ?> value="<?= $res['row_id']; ?>"><?= $res['id'] . "-" . $res['name']; ?></option>
                                                                                            <?php
                                                                                            endforeach;
                                                                                            ?>
                                                                                        </select>

                                                                                    </div>
                                                                                </div>

                                                                            </div>

                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('bpartner_incoterms'); ?></label>
                                                                                        <select form="quickbook_form"
                                                                                                name="incoterm_popup"
                                                                                                class="main-control custom-select-main form-control quickbookform"
                                                                                                id="incoterm_popup">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            foreach ($incoterm as $name):
                                                                                                ?>
                                                                                                <option
                                                                                                    value="<?= $name; ?>"><?= $name; ?></option>
                                                                                            <?php
                                                                                            endforeach;
                                                                                            ?>
                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_deliveryterms'); ?></label>
                                                                                        <select form="quickbook_form"
                                                                                                name="popupdelivery_terms"
                                                                                                class="quickbookform form-control main-control custom-select-main"
                                                                                                id="popupdelivery_terms">
                                                                                        </select>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_deliverynote'); ?> </label>
                                                                                        <input type="text" onkeyup="upper(this);"
                                                                                               class="quickbookform Txtfld form-control"
                                                                                               form="quickbook_form" form="quickbook_form"
                                                                                               name="popupdelivery_note" id="deliverynote_popup">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label><?= $this->lang->line('qbook_notifyparty'); ?></label>
                                                                                        <input type="text"
                                                                                               class="form-control  quickbookform add_book Txtfld"
                                                                                               onkeyup="upper(this);" form="quickbook_form"
                                                                                               name="popupnotifyparty" id="popupnotifyparty"
                                                                                               size="20" value="">
                                                                                    </div>
                                                                                </div>
                                                                            </div>

                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="popuporder_type"><?= $this->lang->line('bpartner_ordtype'); ?>*</label>
                                                                                        <select
                                                                                            class="quickbookform main-control custom-select-main form-control"
                                                                                            name="popuporder_type" id="popuporder_type">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            foreach ($ordertypes as $types):
                                                                                                if ($types['type_name'] != ""):
                                                                                                    ?>
                                                                                                    <option
                                                                                                        value="<?= $types['type_id']; ?>"><?= $types['type_name']; ?></option>
                                                                                                <?php
                                                                                                endif;
                                                                                            endforeach;
                                                                                            ?>
                                                                                        </select>

                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="popupmodeof_trasnport"><?= $this->lang->line('mode_of_transport'); ?> * </label>
                                                                                        <select
                                                                                            class="quickbookform main-control custom-select-main form-control"
                                                                                            name="popupmodeof_trasnport"
                                                                                            id="popupmodeof_trasnport">
                                                                                            <option value="">Select</option>
                                                                                            <?php
                                                                                            $rateOfferingType = $postData['offeringTypeForBook'] ?? "";
                                                                                            foreach ($transport as $res):
                                                                                                ?>
                                                                                                <option <?php
                                                                                                if ($res['code'] == $rateOfferingType): echo "selected"; endif; ?> value="<?= $res['code']; ?>"><?= $res['name']; ?></option>
                                                                                            <?php
                                                                                            endforeach;
                                                                                            ?>

                                                                                        </select>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('qbook_purchaseorder'); ?></label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               onkeyup="upper(this);"
                                                                                               class="quickbookform Txtfld form-control"
                                                                                               onblur="checkpopuppurchaseordervalue()"
                                                                                               name="purchaseorder_popup"
                                                                                               id="purchaseorder_popup">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('driver_pickup_instruction'); ?></label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               onkeyup="upper(this);"
                                                                                               class="quickbookform Txtfld form-control"
                                                                                               name="driverpickup_popup" id="driverpickup_popup">
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <button class="btn  btn-primary btn_color"
                                                                                            style="margin-top: 22px;" title="Add Reference"
                                                                                            data-toggle="modal" data-target="#exampleModal"
                                                                                            onclick="addreferenceforquickbook(event)">
                                                                                        <small><i class="glyphicon glyphicon-plus"></i></small>&nbsp;<?= $this->lang->line('qbook_refvalues'); ?>
                                                                                    </button>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="form-group">
                                                                                        <label for="purchase_order"><?= $this->lang->line('driver_delivery_instruction'); ?></label>
                                                                                        <input type="text" form="quickbook_form"
                                                                                               onkeyup="upper(this);"
                                                                                               class="quickbookform Txtfld form-control"
                                                                                               name="driverdelivery_popup"
                                                                                               id="driverdelivery_popup">
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-sm-6">
                                                                                    <div class="form-group">
                                                                                        <label for="goods_value"><?= $this->lang->line('goods_value'); ?></label>
                                                                                        <div class="row">
                                                                                            <div class="col-md-6">
                                                                                                <input onkeypress="return isNonSpecialCharCheck(event);" form="quickbook_form" type="text" name="goods_value" id="goods_value" parsley-trigger="change" required placeholder="" class="decimal form-control" style="width:115px;">
                                                                                            </div>
                                                                                            <div class="col-sm-6" style="0px;">
                                                                                                <select form="quickbook_form" class="form-control" name="currency" id="currency">
                                                                                                    <option value="">Select</option>
                                                                                                    <?php
                                                                                                    foreach ($currencies as $currency):
                                                                                                        $sel = ($user_currency == $currency) ? "selected" : '';
                                                                                                        ?>
                                                                                                        <option value="<?= $currency; ?>" <?= $sel; ?>><?= $currency; ?></option>
                                                                                                    <?php
                                                                                                    endforeach;
                                                                                                    ?>
                                                                                                </select>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="row">
                                                                                <div class="col-md-12">
                                                                                    <div class="col-md-12 new_popupreference_table"
                                                                                         style="background-color: white; display: none;">
                                                                                        <table id="popupref_table"
                                                                                               class="table table-bordered table-striped">
                                                                                            <thead>
                                                                                            <tr>
                                                                                                <th>#</th>
                                                                                                <th>Refernce Name</th>
                                                                                                <th>Description</th>
                                                                                                <th>Value</th>
                                                                                                <th width="20%"></th>

                                                                                            </tr>
                                                                                            </thead>
                                                                                            <tbody>

                                                                                            </tbody>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </fieldset>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="CargoInfo panel panel-default">
                                                    <div class="panel-heading active" role="tab"
                                                         id="headingCargoInfo" style="margin-top: -19px;">
                                                        <h4 class="panel-title">
                                                            <a role="button" data-toggle="collapse"
                                                               data-parent="#accordion" href="#CargoInfo"
                                                               aria-expanded="true" aria-controls="collapseTwo"> <i
                                                                    class="more-less fa fa-angle-right"></i><?= $this->lang->line('cargo_details'); ?>
                                                            </a>
                                                        </h4>
                                                    </div>

                                    </form>
                                    <div id="CargoInfo" class="panel-collapse collapse"
                                         role="tabpanel" aria-labelledby="headingCargoInfo">
                                        <div class="panel-body">
                                            <div class="general_input_fields">
                                                <form method="POST"
                                                      action="<?= base_url(); ?>smtcorders/savepopupcargo<?= @$id ?>"
                                                      id="popupcargo_form" novalidate
                                                      onsubmit="return savepopupCargo(event);" autocomplete="off">
                                                    <div class="row">
                                                        <input type="hidden" name="mainpopupheight"
                                                               id="mainpopupheight" value=""> <input type="hidden"
                                                                                                     name="mainpopupweight" id="mainpopupweight" value=""> <input
                                                            type="hidden" name="mainpopupwidth" id="mainpopupwidth"
                                                            value=""> <input type="hidden" name="mainpopuplength"
                                                                             id="mainpopuplength" value="">
                                                        <div class="col-md-12">
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group">
                                                                        <label for="popupcargo_type"><?= $this->lang->line('package_type'); ?> * </label>
                                                                        <input type="text"
                                                                               class="popupcargo_form Txtfld form-control ui-autocomplete-input"
                                                                               name="popupcargo_type" id="popupmarks_number"
                                                                               autocomplete="off">
                                                                        <div class="input-group-btn">
                                                                            <button class="btn " type="button"
                                                                                    data-placement="top" data-toggle="modal">
                                                                                <a
                                                                                    data-war="<?= $this->lang->line('alert_entervalue'); ?>"
                                                                                    data-info="<?= $this->lang->line('general_searchitemdts'); ?>"
                                                                                    title="Search" href="#" id="searchviewbranch"
                                                                                    onclick="searchviewpopupitem(event)"> <i
                                                                                        class="icon tru-icon-search"></i>
                                                                                </a>
                                                                            </button>
                                                                            <button class="btn " type="button"
                                                                                    data-placement="top" data-toggle="modal">

                                                                                <a href="#" title="List" id="viewbranchlist"
                                                                                   onclick="viewpopupitemlist(event)"> <i
                                                                                        class="icon tru-icon-tender-list"></i>
                                                                                </a>
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="popupcargo_type">
                                                                            <?= $this->lang->line('qbook_goodsdescription'); ?>
                                                                            <?= order_cargo_description_mandatory($company_code) ?>
                                                                        </label>
                                                                        <input type="text" onkeyup="upper(this);"
                                                                               class="Txtfld popupcargo_form form-control"
                                                                               name="popupgoods_desc" id="popupgoods_desc">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="popupcargo_type">
                                                                            <?= $this->lang->line('general_quantity'); ?>
                                                                            <?= order_cargo_quantity_mandatory($company_code) ?>
                                                                        </label>

                                                                        <input type="number"
                                                                               onkeypress="return quantitytype(event);"
                                                                               class="Txtfld popupcargo_form form-control"
                                                                               name="popupquantity" min='1' id="popupquantity">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popuplength"><?= $this->lang->line('general_length'); ?> </label>
                                                                            <input type="text"
                                                                                   class="decimal form-control popupcargo_form  ui-autocomplete-input"
                                                                                   name="popuplength" id="popuplength"
                                                                                   oninput="changepopupbylength()" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popuplength_uom" oninput="changepopupbylength()"
                                                                                                          id="popuplength_uom"
                                                                                                          class="cargo_details main-control custom-select form-control">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupwidth"><?= $this->lang->line('general_width'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="popupwidth" id="popupwidth" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popupwidth_uom"
                                                                                                          class="cargo_details main-control form-control custom-select"
                                                                                                          id="popupwidth_uom">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupheight"><?= $this->lang->line('general_height'); ?> </label>
                                                                            <input type="text"
                                                                                   class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control"
                                                                                   onkeyup="upper(this);" name="popupheight"
                                                                                   id="popupheight" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popupheight_uom"
                                                                                                          class="cargo_details main-control form-control custom-select"
                                                                                                          id="popupheight_uom">
                                                                                <option value="M"><?= $this->lang->line('m'); ?></option>
                                                                                <option value="Cm"><?= $this->lang->line('cm'); ?></option>
                                                                                <option value="Inches"><?= $this->lang->line('inches'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupweight">
                                                                                <?= $this->lang->line('actual_weight'); ?>
                                                                                <?= order_cargo_actual_weight_mandatory($company_code); ?>
                                                                                * </label>
                                                                            <input decimaltype="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control"
                                                                                   name="popupweight" id="popupweight"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popupweight_uom"
                                                                                                          class="main-control form-control custom-select"
                                                                                                          id="popupweight_uom">
                                                                                <option value="Kg"><?= $this->lang->line('kg'); ?></option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="secondweight">
                                                                                <?= $this->lang->line('general_weight'); ?>
                                                                                <?= order_cargo_weight_mandatory($company_code); ?>
                                                                            </label>
                                                                            <input decimaltype="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld ui-autocomplete-input popupcargo_form form-control"
                                                                                   name="secondweight" id="secondweight"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select
                                                                                name="secondpopupweight_uom"
                                                                                class="main-control form-control custom-select"
                                                                                id="secondpopupweight_uom">
                                                                                <option value="Kg"><?= $this->lang->line('kg'); ?></option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupvolume"><?= $this->lang->line('volumetric_weight'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="popupvolumetric_weight"
                                                                                   id="popupvolumetric_weight" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popupvow_uom"
                                                                                                          class="main-control form-control custom-select"
                                                                                                          id="popupvow_uom">
                                                                                <option value="Kg"><?= $this->lang->line('kg'); ?></option>
                                                                                <option value="Tons"><?= $this->lang->line('Tons'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupvolume"><?= $this->lang->line('actual_volume'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="popupvolume" id="popupvolume"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select name="popupvolume_uom"
                                                                                                          class="main-control custom-select form-control"
                                                                                                          id="popupvolume_uom">
                                                                                <option value="cbm"><?= $this->lang->line('cbm'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="secondvolume"><?= $this->lang->line('general_volume'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal Txtfld form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="secondvolume" id="secondvolume"
                                                                                   autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <label>&nbsp;</label> <select
                                                                                name="secondpopupvolume_uom"
                                                                                class="main-control custom-select form-control"
                                                                                id="secondpopupvolume_uom">
                                                                                <option value="cbm"><?= $this->lang->line('cbm'); ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-8">
                                                                            <label for="popupwidth"><?= $this->lang->line('ldm'); ?> </label>
                                                                            <input type="text" onkeyup="upper(this);"
                                                                                   class="decimal form-control ui-autocomplete-input popupcargo_form"
                                                                                   name="popupldm" id="popupldm" autocomplete="off">
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="input-group row">
                                                                                <div class="dgGoodsColumn"></div>
                                                                                <input name="popupstackable" type="checkbox"
                                                                                       id="popupstackable" class="cargo_details" value="1">
                                                                                &nbsp;&nbsp; <label for="popupstackable"><?= $this->lang->line('qbook_stackable'); ?></label>
                                                                                <br> <input name="popupgroundable" type="checkbox"
                                                                                            id="popupgroundable" class="cargo_details"
                                                                                            value="1"> &nbsp;&nbsp; <label
                                                                                    for="popupgroundable"><?= $this->lang->line('grounded'); ?></label>
                                                                                <br> <input name="popupsplittable" type="checkbox"
                                                                                            id="popupsplittable" class="cargo_details"
                                                                                            value="1"> &nbsp;&nbsp; <label
                                                                                    for="popupsplittable"><?= $this->lang->line('splittable'); ?></label>
                                                                                <br> <input name="popupdg_goods" type="checkbox"
                                                                                            id="popupdg_goods" class="cargo_details" onchange="checkDggoods()" value="1">
                                                                                &nbsp;&nbsp; <label for="popupdg_goods"><?= $this->lang->line('dg_goods'); ?></label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <div class="input-group row">
                                                                        <div class="col-md-12">
                                                                            <label for="marks_numbers"><?= $this->lang->line('marks_numbers'); ?></label>
                                                                            <input type="text" onkeyup="upper(this);" class="Txtfld form-control ui-autocomplete-input popupcargo_form" name="marks_numbers" id="marks_numbers" autocomplete="off">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="add-button-row">
                                                                    <div class="col-md-4" style="padding-top: 15px;">
                                                                        <input type="submit" name="add"
                                                                               value="<?= $this->lang->line('general_save'); ?>"
                                                                               class="btn btn-primary btn_color waves-effect waves-light">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>

                                            </div>

                                            </form>
                                            <div class="col-md-12">
                                                <div class="row" style="overflow-x: auto;">
                                                    <table class="table table-striped table-bordered"
                                                           cellspacing="0" style="width: 100%;" id="popuporder_cargo">
                                                        <thead>
                                                        <tr>
                                                            <th class="th-sm"><?= $this->lang->line('general_actions'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('package_type'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('qbook_goodsdescription'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('marks_numbers'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_quantity'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_length'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_width'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_height'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('actual_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('volumetric_weight'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('actual_volume'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('general_volume'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('ldm'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('qbook_stackable'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('grounded'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('splittable'); ?></th>
                                                            <th class="th-sm"><?= $this->lang->line('dg_goods'); ?></th>

                                                        </tr>
                                                        </thead>
                                                        <tbody class="cargo_details">
                                                        </tbody>
                                                    </table>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button"
                                    class="closevalues btn btn-default waves-effect btn_color resetbtn"
                                    data-dismiss="modal"><?= $this->lang->line('general_close'); ?></button>
                            <input type="submit"
                                   class="btn btn-primary submitorderdetails btn_color waves-effect waves-light"
                                   name="submit"
                                   value="<?= $this->lang->line('general_save'); ?>"
                                   form="quickbook_form">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_items">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('view_items');">&times;
                            </button>
                            <h4 class="modal-title" id="view_items_title">List of Items</h4>
                        </div>
                        <div class="modal-body " style="overflow-x: auto;">
                            <div class="box custom-box">
                                <table class="table table-striped" width="100%" id="item_tab">
                                    <thead>
                                    <tr>
                                        <th scope="col"></th>
                                        <th scope="col"><?= $this->lang->line('package_type'); ?></th>
                                        <th scope="col">Length</th>
                                        <th scope="col">Width</th>
                                        <th scope="col">Height</th>
                                        <th scope="col">Actual Weight</th>
                                        <th scope="col">Weight</th>
                                        <th scope="col">Volumetric Weight</th>
                                        <th scope="col">Actual Volume</th>
                                        <th scope="col">Volume</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="items-show_data">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-default waves-effect btn_color resetbtn"
                                    onclick="viewmodaleclose('view_items');">Close
                            </button>
                            <button type="button"
                                    class="selectitem btn btn-primary btn_color waves-effect waves-light"
                                    onclick="selectiteminlist()">Select
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_branch">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('view_branch');">&times;
                            </button>
                            <h4 class="modal-title" id="view_branch_title">Branch details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box">
                                <table class="table table-striped" id="branch_tab" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Branch Name</th>
                                        <th scope="col">Branch Code</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="show_branchdata">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-default waves-effect btn_color resetbtn"
                                    onclick="viewmodaleclose('view_branch');">Close
                            </button>
                            <button type="button"
                                    class="selectbranch btn btn-primary  btn_color waves-effect waves-light"
                                    onclick="selectbranchinlist()">Select
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_company">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('view_company');">&times;
                            </button>
                            <h4 class="modal-title" id="view_company_title">Company details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box">
                                <table class="table table-striped" id="company_tab" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Company Name</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Description</th>
                                    </tr>
                                    </thead>
                                    <tbody id="company-show_data">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-default waves-effect btn_color resetbtn"
                                    onclick="viewmodaleclose('view_company');">Close
                            </button>
                            <button type="button"
                                    class="selectcompany btn btn-primary btn_color waves-effect waves-light"
                                    onclick="selectcompanyinlist()">Select
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_customer">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('view_customer');">&times;
                            </button>
                            <h4 class="modal-title" id="view_customer_title">Party details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box" style="overflow-x: auto;">
                                <table class="table table-striped table-bordered" width="100%"
                                       id="list_party">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">ID</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Street</th>
                                        <th scope="col">City</th>
                                        <th scope="col">Country</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Branch Code</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-default waves-effect btn_color resetbtn"
                                    onclick="viewmodaleclose('view_customer');">Close
                            </button>
                            <button type="button"
                                    class="selectpopup btn btn-primary  btn_color waves-effect waves-light"
                                    onclick="selectshipperinlist()">Select
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="view_party">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('view_party');">&times;
                            </button>
                            <h4 class="modal-title" id="view_party_title">Party details</h4>
                        </div>
                        <div class="modal-body ">
                            <div class="box custom-box" style="overflow-x: auto;">
                                <table
                                    class="table table-striped add-edit-table table-bordered table_bg"
                                    id="partylistdata" width="100%">
                                    <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">ID</th>
                                        <th scope="col">Name</th>
                                        <th scope="col">Party Type</th>
                                        <th scope="col">Street</th>
                                        <th scope="col">City</th>
                                        <th scope="col">Country</th>
                                        <th scope="col">Company Code</th>
                                        <th scope="col">Branch Code</th>
                                    </tr>
                                    </thead>
                                    <tbody id="">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" onclick="viewmodaleclose('view_party');"
                                    class="btn btn-default waves-effect btn_color resetbtn">Close
                            </button>
                            <button type="button"
                                    class="selectparty btn btn-primary  btn_color waves-effect waves-light"
                                    onclick="selectpartyinlist()">Select
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div id="create_popupreference" class="modal fade" tabindex="-1"
                 role="dialog" aria-hidden="true" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close"
                                    onclick="viewmodaleclose('create_popupreference');"
                                    aria-hidden="true">×
                            </button>
                            <h4 class="modal-title" id="companyCodeAddmodalLabel">Add
                                Reference Details</h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label>Reference Name</label> <input type="hidden"
                                                                             name="popupref_row_id" id="popupref_row_id" value=""> <input
                                            type="text" class="popupref Txtfld form-control"
                                            id="popupreference_id" value="" onkeyup="upper(this);" onkeypress="return getreference_autocomplete()" size="20">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="Description">Description</label> <input
                                            type="text" class="popupref Txtfld form-control"
                                            onkeyup="upper(this);" id="popupreference_name" size="20"
                                            value="">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label>Reference Value</label> <input type="text"
                                                                              class="popupref form-control Txtfld "
                                                                              id="popupreference_value" onkeyup="upper(this);" size="20"
                                                                              value=""> <input type="hidden" name="order_ref_id"
                                                                                               id="order_ref_id">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button"
                                    class="btn btn-default waves-effect btn_color resetbtn"
                                    onclick="viewmodaleclose('create_popupreference');">Close
                            </button>
                            <input type="submit"
                                   class="submittypebtn btn-primary  btn_color waves-effect waves-light"
                                   id="popupadd_refernce" onclick="addpopupreferencedetails(event)"
                                   data-dismiss="close" data-info="add" value="Save">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<script>
    var baseurl = "<?= base_url(); ?>";
    var rateServiceId = <?= $rateServiceRowIdForBook?>;
    if (rateServiceId > 0) {
        $('#quickBookId').click();
    }
</script>
<script
    src="<?= base_url(); ?>assets/newtheme/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
<link href="<?= base_url(); ?>assets/css/jquery.datetimepicker.css" rel="stylesheet">
<script src="<?= base_url(); ?>assets/js/jquery.datetimepicker.js"></script>
<script src="<?= base_url(); ?>assets/js/jquery.datetimepicker.full.js"></script>
<script src="<?= base_url(); ?>assets/plugins/select2/select2.min.js"></script>
<link rel="stylesheet" href="<?= base_url(); ?>assets/plugins/select2/select2.min.css">
<script src="<?= base_url(); ?>assets/sweetalerts/sweetalert.min.js"></script>
<script type="text/javascript">
    <?php if ($this->session->flashdata('booking') != ""){ ?>
    setTimeout(function () {
        $("#searchsubmit").click();
    }, 1000);

    <?php } ?>
    var ats = $('#ats_parties').val();
    var list_type = $('#list_type').val();
    if (ats != "" && list_type == '0') {
        checkatsservice();
    }

    function checkatsservice() {
        var ats_parties = $('#ats_parties').val();
        let fd = new FormData();
        fd.append('ats_parties', ats_parties);
        fd.append('action', 'list');

        $.ajax({
            url: baseurl + 'ats/ats_lib',
            type: 'POST',
            processData: false,
            data: fd,
            contentType: false,
            cache: false,
            async: false,
            success: function (data) {
                if (data.trim() == "0" || data.trim() == 0) {
                } else {
                    $('#atsModel .modal-body').html(data);
                    $('#atsModel').modal('show');
                }
            }
        });
    }

    function submitbulkcargos_fororder(e) {
        e.preventDefault();
        var ids = $('#cargo_orderids').val();
        var cargo_type = $('#updatcargo_val').val();
        if (cargo_type == "") {
            gettoast('top-right1', 'updatcargo_val', 'Select Cargo Type');
            return false;
        } else {
            $.ajax({
                url: baseurl + 'orderrevenues/updatebulkcargo',
                type: "POST",
                data: {'order_ids': ids, 'cargo_type': cargo_type},
                success: function (data) {
                    $('#cargoupd_success').css('display', 'block');
                    setTimeout(function () {
                        $('#cargoupd_success').fadeOut('fast');
                    }, 1000);
                    setTimeout(function () {
                        $("#cargobulkupload").modal('hide');
                    }, 2000);
                }
            });
        }
    }

    var list_type = $('#list_type').val();
    if (list_type == '1') {
        getorderslist();
    }
    var cllist_type = $('#cllist_type').val();
    if (cllist_type == '1') {
        getclorderslist();
    }
    var charge_list_type = $('#charge_list_type').val();
    if (charge_list_type == '1') {
        getchargesuploadpopup();
    }
    var knlogin_list_type = $('#knlogin_list_type').val();
    if (knlogin_list_type > 0) {
        getknLoginStatusRespose();
    }

    function getknLoginStatusRespose() {
        $('#knloginstatus_success_list').modal('show');
    }

    function getorderslist() {
        $('#orders_success_list').modal('show');
        var ats = $('#ats_parties').val();
        if (ats != "") {
            check_excelatsservice();
        }
    }

    function check_excelatsservice() {
        var ats_parties = $('#ats_parties').val();
        let fd = new FormData();
        fd.append('ats_parties', ats_parties);
        fd.append('action', 'count');
        $.ajax({
            url: baseurl + 'ats/ats_lib',
            type: 'POST',
            processData: false,
            data: fd,
            contentType: false,
            cache: false,
            async: false,
            success: function (data) {
                if (data.trim() == 0 || data.trim() == "0") {
                    console.log("Zero hits received.");
                } else {
                    var html = "Total ATS Hit Count is " + data + "";
                    $('#atsModel .modal-body').html(html);
                    $('#atsModel').modal('show');
                }
            }
        });
    }

    function getclorderslist() {
        $('#clorders_success_list').modal('show');
    }

    function getchargesuploadpopup() {
        $('#charges_success_list').modal('show');
    }

    function checkseachvalidation(e) {
        var fromDate = $('#fromDate').val();
        var toDate = $('#toDate').val();
        var bookingid = $('#bookingid').val();
        var status = $('#searchstatus').val();
        if (toDate == "") {
        } else {
            if (fromDate == "") {
                gettoast('top-right', 'fromDate', 'Please Enter From Date');
                return false;
            }
        }
        var company_code = $('#chkcompanycode').val();
        var chkbranchcode = $('#chkbranchcode').val();
        if (company_code == "AUKN" || chkbranchcode == "INCL") {
            var container_no = $('#container_no').val();
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "" && container_no == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        } else {
            if ((bookingid == "" || bookingid == null) && status == "" && fromDate == "" && toDate == "") {
                gettoast('top-right', '', 'Please select any field for search orders');
                return false;
            }
        }

        if (company_code == "SGKN") {
            if (toDate != '' || fromDate != '') {
                let daysCount = calculateDaysCount(fromDate, toDate);
                if (daysCount > 30) {
                    gettoast('top-right', '', 'Max History Days Are Limited To 31 Days');
                    return false;
                }
            }

        }
    }

    $("#popupshipper_country, #popupshipper_country").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: baseurl + "businesspartners/getcountrieslist",
                type: "POST",
                dataType: "json",
                data: {
                    country: request.term
                },
                success: function (data) {
                    if (data.length == 0) {
                        gettoast('top-right1', id, 'Please Enter Proper Country');
                        $('#' + popupshipper_country).val("");
                        return true;
                    } else {
                        response(data);
                    }
                }
            });
        },
    });
    $(".chkpopupcountry").each(function () {
        var id = $(this).attr('id');
        $('#' + id).autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: baseurl + "businesspartners/getcountrieslist",
                    type: "POST",
                    dataType: "json",
                    data: {
                        country: request.term
                    },
                    success: function (data) {
                        if (data.length == 0) {
                            gettoast('top-right1', id, 'Please Enter Proper Country');
                            $('#' + id).val("");
                            return true;
                        } else {
                            response(data);
                        }
                    }
                });
            },

        });
    });

    function validatetrip() {
        var carrier = $('#tcarrierid').val();
        var vehicletype = $('#tpvehicle_type').val();
        if (carrier == 277 && vehicletype == '') {
            gettoast('top-right', 'tpvehicle_type', 'Please Select Vehicle Type');
            return false;
        }
    }

    $('#incoterm_popup').on('change', function () {
        var incoterm = $(this).val();
        $.ajax({
            url: baseurl + 'smtcorders/getdeliverytermvalue',
            type: 'POST',
            dataType: 'json',
            data: {
                incoterm: incoterm,
            },
            success: function (data) {
                var htm = "<option value=''>Select</option>";
                if (data.length > 0) {
                    $.each(data, function (key, value) {
                        htm += "<option value='" + value.id + "'>" + value.id + " " + value.name + "-" + value.incoterm + "</option>";
                    });
                }
                $('#popupdelivery_terms').html(htm);
            }
        });
    });

    function filetrasnferfor_selectedorders() {
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Order');
            return false;
        } else {
            $.ajax({
                url: baseurl + 'Sendmultipleaconedi/filetrasnferfor_selectedorders',
                type: "POST",
                dataType: 'json',
                data: {'order_ids': ids},
                beforeSend: function () {
                    var table = $('#filetransfersucces_list').DataTable();
                    table.destroy();
                    $('#file_tranfer_succeslist').modal('show');
                    $('.filetransfersucces_list-body').html('<tr><td colspan="2" align="center"><img id="gif"  src="<?= base_url();?>assets/images/482.gif"></td></tr>');
                },
                success: function (data) {
                    $("#filetransfersucces_list").DataTable({
                        data: data,
                        "bPaginate": true,
                        "paging": true,
                        "bLengthChange": true,
                        "bFilter": true,
                        "bInfo": false,
                        "bAutoWidth": true,
                        "language": {
                            "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                        },
                        dom: 'Blfrtip',
                        buttons: [
                            'copyHtml5',
                            'excelHtml5',
                            'csvHtml5',
                            'pdfHtml5',
                            'print'
                        ],
                        "columns": [
                            {"data": "id"},
                            {"data": "status"},
                        ]
                    });

                }, error: function (errMsg) {
                    $(".filetransfersucces_list-body").html('<tr><td colspan="2" align="center">Something Went Wrong</td></tr>');
                }
            });
        }

    }

    function readytoinvoiceforselected(e) {
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Order');
            return false;
        } else {
            var table = $('#ready_invoice_tb').DataTable();
            table.destroy();
            $('#readyinvoice_show_data').html('');
            $.ajax({
                url: baseurl + 'orderrevenues/makeselectedasinvoice',
                type: "POST",
                dataType: 'json',
                data: {'order_ids': ids, 'fromdate': from_date},
                beforeSend: function () {
                    $('#readyinvoice_show_data').html('');
                    $('.pop_message_load').html('Please wait..!');
                    $("#ready_invoice").modal('show');
                },
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    console.log(data);
                    $('.pop_message_load').html('');
                    $("#ready_invoice_tb").DataTable({
                        data: data,
                        "bPaginate": true,
                        "paging": true,
                        "bLengthChange": true,
                        "bFilter": true,
                        "bInfo": false,
                        "bAutoWidth": true,
                        "language": {
                            "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                        },
                        dom: 'Blfrtip',
                        buttons: [
                            'copyHtml5',
                            'excelHtml5',
                            'csvHtml5',
                            'pdfHtml5',
                            'print'
                        ],
                        "columns": [
                            {"data": "id"},
                            {"data": "recipient_role"},
                            {"data": "JFR"},
                            {"data": "message"},
                            {"data": "status"},
                        ],
                    });
                }
            });
        }

    }

    function readytoinvoiceknbill(e) {
        e.preventDefault();
        var ids = [];
        var from_date = $('#fromDate').val();
        var htm = "";
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Please Select any Order');
            return false;
        } else {
            $.ajax({
                url: baseurl + 'aconedi/index',
                type: "POST",
                data: {'order_ids': ids, 'fromdate': from_date},
                beforeSend: function () {
                    $(".containerModal").modal("show");
                    $(".containerModal").find(".modal-title").html("Please Wait...");
                    $(".containerModal").find(".modal-body").html("<center><progress></center>");
                },
                success: function (data) {
                    var data = JSON.parse(data);
                    $(".containerModal").modal("hide");
                    if ((data.revenue_count > 0) || (data.accural_count > 0)) {
                        $(".pop_message").html('EDI Sent to KNbill Successfully');
                    } else {
                        $(".pop_message").html('No charges Found');
                    }
                    $("#insert_success_div").modal('show');
                },
                error: function (errMsg) {
                    $(".pop_message").html('Oops! Something went wrong');
                    $("#insert_success_div").modal('show');

                }
            });
        }

    }

    function isNonSpecialCharCheck(e) {
        var keynum;
        var keychar;
        var numcheck;
        if (window.event) {
            keynum = e.keyCode;
        } else if (e.which) {
            keynum = e.which;
        }
        keychar = String.fromCharCode(keynum);
        if (keychar == "'" || keychar == "`" || keychar == "~" || keychar == "+"
            || keychar == "/" || keychar == "\/" || keychar == "//" || keychar == "\\"
            || keychar == "<" || keychar == ">" || keychar == "^" || keychar == "|") {
            return false;
        } else {
            return true;
        }
    }

    $(document).ready(function () {
        var from_date = $('#fromDate').val();
        if (from_date != '') {
            var date_array = from_date.split("-");
            var newDate = date_array[1] + "-" + date_array[0] + "-" + date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#toDate').datepicker('setStartDate', minDate);
        }
        var advfrom_date = $('#advfrom_date').val();
        if (advfrom_date != '') {
            var date_array = advfrom_date.split("-");
            var newDate = date_array[1] + "-" + date_array[0] + "-" + date_array[2];
            var formatDate = new Date(newDate).getTime();
            var minDate = new Date(formatDate);
            $('#advto_date').datepicker('setStartDate', minDate);
        }

        var advpickupfrom_date = $('#advpickupfrom_date').val();
            if(advpickupfrom_date != ''){
                var date_array = advpickupfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advpickupto_date').datepicker('setStartDate', minDate);
            }

            var advdeliveryfrom_date = $('#advdeliveryfrom_date').val();
            if(advdeliveryfrom_date != ''){
                var date_array = advdeliveryfrom_date.split("-");
                var newDate = date_array[1]+"-"+date_array[0]+"-"+date_array[2];
                var formatDate = new Date(newDate).getTime();
                var minDate = new Date(formatDate);
                $('#advdeliveryto_date').datepicker('setStartDate', minDate);
            }
    });

    $('#fromDate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#toDate').datepicker('setStartDate', minDate);
    });
    $('#toDate').datepicker({
        format: 'dd-mm-yyyy',
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#fromDate').datepicker('setEndDate', maxDate);
    });

    $('#forcefromDate').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#forcetoDate').datepicker('setStartDate', minDate);
    });
    $('#forcetoDate').datepicker({
        format: 'dd-mm-yyyy',
    }).on('change', function () {
        $('.datepicker').hide();
    });

    $('#advfrom_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
    }).on('changeDate', function (selected) {
        var minDate = new Date(selected.date.valueOf());
        console.log(selected.date.valueOf());
        $('#advto_date').datepicker('setStartDate', minDate);
    });
    $('#advto_date').datepicker({
        format: 'dd-mm-yyyy',
    }).on('changeDate', function (selected) {
        var maxDate = new Date(selected.date.valueOf());
        $('#advfrom_date').datepicker('setEndDate', maxDate);
    });

    $('#advpickupfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advpickupto_date').datepicker('setStartDate', minDate);
        });
        $('#advpickupto_date').datepicker({
            format: 'dd-mm-yyyy',
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advpickupfrom_date').datepicker('setEndDate', maxDate);
        });


        $('#advdeliveryfrom_date').datepicker({
            format: 'dd-mm-yyyy',
            autoclose: true,
        }).on('changeDate', function (selected) {
            var minDate = new Date(selected.date.valueOf());
            console.log(selected.date.valueOf());
            $('#advdeliveryto_date').datepicker('setStartDate', minDate);
        });
        $('#advdeliveryto_date').datepicker({
            format: 'dd-mm-yyyy',
        }).on('changeDate', function (selected) {
            var maxDate = new Date(selected.date.valueOf());
            $('#advdeliveryfrom_date').datepicker('setEndDate', maxDate);
        });

    $(".bookingid").select2({
        placeholder: "<?= $this->lang->line('booking_id'); ?>",
        ajax: {
            url: "<?= base_url(); ?>" + 'orderrevenues/getorderids',
            type: "post",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    searchTerm: params.term
                };
            },
            processResults: function (response) {
                return {
                    results: response
                };
            },
            cache: true
        }
    });

    function deleteselectedrecords() {
        var selectedrecords = [];
        $('input.recordcheckbox:checkbox:checked').each(function () {
            selectedrecords.push($(this).val());
        });
        if
        (selectedrecords.length == 0) {
            gettoast('top-right1', '', 'No records were selected for this operation');
            return false;
        } else {
            swal({
                title: 'Are you going to delete these records?',
                text: 'There will be no way to restore them. Would you like to continue',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No, cancel !',
                closeOnConfirm: true,
                closeOnCancel: false
            }, function (isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "post",
                        url: "<?= base_url('smtcorders/deleteorders/');?>",
                        data: {deleteids: selectedrecords},
                        success: function (data) {
                            if (data == 'success') {
                                location.reload();
                            } else {
                                console.log(data);
                            }
                        },
                    })
                } else {
                    swal('Cancelled', 'Your record is safe :)', 'error');
                }
            });
        }
    }

    function deleteorderbyid(orderid) {
        var x = confirm("Are you sure you want to delete this Order?");
        if (x) {
            $.ajax({
                url: baseurl + 'smtcorders/deleteorder/' + orderid,
                type: "GET",
                success: function () {
                    location.reload();
                }
            });
        } else {
            return false;
        }
    }

    $('#tcarrierid').on('change', function () {
        var id = $("#tcarrierid").val();
        if (id == '') {
            $("#nccode").val('');
            return false;
        }
        $.ajax({
            url: baseurl + 'smtcorders/gettripcarinfo/' + id,
            type: "POST",
            dataType: 'JSON',
            success: function (data) {
                $(".tripcar_name").val(data.carrier_name);
                $("#tdrivespan").html(data.drivers);
                $("#debtor_code_status").val(data.debtor_code);
                $("#tpvehicle_type").html(data.vehicle_type);
            }
        });
    });
    $('#tpvehicle_type').on('change', function () {
        var id = $("#tpvehicle_type").val();
        if (id != '') {
            var carrierid = $('#tcarrierid').val();
            $("#tvehid").val('');
            if (carrierid == '') {
                $("#dialog").dialog();
                $(".ui-dialog").addClass('alert_zindex');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog-text").text("Please select carrier details");
                return false;
            }
            $.ajax({
                url: baseurl + 'smtcorders/gettripvelinfo',
                type: "POST",
                data: {
                    carrierid: carrierid, vtype: id,
                },
                dataType: 'JSON',
                success: function (data) {
                    $("#tpveh_typename").val(data.typename);
                    $("#tpveh_numdiv").html(data.vehiclenum);
                }
            });
        } else {
            $("#tpveh_typename").val('');
            return false;
        }

    });

    function myfun() {
        var id = $("#tvehnum").val();
        if (id != '') {
            $.ajax({
                url: baseurl + 'smtcorders/getvelinfo/' + id,
                type: "POST",
                dataType: 'JSON',
                success: function (data) {
                    if (data.transit == 1) {
                        $("#tvehid").val('');
                        $("#intransit_status").show();
                        setTimeout(function () {
                            $("#intransit_status").hide();
                        }, 3000);

                        var id = $("#tpvehicle_type").val();
                        var carrierid = $('#tcarrierid').val();
                        if (carrierid == '') {
                            $("#carrier_status").show();
                            setTimeout(function () {
                                $("#carrier_status").hide();
                            }, 3000);

                            return false;
                        }
                        $.ajax({
                            url: baseurl + 'smtcorders/gettripvelinfo',
                            type: "POST",
                            data: {
                                carrierid: carrierid, vtype: id,
                            },
                            dataType: 'JSON',
                            success: function (data) {
                                $("#tpveh_typename").val(data.typename);
                                $("#tpveh_numdiv").html(data.vehiclenum);
                            }
                        });
                        return false;
                    } else {
                        var vehicle_num = $("#tvehnum option:selected").val();
                        if (vehicle_num == "") {
                            $('#tcarrierid').trigger("change");
                        } else {
                            var carrier_id = $("#tcarrierid option:selected").val();
                            var register_number = $("#tvehnum option:selected").text();
                            $('#tvehid').val(register_number);
                            $.ajax({
                                url: baseurl + "shipmentplan/getdriversbyvendor",
                                type: "POST",
                                data: {'carrier_id': carrier_id},
                                dataType: "JSON",
                                success: function (data) {
                                    if (data['drivers'].length == 0) {
                                        $("#tdri_name").html("<option value=''>-Driver(s) not found-</option>");
                                    } else {
                                        $("#tdri_name").html("<option value=''>-select-</option>");
                                    }
                                    $.each(data["drivers"], function (i, value) {
                                        var sts = "";
                                        $("#tdri_name").append("<option  value='" + value.id + "'> " + value.name + " </option>");
                                    });
                                }
                            });
                        }
                    }
                }
            });
        } else {
            $('#tvehid').val('');
            return false;
        }
    }

    function getdrid() {
        var vehicle_num = $("#tvehnum option:selected").val();
        if (vehicle_num == "") {
            $('#tcarrierid').trigger("change");
        } else {
            var id = $("#tdri_name").val();
            if (id != "") {
                $.ajax({
                    url: baseurl + 'smtcorders/getdriverid/' + id,
                    type: "POST",
                    success: function (data) {
                        $("#tdri_id").val(data);
                    }
                });
            } else {
                $('#tdri_id').val('');
                return false;
            }
        }
    }

    function importFromGSheets() {
        window.location = '<?= base_url('gdocs/selectFile'); ?>';
    }

    var company_code = $('#chkcompanycode').val();
    $('#buttonid').on('click', function () {
        $("#exlfile").click();
    });
    $('#buttonsgid').on('click', function () {
        $("#exlsgupfile").click();
    });
    $('#buttoncargoid').on('click', function () {
        $("#exlcargoupfile").click();
    });
    $('#buttoncostid').on('click', function () {
        $("#exlcostfile").click();
    });
    $('#buttonachievaid').on('click', function () {
        $("#buttonachievaupfile").click();
    });
    $(document).ready(function () {
        $(".datetimepicker").datetimepicker({
            format: "Y-m-d H:i:s",
            autoclose: true,
        });
    });
    $('.closevalues').click(function () {
        $('.quickbookform').val("");
        $('#shipper_details').html("");
        $('#consignee_details').html("");
        var company_code = "<?= $this->session->userdata('company_code'); ?>";
        var branch_code = "<?= $this->session->userdata('branch_code'); ?>";
        $('#popupcompany_code').val(company_code);
        $('#popupbranch_code').val(branch_code);
        var custid = "<?= $this->session->userdata('cust_id'); ?>";
        if (custid == "") {
            $('#customer_details').html("");
            $('#popupcustomer_id').val("");
        }

    });
    popupheight.oninput = popupheight_uom.oninput = function () {
        var height = $('#popupheight').val();
        var height_uom = $('#popupheight_uom').val();
        var width_uom = $('#popupwidth_uom').val();
        var length_uom = $('#popuplength_uom').val();
        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height = $('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_height = height;
        $('#mainpopupheight').val(main_height);
        $('#popupquantity').attr("onkeyup", "changepopupdimensions(this);");
        if (height_uom == 'Cm' && width_uom == 'Cm' && length_uom == 'Cm') {
            if (height != "" && width != "" && length != "") {
                var volume = (length * width * height) / 1000000;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'M' && width_uom == 'M' && length_uom == 'M') {
            if (height != "" && width != "" && length != "") {
                var volume = length * width * height;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'Inches' && width_uom == 'Inches' && length_uom == 'Inches') {
            if (height != "" && width != "" && length != "") {
                var total_value = length * width * height;
                var voln = total_value / 61024;
                var volume = voln.toFixed(2);
                $('#popupvolume').val(volume);
            }
        }
    };
    popupweight.oninput = function () {
        var weight = $('#popupweight').val();
        var quantity = $('#popupquantity').val();
        var main_weight = weight;
        $('#mainpopupweight').val(main_weight);
        $('#popupquantity').attr("onkeyup", "changepopupdimensions(this);");

    };
    popupwidth.oninput = popupwidth_uom.oninput = function () {
        var height = $('#popupheight').val();
        var height_uom = $('#popupheight_uom').val();
        var width_uom = $('#popupwidth_uom').val();
        var length_uom = $('#popuplength_uom').val();
        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height = $('#popupheight').val();
        var quantity = $('#popupquantity').val();
        var main_width = width;
        $('#mainpopupwidth').val(main_width);
        $('#popupquantity').attr("onkeyup", "changepopupdimensions(this);");
        if (height_uom == 'Cm' && width_uom == 'Cm' && length_uom == 'Cm') {
            if (height != "" && width != "" && length != "") {
                var volume = (length * width * height) / 1000000;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'M' && width_uom == 'M' && length_uom == 'M') {
            if (height != "" && width != "" && length != "") {
                var volume = length * width * height;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'Inches' && width_uom == 'Inches' && length_uom == 'Inches') {
            if (height != "" && width != "" && length != "") {
                var total_value = length * width * height;
                var voln = total_value / 61024;
                var volume = voln.toFixed(2);
                $('#popupvolume').val(volume);
            }
        }
    };

    function changepopupbylength() {
        var height = $('#popupheight').val();
        var height_uom = $('#popupheight_uom').val();
        var width_uom = $('#popupwidth_uom').val();
        var length_uom = $('#popuplength_uom').val();
        var length = $('#popuplength').val();
        var width = $('#popupwidth').val();
        var height = $('#popupheight').val();
        $('#popupquantity').attr("onkeyup", "changepopupdimensions(this);");
        var quantity = $('#popupquantity').val();
        var main_length = length;
        $('mainpopuplength').val(main_length);
        if (height_uom == 'Cm' && width_uom == 'Cm' && length_uom == 'Cm') {
            if (height != "" && width != "" && length != "") {
                var volume = (length * width * height) / 1000000;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'M' && width_uom == 'M' && length_uom == 'M') {
            if (height != "" && width != "" && length != "") {
                var volume = length * width * height;
                $('#popupvolume').val(volume);
            }
        } else if (height_uom == 'Inches' && width_uom == 'Inches' && length_uom == 'Inches') {
            if (height != "" && width != "" && length != "") {
                var total_value = length * width * height;
                var voln = total_value / 61024;
                var volume = voln.toFixed(2);
                $('#popupvolume').val(volume);
            }
        }
    }

    function sendorderdetailsclick(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push({
                'ids': $(this).attr("id")
            })
        });
        if (ids.length == 1) {
            var id = ids[0]['ids'];
            $.ajax({
                url: baseurl + 'smtcorders/getorderdetails/' + id,
                beforeSend: function () {
                },
                success: function (data) {
                }
            });
        }
    }

    function checkpopuppurchaseordervalue() {
        var val = $('#purchaseorder_popup').val();
        var customer_id = $('#popupcustomer_id').val();
        $.ajax({
            url: baseurl + 'smtcorders/checkpurchaseordervalue',
            type: 'POST',
            dataType: 'json',
            data: {'purchase_order': val, 'customer_id': customer_id},
            success: function (data) {
                if (data == 1) {
                    $('#purchaseorder_popup').val('');
                    gettoast('top-right1', 'purchaseorder_popup', 'Purchase Order already exist with another order');
                }
            }
        });
    }

    function addreferenceforquickbook(e) {
        e.preventDefault();
        $('#popupref_row_id').val('');
        $('.popupref').val("");
        $("#create_popupreference").modal('show');
    }

    function viewmodaleclose(id) {
        $('#' + id).modal('hide');
    }

    function changepopupdimensions(ele) {
        var count = $(ele).val() * 1;
        if (count >= '1') {
            var plength = $('#popuplength').val();
            var pwidth = $('#popupwidth').val();
            var pheight = $('#popupheight').val();
            var pweight = $('#popupweight').val();
            var weight = pweight * count;
            $('#popupweight').val(weight);
            var volume = plength * pwidth * pheight * count;
            $('#popupvolume').val(volume);
        }
    }

    $('.checkAll').on('click', function () {
        if (this.checked == true)
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', true);
        else
            $('.forcheckboxes').find('input[name="chck1"]').prop('checked', false);
    });

    function palletadd(id) {
        $('#order_row_id').val(id);
        $('#Modal_Add').modal('show');
    }

    function checkreference(e) {
        var order_reftype = $('#order_reftype').val();
        var ref_val = $('#ref_val').val();
        if (order_reftype != "") {
            if (ref_val == "") {
                gettoast('top-right', 'ref_val', 'Please Enter reference Value');
                return false;
            }
        }
    }
</script>
<link href="<?= base_url(); ?>assets/newtheme/plugins/toast/toastStyle.css" rel="stylesheet" type="text/css"/>
<script src="<?= base_url(); ?>assets/newtheme/js/custom.js"></script>
<script src="<?= base_url(); ?>assets/js/jquery-ui.js"></script>
<script src="<?= base_url(); ?>assets/newtheme/js/main.js"></script>
<script src="<?= base_url(); ?>assets/newtheme/plugins/toast/toast.js"></script>
<script src="<?= base_url(); ?>assets/js/smtc_order_script.js?v=1.0"></script>
<link rel="stylesheet" type="text/css" href="<?= base_url(); ?>assets/datatables/dataTables.bootstrap.min.css">
<script src="<?= base_url(); ?>assets/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
<script src="<?= base_url(); ?>assets/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
<script src="<?= base_url(); ?>assets/datatables/dataTables.colReorder.min.js"></script>
<?php
$reference = [];
foreach ($ref_names_arr as $res):
    $reference[] = $res['name'];
endforeach;
$referencemaster = $reference;
?>
<script type="text/javascript">
    function getreference_autocomplete() {
        var ref_ids = <?= json_encode($referencemaster); ?>;
        $('#popupreference_id').autocomplete({
            source: ref_ids,
            select: function (event, ui) {
                $(this).val(ui.item.label);
                var id = ui.item.value;
                $.ajax({
                    url: baseurl + 'Orderrevenues/getrefnamebyid',
                    type: 'post',
                    data: {item_id: id, request: 2},
                    dataType: 'json',
                    success: function (response) {
                        if (response != "") {
                            $('#popupreference_name').val(response);
                        }
                    }
                });
                return false;

            }
        });
    }


    function orderExportOptions(options) {
        if (options == 'excel') {
            $('#orderslist_wrapper .buttons-excel').click();
        } else if (options == 'pdf') {
            $('#orderslist_wrapper .buttons-pdf').click();
        } else if (options == 'print') {
            $('#orderslist_wrapper .buttons-print').click();
        }
    }

    function createTrip() {
        var debtor_code_status = $("#debtor_code_status").val();
        if (debtor_code_status == "1") {
            $("#acon_status").show();
            setTimeout(function () {
                $("#acon_status").hide();
            }, 3000);
            return false;
        } else {
            return true;
        }
    }

    function forcecloseorders() {
        var forcetoDate = $("#forcetoDate").val();
        var forcefromDate = $("#forcefromDate").val();
        if (forcetoDate == "" || forcefromDate == "") {
            $("#forceClose_dates").html("Please select the proper Dates");
            $("#forceClose_dates").css("color", "red");
            $("#forceClose_dates").show();
            setTimeout(function () {
                $("#forceClose_dates").hide();
            }, 2000);
        } else {
            $.ajax({
                url: baseurl + 'smtcorders/threemshipmetsforceclose',
                type: 'post',
                data: {forcetoDate: forcetoDate, forcefromDate: forcefromDate},
                dataType: 'text',
                success: function (response) {
                    if (response != "") {
                        $('#forceClose_dates').html(response);
                        $("#forceClose_dates").css("color", "Green");
                        $("#forceClose_dates").show();
                        setTimeout(function () {
                            $("#forceClose_dates").hide();
                        }, 2500);
                        setTimeout(function () {
                            $("#forceClosediv").hide();
                        }, 2500);
                    }
                }
            });

        }
        return false;

    }
    function disableOtherInputFields() {
        var url = baseurl + "orders/triporderintoshipment";
        var templateId = $('#templateId').val();
        if (templateId != "") {
            url = baseurl + "tripstemplate/storeShipmentByTemplate";
            $('.tripcreatefields').prop('disabled', true);
            $('#tcarrierid').attr('required', false);
        } else {
            $('.tripcreatefields').prop('disabled', false);
            $('#tcarrierid').attr('required', true);
        }
        $("#tripcreation").attr("action", url);
    }

    function sendShipmentStatusxml(e) {
        e.preventDefault();
        var ids = [];
        $("input:checkbox[name=chck1]:checked").each(function () {
            ids.push($(this).attr("id"));
        });
        if (ids.length == 0) {
            gettoast('top-right', '', 'Please select atleast one order');
        } else if (ids.length > 5) {
            gettoast('top-right', '', 'Maximum orders to be selected are 5');
        } else {
            $.ajax({
                url: baseurl + 'shipmentxmldata/sendOrderStatusXmlstoKNlogin',
                type: "POST",
                data: {'ids': ids},
                dataType: 'json',
                beforeSend: function () {
                },
                success: function () {
                    location.href = baseurl + 'smtcorders/orderslist/04';
                }
            });
        }
    }

    function checkDggoods(){
        if ($('#popupdg_goods').prop('checked') == true) {
            getDangerousGoodsDetails(0,0,0,1);
        }
    }
</script>
<style type="text/css">
    #cargobulkupload .modal-dialog {
        width: 30%;
        margin: 30px auto;
    }

    #cargobulkupload, .modal-footer {
        padding: 5px 15px;
    }

    #cargobulkupload .modal-body {
        position: relative;
        padding: 5px;
    }

    .dataTables_empty {
        height: 30px;
    }

    #quickbook_popup {
        overflow-y: auto;
    }

    .select2-selection__choice {
        color: white;
    }

    .popupcargo_form {
        margin-bottom: 0px;
    }

    FIELDSET {
        PADDING-TOP: 0px;
        PADDING-BOTTOM: 4px;
        BORDER: solid 1px #ccc;
    }

    LEGEND {
        COLOR: black;
        FONT-WEIGHT: bold;
        font-size: 13px;
    }
</style>
<?php
$auArray = ['AUKN', 'KNAU'];
if (in_array($this->session->userdata('company_code'), $auArray)) {
    $labelUrl = base_url() . 'bulkOrderLabel/bulkMacpacLabels';
} else {
    $labelUrl = base_url() . 'bulkOrderLabel/orderlabel';
}
?>
<form method="POST" action="<?= $labelUrl; ?>" id="bulkLabelPdfForm">
    <input type="hidden" name="orderIds" id="bulkOrderArray">
</form>
