<?php

$switches = $quickbookData['quickbookSwitches'] ?? [];
$documentTypes = $quickbookData['documentTypes'] ?? [];
$orderStops = $quickbookData['stops'] ?? [];
$transport = $quickbookData['transport'] ?? [];
$service = $quickbookData['service'] ?? [];
$orderTypes = $quickbookData['orderTypes'] ?? [];
$vasMasterData = $quickbookData['vasMasterData'] ?? [];
$customerRowId = $customerRowId ?? $this->session->userdata('cust_id');
$companyCode = $companyCode ?? $this->session->userdata('company_code');

$orderRowId = $orderDetails['orderRowId'] ?? 0;
$orderTotalVolume = $orderDetails['orderTotalVolume'] ?? 0;
$orderTotalWeight = $orderDetails['orderTotalWeight'] ?? 0;
$orderTotalQuantity = $orderDetails['orderTotalQuantity'] ?? 0;
$ordersTableData = $orderDetails['ordersTableData'] ?? [];
$bookingId = $ordersTableData['order_id'] ?? "";
$orderDgDetails = $orderDetails['orderDgDetails'] ?? [];
$orderDetailsTableData = $orderDetails['orderDetailsTableData'] ?? [];
$orderAddons = $orderDetails['orderAddons'] ?? [];
$orderCargos = $orderDetails['orderCargos'] ?? [];
$orderPartyDetails = $orderDetails['orderPartyDetails'] ?? [];
$orderReferences = $orderDetails['orderReferences'] ?? [];
$orderCharges = $orderDetails['orderCharges'] ?? [];
$orderDocuments = $orderDetails['orderDocuments'] ?? [];
$orderPartyIds = $orderDetails['orderPartyIds'] ?? [];
$shipperRowId = $orderPartyIds['shipper']['rowId'] ?? 0;
$consigneeRowId = $orderPartyIds['consignee']['rowId'] ?? 0;
$pickupRowId = $orderPartyIds['pickup']['rowId'] ?? $shipperRowId;
$deliveryRowId = $orderPartyIds['delivery']['rowId'] ?? $consigneeRowId;
$shipperHouseNumber = $orderPartyIds['shipper']['house_number'] ?? 0;
$consigneeHouseNumber = $orderPartyIds['consignee']['house_number'] ?? 0;
$totalChargesAmount = 0;
foreach ($orderCharges as $eachCharge):
    $totalChargesAmount += $eachCharge['amount'];
endforeach;
?>
<form method="POST" action="<?= base_url() ?>svkCustomer/CustomerOrders/saveQuickbook" onsubmit="return validateQuickbook();" id="quickbookForm">
    <div class="popUploadRowIdsDevTag"></div>
    <div class="cargoRowIdsDevTag">
        <?php
        foreach ($orderCargos as $eachCargo): ?>
            <input type='checkbox' form='quickbookForm' name='cargoRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='cargoRowIds_<?= $eachCargo['cargoRowId'] ?>' value='<?= $eachCargo['cargoRowId'] ?>' style='display: none;' checked>
        <?php
        endforeach;
        foreach ($orderDgDetails as $eachInput):
            echo $eachInput;
        endforeach;
        ?>
    </div>
    <div class="dgGoodsRowIdsDevTag"></div>
    <input type="hidden" name="customerRowId" id="customerRowId" value="<?= $customerRowId ?>">
    <input type="hidden" name="orderRowId" id="orderRowId" value="<?= $orderRowId ?>">
    <input type="hidden" name="bookingId" id="bookingId" value="<?= $bookingId ?>">
    <input type="hidden" name="companyCode" id="companyCode" value="<?= $companyCode ?>">
    <input type="hidden" name="isCipPortalShipper" id="isCipPortalShipper" form="addingCustomer" value="0"/>
    <input type="hidden" name="isDuplicateCustomer" id="isDuplicateCustomer" form="addingCustomer" value="0"/>
</form>
<div class="card-box">
    <div class="row">
        <div class="col-lg-9 col-md-12 col-sm-12">
            <div class="row">
                <div class="col-sm-12">
                    <h1 class="main_title">Booking Details</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 lineRight">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/pickup.svg">
                                </div>
                                <p>Pickup address</p>
                                <p><span id="shipperNameInfo">
                                        <?php
                                        if ($orderRowId > 0): ?>
                                            <?= $ordersTableData['pickup_company'] ?? "" ?>
                                        <?php
                                        endif; ?>
                                    </span></p>
                                <p id="shipperAddressInfo">
                                    <?php
                                    if ($orderRowId > 0):
                                        $pickupCity = $ordersTableData['pickup_city'] ?? "";
                                        $pickupCountry = $ordersTableData['pickup_country'] ?? "";
                                        ?>
                                        <?= $pickupCity . "," . $pickupCountry ?>
                                    <?php
                                    endif; ?>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/delivery.svg">
                                </div>
                                <p>Delivery address</p>
                                <p><span id="consigneeNameInfo">
                                        <?php
                                        if ($orderRowId > 0): ?>
                                            <?= $ordersTableData['delivery_company'] ?? "" ?>
                                        <?php
                                        endif; ?>
                                    </span></p>
                                <p id="consigneeAddressInfo">
                                    <?php
                                    if ($orderRowId > 0):
                                        $deliveryCity = $ordersTableData['delivery_city'] ?? "";
                                        $deliveryCountry = $ordersTableData['delivery_country'] ?? "";
                                        ?>
                                        <?= $deliveryCity . "," . $deliveryCountry ?>
                                    <?php
                                    endif; ?>
                                </p>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12">
                    <div class="row">
                        <div class="col-md-6 col-sm-12">
                            <div class="colum ptd-20 colum-p">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/weight.svg">
                                </div>
                                <p>Weight</p>
                                <input type="hidden" name="totalWeightInput" class="customerQuickbookDropDown" id="totalWeightInput" value="<?= $orderTotalWeight ?? 0 ?>">
                                <p><span id="totalWeight"><?= $orderTotalWeight ?? 0 ?></span></p>
                                <div class="mt-2">
                                    <p>Actual Volume</p>
                                    <input type="hidden" name="totalVolumeInput" class="customerQuickbookDropDown" id="totalVolumeInput" value="<?= $orderTotalVolume ?? 0 ?>">
                                    <input type="hidden" name="totalQuantityInput" class="customerQuickbookDropDown" id="totalQuantityInput" value="<?= $orderTotalQuantity ?? 0 ?>">
                                    <p><span id="totalVolume"><?= $orderTotalVolume ?? 0 ?></span></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="colum  ptd-20 lineRight">
                                <div class="iconBox">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/weight.svg">
                                </div>
                                <p>Distance</p>
                                <p><span id="distanceIcon"></span></p>
                                <?php
                                if (in_array('Show Map', $switches, true)): ?>
                                    <div class="mt-2 map-icon">
                                        <p><a href="#" class="mapTaggle" onclick="toggleMap()"><i class="fa fa-map-marker-alt"></i>Map</a></p>
                                    </div>
                                <?php
                                endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="showMap" style="display: none">
            <button type="button" class="close showMapClose" onclick="closeMapPopup()">&times;</button>
            <div id="map">
            </div>
        </div>

        <div class="col-lg-3 col-md-12 col-sm-12">
            <?php
            if (in_array('Show Quotes', $switches, true)): ?>
                <div class="colum  ptd-20 blueActiveBg colortext" style="height: 80px;">
                    <div class="ptd">
                        <div class="iconBox">
                            <img src="<?= base_url() ?>assets/svkCustomer/images/total.svg">
                        </div>
                        <p>Indicative Price</p>
                        <input type="hidden" name="totalOrderCharges" id="totalOrderCharges" value="<?= $totalChargesAmount ?>">
                        <p><span id="totalCharges"><?= round($totalChargesAmount,2) ?></span></p>
                        <p><small>(Taxes will be Applicable)</small></p>
                    </div>
                </div>
            <?php
            endif; ?>
        </div>
    </div>
    <hr>
    <!-- end row -->
    <div class="row inputMainHeight">
        <div class="col-lg-6 col-md-12 col-sm-12 pd-left lineRight">
            <form>
                <div class="row">
                    <div class="col-md-12">
                        <h1 class="main_title">Pick Up</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="shipperCode" class="form-label">Shipper ID </label>
                            <div class="input-group">
                                <?php
                                $pickupCode = $orderPartyDetails[$pickupRowId]['code'] ?? "" ?>
                                <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperCode" name="shipperCode" value="<?= $pickupCode ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperRowId" name="shipperRowId" value="<?= $pickupRowId ?? 0 ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperLatitude" name="shipperLatitude" value="<?= $ordersTableData['plat'] ?? "" ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperLongitude" name="shipperLongitude" value="<?= $ordersTableData['plng'] ?? "" ?>">
                                <div class="input-group-btn">
                                    <button class="btn btn-outline-secondary" type="button" data-toggle="modal" data-placement="top" title="Search" onclick="getShipperListFromCustomer(1)">
                                        <i class="icon tru-icon-search"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="getShipperListFromCustomer(0)">
                                        <i class="icon tru-icon-tender-list"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary saveShipperData" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="addShipperDataFromQuickbook()">
                                        <i class="icon tru-icon-add"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal -->
                    <div id="shipper_modalmain_list" class="modal fade partyTypeModel" role="dialog">
                        <div class="modal-dialog modal-md">
                            <!-- Modal content-->
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-number="shipper_modalList1" onclick="closepartyTypeModelPopup()">&times;</button>
                                    <h4 class="modal-title" id="partyTypeModalTitle">List</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="table-responsive quickbookTables">
                                        <table class="table documents_main" id="partyTypesListTable">
                                            <thead>
                                            <tr>
                                                <th></th>
                                                <th>ID</th>
                                                <th>Name</th>
                                                <th>Party Type</th>
                                                <th>Street</th>
                                                <th>City</th>
                                                <th>Country</th>
                                                <th>Company Code</th>
                                                <th>Branch Code</th>

                                            </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary" data-number="shipper_modalList1" onclick="closepartyTypeModelPopup()">Close</button>
                                    <button type="button" class="btn btn-secondary getQuote_btn partyTypeSelectButton" onclick="getSelectedPartyTypeInQuickbook()">Select</button>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="ShipperName" class="form-label">Shipper Name </label>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperName" name="shipperName" value="<?= $ordersTableData['pickup_company'] ?? "" ?>">
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="contactperson" class="form-label">Contact person</label>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperContactperson" name="shipperContactperson" value="<?= $ordersTableData['pickup_company'] ?? "" ?>">
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Date" class="form-label">Estimated Pickup Date </label>
                            <input type="text" form="quickbookForm" class="form-control datetimepicker customerQuickbookFields" name="estimatedPickupDate" id="estimatedPickupDate" value="<?= $ordersTableData['pickup_datetime'] ?? "" ?>" autocomplete="off">
                        </div>
                    </div>
                    <?php
                    $pickupCity = $ordersTableData['pickup_city'] ?? "";
                    $pickupState = $ordersTableData['pickup_address2'] ?? "";
                    $pickupCountry = $ordersTableData['pickup_country'] ?? "";
                    $pickupAddress = $pickupCity . " , " . $pickupState . " , " . $pickupCountry;
                    ?>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="findAddress" class="form-label">Shipper Address</label>

                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperAddress" name="shipperAddress" value="<?php
                            if ($orderRowId > 0): echo $pickupAddress; endif; ?>">
                        </div>
                    </div>
                    <div class="row shipperAddressLookup" id="shipperAddressLookup">
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="customerAccount" class="form-label">Country</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields addressFields country ui-autocomplete-input" id="shipperCountry" name="shipperCountry" value="<?= $pickupCountry ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="Street" class="form-label">Street</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields autocomplete route" id="shipperStreet" name="shipperStreet" value="<?= $ordersTableData['pickup_address1'] ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="Suburb" class="form-label">Suburb</label>
                                <input form="quickbookForm" type="text" class="addressFields form-control sublocality_level_1 customerQuickbookFields" id="shipperSuburb" name="shipperSuburb" value="<?= $pickupState ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="customerAccount" class="form-label">House Number</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields addressFields  ui-autocomplete-input" id="shipperHouseNumber" name="shipperHouseNumber" value="<?= $shipperHouseNumber ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="cityTown" class="form-label">City / Town</label>
                                        <input type="text" form="quickbookForm" class="addressFields form-control locality customerQuickbookFields" id="shipperCity" name="shipperCity" value="<?= $pickupCity ?>" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="postalCode" class="form-label">Postal Code</label>
                                        <input type="text" form="quickbookForm" class="addressFields form-control postal_code customerQuickbookFields" id="shipperPostalCode" name="shipperPostalCode" value="<?= $ordersTableData['pickup_pincode'] ?? "" ?>" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Phone" class="form-label">Phone</label>
                            <?php
                            $pickupPhone = $orderPartyDetails[$pickupRowId]['mobile'] ?? "" ?>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperPhone" name="shipperPhone" value="<?= $pickupPhone ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Email" class="form-label">Email</label>
                            <?php
                            $pickupEmail = $orderPartyDetails[$pickupRowId]['email'] ?? "" ?>
                            <input type="email" form="quickbookForm" class="form-control customerQuickbookFields" id="shipperEmail" name="shipperEmail" value="<?= $pickupEmail ?>">
                        </div>
                    </div>
                </div>

            </form>
        </div>
        <div class="col-lg-6 col-md-12 col-sm-12 pd-right">
            <form>
                <div class="row">
                    <div class="col-md-12">
                        <h1 class="main_title">Delivery</h1>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="consigneeCode" class="form-label">Consignee ID </label>
                            <div class="input-group">
                                <?php
                                $deliveryCode = $orderPartyDetails[$deliveryRowId]['code'] ?? "" ?>
                                <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeCode" name="consigneeCode" value="<?= $deliveryCode ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeRowId" name="consigneeRowId" value="<?= $deliveryRowId ?? 0 ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeLatitude" name="consigneeLatitude" value="<?= $ordersTableData['dlat'] ?? "" ?>">
                                <input type="hidden" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeLongitude" name="consigneeLongitude" value="<?= $ordersTableData['dlng'] ?? "" ?>">
                                <div class="input-group-btn">
                                    <button class="btn btn-outline-secondary" type="button" data-toggle="modal" data-placement="top" onclick="getConsigneeListFromCustomer(1)" title="Search">
                                        <i class="icon tru-icon-search"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="getConsigneeListFromCustomer(0)">
                                        <i class="icon tru-icon-tender-list"></i>
                                    </button>
                                    <button class="btn btn-outline-secondary saveConsigneeData" type="button" data-placement="top" title="Find" data-toggle="modal" onclick="addConsigneeDataFromQuickbook()">
                                        <i class="icon tru-icon-add"></i>
                                    </button>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="row">
                            <div class="col-md-12 col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="companyName" class="form-label">Consignee Name</label>
                                    <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeName" name="consigneeName" value="<?= $ordersTableData['delivery_company'] ?? "" ?>">
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="contactperson" class="form-label">Contact person</label>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="conisneeContactPerson" name="conisneeContactPerson" value="<?= $ordersTableData['delivery_company'] ?? "" ?>">
                        </div>
                    </div>

                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Date" class="form-label">Estimated Delivery Date </label>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields datetimepicker" name="estimatedDeliveryDate" id="estimatedDeliveryDate" value="<?= $ordersTableData['delivery_datetime'] ?? "" ?>"  autocomplete="off">
                        </div>
                    </div>
                    <?php
                    $deliveryCity = $ordersTableData['delivery_city'] ?? "";
                    $deliveryState = $ordersTableData['delivery_address2'] ?? "";
                    $deliveryCountry = $ordersTableData['delivery_country'] ?? "";
                    $deliveryAddress = $deliveryCity . " , " . $deliveryState . " , " . $deliveryCountry;
                    ?>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="findAddress" class="form-label">Consignee Address</label>
                            <input type="text" form="quickbookForm" class="form-control customerQuickbookFields" id="consigneeAddress" name="consigneeAddress" value="<?php
                            if ($orderRowId > 0): echo $deliveryAddress; endif; ?>">
                        </div>
                    </div>
                    <div class="row consigneeAddressLookup" id="consigneeAddressLookup">
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="customerAccount" class="form-label">Country</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields  addressFields country ui-autocomplete-input" id="consigneeCountry" name="consigneeCountry" value="<?= $deliveryCountry ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="Street" class="form-label">Street</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields  consigneeAutocomplete route" id="consigneeStreet" name="consigneeStreet" value="<?= $ordersTableData['delivery_address1'] ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="Suburb" class="form-label">Suburb</label>
                                <input form="quickbookForm" type="text" class="addressFields form-control customerQuickbookFields  sublocality_level_1" id="consigneeSuburb" name="consigneeSuburb" value="<?= $deliveryState ?>"  autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="form-group mb-3">
                                <label for="customerAccount" class="form-label">House Number</label>
                                <input form="quickbookForm" type="text" class="form-control customerQuickbookFields addressFields ui-autocomplete-input" id="consigneeHouseNumber" name="consigneeHouseNumber" value="<?= $consigneeHouseNumber ?? "" ?>" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6 col-sm-12">
                            <div class="row">
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="cityTown" class="form-label">City / Town</label>
                                        <input form="quickbookForm" type="text" class="addressFields form-control locality customerQuickbookFields" id="consigneeCity" name="consigneeCity" value="<?= $deliveryCity ?>" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="postalCode" class="form-label">Postal Code</label>
                                        <input form="quickbookForm" type="text" class="addressFields form-control customerQuickbookFields postal_code" id="consigneePostalCode" name="consigneePostalCode" value="<?= $ordersTableData['delivery_pincode'] ?? "" ?>" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Phone" class="form-label">Phone</label>
                            <?php
                            $deliveryPhone = $orderPartyDetails[$deliveryRowId]['mobile'] ?? "" ?>
                            <input form="quickbookForm" type="text" class="form-control customerQuickbookFields" id="consigneePhone" name="consigneePhone" value="<?= $deliveryPhone ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-12">
                        <div class="form-group mb-3">
                            <label for="Email" class="form-label">Email</label>
                            <?php
                            $deliveryemail = $orderPartyDetails[$deliveryRowId]['email'] ?? "" ?>
                            <input form="quickbookForm" type="email" class="form-control customerQuickbookFields" id="consigneeEmail" name="consigneeEmail" value="<?= $deliveryemail ?>">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- end row -->
    <div class="row additionalServicesCards">
        <div class="col-lg-5 col-md-12 col-sm-12">
            <div class="card-box1 as-minHeightCard  card-box-heading">
                <div class="row">
                    <div class="col-lg-6 borderrightorder">
                        <h2>Order Attributes</h2>
                        <div class="paddingCol1">
                            <div class="referencesBlockCard paddRight">
                                <div class="form-group">
                                    <i class="fa fa-inbox icon_Order" aria-hidden="true"></i>
                                    <select form="quickbookForm" name="orderType" id="orderType" class="form-control customerQuickbookDropDown">
                                        <option value="0">Select Order Type</option>
                                        <?php
                                        $ordersOrderType = $orderDetailsTableData['order_type'] ?? 0;
                                        foreach ($orderTypes as $eachType): ?>
                                            <option <?php
                                            if ($ordersOrderType === $eachType['type_id']) : echo "selected"; endif; ?> value="<?= $eachType['type_id'] ?>"><?= $eachType['type_name'] ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <i class="fa fa-snowflake-o icon_Order" aria-hidden="true"></i>
                                    <select form="quickbookForm" name="service" id="orderService" class="form-control customerQuickbookDropDown">
                                        <option value="0">Select Service</option>
                                        <?php
                                        $ordersService = $orderDetailsTableData['service'] ?? 0;
                                        foreach ($service as $eachType): ?>
                                            <option <?php
                                            if ($ordersService === $eachType['row_id']) : echo "selected"; endif; ?> value="<?= $eachType['row_id'] ?>"><?= $eachType['id'] . "-" . $eachType['name'] ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <i class="icon tru-icon-truck-emp icon_Order" aria-hidden="true"></i>
                                    <select form="quickbookForm" name="modeOfTransport" id="modeOfTransport" class="form-control customerQuickbookDropDown">
                                        <option value="0">Mode Of Transport</option>
                                        <?php
                                        $ordersTransportMode = $ordersTableData['transport_mode'] ?? "";
                                        foreach ($transport as $eachType): ?>
                                            <option <?php
                                            if ($ordersTransportMode === $eachType['code']) : echo "selected"; endif; ?> value="<?= $eachType['code'] ?>"><?= $eachType['name'] ?></option>
                                        <?php
                                        endforeach;
                                        ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <i class="fa fa-comment icon_Order_References" aria-hidden="true"></i>
                                    <textarea form="quickbookForm" id="pickupInstructions" name="pickupInstructions" class="form-control customerQuickbookFields" placeholder="Pickup Instructions"><?= $orderReferences['ORD_PIKINST'] ?? "" ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 pd-References">
                        <h2>References</h2>
                        <div class="paddingCol2">
                            <div class="referencesBlockCard paddLeft">
                                <div class="form-group mb-3">
                                    <i class="fa fa-file-text icon_References" aria-hidden="true"></i>
                                    <label class="form-label">DQ/Customer reference</label>

                                    <input form="quickbookForm" type="text" id="dqNumber" name="dqNumber" class="form-control customerQuickbookFields" placeholder="Value" value="<?= $orderReferences['DQ'] ?? "" ?>">
                                </div>

                                <div class="form-group mb-3">
                                    <i class="fa fa-file-text icon_References" aria-hidden="true"></i>
                                    <label class="form-label">Purchase Order</label>

                                    <input form="quickbookForm" type="text" id="purchaseOrder" name="purchaseOrder" class="form-control customerQuickbookFields" placeholder="Value" value="<?= $orderReferences['PO'] ?? "" ?>">
                                </div>
                                <div class="form-group">
                                    <i class="fa fa-comment icon_Order_References" aria-hidden="true"></i>
                                    <textarea form="quickbookForm" name="deliveryInstructions" id="deliveryInstructions" class="form-control customerQuickbookFields" placeholder="Delivery Instructions"><?= $orderReferences['ORD_DLVINST'] ?? "" ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <?php
        if (in_array('Show Services', $switches, true)):
            ?>
            <div class="col-lg-3 col-md-12 col-sm-12">
                <div class="card-box1 as-minHeightCard card-box-heading">
                    <h2>Additional Services</h2>
                    <div class="paddingCol">
                        <?php
                        foreach ($vasMasterData as $eachLine): ?>
                            <div class="">
                                <label><input form="quickbookForm" type="checkbox" class="vasData" name="vasData[]" id="vasData" value=" <?= $eachLine['rowId'] ?>" <?php
                                    if (in_array($eachLine['rowId'], $orderAddons, true)) : echo "checked"; endif; ?> > <?= $eachLine['vasId'] . " - " . $eachLine['vasName'] ?></label>
                            </div>
                        <?php
                        endforeach;
                        ?>
                    </div>
                </div>
            </div>
        <?php
        endif; ?>
        <?php
        if (in_array('Show Quotes', $switches, true)):
            $emptyChargesStyle = "height: 175px;overflow: auto";
            $chargesDataStyle = "display: none;height: 175px;overflow: auto";
            if (!empty($orderCharges)):
                $emptyChargesStyle = "display: none;height: 175px;overflow: auto";
                $chargesDataStyle = "height: 175px;overflow: auto";
            endif;
            ?>
            <div class="col-lg-4 col-md-12 col-sm-12">
                <div class="card-box1 as-minHeightCard  card-box-heading">
                    <h2> Charges</h2>
                    <div class="table-responsive quickbookTables" id="orderChargesTableDivTag" style="<?= $chargesDataStyle ?>">
                        <table class="table additionalServicesTable">
                            <thead>
                            <tr>
                                <th>Rate ID</th>
                                <th>Vas ID</th>
                                <th>Charge ID</th>
                                <th>Amount</th>
                            </tr>
                            </thead>
                            <tbody id="chargesBodyTable">
                            <?php
                            foreach ($orderCharges as $eachChargeLine): ?>
                                <tr>
                                    <td><?= $eachChargeLine['rate_id'] ?></td>
                                    <td></td>
                                    <td><?= $eachChargeLine['charge_code'] ?></td>
                                    <td><?= round($eachChargeLine['amount'], 2) . " " . $eachChargeLine['currency'] ?></td>
                                </tr>
                            <?php
                            endforeach;
                            ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="table-responsive quickbookTables" id="emptyChargesTableDivTag" style="<?= $emptyChargesStyle ?>">
                        <table class="table additionalServicesTable">
                            <thead>
                            <tr>
                                <th>Rate ID</th>
                                <th>Vas ID</th>
                                <th>Charge ID</th>
                                <th>Amount</th>
                            </tr>
                            </thead>
                            <tbody class="text-center">
                            <tr>
                                <td colspan="4"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                    <p>No Data Available</p>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php
        endif; ?>
        <?php
        if (!in_array('Show Quotes', $switches, true) && !in_array('Show Services', $switches, true)) : ?>
            <div class="col-lg-7 col-md-12 col-sm-12" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Services And Show Quote Switches Disabled.</p>
            </div>
        <?php
        endif; ?>
        <?php
        if (!in_array('Show Quotes', $switches, true) && in_array('Show Services', $switches, true)) : ?>
            <div class="card-box1 as-minHeightCard  card-box-heading" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Quote Switch is Disabled.</p>
            </div>
        <?php
        endif; ?>

        <?php
        if (in_array('Show Quotes', $switches, true) && !in_array('Show Services', $switches, true)) : ?>
            <div class="card-box1 as-minHeightCard  card-box-heading" style="text-align: center">
                <img src="<?= base_url() ?>assets/images/no-charges-icon.svg" width="275px" height="200px">
                <p>Show Services Switch is Disabled.</p>
            </div>
        <?php
        endif; ?>
    </div>


    <!-- end bgGrey -->
    <div class="row cargoDetails_main">

        <div class="col-md-8">
            <div class="borderLine">
                <div class="bgGrey mb-15 mt-15">
                    <div class="row ">
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <h2 class="main_title">Cargo Details</h2>
                        </div>
                    </div>
                </div>
                <?php
                $cargosMasterData = $quickbookData['cargosMasterData'] ?? []; ?>
                <form method="POST" action="<?= base_url() ?>svkCustomer/CustomerOrders/saveQuickbookCargoDetails" id="saveCargoDetails">
                    <div class="row pd-10">
                        <div class="col-lg-10 col-md-12 col-sm-12">
                            <div class="row">
                                <div class="col-lg-1 col-md-12 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="Items" class="form-label">Item</label>
                                        <input type="hidden" name="cargoOrderRowId" form="saveCargoDetails" id="cargoOrderRowId" value="<?= $orderRowId ?? 0 ?>">
                                        <select form="saveCargoDetails" class="form-control cargoDetailsDropdown customerQuickbookDropDown" name="itemId" id="itemId" onchange="getCargoMasterData()">
                                            <option value="0">Select Item</option>
                                            <?php
                                            foreach ($cargosMasterData as $eachCargo): ?>
                                                <option value="<?= $eachCargo['itemRowId'] ?>"><?= $eachCargo['itemId'] ?></option>
                                            <?php
                                            endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="packageType" class="form-label">Package Type</label>
                                        <input type="hidden" id="cargoType" class="customerQuickbookFields" name="cargoType" form="saveCargoDetails" value="0">
                                        <input type="hidden" id="cargoRowId" class="cargoDetailsFields customerQuickbookFields" name="cargoRowId" form="saveCargoDetails" value="">
                                        <select name="packageType" form="saveCargoDetails" id="packageType" class="cargoDetailsDropdown form-control customerQuickbookDropDown">
                                            <option value="0">Select Package Type</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="goodsDescription" class="form-label"> Goods Desc. </label>
                                        <input form="saveCargoDetails" type="text" name="goodsDescription" class="form-control customerQuickbookFields cargoDetailsFields" id="goodsDescription">
                                    </div>
                                </div>
                                <div class="col-lg-1 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="Quantity" class="form-label"> Qty </label>
                                        <input form="saveCargoDetails" onblur="changeByDimensions()" type="number" min="1" name="quantity" class="form-control customerQuickbookFields cargoDetailsFields" id="quantity">
                                    </div>
                                </div>
                                <div class="col-lg-1 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="Weight" class="form-label">Wt(Kgs)</label>
                                        <input form="saveCargoDetails" type="text" class="form-control cargoDetailsFields customerQuickbookFields" name="weight" id="weight">
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-12 col-sm-12 ">
                                    <div class="row">
                                        <div class="col-md-12 col-sm-12">
                                            <div class="form-group mb-3">
                                                <label for="length" class="form-label">Dimensions (cm) per
                                                    unit</label>
                                                <div class="row">
                                                    <div class="col-lg-3 col-md-6 col-sm-12">
                                                        <input form="saveCargoDetails" type="text" class="cargoDetailsFields form-control customerQuickbookFields" name="length" id="length" onblur="changeByDimensions()" placeholder="L">
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                                        <input form="saveCargoDetails" type="text" class="cargoDetailsFields form-control customerQuickbookFields" name="width" id="width" onblur="changeByDimensions()" placeholder="W">
                                                    </div>
                                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                                        <input form="saveCargoDetails" type="text" class="cargoDetailsFields form-control customerQuickbookFields" id="height" name="height" onblur="changeByDimensions()" placeholder="H">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <label for="volume" class="form-label">Actual Vol(cbm)</label>
                                        <input form="saveCargoDetails" type="text" class="form-control cargoDetailsFields customerQuickbookFields" name="volume" id="volume">
                                        <input form="saveCargoDetails" type="hidden" class="form-control customerQuickbookFields" name="orderDgGoodsRow" id="orderDgGoodsRow">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="col-lg-2 col-md-12 col-sm-12">
                            <div class="row">

                                <div class="col-lg-8 col-md-6 col-sm-12">

                                    <div class="form-group mb-3">
                                        <label for="DGType" class="form-label">Cargo Type</label>
                                        <div class="dropdown">
                                            <button class="btn btn-default dropdown-toggle" type="button"
                                                    id="dropdownMenu1" data-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="true">
                                                Select CargoType
                                            </button>
                                            <ul class="dropdown-menu checkbox-menu allow-focus" aria-labelledby="dropdownMenu1">

                                                <li>
                                                    <label>
                                                        <input type="checkbox" class="cargoCheckBoxes" form="saveCargoDetails" name="cargoStackable" id="cargoStackable" value="1"> Stackable
                                                    </label>
                                                </li>

                                                <li>
                                                    <label>
                                                        <input type="checkbox" class="cargoCheckBoxes" form="saveCargoDetails" name="cargoGrounded" id="cargoGrounded" value="1"> Grounded
                                                    </label>
                                                </li>

                                                <li>
                                                    <label>
                                                        <input type="checkbox" class="cargoCheckBoxes" form="saveCargoDetails" name="cargoSplittable" id="cargoSplittable" value="1"> Splittable
                                                    </label>
                                                </li>
                                                <?php
                                                if (in_array('DG Cargo Allowed', $switches, true)): ?>
                                                    <li>
                                                        <label>
                                                            <input class="cargoCheckBoxes cargoDg" form="saveCargoDetails" type="checkbox" value="1" name="cargoDg" id="cargoDg" onclick="displayDgModal()"> <span class="myModal_dggoods">DG Goods</span>
                                                        </label>
                                                    </li>
                                                <?php
                                                endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group mb-3">
                                        <button type="button" class="btn btn-primary adddetails" onclick="addCargoDetails()"><i class="fa fa-plus"></i></button>
                                    </div>
                                </div>


                            </div>

                        </div>


                    </div>
                    <br>
                    <?php
                    $emptyCargosStyle = "";
                    $cargosDataStyle = "display: none;";
                    if (!empty($orderCargos)):
                        $emptyCargosStyle = "display: none";
                        $cargosDataStyle = "";
                    endif;
                    ?>
                    <div class="row cargoDetails_table" id="orderCargosTableDivTag" style="<?= $cargosDataStyle ?>">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="table-responsive quickbookTables">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th>Item</th>
                                        <th>Package Type</th>
                                        <th>Goods Description</th>
                                        <th>Quantity</th>
                                        <th>Weight (Kg)</th>
                                        <th>Actual Volume (cbm)</th>
                                        <th>Dimensions (cm)</th>
                                    </tr>
                                    </thead>
                                    <tbody id="orderCargoTableBody">
                                    <?php
                                    foreach ($orderCargos as $eachCargo):
                                        $length = $eachCargo['length'] > 0 ? $eachCargo['length'] : " ";
                                        $width = $eachCargo['width'] > 0 ? $eachCargo['width'] : " ";
                                        $height = $eachCargo['height'] > 0 ? $eachCargo['height'] : " ";
                                        ?>
                                        <tr class="cargoRow_<?= $eachCargo['cargoRowId'] ?> newCargos">
                                            <td>
                                                <ul class="nav nav-tabs">
                                                    <li class="dropdown tablebtnrleft"><a class="dropdown-toggle" style="border: none;" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a>
                                                        <ul class="dropdown-menu icondropdown" style="padding: 0;left: 0" role="menu">
                                                            <li><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="editCargoDetails(this,<?= $eachCargo['cargoRowId'] ?>,<?= $eachCargo['itemRowId'] ?>);"><span class="glyphicon glyphicon-pencil"></span>Edit</a></li>
                                                            <li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="deleteCargoDetailsRow(this,<?= $eachCargo['cargoRowId'] ?>);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </td>
                                            <td><?= $eachCargo['quantityType'] ?></td>
                                            <td><?= $eachCargo['handlingUnit'] ?></td>
                                            <td><?= $eachCargo['cargoContent'] ?></td>
                                            <td><?= $eachCargo['quantity'] ?></td>
                                            <td><?= round($eachCargo['weight'],2) ?></td>
                                            <td><?= round($eachCargo['volume'],2) ?>
                                                <span class="cargoCheckBoxValues" id="cargoStackableValue_<?= $eachCargo['cargoRowId'] ?>">_<?= $eachCargo['stackable'] > 0 ? 'true' : 'false' ?></span>
                                                <span class="cargoCheckBoxValues" id="cargoGroundedValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['grounded'] > 0 ? 'true' : 'false' ?></span>
                                                <span class="cargoCheckBoxValues" id="cargoSplittableValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['splittable'] > 0 ? 'true' : 'false' ?></span>
                                                <span class="cargoCheckBoxValues" id="cargoDgValue_<?= $eachCargo['cargoRowId'] ?>"><?= $eachCargo['dgGoods'] > 0 ? 'true' : 'false' ?></span>
                                            </td>
                                            <?php
                                            if ($length == " " && $width == " " && $height == " "): ?>
                                                <td></td>
                                            <?php
                                            else : ?>
                                                <td><?= $length . " x " . $width . " x " . $height ?></td>
                                            <?php
                                            endif; ?>
                                        </tr>
                                    <?php
                                    endforeach;
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                    <!-- end cargo Details table -->
                    <div class="row cargoDetails_table" id="emptyCargoTableDivTag" style="<?= $emptyCargosStyle ?>">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="table-responsive quickbookTables">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th>Item</th>
                                        <th>Package Type</th>
                                        <th>Goods Description</th>
                                        <th>Quantity</th>
                                        <th>Weight (Kg)</th>
                                        <th>Actual Volume (cbm)</th>
                                        <th>Dimensions (m)</th>
                                    </tr>
                                    </thead>
                                    <tbody class="text-center">
                                    <tr>
                                        <td colspan="6"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                            <p>No Data Available</p>
                                        </td>

                                    </tr>


                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                    <!-- end cargo Details table -->
                </form>
            </div>
        </div>
        <div class="col-md-4 ">
            <div class="borderLine">

                <div class="bgGrey mb-15 mt-15">
                    <div class="row ">
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <h2 class="main_title">Documents</h2>
                        </div>
                    </div>
                </div>
                <?php
                $emptyDocumentStyle = "";
                $documentDataStyle = "display: none";
                if (!empty($orderDocuments)):
                    $emptyDocumentStyle = "display: none";
                    $documentDataStyle = "";
                endif;
                ?>
                <div class="row pd-101">
                    <div class="col-lg-12 col-md-12 col-sm-12" id="orderPodUploadsTableDivTag" style="<?= $documentDataStyle ?>">
                        <div class="table-responsive quickbookTables">
                            <table class="table documents_main">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>Document Type</th>
                                    <th>Document Name</th>
                                    <th>Date</th>
                                </tr>
                                </thead>
                                <tbody id="orderPodUploadsTableBody">
                                <?php
                                foreach ($orderDocuments as $eachRow): ?>
                                    <tr>
                                        <td><input type='checkbox' form='quickbookForm' name='podUploadRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='podUploadRowIds_<?= $eachRow['rowId'] ?>' value='<?= $eachRow['rowId'] ?>' style='display: none;'>
                                            <ul class="nav nav-tabs">
                                                <li class="dropdown tablebtnrleft"><a class="dropdown-toggle" style="border: none;" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a>
                                                    <ul class="dropdown-menu icondropdown" style="padding: 0;left: 0" role="menu">
                                                        <li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="deletePodUploadedRow(this,<?= $eachRow['rowId'] ?>);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </td>
                                        <td><?= $eachRow['typeName'] ?></td>
                                        <td><?= $eachRow['path'] ?></td>
                                        <td><?= Date('Y-m-d', strtotime($eachRow['date'])) ?></td>
                                    </tr>
                                <?php
                                endforeach;
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12" id="emptyPodUploadsDivTag" style="<?= $emptyDocumentStyle ?>">
                        <div class="table-responsive quickbookTables">
                            <table class="table documents_main">
                                <thead>
                                <tr>
                                    <th></th>
                                    <th>Document Type</th>
                                    <th>Document Name</th>
                                    <th>Date</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td colspan="4" align="center"><img src="<?= base_url() ?>/assets/svkCustomer/images/nodata.png">
                                        <p>No Data Available</p>
                                    </td>

                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12 text-right">
                        <button type="button" class="btn btn-primary adddetails myModal_documents" onclick="displayDocumentsModal()"><i class="fa fa-plus"></i></button>
                    </div>

                </div>
            </div>
            <!-- Modal -->
            <div id="addDocuments" class="addDocuments documentsModal_main" style="display:none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close documentsModal_mainClose" onclick="closeDocumentsModalPopup()">&times;</button>
                            <h4 class="modal-title">Add Document </h4>
                        </div>
                        <div class="modal-body">
                            <form method="POST" action="" enctype="multipart/form-data" id="saveUploadedData">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <div class="form-group  mb-3">
                                            <label class="form-label">Documents Type</label>
                                            <input type="hidden" name="documentOrderRowId" form="saveUploadedData" id="documentRowId" value="<?= $orderRowId ?? 0 ?>">
                                            <input type="hidden" name="shiftRowId" form="saveUploadedData" id="shiftRowId" value="<?= $ordersTableData['shift_id'] ?? 0 ?>">
                                            <input type="hidden" name="tripRowId" form="saveUploadedData" id="tripRowId" value="<?= $ordersTableData['trip_id'] ?? 0 ?>">
                                            <select form="saveUploadedData" placeholder="Type" class="form-control customerQuickbookDropDown podUploadDropdown" id="documentType" name="documentType" required="">
                                                <option class="text-light" value="0">Select Documents Type</option>
                                                <?php
                                                foreach ($documentTypes as $eachType): ?>
                                                    <option value="<?= $eachType['rowId'] ?>"><?= $eachType['typeName'] ?></option>
                                                <?php
                                                endforeach;
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group  mb-3">
                                            <label class="form-label">Stop</label>
                                            <select placeholder="Select Stop" form="saveUploadedData" class="form-control customerQuickbookFields podUploadFields" name="stopId">
                                                <option class="text-light" value="0">Select Stop</option>
                                                <?php
                                                foreach ($orderStops as $eachStop): ?>
                                                    <option value="<?= $eachStop['id'] ?>"><?= $eachStop['stopname'] ?></option>
                                                <?php
                                                endforeach;
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group  mb-3">
                                            <label class="form-label">Documents Upload</label>
                                            <input form="saveUploadedData" type="file" placeholder="DOC" class="podUploadFields customerQuickbookFields form-control" name="fileName" id="fileName">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary documentsModal_mainClose" onclick="closeDocumentsModalPopup()">Close</button>
                            <button type="button" class="btn btn-secondary getQuote_btn" onclick="addUploadedDocument()" data-number="addDocumentsClose">DOC Upload</button>
                        </div>
                    </div>

                </div>
            </div>


        </div>
        <!-- end cargo Details -->
        <!-- Modal -->
        <div class="dgModal_main custModal" style="display: none">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close dgModal_mainClose" onclick="closeDgModalPopup()">&times;</button>
                        <h4 class="modal-title">Dg Goods </h4>
                    </div>
                    <div class="modal-body">
                        <div class="dg_goods_pd">
                            <form method="POST" action="<?= base_url() ?>svkCustomer/CustomerOrders/saveDangerousGoodsForCargo" id="saveDangerousGoods">
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group  mb-3">
                                            <label class="form-label">UN Code</label>
                                            <div class="input-group">
                                                <input type="hidden" form="saveDangerousGoods" name="dgorderRowId" id="dgorderRowId" value="<?= $orderRowId ?>">
                                                <input type="text" form="saveDangerousGoods" name="dgUnCode" id="dgUnCode" class="form-control dgPopupFields" readonly>
                                                <div onclick="displayDgUncodeModal()" class="myModal_lookup input-group-addon" style="cursor:pointer;"><span class="icon  tru-icon-action-setting"></span></div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Name</label>
                                            <input type="text" form="saveDangerousGoods" name="dgUnCodeName" id="dgUnCodeName" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Class</label>
                                            <input type="text" form="saveDangerousGoods" name="dgUnCodeClass" id="dgUnCodeClass" class="form-control dgPopupFields">
                                            <input type="hidden" form="saveDangerousGoods" name="dgRowId" id="dgRowId" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Packing Group</label>
                                            <input type="text" form="saveDangerousGoods" id="dgUnCodePackingGroup" name="dgUnCodePackingGroup" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">N.O.S</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNos" id="dgNos" class="form-control dgPopupFields">
                                            <input type="hidden" form="saveDangerousGoods" name="dgAdrMultiplicator" id="dgAdrMultiplicator" class="form-control dgPopupFields">
                                            <input type="hidden" form="saveDangerousGoods" name="dgTransportCategory" id="dgTransportCategory" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Tunnel Code</label>
                                            <input type="text" form="saveDangerousGoods" name="dgTunnelCode" id="dgTunnelCode" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Number of Packages</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNoOfPackages" id="dgNoOfPackages" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Package Type</label>
                                            <input type="text" form="saveDangerousGoods" name="dgPackageType" id="dgPackageType" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Gross Weight (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgGrossWeight" id="dgGrossWeight" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Net Weight (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNetWeight" id="dgNetWeight" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Net Explosive Mass (kg)</label>
                                            <input type="text" form="saveDangerousGoods" name="dgNetExplosiveMass" id="dgNetExplosiveMass" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Liters</label>
                                            <input type="text" form="saveDangerousGoods" name="dgLiters" id="dgLiters" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Limited Quantity</label>
                                            <input type="text" form="saveDangerousGoods" name="dgLimitedQuantity" id="dgLimitedQuantity" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Expected Quantity</label>
                                            <input type="text" form="saveDangerousGoods" name="dgExpectedQuantity" id="dgExpectedQuantity" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Environmentally</label>
                                            <input type="text" form="saveDangerousGoods" name="dgEnvironmentally" id="dgEnvironmentally" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Fireworks Information</label>
                                            <input type="text" form="saveDangerousGoods" name="dgFireworks" id="dgFireworks" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Technical Name</label>
                                            <input type="text" form="saveDangerousGoods" name="dgTechinalName" id="dgTechinalName" class="form-control dgPopupFields">
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary dgModal_mainClose" onclick="closeDgModalPopup()">Cancel</button>
                        <button type="button" class="btn btn-secondary getQuote_btn submitDg" onclick="AddDgGoodsToCargo()">Submit</button>
                    </div>
                </div>

            </div>
        </div>
        <!--Modal-->
        <div class="lookup_main custModal" style="display:none;">
            <div class="modal-dialog">
                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close lookup_mainClose" onclick="closeLookupMainPopup()">&times;</button>
                        <h4 class="modal-title">UN Code Search</h4>
                    </div>
                    <div class="modal-body">
                        <div class="dg_goods_pd">
                            <div class="table-responsive quickbookTables">
                                <table class="table" id="UnCodeDataTable">
                                    <thead>
                                    <tr>
                                        <th></th>
                                        <th>UN Code</th>
                                        <th>Name</th>
                                        <th>Class</th>
                                        <th>Packing Group</th>
                                        <th>Main Risk</th>
                                        <th>Sub Label 1</th>
                                        <th>Sub Label 2</th>
                                        <th>Sub Label 3</th>
                                        <th>Sub Label 4</th>
                                        <th>Classification Code</th>
                                        <th>N.O.S</th>
                                        <th>Tunnel Code</th>
                                    </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary lookup_mainClose" data-number="shipper_modalList1" onclick="closeLookupMainPopup()">Close</button>
                        <button type="button" class="btn btn-secondary getQuote_btn partyTypeSelectButton" onclick="displaySelectedUncodeDetails()">Select</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="row cargoDetails_btns">
            <div class="col-md-12 text-right">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                <?php
                if ($orderRowId > 0): ?>
                    <button type="button" class="btn btn-primary" onclick="editOrderInPopupPage(<?= $orderRowId ?>,'<?= $bookingId ?>')">Reset</button>
                <?php
                else: ?>
                    <button type="button" class="btn btn-primary" onclick="removeAllInputValues()">Reset</button>
                <?php
                endif; ?>

                <button type="submit" form="quickbookForm" class="btn btn-primary submitorderdetails">Save</button>
                <?php
                if (in_array('Show Quotes', $switches, true)):
                    if (in_array('Show All Rates', $switches, true)): ?>
                        <input type="hidden" id="showAllRates" name="showAllRates" form="quickbookForm" value="1">
                        <input type="hidden" id="rateCustomerProfileId" class="customerQuickbookDropDown" name="rateCustomerProfileId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateLaneRowId" class="customerQuickbookDropDown" name="rateLaneRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateServiceRowId" class="customerQuickbookDropDown" name="rateServiceRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateOfferingRowId" class="customerQuickbookDropDown" name="rateOfferingRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="rateRecordRowId" class="customerQuickbookDropDown" name="rateRecordRowId" form="quickbookForm" value="0">
                        <input type="hidden" id="sessionCurrency" name="sessionCurrency" form="quickbookForm" value="<?= $sessionCurrency ?? '' ?>">
                    <?php
                    endif; ?>
                    <button type="button" class="btn btn-secondary getQuote_btn scrollTop getQuoteButton" id="scrollTop" data-toggle="modal" onclick="GetLeastSellRate()">Get Quote<i class="fa fa-angle-right" aria-hidden="true"></i></button>
                <?php
                endif; ?>
            </div>


        </div>
        <!-- end cargo Details table -->
        <!-- Modal -->
        <div class="modal fade quoteModel custModal" id="quote_ModalMain" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">

                        <button type="button" class="close" data-number="Quote_modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-2 col-md-12 col-sm-12">
                                <div class="iconBox-1">
                                    <img src="<?= base_url() ?>assets/svkCustomer/images/thank.svg">
                                </div>
                            </div>
                            <div class="col-lg-10 col-md-12 col-sm-12">
                                <div class="row">
                                    <div class="col-md-12 col-sm-12">
                                        <h2>Thank you for your order</h2>
                                        <p>An email confirmation has been sent to <a href="mailto:edla.m@gmail.com">edla.m@gmail.com</a></p>
                                        <h3>Order Number : <span>KN00123456</span></h3>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-8 col-md-12 col-sm-12">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-12 col-sm-12">
                                                <div class="colum_pop">

                                                    <p>Pickup address</p>
                                                    <p><span>Bukit Brown Cemetery</span></p>
                                                    <p>KNAKAL Transport - Road</p>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12 col-sm-12">
                                                <div class="colum_pop">

                                                    <p>Delivery address</p>
                                                    <p><span>Bukit Brown Cemetery</span></p>
                                                    <p>KNAKAL Transport - Road</p>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4  col-md-12 col-sm-12">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-12 col-sm-12">
                                                <div class="colum_pop">

                                                    <p>Weight</p>
                                                    <p><span>20276.000KG</span></p>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-12 col-sm-12">
                                                <div class="colum_pop">
                                                    <p>Volume</p>
                                                    <p><span>49.450CBM</span></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <h1>Total Charge Amount : <span>1200.00 USD</span></h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-number="Quote_modal">Cancel</button>
                        <button type="button" class="btn btn-secondary getQuote_btn">Confirm</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script>

    $(document).ready(function () {
        var autocompletesWraps = ['shipperAddressLookup'];
        createGeoListeners(autocompletesWraps,'autocomplete');
        var consigneeAutocompletesWraps = ['consigneeAddressLookup'];
        createGeoListeners(consigneeAutocompletesWraps,'consigneeAutocomplete');
    });

    function createGeoListeners(autocompletesWraps,className) {
        var options = {types: ['geocode']};
        var inputs = $('.' + className);
        var autocompletes = [];
        for (let i = 0; i < inputs.length; i++) {
            var autocomplete = new google.maps.places.Autocomplete(inputs[i], options);
            autocomplete.inputId = inputs[i].id;
            autocomplete.parentDiv = autocompletesWraps[i];
            autocomplete.addListener('place_changed', fillInAddressFields);
            autocompletes.push(autocomplete);
        }
    }

    function fillInAddressFields() {
       // $('.addressFields').val("");
        $('.googleerror').removeClass('is-valid is-invalid');
        var place = this.getPlace();
        var suburb_flag = false;
        console.log('place');
        console.log(place);
        for (var i = 0; i < place.address_components.length; i++) {
            var addressType = place.address_components[i].types[0];
            var val = place.address_components[i].long_name;
            console.log("address Type " + addressType + " val " + val + " pd " + this.parentDiv);
            if (addressType == 'street_number') {
                var street_number_val = place.address_components[i].long_name;
            }
            if (addressType == 'route') {
                if (street_number_val == 'undefined' || street_number_val == '' || street_number_val == null) {
                    var val = place.address_components[i].long_name;
                } else {
                    var val = street_number_val + " " + place.address_components[i].long_name;
                }
            }
            if (addressType == 'sublocality_level_1') {
                var suburb_flag = true;
            }
            $('#' + this.parentDiv).find("." + addressType).val(val);
            $('#' + this.parentDiv).find("." + addressType).attr('disabled', false);
        }
        if (!suburb_flag) {
            for (var i = 0; i < place.address_components.length; i++) {
                var addressType = place.address_components[i].types[0];
                var val = place.address_components[i].long_name;
                if (addressType == 'locality') {
                    var addressType = 'sublocality_level_1';
                    $('#' + this.parentDiv).find("." + addressType).val(val);
                    $('#' + this.parentDiv).find("." + addressType).attr('disabled', false);
                }
            }
        }
    }

    $(".datetimepicker").datetimepicker({
        format: "Y-m-d H:i:s",
        /* minDate : 0,
         minTime: 0,*/
        autoclose: true,
    });

    function getCargoMasterData() {
        const itemId = $('#itemId').val();
        if (itemId > 0) {
            let itemMasterData = <?php echo json_encode($cargosMasterData); ?>;
            const selectedCargoDetails = itemMasterData[itemId];
            const itemName = selectedCargoDetails.itemName;
            let option = "<option value='0'>Select</option>";
            option += "<option value='" + itemName + "'>" + itemName + "</option>";
            $('#packageType').html(option);
            const cargoType = selectedCargoDetails.itemId;
            $('#cargoType').val(cargoType);
            $('#packageType option[value="' + itemName + '"]').prop("selected", true);
        }
    }

    function editCargoDetails(but, rowId, itemRowId) {
        const $row = $(but).closest('tr');
        const packageType = $row.find("td:eq(2)").text().trim();
        const goodsDescription = $row.find("td:eq(3)").text().trim();
        const quantity = $row.find("td:eq(4)").text().trim();
        const weight = $row.find("td:eq(5)").text().trim();
        const volumeTag = $row.find("td:eq(6)").text().trim();
        const volumeArray = volumeTag.split('_');
        const volume = volumeArray[0];
        const dimensions = $row.find("td:eq(7)").text().trim();
        const dimensionsArray = dimensions.split('x');
        const length = dimensionsArray[0];
        const width = dimensionsArray[1];
        const height = dimensionsArray[2];

        $('#itemId option[value="' + itemRowId + '"]').prop("selected", true);
        let itemMasterData = <?php echo json_encode($cargosMasterData); ?>;
        const selectedCargoDetails = itemMasterData[itemRowId];
        const itemName = selectedCargoDetails.itemName;
        let option = "<option value='0'>Select</option>";
        option += "<option value='" + itemName + "'>" + itemName + "</option>";
        $('#packageType').html(option);
        $('#packageType option[value="' + packageType + '"]').prop("selected", true);
        const cargoType = $('#itemId').find(":selected").text();
        $('#cargoType').val(cargoType);
        $('#quantity').val(quantity);
        $('#weight').val(weight);
        $('#volume').val(volume);
        $('#length').val(length);
        $('#width').val(width);
        $('#height').val(height);
        $('#goodsDescription').val(goodsDescription);
        $('#cargoRowId').val(rowId);
        const totalVolume = parseFloat($('#totalVolumeInput').val()) - parseFloat(volume);
        $('#totalVolumeInput').val(totalVolume);
        const totalQuantity = parseFloat($('#totalQuantityInput').val()) - parseFloat(quantity);
        $('#totalQuantityInput').val(totalQuantity);
        const totalWeight = parseFloat($('#totalWeightInput').val()) - parseFloat(weight);
        $('#totalWeightInput').val(totalWeight);
        if ($('#cargoStackableValue_' + rowId).text() == "_true") {
            $('#cargoStackable').prop('checked', true);
        }
        if ($('#cargoGroundedValue_' + rowId).text() == "true") {
            $('#cargoGrounded').prop('checked', true);
        }
        if ($('#cargoSplittableValue_' + rowId).text() == "true") {
            $('#cargoSplittable').prop('checked', true);
        }
        if ($('#cargoDgValue_' + rowId).text() == "true") {
            const dgRowId = $('#dgWithCargo_' + rowId).val();
            $('#orderDgGoodsRow').val(dgRowId);
            $('#cargoDg').prop('checked', true);
            $('#dgRowId').val($('#dgRowIds' + dgRowId).val());
            $('#dgUnCode').val($('#dgRowIds' + dgRowId).attr('data-unCode'));
            $('#dgUnCodeName').val($('#dgRowIds' + dgRowId).attr('data-unCodeName'));
            $('#dgUnCodeClass').val($('#dgRowIds' + dgRowId).attr('data-unCodeClass'));
            $('#dgUnCodePackingGroup').val($('#dgRowIds' + dgRowId).attr('data-packagingGroup'));
            $('#dgNos').val($('#dgRowIds' + dgRowId).attr('data-nos'));
            $('#dgTunnelCode').val($('#dgRowIds' + dgRowId).attr('data-tunnelCode'));
            $('#dgNoOfPackages').val($('#dgRowIds' + dgRowId).attr('data-packages'));
            $('#dgPackageType').val($('#dgRowIds' + dgRowId).attr('data-packageType'));
            $('#dgGrossWeight').val($('#dgRowIds' + dgRowId).attr('data-gorssWeight'));
            $('#dgNetWeight').val($('#dgRowIds' + dgRowId).attr('data-netWeight'));
            $('#dgNetExplosiveMass').val($('#dgRowIds' + dgRowId).attr('data-explosiveMass'));
            $('#dgLiters').val($('#dgRowIds' + dgRowId).attr('data-liters'));
            $('#dgLimitedQuantity').val($('#dgRowIds' + dgRowId).attr('data-ltdQuantity'));
            $('#dgExpectedQuantity').val($('#dgRowIds' + dgRowId).attr('data-expQuantity'));
            $('#dgEnvironmentally').val($('#dgRowIds' + dgRowId).attr('data-environmentally'));
            $('#dgTechinalName').val($('#dgRowIds' + dgRowId).attr('data-techinalName'));
            $('#dgFireworks').val($('#dgRowIds' + dgRowId).attr('data-fireWorks'));
        }
    }

    $('#consigneeCode').autocomplete({
        source: function (request, response) {
            const partyTypes = ['Consignee', 'Delivery'];
            if (request.term.length > 4) {
                $.ajax({
                    url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypesListFromCustomerLogin',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        shipperCode: request.term,
                        type: partyTypes
                    },
                    success: function (data) {
                        if (data.length > '0') {
                            response($.map(data, function (item) {
                                    return {id: item.id, value: item.code};
                                })
                            );
                        }
                    }
                });
            }
        }, select: function (event, ui) {
            $(this).val(ui.item.label);
            const id = ui.item.id;
            $.ajax({
                url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypeFromRowId',
                type: 'post',
                data: {'rowId': id, 'partyType': 'Consignee'},
                dataType: 'json',
                success: function (response) {
                    $('#consigneeCode').val(response[0].code);
                    $('#consigneeName').val(response[0].name);
                    $('#conisneeContactPerson').val(response[0].name);
                    $('#consigneeAddress').val(response[0].city + ',' + response[0].state + ',' + response[0].country);
                    $('#consigneeStreet').val(response[0].street);
                    $('#consigneeSuburb').val(response[0].state);
                    $('#consigneeCity').val(response[0].city);
                    $('#consigneePostalCode').val(response[0].pincode);
                    $('#consigneePhone').val(response[0].mobile);
                    $('#consigneeEmail').val(response[0].email);
                    $('#consigneeRowId').val(response[0].id);
                    $('#consigneeLatitude').val(response[0].latitude);
                    $('#consigneeLongitude').val(response[0].longitude);
                    $('#consigneeCountry').val(response[0].country);
                    $('#consigneeNameInfo').html(response[0].name);
                    $('#consigneeAddressInfo').html(response[0].city + ' - ' + response[0].country);
                }
            });
            var shipperCode = $('#shipperCode').val();
            var consigneeCode = $('#consigneeCode').val();
            if (shipperCode != "" && consigneeCode != "") {
                getDistanceBetweenLocations();
            }
            return false;
        } , appendTo: $('#quickbook_popup')
    });
    $('#shipperCode').autocomplete({
        source: function (request, response) {
            const partyTypes = ['Shipper', 'Pickup'];
            if (request.term.length > 4) {
                $.ajax({
                    url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypesListFromCustomerLogin',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        shipperCode: request.term,
                        type: partyTypes
                    },
                    success: function (data) {
                        if (data.length > '0') {
                            response($.map(data, function (item) {
                                    return {id: item.id, value: item.code};
                                })
                            );
                        }
                    }
                });
            }
        }, select: function (event, ui) {
            $(this).val(ui.item.label);
            const id = ui.item.id;
            $.ajax({
                url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypeFromRowId',
                type: 'post',
                data: {'rowId': id, 'partyType': 'Shipper'},
                dataType: 'json',
                success: function (response) {
                    $('#shipperCode').val(response[0].code);
                    $('#shipperName').val(response[0].name);
                    $('#shipperContactperson').val(response[0].name);
                    $('#shipperAddress').val(response[0].city + ',' + response[0].state + ',' + response[0].country);
                    $('#shipperStreet').val(response[0].street);
                    $('#shipperSuburb').val(response[0].state);
                    $('#shipperCity').val(response[0].city);
                    $('#shipperPostalCode').val(response[0].pincode);
                    $('#shipperPhone').val(response[0].mobile);
                    $('#shipperEmail').val(response[0].email);
                    $('#shipperRowId').val(response[0].id);
                    $('#shipperLatitude').val(response[0].latitude);
                    $('#shipperLongitude').val(response[0].longitude);
                    $('#shipperCountry').val(response[0].country);
                    $('#shipperNameInfo').html(response[0].name);
                    $('#shipperAddressInfo').html(response[0].city + ' - ' + response[0].country);
                }
            });
            var shipperCode = $('#shipperCode').val();
            var consigneeCode = $('#consigneeCode').val();
            if (shipperCode != "" && consigneeCode != "") {
                getDistanceBetweenLocations();
            }
            return false;
        } , appendTo: $('#quickbook_popup')
    });

    $('input#shipperStreet').on('change', function() {
        setTimeout(function () {
            var addValue = $('input#shipperStreet').val();
            var houseNumber = getPrecedingNumeric(addValue);
            if (houseNumber) {
                $('input#shipperHouseNumber').val(houseNumber);
                addValue = addValue.replace(houseNumber,'');
                $('input#shipperStreet').val(addValue);
            }
        }, 1000);
    });

    $('input#consigneeStreet').on('change', function() {
        setTimeout(function () {
            var addValue = $('input#consigneeStreet').val();
            var houseNumber = getPrecedingNumeric(addValue);
            if (houseNumber) {
                $('input#consigneeHouseNumber').val(houseNumber);
                addValue = addValue.replace(houseNumber,'');
                $('input#consigneeStreet').val(addValue);
            }
        }, 1000);
    }); 

    function getPrecedingNumeric(sentence) {
        // Match any numeric value at the beginning of the sentence
        var splitText = sentence.split(' ');
        splitText = splitText[0];
        const match = splitText.match(/^\D*(\d+)/);

        // Check if a match is found
        if (match) {
            // Extract and return the numeric value
            return parseInt(match[1], 10);
        }
        return false;
    }   
</script>
