<section class="content-header">
  <h1>
    General UI
    <small>Templates</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li><a href="#">UI</a></li>
    <li class="active">General</li>
  </ol>
</section>
<section class="content">
    <div class="box box-default">
        <div class="box-header with-border">
          <h3 class="box-title">Templates</h3>
          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove"><i class="fa fa-remove"></i></button>
          </div>
        </div>
        <!-- /.box-header -->
        <div class="box-body">
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Type:</label>
                        <select type="text" class="form-control my-colorpicker1 colorpicker-element mail_type">
                            <option value="1">Carrier</option>
                            <option value="2">Customer</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="row docs-premium-template">
                <?php
                foreach($templates->result() as $template){
                ?>
                <div class="col-sm-12 col-md-4">
                    <div class="box box-solid">
                        <div class="box-body">
                            <h4 style="background-color:#f7f7f7; font-size: 18px; text-align: center; padding: 7px 10px; margin-top: 0;text-transform: uppercase;">
                                <?php echo $template->name;?>
                            </h4>
                            <div class="media">
                                <div class="media-left">
                                    <a href="#" class="ad-click-event">
                                        <img src="<?php echo base_url($template->image);?>" alt="MaterialPro" class="media-object" style="width: 100%;height: auto;border-radius: 4px;box-shadow: 0 1px 3px rgba(0,0,0,.15);">
                                    </a>
                                </div>
                                <div class="media-body" style="margin-top: 10px;">
                                    <div class="clearfix">
                                        <p class="pull-right">
                                            <?php
                                            if($user->carrier_mail_template == $template->id){
                                                echo "<div class='btn btn-success btn-sm ad-click-event pull-right disabled templateBtn' data-templateid='".$template->id."' onclick='selectTemplate(\"".$template->id."\")'>";
                                                echo "SELECTED";
                                                echo "</div>";
                                            }else{
                                                echo "<div class='btn btn-success btn-sm ad-click-event pull-right templateBtn' data-templateid='".$template->id."' onclick='selectTemplate(\"".$template->id."\")'>";
                                                echo "SUBMIT";
                                                echo "</div>"; 
                                            }
                                            ?>
                                            
                                        </p>
                                        <h4><?php echo $template->name;?></h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                }
                ?>
            </div>
        </div>
    </div>
</section>
<script type="text/javascript">
    function selectTemplate(temp_id) {
        var mail_type = $(".mail_type").val();
        $.ajax({
            url:"templates/setUserMailTemplate",
            data:{'template_id':temp_id,'mail_type':mail_type},
            type:"POST",
            dataType:"JSON",
            beforeSend:function(){
                $(".templateBtn").each(function(){
                    if(!$(this).hasClass("disabled")){
                        $(this).addClass("disabled");
                    }
                });
            },
            success:function(data){
                $(".templateBtn").each(function(){
                    var id = $(this).data("templateid");
                    if(mail_type=="1"){
                        if(data.user.carrier_mail_template == id){
                            //do some action
                            $(this).html("SELECTED");
                        }else{
                            $(this).removeClass("disabled");
                            $(this).html("SELECT");
                        }
                    }else if(mail_type=="2"){
                        if(data.user.customer_mail_template == id){
                            //do some action
                            $(this).html("SELECTED");
                        }else{
                            $(this).removeClass("disabled");
                            $(this).html("SELECT");
                        }
                    }
                });
            }
        });
    }
    $(document).ready(function(){
        $(".mail_type").change(function(){
            var mail_type = $(".mail_type").val();
            refreshTemplates(mail_type);
        });
    });
    function refreshTemplates(mail_type) {
        $.ajax({
            url:"templates/getUserMailTemplateData",
            type:"POST",
            dataType:"JSON",
            beforeSend:function(){
                $(".templateBtn").each(function(){
                    if(!$(this).hasClass("disabled")){
                        $(this).addClass("disabled");
                    }
                });
            },
            success:function(data){
                $(".templateBtn").each(function(){
                    var id = $(this).data("templateid");
                    if(mail_type=="1"){
                        if(data.user.carrier_mail_template == id){
                            //do some action
                            $(this).html("SELECTED");
                        }else{
                            $(this).removeClass("disabled");
                            $(this).html("SELECT");
                        }
                    }else if(mail_type=="2"){
                        if(data.user.customer_mail_template == id){
                            //do some action
                            $(this).html("SELECTED");
                        }else{
                            $(this).removeClass("disabled");
                            $(this).html("SELECT");
                        }
                    }
                });
            }
        });
    }
</script>
<style type="text/css">
.box-body {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-bottom-right-radius: 3px;
    border-bottom-left-radius: 3px;
    padding: 10px;
    border: 1px #efefef solid;
}
</style>