function pieChartgraph(json_data, Divtag) {
  am5.ready(function () {
    maybeDisposeRoot(Divtag);
    var root = am5.Root.new(Divtag);
    root._logo.dispose();
    root.setThemes([
      am5themes_Animated.new(root)
    ]);
    var chart = root.container.children.push(
      am5percent.PieChart.new(root, {
        endAngle: 360
      })
    );
    var series = chart.series.push(
      am5percent.PieSeries.new(root, {
        valueField: "Count",
        categoryField: "Name",
        endAngle: 360,
        fillField: "Color",
      })
    );
    series.states.create("hidden", {endAngle: -90});
    //series.labels.template.adapters.add("forceHidden", forceHidden);
    //series.ticks.template.adapters.add("forceHidden", forceHidden);
    series.labels.template.setAll({
      radius: 10,
      inside: true
    });
    if (json_data) {
      series.data.setAll(json_data);
    }
    series.appear(1000, 100);

  });
}

function forceHidden(hidden, target) {
  return target.dataItem.get("valuePercentTotal");
}

function maybeDisposeRoot(divId) {
  am5.array.each(am5.registry.rootElements, function (root) {
    if (root) {
      if (root.dom.id == divId) {
        root.dispose();
      }
    }
  });
};
$('#select_year').on('change', function () {
  var year = $(this).val();
  $(".buffer").show();
  $(".modal-body").html("<center><progress></center>");
  $.ajax({
    url: baseurl + 'KNCustBIBasic/getPieChartInfo',
    type: 'POST',
    async: true,
    dataType: 'JSON',
    data: {year: year},
    beforeSend: function () {
    },
    success: function (data, textStatus, jqXHR) {
      $(".buffer").hide();
      $(".modal-body").html("");
      pieChartgraph(data.activePendingOrders, "chartdiv1");
      pieChartgraph(data.transportModeOrders, "chartdiv2");
      pieChartgraph(data.deliveryOrdersInfo, "chartdiv3");
    },
    error: function (jqXHR, textStatus, errorThrown) {
    }
  });

});

function bandsGaugeChart(chartvalue, Divtag) {

  maybeDisposeRoot(Divtag);
  var root = am5.Root.new(Divtag);
  root._logo.dispose();
  root.setThemes([
    am5themes_Animated.new(root)
  ]);

  var chart = root.container.children.push(am5radar.RadarChart.new(root, {
    panX: false,
    panY: false,
    startAngle: 160,
    endAngle: 380
  }));

  var bandsData = [
    {color: "#000080", lowScore: 0, highScore: 50},
    {color: "#0018F9", lowScore: 50, highScore: 100},
    {color: "#1134A6", lowScore: 100, highScore: 150},
    {color: "#000080", lowScore: 150, highScore: 200},
    {color: "#0018F9" , lowScore: 200, highScore: 250},
    {color: "#1134A6" , lowScore: 250, highScore: 300},
    {color: "#000080" , lowScore: 300, highScore: 350},
    {color: "#0018F9", lowScore: 350, highScore: 400},
    {color: "#1134A6", lowScore: 400, highScore: 450},
    {color: "#000080", lowScore: 450, highScore: 500}
  ];

  var axisRenderer = am5radar.AxisRendererCircular.new(root, {
    innerRadius: -40,
    minGridDistance: 50
  });

  axisRenderer.grid.template.setAll({
    stroke: root.interfaceColors.get("background"),
    visible: true,
    strokeOpacity: 0.8
  });

  axisRenderer.labels.template.setAll({
    value: bandsData.lowScore,
    endValue: bandsData.highScore,
    visible: true
  })

  var xAxis = chart.xAxes.push(am5xy.ValueAxis.new(root, {
    maxDeviation: 0,
    min: 0,
    max: 500,
    strictMinMax: true,
    maxPrecision: 0,
    renderer: axisRenderer
  }));

  var axisDataItem = xAxis.makeDataItem({});

  var clockHand = am5radar.ClockHand.new(root, {
    pinRadius: am5.percent(20),
    radius: am5.percent(100),
    bottomWidth: 40
  })

  var bullet = axisDataItem.set("bullet", am5xy.AxisBullet.new(root, {
    sprite: clockHand
  }));


  xAxis.createAxisRange(axisDataItem);

  var label = chart.radarContainer.children.push(am5.Label.new(root, {
    fill: am5.color(0xffffff),
    centerX: am5.percent(50),
    textAlign: "center",
    centerY: am5.percent(50),
    fontSize: "1em"
  }));

  axisDataItem.set("value", chartvalue);

  bullet.get("sprite").on("rotation", function () {
    var value = axisDataItem.get("value");
    var text = Math.round(axisDataItem.get("value")).toString();
    var fill = am5.color(0x000000);
    xAxis.axisRanges.each(function (axisRange) {
      if (value >= axisRange.get("value") && value <= axisRange.get("endValue")) {
        fill = axisRange.get("axisFill").get("fill");
      }
    })

    label.set("text", Math.round(value).toString());

    clockHand.pin.animate({key: "fill", to: fill, duration: 500, easing: am5.ease.out(am5.ease.cubic)})
    clockHand.hand.animate({key: "fill", to: fill, duration: 500, easing: am5.ease.out(am5.ease.cubic)})
  });
  chart.bulletsContainer.set("mask", undefined);

  am5.array.each(bandsData, function (data) {
    var axisRange = xAxis.createAxisRange(xAxis.makeDataItem({}));

    axisRange.setAll({
      value: data.lowScore,
      endValue: data.highScore
    });

    axisRange.get("axisFill").setAll({
      visible: true,
      fill: am5.color(data.color),
      fillOpacity: 0.8
    });

    axisRange.get("label").setAll({
      text: data.title,
      inside: true,
      radius: 15,
      fontSize: "0.9em",
      fill: root.interfaceColors.get("background")
    });
  });

  chart.appear(1000, 100);
}


function checkseachvalidation() {
  var currentyear = $("#currentyear").val();
  var currentmonth = $("#currentmonth").val();
  var currentweek = $("#currentweek").val();
  $(".buffer").show();
  $(".modal-body2").html("<center><progress></center>");
  $.ajax({
    url: baseurl + 'KNCustBIBasic/getBandsGaugeChartDetails',
    type: 'POST',
    async: true,
    dataType: 'JSON',
    data: {currentyear: currentyear, currentmonth: currentmonth, currentweek: currentweek},
    beforeSend: function () {
    },
    success: function (data, textStatus, jqXHR) {
      $(".buffer").hide();
      $(".modal-body2").html("");
      var NOPOD = deliveryDelayedOrders = pickupDelayedOrders = 0;
      if(data.noPodOrders) {
        Object.keys(data.noPodOrders).forEach(function (key) {
          if (data.noPodOrders[key].PODtype == "NOPOD") {
            NOPOD = data.noPodOrders[key].order_count
          }
        });
      }
      if(data.deliveryDelayedOrders) {
        Object.keys(data.deliveryDelayedOrders).forEach(function (key) {
          if (data.deliveryDelayedOrders[key].OrderType == "Delayed") {
            deliveryDelayedOrders = data.deliveryDelayedOrders[key].order_count
          }
        });
      }
      if(data.pickupDelayedOrders) {
        Object.keys(data.pickupDelayedOrders).forEach(function (key) {
          if (data.pickupDelayedOrders[key].OrderType == "Delayed") {
            pickupDelayedOrders = data.pickupDelayedOrders[key].order_count
          }
        });
      }
      bandsGaugeChart(NOPOD, "gaugeChart1");
      bandsGaugeChart(deliveryDelayedOrders, "gaugeChart2");
      bandsGaugeChart(pickupDelayedOrders, "gaugeChart3");
      return false;
    },
    error: function (jqXHR, textStatus, errorThrown) {
    }
  });
  return false;
}

function ganttChartgraph(json, Divtag) {
  maybeDisposeRoot(Divtag);
  var json_data = json;
  console.log(json_data);
  var root = am5.Root.new(Divtag);
  root.dateFormatter.setAll({
    dateFormat: "yyyy-MM-dd",
    dateFields: ["valueX", "openValueX"]
  });
  root.setThemes([
    am5themes_Animated.new(root)
  ]);
  var chart = root.container.children.push(am5xy.XYChart.new(root, {
    panX: false,
    panY: false,
    wheelX: "panX",
    wheelY: "zoomX",
    layout: root.verticalLayout
  }));
  var legend = chart.children.push(am5.Legend.new(root, {
    centerX: am5.p50,
    x: am5.p50
  }))
  var colors = chart.get("colors");

  var data = json_data.data;

  var yRenderer = am5xy.AxisRendererY.new(root, {});
  yRenderer.grid.template.set("location", 1);

  var yAxis = chart.yAxes.push(
    am5xy.CategoryAxis.new(root, {
      categoryField: "category",
      renderer: yRenderer,
      tooltip: am5.Tooltip.new(root, {})
    })
  );

  yAxis.data.setAll(json_data.category);

  var xRenderer = am5xy.AxisRendererX.new(root, {minGridDistance: 10});
  var xAxis = chart.xAxes.push(
    am5xy.DateAxis.new(root, {
      baseInterval: {timeUnit: "day", count: 1},
      renderer: xRenderer
    })
  );
  xRenderer.labels.template.setAll({
    rotation: 90
  })
  var series = chart.series.push(am5xy.ColumnSeries.new(root, {
    xAxis: xAxis,
    yAxis: yAxis,
    openValueXField: "start",
    valueXField: "end",
    categoryYField: "category",
    sequencedInterpolation: true
  }));

  series.columns.template.setAll({
    templateField: "columnSettings",
    strokeOpacity: 2,
    tooltipText: "{task}:\n[bold]{openValueX}[/] - [bold]{valueX}[/]"
  });

  series.data.setAll(data);

  chart.set("scrollbarX", am5.Scrollbar.new(root, {orientation: "horizontal"}));

  series.appear();
  chart.appear(1000, 100);
}
