function lineareaChart(chartdata, Divtag) {

  maybeDisposeRoot(Divtag);
  var root = am5.Root.new(Divtag);
  root._logo.dispose();
  root.setThemes([am5themes_Animated.new(root)]);
  var chart = root.container.children.push(am5xy.XYChart.new(root, {
    panX: false,
    panY: false,
    wheelY: "none"
  }));
  chart.zoomOutButton.set("forceHidden", true);

  chart.get("colors").set("step", 2);

  var xRenderer = am5xy.AxisRendererX.new(root, {minGridDistance: 20});
  var xAxis = chart.xAxes.push(am5xy.CategoryAxis.new(root, {
    categoryField: "date",
    renderer: xRenderer,
    tooltip: am5.Tooltip.new(root, {})
  }));

  xRenderer.labels.template.setAll({
    rotation: 90
  })

  var distanceAxisRenderer = am5xy.AxisRendererY.new(root, {minGridDistance: 30});
  distanceAxisRenderer.grid.template.set("forceHidden", true);
  let maxDistance = Math.max(...chartdata.map((d) => d.distance ?? 0));
  var distanceAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
    min: 0,
    max: maxDistance,
    renderer: distanceAxisRenderer,
    tooltip: am5.Tooltip.new(root, {})
  }));

  var latitudeAxisRenderer = am5xy.AxisRendererY.new(root, {});
  latitudeAxisRenderer.grid.template.set("forceHidden", true);
  var latitudeAxis = chart.yAxes.push(am5xy.ValueAxis.new(root, {
    min: 0,
    max: 10,
    renderer: latitudeAxisRenderer,
    forceHidden: true
  }));
  var distanceSeries = chart.series.push(am5xy.ColumnSeries.new(root, {
    xAxis: xAxis,
    yAxis: distanceAxis,
    valueYField: "distance",
    categoryXField: "date",
    tooltip: am5.Tooltip.new(root, {
      labelText: "{valueY}"
    })
  }));
  distanceSeries.columns.template.adapters.add("fill", function(fill, target) {
    var colors = ["#0080bf", "#00acdf", "#15AAFF","#55d0ff", "#7ce8ff","#ccf9ff"];
    var randomIndex = Math.floor(Math.random() * colors.length);
    return colors[randomIndex];
  });
  var latitudeSeries = chart.series.push(am5xy.LineSeries.new(root, {
    xAxis: xAxis,
    yAxis: latitudeAxis,
    //valueYField: "latitude",
    categoryXField: "date",
    tooltip: am5.Tooltip.new(root, {
      labelText: "{valueY}"
    })
  }));
  latitudeSeries.strokes.template.setAll({strokeWidth: 2});
  chart.set("cursor", am5xy.XYCursor.new(root, {
    xAxis: xAxis,
    yAxis: distanceAxis
  }));

  distanceSeries.data.setAll(chartdata);
  latitudeSeries.data.setAll(chartdata);
  xAxis.data.setAll(chartdata);

  distanceSeries.appear(1000);
  chart.appear(1000, 100);
}
