const base_url = $('#base_url').val();
const comment_error = $('#driverapp_please_enter_comment').val();
const select_picture_error = $('#driverapp_please_select_picture').val();
const invalid_input_error = $('#driverapp_please_enter_valid_input').val();
const missing_qty_error = $('#driverapp_please_enter_missing_quantity').val();
const signee_name_error = $('#driverapp_please_enter_signee_name').val();
const spl_char_not_allow_error = $('#driverapp_special_characters_not_allowed').val();
const invalid_file_error = $('#driverapp_invalid_file').val();
const add_pic_label = $('#driverapp_add_picture').val();
const take_pic_label = $('#driverapp_take_picture').val();
const next_label = $('#driverapp_next').val();
const confirm_close_label = $('#driverapp_confirm_close').val();

function readURL(input, target_id) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            $('#' + target_id).attr('src', e.target.result);
        }
        reader.readAsDataURL(input.files[0]); // convert to base64 string
    }
}

'use strict'

function do_compress(evt, id, res) {
    console.log('do compresing...');
    $('body .loading_roc').show();
    const compress = new Compress()
    const files = [...evt.target.files]
    compress.compress(files, {
        size: 4, // the max size in MB, defaults to 2MB
        quality: 0.50, // the quality of the image, max is 1,
        resize: false // defaults to true, set false if you do not want to resize the image width and height
    }).then((images) => {
        // console.log(images)
        const img = images[0]
        // returns an array of compressed images
        $('body .loading_roc').hide();
        $('#' + res).val(`${img.prefix}${img.data}`);
        return `${img.prefix}${img.data}`;

        // const { endSizeInMb, initialSizeInMb, iterations, sizeReducedInPercent, elapsedTimeInSeconds, alt } = img
    })
}

function dataURItoBlob(data) {
    var binStr = atob(data).split(',')[1],
        len = binStr.length,
        arr = new Uint8Array(len);

    for (var i = 0; i < len; i++) {
        arr[i] = binStr.charCodeAt(i);
    }
    return new Blob(arr);
}

function b64toBlob(b64Data, contentType, sliceSize) {
    contentType = contentType || '';
    sliceSize = sliceSize || 512;

    var byteCharacters = atob(b64Data);
    var byteArrays = [];

    for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
        var slice = byteCharacters.slice(offset, offset + sliceSize);

        var byteNumbers = new Array(slice.length);
        for (var i = 0; i < slice.length; i++) {
            byteNumbers[i] = slice.charCodeAt(i);
        }

        var byteArray = new Uint8Array(byteNumbers);

        byteArrays.push(byteArray);
    }

    var blob = new Blob(byteArrays, {type: contentType});
    return blob;
}


function imagetoblob(ImageURL) {
    // console.log(ImageURL);
    // Split the base64 string in data and contentType
    var block = ImageURL.split(";");
    // Get the content type of the image
    var contentType = block[0].split(":")[1];// In this case "image/gif"
    // get the real base64 content of the file
    var realData = block[1].split(",")[1];// In this case "R0lGODlhPQBEAPeoAJosM...."

    // Convert it to a blob to upload
    return b64toBlob(realData, contentType);
}


var maxLen = 200;

$('.comment-box').keypress(function (event) {
    var this_t = $(this);
    var Length = this_t.val().length;
    var AmountLeft = maxLen - Length;
    this_t.next('span.error').show();
    // console.log(AmountLeft + '/' + maxLen);
    this_t.next('span.error').html(AmountLeft + ' left');
    if (Length >= maxLen) {
        if (event.which != 8) {
            return false;
        }
    }
});

$(document).on('keypress', 'input[type != "password"]', function (event) {
    var regex = new RegExp("^[a-zA-Z\+\,\'\"\_\@\. 0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
        $(this).next('span.error').show();
        $(this).next('span.error').html(spl_char_not_allow_error);
        event.preventDefault();
        return false;
    } else {
        $(this).next('span.error').html('');
    }
});

$(document).on('keypress', 'input[type = "number"], .onlyNumeric', function (event) {
    console.log('keypres couur number');
    var regex = new RegExp("^[0-9]+$");
    var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
    if (!regex.test(key)) {
        $(this).css('border', 'tomato 1px solid');
        $(this).next('span.error').show();
        $(this).next('span.error').html(spl_char_not_allow_error);
        event.preventDefault();
        return false;
    } else {
        $(this).css('border', '1px solid #ced4da');
        $(this).next('span.error').html('');
    }
});

function show_dg(str) {
    if (((str).trim()).length == "0") {
        str = "Oops ! Description is empty";
    }
    var form = new FormData();
    form.append('danger_goods_order_id', str);
    $.ajax({
        type: 'POST',
        url: base_url + "/driverdanger_goods_description",
        processData: false,
        data: form,
        contentType: false,
        cache: false,
        async: false,
        success: function (response) {
            $('#dg_content').html(response);
            $('#dg_model').modal('show');
        },
        error: function (jqXHR, textStatus, errorThrown) {
            set_message("Error Occurred.");
        }
    });
}

function setshipstopstatus(stop_status, status_type, tail, selected) {
    setshipstopstatus_submit(stop_status, status_type, tail, selected);
}

function setshipstopstatus_submit(stop_status, status_type, tail, selected) {
    // return;
    var status_stage = $(selected).data('status');

    var action = base_url + "/driversetshipstopstatus_multiple";
    var method = 'POST';
    var form = new FormData();
    var macadam_data = '';
    var comment = '';
    var d_missing_qty = '';
    if (status_type == "P") {
        form.append('pickup_data', $('#pickup_data' + tail).val());
        macadam_data = $('#pickup_macadam_data' + tail).val();
        comment = $('#comment' + tail).val();
    } else {
        form.append('drop_data', $('#drop_data' + tail).val());
        macadam_data = $('#delivery_macadam_data' + tail).val();
        comment = $('#d_comment' + tail).val();
        var d_missing_qty_v = $('#d_missing_qty' + tail).val().trim();
        d_missing_qty = (d_missing_qty_v) ? d_missing_qty_v : '';
    }
    var pickup_POP_res = $('#pickup_POP_res' + tail).val();
    var delivery_POD_res = $('#delivery_POD_res' + tail).val();

    if (pickup_POP_res == 'err' || delivery_POD_res == 'err') {
        // alert('Oops! Something went wrong');
        return false;
    }
    form.append('status_stage', status_stage);
    form.append('status', stop_status);
    form.append('status_type', status_type);
    form.append('comment', comment);
    (d_missing_qty) ? form.append('missing_qty', d_missing_qty) : '';
    form.append('macadam_d3_data', pickup_POP_res);
    form.append('macadam_d3_POD_data', delivery_POD_res);
    var currentdate = new Date();
    var datetime = currentdate.getFullYear() + "-"
        + (currentdate.getMonth() + 1) + "-"
        + currentdate.getDate() + " "
        + currentdate.getHours() + ":"
        + currentdate.getMinutes();
    form.append('status_manual_date', datetime);

    form.append('macadam_data', macadam_data);
    $('body').find('#preloader').show();
    $.ajax({
        type: method,
        url: action,
        processData: false,
        data: form,
        contentType: false,
        cache: false,
        // async: false,
        beforeSend: function () {
            $(selected).attr('disabled', true);
            $('body .loading_roc').show();
            if (status_type == "P") {
                $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            } else {
                $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            }
        },
        success: function (response) {
            //  window.location.reload();
            let parsed_response = JSON.parse(response);
            $(selected).find('.btn_date_kn').html(parsed_response.return_time);
            if (stop_status == 3) {
                // gateout happend
                try {
                    let stops_left_val = parseInt($('#stops_left_val').html().trim());
                    if (stops_left_val > 0) {
                        $('#stops_left_val').html(stops_left_val - 1);
                    }
                } catch (error) {
                    throw {"message": "invalid stops count"}
                }
            } else {
                selected.value = parsed_response.return_time;
            }
            $(selected).removeClass('pnd_btn');
            $(selected).addClass('btn-success');
            var next_id = $(selected).data('next-id');
            console.log($('#' + next_id));
            $('#' + next_id).prop('disabled', false);
            // $(selected).closest('tr').next().find('.pnd_btn').prop('disabled', false);
            $('#preloader').hide();
            // pop-ups close
            $('#pickupModal' + tail).modal('hide');
            $('#deliveryModal' + tail).modal('hide');
            $('#deliveryModal_pod' + tail).modal('hide');
        },
        error: function (jqXHR, textStatus, errorThrown) {
            $(selected).prop('disabled', false);
            $('body .loading_roc').hide();
            set_message("Error Occurred.");
            if (status_type == "P") {
                $('#confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
            } else {
                $('#d_confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
                $('#d_confirm_close_pod' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
            }
        }
    });
}

function do_action_after_click_btn_in_pop(tail) {
    $('#btn_com_pic_section' + tail).show();
    // $('#confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
    from_check('pod_sign_uploads', 'confirm_close', tail);
}

function d_do_action_after_click_btn_in_pop(tail) {
    $('#d_btn_com_pic_section' + tail).show();
    from_check('d_pod_sign_uploads', 'd_confirm_close', tail);
}

function pk_done(tail) {
    $('#damage' + tail).attr('disabled', true);
    $('#notdone' + tail).attr('disabled', true);
    $('#c_asterisk' + tail).attr('style', 'display:none !important');
    $('#comment' + tail).removeAttr('required');
    $('#p_asterisk' + tail).attr('style', 'display:none !important');
    $('#picture' + tail).removeAttr('required');
    // $('#picture' + tail).attr('required', true);
    do_action_after_click_btn_in_pop(tail);
    $('#done' + tail).find('i').addClass('text-success');
}

function pk_damang(tail) {
    $('#done' + tail).attr('disabled', true);
    $('#notdone' + tail).attr('disabled', true);
    // $('#damage' + tail).css('border', '2px solid #ca9804');
    $('#c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#comment' + tail).attr('required', true);
    $('#p_asterisk' + tail).attr('style', 'display:flex !important; top: 15px; background: transparent;');
    $('#picture' + tail).attr('required', true);
    do_action_after_click_btn_in_pop(tail);
    $('#damage' + tail).find('i').addClass('text-warning');
}

function pk_notdone(tail) {
    $('#done' + tail).attr('disabled', true);
    $('#damage' + tail).attr('disabled', true);
    $('#picture' + tail).removeAttr('required');
    $('#c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#comment' + tail).attr('required', true);
    $('#p_asterisk' + tail).attr('style', 'display:none !important');
    do_action_after_click_btn_in_pop(tail);
    $('#notdone' + tail).find('i').addClass('text-danger');
}

function d_done(tail) {
    $('#d_damage' + tail).attr('disabled', true);
    $('#d_short' + tail).attr('disabled', true);
    $('#d_notdone' + tail).attr('disabled', true);
    $('#d_refused' + tail).attr('disabled', true);
    // $('#d_notdone' + tail).attr('style', 'display:none !important');
    $('#d_c_asterisk' + tail).attr('style', 'display:none !important');
    $('#d_comment' + tail).removeAttr('required');
    $('.d_missing_qty_blk' + tail).hide();
    $('#d_missing_qty' + tail).attr('required', false);
    $('#d_p_asterisk' + tail).attr('style', 'display:none !important');
    $('#d_picture' + tail).removeAttr('required');
    d_do_action_after_click_btn_in_pop(tail);
    $('#d_done' + tail).find('i').addClass('text-success');
}

function d_damage(tail) {
    $('#d_done' + tail).attr('disabled', true);
    $('#d_short' + tail).attr('disabled', true);
    $('#d_notdone' + tail).attr('disabled', true);
    $('#d_refused' + tail).attr('disabled', true);
    // $('#d_damage' + tail).css('border', '2px solid #ca9804');
    $('.d_missing_qty_blk' + tail).hide();
    $('#d_missing_qty' + tail).attr('required', false);
    // $('#d_notdone' + tail).attr('style', 'display:none !important');
    // $('#d_comment' + tail).removeAttr('required');
    $('#d_c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#d_comment' + tail).attr('required', true);
    $('#d_p_asterisk' + tail).attr('style', 'display:flex !important; top: 15px; background: transparent;');
    $('#d_picture' + tail).attr('required', true);
    d_do_action_after_click_btn_in_pop(tail);
    $('#d_damage' + tail).find('i').addClass('text-warning');
}

function d_short(tail) {
    $('#d_done' + tail).attr('disabled', true);
    $('#d_damage' + tail).attr('disabled', true);
    $('#d_notdone' + tail).attr('disabled', true);
    $('#d_refused' + tail).attr('disabled', true);
    // $('#d_short' + tail).css('border', '2px solid #ca9804');
    $('.d_missing_qty_blk' + tail).show();
    $('#d_missing_qty' + tail).attr('required', true);
    $('#d_c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#d_comment' + tail).attr('required', true);
    $('#d_p_asterisk' + tail).attr('style', 'display:flex !important; top: 15px; background: transparent;');
    $('#d_picture' + tail).attr('required', true);
    d_do_action_after_click_btn_in_pop(tail);
    $('#d_short' + tail).find('i').addClass('text-warning');
}

function d_notdone(tail) {
    $('#d_done' + tail).attr('disabled', true);
    $('#d_damage' + tail).attr('disabled', true);
    $('#d_short' + tail).attr('disabled', true);
    $('#d_refused' + tail).attr('disabled', true);
    // $('#d_notdone' + tail).css('border', '2px solid #ca9804');
    $('#d_picture' + tail).removeAttr('required');
    $('.d_missing_qty_blk' + tail).hide();
    $('#d_missing_qty' + tail).attr('required', false);
    $('#d_p_asterisk' + tail).attr('style', 'display:none !important');
    $('#d_c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#d_comment' + tail).attr('required', true);
    d_do_action_after_click_btn_in_pop(tail);
    $('#d_notdone' + tail).find('i').addClass('text-warning');
}

function d_refused(tail) {
    $('#d_done' + tail).attr('disabled', true);
    $('#d_damage' + tail).attr('disabled', true);
    $('#d_short' + tail).attr('disabled', true);
    $('#d_notdone' + tail).attr('disabled', true);
    // $('#d_refused' + tail).css('border', '2px solid #ca9804');
    $('#d_picture' + tail).removeAttr('required');
    $('.d_missing_qty_blk' + tail).hide();
    $('#d_missing_qty' + tail).attr('required', false);
    $('#d_p_asterisk' + tail).attr('style', 'display:none !important');
    $('#d_c_asterisk' + tail).attr('style', 'display:flex !important');
    $('#d_comment' + tail).attr('required', true);
    d_do_action_after_click_btn_in_pop(tail);
    $('#d_refused' + tail).find('i').addClass('text-warning');
}

function do_back(tail) {
    // console.log('called');
    var modal_action = $('#modal_back' + tail).attr('data-modal_action'); // close or back
    console.log(modal_action);
    if (modal_action === 'close') {
        $('#modal_back' + tail).attr('data-modal_action', 'close'); // close or back
        $('#pickupModal' + tail).modal('hide');
        /*$('#pickupModal' + tail).on('hidden.bs.modal', function () {
            window.location.reload();
        });*/
        // return true;
    } else {
        $('#modal_back' + tail).attr('data-modal_action', 'close'); // close or back
        $('#done' + tail).attr('disabled', false);
        $('#damage' + tail).attr('disabled', false);
        $('#notdone' + tail).attr('disabled', false);
        $('#btn_com_pic_section' + tail).hide();
        $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
        $('#comment' + tail).val('');
        $('#missing_qty' + tail).val('');
        $('#picture' + tail).val('');
        $('#btnfile' + tail).removeClass('btn-success').addClass('btn-kn');
        $('#fname' + tail).text(add_pic_label);
        // return true;
    }
}

function d_modal_back_pod(tail) {
    // alert('cliekd');
    $('#pod_upload_text' + tail).text(take_pic_label);
    $('#d_picture_pod' + tail).val('');
    $('#prev_pod' + tail).attr('src', base_url + 'assets/driverapp/images/icons/camera-4998.svg');
    $('#d_sign' + tail).val('');
    $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
    $('#d_btnfile_pod' + tail).removeClass('btn-success').addClass('btn-kn');
    // return true;
}

function d_do_back(tail) {
    // console.log('called');
    var modal_action = $('#d_modal_back' + tail).attr('data-modal_action'); // close or back
    console.log(modal_action);
    if (modal_action === 'close') {
        $('#d_modal_back' + tail).attr('data-modal_action', 'close'); // close or back
        $('#deliveryModal' + tail).modal('hide');
        /*$('#deliveryModal' + tail).on('hidden.bs.modal', function () {
             window.location.reload();
        });*/
        // return true;
    } else {
        $('#d_modal_back' + tail).attr('data-modal_action', 'close'); // close or back
        $('#d_done' + tail).attr('disabled', false);
        $('#d_damage' + tail).attr('disabled', false);
        $('#d_short' + tail).attr('disabled', false);
        $('#d_notdone' + tail).attr('disabled', false);
        $('#d_refused' + tail).attr('disabled', false);
        $('#d_btn_com_pic_section' + tail).hide();
        $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
        $('#d_comment' + tail).val('');
        $('#d_missing_qty' + tail).val('');
        $('#d_picture' + tail).val('');
        $('#d_btnfile' + tail).removeClass('btn-success').addClass('btn-kn');
        $('#d_fname' + tail).text(add_pic_label);
        // return true;
    }
}

function from_check(form_id, confirm_btn_id, tail) {
    var r = 0;
    $('form#' + form_id + tail).find('input[type!=hidden],textarea').each(function () {
        var ele = $(this);
        var val = ele.val().trim();
        console.log('ele val => ' + val);
        if (ele.prop('required') && (val === '' || val === undefined)) {
            r++;
        }
        console.log('r =>' + r);
        if (r) {
            $('#' + confirm_btn_id + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
        } else {
            $('#' + confirm_btn_id + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
        }
    });
}

function setpickupdata(stop_status, status_type, tail, selected) {
    $('#pickupModal' + tail).modal('show');
    $('form#pod_sign_uploads' + tail).on('change', function () {
        from_check('pod_sign_uploads', 'confirm_close', tail);
    });
    $('#done' + tail).click(function () {
        $(selected).data('status', "PICKUP_OK");
        pk_done(tail);
        $('#modal_back' + tail).attr('data-modal_action', 'back'); // close or back
    });
    $('#damage' + tail).click(function () {
        stop_status = 12;
        $(selected).data('status', "PICKUP_BROKEN");
        pk_damang(tail);
        $('#modal_back' + tail).attr('data-modal_action', 'back'); // close or back
    });
    $('#notdone' + tail).click(function () {
        stop_status = 13;
        $(selected).data('status', "PICKUP_NOT_DONE");
        pk_notdone(tail);
        $('#modal_back' + tail).attr('data-modal_action', 'back'); // close or back
    });
    $("#btnfile" + tail).click(function () {
        console.log('get clicked');
        $("#picture" + tail).trigger('click');
    });

    $("#picture" + tail).change(function (e) {
        var ext = $(this).val().split('.').pop().toLowerCase();
        if (ext) {
            if ($.inArray(ext, ['gif', 'png', 'jpg', 'jpeg', 'pdf']) == -1) {
                alert(invalid_file_error);
                return false;
            }
        } else {
            return false;
        }
        var file = $(this).val().replace(/C:\\fakepath\\/ig, '');
        if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
            do_compress(e, 'picture' + tail, 'picture_base64' + tail);
        }
        $("#fname" + tail).text(file);
        $("#picture_file_name" + tail).val(file);
        $('#btnfile' + tail).removeClass('btn-kn').addClass('btn-success');
    });

    $('#modal_back' + tail).click(function () {
        do_back(tail);
    });
    $('#confirm_close' + tail).click(function () {
        $('#status_id' + tail).val(stop_status);
        var curr_status = $(selected).data('status');
        // console.log(curr_status);
        var this_p = $('#btnfile' + tail);
        var this_c = $('#comment' + tail);
        var comment = this_c.val().trim();
        var picture = $('#picture' + tail).val().trim();

        /*if (curr_status === 'PICKUP_OK') {
         if (picture === '' || picture === undefined) {
         // alert(select_picture_error);
         this_p.css('border', " 2px solid tomato");
         this_p.next('span.error').show();
         this_p.next('span.error').html(select_picture_error);
         return false;
         } else {
         // alert('req sent');
         this_p.css('border', " 2px solid #154da1");
         }
         }*/
        if (curr_status === 'PICKUP_BROKEN') {
            if (comment === '' || comment === undefined) {
                this_c.css('border', " 2px solid tomato");
                this_c.next('span.error').show();
                this_c.next('span.error').html(comment_error);
                // alert('enter commnet');
                return false;
            } else {
                this_c.css('border', " 2px solid #154da1")
            }
            if (picture === '' || picture === undefined) {
                // alert(select_picture_error);
                this_p.css('border', " 2px solid tomato");
                this_p.next('span.error').show();
                this_p.next('span.error').html(select_picture_error);
                return false;
            } else {
                // alert('req sent');
                this_p.css('border', " 2px solid #154da1");
            }
        }
        if (curr_status === 'PICKUP_NOT_DONE') {
            if (comment === '' || comment === undefined) {
                this_c.css('border', " 2px solid tomato");
                this_c.next('span.error').show();
                this_c.next('span.error').html(comment_error);
                // alert('enter commnet');
                return false;
            } else {
                this_c.css('border', " 2px solid #154da1")
            }
        }

        // $('#pod_sign_uploads').submit();
        $('body .loading_roc').show();

        if (picture) {
            $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            upload_pod_package_image(tail, 'pod_sign_uploads', 'picture', curr_status);
        }
        setshipstopstatus(stop_status, status_type, tail, selected);
    });

}

function setdeliverydata(stop_status, status_type, tail, selected) {
    $('form#d_pod_sign_uploads' + tail).change(function () {
        console.log('form change function called');
        from_check('d_pod_sign_uploads', 'd_confirm_close', tail);
    });
    $('#deliveryModal' + tail).modal('show');
    $('#d_done' + tail).click(function () {
        $(selected).data('status', "DELIVERED");
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back
        d_done(tail);
        $('#d_confirm_close' + tail).text(next_label);
    });

    $('#d_damage' + tail).click(function () {
        stop_status = 12;
        $(selected).data('status', "DELIVERED_WITH_DAMAGE");
        d_damage(tail);
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back
        $('#d_confirm_close' + tail).text(next_label);
        // return;
    });

    // 5 => +ve status
    // 8 => -ve status
    $('#d_short' + tail).click(function () {
        stop_status = 13;
        $(selected).data('status', "DELIVERY_SHORT");
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back
        d_short(tail);
        $('#d_confirm_close' + tail).text(next_label);
    });

    $('#d_notdone' + tail).click(function () {
        stop_status = 14; //-ve status -> 8
        $(selected).data('status', "DELIVERY_NOT_DONE");
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back
        d_notdone(tail);
        $('#d_confirm_close' + tail).text(confirm_close_label);
    });

    $('#d_refused' + tail).click(function () {
        stop_status = 15;
        $(selected).data('status', "DELIVERY_REFUSED");
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back
        d_refused(tail);
        $('#d_confirm_close' + tail).text(next_label);
    });
    $("#d_btnfile" + tail).click(function () {
        console.log('get clicked');
        $("#d_picture" + tail).trigger('click');
    });

    $("#d_picture" + tail).change(function (e) {
        var ext = $(this).val().split('.').pop().toLowerCase();
        if (ext) {
            if ($.inArray(ext, ['gif', 'png', 'jpg', 'jpeg', 'pdf']) == -1) {
                alert('invalid file!');
                return false;
            }
        } else {
            return false;
        }

        var file = $(this).val().replace(/C:\\fakepath\\/ig, '');
        if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
            do_compress(e, 'd_picture' + tail, 'd_picture_base64' + tail);
        }
        $("#d_fname" + tail).text(file);
        $("#d_picture_file_name" + tail).val(file);
        $('#d_btnfile' + tail).removeClass('btn-kn').addClass('btn-success');
    });


    $("#d_btnfile_pod" + tail).click(function () {
        $("#d_picture_pod" + tail).click();
    });

    $("#d_picture_pod" + tail).change(function (e) {
        var ext = $(this).val().split('.').pop().toLowerCase();
        if (ext) {
            if ($.inArray(ext, ['gif', 'png', 'jpg', 'jpeg', 'pdf']) == -1) {
                alert('invalid file!');
                return false;
            }
        } else {
            return false;
        }
        readURL(this, 'prev_pod' + tail);
        $('#pod_upload_text' + tail).text('CHANGE');
        if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
            do_compress(e, 'd_picture_pod' + tail, 'd_picture_base64_pod' + tail);
        }
        var file = $(this).val().replace(/C:\\fakepath\\/ig, '');
        $("#d_fname_pod" + tail).text(file);
        $("#d_picture_file_name_pod" + tail).val(file);
        $('#d_btnfile_pod' + tail).removeClass('btn-kn').addClass('btn-success');
    });

    $('#d_confirm_close' + tail).click(function () {
        $('#d_status_id' + tail).val(stop_status);
        var curr_status = $(selected).data('status');
        console.log(curr_status);
        // d_btnfile0
        var this_p = $('#d_btnfile' + tail);
        var this_c = $('#d_comment' + tail);
        var this_mq = $('#d_missing_qty' + tail);
        var picture = $('#d_picture' + tail).val().trim();
        var missing_qty = this_mq.val().trim();
        var comment = this_c.val().trim();

        if (curr_status === 'DELIVERY_NOT_DONE' || curr_status === 'DELIVERY_REFUSED') {
            if (comment === '' || comment === undefined) {
                // alert('enter commnet');
                this_c.css('border', " 2px solid tomato");
                this_c.next('span.error').show();
                this_c.next('span.error').html(comment_error);
                return false;
            } else {
                this_c.css('border', " 2px solid #154da1")
            }
        }

        if (curr_status === 'DELIVERED_WITH_DAMAGE' || curr_status === 'DELIVERY_SHORT') {
            if (curr_status === 'DELIVERY_SHORT') {
                if (missing_qty === '' || missing_qty === undefined || missing_qty == 0) {
                    this_mq.css('border', " 2px solid tomato");
                    this_mq.next('span.error').show();
                    this_mq.next('span.error').html(missing_qty_error);
                    return false;
                } else {
                    console.log('missing_qty', missing_qty);
                    var d_missing_qty_max = parseInt($('#d_missing_qty_max' + tail).val());
                    console.log('d_missing_qty_max ', d_missing_qty_max);
                    if (parseInt(missing_qty) > d_missing_qty_max) {
                        this_mq.css('border', " 2px solid tomato");
                        this_mq.next('span.error').show();
                        this_mq.next('span.error').html(invalid_input_error);
                        return false;
                    } else {
                        this_mq.css('border', " 2px solid #154da1")
                    }
                }
            }

            if (comment === '' || comment === undefined) {
                this_c.css('border', " 2px solid tomato");
                this_c.next('span.error').show();
                this_c.next('span.error').html(comment_error);
                return false;
            } else {
                this_c.css('border', " 2px solid #154da1")
            }
            if (picture === '' || picture === undefined) {
                this_p.css('border', " 2px solid tomato");
                this_p.next('span.error').show();
                this_p.next('span.error').html(select_picture_error);
                return false;
            } else {
                this_p.css('border', " 2px solid #154da1");
                // alert('req sent');
            }
        }


        // $('body .loading_roc').show();
        $('#d_modal_back' + tail).attr('data-modal_action', 'back'); // close or back

        console.log('req sent');
        var cur_sec = $('#d_confirm_close' + tail).text();
        if (cur_sec === 'NEXT' || cur_sec === 'Suivant') {
            $('#deliveryModal_pod' + tail).modal('show');
            $('#d_confirm_close_pod' + tail).click(function () {
                $('#d_sign' + tail).trigger('blur');
                var POD = $('#d_picture_pod' + tail).val().trim();
                console.log('d_confirm_close_pod clicked working.. ');
                console.log('POD =>' + POD);
                if (POD) {
                    $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    console.log('pod sending....');
                    upload_pod_package_image(tail, 'd_pod_sign_uploads_pod', 'POD', curr_status);
                }
                if (picture) {
                    $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                    console.log('picture sending....');
                    upload_pod_package_image(tail, 'd_pod_sign_uploads', 'picture', curr_status);
                }
                setshipstopstatus(stop_status, status_type, tail, selected);
            });
        } else {
            if (picture) {
                $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
                upload_pod_package_image(tail, 'd_pod_sign_uploads', 'picture', curr_status);
            }
            setshipstopstatus(stop_status, status_type, tail, selected);
        }
    });

    $('#d_sign' + tail).on('blur, keyup', function () {
        var sign = $(this);
        var sign_v = sign.val();
        if (sign_v === '' || sign_v === undefined) {
            sign.css('border', " 2px solid tomato");
            sign.next('span.error').show();
            sign.next('span.error').html(signee_name_error);
            return false;
        } else {
            $('#d_confirm_close_pod' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
        }
    });

    $('#d_modal_back' + tail).click(function () {
        d_do_back(tail);
    });

}

function upload_pod_package_image(tail, FromSelect, ImgStoreType = '',curr_status) {
    var form = $('#' + FromSelect + tail)[0];
    var data = new FormData(form);

    console.log('form id => ' + FromSelect);
    if (FromSelect == 'pod_sign_uploads') {
        var imgURI = $('#picture_base64' + tail).val();
        if (imgURI) {
            data.append('file_name', imagetoblob(imgURI), $('#picture_file_name' + tail).val());
        }
    }

    if (FromSelect == 'd_pod_sign_uploads') {
        var imgURI = $('#d_picture_base64' + tail).val();
        if (imgURI) {
            data.append('file_name', imagetoblob(imgURI), $('#d_picture_file_name' + tail).val());
        }
    }
    if (FromSelect == 'd_pod_sign_uploads_pod') {
        var imgURI = $('#d_picture_base64_pod' + tail).val();
        if (imgURI) {
            data.append('file_name', imagetoblob(imgURI), $('#d_picture_file_name_pod' + tail).val());
        }
    }
    data.append('img_store_type', ImgStoreType);

    if (ImgStoreType === 'POD') {
        var sign_v = $('#d_sign' + tail).val();
        data.append('rev_sign', sign_v);
    }
    data.append('status_stage', curr_status);
    console.log(data);
    $('body .loading_roc').show();
    // $("#upload_btn").prop("disabled", true);
    // $('#fa_fa_camera').css('display', 'none');
    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: base_url + "/Driverappv2/poduploads",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        // timeout: 600000,
        async: false,
        beforeSend: function () {
            console.log('uploading POP img');
            $('body .loading_roc').show();
            $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
            $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true);
        },
        success: function (data) {
            $('body .loading_roc').hide();
            console.log('uploading POP img done success');
            var res = JSON.parse(data);
            // console.log(res);
            if (res.status == 1) {
                // console.log(res.res);
                if (ImgStoreType == 'POD') {
                    console.log('got POD data');
                    $('#delivery_POD_res' + tail).val(JSON.stringify(res.res));
                } else {
                    console.log('got POP data');
                    $('#pickup_POP_res' + tail).val(JSON.stringify(res.res));
                }
            } else {
                console.log('error occour');
                console.log(res.data);
                if (ImgStoreType == 'POD') {
                    console.log('got POD data');
                    $('#delivery_POD_res' + tail).val('err');
                } else {
                    console.log('got POP data');
                    $('#pickup_POP_res' + tail).val('err');
                }
                $('.pod_error' + tail).html(res.data);
                return false;
            }
        },
        error: function (e) {
            $('body .loading_roc').hide();
            // $("#upload_btn").prop("disabled", false);
        },
        complete: function (e) {
            /*setTimeout(function () {
                $('#confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
                $('#d_confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
                $('#d_confirm_close_pod' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false);
            }, 100);*/
        }
    });
}


var toggle_div = function (inp, i) {
    // $('.' + inp + i).slideToggle(200);
    var chv_tg = $('#chv_tg_' + inp[0] + i);
    chv_tg.toggleClass('la-chevron-down');
    chv_tg.toggleClass('la-chevron-up');
    $('#' + inp[0] + '_info_ico' + i).toggle();
    $('#' + inp[0] + '_c_info' + i).toggle();
    $('#' + inp[0] + '_date_info' + i).toggle();
};

function getLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(showPosition);
    } else {
        console.log("Geolocation is not supported by this browser.");
    }
}

function showPosition(position) {
    console.log("Latitude: " + position.coords.latitude + "\nLongitude: " + position.coords.longitude);
}

window.onbeforeunload = function () {
    document.getElementById('preloader').style.display = "block";
};
document.onreadystatechange = function () {
    var state = document.readyState;
    if (state == 'interactive') {
        // document.getElementById('preloader').style.display="block";
    } else if (state == 'complete') {
        setTimeout(function () {
            document.getElementById('interactive');
            document.getElementById('preloader').style.display = "none";
        }, 1);
    }
};

function setStops() {
    var wrapperx = $('#body_div');
    var stopsLeft = wrapperx.find('#stops_left').val();
    wrapperx.find('#stops_left_val').text(stopsLeft);
}

var sendLocationTracking = function () {
    $.ajax({
        type: "POST",
        url: base_url + "/Driverappv2/saveTracking",
        data: {},
        async: false,
        beforeSend: function () {
            console.log('sending tracking');
        },
        success: function (data) {
            console.log('tacking saved');
        }
    });
};

function openTransPop() {
    $('#language_model').modal('show');
}

function change_language() {
    var final_lang = $('#final_lang').val();
    if (final_lang.length < 3) {
        set_message('Please select valid language');
        return false;
    }
    var form = new FormData();
    form.append('language', final_lang);
    $.ajax({
        type: "POST",
        url: base_url + 'driversite_language2',
        processData: false,
        data: form,
        contentType: false,
        cache: false,
        async: false,
        beforeSend: function () {
            $('body .loading_roc').show();
        },
        success: function (response) {
            var res = JSON.parse(response);
            console.log(res);
            if (res.status == "1") {
                window.location.reload();
            } else {
                $('#language_model').modal('hidden');
                alert(res.response);
                set_message(res.response);
            }
        },
        error: function (jqXHR, textStatus, errorThrown) {
//                alert("Error Occurred.");
            set_message('Error Occurred.');
        }
    });
}