const base_url = $('#base_url').val()
const comment_error = $('#driverapp_please_enter_comment').val()
const select_picture_error = $('#driverapp_please_select_picture').val()
const invalid_input_error = $('#driverapp_please_enter_valid_input').val()
const missing_qty_error = $('#driverapp_please_enter_missing_quantity').val()
const signee_name_error = $('#driverapp_please_enter_signee_name').val()
const driver_name_error = $('#driverapp_please_enter_driver_name').val()
const mobile_number_error = $('#driverapp_please_enter_mobile_number').val()
const truck_reg_num_error = $('#driverapp_please_enter_truck_reg_num').val()
const spl_char_not_allow_error = $('#driverapp_special_characters_not_allowed').val()
const invalid_file_error = $('#driverapp_invalid_file').val()
const driverapp_attachment = $('#driverapp_attachment').val()
const next_label = $('#driverapp_next').val()
const confirm_close_label = $('#driverapp_confirm_close').val()
const driverapp_pickup_not_done_KN_message = $('#driverapp_pickup_not_done_KN_message').val()
let lang_status = []
let lang_status_h3 = []
let resStatusFlagArr = []

function readURL(input, target_id) {
  if (input.files && input.files[0]) {
    var reader = new FileReader()
    reader.onload = function (e) {
      $('#' + target_id).attr('src', e.target.result)
    }
    reader.readAsDataURL(input.files[0]) // convert to base64 string
  }
}

'use strict'

function do_compress(evt, id, res, tail = 0) {
  $('body .loading_roc').show()
  const compress = new Compress()
  const files = [...evt.target.files]
  compress.compress(files, {
    size: 2, // the max size in MB, defaults to 2MB
    quality: 0.20, // the quality of the image, max is 1,
    resize: false // defaults to true, set false if you do not want to resize the image width and height
  }).then((images) => {
    const img = images[0]
    // returns an array of compressed images
    $('body .loading_roc').hide()
    $('#' + res).val(`${img.prefix}${img.data}`)
    var sel_type = (id.toLowerCase().charAt(0) === 'd') ? (id.toLowerCase().charAt(10) === 'p') ? 'd_pod_' : 'd_' : ''
    var sel = $('#' + sel_type + 'imagePreview' + tail)
    sel.css('display', 'flex')
    sel.find('img').attr('src', `${img.prefix}${img.data}`)
    $('#' + sel_type + 'imgIco' + tail).hide()
  })
}

function dataURItoBlob(data) {
  var binStr = atob(data).split(',')[1],
    len = binStr.length,
    arr = new Uint8Array(len)
  for (var i = 0; i < len; i++) {
    arr[i] = binStr.charCodeAt(i)
  }
  return new Blob(arr)
}

function b64toBlob(b64Data, contentType = '', sliceSize = 512) {
  var byteCharacters = atob(b64Data)
  var byteArrays = []
  const byteCharLength = byteCharacters.length
  for (var offset = 0; offset < byteCharLength; offset += sliceSize) {
    var slice = byteCharacters.slice(offset, offset + sliceSize)
    const sliceLength = slice.length
    var byteNumbers = new Array(sliceLength)
    for (var i = 0; i < sliceLength; i++) {
      byteNumbers[i] = slice.charCodeAt(i)
    }
    var byteArray = new Uint8Array(byteNumbers)
    byteArrays.push(byteArray)
  }

  return new Blob(byteArrays, { type: contentType })
}

function imagetoblob(ImageURL) {
  // Split the base64 string in data and contentType
  var block = ImageURL.split(';')
  // Get the content type of the image
  var contentType = block[0].split(':')[1]// In this case "image/gif"
  // get the real base64 content of the file
  var realData = block[1].split(',')[1]// In this case "R0lGODlhPQBEAPeoAJosM...."
  // Convert it to a blob to upload
  return b64toBlob(realData, contentType)
}

$(document).on('keypress', 'input[type != "password"]', function (event) {
  const regex = new RegExp('^[^*|\\:<>[\\]{}`\\\\()\';]+$')
  const key = String.fromCharCode(!event.charCode ? event.which : event.charCode)
  if (!regex.test(key)) {
    $(this).next('span.error').html(spl_char_not_allow_error).show()
    event.preventDefault()
    return false
  } else {
    $(this).next('span.error').html('')
  }
})

$(document).on('keypress', '.onlyChars', function (event) {
  return onlyChars($(this), event);
});

$(document).on('blur', '.onlyChars, .onlyNumeric', function () {
  $(this).next('span.error').hide();
});

function onlyChars(select, event) {
  const regex = new RegExp('^[a-z A-Z]+$')
  return validateField(select, regex, invalid_input_error, event);
}

function onlyNumbers(select, event) {
  const regex = new RegExp('^[0-9]+$');
  return validateField(select, regex, spl_char_not_allow_error, event);
}

function validateField(select, regex, errorMessage, event) {
  const key = String.fromCharCode(!event.charCode ? event.which : event.charCode)
  if (!regex.test(key)) {
    select.css('border-bottom', '1px solid tomato')
    select.next('span.error').html(errorMessage).show()
    event.preventDefault()
    return false
  } else {
    select.css('border-bottom', '1px solid #ced4da')
    select.next('span.error').html('')
    return true
  }
}

$(document).on('keypress', 'input[type="number"], .onlyNumeric', function (event) {
  return onlyNumbers($(this), event)
})

function show_dg(goodsID) {
  if (goodsID === undefined) {
    set_message('DG Goods not found')
    throw new Error('Oops ! DG Goods not found')
  }
  let form = new FormData()
  form.append('danger_goods_order_id', goodsID)
  $.ajax({
    type: 'POST',
    url: base_url + '/driverdanger_goods_description',
    processData: false,
    data: form,
    contentType: false,
    cache: false,
    beforeSend: function () {
      showLoader()
      $('#dg_model').modal('show')
      $('#dg_content').html('Please wait...')
    },
    success: function (response) {
      $('#dg_content').html(response)
    },
    error: function (jqXHR, textStatus, errorThrown) {
      set_message('Unable to load DG Goods')
      $('#dg_content').html('Unable to load DG Goods')
    },
    complete: function () {
      hideLoader()
    }
  })
}

function setInTransStatus(stop_status, status_type) {
  if ('4' !== stop_status && 'T' !== status_type) {
    return;
  }

  var shareLocationEligibleOrders = JSON.parse($('#shareLocationEligibleOrders').val());
  $.each(shareLocationEligibleOrders, function (key, val) {
    var thisSelect = $('button.pickup_btn[data-order-id=' + val + ']');
    var thisTail = thisSelect.attr('data-tail');
    setshipstopstatus(stop_status, 'T', thisTail, thisSelect);
  })
}

function setshipstopstatus(stop_status, status_type, tail, selected) {
  var status_stage = (status_type === 'T') ? 'IN_TRANSIT' : $(selected).attr('data-status')
  var data_order_id = $(selected).attr('data-order-id')
  if (status_type !== 'T' && localStorage.getItem(tail + '_' + status_stage)) {
    return false
  }

  var client_time_zone_offset = $('#client_time_zone_offset').val()
  var form = new FormData()
  var macadam_data = ''
  var comment = ''
  var d_missing_qty = ''
  if (status_type === 'P') {
    form.append('pickup_data', $('#pickup_data' + tail).val())
    macadam_data = $('#pickup_macadam_data' + tail).val()
    comment = $('#comment' + tail).val()
  } else if (status_type === 'T') {
    status_type = 'P';
    status_stage = 'IN_TRANSIT';
    var latLng = $('#geoLocationLatLng').val();
    const urlSearchParams = new URLSearchParams(latLng);
    const latLngParams = Object.fromEntries(urlSearchParams.entries());
    var inTransData = JSON.parse($('#pickup_data' + tail).val())
    delete inTransData.latitude;
    delete inTransData.longitude;
    inTransData['latitude'] = latLngParams.lat
    inTransData['longitude'] = latLngParams.lon
    form.append('pickup_data', JSON.stringify(inTransData))
    macadam_data = $('#pickup_macadam_data' + tail).val()
  } else if (status_type === 'D') {
    form.append('drop_data', $('#drop_data' + tail).val())
    macadam_data = $('#delivery_macadam_data' + tail).val()
    comment = $('#d_comment' + tail).val()
    var d_missing_qty_v = $('#d_missing_qty' + tail).val().trim()
    d_missing_qty = (d_missing_qty_v) ? d_missing_qty_v : ''
  }
  var pickup_POP_res = $('#pickup_POP_res' + tail).val()
  var delivery_POD_res = $('#delivery_POD_res' + tail).val()

  if (pickup_POP_res === 'err' || delivery_POD_res === 'err') {
    set_message('Picture/POD has some errors.')
    return false
  }
  if (status_stage.toUpperCase() === 'PICKUP') {
    status_stage = 'PICKUP_OK'
  }
  form.append('client_timezone_offset', client_time_zone_offset)
  form.append('status_stage', status_stage)
  form.append('status', stop_status)
  form.append('status_type', status_type)
  form.append('comment', comment);
  (d_missing_qty) ? form.append('missing_qty', d_missing_qty) : ''
  form.append('macadam_d3_data', pickup_POP_res)
  form.append('macadam_d3_POD_data', delivery_POD_res)
  var currentdate = new Date()
  var datetime = currentdate.getFullYear() + '-'
    + (currentdate.getMonth() + 1) + '-'
    + currentdate.getDate() + ' '
    + currentdate.getHours() + ':'
    + currentdate.getMinutes()
  form.append('status_manual_date', datetime)
  form.append('macadam_data', macadam_data)
  var shiftLegId = $('#shift_leg_id').val();
  var shipmentId = "";
  var earlyStatusId = "";
  var earlyStatusType = "";
  var earlylegno = 0;
  if (shiftLegId > 0 && stop_status == 274 && $('#trip_num').val() != '') {
    earlyStatusId = '281';
    earlyStatusType = 'D';
    shipmentId = $('#trip_num').val();
    var splitarray = shipmentId.split("-");
    var shipment = splitarray[0];
    var legno = splitarray[1];
    if (legno > 1) {
      earlylegno = legno - 1;
      form.append('earlyShipmentId', shipment + '-' + earlylegno);
      form.append('earlyStatusId', earlyStatusId);
      form.append('earlyStatusType', earlyStatusType);
    }
  }
  $('body').find('#preloader').show()

  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'POST',
      url: base_url + '/driversetshipstopstatus_multiple',
      processData: false,
      data: form,
      //async: false,
      contentType: false,
      cache: false,
      beforeSend: function () {
        showLoader()
        $(selected).attr('disabled', true)
        $('body .loading_roc').show()
        if (status_type === 'P') {
          $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
        } else {
          $('.pod_error' + tail).html('')
          $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
          $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
        }
      },
      success: function (response) {
        if (!response) {
          $(selected).prop('disabled', false)
          hideLoader()
          set_message('No Response from Server')
          resolve({ error: 'No Response from Server' })
          return
        }
        let parsed_response = JSON.parse(response)
        if (parsed_response.status == 0) {
          $(selected).prop('disabled', false)
          hideLoader()
          set_message(parsed_response.data)
          resolve({ error: parsed_response.data })
          return
        } else {
          $(selected).find('.btn_date_kn').html(parsed_response.return_time)
          var stage_name_cls = status_stage.toLowerCase()
          var stage_name = status_stage
          var kn_info_text = (stage_name === 'PICKUP_NOT_DONE' || stage_name === 'DELIVERY_NOT_DONE') ? '<span class="kn-info-text text-muted">' + driverapp_pickup_not_done_KN_message + '</span>' : ''
          var img_url_html = ''
          if (parsed_response.img_urls && parsed_response.img_urls.length) {
            $.each(parsed_response.img_urls, function (key, val) {
              img_url_html += '<a href="' + base_url + val.img_url + '" target="_blank">\n' +
                '<span class="attach_icon ml-0"><img src="' + base_url + '/assets/driverappv3/img/attachment.svg" alt="pickup_icon"></span>\n' +
                '</a>'
            })
          }

          var html_action = '<div class="animated animatedFadeInUp fadeInUp">\n' +
            '<h3>' +
            '	<span>' + lang_status[stage_name] + '</span> ' +
            '	<p style="display: inline; font-family: sans-serif !important;">' + parsed_response.return_time + '</p>'
            + img_url_html + kn_info_text +
            '</h3>\n' +
            ' </div>'
          var action_btn = ''
          $('#preloader').hide()
          if (status_type === 'P') {
            $('.pk_action_lables' + tail).append(html_action)
            action_btn = $('.action_btn_pk')
            clearAllFromsPK(tail)
          } else {
            $('.dl_action_lables' + tail).append(html_action)
            action_btn = $('.action_btn_dl')
            clearAllFromsDL(tail)
          }
          $(selected).removeClass('pnd_btn').addClass('active')
          var s = fileNameUrl($(selected).find('img').attr('src')).replace(/b/g, 'w')
          $(selected).find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)

          /*if (status_stage === 'DELIVERY_GATE_OUT') {
            $('.trip-completed.main-banner-area-four1').fadeIn()
            $('.topid-section').hide()
            $('.overlappBlock').hide()
          }*/

          var next_id = $(selected).data('next-id')
          var next_sel = $('#' + next_id)

          if (next_sel.attr('data-status') === 'DELIVERY_GATE_IN') {
            var pk_saved_status = $('#crd_act_p_' + tail).val().toUpperCase()
            setTimeout(function () {
              var this_order_id_x = next_sel.attr('data-order-id')
              if (this_order_id_x.charAt(0) === ('d' || 'P')) {
                this_order_id_x = this_order_id_x.slice(2)
              }
              var pk_sel = $(document).find('body button[data-order-id=\'' + this_order_id_x + '\'][data-status=\'PICKUP_GATE_OUT\'] ')
              var isNotDisabled = pk_saved_status !== 'PICKUP_NOT_DONE' && (pk_sel.hasClass('active2') || pk_sel.hasClass('active'))
              next_sel.prop('disabled', !isNotDisabled)
            }, 500)
          } else {
            next_sel.prop('disabled', false)
          }

          if (stage_name === 'DELIVERY_GATE_IN') {
            shareLocationEligibleBtn(data_order_id, 'POP');
          }
          if (parseInt(stop_status) === 281) {
            // gate-out happend
            let stops_left_val = parseInt($('#stops_left_val').html().trim())
            if (stops_left_val > 0) {
              $('#stops_left_val').html(stops_left_val - 1)
              completedStops(stops_left_val - 1)
              var sel_vi = $('#crd_act_' + status_type.toLowerCase() + '_' + tail).val()
              $('#icon_' + status_type.toLowerCase() + '_' + tail).addClass('complete').addClass(sel_vi.toLowerCase())
              var this_order_id = $(selected).attr('data-order-id')
              if (stage_name_cls === 'pickup_gate_out') {
                var dis = 0
                $.each($(document).find('body button[data-order-id=\'d_' + this_order_id + '\']'), function () {
                  if (!$(this).hasClass('active2') && dis === 0) {
                    dis++
                    var __this_doc = $(document).find('body button[data-status=\'PICKUP_NOT_DONE\'][data-order-id=\'' + this_order_id + '\']')
                    $(this).attr('disabled', __this_doc.attr('data-status') === 'PICKUP_NOT_DONE')
                    $(document).find('body div.dl_sec_' + this_order_id).css({
                      'border': '2px solid #66ccf3',
                      'border-left': '4px solid #1E319D'
                    })
                  }
                })
                shareLocationEligibleBtn(this_order_id);
              }
            } // TODO are completed

          } else {
            selected.value = parsed_response.return_time
          }
          localStorage.setItem(tail + '_' + status_stage, true)
          if (status_stage === 'IN_TRANSIT' && stop_status === '278') {
            var shareLocationCountEle = $('#share_location_count')
            var shareLocationCount = shareLocationCountEle.val()
            shareLocationCount++;
            shareLocationCountEle.val(shareLocationCount);
          }
          shareLocationCountShow();
          /*if (status_stage !== 'DELIVERY_GATE_OUT') {
            window.location.reload();
          }*/
          console.log('came here')
          if (status_stage === 'DELIVERY_GATE_OUT') {
            var totalDeliveries = $('button[data-status="DELIVERY_GATE_OUT"]').length;
            var last_tail = totalDeliveries - 1;
            if (parseInt(tail) != last_tail) {
              window.location.reload();
            }
          }
          else {
            window.location.reload();
          }
        }
      },
      error: function (jqXHR, textStatus, errorThrown) {
        var errorsResponse = JSON.parse(jqXHR.responseText);
        var errorMessages = '';
        $.each(errorsResponse.data, function (key, val) {
          errorMessages += '<p>' + val + '</p>';
        });
        $(selected).prop('disabled', false)
        hideLoader()
        $('.modal1').css({ 'width': '310px' })
        set_message(errorMessages)
        if (status_type === 'P') {
          $('#confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false).prop('disabled',false)
        } else {
          $('#d_confirm_close' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false).prop('disabled',false)
          $('#d_confirm_close_pod' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false).prop('disabled',false)
        }
        resolve({ error: errorThrown })
      },
      complete: function () {
        hideLoader()
        $('#pickup_POP_res' + tail).val('')
        $('#delivery_POD_res' + tail).val('')
        resolve()
        //window.location.reload()
      }
    })
  })
}

function do_action_after_click_btn_in_pop(tail) {
  $('#btn_com_pic_sec' + tail).show()
  $('.pk_action_lables' + tail).hide()
  from_check('pod_sign_uploads', 'confirm_close', tail)
}

function d_do_action_after_click_btn_in_pop(tail) {
  $('#d_btn_com_pic_sec' + tail).show()
  $('.dl_action_lables' + tail).hide()
  $('#deliveryModal_pod' + tail).hide()
  $('.dl_heading').show()
  $('.error').html('')
  from_check('d_pod_sign_uploads', 'd_confirm_close', tail)
}

function pk_done(tail) {
  $('#damage' + tail).attr('disabled', true)
  $('#notdone' + tail).attr('disabled', true)
  $('#c_asterisk' + tail).attr('style', 'display:none !important')
  $('#comment' + tail).removeAttr('required')
  $('#p_asterisk' + tail).attr('style', 'display:none !important')
  $('#picture' + tail).removeAttr('required')
  do_action_after_click_btn_in_pop(tail)
}

function pk_damang(tail) {
  $('#done' + tail).attr('disabled', true)
  $('#notdone' + tail).attr('disabled', true)
  $('#c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#comment' + tail).attr('required', true)
  $('#p_asterisk' + tail).attr('style', 'display:flex !important; top: 15px; background: transparent;')
  $('#picture' + tail).attr('required', true)
  do_action_after_click_btn_in_pop(tail)
}

function pk_notdone(tail) {
  $('#done' + tail).attr('disabled', true)
  $('#damage' + tail).attr('disabled', true)
  $('#picture' + tail).removeAttr('required')
  $('#c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#comment' + tail).attr('required', true)
  $('#p_asterisk' + tail).attr('style', 'display:none !important')
  do_action_after_click_btn_in_pop(tail)
}

function d_done(tail) {
  $('#d_comment' + tail).removeAttr('required')
  $('#d_c_asterisk' + tail).attr('style', 'display:none !important')
  $('.d_missing_qty_blk' + tail).hide()
  $('#d_missing_qty' + tail).attr('required', false)
  $('#d_p_asterisk' + tail).attr('style', 'display:none !important')
  $('#d_picture' + tail).removeAttr('required')
  d_do_action_after_click_btn_in_pop(tail)
}

function d_damage(tail) {
  $('.d_missing_qty_blk' + tail).hide()
  $('#d_missing_qty' + tail).attr('required', false)
  $('#d_c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#d_comment' + tail).attr('required', true)
  $('#d_p_asterisk' + tail).attr('style', 'display:flex !important; top: 15px; background: transparent;')
  $('#d_picture' + tail).attr('required', true)
  d_do_action_after_click_btn_in_pop(tail)
}

function d_short(tail) {
  $('.d_missing_qty_blk' + tail).show()
  $('#d_missing_qty' + tail).attr('required', true)
  $('#d_c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#d_comment' + tail).attr('required', true)
  $('#d_p_asterisk' + tail).attr('style', 'display:none !important')
  $('#d_picture' + tail).attr('required', false)
  d_do_action_after_click_btn_in_pop(tail)
}

function d_notdone(tail) {
  $('#d_picture' + tail).removeAttr('required')
  $('.d_missing_qty_blk' + tail).hide()
  $('#d_missing_qty' + tail).attr('required', false)
  $('#d_p_asterisk' + tail).attr('style', 'display:none !important')
  $('#d_c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#d_comment' + tail).attr('required', true)
  d_do_action_after_click_btn_in_pop(tail)
}

function d_refused(tail) {
  $('#d_picture' + tail).removeAttr('required')
  $('.d_missing_qty_blk' + tail).hide()
  $('#d_missing_qty' + tail).attr('required', false)
  $('#d_p_asterisk' + tail).attr('style', 'display:none !important')
  $('#d_c_asterisk' + tail).attr('style', 'display:flex !important')
  $('#d_comment' + tail).attr('required', true)
  d_do_action_after_click_btn_in_pop(tail)
}

function from_check(form_id, confirm_btn_id, tail) {
  var r = 0
  $('form#' + form_id + tail).find('input[type!=hidden],textarea').each(function () {
    var ele = $(this)
    var val = ele.val().trim()
    if (ele.prop('required') && (val === '' || val === undefined)) {
      r++
    }
  })
  if (r > 1) {
    $('#' + confirm_btn_id + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
  } else {
    $('#' + confirm_btn_id + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
  }
  return r;
}

function fileNameUrl(extension) {
  /*var s = extension.replace(/\\/g, '/')
  s = s.substring(s.lastIndexOf('/') + 1)
  return extension ? s.replace(/[?#].+$/, '') : s.split('.')[0]*/
  if (typeof extension !== 'string') return '';

  var s = extension.replace(/\\/g, '/');
  s = s.substring(s.lastIndexOf('/') + 1);
  return s.replace(/[?#].+$/, '');
}

function remove_active(selected_block) {
  $.each(selected_block, function () {
    if ($(this).hasClass('active')) {
      var s = fileNameUrl($(this).find('img').attr('src')).replace(/b/g, 'w')
      $(this).find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
      $(this).removeClass('active')
    }
  })
}

function add_active(select_b) {
  var s = fileNameUrl(select_b.find('img').attr('src')).replace(/w/g, 'b')
  select_b.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  select_b.addClass('active')
}

function allFormReset(tail) {
  $('form').each(function () {
    $(this)[0].reset()
    $(this).find('#fname' + tail).text(driverapp_attachment)
    $(this).find('#d_fname_pod' + tail).text(driverapp_attachment)
    $(this).find('#d_fname' + tail).text(driverapp_attachment)
    $(this).find('.imagePreview').hide()
    $(this).find('.imageAddCam').show()
  })
}

function clearAllFromsPK(tail) {
  $('#pickup_act_ico' + tail).hide()
  $('.pk_action_lables' + tail).show()
  $('#btn_com_pic_sec' + tail).hide()
  $('.pk_heading').find('span').html('')
  remove_active($('.action_btn_pk'))
  allFormReset(tail)
}

function setpickupdata(stop_status, status_type, tail, selected) {
  $('#pickup_act_ico' + tail).show()
  $('#closebtn' + tail).click(function () {
    window.location.reload()
  })
  $('form#pod_sign_uploads' + tail).on('change', function () {
    from_check('pod_sign_uploads', 'confirm_close', tail)
  })
  var s = fileNameUrl($(selected).find('img').attr('src')).replace(/b/g, 'w')
  $(selected).find('img').attr('src', base_url + 'assets/driverappv3/img/' + s).addClass('active')

  // $('#pkdone' + tail).click(function () {
  //   remove_active($('.action_btn_pk'))
  //   add_active($(this))
  //   stop_status = 1
  //   $(selected).attr('data-status', 'PICKUP_OK')
  //   $('.pk_heading').find('span').html(' - ' + lang_status_h3['DONE'])
  //   pk_done(tail)
  // })



  $(document).ready(function () {

    $(document).on('change', 'input[type=radio].action_btn_pk', function () {
      var tail = this.id.replace('pkdone', ''); // extract i from id="pkdone<?= $i ?>"
      if (this.id.startsWith('pkdone')) {
        $('.pickDone-hideshow').hide();
        $('#btn_com_pic_sec' + tail).show();
        $('.pk_heading').find('span').html(' - ' + lang_status_h3['DONE']);
        $('#pickdone_heading' + tail).find('span').html(' - ' + lang_status_h3['DONE'])
        stop_status = 285
        $(selected).attr('data-status', 'PICKUP_OK')
        remove_active($('.action_btn_pk'))
        add_active($(this))
        pk_done(tail);
      }
    });
  });

  $('#pickupok').modal('show');

  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_pk', function () {
      var tail = this.id.replace('pkdamage', ''); // extract i from id="pkdone<?= $i ?>"
      if (this.id.startsWith('pkdamage')) {
        $('.pickDone-hideshow').hide();
        $('#btn_com_pic_sec' + tail).show();
        $('.pk_heading').find('span').html(' - ' + lang_status_h3['BROKEN']);
        $('#pickdone_heading' + tail).find('span').html(' - ' + lang_status_h3['BROKEN'])
        stop_status = 12
        $(selected).attr('data-status', 'PICKUP_BROKEN')
        remove_active($('.action_btn_pk'))
        add_active($(this))
        pk_damang(tail)
      }
    });
  });
  $('#pickupok').modal('show');

  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_pk', function () {
      var tail = this.id.replace('pknotdone', '');
      if (this.id.startsWith('pknotdone')) {
        $('.pickDone-hideshow').hide();
        $('#btn_com_pic_sec' + tail).show();
        $('.pk_heading').find('span').html(' - ' + lang_status_h3['NOT_DONE']);
        $('#pickdone_heading' + tail).find('span').html(' - ' + lang_status_h3['NOT_DONE'])
        stop_status = 13
        $(selected).attr('data-status', 'PICKUP_NOT_DONE')
        remove_active($('.action_btn_pk'))
        add_active($(this))
        pk_notdone(tail)
      }
    });
  });

  $('#picture' + tail).change(function (e) {
    const ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'picture' + tail, 'picture_base64' + tail, tail)
      }
      $('#fname' + tail).text(file)
      $('#picture_file_name' + tail).val(file)
    } else {
      $(this).val('')
    }
  })

  $('#picture_cam' + tail).change(function (e) {
    const ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'picture_cam' + tail, 'picture_base64_cam' + tail, tail)
      }
      $('#fname' + tail).text(file)
      $('#picture_file_name' + tail).val(file)
    } else {
      $(this).val('')
    }
  })

  $('#confirm_close' + tail).click(async function () {
    $('#status_id' + tail).val(stop_status)
    var curr_status = $(selected).attr('data-status')
    var this_p = $('#btnfile' + tail)
    var this_c = $('#comment' + tail)
    var comment = this_c.val().trim()
    var picture = $('#picture' + tail).val().trim()
    if (picture == "") {
      picture = $('#picture_cam' + tail).val().trim()
    }

    if (curr_status === 'PICKUP_BROKEN') {
      if (comment === '' || comment === undefined) {
        showError(this_c, comment_error)
      } else {
        this_c.css('border-bottom', ' 2px solid #154da1')
      }
      if (picture === '' || picture === undefined) {
        showError(this_p, select_picture_error)
      } else {
        this_p.css('border-bottom', ' 2px solid #154da1')
      }
    } else if (curr_status === 'PICKUP_NOT_DONE') {
      if (comment === '' || comment === undefined) {
        showError(this_c, comment_error)
      } else {
        this_c.css('border-bottom', ' 2px solid #154da1')
      }
    }
    $('body .loading_roc').show()

    if (picture) {
      freez_submit_buttons()
      var uploadPictureResponse = await upload_pod_package_image(tail, 'pod_sign_uploads', 'picture', selected)
      if (uploadPictureResponse && uploadPictureResponse.error) {
        return
      }
    }
    var data_status = $(selected).attr('data-status')
    $('#crd_act_p_' + tail).val((data_status) ? data_status.toLowerCase() : '')
    await setshipstopstatus(stop_status, status_type, tail, selected)
    $('#pickupok').modal('hide')
    window.location.reload()
  })
}

function clearAllFromsDL(tail) {
  $('#delivery_act_ico' + tail).hide()
  $('.dl_action_lables' + tail).show()
  $('#d_btn_com_pic_sec' + tail).hide()
  $('#deliveryModal_pod' + tail).hide()
  $('.dl_heading').show().find('span').html('')


  remove_active($('.action_btn_dl'))
  allFormReset(tail)
}

function setdeliverydata(stop_status, status_type, tail, selected) {
  var dl_action_form = $('form#d_pod_sign_uploads' + tail)
  dl_action_form.on('change', function () {
    from_check('d_pod_sign_uploads', 'd_confirm_close', tail)
  })
  dl_action_form.on('keyup', function () {
    from_check('d_pod_sign_uploads', 'd_confirm_close', tail)
  })
  dl_action_form.on('keypress', function () {
    from_check('d_pod_sign_uploads', 'd_confirm_close', tail)
  })
  $('#delivery_act_ico' + tail).show()
  $('#d_closebtn' + tail).click(function () {
    window.location.reload()
  })


  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_dl', function () {
      var tail = this.id.replace('d_done', '');
      if (this.id.startsWith('d_done')) {
        $('.dropDone-hideshow').hide();
        $('#d_btn_com_pic_sec' + tail).show();

        $('.dl_heading').show().find('span').html(' - ' + lang_status_h3['DONE']);
        $('#delivered_heading' + tail).find('span').html(' - ' + lang_status_h3['DONE']);
        stop_status = 280
        $(selected).attr('data-status', 'DELIVERED')
        d_done(tail);
        $('#d_confirm_close' + tail).attr('data-nxt-type', 'n').text(next_label);

      }
    });
  });

  $('#deliveryok').modal('show');

  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_dl', function () {
      var tail = this.id.replace('d_damage', '');
      if (this.id.startsWith('d_damage')) {
        $('.dropDone-hideshow').hide();
        $('#d_btn_com_pic_sec' + tail).show();
        $('.dl_heading').show().find('span').html(' - ' + lang_status_h3['DAMAGE']);
        $('#delivered_heading' + tail).find('span').html(' - ' + lang_status_h3['DAMAGE']);
        stop_status = 12;
        $(selected).attr('data-status', 'DELIVERED_WITH_DAMAGE');
        d_damage(tail);
        $('#d_confirm_close' + tail).attr('data-nxt-type', 'n').text(next_label)

      }
    });
  });

  $('#deliveryok').modal('show');

  // 5 => +ve status
  // 8 => -ve status

  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_dl', function () {
      var tail = this.id.replace('d_short', '');
      if (this.id.startsWith('d_short')) {
        $('.dropDone-hideshow').hide();
        $('#d_btn_com_pic_sec' + tail).show();
        $('.dl_heading').show().find('span').html(' - ' + lang_status_h3['SHORT']);
        $('#delivered_heading' + tail).find('span').html(' - ' + lang_status_h3['SHORT']);
        stop_status = 13
        $(selected).attr('data-status', 'DELIVERY_SHORT')
        d_short(tail);
        $('#d_confirm_close' + tail).attr('data-nxt-type', 'n').text(next_label)

      }
    });
  });

  $('#deliveryok').modal('show');


  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_dl', function () {
      var tail = this.id.replace('d_notdone', '');
      if (this.id.startsWith('d_notdone')) {
        $('.dropDone-hideshow').hide();
        $('#d_btn_com_pic_sec' + tail).show();
        $('.dl_heading').show().find('span').html(' - ' + lang_status_h3['NOT_DONE']);
        $('#delivered_heading' + tail).find('span').html(' - ' + lang_status_h3['NOT_DONE']);
        stop_status = 14
        $(selected).attr('data-status', 'DELIVERY_NOT_DONE')
        d_notdone(tail);
        $('#d_confirm_close' + tail).attr('data-nxt-type', 'n').text(confirm_close_label)

      }
    });
  });

  $('#deliveryok').modal('show');
  $(document).ready(function () {
    $(document).on('change', 'input[type=radio].action_btn_dl', function () {
      var tail = this.id.replace('d_refused', '');
      if (this.id.startsWith('d_refused')) {
        $('.dropDone-hideshow').hide();
        $('#d_btn_com_pic_sec' + tail).show();
        $('.dl_heading').show().find('span').html(' - ' + lang_status_h3['REFUSED']);
        $('#delivered_heading' + tail).find('span').html(' - ' + lang_status_h3['REFUSED']);
        stop_status = 15
        $(selected).attr('data-status', 'DELIVERY_REFUSED')
        d_refused(tail);
        $('#d_confirm_close' + tail).attr('data-nxt-type', 'n').text(next_label)

      }
    });
  });
  $('#d_btnfile' + tail).click(function () {
    $('#d_picture' + tail).trigger('click')
  })
  $('#deliveryok').modal('show');

  $('#d_picture' + tail).change(function (e) {
    var ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'd_picture' + tail, 'd_picture_base64' + tail, tail)
      }
      $('#d_fname' + tail).text(file)
      $('#d_picture_file_name' + tail).val(file)
    } else {
      $(this).val('')
      return false
    }
  });

  $('#d_picture_cam' + tail).change(function (e) {
    var ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'd_picture_cam' + tail, 'd_picture_base64_cam' + tail, tail)
      }
      $('#d_fname' + tail).text(file)
      $('#d_picture_file_name' + tail).val(file)
    } else {
      $(this).val('')
      return false
    }
  });

  // Restricts input for the set of matched elements to the given inputFilter function.
  (function ($) {
    $.fn.inputFilter = function (inputFilter) {
      return this.on('input keydown keyup mousedown mouseup select contextmenu drop', function () {
        if (inputFilter(this.value)) {
          this.oldValue = this.value
          this.oldSelectionStart = this.selectionStart
          this.oldSelectionEnd = this.selectionEnd
        } else if (this.hasOwnProperty('oldValue')) {
          this.value = this.oldValue
          this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd)
        } else {
          this.value = ''
        }
      })
    }
  }(jQuery))

  $('#d_missing_qty' + tail).on('keyup input blur', function (event) {
    var val = $(this).val()
    while (parseInt(val.charAt(0)) === 0) {
      val = val.substr(1)
    }
    $(this).val(val)
    $(this).inputFilter(function (value) {
      return /^\d*$/.test(value)	// Allow digits only, using a RegExp
    })
  })

  $('#d_btnfile_pod' + tail).click(function () {
    $('#d_picture_pod' + tail).trigger('click')
  })

  $('#d_picture_pod' + tail).change(function (e) {
    var ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      readURL(this, 'prev_pod' + tail)
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'd_picture_pod' + tail, 'd_picture_base64_pod' + tail, tail)
      }
      $('#d_fname_pod' + tail).text(file)
      $('#d_picture_file_name_pod' + tail).val(file)
    } else {
      $(this).val('')
      return false
    }
  })

  $('#d_picture_pod_cam' + tail).change(function (e) {
    var ext = $(this).val().split('.').pop().toLowerCase()
    if (ext && check_ext(ext, e)) {
      readURL(this, 'prev_pod' + tail)
      let file = $(this).val().replace(/C:\\fakepath\\/ig, '')
      if (ext === 'png' || ext === 'jpg' || ext === 'jpeg') {
        do_compress(e, 'd_picture_pod_cam' + tail, 'd_picture_base64_pod_cam' + tail, tail)
      }
      $('#d_fname_pod' + tail).text(file)
      $('#d_picture_file_name_pod' + tail).val(file)
    } else {
      $(this).val('')
      return false
    }
  })

  $('#d_confirm_close' + tail).click(async function () {
    $('#d_status_id' + tail).val(stop_status)
    var curr_status = $(selected).attr('data-status')
    var this_p = $('#d_btnfile' + tail)
    var this_c = $('#d_comment' + tail)
    var this_mq = $('#d_missing_qty' + tail)
    var picture = $('#d_picture' + tail).val().trim()
    if (picture == "") {
      picture = $('#d_picture_cam' + tail).val().trim()
    }
    var missing_qty = this_mq.val().trim()
    var comment = this_c.val().trim()

    if (curr_status === 'DELIVERY_NOT_DONE' || curr_status === 'DELIVERY_REFUSED') {
      if (comment === '' || comment === undefined) {
        showError(this_c, comment_error)
      } else {
        this_c.css('border-bottom', ' 2px solid #154da1')
      }
    }

    if (curr_status === 'DELIVERED_WITH_DAMAGE' || curr_status === 'DELIVERY_SHORT') {
      if (curr_status === 'DELIVERY_SHORT') {
        while (missing_qty.charAt(0) == '0') {
          missing_qty = missing_qty.substr(1)
        }
        this_mq.val(missing_qty)
        if (missing_qty === '' || missing_qty === undefined || missing_qty == 0) {
          showError(this_mq, missing_qty_error)
        }
      }

      if (comment === '' || comment === undefined) {
        showError(this_c, comment_error)
      } else {
        this_c.css('border-bottom', ' 2px solid #154da1')
      }
      if (picture === '' || picture === undefined) {
        showError(this_p, select_picture_error)
      } else {
        this_p.css('border-bottom', ' 2px solid #154da1')
      }
    }

    var data_status = $(selected).attr('data-status')
    $('#crd_act_d_' + tail).val((data_status) ? data_status.toLowerCase() : '')
    let cur_sec = $('#d_confirm_close' + tail).attr('data-nxt-type')
    let dl_action_from_pod = $('form#d_pod_sign_uploads_pod' + tail)
    dl_action_from_pod.on('change', function () {
      from_check('d_pod_sign_uploads_pod', 'd_confirm_close_pod', tail)
    })
    dl_action_from_pod.on('keyup', function () {
      from_check('d_pod_sign_uploads_pod', 'd_confirm_close_pod', tail)
    })

    $('.back_iconbtn' + tail).click(function () {
      /*	$('#d_btn_com_pic_sec' + tail).show();
        $('#deliveryModal_pod' + tail).hide();*/
      window.location.reload()
    })

    if (cur_sec === 'n') {
      $('#deliveryModal_pod' + tail).show()
      $('.dropMain-hideshow').find('button').each(function () {
        $(this).attr('disabled', true)
      })
      $('.dl_heading').hide()
      $('#d_btn_com_pic_sec' + tail).hide()
      $('#d_confirm_close_pod' + tail).click(async function () {
        $('#d_sign' + tail).trigger('blur')

        if (picture) {
          freez_submit_buttons(tail)
          var uploadPictureResponse = await upload_pod_package_image(tail, 'd_pod_sign_uploads', 'picture', selected)
          if (uploadPictureResponse && uploadPictureResponse.error) {
            return
          }
        }

        var POD = $('#d_picture_pod' + tail).val().trim()
        if (POD == "") {
          POD = $('#d_picture_pod_cam' + tail).val().trim()
        }
        if (POD) {
          freez_submit_buttons(tail)
          var uploadPODResponse = await upload_pod_package_image(tail, 'd_pod_sign_uploads_pod', 'POD', selected)
          if (uploadPODResponse && uploadPODResponse.error) {
            return
          } // response will be undefined if the promise is resolved
        }
        await setshipstopstatus(stop_status, status_type, tail, selected)
        $('#deliveryModal_pod' + tail).modal('hide');
        $('#deliveryok').modal('hide');
        window.location.reload()
      })
    } else {
      if (picture) {
        freez_submit_buttons(tail)
        var uploadPictureResponse = await upload_pod_package_image(tail, 'd_pod_sign_uploads', 'picture', selected)
        if (uploadPictureResponse && uploadPictureResponse.error) {
          return
        }
      }
      await setshipstopstatus(stop_status, status_type, tail, selected)
      $('#deliveryModal_pod' + tail).modal('hide');
      $('#deliveryok').modal('hide');
      window.location.reload()
    }
  })

  $('#d_sign' + tail).on('blur, keyup', function () {
    var sign = $(this)
    var sign_v = sign.val()
    if (sign_v === '' || sign_v === undefined) {
      showError(sign, signee_name_error)
    } else {
      $('#d_confirm_close_pod' + tail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false).prop('disabled',false)
    }
  })
}

function showLoader() {
  $('body .loading_roc').css('display', '')
}

function hideLoader() {
  $('body .loading_roc').css('display', 'none')
}

function upload_pod_package_image(tail, FromSelect, ImgStoreType = '', selected) {
  var curr_status = $(selected).attr('data-status')
  if (localStorage.getItem(tail + '_' + ImgStoreType + '_' + curr_status)) {
    return false
  }

  var form = $('#' + FromSelect + tail)[0]
  var data = new FormData(form)
  var imgURI = ''
  showLoader()
  if (FromSelect === 'pod_sign_uploads') {
    imgURI = $('#picture_base64' + tail).val()
    imgURI1 = $('#picture_base64_cam' + tail).val()

    if (imgURI) {
      data.append('file_name', imagetoblob(imgURI), $('#picture_file_name' + tail).val())
    }
    else {
      data.append('file_name', imagetoblob(imgURI1), $('#picture_file_name' + tail).val())
    }
  }
  if (FromSelect === 'd_pod_sign_uploads') {
    imgURI = $('#d_picture_base64' + tail).val()
    imgURI1 = $('#d_picture_base64_cam' + tail).val()

    if (imgURI) {
      data.append('file_name', imagetoblob(imgURI), $('#d_picture_file_name' + tail).val())
    }
    else {
      data.append('file_name', imagetoblob(imgURI1), $('#d_picture_file_name' + tail).val())
    }
  }
  if (FromSelect === 'd_pod_sign_uploads_pod') {
    imgURI = $('#d_picture_base64_pod' + tail).val()
    imgURI1 = $('#d_picture_base64_pod_cam' + tail).val()

    if (imgURI) {
      data.append('file_name', imagetoblob(imgURI), $('#d_picture_file_name_pod' + tail).val())
    }
    else {
      data.append('file_name', imagetoblob(imgURI1), $('#d_picture_file_name_pod' + tail).val())
    }
  }
  data.append('img_store_type', ImgStoreType)
  if (ImgStoreType === 'POD') {
    var sign_v = $('#d_sign' + tail).val()
    data.append('rev_sign', sign_v)
  }
  curr_status = $(selected).attr('data-status')
  data.append('status_stage', curr_status)
  return new Promise((resolve) => {
    $.ajax({
      type: 'POST',
      enctype: 'multipart/form-data',
      url: base_url + '/Driverappv3/poduploads',
      data: data,
      processData: false,
      contentType: false,
      cache: false,
      beforeSend: function () {
        freez_submit_buttons(tail)
      },
      success: function (data) {
        hideLoader()
        var res = JSON.parse(data)
        var resHiddenId = ImgStoreType === 'POD' ? 'delivery_POD_res' : 'pickup_POP_res'
        if (parseInt(res.status) === 1) {
          $('#' + resHiddenId + tail).val(JSON.stringify(res.res))
        } else {
          $('#' + resHiddenId + tail).val('err')
          $('.pod_error' + tail).html(res.data)
          set_message(res.data)
          resolve({ error: res.data })
        }
        localStorage.setItem(tail + '_' + ImgStoreType + '_' + curr_status, true)
        resolve()
      },
      error: function (e) {
        hideLoader()
        set_message(e.statusText)
        resolve({ error: e.statusText })
      },
      complete: function (e) {
        hideLoader()
      }
    })
  })
}

$(function () {
  $(document).on('cut copy paste', 'input', function (e) {
    e.preventDefault()
  })
})

window.onbeforeunload = function () {
  document.getElementById('preloader').style.display = 'block'
}
document.onreadystatechange = function () {
  var state = document.readyState
  if (state === 'interactive') {
    // document.getElementById('preloader').style.display="block";
  } else if (state === 'complete') {
    setTimeout(function () {
      document.getElementById('interactive')
      document.getElementById('preloader').style.display = 'none'
    }, 1)
  }
}

function setStops() {
  let wrapperx = $('#body_div')
  let stopsLeft = parseInt(wrapperx.find('#stops_left').val())
  wrapperx.find('#stops_left_val').text(stopsLeft)
  completedStops(stopsLeft)
  lang_status = JSON.parse($('#lang_status').val())
  lang_status_h3 = JSON.parse($('#lang_status_h3').val())
  setTimeout(function () {
    shareLocationCountShow()
  }, 100);
  localStorage.clear()
  checkActionCard()
}

function completedStops(stopsLeft) {
  if (stopsLeft === 0) {
    $('.trip-block').hide()
    $('.trip-completed').show()
  } else {
    $('.trip-block').show()
    $('.trip-completed').hide()
  }
}

var shareLocationCountShow = function () {
  const allowedDriverCountriesToShare = JSON.parse($('#secure_link_in_trans_share_location_allowed_countries').val());
  const companyCode = $('#company_code').val();
  if (jQuery.inArray(companyCode, allowedDriverCountriesToShare) === -1) {
    return false;
  }
  var _shareLocationEligibleOrders = $('#shareLocationEligibleOrders');
  var shareLocationEligibleOrders = JSON.parse(_shareLocationEligibleOrders.val());
  var s = '';
  if (shareLocationEligibleOrders.length < 1) {
    const shareLocBtnEle = $('#shareLocationBtn')
    shareLocBtnEle.attr('disabled', true)
    shareLocBtnEle.removeClass('shadow-card')
    s = fileNameUrl(shareLocBtnEle.find('img').attr('src')).replace(/w/g, 'b')
    shareLocBtnEle.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  } else {
    const shareLocBtnEle = $('#shareLocationBtn')
    shareLocBtnEle.attr('disabled', false)
    shareLocBtnEle.addClass('shadow-card')
    s = fileNameUrl(shareLocBtnEle.find('img').attr('src')).replace(/b/g, 'w')
    shareLocBtnEle.find('img').attr('src', base_url + 'assets/driverappv3/img/' + s)
  }

  var locationSharedCount = $('#share_location_count').val()
  if (locationSharedCount > 0) {
    $('#shareLocationBtn').addClass('complete').addClass('delivery_share_location_count');
  }
  if (locationSharedCount > 9) {
    $('.share-location-count-label').css('left', '35px');
  }
  const locationSharedCountEle = $('#locationSharedCount')
  locationSharedCountEle.html(locationSharedCount)
  locationSharedCountEle.css('display', locationSharedCount > 0 ? 'block' : 'none');
}

var shareLocationEligibleBtn = function (orderID, Action = 'PUSH') {
  const allowedDriverCountriesToShare = JSON.parse($('#secure_link_in_trans_share_location_allowed_countries').val());
  const companyCode = $('#company_code').val();
  if (jQuery.inArray(companyCode, allowedDriverCountriesToShare) === -1) {
    return false;
  }
  // pickup phase done -> enable share location
  var _shareLocationEligibleOrders = $('#shareLocationEligibleOrders');
  var shareLocationEligibleOrders = JSON.parse(_shareLocationEligibleOrders.val());

  if (Action === 'PUSH') {
    shareLocationEligibleOrders.push(orderID)
  }
  if (Action === 'POP') {
    orderID = orderID.replace(/d\_/i, "");
    const index = shareLocationEligibleOrders.indexOf(orderID);
    if (index > -1) {
      shareLocationEligibleOrders.splice(index, 1);
    }
  }

  $('#shareLocationBtnLabelCount').html(shareLocationEligibleOrders.length);
  _shareLocationEligibleOrders.val(JSON.stringify(shareLocationEligibleOrders));
}

var checkActionCard = function () {
  $.each($('.active2 '), function () {
    var data_tail = $(this).attr('data-tail')
    var data_status = $(this).attr('data-status')
    var this_order_id = $(this).attr('data-order-id')
    if (data_status === 'PICKUP_GATE_OUT' || data_status === 'DELIVERY_GATE_OUT') {
      var status_type = data_status.charAt(0)
      var sel_vi = $('#crd_act_' + status_type.toLowerCase() + '_' + data_tail).val()
      $('#icon_' + status_type.toLowerCase() + '_' + data_tail).addClass('complete').addClass(sel_vi.toLowerCase())
      if (data_status === 'PICKUP_GATE_OUT') {
        var dis = 0
        var pk_saved_status = $('#crd_act_p_' + data_tail).val().toUpperCase()
        $.each($(document).find('body button[data-order-id=\'d_' + this_order_id + '\']'), function () {
          if (!$(this).hasClass('active2') && dis === 0 && pk_saved_status !== 'PICKUP_NOT_DONE') {
            dis++
            $(this).attr('disabled', false)
            $(document).find('body div.dl_sec_' + this_order_id).css({
              'border': '2px solid #66ccf3',
              'border-left': '4px solid #1E319D'
            })
          }
        })
        shareLocationEligibleBtn(this_order_id);
      }
    }
    if (data_status === 'DELIVERY_GATE_IN') {
      shareLocationEligibleBtn(this_order_id, 'POP');
    }
  })
}

function change_language() {
  var final_lang = $('#final_lang').val()
  if (final_lang.length < 3) {
    set_message('Please select valid language')
    return false
  }
  var form = new FormData()
  form.append('language', final_lang)
  $.ajax({
    type: 'POST',
    url: base_url + 'driversite_language2',
    processData: false,
    data: form,
    contentType: false,
    cache: false,
    beforeSend: function () {
      $('body .loading_roc').show()
      showLoader()
    },
    success: function (response) {
      var res = JSON.parse(response)
      if (parseInt(res.status) === 1) {
        window.location.reload()
      } else {
        set_message(res.response)
      }
    },
    error: function (jqXHR, textStatus, errorThrown) {
      hideLoader()
      set_message('Error Occurred.')
    }
  })
}

let check_ext = function (ext, event) {
  if ($.inArray(ext, ['png', 'tif', 'jpg', 'bmp', 'jpeg', 'pdf']) === -1) {
    alert(invalid_file_error)
    event.preventDefault()
    return false
  }
  return true
}

var freez_submit_buttons = function (tail) {
  $('#confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
  $('#d_confirm_close' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
  $('#d_confirm_close_pod' + tail).removeClass('btn-kn').addClass('btn-disabled').attr('disabled', true)
}

var showError = function (select, error_msg) {
  select.css('border-bottom', ' 2px solid tomato')
  select.next('span.error').show()
  select.next('span.error').html(error_msg)
  return false
}

function checkFormField(fieldClassName, ErrorMessage = invalid_input_error) {
  const field = $('.' + fieldClassName)
  const fieldTail = field.attr('data-tail')
  var fieldValue = field.val()
  if (fieldValue === '' || fieldValue === undefined) {
    showError(field, ErrorMessage)
    return;
  } else {
    field.css('border-bottom', ' 2px solid #1E319D')
    $('#confirm_user_reg' + fieldTail).removeClass('btn-disabled').addClass('btn-kn').attr('disabled', false)
  }
  from_check('driver_registration_from', 'confirm_user_reg', fieldTail)
  return fieldValue;
}


$(document).on('keyup blur', '.driverNameCheck', function () {
  checkFormField('driverNameCheck', driver_name_error);
})
$(document).on('keyup blur', '.mobileNumberCheck', function () {
  checkFormField('mobileNumberCheck', mobile_number_error);
})
$(document).on('keyup blur', '.truckRegNumberCheck', function () {
  checkFormField('truckRegNumberCheck', truck_reg_num_error);
})

$.ajaxSetup({
  beforeSend: showLoader,
  complete: hideLoader
});

function driverRegistrationFromSubmit() {
  const formEleId = 'driver_registration_from';
  const submitBtnId = 'confirm_user_reg';
  const tail = 0;
  var driverNameValue = checkFormField('driverNameCheck', driver_name_error)
  var mobileNumberValue = checkFormField('mobileNumberCheck', mobile_number_error)
  var truckRegNumberValue = checkFormField('truckRegNumberCheck', truck_reg_num_error)
  var submitBtnStatus = from_check(formEleId, submitBtnId, tail)
  const shipment_id = $('#shipment_id').val()
  const secure_token = $('#secure_token').val()
  const country_code = $('#country_code').val()
  const secure_link_device_uuid = $('#secure_link_device_uuid').val();
  const device_info = $('#device_info').val();

  if (submitBtnStatus) {
    return false;
  } else {
    const url = base_url + '/Driverappv3/save_driver_data';
    let data = {
      driver_name: driverNameValue,
      mobile_number: mobileNumberValue,
      truck_reg_number: truckRegNumberValue,
      shipment_id: shipment_id,
      secure_token: secure_token,
      country_code: country_code,
      device_uuid: secure_link_device_uuid,
      device_info: device_info
    }

    $.post(url, data).then(function (res) {
      const resData = JSON.parse(res)
      if (resData.status === 1) {
        getsecureview(secure_token)
      } else {
        set_message(resData.message);
      }
    }).fail(function (err) {
      set_message(err);
      return false;
    })

  }
}
