"use strict";
$.fn.HereObject = function (input) {
	var inputData = {
        apiKey : null,
        eleId : null,
        center: {lat: 50, lng: 5}, 
        zoom: 4,
        traffic:false,
        trafficIncidents:false,
        success: function () {}
    };
    var params = $.extend(inputData, input); 
    // Initialize the platform object:
    platform = new H.service.Platform({
      'apikey': params.apiKey
    });
    var defaultLayers = platform.createDefaultLayers();
    
    //Step 2: initialize a map - this map is centered over Europe
    map = new H.Map(document.getElementById(params.eleId),
        defaultLayers.vector.normal.map,{
        center: params.center,
        zoom: params.zoom,
        pixelRatio: window.devicePixelRatio || 1
    });
    map.getViewPort().setPadding(50, 50, 50, 50);
    // add a resize listener to make sure that the map occupies the whole container
    window.addEventListener('resize', () => map.getViewPort().resize());
    
    //Step 3: make the map interactive
    // MapEvents enables the event system
    // Behavior implements default interactions for pan/zoom (also on mobile touch environments)
    var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));
    
    // Create the default UI components
    var ui = H.ui.UI.createDefault(map, defaultLayers);
    if(params.traffic){
    	map.addLayer(defaultLayers.vector.normal.traffic);
    }
    if(params.trafficIncidents){
    	map.addLayer(defaultLayers.vector.normal.trafficincidents);
    }

    params.success(map,platform);
    return this;
};