/*start Billing partner*/
$('.form-control').keypress(function () {
  if ($('.form-control').hasClass('errorclass')) {
    $('.form-control').removeClass('errorclass')
  }
})
$('.form-control').click(function () {
  if ($('.form-control').hasClass('errorclass')) {
    $('.form-control').removeClass('errorclass')
  }
})

function gettoast (position, id, desp) {
  /*$('#'+id).focus();*/
  if (!$('#' + id).hasClass('errorclass')) {
    $('#' + id).addClass('errorclass')
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  })
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>' + desp + '</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout: 900
  })
}

function viewroletypelist (type) {
  var group = $('#groupname').val()
  if (group.length > 0) {
    var table = $('#role_tab').DataTable()
    table.destroy()
    $('#view_roletype').modal('show')
    if (type == 'Customer') {
      $('#view_roletype_title').html('Customer List')
    } else if (type = 'Carrier') {
      $('#view_roletype_title').html('Vendor Type List')
    } else {
      $('#view_roletype_title').html('Role Type List')
    }
    $.ajax({
      url: baseurl + 'billing/viewroletypelist',
      type: 'POST',
      data: { 'type': type },
      dataType: 'JSON',
      success: function (data) {
        $('#role_tab').DataTable({
          data: data,
          'bPaginate': true,
          'bsearch': true,
          'paging': true,
          'bLengthChange': true,
          'bFilter': true,
          'bInfo': false,
          'bAutoWidth': true,
          'language': {
            'lengthMenu': '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          'columns': [
            { 'data': 'check' },
            { 'data': 'code' },
            { 'data': 'name' },
            { 'data': 'email_id' },
            { 'data': 'company_code' },
            { 'data': 'branch_code' },
          ],
        })
      }
    })
  } else {
    gettoast('top-right', 'bill_group', 'Please Select Bill Group')
    return false
  }
}

function selectrolebyid (id) {
  $('.rolelist').removeClass('roleselected-list')
  $('#rolelist_' + id).addClass('roleselected-list')
  $('selectedrole').attr('onclick', 'selectroleinlist()')
}

function selectvendorbyid (id) {
  $('.vendorlist').removeClass('vendorselected-list')
  $('#vendorlist_' + id).addClass('vendorselected-list')
  $('.selectedrole').attr('onclick', 'selectvendordetailsbyid()')
}

function selectroleinlist () {
  var id = $('.roleselected-list').val()
  $.ajax({
    url: baseurl + 'billing/getshipperdetailsbyID',
    type: 'post',
    data: { id: id },
    dataType: 'json',
    success: function (data) {
      $('#view_roletype').modal('hide')
      var response = data.customer_details
      var code = response.code
      var name = response.name
      var branch_code = response.branch_code
      $('#partner_cid').val(code)
      $('#customercode').val(code)
      $('#name').val(name)
      $('#branch_code').val(branch_code)
      $('#partner_debitor_code').val(code)
    }
  })
}

function selectvendordetailsbyid () {
  var id = $('.vendorselected-list').val()
  var groupname = $('#groupname').val()
  if (groupname == 'invoice') {
    $.ajax({
      url: baseurl + 'billing/getvendordetailsbyID',
      type: 'post',
      data: { id: id },
      dataType: 'json',
      success: function (data) {
        $('#view_roletype').modal('hide')
        $('#partner_cid').val(data.code)
        $('#customercode').val(data.code)
        $('#partner_debitor_code').val(data.code)
        $('#name').val(data.name)
        $('#branch_code').val(data.branch_code)
      }
    })
  } else {
    var id = $('.roleselected-list').val()
    $.ajax({
      url: baseurl + 'billing/getshipperdetailsbyID',
      type: 'post',
      data: { id: id },
      dataType: 'json',
      success: function (data) {
        $('#view_roletype').modal('hide')
        var response = data.customer_details
        var code = response.code
        var name = response.name
        var branch_code = response.branch_code
        $('#partner_cid').val(code)
        $('#customercode').val(code)
        $('#partner_debitor_code').val(code)
        $('#name').val(name)
        $('#branch_code').val(branch_code)
      }
    })
  }
}

function selectpartiesbyid (id) {
  $('.twopartieslist').removeClass('partiesselected-list')
  $('#twopartieslist_' + id).addClass('partiesselected-list')
  $('.selectedrole').attr('onclick', 'selectpartiesdetailsbyid()')
}

function selectpartiesdetailsbyid () {
  var id = $('.partiesselected-list').val() ? $('.partiesselected-list').val() : $('#partner_cid').val();
  var branch_code = $('#branch_code').val();
  var groupname = $('#groupname').val();
   var customernumber=$('input[name=selectparties]:checked').attr('id');
  var customerid=customernumber.split("_");
  var customer_company=$('#customer_company_'+customerid[1]).val();
  var type = 'Customer';
  if (groupname == 'invoice') {
    var type = 'Carrier'
  }
  $.ajax({
    url: baseurl + 'billing/getpartnerdetailsbyID',
    type: 'post',
    data: { id: id, type: type, branch_code: branch_code, customer_company:customer_company },
    dataType: 'json',
    success: function (data) {
      $('#view_roletype').modal('hide')
      $('#customercode').val(data.customer_code)
	  $('#bill_type').val(data.invoice_type);
      $('#name').val(data.name)
      $('#partner_cid').val(data.code)
      $('#partner_debitor_code').val(data.acon)
      $('#customercode').removeClass('errorclass');
      // $('#branch_code').val(data.branch_code);
      var data = data.tobebilled
      var table = $('#newbill').DataTable()
      table.destroy()
      $('#newbill tbody').empty()
      if (data.length > 0) {
        $('#newbill').DataTable({
          data: data,
          'createdRow': function (row, data, dataIndex) {
            $(row).attr('class', 'trkid')
            $(row).attr('id', data.rev_cosid)
          },
          'bPaginate': true,
          'paging': true,
          'bLengthChange': true,
          'bInfo': false,
          'bFilter': false,
          'bAutoWidth': true,
          'language': {
            'lengthMenu': '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          iDisplayLength: -1,
          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          'columns': [
            { 'data': 'tdvalue' },
            { 'data': 'order_id' },
            { 'data': 'createdon' },
            { 'data': 'shipper' },
            { 'data': 'pickup_city' },
            { 'data': 'pickup_pincode' },
            { 'data': 'pickup_country' },
            { 'data': 'consignee' },
            { 'data': 'delivery_city' },
            { 'data': 'delivery_pincode' },
            { 'data': 'delivery_country' },
            { 'data': 'transport_mode' },
            { 'data': 'amount' },
            { 'data': 'currency' },
          ],
        })
      } else {
        gettoast('top-right', 'customercode', 'No Pending bills for the selected customer or vendor')
        return false
      }
    }
  })
}

function savebill (event, savetype) {
  event.preventDefault()
  var status = event.target.value
  $('#status').val(status)
  var bill_type = $('#bill_type').val()
  var bill_group = $('#bill_group').val()
  var customercode = $('#customercode').val()
  var company_code = $('#company_code').val()
  var name = $('#name').val()
  var branch_code = $('#branch_code').val()
  var partner_cid = $('#partner_cid').val()
  var debitor_code = $('#partner_debitor_code').val()
  var invoice_date = $('#fromDatemin').val()
  var bill_status = $('#bill_status').val()
  var billtablelen = $('#newbill tr').length
  var invoice_description_len = ''
  if ($('#invoice_description').length) {
    var invoice_description_len = $('#invoice_description').val()
  }
  var trknocbox = []
  $('input:checkbox[class=tracking_no]:checked').each(function () {
    trknocbox.push({
      'ids': $(this).val()
    })
  })
  var trknorbut = []
  $('input:radio[class=trackingno]:checked').each(function () {
    trknorbut.push({
      'ids': $(this).val()
    })
  })
  if (bill_group.length == 0) {
    gettoast('top-right', 'bill_group', 'Please Select Bill Group')
    return false
  } else if (customercode.length == 0) {
    gettoast('top-right', 'customercode', 'Please Select Customer Code')
    return false
  } else if (bill_type.length == 0) {
    gettoast('top-right', 'bill_type', 'Please Select Bill Type')
    return false
  } else if (company_code.length == 0) {
    gettoast('top-right', 'company_code', 'Please Enter Company Code')
    return false
  } else if (name.length == 0) {
    gettoast('top-right', 'name', 'Please Enter Name')
    return false
  } else if (partner_cid.length == 0) {
    gettoast('top-right', 'partner_cid', 'Please Enter CID')
    return false
  } else if (branch_code.length == 0) {
    gettoast('top-right', 'branch_code', 'Please Enter Branch Code')
    return false
  } else if (debitor_code.length == 0) {
    gettoast('top-right', 'partner_debitor_code', 'Please Enter Account Debitor Code')
    return false
  } else if (invoice_date.length == 0) {
    gettoast('top-right', 'fromDatemin', 'Please Enter Invoice Date')
    return false
  } else if (bill_status.length == 0) {
    gettoast('top-right', 'bill_status', 'Please Select Bill Status')
    return false
  } else if (bill_type == 1 && trknorbut.length == 0 && billtablelen > 1) {
    gettoast('top-right', 'bill_type', 'Please Select One Tracking Number')
    $('.trackingno').focus()
    return false
  } else if (bill_type == 2 && trknocbox.length == 0 && billtablelen > 1) {
    gettoast('top-right', 'bill_type', 'Please Select Atleast One Tracking Number')
    $('.tracking_no').focus()
    return false
  } else if (billtablelen == 1 || billtablelen == 0) {
    gettoast('top-right', 'customercode', 'No Pending bills for the selected customer or vendor')
    return false
  } else if (invoice_description_len != '' && invoice_description_len.length > 500) {
      gettoast('top-right', 'invoice_description', 'Invoice Description Supports Maximum 500 Characters')
      $('.invoice_description').focus()
      return false
  } else {
    if (bill_type == 2 && trknocbox.length > 0) {
      /* if(savetype == '2'){*/
      var a = 0
      var ids = []
      $('.noorder_trip_sts').each(function () {
        var notrip_id = $(this).attr('id')
        ids.push($(this).attr('id'))
      })
      if (ids.length > 0) {
        $('.tracking_no:checked').each(function () {
          var checked_id = $(this).attr('id')
          if (checked_id > 0) {
            var chck = jQuery.inArray(checked_id, ids)
            if (chck >= '0') {
              a++
            }
          }
        })
      }
      if (a > 0) {
        gettoast('top-right', '', 'Selected Tracking no. contains Pending Order(s)')
        $('.tracking_no').focus()
        return false
      }
      /*   }*/
    }
    if (bill_type == 1 && trknorbut.length > 0) {
      /* if(savetype == '2'){*/
      var chck = '-1'
      var ids = []
      $('.noorder_trip_sts').each(function () {
        var notrip_id = $(this).attr('id')
        ids.push($(this).attr('id'))
      })
      if (ids.length > 0) {
        var checked_id = $('input[name=\'trackingno\']:checked').val()
        var chck = jQuery.inArray(checked_id, ids)
      }
      if (chck >= '0') {
        gettoast('top-right', '', 'Selected Tracking no. contains Pending Order(s)')
        $('.trackingno').focus()
        return false
      }
      /* }*/
    }
    var datastring = $('#bill_data').serialize()
    var baseurl1 = baseurl + 'billing/insertbilldata/'
    var url = baseurl1
    $.ajax({
      url: url,
      type: 'POST',
      dataType: 'json',
      data: datastring,
      beforeSend: function () {
        $(':input[type="submit"]').prop('disabled', true)
      },
      success: function (data) {
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          location.href = baseurl + 'billing'
        })
      },
      error: function (errMsg) {
        $('.pop_message').html('Oops! Something went wrong')
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          location.href = baseurl + 'billing'
        })
      }
    })
    return false
  }
}

function updatebill (event, savetype) {
  event.preventDefault()
  var status = event.target.value
  $('#status').val(status)
  var bill_type = $('#bill_type').val()
  var bill_group = $('#bill_group').val()
  var customercode = $('#customercode').val()
  var company_code = $('#company_code').val()
  var name = $('#name').val()
  var branch_code = $('#branch_code').val()
  var partner_cid = $('#partner_cid').val()
  var debitor_code = $('#partner_debitor_code').val()
  var invoice_date = $('#fromDatemin').val()
  var bill_status = $('#bill_status').val()
  var invoice_description_len = ''
  if ($('#invoice_description').length) {
    var invoice_description_len = $('#invoice_description').val()
  }
  var trknocbox = []
  $('input:checkbox[class=tracking_no]:checked').each(function () {
    trknocbox.push({
      'ids': $(this).val()
    })
  })
  var trknorbut = []
  $('input:radio[class=trackingno]:checked').each(function () {
    trknorbut.push({
      'ids': $(this).val()
    })
  })
  if (bill_group.length == 0) {
    gettoast('top-right', 'bill_group', 'Please Select Bill Group')
    return false
  } else if (customercode.length == 0) {
    gettoast('top-right', 'customercode', 'Please Select Customer Code')
    return false
  } else if (bill_type.length == 0) {
    gettoast('top-right', 'bill_type', 'Please Select Bill Type')
    return false
  } else if (company_code.length == 0) {
    gettoast('top-right', 'company_code', 'Please Enter Company Code')
    return false
  } else if (name.length == 0) {
    gettoast('top-right', 'name', 'Please Enter Name')
    return false
  } else if (partner_cid.length == 0) {
    gettoast('top-right', 'partner_cid', 'Please Enter CID')
    return false
  } else if (branch_code.length == 0) {
    gettoast('top-right', 'branch_code', 'Please Enter Branch Code')
    return false
  } else if (debitor_code.length == 0) {
    gettoast('top-right', 'partner_debitor_code', 'Please Enter Account Debitor Code')
    return false
  } else if (invoice_date.length == 0) {
    gettoast('top-right', 'fromDatemin', 'Please Enter Invoice Date')
    return false
  } else if (bill_status.length == 0) {
    gettoast('top-right', 'bill_status', 'Please Select Bill Status')
    return false
  } else if (bill_type == 1 && trknorbut.length == 0) {
    gettoast('top-right', 'bill_type', 'Please Select One Tracking Number')
    $('.trackingno').focus()
    return false
  } else if (bill_type == 2 && trknocbox.length == 0) {
    gettoast('top-right', 'bill_type', 'Please Select Atleast One Tracking Number')
    $('.tracking_no').focus()
    return false
  } else if (invoice_description_len != '' && invoice_description_len.length > 500) {
      gettoast('top-right', 'invoice_description', 'Invoice Description Supports Maximum 500 Characters')
      $('.invoice_description').focus()
      return false
  } else {
    if (bill_type == 2 && trknocbox.length > 0) {
      /*  if(savetype == '2'){*/
      var a = 0
      var ids = []
      $('.noorder_trip_sts').each(function () {
        var notrip_id = $(this).attr('id')
        ids.push($(this).attr('id'))
      })
      if (ids.length > 0) {
        $('.tracking_no:checked').each(function () {
          var checked_id = $(this).attr('id')
          if (checked_id > 0) {
            var chck = jQuery.inArray(checked_id, ids)
            if (chck >= '0') {
              a++
            }
          }
        })
      }
      if (a > 0) {
        gettoast('top-right', '', 'Selected Tracking no. contains Pending Order(s)')
        $('.tracking_no').focus()
        return false
      }
      /*   }*/
    }
    if (bill_type == 1 && trknorbut.length > 0) {
      /* if(savetype == '2'){*/
      var chck = '-1'
      var ids = []
      $('.noorder_trip_sts').each(function () {
        var notrip_id = $(this).attr('id')
        ids.push($(this).attr('id'))
      })
      if (ids.length > 0) {
        var checked_id = $('input[name=\'trackingno\']:checked').val()
        var chck = jQuery.inArray(checked_id, ids)
      }
      if (chck >= '0') {
        gettoast('top-right', '', 'Selected Tracking no. contains Pending Order(s)')
        $('.trackingno').focus()
        return false
      }
      /*  }*/
    }
    var data = $('#bill_data').serialize()
    var baseurl1 = baseurl + 'billing/updatebill/'
    var url = baseurl1
    $.ajax({
      url: url,
      type: 'POST',
      dataType: 'json',
      data: data,
      beforeSend: function () {
        $(':input[type="submit"]').prop('disabled', true)
      },
      success: function (data) {
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          location.href = baseurl + 'billing'
        })
      },
      error: function (errMsg) {
        $('.pop_message').html('Oops! Something went wrong')
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          location.href = baseurl + 'billing'
        })
      }
    })
    return false
  }
}

function updatecreditdebitnote (event) {
  event.preventDefault()
  var status = event.target.value
  var invoice_date = $('#fromDatemin').val()
  var billid = $('#billid').val()
  if (invoice_date.length == 0) {
    gettoast('top-right', 'fromDatemin', 'Please Select Invoice Date')
    $('#fromDatemin').focus()
    return false
  } else {
    var baseurl1 = baseurl + 'billing/updatecreditdebitnote/'
    var url = baseurl1
    $.ajax({
      url: url,
      type: 'POST',
      dataType: 'json',
      data: { 'billid': billid, 'status': status, 'invoice_date': invoice_date },
      beforeSend: function () {
        $(':input[type="submit"]').prop('disabled', true)
      },
      success: function (data) {
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          location.href = baseurl + 'billing'
        })
      },
    })
    return false
  }
}

function checkbillbeforeDelete (bid) {
  event.preventDefault()
  var id = bid.toString()
  $.ajax({
    url: baseurl + 'billing/deletebill/' + id,
    beforeSend: function () {
    },
    success: function (data) {
      if (data == '1') {
        $('.popup_circle').removeClass('glyphicon-remove-circle')
        $('.popup_circle').addClass('glyphicon-ok-circle')
        $('.popup_circle').css('color', 'green')
        $('.pop_message').html('Record Deleted Successfully !!')
        $('#insert_success_div').modal('show')
        $('.success_redirect').on('click', function () {
          window.location.reload()
        })
      } else {
        $('#dialog_box').dialog()
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog_text').text('Oops...something went wrong')
        e.preventDefault()
      }
    }
  })
}

function billsfilter (event) {
  event.preventDefault()
  var billid = $('#billid').val()
  var bill_type = $('#bill_type').val()
  var customercode = $('#partner_cid').val()
  var groupname = $('#groupname').val()
  var earlypickupfrom = $('#earlypickupfrom').val()
  var earlypickupto = $('#earlypickupto').val()
  var earlydeliveryfrom = $('#earlydeliveryfrom').val()
  var earlydeliveryto = $('#earlydeliveryto').val()
  var pickupfrom = $('#pickupfrom').val()
  var pickupto = $('#pickupto').val()
  var deliveryfrom = $('#deliveryfrom').val()
  var deliveryto = $('#deliveryto').val()
  var order_status = $('#order_status').val()
  var doc_status = $('#doc_status').val()
  var order_reftype = $('#order_reftype').val()
  var ref_val = $('#ref_val').val()
  var department_code = $('#department_code').val()
  var bookingid = $('#bookingid').val()
  var type = 'Customer'
  if (groupname == 'invoice') {
    var type = 'Carrier'
  }
  if (customercode.length > 0) {
    $.ajax({
      url: baseurl + 'billing/billsfilter',
      type: 'post',
      data: {
        customercode: customercode,
        type: type,
        billid: billid,
        bill_type: bill_type,
        earlypickupfrom: earlypickupfrom,
        earlypickupto: earlypickupto,
        earlydeliveryfrom: earlydeliveryfrom,
        earlydeliveryto: earlydeliveryto,
        pickupfrom: pickupfrom,
        pickupto: pickupto,
        deliveryfrom: deliveryfrom,
        deliveryto: deliveryto,
        order_status: order_status,
        doc_status: doc_status,
        order_reftype: order_reftype,
        ref_val: ref_val,
        department_code: department_code, bookingid: bookingid
      },
      dataType: 'json',
      success: function (data) {
        var data = data.tobebilled
        var table = $('#newbill').DataTable()
        table.destroy()
        $('#newbill tbody').empty()
        if (data.length > 0) {
          $('#newbill').DataTable({
            data: data,
            'createdRow': function (row, data, dataIndex) {
              $(row).attr('class', 'trkid')
              $(row).attr('id', data.rev_cosid)
            },
            'bPaginate': true,
            'paging': true,
            'bLengthChange': true,
            'bInfo': false,
            'bFilter': false,
            'bAutoWidth': true,
            'language': {
              'lengthMenu': '<select class="form-control">' +
                '<option value="10">10</option>' +
                '<option value="20">20</option>' +
                '<option value="30">30</option>' +
                '<option value="40">40</option>' +
                '<option value="50">50</option>' +
                '<option value="-1">All</option>' +
                '</select>'
            },
            iDisplayLength: -1,
            dom: 'Blfrtip',
            buttons: [
              'copyHtml5',
              'excelHtml5',
              'csvHtml5',
              'pdfHtml5',
              'print'
            ],
            'columns': [
              { 'data': 'tdvalue' },
              { 'data': 'order_id' },
              { 'data': 'createdon' },
              { 'data': 'shipper' },
              { 'data': 'pickup_city' },
              { 'data': 'pickup_pincode' },
              { 'data': 'pickup_country' },
              { 'data': 'consignee' },
              { 'data': 'delivery_city' },
              { 'data': 'delivery_pincode' },
              { 'data': 'delivery_country' },
              { 'data': 'transport_mode' },
              { 'data': 'amount' },
              { 'data': 'currency' },
            ],
          })
        } else {
          gettoast('top-right', 'customercode', 'No Pending bills for the selected combination')
          return false
        }
      }
    })
  }
}

/*   function saverevisedamount(id,amount,event){
       event.preventDefault();
        var currentRow= $(this).closest("tr"); 
        var referenceid = currentRow.find("td:eq(4) input").val().trim();
       alert(referenceid);
     }*/
$(document).ready(function () {
  $('#updatenote').click(function (e) {
    var billid = $('#billid').val()
    if (billid.length > 0) {
      $.ajax({
        url: baseurl + 'billing/updatenotestatus/',
        type: 'POST',
        dataType: 'json',
        data: { 'billid': billid },
        success: function (data) {
          if (data.status == 1) {
            $('#insert_success_div').modal('show')
            $('.success_redirect').on('click', function () {
              location.href = baseurl + 'billing'
            })
          } else {
            $('#alerterror').modal('show')
          }
        },
      })
      return false
    }
  })
  $('#chargecodesrev').on('click', '#chargesave', function () {
    var currentRow = $(this).closest('tr')
    var amount = currentRow.find('td:eq(3)').text().trim()
    var revisedamount = currentRow.find('td:eq(4) input').val().trim()
    var chargeid = currentRow.attr('id') /*charge id*/
    if (parseFloat(revisedamount) <= parseFloat(amount)) {
      $.ajax({
        url: baseurl + 'billing/updatecharges',
        type: 'POST',
        dataType: 'json',
        data: { 'chargeid': chargeid, 'revisedamount': revisedamount },
        success: function (data) {
          if (data.status == 1) {
            $('.pop_message').html('Credit Amount Updated Successfully!')
            $('#insert_success_div').modal('show')
          } else {
            $('#alerterror').modal('show')
          }
        },
      })
    } else {
      $('#alertcharge').modal('show')
      $('.chargeok').on('click', function () {
        currentRow.find('td:eq(4) input active').focus()
      })
    }
  })
  $('#company_code').autocomplete({
    source: function (request, response) {
      $.ajax({
        url: baseurl + 'orders/getcompanyname',
        type: 'POST',
        dataType: 'json',
        data: {
          term: request.term,
        },
        success: function (data) {
          if (data.length == '0') {
            $('#dialog').dialog()
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('.ui-dialog').addClass('alert_zindex')
            $('#dialog-text').html('Please enter a correct value in company')
            $('.ui-dialog-titlebar-close').click(function () {
              $('#company_code').val('')
              $('#company_code').focus()
            })
          } else {
            response($.map(data, function (item) {
                return { id: item.id, value: item.company_code }
              })
            )
          }
        }
      })
    }, select: function (event, ui) {
      $(this).val(ui.item.label)
      var id = ui.item.value
      $('#shipper_company_code').val(id)
      $('#party_company_id').val(id)
      $('#consignee_company_code').val(id)
      return false
    }
  })
  $('#nbcmcode').autocomplete({
    source: function (request, response) {
      $.ajax({
        url: baseurl + 'orders/getcompanyname',
        type: 'POST',
        dataType: 'json',
        data: {
          term: request.term,
        },
        success: function (data) {
          if (data.length == '0') {
            $('#dialog').dialog()
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('.ui-dialog').addClass('alert_zindex')
            $('#dialog-text').html('Please enter a correct value in company')
            $('.ui-dialog-titlebar-close').click(function () {
              $('#nbcmcode').val('')
              $('#nbcmcode').focus()
            })
          } else {
            response($.map(data, function (item) {
                return { id: item.id, value: item.company_code }
              })
            )
          }
        }
      })
    }, appendTo: $('#create_view_branch')
  })
  $('#ndcmcode').autocomplete({
    source: function (request, response) {
      $.ajax({
        url: baseurl + 'orders/getcompanyname',
        type: 'POST',
        dataType: 'json',
        data: {
          term: request.term,
        },
        success: function (data) {
          if (data.length == '0') {
            $('#dialog').dialog()
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('.ui-dialog').addClass('alert_zindex')
            $('#dialog-text').html('Please enter a correct value in company')
            $('.ui-dialog-titlebar-close').click(function () {
              $('#ndcmcode').val('')
              $('#ndcmcode').focus()
            })
          } else {
            response($.map(data, function (item) {
                return { id: item.id, value: item.company_code }
              })
            )
          }
        }
      })
    }, appendTo: $('#create_view_department')
  })
  $('#ndbmcode').autocomplete({
    source: function (request, response) {
      var cmp_code = $('#ndcmcode').val()
      if (cmp_code != '') {
        $.ajax({
          url: baseurl + 'orders/getbranchbycompany',
          type: 'POST',
          dataType: 'json',
          data: {
            term: request.term,
            cmp_code: cmp_code
          },
          success: function (data) {
            response($.map(data, function (item) {
                return { id: item.id, value: item.branch_code }
              })
            )
            if (data.length == '0') {
              $('#dialog').dialog()
              $('.ui-dialog-title').addClass('fa fa-warning')
              $('.ui-dialog').addClass('alert_zindex')
              $('#dialog-text').html('Please enter a correct value in Branch')
              $('.ui-dialog-titlebar-close').click(function () {
                $('#ndbmcode').val('')
                $('#ndbmcode').focus()
              })
            }
          }
        })
      } else {
        $('#dialog').dialog()
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('.ui-dialog').addClass('alert_zindex')
        $('#dialog-text').html('Please enter a value in company')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ndbmcode').val('')
          $('#ndcmcode').focus()
        })
      }
    }, appendTo: $('#create_view_department')
  })

  function findcompanylist (e) {
    e.preventDefault()
    var company = $('#company_code').val()
    if (company != '') {
      $('#view_company').modal('show')
      $('#view_company_title').html('Company Detials')
      var table = $('#company_tab').DataTable()
      table.destroy()
      var name = $('#company_code').val()
      $.ajax({
        url: baseurl + 'orders/findcountrybyname',
        type: 'POST',
        data: { 'name': name },
        dataType: 'JSON',
        success: function (data) {
          $('#company_tab').DataTable({
            data: data,
            'language': {
              'lengthMenu': 'Display _MENU_ ',
              'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
              'info': 'Showing page _PAGE_ of _PAGES_',
              'infoEmpty': 'No Records Available',
              'infoFiltered': '(filtered from _MAX_ total records)'
            },
            'columns': [
              { 'data': 'check' },
              { 'data': 'company_name' },
              { 'data': 'company_code' },
              { 'data': 'description' },
            ],
          })
        }
      })
    } else {
      $('#dialog').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('#dialog-text').html('Please enter a value in company')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#company_code').focus()
      })
    }
  }

  function viewcompanylist (e) {
    e.preventDefault()
    var table = $('#company_tab').DataTable()
    table.destroy()
    $('#view_company').modal('show')
    $('#view_company_title').html('List Of Companies')
    //    $('#show_data').html("");
    $.ajax({
      url: baseurl + 'orders/viewcompanylist',
      type: 'POST',
      dataType: 'JSON',
      success: function (data) {
        $('#company_tab').DataTable({
          data: data,
          'language': {
            'lengthMenu': 'Display _MENU_ ',
            'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
            'info': 'Showing page _PAGE_ of _PAGES_',
            'infoEmpty': 'No Records Available',
            'infoFiltered': '(filtered from _MAX_ total records)'
          },
          'columns': [
            { 'data': 'check' },
            { 'data': 'company_name' },
            { 'data': 'company_code' },
            { 'data': 'description' },
          ],
        })
      }
    })
  }

  function createviewcompany (e) {
    $('.add_company').val('')
    $('#create_view_company').modal('show')
  }

  function newcompanyadd (e) {
    var company_name = $('#ncname').val()
    var company_code = $('#nccode').val()
    var description = $('#ncdescrpt').val()
    if (company_name != '' && company_code != '') {
      $.ajax({
        url: baseurl + 'orders/addcompanydetails',
        type: 'POST',
        data: { 'company_name': company_name, 'company_code': company_code, 'description': description },
        success: function (data) {
          if (data == '2') {
            $('#dialog').dialog()
            $('.ui-dialog').addClass('alert_zindex')
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('#dialog-text').html('Data already exists')
            $('.ui-dialog-titlebar-close').click(function () {
              $('.add_company').val('')
            })
          } else {
            $('#insert_success_div').modal('show')
            $('#create_view_company').modal('hide')
          }
        }
      })
    } else {
      if (company_name == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('please enter Company Name')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ncname').focus()
        })
      } else if (company_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Company Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#nccode').focus()
        })
      }
    }
  }

  function searchviewcompany (e) {
    e.preventDefault()
    var company = $('#company_code').val()
    if (company != '') {
      var table = $('#company_tab').DataTable()
      table.destroy()
      $('#view_company').modal('show')
      $('#view_company_title').html('Search Company Detials')
      $.ajax({
        url: baseurl + 'orders/getcompanyname',
        type: 'POST',
        data: { 'term': company },
        dataType: 'JSON',
        success: function (data) {
          $('#company_tab').DataTable({
            data: data,
            'language': {
              'lengthMenu': 'Display _MENU_ ',
              'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
              'info': 'Showing page _PAGE_ of _PAGES_',
              'infoEmpty': 'No Records Available',
              'infoFiltered': '(filtered from _MAX_ total records)'
            },
            'columns': [
              { 'data': 'check' },
              { 'data': 'company_name' },
              { 'data': 'company_code' },
              { 'data': 'description' },
            ],
          })
        }
      })
    } else {
      $('#dialog').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('#dialog-text').html('Please enter a value in company')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#company_code').focus()
      })
    }
  }

  function createviewbranch (e) {
    $('.add_branch').val('')
    $('#create_view_branch').modal('show')
  }

  function newbranchadd (e) {
    e.preventDefault()
    var branch_name = $('#nbname').val()
    var branch_code = $('#nbcode').val()
    var description = $('#nbdescrpt').val()
    var company_code = $('#nbcmcode').val()
    if (branch_name != '' && branch_name != '' && company_code != '') {
      $.ajax({
        url: baseurl + 'orders/addbranchdetails',
        type: 'POST',
        data: { 'branch_name': branch_name, 'branch_code': branch_code, 'description': description, 'company_code': company_code },
        success: function (data) {
          if (data == '2') {
            $('#dialog').dialog()
            $('.ui-dialog').addClass('alert_zindex')
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('#dialog-text').html('Data already exists')
            $('.ui-dialog-titlebar-close').click(function () {
              $('.add_branch').val('')
            })
          } else {
            $('#insert_success_div').modal('show')
            $('#create_view_branch').modal('hide')
          }
        }
      })
    } else {
      if (branch_name == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Branch Name')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#nbname').focus()
        })
      } else if (branch_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Branch Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#nbcode').focus()
        })
      } else if (company_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Company Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#nbcode').focus()
        })
      }
    }
  }

  function finddepartmentlist (e) {
    e.preventDefault()
    var department = $('#department_code').val()
    if (department != '') {
      var table = $('#department_tab').DataTable()
      table.destroy()
      $('#view_department').modal('show')
      $('#view_department_title').html('Department Detials')
      var name = $('#department_code').val()
      $.ajax({
        url: baseurl + 'orders/finddepartmentlist',
        type: 'POST',
        data: { 'name': name },
        success: function (data) {
          $('#department_tab').DataTable({
            data: data,
            'language': {
              'lengthMenu': 'Display _MENU_ ',
              'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
              'info': 'Showing page _PAGE_ of _PAGES_',
              'infoEmpty': 'No Records Available',
              'infoFiltered': '(filtered from _MAX_ total records)'
            },
            'columns': [
              { 'data': 'check' },
              { 'data': 'department_name' },
              { 'data': 'department_code' },
              { 'data': 'branch_code' },
              { 'data': 'company_code' },
              { 'data': 'description' },
            ],
          })
        }
      })
    } else {
      $('#dialog').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('#dialog-text').html('Please enter a value in department')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#department_code').focus()
      })
    }
  }

  function searchviewdepartment (e) {
    e.preventDefault()
    var department = $('#department_code').val()
    if (department != '') {
      var table = $('#department_tab').DataTable()
      table.destroy()
      $('#view_department').modal('show')
      $('#view_department_title').html('Department Detials')
      var name = $('#department_code').val()
      $.ajax({
        url: baseurl + 'orders/finddepartmentlikelist',
        type: 'POST',
        data: { 'name': name },
        success: function (data) {
          $('#department_tab').DataTable({
            data: data,
            'language': {
              'lengthMenu': 'Display _MENU_ ',
              'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
              'info': 'Showing page _PAGE_ of _PAGES_',
              'infoEmpty': 'No Records Available',
              'infoFiltered': '(filtered from _MAX_ total records)'
            },
            'columns': [
              { 'data': 'check' },
              { 'data': 'department_name' },
              { 'data': 'department_code' },
              { 'data': 'branch_code' },
              { 'data': 'company_code' },
              { 'data': 'description' },
            ],
          })
        }
      })
    } else {
      $('#dialog').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('#dialog-text').html('Please enter a value in department')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#department_code').focus()
      })
    }
  }

  function viewdepartmentlist (e) {
    e.preventDefault()
    var table = $('#department_tab').DataTable()
    table.destroy()
    var company_code = $('#company_code').val()
    var branch_code = $('#branch_code').val()
    $('#view_department').modal('show')
    $('#view_department_title').html('List Of Department')
    $.ajax({
      url: baseurl + 'orders/viewdepartmentlist',
      type: 'POST',
      data: { branch_code: branch_code, company_code: company_code },
      dataType: 'JSON',
      success: function (data) {
        $('#department_tab').DataTable({
          data: data,
          'language': {
            'lengthMenu': 'Display _MENU_ ',
            'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
            'info': 'Showing page _PAGE_ of _PAGES_',
            'infoEmpty': 'No Records Available',
            'infoFiltered': '(filtered from _MAX_ total records)'
          },
          'columns': [
            { 'data': 'check' },
            { 'data': 'department_name' },
            { 'data': 'department_code' },
            { 'data': 'branch_code' },
            { 'data': 'company_code' },
            { 'data': 'description' },
          ],
        })
      }
    })
  }

  function createviewdepartment (e) {
    $('.add_dept').val('')
    $('#create_view_department').modal('show')
  }

  function newdepartmentadd (e) {
    e.preventDefault()
    var department_name = $('#ndname').val()
    var department_code = $('#ndcode').val()
    var description = $('#nddescrpt').val()
    var company_code = $('#ndcmcode').val()
    var branch_code = $('#ndbmcode').val()
    if (department_name != '' && department_code != '' && branch_code != '' && company_code != '') {
      $.ajax({
        url: baseurl + 'orders/adddepartmentdetails',
        type: 'POST',
        data: { 'department_name': department_name, 'department_code': department_code, 'company_code': company_code, 'branch_code': branch_code, 'description': description },
        success: function (data) {
          if (data == '2') {
            $('#dialog').dialog()
            $('.ui-dialog').addClass('alert_zindex')
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('#dialog-text').html('Data already exists')
          } else {
            $('#insert_success_div').modal('show')
            $('#create_view_department').modal('hide')
          }
        }
      })
    } else {
      if (department_name == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Department Name')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ndname').focus()
        })
      } else if (department_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Department Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ndcode').focus()
        })
      } else if (company_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Company Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ndcmcode').focus()
        })
      } else if (branch_code == '') {
        $('#dialog').dialog()
        $('.ui-dialog').addClass('alert_zindex')
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('#dialog-text').html('Please enter Branch Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#ndbmcode').focus()
        })
      }
    }
  }

  $('#branch_code').autocomplete({
    source: function (request, response) {
      var cmp_code = $('#company_code').val()
      if (cmp_code != '') {
        $.ajax({
          url: baseurl + 'orders/getbranchbycompany',
          type: 'POST',
          dataType: 'json',
          data: {
            term: request.term,
            cmp_code: cmp_code
          },
          success: function (data) {
            response($.map(data, function (item) {
                return { id: item.id, value: item.branch_code }
              })
            )
            if (data.length == '0') {
              $('#dialog').dialog()
              $('.ui-dialog-title').addClass('fa fa-warning')
              $('.ui-dialog').addClass('alert_zindex')
              $('#dialog-text').html('Please enter a correct value in Branch')
              $('.ui-dialog-titlebar-close').click(function () {
                $('#branch_code').val('')
                $('#branch_code').focus()
              })
            }
          }
        })
      } else {
        $('#dialog').dialog()
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('.ui-dialog').addClass('alert_zindex')
        $('#dialog-text').html('Please enter a value in company')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#branch_code').val('')
          $('#company_code').focus()
        })
      }
    }, select: function (event, ui) {
      $(this).val(ui.item.label)
      var id = ui.item.value
      $('#shipper_branch_code').val(id)
      $('#party_branch_code').val(id)
      $('#consignee_branch_code').val(id)
      return false
    }
  })
  $('#department_code').autocomplete({
    source: function (request, response) {
      var branch_code = $('#branch_code').val()
      if (branch_code != '') {
        $.ajax({
          url: baseurl + 'orders/getdepartmentbybranch',
          type: 'POST',
          dataType: 'json',
          data: {
            term: request.term,
            branch_code: branch_code
          },
          success: function (data) {
            response($.map(data, function (item) {
                return { id: item.id, value: item.department_code }
              })
            )
            if (data.length == '0') {
              $('#dialog').dialog()
              $('.ui-dialog-title').addClass('fa fa-warning')
              $('.ui-dialog').addClass('alert_zindex')
              $('#dialog-text').html('Please enter a value in Department Code')
              $('.ui-dialog-titlebar-close').click(function () {
                $('#department_code').val('')
                $('#department_code').focus()
              })
            }
          }
        })
      } else {
        $('#dialog').dialog()
        $('.ui-dialog-title').addClass('fa fa-warning')
        $('.ui-dialog').addClass('alert_zindex')
        $('#dialog-text').html('Please enter a value in Branch Code')
        $('.ui-dialog-titlebar-close').click(function () {
          $('#department_code').val('')
          $('#branch_code').focus()
        })
      }
    }
  })
  $(document).ready(function () {
    $('.date').datepicker()
    setTimeout(function () {
      $('.flashmessages').fadeOut('fast')
    }, 1000)
    $('table.partnerslist').DataTable()
    $('table.prefs').DataTable()
    $('table.pcontacts').DataTable()
    $('table.paccounts').DataTable()
    $('table.pcontracts').DataTable()
    $('table.ediapitab').DataTable()
  })

  function selectcompany (id) {
    $('.selectcompany').attr('onclick', 'selectcompanyinlist()')
    $('.listcompany').removeClass('selectedcompany-list')
    $('#listcompany_' + id).addClass('selectedcompany-list')
  }

  function selectcompanyinlist () {
    $('#view_company').modal('hide')
    var id = $('.selectedcompany-list').val()
    $('#company_code').val(id)
  }

  function selectdepartment (id) {
    $('.selectdepartment').attr('onclick', 'selectdepartmentinlist()')
    $('.listdepartment').removeClass('selecteddepartment-list')
    $('#listdepartment_' + id).addClass('selecteddepartment-list')
  }

  function selectdepartmentinlist () {
    $('#view_department').modal('hide')
    var id = $('.selecteddepartment-list').val()
    $('#department_code').val(id)
  }

  $(document).ready(function () {
    $('.datep').datepicker({
      format: 'yyyy-mm-dd', autoclose: true,
    })
    setTimeout(function () {
      $('.flashmessages').fadeOut('fast')
    }, 1000)
    $('table.chargecode').DataTable()
  })
  $('#resetbutton').click(function () {
    $('#search_partner').trigger('reset')
    return false
  })
  $('#newbill').on('click', '.trkid', function () {
    var rev_costid = (this.id) // button ID 
    var bill_type = $('#bill_type').val();
    if(bill_type == "1"){
      var table = $('#chargecodes').DataTable()
      table.destroy()
      $.ajax({
        url: baseurl + 'billing/getcharges',
        type: 'POST',
        data: { 'rev_costid': rev_costid },
        dataType: 'JSON',
        success: function (data) {
          $('#chargecodes').DataTable({
            'bPaginate': true,
            'destroy': true,
            'paging': false,
            'bLengthChange': true,
            'bFilter': false,
            'bInfo': false,
            'bAutoWidth': true,
            'language': {
              'lengthMenu': '<select class="form-control">' +
                '<option value="10">10</option>' +
                '<option value="20">20</option>' +
                '<option value="30">30</option>' +
                '<option value="40">40</option>' +
                '<option value="50">50</option>' +
                '<option value="-1">All</option>' +
                '</select>'
            },
            data: data,
            'columns': [
              { 'data': 'order_id' },
              { 'data': 'charge_code' },
              { 'data': 'description' },
              { 'data': 'amount' },
              { 'data': 'currency' },
            ],
          })
        }
      })
    }
  })
  $('#newbill').on('click', '.notes', function () {
    var rev_costid = (this.id) // button ID 
    var status = $('#status').val()
    var table = $('#chargecodesrev').DataTable()
    table.destroy()
    $.ajax({
      url: baseurl + 'billing/getchargesfornotes',
      type: 'POST',
      data: { 'rev_costid': rev_costid, 'status': status },
      dataType: 'JSON',
      success: function (data) {
        $('#chargecodesrev').DataTable({
          'bPaginate': true,
          'destroy': true,
          'paging': false,
          'bLengthChange': true,
          'bFilter': false,
          'bInfo': false,
          'bAutoWidth': true,
          'language': {
            'lengthMenu': '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          data: data,
          'createdRow': function (row, data, dataIndex) {
            $(row).attr('class', 'trkid')
            $(row).attr('id', data.id)
          },
          'columns': [
            { 'data': 'action' },
            { 'data': 'charge_code' },
            { 'data': 'description' },
            { 'data': 'amount' },
            { 'data': 'revisedamount' },
            { 'data': 'currency' },
          ],
        })
      }
    })
  })
  $('#submitform').click(function (e) {
    e.preventDefault()
    var bill_type = $('#bill_type').val()
    var bill_group = $('#bill_group').val()
    var customercode = $('#customercode').val()
    var company_code = $('#company_code').val()
    var branch_code = $('#branch_code').val()
    var partner_cid = $('#partner_cid').val()
    var debitor_code = $('#partner_debitor_code').val()
    var invoice_date = $('#fromDatemin').val()
    var bill_status = $('#bill_status').val()
    var trknocbox = []
    $('input:checkbox[class=tracking_no]:checked').each(function () {
      trknocbox.push({
        'ids': $(this).val()
      })
    })
    var trknorbut = []
    $('input:radio[class=trackingno]:checked').each(function () {
      trknorbut.push({
        'ids': $(this).val()
      })
    })
    if (bill_type.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Select Bill Type')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#bill_type').focus().select()
      })
      return false
    } else if (bill_group.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Select Bill Group')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#bill_group').focus().select()
      })
      return false
    } else if (customercode.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter Customer Code')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#customercode').focus().select()
      })
      return false
    } else if (company_code.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter Company Code')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#company_code').focus().select()
      })
      return false
    } else if (partner_cid.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter CID')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#partner_cid').focus().select()
      })
      return false
    } else if (branch_code.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter Branch Code')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#branch_code').focus().select()
      })
      return false
    } else if (debitor_code.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter Account Debitor Code')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#partner_debitor_code').focus().select()
      })
      return false
    } else if (invoice_date.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Enter Invoice Date')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#fromDatemin').focus().select()
      })
      return false
    } else if (bill_status.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Select Bill Status')
      $('.ui-dialog-titlebar-close').click(function () {
        $('#bill_status').focus().select()
      })
      return false
    } else if (bill_type == 1 && trknorbut.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Select One Tracking Number')
      $('.ui-dialog-titlebar-close').click(function () {
        $('.trackingno').focus()
      })
      return false
    } else if (bill_type == 2 && trknocbox.length == 0) {
      $('#dialog_box').dialog()
      $('.ui-dialog-title').addClass('fa fa-warning')
      $('.ui-dialog').addClass('alert_zindex')
      $('#dialog_text').html('Please Select Atleast One Tracking Number')
      $('.ui-dialog-titlebar-close').click(function () {
        $('.tracking_no').focus()
      })
      return false
    } else {
      var datastring = $('#bill_data').serialize()
      var baseurl1 = baseurl + 'billing/insertbilldata/'
      var url = baseurl1
      $.ajax({
        url: url,
        type: 'POST',
        dataType: 'json',
        data: datastring,
        success: function (data) {
          $('#insert_success_div').modal('show')
          $('.success_redirect').on('click', function () {
            location.href = baseurl + 'billing'
          })
        },
      })
      return false
    }
  })
  /* $("#newbill").on("click", "#bill_type", function(){*/
  $('#bill_type').change(function () {
    var checkbox = $('.tracking_no')
    var radio = $('.trackingno')
    /*var table = $("#newbill");*/
    if ($(this).val() == 1) {
      $('.getcharges_btn_enable').attr('style','display:none');
      checkbox.hide()
      radio.show()
    } else {
      $('.getcharges_btn_enable').attr('style','display:block');
      radio.hide()
      checkbox.show()
    }
    getchargesbyorders();
  })
  $('#bill_group').change(function () {
    var group = $('#bill_group option:selected').text().toLowerCase()
    $('#groupname').val(group)
    // $('#customercode').val('')
    if (group == 'invoice') {
      var type = 'Carrier'
      $('#makeroletype').attr('onclick', 'viewroletypelist("' + type + '")')
      $('#custcode').hide()
      $('#vendcode').show()
    } else {
      var type = 'Customer'
      $('#makeroletype').attr('onclick', 'viewroletypelist("' + type + '")')
      $('#custcode').show()
      $('#vendcode').hide()
    }
  })
  $('#customercode').autocomplete({
    source: function (request, response) {
      var groupname = $('#groupname').val()
      var type = 'Customer'
      if (groupname == 'invoice') {
        var type = 'Carrier'
      }
      $.ajax({
        url: baseurl + 'billing/getcustomercodes',
        dataType: 'json',
        data: {
          custcode: request.term,
          type: type
        },
        success: function (data) {
          if (data.length == 0) {
            $('#dialog_box').dialog()
            $('.ui-dialog-title').addClass('fa fa-warning')
            $('.ui-dialog').addClass('alert_zindex')
            $('#dialog_text').html('No Customers Found')
            $('.ui-dialog-titlebar-close').click(function () {
              $('#customercode').focus()
            })
            return true
          } else {
            response(data)
          }
        }
      })
    }, select: function (event, ui) {
      $(this).val(ui.item.label)
      var id = ui.item.value
      var groupname = $('#groupname').val()
      var type = 'Customer'
      if (groupname == 'invoice') {
        var type = 'Carrier'
      }
      $.ajax({
        url: baseurl + 'billing/getcustomerdetails',
        type: 'post',
        data: { id: id, request: 2, type: type },
        dataType: 'json',
        success: function (data) {
          $('#name').val(data.name)
          $('#partner_cid').val(data.code)
          $('#branch_code').val(data.branch_code)
          $('#partner_debitor_code').val(data.acon_debitor_code)
          $('#department_code').val(data.department_code)
          var data = data.tobebilled
          var table = $('#newbill').DataTable()
          table.destroy()
          $('#newbill tbody').empty()
          if (data.length > 0) {
            $('#newbill').DataTable({
              data: data,
              'createdRow': function (row, data, dataIndex) {
                $(row).attr('class', 'trkid')
                $(row).attr('id', data.rev_cosid)
              },
              'bPaginate': true,
              'paging': true,
              'bLengthChange': true,
              'bInfo': false,
              'bFilter': false,
              'bAutoWidth': true,
              'language': {
                'lengthMenu': '<select class="form-control">' +
                  '<option value="10">10</option>' +
                  '<option value="20">20</option>' +
                  '<option value="30">30</option>' +
                  '<option value="40">40</option>' +
                  '<option value="50">50</option>' +
                  '<option value="-1">All</option>' +
                  '</select>'
              },
              iDisplayLength: -1,
              dom: 'Blfrtip',
              buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
                'print'
              ],
              'columns': [
                { 'data': 'tdvalue' },
                { 'data': 'order_id' },
                { 'data': 'shipper' },
                { 'data': 'pickup_city' },
                { 'data': 'pickup_pincode' },
                { 'data': 'pickup_country' },
                { 'data': 'consignee' },
                { 'data': 'delivery_city' },
                { 'data': 'delivery_pincode' },
                { 'data': 'delivery_country' },
                { 'data': 'transport_mode' },
                { 'data': 'amount' },
                { 'data': 'currency' },
              ],
            })
          }
        }
      })
      return false
    }
  })
  $('#week_filter').change(function () {
    var week = $(this).val()
    var billid = $('#billid').val()
    var bill_type = $('#bill_type').val()
    var customercode = $('#partner_cid').val()
    var groupname = $('#groupname').val()
    var type = 'Customer'
    if (groupname == 'invoice') {
      var type = 'Carrier'
    }
    if (customercode.length > 0 && week.length > 0) {
      $.ajax({
        url: baseurl + 'billing/weekfilter',
        type: 'post',
        data: { customercode: customercode, type: type, week: week, billid: billid, bill_type: bill_type },
        dataType: 'json',
        success: function (data) {
          var data = data.tobebilled
          var table = $('#newbill').DataTable()
          table.destroy()
          $('#newbill tbody').empty()
          if (data.length > 0) {
            $('#newbill').DataTable({
              data: data,
              'createdRow': function (row, data, dataIndex) {
                $(row).attr('class', 'trkid')
                $(row).attr('id', data.rev_cosid)
              },
              'bPaginate': false,
              'paging': false,
              'bLengthChange': true,
              'bInfo': false,
              'bFilter': false,
              'bAutoWidth': true,
              'language': {
                'lengthMenu': '<select class="form-control">' +
                  '<option value="10">10</option>' +
                  '<option value="20">20</option>' +
                  '<option value="30">30</option>' +
                  '<option value="40">40</option>' +
                  '<option value="50">50</option>' +
                  '<option value="-1">All</option>' +
                  '</select>'
              },
              dom: 'Blfrtip',
              buttons: [
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
                'print'
              ],
              'columns': [
                { 'data': 'tdvalue' },
                { 'data': 'order_id' },
                { 'data': 'createdon' },
                { 'data': 'shipper' },
                { 'data': 'pickup_city' },
                { 'data': 'pickup_pincode' },
                { 'data': 'pickup_country' },
                { 'data': 'consignee' },
                { 'data': 'delivery_city' },
                { 'data': 'delivery_pincode' },
                { 'data': 'delivery_country' },
                { 'data': 'transport_mode' },
                { 'data': 'amount' },
                { 'data': 'currency' },
              ],
            })
          } else {
            gettoast('top-right', 'customercode', 'No Pending bills for the selected Week')
            return false
          }
        }
      })
    }
  })
})

function findbranchlist (e) {
  e.preventDefault()
  var branch = $('#branch_code').val()
  if (branch != '') {
    var table = $('#branch_tab').DataTable()
    table.destroy()
    $('#view_branch').modal('show')
    $('#view_branch_title').html('Branch Detials')
    var name = $('#branch_code').val()
    $.ajax({
      url: baseurl + 'orders/findbranchbyname',
      type: 'POST',
      data: { 'name': name },
      dataType: 'JSON',
      success: function (data) {
        $('#branch_tab').DataTable({
          data: data,
          'language': {
            'lengthMenu': 'Display _MENU_ ',
            'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
            'info': 'Showing page _PAGE_ of _PAGES_',
            'infoEmpty': 'No Records Available',
            'infoFiltered': '(filtered from _MAX_ total records)'
          },
          'columns': [
            { 'data': 'check' },
            { 'data': 'branch_name' },
            { 'data': 'branch_code' },
            { 'data': 'company_code' },
            { 'data': 'description' },
          ],
        })
      }
    })
  } else {
    $('#dialog').dialog()
    $('.ui-dialog-title').addClass('fa fa-warning')
    $('#dialog-text').html('Please enter a value in branch')
    $('.ui-dialog-titlebar-close').click(function () {
      $('#branch_code').focus()
    })
  }
}

function viewbranchlist (e) {
  e.preventDefault()
  var company_code = $('#company_code').val()
  $('#view_branch').modal('show')
  $('#view_branch_title').html('List Of Branches')
  var table = $('#branch_tab').DataTable()
  table.destroy()
  $.ajax({
    url: baseurl + 'orders/viewbranchlist',
    type: 'POST',
    data: { company_code: company_code },
    dataType: 'JSON',
    success: function (data) {
      $('#branch_tab').DataTable({
        data: data,
        'language': {
          'lengthMenu': 'Display _MENU_ ',
          'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
          'info': 'Showing page _PAGE_ of _PAGES_',
          'infoEmpty': 'No Records Available',
          'infoFiltered': '(filtered from _MAX_ total records)'
        },
        'columns': [
          { 'data': 'check' },
          { 'data': 'branch_name' },
          { 'data': 'branch_code' },
          { 'data': 'company_code' },
          { 'data': 'description' },
        ],
      })
    }
  })
}

function searchviewbranch (e) {
  e.preventDefault()
  var branch = $('#branch_code').val()
  if (branch != '') {
    var table = $('#branch_tab').DataTable()
    table.destroy()
    $('#view_branch').modal('show')
    $('#view_branch_title').html('Search Branch Detials')
    var name = $('#branch_code').val()
    $.ajax({
      url: baseurl + 'orders/getbranchbyname',
      type: 'POST',
      data: { 'name': name },
      dataType: 'JSON',
      success: function (data) {
        $('#branch_tab').DataTable({
          data: data,
          'language': {
            'lengthMenu': 'Display _MENU_ ',
            'zeroRecords': '<h4 align=\'center\' style=\'color:red;\'>No Data Found</h4>',
            'info': 'Showing page _PAGE_ of _PAGES_',
            'infoEmpty': 'No Records Available',
            'infoFiltered': '(filtered from _MAX_ total records)'
          },
          'columns': [
            { 'data': 'check' },
            { 'data': 'branch_name' },
            { 'data': 'branch_code' },
            { 'data': 'company_code' },
            { 'data': 'description' },
          ],
        })
      }
    })
  } else {
    $('#dialog').dialog()
    $('.ui-dialog-title').addClass('fa fa-warning')
    $('#dialog-text').html('Please enter a value in branch')
    $('.ui-dialog-titlebar-close').click(function () {
      $('#branch_code').focus()
    })
  }
}

function selectbranch (id) {
  $('.selectbranch').attr('onclick', 'selectbranchinlist()')
  $('.listbranch').removeClass('selectedbranch-list')
  $('#listbranch_' + id).addClass('selectedbranch-list')
}

function selectbranchinlist () {
  $('#view_branch').modal('hide')
  var id = $('.selectedbranch-list').val()
  $('#branch_code').val(id)
  selectpartiesdetailsbyid()
}
function getchargesbyorders(){
  var rev_costid = 0;
  var ids = [];
  var bill_type = $('#bill_type').val();
  if(bill_type == "2"){
    $("input:checkbox[class=tracking_no]:checked").each(function () {
      var id = $(this).attr("id");
      ids.push(id);
    });
  }else{
    var val = $(".trackingno:checked").val();
    ids.push(val);
  }
  var table = $('#chargecodes').DataTable();
  table.destroy()
  $.ajax({
    url: baseurl + 'billing/getchargeswithorder',
    type: 'POST',
    data: { 'rev_costids': ids },
    dataType: 'JSON',
    success: function (data) {
      $('#chargecodes').DataTable({
        'bPaginate': true,
        'destroy': true,
        'paging': false,
        'bLengthChange': true,
        'bFilter': false,
        'bInfo': false,
        'bAutoWidth': true,
        'language': {
          'lengthMenu': '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        data: data,
        'columns': [
          { 'data': 'order_id' },
          { 'data': 'charge_code' },
          { 'data': 'description' },
          { 'data': 'amount' },
          { 'data': 'currency' },
        ],
      })
    }
  })
}

/*end start Billing */
