function getShipperListFromCustomer(listType) {
  $('.partyTypeSelectButton').prop('disabled', false);
  const table = $('#partyTypesListTable').DataTable();
  table.clear();
  table.destroy();
  const shipperRowId = $('#shipperRowId').val();
  $(".partyTypeModel").modal('show');
  $("#partyTypeModalTitle").html('Shipper List');
  if (listType > 0) {
    $('.partyTypeSelectButton').prop('disabled', true);
    $.ajax({
      url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypeFromRowId',
      type: "POST",
      data: {'rowId': shipperRowId, 'partyType': 'Shipper'},
      dataType: "JSON",
      success: function (data) {
        $("#partyTypesListTable").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },

          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          "columns": [
            {"data": "inputField"},
            {"data": "code"},
            {"data": "name"},
            {"data": "role"},
            {"data": "street"},
            {"data": "state"},
            {"data": "country"},
            {"data": "company_code"},
            {"data": "branch_code"},

          ],
        });
      }
    });
  } else {
    const partyTypes = ['Shipper', 'Pickup'];
    $.ajax({
      url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypesListFromCustomerLogin',
      type: "POST",
      data: {'type': partyTypes},
      dataType: "JSON",
      success: function (data) {
        $("#partyTypesListTable").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },

          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          "columns": [
            {"data": "inputField"},
            {"data": "code"},
            {"data": "name"},
            {"data": "role"},
            {"data": "street"},
            {"data": "state"},
            {"data": "country"},
            {"data": "company_code"},
            {"data": "branch_code"},

          ],
        });

      }
    });
  }
}

function getConsigneeListFromCustomer(listType) {
  $('.partyTypeSelectButton').prop('disabled', false);
  $(".partyTypeModel").modal('show');
  $("#partyTypeModalTitle").html('Consignee List');
  const table = $('#partyTypesListTable').DataTable();
  table.clear();
  table.destroy();
  const consigneeRowId = $('#consigneeRowId').val();
  if (listType > 0) {
    $('.partyTypeSelectButton').prop('disabled', true);
    $.ajax({
      url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypeFromRowId',
      type: "POST",
      data: {'rowId': consigneeRowId, 'partyType': 'Consignee'},
      dataType: "JSON",
      success: function (data) {
        $("#partyTypesListTable").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },

          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          "columns": [
            {"data": "inputField"},
            {"data": "code"},
            {"data": "name"},
            {"data": "role"},
            {"data": "street"},
            {"data": "state"},
            {"data": "country"},
            {"data": "company_code"},
            {"data": "branch_code"},

          ],
        });
      }
    });
  } else {
    const partyTypes = ['Consignee', 'Delivery'];
    $.ajax({
      url: baseurl + 'svkCustomer/CustomerOrders/getPartyTypesListFromCustomerLogin',
      type: "POST",
      data: {'type': partyTypes},
      dataType: "JSON",
      success: function (data) {
        $("#partyTypesListTable").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": true,
          "bInfo": false,
          "bAutoWidth": true,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },

          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          "columns": [
            {"data": "inputField"},
            {"data": "code"},
            {"data": "name"},
            {"data": "role"},
            {"data": "street"},
            {"data": "state"},
            {"data": "country"},
            {"data": "company_code"},
            {"data": "branch_code"},

          ],
        });

      }
    });
  }
}

function selectpartylist(partyId) {
  $('.partylistclass').removeClass('finalPartyType');
  $('#partylist_' + partyId).addClass('finalPartyType');
}

function getSelectedPartyTypeInQuickbook() {
  if ($('.finalPartyType').length) {
    const name = $('.finalPartyType').attr('data-name');
    const email = $('.finalPartyType').attr('data-email');
    const street = $('.finalPartyType').attr('data-street');
    const city = $('.finalPartyType').attr('data-city');
    const state = $('.finalPartyType').attr('data-state');
    const mobile = $('.finalPartyType').attr('data-mobile');
    const country = $('.finalPartyType').attr('data-country');
    const pincode = $('.finalPartyType').attr('data-pincode');
    const code = $('.finalPartyType').attr('data-code');
    const role = $('.finalPartyType').attr('data-role');
    const latitude = $('.finalPartyType').attr('data-latitude');
    const longitude = $('.finalPartyType').attr('data-longitude');
    const house_number = $('.finalPartyType').attr('data-house_number');
    const partyRowId = $('.finalPartyType').val();
    if (['SHIPPER', 'PICKUP'].includes(role)) {
      $('#shipperCode').val(code);
      $('#shipperName').val(name);
      $('#shipperContactperson').val(name);
      $('#shipperAddress').val(city + ',' + state + ',' + country);
      $('#shipperStreet').val(street);
      $('#shipperSuburb').val(state);
      $('#shipperCity').val(city);
      $('#shipperPostalCode').val(pincode);
      $('#shipperPhone').val(mobile);
      $('#shipperEmail').val(email);
      $('#shipperRowId').val(partyRowId);
      $('#shipperLatitude').val(latitude);
      $('#shipperLongitude').val(longitude);
      $('#shipperCountry').val(country);
      $('#shipperNameInfo').html(name);
      $('#shipperHouseNumber').val(house_number);
      $('#shipperAddressInfo').html(city + ' - ' + country);
    } else {
      $('#consigneeCode').val(code);
      $('#consigneeName').val(name);
      $('#conisneeContactPerson').val(name);
      $('#consigneeAddress').val(city + ',' + state + ',' + country);
      $('#consigneeStreet').val(street);
      $('#consigneeSuburb').val(state);
      $('#consigneeCity').val(city);
      $('#consigneePostalCode').val(pincode);
      $('#consigneePhone').val(mobile);
      $('#consigneeEmail').val(email);
      $('#consigneeRowId').val(partyRowId);
      $('#consigneeLatitude').val(latitude);
      $('#consigneeLongitude').val(longitude);
      $('#consigneeCountry').val(country);
      $('#consigneeNameInfo').html(name);
      $('#consigneeHouseNumber').val(house_number);
      $('#consigneeAddressInfo').html(city + ' - ' + country);
    }
    $(".partyTypeModel").modal('hide');
    var shipperCode = $('#shipperCode').val();
    var consigneeCode = $('#consigneeCode').val();
    if (shipperCode != "" && consigneeCode != "") {
      getDistanceBetweenLocations();
    }
  }
}

function getDistanceBetweenLocations() {
  const fromLatitude = $('#shipperLatitude').val();
  const fromLongitude = $('#shipperLongitude').val();
  const toLatitude = $('#consigneeLatitude').val();
  const toLongitude = $('#consigneeLongitude').val();
  const fromStreet = $('#shipperStreet').val();
  const fromCity = $('#shipperCity').val();
  const fromCountry = $('#shipperCountry').val();
  const fromPostalCode = $('#shipperPostalCode').val();
  const toStreet = $('#consigneeStreet').val();
  const toCity = $('#consigneeCity').val();
  const toCountry = $('#consigneeCountry').val();
  const toPostalCode = $('#consigneePostalCode').val();
  $.ajax({
    url: baseurl + 'svkCustomer/CustomerOrders/getDistanceBetweenLocations',
    type: "POST",
    data: {'fromLatitude': fromLatitude, 'fromLongitude': fromLongitude, 'toLatitude': toLatitude, 'toLongitude': toLongitude, 'fromStreet': fromStreet, 'fromCity': fromCity, 'fromCountry': fromCountry, 'fromPostalCode': fromPostalCode, 'toStreet': toStreet, 'toCity': toCity, 'toCountry': toCountry, 'toPostalCode': toPostalCode},
    dataType: "JSON",
    success: function (data) {
      $('#distanceIcon').html(data['distance']);
      $('#shipperLatitude').val(data['fromLatitude']);
      $('#shipperLongitude').val(data['fromLongitude']);
      $('#consigneeLatitude').val(data['toLatitude']);
      $('#consigneeLongitude').val(data['toLongitude']);
    }
  });
}

function InitializeGoogleMaps() {
  const plat = $('#shipperLatitude').val() * 1;
  const plng = $('#shipperLongitude').val() * 1;
  const dlat = $('#consigneeLatitude').val() * 1;
  const dlng = $('#consigneeLongitude').val() * 1;
  const clat = plat;
  const clng = plng;
  level1Bounds = new google.maps.LatLngBounds();

  googleMap = new google.maps.Map(document.getElementById('map'), {
    center: {
      lat: plat,
      lng: plng
    },
    mapTypeControl: true,
    mapTypeControlOptions: {
      style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
      position: google.maps.ControlPosition.TOP_CENTER
    },
    zoomControlOptions: {
      position: google.maps.ControlPosition.LEFT_CENTER,
    },
    scaleControl: true,
    streetViewControl: true,
    streetViewControlOptions: {
      position: google.maps.ControlPosition.LEFT_TOP,
    },
    zoom: 12,
    mapTypeId: google.maps.MapTypeId.ROADMAP
  });
  var pos = new google.maps.LatLng(clat, clng);
  bounds = new google.maps.LatLngBounds();
  vehicle = new google.maps.Marker({
    position: pos,
    map: googleMap,
  });


  directionsService = new google.maps.DirectionsService();
  directionsDisplay = new google.maps.DirectionsRenderer();
  start = plat + ',' + plng;
  end = dlat + ',' + dlng;
  var request = {
    origin: start,
    destination: end,
    travelMode: google.maps.TravelMode.DRIVING
  };

  directionsService.route(request, function (response, status) {
    if (status == google.maps.DirectionsStatus.OK) {
      directionsDisplay.setDirections(response);
      directionsDisplay.setMap(googleMap);
    }
  });
}

function addCargoDetails() {
  const data = $("#saveCargoDetails").serializeArray();
  const itemId = $('#itemId').find(":selected").text();
  const packageType = $('#packageType').find(":selected").text();
  const quantity = $('#quantity').val();
  const itemIdValue = $('#itemId').val();
  const goodsDescription = $('#goodsDescription').val();
  if (itemIdValue == 0) {
    gettoast('top-right1', 'itemId', 'Please Select Item');
    return false;
  }
  if (quantity == "") {
    gettoast('top-right1', 'quantity', 'Please enter quantity');
    return false;
  }
  const weight = $('#weight').val();
  if (weight == "") {
    gettoast('top-right1', 'weight', 'Please enter weight');
    return false;
  }
  const volume = $('#volume').val();
  if (volume == "") {
    gettoast('top-right1', 'volume', 'Please enter volume');
    return false;
  }
  const companyCode = $('#companyCode').val();
  const length = $('#length').val();
  const width = $('#width').val();
  const height = $('#height').val();
  if (companyCode != "NZKN") {
    if (length == "") {
      gettoast('top-right1', 'length', 'Please enter length');
      return false;
    }
    if (width == "") {
      gettoast('top-right1', 'width', 'Please enter width');
      return false;
    }
    if (height == "") {
      gettoast('top-right1', 'height', 'Please enter height');
      return false;
    }
  }
  const cargoRowId = $('#cargoRowId').val();
  if (quantity > 0) {
    $.ajax({
      url: $("#saveCargoDetails").attr("action"),
      type: "POST",
      data: data,
      dataType: "JSON",
      success: function (response) {
        const rowId = response.rowId;
        const dgRowId = response.dgRowId;
        if (rowId > 0) {
          const totalQuantity = parseFloat($('#totalQuantityInput').val()) + parseFloat(quantity);
          $('#totalQuantityInput').val(totalQuantity);
          const totalVolume = parseFloat($('#totalVolumeInput').val()) + parseFloat(volume);
          $('#totalVolumeInput').val(totalVolume.toFixed(2));
          $('#totalVolume').text(totalVolume.toFixed(2) + " CBM");
          const totalWeight = parseFloat($('#totalWeightInput').val()) + parseFloat(weight);
          $('#totalWeightInput').val(totalWeight.toFixed(2));
          $('#totalWeight').text(totalWeight.toFixed(2) + " KG");
          $('.cargoDetailsFields').val('');
          const cargoStackable = $('#cargoStackable').is(":checked");
          const cargoGrounded = $('#cargoGrounded').is(":checked");
          const cargoSplittable = $('#cargoSplittable').is(":checked");
          const cargoDg = $('#cargoDg').is(":checked");
          $('.cargoCheckBoxes').prop('checked', false);
          $('.cargoDetailsDropdown').val('0');
          const cargoWeight = parseFloat(weight).toFixed(2);
          const cargoVolume = parseFloat(volume).toFixed(2);
          var cargoLength = " ";
          var cargoWidth = " ";
          var cargoHeight = " ";
          if (length != "") {
            cargoLength = parseFloat(length).toFixed(2);
          }
          if (width != "") {
            cargoWidth = parseFloat(width).toFixed(2);
          }
          if (height != "") {
            cargoHeight = parseFloat(height).toFixed(2);
          }
          const icons = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" style="border: none;" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu icondropdown" style="padding: 0;left: 0" role="menu"><li><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="editCargoDetails(this,' + rowId + ',' + itemIdValue + ');"><span class="glyphicon glyphicon-pencil"></span>Edit</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="deleteCargoDetailsRow(this,' + rowId + ');"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul>'
          var dimensionsColumn = "<td></td>";
          if (length != "" || width != "" || height != "") {
            dimensionsColumn = "<td>" + cargoLength + " x " + cargoWidth + " x " + cargoHeight + "</td>";
          }
          var tableBody = "<tr class='cargoRow_" + rowId + " newCargos'>" +
            "<td>" + icons + "</td>" +
            "<td>" + itemId + "</td>" +
            "<td>" + packageType + "</td>" +
            "<td>" + goodsDescription + "</td>" +
            "<td>" + quantity + "</td>" +
            "<td>" + cargoWeight + "</td>" +
            "<td>" + cargoVolume + "<span class='cargoCheckBoxValues' id='cargoStackableValue_" + rowId + "'>_" + cargoStackable + "</span><span class='cargoCheckBoxValues' id='cargoGroundedValue_" + rowId + "'>" + cargoGrounded + "</span><span class='cargoCheckBoxValues' id='cargoSplittableValue_" + rowId + "'>" + cargoSplittable + "</span><span class='cargoCheckBoxValues' id='cargoDgValue_" + rowId + "'>" + cargoDg + "</span></td>" + dimensionsColumn +
            "</tr>";
          if (cargoRowId > 0) {
            $('.cargoRow_' + rowId).remove();
            $('#orderCargoTableBody').append(tableBody);
          } else {
            if (!$('#cargoRowIds_' + rowId).length) {
              const checkBoxInputType = "<input type='checkbox' form='quickbookForm' name='cargoRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='cargoRowIds_" + rowId + "' value = '" + rowId + "' style='display: none;'><input type='hidden' id='dgWithCargo_" + rowId + "' name='dgWithCargo' value='" + dgRowId + "'>";
              $('.cargoRowIdsDevTag').append(checkBoxInputType);
              $('#cargoRowIds_' + rowId).prop('checked', true);
              $('#orderCargoTableBody').append(tableBody);
            }
          }
          $('#orderCargosTableDivTag').css('display', 'block');
          $('#emptyCargoTableDivTag').css('display', 'none');
        }
      }
    });
  }
}

function addUploadedDocument() {
  const documentType = $('#documentType').find(":selected").text();
  const formData = new FormData(document.getElementById("saveUploadedData"));
  /*  const name = document.getElementById("fileName");
    const fileName = name.files[0];
    formData.append('fileName', fileName); */
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/saveUploadedDocuments",
    type: "POST",
    data: formData,
    contentType: false,
    cache: false,
    processData: false,
    success: function (response) {
      const data = JSON.parse(response);
      if (data.status == 0) {
        gettoast('top-right1', '', 'Something went wrong');
      } else if (data.status == 1) {
        $(".addDocuments").css('display', 'none');
        $('.podUploadFields').val('');
        $('.podUploadDropdown').val('0');
        const uploadedDocumentRowId = data.uploadedDocumentRowId;
        if (uploadedDocumentRowId > 0) {
          const date = data.date;
          const fileName = data.fileName;
          const checkBoxInputType = "<input type='checkbox' form='quickbookForm' name='podUploadRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='podUploadRowIds_" + uploadedDocumentRowId + "' value = '" + uploadedDocumentRowId + "' style='display: none;'>";
          const icons = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" style="border: none;" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu icondropdown" style="padding: 0;left: 0" role="menu"><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="deletePodUploadedRow(this,' + uploadedDocumentRowId + ');"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul>';
          $('.popUploadRowIdsDevTag').append(checkBoxInputType);
          $('#podUploadRowIds_' + uploadedDocumentRowId).prop('checked', true);
          var tableBody = "<tr>" +
            "<td>" + icons + "</td>" +
            "<td>" + documentType + "</td>" +
            "<td>" + fileName + "</td>" +
            "<td>" + date + "</td>" +
            "</tr>";
          $('#orderPodUploadsTableBody').append(tableBody);
          $('#orderPodUploadsTableDivTag').css('display', 'block');
          $('#emptyPodUploadsDivTag').css('display', 'none');
        }
      } else if (data.status == 2) {
        gettoast('top-right1', '', 'Please select file to upload');
      }
    }
  });
}

function deletePodUploadedRow(but, rowId) {
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/deletePodUploadedDocumentById",
    type: "POST",
    data: {'podUploadRowId': rowId},
    dataType: "JSON",
    success: function (data) {
      if (data > 0) {
        const $row = $(but).closest('tr');
        $row.remove();
        $("#podUploadRowIds_" + rowId).remove();
      } else {

      }
    }
  });
}

function deleteCargoDetailsRow(but, rowId) {
  const orderRowId = $('#orderRowId').val();
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/deleteCargoDetailsById",
    type: "POST",
    data: {'cargoRowId': rowId, 'orderRowId': orderRowId},
    dataType: "JSON",
    success: function (data) {
      if (data > 0) {
        const $row = $(but).closest('tr');
        const volumeTag = $row.find("td:eq(6)").text().trim();
        const totalVolume = parseFloat($('#totalVolumeInput').val()) - parseFloat(volumeTag);
        $('#totalVolumeInput').val(totalVolume.toFixed(2));
        $('#totalVolume').text(totalVolume.toFixed(2) + " CBM");
        const quantityTag = $row.find("td:eq(4)").text().trim();
        const totalQuantity = parseFloat($('#totalQuantityInput').val()) - parseFloat(quantityTag);
        $('#totalQuantityInput').val(totalQuantity.toFixed(2));
        const weightTag = $row.find("td:eq(5)").text().trim();
        const totalWeight = parseFloat($('#totalWeightInput').val()) - parseFloat(weightTag);
        $('#totalWeightInput').val(totalWeight.toFixed(2));
        $('#totalWeight').text(totalWeight.toFixed(2) + " KG");
        $row.remove();
        $("#cargoRowIds_" + rowId).remove();
      }
    }
  });
}

function removeAllInputValues() {
  $('.customerQuickbookFields').val('');
  $('.customerQuickbookDropDown').val('0');
  $('.hiddenCheckBoxes').remove();
  $('#orderCargoTableBody').html("");
  $('#orderPodUploadsTableBody').html("");
  $('#orderPodUploadsTableDivTag').css('display', 'none');
  $('#emptyPodUploadsDivTag').css('display', 'block');
  $('#orderCargosTableDivTag').css('display', 'none');
  $('#emptyCargoTableDivTag').css('display', 'block');
  $('#orderChargesTableDivTag').css('display', 'none');
  $('#emptyChargesTableDivTag').css('display', 'block');
  $('.submitorderdetails').prop('disabled', false);
  $('.getQuoteButton').prop('disabled', false);
  $('.cargoCheckBoxes').prop('checked', false);
  $('#totalVolume').text('0');
  $('#totalWeight').text('0');
  $('#totalCharges').text('');
}

function validateQuickbook() {
  let sts = 1;
  const shipperCode = $('#shipperCode').val();
  if (shipperCode == "") {
    sts = 0;
    gettoast('top-right1', 'shipperCode', 'Please enter a value in Shipper ID');
    return false;
  }
  const consigneeCode = $('#consigneeCode').val();
  if (consigneeCode == "") {
    sts = 0;
    gettoast('top-right1', 'consigneeCode', 'Please enter a value in Consginee ID');
    return false;
  }
  const estimatedPickupDate = $('#estimatedPickupDate').val();
  if (estimatedPickupDate == "") {
    sts = 0;
    gettoast('top-right1', 'estimatedPickupDate', 'Please enter a value in Estimated Pickup Date');
    return false;
  }
  const estimatedDeliveryDate = $('#estimatedDeliveryDate').val();
  if (estimatedDeliveryDate == "") {
    sts = 0;
    gettoast('top-right1', 'estimatedDeliveryDate', 'Please enter a value in Estimated Delivery Date');
    return false;
  }
  const startDate = new Date(estimatedPickupDate);
  const endDate = new Date(estimatedDeliveryDate);
  if (endDate < startDate) {
    gettoast('top-right1', 'estimatedDeliveryDate', 'Delivery Date and time is grater than or equal to Pickup  ');
    return false;
  }
  const orderType = $('#orderType').val();
  if (orderType == "0") {
    sts = 0;
    gettoast('top-right1', 'orderType', 'Please Select Booking Type');
    return false;
  }
  const service = $('#orderService').val();
  if (service == "0") {
    sts = 0;
    gettoast('top-right1', 'service', 'Please Select Service');
    return false;
  }

  const modeOfTransport = $('#modeOfTransport').val();
  if (modeOfTransport == "0") {
    sts = 0;
    gettoast('top-right1', 'modeOfTransport', 'Please Select Mode Of Trasnport');
    return false;
  }
  if (sts == '1') {
    $('.submitorderdetails').prop('disabled', true);
  }
}

function gettoast(position, id, desp, timeOut = 2000) {
  if (id != "") {
    $('#' + id).focus();
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  });
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>' + desp + '</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout: timeOut
  });
}

function changeByDimensions() {
  var height = $('#height').val();
  var length = $('#length').val();
  var width = $('#width').val();
  var quantity = $('#quantity').val();
  if (height > 0 && width > 0 && length > 0 && quantity > 0) {
    var dimensions = ((length) * (width) * (height)) / 1000000;
    var volume = (dimensions * quantity);
    $('#volume').val(volume.toFixed(2));
  }
}

function GetLeastSellRate() {
  if ($('#showAllRates').length) {
    $('.submitorderdetails').prop('disabled', true);
    $('.getQuoteButton').prop('disabled', true);
    const vasData = [];
    $('input.vasData:checkbox:checked').each(function () {
      vasData.push($(this).val());
    });
    const orderRowId = $('#orderRowId').val();
    const shipperRowId = $('#shipperRowId').val();
    const consigneeRowId = $('#consigneeRowId').val();
    const pickupState = $('#shipperSuburb').val();
    const pickupCity = $('#shipperCity').val();
    const pickupCountry = $('#shipperCountry').val();
    const pickupPincode = $('#shipperPostalCode').val();
    const consigneeState = $('#consigneeSuburb').val();
    const consigneeCity = $('#consigneeCity').val();
    const consigneeCountry = $('#consigneeCountry').val();
    const consigneePincode = $('#consigneePostalCode').val();
    const offeringType = $('#modeOfTransport').val();
    const customerRowId = $('#customerRowId').val();
    const currency = $('#sessionCurrency').val();
    const totalWeight = $('#totalWeightInput').val();
    const totalVolume = $('#totalVolumeInput').val();
    const totalQuantity = $('#totalQuantityInput').val();
    const distanceWithKM = $('#distanceIcon').text();
    const distanceArray = distanceWithKM.split(' ');
    const totalKiloMeters = distanceArray[0];
    const totalMiles = (totalKiloMeters * 0.621371);
    const service = $('#orderService').val();
    const modeOfTransport = $('#modeOfTransport').val();
    const values = [shipperRowId, consigneeRowId, pickupCountry, pickupState, pickupCity, pickupPincode, consigneeCountry, consigneeState, consigneeCity, consigneePincode, service, modeOfTransport];
    const messages = ['Please Select Shipper', 'Please Select Consignee', 'Please Select Shipper Country', 'Please Select Shipper Suburb/province', 'Please Select Shipper City', 'Please Select Shipper Zipcode', 'Please Select Consignee Country', 'Please Select Consignee Suburb/province', 'Please Select Consignee City', 'Please Select Consignee Zipcode', 'Please Select Service', 'Please Select Mode Of Transport'];
    for (let i = 0; i < 12; i++) {
      if (values[i] == "0") {
        $('.submitorderdetails').prop('disabled', false);
        $('.getQuoteButton').prop('disabled', false);
        gettoast('top-right1', '', messages[i]);
        return false;
      }
      if (values[i] == "") {
        gettoast('top-right1', '', messages[i]);
        $('.submitorderdetails').prop('disabled', false);
        $('.getQuoteButton').prop('disabled', false);
        return false;
      }
    }
    if (!$('.newCargos').length) {
      gettoast('top-right1', '', 'Please select Cargos');
      $('.submitorderdetails').prop('disabled', false);
      $('.getQuoteButton').prop('disabled', false);
      return false;
    }
    $.ajax({
      url: baseurl + "rateenquiry/index",
      type: "POST",
      data: {
        'pickupState': pickupState,
        'pickupCity': pickupCity,
        'pickupCountry': pickupCountry,
        'pickupPincode': pickupPincode,
        'consigneeState': consigneeState,
        'consigneeCity': consigneeCity,
        'consigneeCountry': consigneeCountry,
        'consigneePincode': consigneePincode,
        'tariffType': 'SELL',
        'modelType': offeringType,
        'totalWeight': totalWeight,
        'totalVolume': totalVolume,
        'totalQuantity': totalQuantity,
        'totalKiloMeters': totalKiloMeters,
        'totalMiles': totalMiles,
        'customerRowId': customerRowId,
        'service': service,
        'modeOfTransport': modeOfTransport,
        'vasData': vasData,
        'ajaxCall': '1'
      },
      dataType: "JSON",
      success: function (data) {
        $('.submitorderdetails').prop('disabled', false);
        $('.getQuoteButton').prop('disabled', false);
        const totalAmount = data.totalAmount;
        if (totalAmount > 0) {
          const rateLaneRowId = data.laneRowId;
          const customerProfileId = data.customerProfileId;
          const rateServiceRowId = data.serviceRowId;
          const rateOfferingRowId = data.offeringRowId;
          const rateRecordRowId = data.recordRowId;
          $('#rateServiceRowId').val(rateServiceRowId);
          $('#rateCustomerProfileId').val(customerProfileId);
          $('#rateLaneRowId').val(rateLaneRowId);
          $('#rateOfferingRowId').val(rateOfferingRowId);
          $('#rateRecordRowId').val(rateRecordRowId);
          const individualCharges = data.individualCharges;
          let tableBody = "";
          $.each(individualCharges, function (key, value) {
            if (value.amountWithBasis > 0) {
              tableBody += "<tr class='leastRateRow'>" +
                "<td>" + value.rateId + "</td>" +
                "<td>" + value.vasId + "</td>" +
                "<td>" + value.chargeId + "</td>" +
                "<td>" + value.amountWithBasis + " " + value.currency + "</td>" +
                "</tr>";
            }
          });
          if (orderRowId > 0) {
            $('.leastRateRow').remove();
            $('#chargesBodyTable').append(tableBody);
            const totalDbAmount = parseFloat($('#totalOrderCharges').val());
            const amount = (totalDbAmount + parseFloat(totalAmount))
            $('#totalCharges').text(parseFloat(amount).toFixed(2) + " " + currency);
          } else {
            $('#chargesBodyTable').html(tableBody);
            $('#totalCharges').text(parseFloat(totalAmount).toFixed(2) + " " + currency);
          }
          $('#orderChargesTableDivTag').css('display', 'block');
          $('#emptyChargesTableDivTag').css('display', 'none');
        } else {
          $('#rateServiceRowId').val(0);
          $('#rateCustomerProfileId').val(0);
          $('#rateLaneRowId').val(0);
          $('#rateOfferingRowId').val(0);
          $('#rateRecordRowId').val(0);
          $('#chargesBodyTable').html("");
          $('#orderChargesTableDivTag').css('display', 'none');
          $('#emptyChargesTableDivTag').css('display', 'block');
          $('#totalCharges').text("");
        }
      }
    });
  }
}

function displayDgModal() {
  if ($('#orderDgGoodsRow').val() > 0) {
    $('#cargoDg').prop('checked', true);
  }
  if ($('#cargoDg').is(":checked")) {
    $(".dgModal_main").show();
  }
}

function closeDgModalPopup() {
  $('#cargoDg').prop('checked', false);
  $(".dgModal_main").hide();
  $('.dgPopupFields').val("");
}

function AddDgGoodsToCargo() {
  const data = $("#saveDangerousGoods").serializeArray();
  const unCode = $('#dgUnCode').val();
  if (unCode == 0) {
    gettoast('top-right1', 'dgUnCode', 'Please Select UN Code');
    return false;
  }
  $.ajax({
    url: $("#saveDangerousGoods").attr("action"),
    type: "POST",
    data: data,
    dataType: "JSON",
    success: function (data) {
      $('#orderDgGoodsRow').val(data);
      const checkBoxInputType = "<input type='checkbox' form='quickbookForm' name='dgRowIds[]' class='hiddenCheckBoxes customerQuickbookFields' id='dgRowIds" + data + "' value = '" + data + "' style='display: none;'>";
      $('.dgGoodsRowIdsDevTag').append(checkBoxInputType);
      $('#dgRowIds' + data).attr('data-unCode', $('#dgUnCode').val());
      $('#dgRowIds' + data).attr('data-unCodeName', $('#dgUnCodeName').val());
      $('#dgRowIds' + data).attr('data-unCodeClass', $('#dgUnCodeClass').val());
      $('#dgRowIds' + data).attr('data-packagingGroup', $('#dgUnCodePackingGroup').val());
      $('#dgRowIds' + data).attr('data-nos', $('#dgNos').val());
      $('#dgRowIds' + data).attr('data-tunnelCode', $('#dgTunnelCode').val());
      $('#dgRowIds' + data).attr('data-packages', $('#dgNoOfPackages').val());
      $('#dgRowIds' + data).attr('data-packageType', $('#dgPackageType').val());
      $('#dgRowIds' + data).attr('data-gorssWeight', $('#dgGrossWeight').val());
      $('#dgRowIds' + data).attr('data-netWeight', $('#dgNetWeight').val());
      $('#dgRowIds' + data).attr('data-explosiveMass', $('#dgNetExplosiveMass').val());
      $('#dgRowIds' + data).attr('data-liters', $('#dgLiters').val());
      $('#dgRowIds' + data).attr('data-ltdQuantity', $('#dgLimitedQuantity').val());
      $('#dgRowIds' + data).attr('data-expQuantity', $('#dgExpectedQuantity').val());
      $('#dgRowIds' + data).attr('data-environmentally', $('#dgEnvironmentally').val());
      $('#dgRowIds' + data).attr('data-techinalName', $('#dgTechinalName').val());
      $('#dgRowIds' + data).attr('data-fireWorks', $('#dgFireworks').val());
      $('#dgRowIds' + data).prop('checked', true);
      $(".dgModal_main ").hide();
      $('.dgPopupFields').val("");
    }
  });
}

function displayDgUncodeModal() {
  $(".lookup_main").show();
  const table = $('#UnCodeDataTable').DataTable();
  table.clear();
  table.destroy();
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/getUnCodeForDangerousGoods",
    type: "POST",
    data: '',
    dataType: "JSON",
    success: function (data) {
      $("#UnCodeDataTable").DataTable({
        data: data,
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": true,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },

        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "inputField"},
          {"data": "unCode"},
          {"data": "name"},
          {"data": "class"},
          {"data": "packingGroup"},
          {"data": "mainRisk"},
          {"data": "subLevel1"},
          {"data": "subLevel2"},
          {"data": "subLevel3"},
          {"data": "subLevel4"},
          {"data": "classificationCode"},
          {"data": "nos"},
          {"data": "tunnelCode"},

        ],
      });
    }
  });
}

function selectUnCodeData(partyId) {
  $('.unCodeList').removeClass('selectedUnCode');
  $('#unCode_' + partyId).addClass('selectedUnCode');
}

function displaySelectedUncodeDetails() {
  const uncodeName = $('.selectedUnCode').attr('data-name');
  $('#dgUnCodeName').val(uncodeName);
  const unCode = $('.selectedUnCode').attr('data-uncode');
  $('#dgUnCode').val(unCode);
  const unCodeClass = $('.selectedUnCode').attr('data-class');
  $('#dgUnCodeClass').val(unCodeClass);
  const packingGroup = $('.selectedUnCode').attr('data-packing_group');
  $('#dgUnCodePackingGroup').val(packingGroup);
  const tunnelCode = $('.selectedUnCode').attr('data-tunnel_code');
  $('#dgTunnelCode').val(tunnelCode);
  const nos = $('.selectedUnCode').attr('data-nos');
  $('#dgNos').val(nos);
  const adrMultiplicator = $('.selectedUnCode').attr('data-adr_multiplicator');
  $('#dgAdrMultiplicator').val(adrMultiplicator);
  const transportCategory = $('.selectedUnCode').attr('data-transport_category');
  $('#dgTransportCategory').val(transportCategory);
  $(".lookup_main").hide();
}

function editOrderInPopupPage(orderRowId, bookingId) {
  $("#cover-spin").show();
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/editOrderInPopup",
    type: "POST",
    data: {'orderRowId': orderRowId},
    success: function (response) {
      $('#cover-spin').hide();
      $('#quickbookPopupHeader').html(bookingId);
      $("#quickbook_popup").modal('show');
      $('.quickbook_popupBody').html(response);
      getDistanceBetweenLocations();
    }
  });
}

function viewOrderInPopupPage(orderRowId, bookingId) {
  $("#cover-spin").show();
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/viewOrderInPopup",
    type: "POST",
    data: {'orderRowId': orderRowId},
    success: function (response) {
      $('#cover-spin').hide();
      $('#quickbookPopupHeader').html(bookingId);
      $("#quickbook_popup").modal('show');
      $('#quickbookPopupHeader').html('eBooking');
      $('.quickbook_popupBody').html(response);
      getDistanceBetweenLocations();
    }
  });
}

function displayQuickbookPage() {
  $("#cover-spin").show();
  $.ajax({
    url: baseurl + "svkCustomer/CustomerOrders/displayQuickBookForCustomer",
    type: "POST",
    data: {},
    success: function (response) {
      $('#cover-spin').hide();
      $("#quickbook_popup").modal('show');
      $('.quickbook_popupBody').html(response);
    }
  });
}

function displayDocumentsModal() {
  $(".documentsModal_main").show();
}

function closeDocumentsModalPopup() {
  $(".documentsModal_main").hide();
}

function closeLookupMainPopup() {
  $(".lookup_main").hide();
}

function closepartyTypeModelPopup() {
  $(".partyTypeModel").modal('hide');
}

function toggleMap() {
  $(".showMap").show();
  InitializeGoogleMaps();
}

function closeMapPopup() {
  $(".showMap").hide();
}

/*function deleteorderbyid(orderid) {
  var x = confirm("Are you sure you want to delete this Order?");
  if (x) {
    $.ajax({
      url: baseurl + 'orders/deleteorder/' + orderid,
      type: "GET",
      success: function () {
        location.reload();
      }
    });
  } else {
    return false;
  }
}*/

let selectedOrderId = null;

function deleteorderbyid(orderid) {
    selectedOrderId = orderid;
    $("#deleteModal").modal("show");
}

$("#confirmDelete").off("click").on("click", function () {
    var orderid = $(this).data("orderid");
    $("#deleteModal").modal("hide");
    if (selectedOrderId) {
      $.ajax({
        url: baseurl + "orders/deleteorder/" + selectedOrderId,
        type: "GET",
        success: function () {
          location.reload();
        },
      });
    } else {
      return false;
    }
});

function addShipperDataFromQuickbook() {
  var name = $('#shipperName').val();
  if (name == "") {
    gettoast('top-right1', 'shipperName', 'Please enter Shipper Name');
    return false;
  }
  var code = $('#shipperCode').val();
  var country = $('#shipperCountry').val();
  var house_number = $('#shipperHouseNumber').val();
  if (country == "") {
    gettoast('top-right1', 'shipperCountry', 'Please enter Shipper Country');
    return false;
  }
  var street = $('#shipperStreet').val();
  if (street == "") {
    gettoast('top-right1', 'shipperStreet', 'Please enter Shipper Street');
    return false;
  }
  var suburb = $('#shipperSuburb').val();
  if (suburb == "") {
    gettoast('top-right1', 'shipperSuburb', 'Please enter Shipper Suburb');
    return false;
  }
  var city = $('#shipperCity').val();
  if (city == "") {
    gettoast('top-right1', 'shipperCity', 'Please enter Shipper City');
    return false;
  }
  var postalCode = $('#shipperPostalCode').val();
  if (postalCode == "") {
    gettoast('top-right1', 'shipperPostalCode', 'Please enter Shipper Postal Code');
    return false;
  }
  if (house_number == "") {
    gettoast('top-right1', 'shipperHouseNumber', 'Please enter House Number');
    return false;
  }
  $('.saveShipperData').attr('disabled', true);
  var rowId = $('#shipperRowId').val();
  if (rowId > 0) {
    updateAddressDataFromQuickbook(0);
  } else {
    if (code == '') {
      var data = {
        'isCipPortalCustomer': 0,
        'isDuplicateCustomer': $('#isDuplicateCustomer').val(),
        'addrs_name': name,
        'addrs_street': street,
        'addrs_city': city,
        'addrs_province': suburb,
        'addrs_country': country,
        'postal_code': postalCode,
        'street_2': '',
        'street_3': '',
        'addrs_building': '',
        'house_number': house_number,
      };
      $.ajax({
        url: baseurl + 'CipAuthorization/generateCID_V1',
        type: "POST",
        data: data,
        dataType: 'json',
        success: function (response) {
          $('.saveShipperData').attr('disabled', false);
          console.log('errorMessage==>', response.errorMessage);
          if (response.status == 1) {
            $('#shipperCode').val(response.cid);
            saveAddressInfo(0);
          } else if ([0, 2, 3, 6].includes(response.status)) {
            gettoast('top-right', 'cip_number', response.message);
            return false;
          } else if (response.status == 5) {
            var dataHTML = 'No data found';
            $.each(response.customers, function (f_key, result) {
              dataHTML += '<tr>';
              dataHTML += '<td><input type="radio" value="' + result.cid + '" name="customer_cip_number">' + result.cid + '</td>';
              dataHTML += '<td>' + result.entityName + '</td>';
              dataHTML += '<td>' + result.address + '</td>';
              dataHTML += '</tr>';
            });
            $('#cip-customer_display_data').html(dataHTML);
            $('#cipPartyType').val(0);
            $('#cip_customer_matching_list').modal('show');
            var table = $('table#customers_cip_table').DataTable();
            table.destroy();
          }
        },
        error: function (xhr, status, error) {
          $('div.displayLoader').css('display', 'none');
          console.log(xhr.responseText);
        }
      });
    } else {
      saveAddressInfo(0);
    }
  }
  const shipperCode = $('#shipperCode').val();
  const consigneeCode = $('#consigneeCode').val();
  if (shipperCode != "" && consigneeCode != "") {
    getDistanceBetweenLocations();
  }
}

function addConsigneeDataFromQuickbook() {
  var name = $('#consigneeName').val();
  if (name == "") {
    gettoast('top-right1', 'consigneeName', 'Please enter Consignee Name');
    return false;
  }
  var code = $('#consigneeCode').val();
  var country = $('#consigneeCountry').val();
  var house_number = $('#consigneeHouseNumber').val();
  if (country == "") {
    gettoast('top-right1', 'consigneeCountry', 'Please enter Consignee Country');
    return false;
  }
  var street = $('#consigneeStreet').val();
  if (street == "") {
    gettoast('top-right1', 'consigneeStreet', 'Please enter Consignee Street');
    return false;
  }
  var suburb = $('#consigneeSuburb').val();
  if (suburb == "") {
    gettoast('top-right1', 'consigneeSuburb', 'Please enter Consignee Suburb');
    return false;
  }
  var city = $('#consigneeCity').val();
  if (city == "") {
    gettoast('top-right1', 'consigneeCity', 'Please enter Consignee City');
    return false;
  }
  var postalCode = $('#consigneePostalCode').val();
  if (postalCode == "") {
    gettoast('top-right1', 'consigneePostalCode', 'Please enter Consignee Postal Code');
    return false;
  }
  if (house_number == "") {
    gettoast('top-right1', 'consigneeHouseNumber', 'Please enter House Number');
    return false;
  }
  $('.saveConsigneeData').attr('disabled', true);
  var rowId = $('#consigneeRowId').val();
  if (rowId > 0) {
    updateAddressDataFromQuickbook(1);
  } else {
    if (code == '') {
      var data = {
        'isCipPortalCustomer': 0,
        'isDuplicateCustomer': $('#isDuplicateCustomer').val(),
        'addrs_name': name,
        'addrs_street': street,
        'addrs_city': city,
        'addrs_province': suburb,
        'addrs_country': country,
        'postal_code': postalCode,
        'street_2': '',
        'street_3': '',
        'addrs_building': '',
        'house_number': house_number,
      };
      $.ajax({
        url: baseurl + 'CipAuthorization/generateCID_V1',
        type: "POST",
        data: data,
        dataType: 'json',
        success: function (response) {
          $('.saveConsigneeData').attr('disabled', false);
          console.log('errorMessage==>', response.errorMessage);
          if (response.status == 1) {
            $('#consigneeCode').val(response.cid);
            saveAddressInfo(1);
          } else if ([0, 2, 3, 6].includes(response.status)) {
            gettoast('top-right', 'cip_number', response.message);
            return false;
          } else if (response.status == 5) {
            var dataHTML = 'No data found';
            $.each(response.customers, function (f_key, result) {
              dataHTML += '<tr>';
              dataHTML += '<td><input type="radio" value="' + result.cid + '" name="customer_cip_number">' + result.cid + '</td>';
              dataHTML += '<td>' + result.entityName + '</td>';
              dataHTML += '<td>' + result.address + '</td>';
              dataHTML += '</tr>';
            });
            $('#cip-customer_display_data').html(dataHTML);
            $('#cipPartyType').val(1);
            $('#cip_customer_matching_list').modal('show');
            var table = $('table#customers_cip_table').DataTable();
            table.destroy();
          }
        },
        error: function (xhr, status, error) {
          $('div.displayLoader').css('display', 'none');
          console.log(xhr.responseText);
        }
      });
    } else {
      saveAddressInfo(1);
    }
  }
  const shipperCode = $('#shipperCode').val();
  const consigneeCode = $('#consigneeCode').val();
  if (shipperCode != "" && consigneeCode != "") {
    getDistanceBetweenLocations();
  }
}

function saveAddressInfo(type) {
  let data;
  if (type > 0) {
    data = {
      'rowId': $('#consigneeRowId').val(),
      'cid': $('#consigneeCode').val(),
      'customerName': $('#consigneeName').val(),
      'email': $('#consigneeEmail').val(),
      'phone': $('#consigneePhone').val(),
      'street': $('#consigneeStreet').val(),
      'country': $('#consigneeCountry').val(),
      'province': $('#consigneeSuburb').val(),
      'city': $('#consigneeCity').val(),
      'house_number': $('#consigneeHouseNumber').val(),
      'pinCode': $('#consigneePostalCode').val()
    };
  } else {
    data = {
      'rowId': $('#shipperRowId').val(),
      'cid': $('#shipperCode').val(),
      'customerName': $('#shipperName').val(),
      'email': $('#shipperEmail').val(),
      'phone': $('#shipperPhone').val(),
      'street': $('#shipperStreet').val(),
      'country': $('#shipperCountry').val(),
      'province': $('#shipperSuburb').val(),
      'city': $('#shipperCity').val(),
      'house_number': $('#shipperHouseNumber').val(),
      'pinCode': $('#shipperPostalCode').val()
    };
  }
  console.log(data);
  $.ajax({
    url: baseurl + 'SVKCustomerAddress/customerAddress',
    type: "POST",
    data: data,
    dataType: 'json',
    success: function (response) {
      let message;
      if (type > 0) {
        $('.saveConsigneeData').attr('disabled', false);
      } else {
        $('.saveShipperData').attr('disabled', false);
      }
      $('#isDuplicateCustomer').val(0);
      if (response.status > 0) {
        const masterData = response.masterData;
        if (type > 0) {
          message = "Consignee address added successfully";
          $('#consigneeRowId').val(response.result);
          $('#consigneeAddress').val(masterData.location_id + ',' + masterData.state + ',' + masterData.country);
          $('#consigneeLatitude').val(masterData.latitude);
          $('#consigneeLongitude').val(masterData.longitude);
          $('#conisneeContactPerson').val(masterData.name);
          $('#consigneeNameInfo').html(masterData.name);
          $('#consigneeAddressInfo').html(masterData.location_id + ' - ' + masterData.country);
        } else {
          message = "Shipper address added successfully";
          $('#shipperRowId').val(response.result);
          $('#shipperAddress').val(masterData.location_id + ',' + masterData.state + ',' + masterData.country);
          $('#shipperLatitude').val(masterData.latitude);
          $('#shipperLongitude').val(masterData.longitude);
          $('#shipperContactperson').val(masterData.name);
          $('#shipperNameInfo').html(masterData.name);
          $('#shipperAddressInfo').html(masterData.location_id + ' - ' + masterData.country);
        }
        gettoast('top-right', '', message);
      } else {
        gettoast('top-right', '', 'Something went wrong');
      }
    }
  });
}

function createDuplicateCustomer() {
  if (confirm('Are you sure want to create as a new customer?')) {
    partyType = $('#cipPartyType').val();
    $('#cip_customer_matching_list').modal('hide');
    $('#isDuplicateCustomer').val(1);
    if (partyType > 0) {
      addConsigneeDataFromQuickbook();
    } else {
      addShipperDataFromQuickbook();
    }
  }
}

function submitCIPShipper() {
  var cip_number = $('input[name=customer_cip_number]:checked').val();
  if (typeof cip_number === "undefined") {
    gettoast('top-right', 'cip_number', "Please select a CIP number to proceed");
  } else {
    var partyType = $('#cipPartyType').val();
    $('#cip_customer_matching_list').modal('hide');
    $('tbody#cip-customer_display_data').html('');
    if (partyType > 0) {
      $('#consigneeCode').val(cip_number);
      addConsigneeDataFromQuickbook();
    } else {
      $('#shipperCode').val(cip_number);
      addShipperDataFromQuickbook();
    }
  }
  return false;
}

function updateAddressDataFromQuickbook(type) {
  let data;
  if (type > 0) {
    data = {
      'ajaxCall': 1,
      'id': $('#consigneeRowId').val(),
      'cid': $('#consigneeCode').val(),
      'customerName': $('#consigneeName').val(),
      'email': $('#consigneeEmail').val(),
      'phone': $('#consigneePhone').val(),
      'street': $('#consigneeStreet').val(),
      'country': $('#consigneeCountry').val(),
      'province': $('#consigneeSuburb').val(),
      'city': $('#consigneeCity').val(),
      'house_number': $('#consigneeHouseNumber').val(),
      'pinCode': $('#consigneePostalCode').val()
    };
  } else {
    data = {
      'ajaxCall': 1,
      'id': $('#shipperRowId').val(),
      'cid': $('#shipperCode').val(),
      'customerName': $('#shipperName').val(),
      'email': $('#shipperEmail').val(),
      'phone': $('#shipperPhone').val(),
      'street': $('#shipperStreet').val(),
      'country': $('#shipperCountry').val(),
      'province': $('#shipperSuburb').val(),
      'city': $('#shipperCity').val(),
      'house_number': $('#shipperHouseNumber').val(),
      'pinCode': $('#shipperPostalCode').val()
    };
  }
  console.log(data);
  $.ajax({
    url: baseurl + 'SVKCustomerAddress/updateCustomerAddress',
    type: "POST",
    data: data,
    dataType: 'json',
    success: function (response) {
      if (type > 0) {
        $('.saveConsigneeData').attr('disabled', false);
      } else {
        $('.saveShipperData').attr('disabled', false);
      }
      let message;
      $('#isDuplicateCustomer').val(0);
      if (response.status > 0) {
        const masterData = response.masterData;
        if (type > 0) {
          message = "Consignee address updated successfully";
          $('#consigneeAddress').val(masterData.location_id + ',' + masterData.state + ',' + masterData.country);
          $('#consigneeLatitude').val(masterData.latitude);
          $('#consigneeLongitude').val(masterData.longitude);
          $('#conisneeContactPerson').val(masterData.name);
          $('#consigneeNameInfo').html(masterData.name);
          $('#consigneeAddressInfo').html(masterData.location_id + ' - ' + masterData.country);
        } else {
          message = "Shipper address updated successfully";
          $('#shipperAddress').val(masterData.location_id + ',' + masterData.state + ',' + masterData.country);
          $('#shipperLatitude').val(masterData.latitude);
          $('#shipperLongitude').val(masterData.longitude);
          $('#shipperContactperson').val(masterData.name);
          $('#shipperNameInfo').html(masterData.name);
          $('#shipperAddressInfo').html(masterData.location_id + ' - ' + masterData.country);
        }
        gettoast('top-right', '', message);
      } else {
        gettoast('top-right', '', 'Something went wrong');
      }
    }
  });
}

