function checkPasswordStrength(password) {
  let strength = 0;
  //check for length
  if(password.length >= 8) {
    strength += 1;
  }
  //check for uppercase
  if(Boolean(password.match(/[A-Z]/))) {
    strength += 1;
  }
  //check for numbers
  if(Boolean(password.match(/\d/))) {
    strength += 1;
  }
  //check for special characters
  let spChars = /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]+/;
  if(spChars.test(password)){
    strength += 1;
  }
  if (strength < 4) {
    return 0;
  }else{
    return 1;
  }
}

function gettoastPassword(position,id,desp){
  if(id != ""){
    //$('#'+id).focus();
    if(!$('#'+id).hasClass('errorclass')){
      $('#'+id).addClass('errorclass');
    }
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  });
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>'+desp+'</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout : 20000
  });
}

