$(document).on('paste', 'span.select2', function (e) {
    e.preventDefault();
    var select = $(e.target).closest('.select2').prev();
    var clipboard = (e.originalEvent || e).clipboardData.getData('text/plain');
    clipboard = clipboard.replace(/\s+/g, ','); 
    var createOption = function (value, selected) {
        selected = typeof selected !== 'undefined' ? selected : true;
        var options = $('#select2-bookingid-results li');
        var matchedVal = options.filter(function () { 
             return $(this).html() === value
            }).text();
        if(matchedVal.length>1){
            return $("<option></option>").attr("value", value).attr("selected", selected).text(value)[0];
        }
    };
    $.each(
        clipboard.split(new RegExp(select.data('select2').options.options.tokenSeparators.map(function (a) {
            return (a).replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
        }).join('|'))),
        function (key, value) {
            if (value && (!select.val() || (select.val() && select.val().indexOf('' + value) == -1))) {
                select.append(createOption(value));
            }
        });
        select.trigger('change');
    });