// Gets Order Wise Cost details in a shift
function getCostDetailsByShiftId(shift_id){
	var table = $('#shift_rates').DataTable();
    table.destroy();
	$.ajax({
		url: baseurl+'trips/getCostDetailsByShiftId',
		type: "post",
		data:{'shift_id':shift_id},
		dataType:'json',
		success: function(data){
			if(data.length > 0){

			}else{
			   $("#shift_rates").DataTable({
                    data: data,
                    "bPaginate": false,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                });
                table.clear().draw();
                var a = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" style="left:0 !important;" role="menu">';
                var b = '<li><a id="bAdd" class="btn dt-add" onclick="addCostRow(this,' + shift_id + ');"><span class="glyphicon glyphicon-plus" > </span>Add Cost Details</a></li>';
                var c = '</ul></li></ul>';
                $('#shift_rates .dataTables_empty').html(a + b + c);
			}
		}
	});
}

// Displays a form to add cost details
function addCostRow(e, shift_id) {
	$.ajax({
		url: baseurl + 'trips/addCostDetail',
		type: "POST",
		data: {
			'shift_id': shift_id
		},
		dataType: 'json',
		success: function (data) {
			if (data.shift_id != 0) {
				var tableId = $(e).closest('table').attr('id');
				var trOpen = '<tr id="editing">';
				var tds = '<form name="cost_form" class="cost_form" id="cost_form" method="POST" action="' + baseurl + 'Orderrevenues/savecost"><td><select form="newcost_form" placeholder="Select Order" class="form-control" name="cost_order_id" id="shift_orders" required></td><td><select name="costtype_role" id="costtype_role" class="form-control" onchange="getcostcodefromrole(this);" form="cost_form" ><option value="">Select</option> <option value="Carrier">Vendor</option><option value="Internal BU">Internal BU</option><option value="Overseas OL">Overseas OL</option></select></td><td style="min-width: 245px" class="measurement"><input onkeypress="return isNonSpecialCharCheck(event);" type="text" name="cost_codeid" parsley-trigger="change"  placeholder=" " class="form-control"  id="cost_codeid" value="" form="cost_form"><button class="btn btn-outline-secondary" type="button" data-placement="top" title="Find" data-toggle="modal" id="makeroletype" onclick="viewroletypelist(event)"><i class="icon tru-icon-find-new"></i></button></td><td style="min-width: 150px" ><input type="text" name="cost_totamount" onkeypress="return isNonSpecialCharCheck(event);" parsley-trigger="change"  placeholder=" " class="form-control decimal"  id="cost_totamount" value="" form="cost_form" readonly></td><td style="min-width: 150px" ><input type="text" name="cost_currency" parsley-trigger="change"  placeholder=" " class="form-control" onkeypress="return isNonSpecialCharCheck(event);" onkeypress="return isNonSpecialCharCheck(event);"  id="cost_currency" value="' + currency + '" form="cost_form" readonly></td></form>';
				var buttons = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left:0 !important;"><li><a id="bEdit" onclick="return savecost(this);"  type="button" class="btn btn-sm btn-default"><span class="glyphicon glyphicon-ok"> </span>Save</a></li>';
				var divClose = "</ul></li></ul></td>";
                var trClose = "</tr></tbody></table></td>";
				var html = trOpen + buttons + tds + divClose + trClose;
                rowAddNewBetween('shift_rates', e, html);

				// Loop Orders
				orders = data.orders;
                var order_opt = "<option value=''>Select Order</option>";
				$.each(orders, function (key, value) {
                    order_opt += "<option value='" + value + "'>" + value + "</option>";
                });
                order_opt += "</select>";
                $('#shift_orders').append(order_opt);
			}
		}
	});
}

// Get Role Type List
function viewroletypelist(type) {
    var table = $('#role_tab').DataTable();
    table.destroy();
    $("#view_roletype").modal('show');
    if (type == "Customer") {
        $("#view_roletype_title").html('Customer List');
    } else if (type = "Vendor") {
        $("#view_roletype_title").html('Vendor Type List');
    } else {
        $("#view_roletype_title").html('Role Type List');
    }
    $.ajax({
        url: baseurl + 'orders/viewroletypelist',
        type: "POST",
        data: {'type': type},
        dataType: 'JSON',
        success: function (data) {
            $("#role_tab").DataTable({
                data: data,
                "bPaginate": true,
                "paging": true,
                "bLengthChange": true,
                "bFilter": true,
                "bInfo": false,
                "bAutoWidth": true,
                "language": {
                    "lengthMenu": '<select class="form-control">' +
                            '<option value="10">10</option>' +
                            '<option value="20">20</option>' +
                            '<option value="30">30</option>' +
                            '<option value="40">40</option>' +
                            '<option value="50">50</option>' +
                            '<option value="-1">All</option>' +
                            '</select>'
                },
                dom: 'Blfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],
                "columns": [
                    {"data": "check"},
                    {"data": "code"},
                    {"data": "name"},
                    {"data": "email_id"},
                    {"data": "street"},
                    {"data": "city"},
                    {"data": "country"},
                    {"data": "company_code"},
                    {"data": "branch_code"},
                ],
            });
        }
    });
}

// Select the Role
function selectroleinlist() {
    var id = $('.roleselected-list').val();
    $.ajax({
        url: baseurl + 'orders/getshipperdetailsbyID',
        type: 'post',
        data: {id: id},
        dataType: 'json',
        success: function (data) {
            $('#view_roletype').modal('hide');
            var response = data.customer_details;
            var code = response[0].code;
            var name = response[0].name;
            $('#revenue_codeid').val(code);
            $('#revenue_name').val(name);
        }
    });
}

// Save Cost
function savecost(e) {
    var role = $('#costtype_role').val();
    var code = $('#cost_codeid').val();
    var name = $('#cost_name').val();
    if (role == "") {
        /*$('#costtype_role').focus();
         return false;*/
        gettoast('top-right', 'costtype_role', 'Please Select Role');
        return false;
    } else if (code == '') {
        /* $('#cost_codeid').focus();
         return false;*/
        gettoast('top-right', 'cost_codeid', 'Please enter a value in Code');
        return false;
    } else if (name == '') {
        /*$('#cost_codeid').focus();
         return false;*/
        gettoast('top-right', 'cost_name', 'Please enter a value in Name');
        return false;
    } else {
        var data = $("#cost_form").serializeArray();
        $.ajax({
            url: $("#cost_form").attr("action"),
            type: "POST",
            data: data,
            dataType: "JSON",
            success: function (data) {
            },
        }).done(function () {
            getcostdetailsbyorder();
            getallcostrevenues();
        });
        if ($('#cost_invoice_status').prop("checked") == true) {
            if ($('#cost_invoice_status').attr('disabled')) {
            } else {
                checkifstatusreadyornot();
            }
        }
        return false;
    }
}
/* Cost Related Functions - End */

function getShipOrdersDocuments(shift_id) {
    var table = $('#orders_doclist').DataTable();
    table.destroy();
    $.ajax({
        url: baseurl + 'trips/orddocsdetails',
        type: "POST",
        data: {'shift_id': shift_id},
        dataType: 'json',
        success: function (data) {
			//alert(data.length);
            if (data.length > 0) {
                $("#orders_doclist").DataTable({
                    data: data,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                    "columns": [
                        {"data": "action"},
                        {"data": "order_id"},
                        {"data": "location"},
                        {"data": "type_name"},
                        {"data": "imgpath"},
                        {"data": "stop_type"},
                        {"data": "driver"},
                        {"data": "date"},
                    ],
                });
            } else {
                $("#orders_doclist").DataTable({
                    data: data,
                    "bPaginate": false,
                    "paging": false,
                    "bLengthChange": true,
                    "bFilter": false,
                    "bInfo": false,
                    "bAutoWidth": true,
                    "language": {
                        "lengthMenu": '<select class="form-control">' +
                                '<option value="10">10</option>' +
                                '<option value="20">20</option>' +
                                '<option value="30">30</option>' +
                                '<option value="40">40</option>' +
                                '<option value="50">50</option>' +
                                '<option value="-1">All</option>' +
                                '</select>'
                    },
                    dom: 'Blfrtip',
                    buttons: [
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                        'print'
                    ],
                });
                table.clear().draw();
                var a = '<ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" style="left:0 !important;" role="menu">';
                var b = '<li><a id="bAdd" class="btn dt-add" onclick="rowshipdocAdd(this,' + shift_id + ');"><span class="glyphicon glyphicon-plus" > </span>Add Doc</a></li>';
                var c = '</ul></li></ul>';
                $('#orders_doclist .dataTables_empty').html(a + b + c);
            }
        }
    });
}


// Add Document Form
function rowshipdocAdd(e, shift_id) {
    $.ajax({
        url: baseurl + 'trips/addorderdoc',
        type: "POST",
        data: {'shift_id': shift_id},
        dataType: 'json',
        success: function (data) {
            if (data.booking_id != '0') {
                var booking_id = data.booking_id;
                var order_row_id = data.order_row_id;
                var trip_id = data.trip_id;
                var shift_id = data.shift_id;
                var company_code = data.company_code;
                var branch_code = data.branch_code;
                var tableId = $(e).closest('table').attr('id');
                var userDepartmentCode = $('#UserdepartmentCode').val();
                var UserRoleId = $('#userRoleId').val();
                var trOpen = "<tr id='editing'>";
                var tds = "<form name='newdoc_form' class='newdoc_form' id='newdoc_form' method='POST' action='" + baseurl + "admin/savenewpod' enctype='multipart/form-data'><td><select form='newdoc_form' placeholder='Select Order' class='form-control' name='order_id' id='shift_order' required onchange='getdocorder(this.id);'></td><td colspan='2'><select form='newdoc_form' placeholder='Select Type' class='form-control' name='doc_type' id='doc_type' required><input form='newdoc_form' type='hidden' name='order_number' id='order_number' value='" + booking_id + "'><input form='newdoc_form' type='hidden' name='company_code' value='" + company_code + "'><input form='newdoc_form' type='hidden' name='branch_code' value='" + branch_code + "'><input form='newdoc_form' type='hidden' name='ship_id' value='" + shift_id + "'><input form='newdoc_form' type='hidden' name='trip_id' value='" + trip_id + "'></td><td colspan='2'><select form='newdoc_form' placeholder='Select Stop' class='form-control' name='stop_id' id='stop_id' required></td><td colspan='2'><input form='newdoc_form' type='file' placeholder='POD' id='updfile_name' class='form-control' name='file_name'></td></form>";
                var buttons = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left:0 !important;"><li><a id="bEdit" onclick="addshipdocdetails(event,'+shift_id+')"  type="button" class="btn btn-sm btn-default"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bAcep" type="button" class="btn btn-sm btn-default" style="display:none;" onclick="rowAcep(this);"><span class="glyphicon glyphicon-ok"> </span>Update</a></li>';
                var divClose = "</ul></li></ul></td>";
                var trClose = "</tr></tbody></table></td>";
                var html = trOpen + buttons + divClose +  tds + trClose;
                rowAddNewBetween('orders_doclist', e, html);
                stops = data.stops;
                doc_type = data.document_types;
                orders = data.orders;
                var order_opt = "<option value=''>Select Order</option>";
                var opt = "<option value=''>Select Document Type</option>";
                var spot_opt = "<option value=''>Select Stop Id</option>";
                $.each(doc_type, function (key, value) {
                    opt += "<option value='" + value.id + "'>" + value.type_name + "</option>";
                });
                opt += "</select>";
                $('#doc_type').append(opt);
                $.each(stops, function (key, value) {
                    if(value != ""){
                        spot_opt += "<option value='" + value.id + "'>" + value.stopname + "</option>";
                    }
                });
                spot_opt += "</select>";
                $('#stop_id').append(spot_opt);
                $.each(orders, function (key, value) {
                  if (UserRoleId == "5" && userDepartmentCode != "" && userDepartmentCode != value.department_code) {
                    order_opt += "<option value='" + value.orderid + "' disabled>" + value.ordernumber + "</option>";
                  } else {
                    order_opt += "<option value='" + value.orderid + "'>" + value.ordernumber + "</option>";
                  }
                });
                order_opt += "</select>";
                $('#shift_order').append(order_opt);
            }
        }
    });
}

function getdocorder(id){
	var order_number=$( "#"+id+" option:selected" ).text();
	$("#order_number").val(order_number);
}

// Add Doc
function addshipdocdetails(evt, shift_id) {
    var file = document.getElementById("updfile_name");
    var doc_type = $("#doc_type").val();
    var chkfile = file.files.length;
    if (doc_type == "") {
        gettoast('top-right', 'doc_type', 'Please Select Document Type');
    } else if (chkfile == 0) {
        gettoast('top-right', 'updfile_name', 'Please Upload File');
    } else {
        var form_data = new FormData(document.getElementById("newdoc_form"));

        $.ajax({
            url: $("#newdoc_form").attr("action"),
            type: "POST",
            data: form_data,
            contentType: false,

            processData: false,
          success: function (response) {
            response = response.toString().trim();
            if (response === '3') {
              gettoast('top-right', 'updfile_name', 'malicious files are not accepted. Upload another file');
              return false;
            }
            getShipOrdersDocuments(shift_id);
          },
        })
    }
}

function getshiporderstatusdetails(shift_id){
   // var order_id = $('#order_id').val();
    var table = $('#status_table').DataTable();
//alert(shift_id);
    table.destroy();
    $.ajax({
        url:baseurl+'trips/getorderstatusdetails',
        type:"POST",
        data:{'shift_id':shift_id},
        dataType:'json',
        success:function(data){
/* 			alert(data);
			console.log(data); */
            if(data.length >0){
                $("#status_table").DataTable({
                data:data,
                "paging": false,
                "bLengthChange": true,
                "bFilter": false,
                "bInfo": false,
                "bAutoWidth": true,
                "language": {
                "lengthMenu": '<select class="form-control">' +
                    '<option value="10">10</option>' +
                    '<option value="20">20</option>' +
                    '<option value="30">30</option>' +
                    '<option value="40">40</option>' +
                    '<option value="50">50</option>' +
                    '<option value="-1">All</option>' +
                    '</select>'
            },
                dom: 'Blfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],
                "columns": [
                    { "data": "action"},
                    { "data": "shipmentid"},
                    { "data": "order_id"},
                    { "data": "stop_id"},
                    { "data": "status_name"},
                    { "data": "status_type"},
                    { "data": "location"},
                    { "data": "date"},

                ],
            });
            }else{
                 $("#status_table").DataTable({
                data:data,
                 "bPaginate": false,
                "paging": false,
                "bLengthChange": true,
                "bFilter": false,
                "bInfo": false,
                "bAutoWidth": true,
                "bSort": false,
                "language": {
                "lengthMenu": '<select class="form-control">' +
                    '<option value="10">10</option>' +
                    '<option value="20">20</option>' +
                    '<option value="30">30</option>' +
                    '<option value="40">40</option>' +
                    '<option value="50">50</option>' +
                    '<option value="-1">All</option>' +
                    '</select>'
            },
                dom: 'Blfrtip',
                buttons: [
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                    'print'
                ],
            });
                  table
                    .clear()
                    .draw();
                    var a = '<ul class="nav nav-tabs"><li class="dropdown"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;">' ;
            var b =
                '<li><a id="bAdd" type="button" class="btn btn-sm btn-default" onclick="rowAddstatus(this);">' +
                '<span class="glyphicon glyphicon-plus" > </span>' +
                'Add Status' +
                '</a></li>';
            var c = '</ul></li></ul>';
            $('#status_table .dataTables_empty').html(a+b+c);
            }

        }
    });
}


function getdatetimepicker(e) {
    $(e).datepicker({
        format: "yyyy-mm-dd",
		autoclose: true,
		minDate: 0,
		minTime: 0,
		showButtonPanel: true
    });
    $(e).focus();
}

function deleteshipmentbyid(id) {
    event.preventDefault();
    var shift_id = id.toString();
    $.ajax({
        url: baseurl + 'trips/delete/' + shift_id,
        beforeSend: function () {
        },
        success: function (data) {
            var response = JSON.parse(data);
            if (response.status==1) {
                $(".popup_circle").removeClass('glyphicon-remove-circle');
                $(".popup_circle").addClass('glyphicon-ok-circle');
                $(".popup_circle").css("color", "green");
                $(".pop_message").html('Record Deleted Successfully !!');
                $("#insert_success_div").modal('show');
                $(".success_redirect").on('click', function () {
                    window.location.reload();
                });
            } else {
                $("#dialog_box").dialog();
                $('.ui-dialog-title').addClass('fa fa-warning');
                $('.ui-dialog-title').addClass('fa fa-warning');
                $("#dialog_text").text("Oops...something went wrong");
            }
        }
    });
}

function savelegs(e){
	  var order_id =$('input[name=radio_order]:checked').val();
	  var legscheckbox=0;
	  var selected = [];
    var deallocateOrders = [];
	 $("input:checkbox[name=triplegs]:checked").each(function(){
		selected.push($(this).val());
	});
  $(".deAllocateOrders").each(function () {
    if ($(this).val() > 0) {
      deallocateOrders.push($(this).val());
    }
  });
	if(order_id == undefined){
		gettoast('top-right','order','Please Select Order');
		return false;
	}else if(selected.length == 0){
		gettoast('top-right','checkboxlegs','Please Check Legs');
		return false;
	} else{
    var baseurl1 = baseurl+"trips/addtriplegs";
    var url = baseurl1;
    var shift_id=$("#shipment_id").val();
    $("#insert_success_div").modal("show");
     $(".suc_pop_ok")
      .off("click")
      .on("click", function () {
        $.ajax({
            url: url,
            type: 'POST',
            dataType: 'json',
            data: {'triplegs': selected, 'order_id': order_id, 'deallocateOrders': deallocateOrders},
            success: function(data)
            {
    			//alert(data);
               // $("#insert_success_div").modal('show');
    			/*$(".success_redirect").on('click',function() {
    				window.location.reload();
    			});*/
    			//(".success_redirect").on('click', function () {
                    const shiftUrl = baseurl + "trips/KNETtripsedit/" + shift_id
                    var carrier_type = $('#carrier_type').val();
                    var today = new Date();
                    var date = today.getFullYear()+'-'+(today.getMonth()+1)+'-'+today.getDate();
                    var time = today.getHours() + ":" + today.getMinutes() ;
                    var todaydate=date+" "+time;
                    $("#editModal .modal-content").load(shiftUrl, function () {
                       // $("#editModal").modal("show");
                         $('.select_date').datetimepicker({
                            startDate: todaydate,
                            step: 5
                         });
                        for(i=0;i<6;i++){
                            if(carrier_type==0){
                                if(i!=0){
                                    $("#trip_legs_row_"+i).addClass("trdisbale");
                                }
                            }else{
                                $("#trip_legs_row_"+i).removeClass("trdisbale");
                            }
                           
                            gettriplegs(i);
                    
                         }
                    });
                //});
            },
             error: function(errMsg) {
    
                        }
        });
    });
    $(".suc_pop_cancel").off("click").on("click", function () {
        $("#insert_success_div").modal("hide");
    });
    return false;
	}
	
	// return false;
}

/* Status Bar Code */

var lastJQueryTS = 0;

function isValidDate(dateStr) {
  var d = new Date(dateStr);
  year = "" + d.getFullYear();
  month = "" + (d.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
  day = "" + d.getDate(); if (day.length == 1) { day = "0" + day; }
  hour = "" + d.getHours(); if (hour.length == 1) { hour = "0" + hour; }
  minute = "" + d.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
  /*console.log(year);*/
  if(year != 9999){
    return true;
  }else{
    return false;
  }
}

	  var tripid1 = 0;

    var shipid1 = 0;

    var ordid1 = 0;

    var stopid1 = 0;

	 var leg_id1 = 0;

    var stopdetid1 = 0;

    var s_type1 = "";

    var type1 = 0;

    var dt1 = '';

    var sts1 = 0;

function orderlegupdstatus(trip_id, shift_id, veh, driver, tracktype, trackvendor, drivermobi, order_id, orderid, stopid, stopdetid, value = '', type, s_type, sts, rowid,legcheck) {

  if (ordid1 == '0') {
    var tripid1 = trip_id;
    var shipid1 = shift_id;
    var ordid1 = order_id;
    var stopid1 = stopid;
    var stopdetid1 = stopdetid;
    var s_type1 = s_type;
    var stsid1 = type;
    var dt1 = value;
    var sts1 = sts;
    var gohead = 1;
  } else {
    var earlyShipmentId = '';
    var earlystatusId = '';
    var earlyStopType = '';
    if ((tripid1 == trip_id) && (shipid1 == shift_id) && (ordid1 == order_id) && (stopid1 == stopid) && (stopdetid1 == stopdetid) && (s_type1 = s_type) && (stsid1 = type) && (dt1 == value) && (sts1 == sts)) {
      var gohead = 0;
    } else {
      var gohead = 1;
    }
  }
  if (gohead == 1) {
    var percent = 0;
    var send = true;
    var isRunning = false;
    if (typeof (event) == 'object') {
      if (event.timeStamp - lastJQueryTS < 200) {
        send = false;
      }
      lastJQueryTS = event.timeStamp;
    }
    if (send) {
      var splitarray = legcheck.split("-");
      var statusType = splitarray[0];
      var shipment = splitarray[1];
      var legno = splitarray[2];
      if (value == "" && sts == '0') {
        var upddt = "";
        var whrupd = actualdt = "";
        if (type == "10") {
          if(legno >1){
            var earlylegno = legno -1;
            if(earlylegno >0){
              if ($('.'+statusType+'-'+shipment+'-'+earlylegno).length > 0) {
                var chckearlyleg = $('.'+statusType+'-'+shipment+'-'+earlylegno).val();
                if(chckearlyleg == ""){
                  var message = 'Please select accept status for '+shipment+'-'+earlylegno;
                  gettoast('top-right','sacceptcr'+shift_id,message);
                  $("#sacceptcr"+shift_id).val("");
                  return false;
                }
              }else{
                earlyShipmentId = shipment+'-'+earlylegno;
                earlystatusId = '10';
                earlyStopType = '';
              }
            }
          }
          upddt = $("#sacceptcr" + shift_id).val();
          actualdt = "sacceptcr" + shift_id;
          whrupd = "sacceptchk" + shift_id;
        } else if (type == "2" && s_type == "P") {
          if ($("#sacceptcr" + shift_id).val() == "") {
            gettoast('top-right','sgateincr'+order_id+""+rowid,'Please check the statuses in sequence only!');
            $("#sgateincr"+order_id+""+rowid).val("");
            return false;
          }
          if(legno >1){
            var earlylegno = legno -1;
            if(earlylegno >0){
              if ($('.'+statusType+'-'+shipment+'-'+earlylegno).length > 0) {
                var chckearlyleg = $('.dgateout-'+shipment+'-'+earlylegno).val();
                if(chckearlyleg == ""){
                  var message = 'Please select GateOut status for '+shipment+'-'+earlylegno;
                  gettoast('top-right','sgateincr'+order_id+""+rowid,message);
                  $("#sgateincr"+order_id+""+rowid).val("");
                  return false;
                }
              }else{
                earlyShipmentId = shipment+'-'+earlylegno;
                earlystatusId = '3';
                earlyStopType = 'D';
              }
            }
          }
          upddt = $("#sgateincr" + order_id + "" + rowid).val();
          actualdt = "sgateincr" + order_id + "" + rowid;
          whrupd = "sgateinchk"+rowid;
        } else if (type == "1" && s_type == "P") {
          if ($("#sgateincr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right','spickupcr'+order_id+""+rowid,'Please check the statuses in sequence only!');
            $("#spickupcr"+order_id+""+rowid).val("");
            return false;
          }
          upddt = $("#spickupcr" + order_id + "" + rowid).val();
          actualdt = "spickupcr" + order_id + "" + rowid;
          whrupd = "spickupchk" + rowid;
        } else if (type == "3" && s_type == "P") {
          if ($("#spickupcr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right', 'sgateoutcr' + order_id + "" + rowid, 'Please check the statuses in sequence only!');
            $("#sgateoutcr" + order_id + "" + rowid).val("");
            return false;
          }
          upddt = $("#sgateoutcr" + order_id + "" + rowid).val();
          actualdt = "sgateoutcr" + order_id + "" + rowid;
          whrupd = "sgateoutchk" + rowid;
        } else if (type == "2" && s_type == "D") {
          if ($("#sgateoutcr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right', 'dgateincr' + order_id + "" + rowid, 'Please check the statuses in sequence only!');
            $("#dgateincr" + order_id + "" + rowid).val("");
            return false;
          }
          upddt = $("#dgateincr" + order_id + "" + rowid).val();
          actualdt = "dgateincr" + order_id + "" + rowid;
          whrupd = "dgateinchk" + rowid;
        } else if (type == "1" && s_type == "D") {
          if ($("#dgateincr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right', 'dpickupcr' + order_id + "" + rowid, 'Please check the statuses in sequence only!');
            $("#dpickupcr" + order_id + "" + rowid).val("");
            return false;
          }
          upddt = $("#dpickupcr" + order_id + "" + rowid).val();
          actualdt = "dpickupcr" + order_id + "" + rowid;
          whrupd = "dpickupchk" + rowid;
        } else if (type == "3" && s_type == "D") {
          if ($("#dpickupcr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right', 'dgateoutcr' + order_id + "" + rowid, 'Please check the statuses in sequence only!');
            $("#dgateoutcr" + order_id + "" + rowid).val("");
            return false;
          }
          upddt = $("#dgateoutcr" + order_id + "" + rowid).val();
          actualdt = "dgateoutcr" + order_id + "" + rowid;
          whrupd = "dgateoutchk" + rowid;
        } else if (type == "11") {
          if ($("#dgateoutcr" + order_id + "" + rowid).val() == "") {
            gettoast('top-right', 'tclosecr' + shift_id, 'Please check the statuses in sequence only!');
            $("#tclosecr" + shift_id).val("");
            return false;
          }
          upddt = $("#tclosecr" + shift_id).val();
          actualdt = "tclosecr" + shift_id;
          whrupd = "tclosechk" + shift_id;
        }
        var sts = $("#" + whrupd).val();
        if (isValidDate(upddt)) {
          if (upddt != "" && sts == "0") {
            $.ajax({
              url: baseurl + "admin/update_order_status",
              data:{'trip_id':trip_id,'ship_id':shift_id,'vehicle_id':veh,'driver_id':driver,'tracktype':tracktype,'trackvendor':trackvendor,'contact_num':drivermobi,'ord_id':order_id,'orderid':orderid,'stopid':stopid,'stopdetid':stopdetid,'stop_type':s_type,'stsid':type,'sts_date':upddt,'status':sts,'crossborder':'1','earlyShipmentId':earlyShipmentId,'earlystatusId':earlystatusId,'earlyStopType':earlyStopType},
              type: "POST",
              dataType: "HTML",
              beforeSend: function () {
                $(".stschkerror").html("<font color='red'>Please wait!</font>");
              },
              success: function (data) {
                percent = 100;
                isRunning = false;
                $(".percent").html(percent);
                if (data == 1) {
                  $("#" + actualdt).val(upddt);
                  $("#" + actualdt).css("background-color", "#1aa41a");
                  $("#" + actualdt).css("color", "#ffffff");
                  var succmsg = "<center><font color='green'>Mass Status Updated successfully!</font></center>";
                  if ($("#" + whrupd).length) {
                    $("#" + whrupd).val("1");
                  }
                  if (type == 10 || type == 11) {
                    window.location.reload();
                  }
                } else if (data == 3) {
                  $("#" + actualdt).val("");
                  var succmsg = "<center><font color='red'>Please Close the Previous shipments for the Orders</font></center>";
                } else {
                  $("#" + actualdt).val("");
                  var succmsg = "<center><font color='red'>Please enter proper details to update the status</font></center>";
                }
                $(".stschkerror").html("");
              }
            });
          }
        }
      }
    }
  }
}

      // Company Code
            $('#company_code').autocomplete({
                source: function (request, response) {
                    $.ajax({
                        url: baseurl + 'orders/getcompanyname',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            term: request.term,
                        },
                        success: function (data) {
                            if (data.length == '0') {
                                $('#company_code').val('');
                                $('#company_code').focus();
                            } else {
                                response($.map(data, function (item) {
                                    return {
                                        id: item.id,
                                        value: item.company_code
                                    };
                                }));
                            }
                        }
                    });
                }
            });

            // Branch Code
            $('#branch_code').autocomplete({
                source: function (request, response) {
                    var cmp_code = $('#company_code').val();
                    if (cmp_code !== "") {
                        $.ajax({
                            url: baseurl + 'orders/getbranchbycompany',
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                term: request.term,
                                cmp_code: cmp_code
                            },
                            success: function (data) {
                                response($.map(data, function (item) {
                                    return {
                                        id: item.id,
                                        value: item.branch_code
                                    };
                                }));
                                if (data.length == '0') {
                                    $('#branch_code').val('');
                                    $('#branch_code').focus();
                                }
                            }
                        });
                    } else {
                        $('#branch_code').val('');
                        $('#company_code').focus();
                    }
                }
            });

            // Shipping Edit Form Submit
            function saveShipment() {
				var carrier_type = $.trim($('#carrier_type').val());
				var border_type = $.trim($('#border_type').val());
				var company_code = $.trim($('#company_code').val());
				var branch_code = $.trim($('#branch_code').val());
				var department_code = $.trim($('#department_code').val());
				var totladata=0;
				var legdata=0;
				var tripsdata={};
				for(i=0;i<6;i++){
					var leg_id_value = $.trim($('#leg_id_value_'+i).val());
					var shipper_row_id = $.trim($('#shipper_row_id_'+i).val());
					var drop_row_id = $.trim($('#drop_row_id_'+i).val());
					var vendor_id = $.trim($('#vendor_id_'+i).val());
					var vehicle_type = $.trim($('#vehicle_type_'+i).val());
					var vehicle_id	 = $.trim($('#vehicle_id_'+i).val());
					var driver_id = $.trim($('#driver_id_'+i).val());
					var splace = $.trim($('#splace_'+i).val());
					var startdate = $.trim($('#startdate_'+i).val());
					var eplace = $.trim($('#eplace_'+i).val());
					var enddate = $.trim($('#enddate_'+i).val());
					var leg_number_value = $.trim($('#leg_number_value_'+i).val());
					var modeof_transport = $.trim($('#modeof_transport_'+i).val());

					if(carrier_type==0){
						if(i==0){
							if((shipper_row_id==0  ||  splace=="") || (drop_row_id==0 || eplace=="") || startdate=="" || enddate=="" || vendor_id==0){

                                if(splace == "" || shipper_row_id== 0){
                                    gettoast('top-right','splace_'+i,'Please Enter Pickup Location in the Line '+i);
                                    return false;
                                }
                                if(startdate == ""){
                                    gettoast('top-right','startdate_'+i,'Please Enter Start Date in the Line '+i);
                                    return false;
                                }
                                if(eplace == "" || drop_row_id==0){
                                    gettoast('top-right','eplace_'+i,'Please Enter Dropping Location in the Line '+i);
                                    return false;
                                }

                                if(enddate == ""){
                                    gettoast('top-right','enddate_'+i,'Please Enter End Date in the Line '+i);
                                    return false;
                                }
								if(vendor_id== 0){
									gettoast('top-right','vendor_id_'+i,'Please Select Carrier Name in the Line '+i);
									return false;
								}


							}else{
								var date1 = new Date(startdate).getTime();
								var date2 = new Date(enddate).getTime();
								 var msec = date2 - date1;
								var mins = Math.floor(msec / 60000);
								if(mins<=0){
									totladata++;
									gettoast('top-right','enddate','Please Enter Correct Dates in the Line '+(i+1));
									return false;
								}else{

									tripsdata[i]=[];
									tripsdata[i].push({"leg_id":leg_id_value,"leg_number_value":leg_number_value,"vendor_id": vendor_id, "vehicle_type": vehicle_type, "vehicle_id": vehicle_id, "driver_id": driver_id, "splace": splace, "startdate": startdate,"eplace": eplace, "enddate": enddate,"shipper_row_id":shipper_row_id,"drop_row_id":drop_row_id,"modeof_transport":modeof_transport});
								}
							}


						}
					}else{
                        if(shipper_row_id!=0 && splace!="" ){

                            if((shipper_row_id==0  ||  splace=="") || (drop_row_id==0 || eplace=="") || startdate=="" || enddate=="" || vendor_id==0){

                                if(splace == "" || shipper_row_id== 0){
                                    gettoast('top-right','splace_'+i,'Please Enter Pickup Location in the Line '+i);
                                    return false;
                                }
                                if(startdate == ""){
                                    gettoast('top-right','startdate_'+i,'Please Enter Start Date in the Line '+i);
                                    return false;
                                }
                                if(eplace == "" || drop_row_id==0){
                                    gettoast('top-right','eplace_'+i,'Please Enter Dropping Location in the Line '+i);
                                    return false;
                                }

                                if(enddate == ""){
                                    gettoast('top-right','enddate_'+i,'Please Enter End Date in the Line '+i);
                                    return false;
                                }
                                if(vendor_id== 0){
                                    gettoast('top-right','vendor_id_'+i,'Please Select Carrier Name in the Line '+i);
                                    return false;
                                }


                            }else{


							var date1 = new Date(startdate).getTime();
							var date2 = new Date(enddate).getTime();
							 var msec = date2 - date1;
							var mins = Math.floor(msec / 60000);
							if(mins<=0){
								totladata++;
								gettoast('top-right','enddate_'+i,'Please Enter Correct Dates in the Line '+(i+1));
								return false;
							}else if(i!=0){
								var startdate2=$("#enddate_"+(i-1)).val();
								var date3 = new Date(startdate2).getTime();
								var date4 = new Date(startdate).getTime();
								 var msec1 = date4 - date3;
								var mins1 = Math.floor(msec1 / 60000);
								if(mins1<=0){
									totladata++;
									gettoast('top-right','enddate_'+i,'Please Enter Origin Date in the Line '+(i+1));
									return false;
									$("#startdate_"+i).css("border","1px solid red");
								}else if(mins<=0){
									totladata++;
									gettoast('top-right','enddate_'+i,'Please Enter Correct Dates in the Line '+(i+1));
									return false;
								}else{
									tripsdata[i]=[];
									tripsdata[i].push({"leg_id":leg_id_value,"leg_number_value":leg_number_value,"vendor_id": vendor_id, "vehicle_type": vehicle_type, "vehicle_id": vehicle_id, "driver_id": driver_id, "splace": splace, "startdate": startdate,"eplace": eplace, "enddate": enddate,"shipper_row_id":shipper_row_id,"drop_row_id":drop_row_id,"modeof_transport":modeof_transport});
								}

							} else{
								if(shipper_row_id==0 || drop_row_id==0 ||  splace=="" || startdate=="" || eplace=="" || enddate=="" || vendor_id==0){
									totladata++;
								}else{
									tripsdata[i]=[];
									tripsdata[i].push({"leg_id":leg_id_value,"leg_number_value":leg_number_value,"vendor_id": vendor_id, "vehicle_type": vehicle_type, "vehicle_id": vehicle_id, "driver_id": driver_id, "splace": splace, "startdate": startdate,"eplace": eplace, "enddate": enddate,"shipper_row_id":shipper_row_id,"drop_row_id":drop_row_id,"modeof_transport":modeof_transport});
								}


							}

                        }

					}
					}
				}

				if(carrier_type== ""){
					gettoast('top-right','carrier_type','Please Select Carrier Name');
					return false;
				}else if(border_type == ""){
					gettoast('top-right','border_type','Please Select Shipment Type');
					return false;
				}  else if(company_code == ""){
					gettoast('top-right','company_code','Please Enter Company Code');
					return false;
				}   else if(branch_code == ""){
					gettoast('top-right','branch_code','Please Enter Branch Code');
					return false;
				 } else{
					console.log(tripsdata);
					if(totladata==0){
						//alert("submit");
						 $("#insert_success_div").modal("show");
                         $(".suc_pop_ok").off("click").on("click", function () {
							var shift_id=$("#shipment_id").val();
							$.ajax({
    							url: $("#shipment_form").attr("action"),
    							type: "POST",
    							data: {"carrier_type":carrier_type,"border_type":border_type,"company_code":company_code,"branch_code":branch_code,"department_code":department_code,"tripsdata":tripsdata,'shift_id':shift_id},
    							dataType: "JSON",
    							beforeSend: function () {
    								$(".overlay").show();
    							},
    							success: function (data) {
    								//alert(data);
    							  $(".overlay").hide();
    								if (data.status == "0") {
    									alert("Shipment saving failed.");
    								} else {
    									    //$("#insert_success_div").modal('hide');
                                            legsdatainfo1=(data.legsdatainfo).split(',');
                                            legsdatashipinfo1=(data.legsdatashipinfo).split(',');
    
                                            for(i=0;i<(legsdatainfo1.length-1);i++){
                                                $("#leg_id_value_"+i).val(legsdatainfo1[i]);
                                                $("#leg_number_value_"+i).val(legsdatashipinfo1[i]);
                                            }
                                            $("#insert_success_div").modal('hide');
                                           	//window.location.reload();
                                            getshiplegdetails(shift_id);
    									//});
    								}
    							},
    							error: function () {
    								$(".overlay").hide();
    								alert("Got some error while creating shipment.");
    							}
                            });
						});
						$(".suc_pop_cancel").off("click").on("click", function () {
                          alert("test");
                          var shift_id = $("#shipment_id").val();
                          const shiftUrl = baseurl + "trips/KNETtripsedit/" + shift_id;
                          var carrier_type = $("#carrier_type").val();
                          var today = new Date();
                          var date = today.getFullYear() + "-" + (today.getMonth() + 1) + "-" + today.getDate();
                          var time = today.getHours() + ":" + today.getMinutes();
                          var todaydate = date + " " + time;
                          $("#insert_success_div").modal("hide");
                          $("#editModal .modal-content").load(shiftUrl, function () {
                            for (var i = 0; i < 6; i++) {
                              if (carrier_type == 0) {
                                if (i != 0) {
                                  $("#trip_legs_row_" + i).addClass("trdisbale");
                                }
                              } else {
                                $("#trip_legs_row_" + i).removeClass("trdisbale");
                              }
                              gettriplegs(i);
                            }
                            $(".select_date").datetimepicker({
                              startDate: todaydate,
                              step: 5,
                            });
                          });
                        });
					}
                }
			    return false;
            }

            // Get No Ship Orders
            function getnoshiporders() {
				var border_type=$("#border_type").val();

                var table = $('#orderlist_tab').DataTable();
                table.destroy();
                $("#view_orders").modal('show');
                $("#view_orders_title").html('Orders List');
                $.ajax({
                    url: baseurl + 'trips/getnoshiporders',
                    type: 'POST',
					data: {"border_type":border_type},
                    dataType: 'json',
                    success: function (data) {
                        $("#orderlist_tab").DataTable({
                            data: data,
                            'checkboxes': {
                                'selectRow': true
                            },
                            "bPaginate": true,
                            "paging": true,
                            "bLengthChange": true,
                            "bFilter": true,
                            "bInfo": false,
                            "bAutoWidth": true,
                            "language": {
                                "lengthMenu": '<select class="form-control"><option value="10">10</option><option value="20">20</option><option value="30">30</option><option value="40">40</option><option value="50">50</option><option value="-1">All</option></select>',

                            },
                            dom: 'Blfrtip',
                            buttons: [
                                'copyHtml5',
                                'excelHtml5',
                                'csvHtml5',
                                'pdfHtml5',
                                'print'
                            ],
                            "columns": [

                                {"data": "checkbox"},
                                {"data": "order_id"},
                                {"data": "pickup_company"},
                                {"data": "delivery_company"},
                                {"data": "transport_mode"},
                                {"data": "quantity"},
                                {"data": "weight"},
                                {"data": "volume"},
                            ],
                        });
                    }
                });
            }

            // Get Selected Order Details
            function getselectedorderdetails(order_id) {
                $('#orderpickupdata').hide();
                $('#orderdropdata').hide();
                $('.orderpickup_data').html('');
                $('.orderdrop_data').html('');
                $.ajax({
                    url: baseurl + 'trips/getorderdetailsbyid',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'order_id': order_id},
                    beforeSend: function () {
                    },
                    success: function (data) {
                       // console.info(data);
                        var orders = data.orders;
                        var legs = data.legs;
                        var legs_data = "";
                        var pickup_data = '';
                        var drop_data = '';

                      $("input:checkbox[name=triplegs]").each(function () {
                        $("#" + $(this).attr("id")).prop('checked', false);
                      });
                      if (legs.length > 1) {
                        $.each(legs, function (i, obj) {
                          $("#triplegs_" + obj.shift_id).prop('checked', true);
                        });
                      }
						gettriordercargodetails(order_id);
                        if (orders.pname != undefined) {
                            $('.orders_stops_body').html('<tr class="tripstopRow_' + order_id + '"><td>Pickup</td><td>' + orders.pname + '</td><td>' + orders.pstreet + '</td><td>' + orders.pstate + '</td><td>' + orders.pcity + '</td><td>' + orders.pcountry + '</td><td>' + orders.ppincode + '</td></tr><tr class="tripstopRow_' + order_id + '"><td>Drop</td><td>' + orders.dname + '</td><td>' + orders.dstreet + '<td>' + orders.dstate + '</td><td>' + orders.dcity + '</td><td>' + orders.dcountry + '</td><td>' + orders.dpincode + '</td></tr>');
                            $('.orderpickup_data').html('<tr><td>' + legs.pickup + '</td></tr>');

                        }
                    }
                });
            }

			function gettriordercargodetails(order_id){

				 $.ajax({
                    url: baseurl + 'trips/getordercargodetails',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'order_id': order_id},
                    beforeSend: function () {
                    },
                    success: function (data) {
						var text='';
						for(i=0;i<data.length;i++){
							var response1 = JSON.parse(JSON.stringify(data[i]));
							var cargo_type=response1["cargo_type"];
							var quantity=response1["quantity"];
							var scanned_quantity=response1["scanned_quantity"];
							var length=response1["length"];
							var width=response1["width"];
							var height=response1["height"];
							var weight=response1["weight"];
							var volume=response1["volume"];
							var volumetric_weight=response1["volumetric_weight"];
							var ldm=response1["ldm"];
							var orderlegs=response1["orderlegs"];
                                  $("input[name='triplegs[]']").each(function (index, obj) {
                                    $("#" + $(this).attr("id")).prop("checked", false);
                    
                                  });
                                  if (orderlegs.length > 0) {
                                    for (i = 0; i < orderlegs.length; i++) {
                                      $("#triplegs_" + orderlegs[i]['shift_id']).prop("checked", true);
                    
                                    }
                                  }
							text+='<tr class="cargorow_' + order_id + '"><td align="Center">'+cargo_type+'</td><td align="Center">'+quantity+'</td><td align="Center">'+scanned_quantity+'</td><td align="Center">'+length+'</td><td align="Center">'+width+'</td><td align="Center">'+height+'</td><td align="Center">'+weight+'</td><td align="Center">'+volumetric_weight+'</td><td align="Center">'+volume+'</td><td align="Center">'+ldm+'</td></tr>';


						}
						$('#orderdrop_data').html(text);
					}
                });

			}



            function selectoderfromlist() {
                var ids = '';
                var myTable = $('#orderlist_tab').DataTable();
                var rowcollection = myTable.$(".noshift_list:checked", {"page": "all"});
                rowcollection.each(function (index, elem) {
                    //You have access to the current iterating row
                    var checkbox_value = $(elem).val();
                    //Do something with 'checkbox_value'
                    if (ids == '') {
                        ids = checkbox_value;
                    } else {
                        ids = ids + ',' + checkbox_value;
                    }
                });
                $('#view_orders').modal('hide');
			     var shift_id=$("#shipment_id").val();
				//alert(ids);
                // Ajax call to insert orders
				//alert(trip_id);
                $.ajax({
                    url: baseurl + 'trips/addorders',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'orderids': ids,'shift_id': shift_id},
                    beforeSend: function () {
                    },
                    success: function (data) {
                        if (data.status == 1) {
                            $(".popup_circle").removeClass('glyphicon-remove-circle');
                            $(".popup_circle").addClass('glyphicon-ok-circle');
                            $(".popup_circle").css("color", "green");
                            $(".pop_message").html('Order(s) Added Successfully !!');
                            $("#insert_success_div").modal('show');
                            /*$(".success_redirect").on('click', function () {
                                //("#insert_success_div").modal('hide');
                                getshiporderdetails(shift_id);
                            });*/
                            $(".suc_pop_ok").off("click") .on("click", function () {
                                $("#insert_success_div").modal("hide");
                                getshiporderdetails(shift_id);
                            });
                            $(".suc_pop_cancel").off("click").on("click", function () {
                                $("#insert_success_div").modal("hide");
                            });
                        } else {
                            $("#dialog_box").dialog();
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $("#dialog_text").text("Oops...something went wrong");
                        }
                    }
                });
            }

            function getshiporderdetails(shipmentid){

                 $.ajax({
                    url: baseurl + 'trips/getshiporderdetails',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'shift_id': shipmentid},
                    beforeSend: function () {
                    },
                    success: function (data) {
                        var orderslist= data.shiftOrders;
                        var tablecont='';
                          $.each(orderslist, function (key, value) {
                            tablecont+='<tr id="trip_order_'+value["orderRowId"]+'"><td><input class="form-control" type="radio" name="radio_order" onclick="getselectedorderdetails('+value["orderRowId"]+')" id="radio_'+value["orderRowId"]+'" value="'+value["orderRowId"]+'" ></td><td><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;"><li><a href="#" onclick="deleteorderbyid('+value["orderRowId"]+')" class="dt-delete"><span class="icon tru-icon-delete" aria-hidden="true"></span>Delete</a></li></ul></li></ul></td><td>'+value["bookingId"]+'</td><td>'+value["pickupCompany"]+'</td><td>'+value["deliveryCompany"]+'</td><td>'+value["orderStatus"]+'</td><td>'+value["transportMode"]+'</td><td>'+value["quantity"]+'</td><td>'+value["weight"]+'</td><td>'+value["volume"]+'</td><td>'+value["createdOn"]+'</td></tr>';
                          });
                       $("#tbodyDynamicorderData").html(tablecont);
                    }
                });

            }

            function getshiplegdetails(shipmentid){

                 $.ajax({
                    url: baseurl + 'trips/getshiplegdetails',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'shift_id': shipmentid},
                    beforeSend: function () {
                    },
                    success: function (data) {
                        var legslist= data.shiftLegsdata;
                        var tablecont='';
                        for(i=0;i<legslist.length;i++){
                            var response1 = JSON.parse(JSON.stringify(legslist[i]));
                            tablecont+='<tr><td><div class="checkbox checkbox-info"><label> <input type="checkbox" id="triplegs_'+response1["legId"]+'" class="triplegs" value="'+response1["legId"]+'" name="triplegs" /><span class="cr"><i class="cr-icon fa fa-check"></i></span> </label></div></td><td>'+response1["legNumber"]+'</td><td>'+response1["fromCity"]+'</td><td>'+response1["startDate"]+'</td><td>'+response1["toCity"]+'<td>'+response1["endDate"]+'</td></tr>';

                      }
                       $("#tbodyDynamiclegsData").html(tablecont);
                    }
                });

            }

            function deleteorderbyid(order_id) {
				var shift_id=$("#shipment_id").val();
                $.ajax({
                    url: baseurl + 'trips/deleteOrder',
                    type: "POST",
                    dataType: 'JSON',
                    data: {'order_id': order_id, 'shift_id': shift_id},
                    beforeSend: function () {
                    },
                    success: function (data) {
                        console.info(data);
                        if (data.status == 1) {
                            $(".popup_circle").removeClass('glyphicon-remove-circle');
                            $(".popup_circle").addClass('glyphicon-ok-circle');
                            $(".popup_circle").css("color", "green");
                            $(".pop_message").html('Order Deleted Successfully !!');
                            $("#insert_success_div").modal('show');
                            $(".suc_pop_ok").on('click', function () {
                               $("#trip_order_" + order_id).hide();          
                               $(".tripstopRow_" + order_id).hide(); 
                               $(".cargorow_" + order_id).hide();
                               $("#insert_success_div").modal('hide');
                               
                            });
                            $(".suc_pop_cancel").on('click', function () {
                                $("#insert_success_div").modal('hide');
                            });
                            /*$(".success_redirect").on('click', function () {
                                $("#trip_order_"+order_id).hide();
                            });*/
                        } else {
                            $("#dialog_box").dialog();
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $('.ui-dialog-title').addClass('fa fa-warning');
                            $("#dialog_text").text("Oops...something went wrong");
                        }
                    }
                });
            }

function gettoast(position, id, desp) {
  if (id != "") {
    if (!$('#' + id).hasClass('errorclass')) {
      $('#' + id).addClass('errorclass');
    }
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  });
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>' + desp + '</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout: 900
  });
}

   function checkdate(event){
	   return false;
   }
   function getlaneforcost(service_id){
	   //alert(service_id);
	   	   if(service_id!=0){
				$.ajax({
					url: baseurl+'trips/getlanevalues',
					type:"POST",
					dataType:'JSON',
					data:{'service_id':service_id},
					success:function(data){
						//alert(data);
						var text='<option value="0">Select</option>';
						for(i=0;i<data.length;i++){
							var response1 = JSON.parse(JSON.stringify(data[i]));
							var id=response1["id"];
							var lane_id=response1["lane_id"];
							var lane_name=response1["lane_name"];

							text+='<option value="'+id+'">'+lane_id+' - '+lane_name+'</option>';

						}
						//alert(text);
						$("#costlane").html(text);
					}
				});

		   }else{
			  $("#costlane").html('<option value="0">Select</option>');
		   }
   }

   function getrateofferingbylaneid(lanid){
	   var rate_service = $('#costrate_service').val();
	   	   if(lanid!=0){
				$.ajax({
					url: baseurl+'trips/getRateOffering',
					type:"POST",
					dataType:'JSON',
					data:{'lanid':lanid,'rate_service':rate_service},
					success:function(data){
						//alert(data);
						var text='<option value="0">Select</option>';
						for(i=0;i<data.length;i++){
							var response1 = JSON.parse(JSON.stringify(data[i]));
							var id=response1["id"];
							var offering_id=response1["offering_id"];
							var offering_name=response1["offering_name"];

							text+='<option value="'+id+'">'+offering_id+' - '+offering_name+'</option>';

						}
						//alert(text);
						$("#costrate_offering").html(text);
					}
				});

		   }else{
			  $("#costrate_offering").html('<option value="0">Select</option>');
		   }
   }
      function getraterecordbyofferingid(rate_offering){
	  costrate_offering=$('#costrate_offering').val();
      if(costrate_offering != 0){
         $.ajax({
           url: baseurl+'trips/getrecord_byoffering',
           type:"POST",
           dataType:'JSON',
           data:{'offering_id':costrate_offering},
           success:function(data){
            var opt = "<option value=''>Select</option>";
            if(data.length >0){
                    $.each(data,function(key,value){
                        opt +="<option value='"+value.record_row_id+"'>"+value.record_name+"</option>";
                    });
                }

                  $('#costrate_record').html(opt);

           }
        });
      }else{
			  $("#costrate_record").html('<option value="0">Select</option>');
		   }
   }

    function applycostchargesbyrates(e){
      e.preventDefault();
      var costrate_service = $('#costrate_service').val();
      var lane_id = $('#costlane').val();
      var costrate_record = $('#costrate_record').val();
      var costrate_offering = $('#costrate_offering').val();
	  var shift_id=$("#shipment_id").val();
      if(costrate_service != 0 && lane_id != 0 && costrate_record != 0 && costrate_offering != 0 ){
         $.ajax({
           url: baseurl+'trips/getcostratesdata',
           type:"POST",
           dataType:'JSON',
           data:{'costrate_service':costrate_service,'type':'1','costrate_record':costrate_record,'lane_id':lane_id,'costrate_offering':costrate_offering,'shift_id': shift_id},
           success:function(data){
			  var catsvalues="";
			  if(data.length>0){
				   $.each(data,function(key,value){
                        catsvalues +='<tr><td></td><td style="min-widtd: 150px">'+value.recipient_role+'</td><td style="min-widtd: 250px">'+value.recipient_code+'</td><td style="min-widtd: 150px">'+value.recipient_name+'</td><td style="min-widtd: 150px">'+value.accrual_amount+'</td><td style="min-widtd: 150px">'+value.amount+'</td><td style="min-widtd: 150px">'+value.currency+'</td><td style="min-widtd: 150px">'+value.bu_jfr+'</td><td style="min-widtd: 150px">'+value.debtor_jfr+'</td><td>'+value.foreign_currency+'</td><td style="min-widtd: 150px">'+value.exchange_rate+'</td><td style="min-widtd: 150px">'+value.accrual_foreign_amount+'</td><td style="min-widtd: 150px">'+value.actual_foreign_amount+'</td><td style="min-widtd: 150px">'+value.invoice_number+'</td><td style="min-widtd: 150px">'+value.credit_note_number+'</td><td style="min-widtd: 150px">'+value.invoice_date+'</td><td style="min-widtd: 150px">'+value.invoice_creation_date+'</td><td style="min-widtd: 150px">'+value.invoice_receivdon_date+'</td><td style="min-widtd: 150px">'+value.status+'</td></tr>';
                    });
				  $("#totalcostvalues").html(catsvalues);
			  }else{
				  $("#totalcostvalues").html('<tr><td align="Center" colspan="18">No Data Found</td></tr>');
			  }

           }
        });
      }else{
		 gettoast('top-right','totalcostvalues','Please select at least one option');
	  }

   }
  /*  function getorderdetails(value,type){
	   if(value!=""){
		   $.ajax({
           url: baseurl+'trips/getorderdetails',
           type:"POST",
           dataType:'JSON',
           data:{'searchvalue':value,'type':type},
           success:function(data){
				var text='';
			for(i=0;i<data.length;i++){
				var response1 = JSON.parse(JSON.stringify(data[i]));
				var checkbox=response1["checkbox"];
				var id=response1["id"];
				var order_id=response1["order_id"];
				var pickup_company=response1["pickup_company"];
				var delivery_company=response1["delivery_company"];
				var transport_mode=response1["transport_mode"];
				var quantity=response1["quantity"];
				var weight=response1["weight"];
				var volume=response1["volume"];
				if(i%2==0){
					text+='<tr role="row" class="odd"><td class="sorting_1">'+checkbox+'</td> <td>'+order_id+'</td><td>'+pickup_company+'</td><td>'+delivery_company+'</td><td>'+transport_mode+'</td><td>'+quantity+'</td><td>'+weight+'</td><td>'+volume+'</td></tr>';
				}else{
					text+='<tr role="row" class="even"><td class="sorting_1">'+checkbox+'</td> <td>'+order_id+'</td><td>'+pickup_company+'</td><td>'+delivery_company+'</td><td>'+transport_mode+'</td><td>'+quantity+'</td><td>'+weight+'</td><td>'+volume+'</td></tr>';
				}


			}
			$('#orderslist-show_data').html(text);
           }
        });

	   }


   }
 */

  function getorderdetails(){
	var	order_id=$.trim($('#order_id').val());
	var	purchase_order=$.trim($('#purchase_order').val());
	var	delivery_note=$.trim($('#delivery_note').val());
	var	pickupdate=$.trim($('#pickupdate').val());
	var	delivery_date=$.trim($('#delivery_date').val());
	var	customer_id=$.trim($('#customer_id').val());
	var	cunsine_id=$.trim($('#cunsine_id').val());
	var	shipper_id=$.trim($('#shipper_id').val());
	var	ref_type=$.trim($('#ref_type').val());
	var	ref_val=$.trim($('#ref_val').val());
	  // if(order_id!="" || purchase_order!="" || delivery_note!="" || pickupdate!="" || delivery_date!="" || customer_id!="" || shipper_id!="" || cunsine_id!="" ||order_id!="" || ref_type!="" ||ref_val!="" ){
		   $.ajax({
           url: baseurl+'trips/getorderdetails',
           type:"POST",
           dataType:'JSON',
           data:{'order_id':order_id,'purchase_order':purchase_order,'delivery_note':delivery_note,'pickupdate':pickupdate,'delivery_date':delivery_date,'customer_id':customer_id,'shipper_id':shipper_id,'cunsine_id':cunsine_id,'ref_type':ref_type,'ref_val':ref_val},
           success:function(data){
			   var table = $('#orderlist_tab').DataTable();
				table.destroy();
				$("#view_orders").modal('show');
				$("#view_orders_title").html('Orders List');

				$("#orderlist_tab").DataTable({
				data: data,
				'checkboxes': {
					'selectRow': true
				},
				"bPaginate": true,
				"paging": true,
				"bLengthChange": true,
				"bFilter": true,
				"bInfo": false,
				"bAutoWidth": true,
				"language": {
					"lengthMenu": '<form method="POST" action=""  id="search_orders" <div="" class="form-group" style="width: 90%;"><div class="form-group"><select class="form-control"><option value="10">10</option><option value="20">20</option><option value="30">30</option><option value="40">40</option><option value="50">50</option><option value="-1">All</option></select>  <input style="width:18%" type="text" name="order_id" parsley-trigger="change" placeholder="Order ID" class="form-control ui-autocomplete-input" id="order_id" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()">  <input style="width:18%" type="text" name="purchase_order" parsley-trigger="change" placeholder="Purchase Order" class="form-control ui-autocomplete-input" id="purchase_order" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> <input style="width:18%" type="text" name="delivery_note" parsley-trigger="change" placeholder="Delivery Order" class="form-control" id="delivery_note" form="advsearch_orders" value="" onblur="getorderdetails()"> <input style="width:18%" type="text" class="form-control" form="search_orders" placeholder="Pickup Date" name="pickupdate" id="pickupdate" value="" autocomplete="off" onblur="getorderdetails()" onclick="getdatetimepicker(this);"> <input style="width:18%" type="text" class="form-control" form="search_orders" placeholder="Delivery Date" name="delivery_date" id="delivery_date" value="" autocomplete="off" onblur="getorderdetails()" onclick="getdatetimepicker(this);">    </div>      <br><div class="form-group" style="padding-top: 10px;"><input style="width:18%" type="text" name="customer_id" id="customer_id" parsley-trigger="change" placeholder="Customer ID" class="form-control ui-autocomplete-input" searchcustomer_id""="" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> <input style="width:18%" type="text" name="cunsine_id" id="cunsine_id" parsley-trigger="change" placeholder="Consignee ID" class="form-control ui-autocomplete-input" searchcustomer_id""="" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> <input style="width:18%" type="text" name="shipper_id" id="shipper_id" parsley-trigger="change" placeholder="Shipper ID" class="form-control ui-autocomplete-input" searchcustomer_id""="" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> <input style="width:18%" type="text" name="ref_type" id="ref_type" parsley-trigger="change" placeholder="Refrence Type" class="form-control ui-autocomplete-input" searchcustomer_id""="" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> <input style="width:18%" type="text" name="ref_val" id="ref_val" parsley-trigger="change" placeholder="Refrence Value" class="form-control ui-autocomplete-input" searchcustomer_id""="" form="search_orders" value="" autocomplete="off" onblur="getorderdetails()"> </div></form>',

				},
				dom: 'Blfrtip',
				buttons: [
					'copyHtml5',
					'excelHtml5',
					'csvHtml5',
					'pdfHtml5',
					'print'
				],
				"columns": [

					{"data": "checkbox"},
					{"data": "order_id"},
					{"data": "pickup_company"},
					{"data": "delivery_company"},
					{"data": "transport_mode"},
					{"data": "quantity"},
					{"data": "weight"},
					{"data": "volume"},
				],
				});

				/* var text='';
			for(i=0;i<data.length;i++){
				var response1 = JSON.parse(JSON.stringify(data[i]));
				var checkbox=response1["checkbox"];
				var id=response1["id"];
				var order_id=response1["order_id"];
				var pickup_company=response1["pickup_company"];
				var delivery_company=response1["delivery_company"];
				var transport_mode=response1["transport_mode"];
				var quantity=response1["quantity"];
				var weight=response1["weight"];
				var volume=response1["volume"];
				if(i%2==0){
					text+='<tr role="row" class="odd"><td class="sorting_1">'+checkbox+'</td> <td>'+order_id+'</td><td>'+pickup_company+'</td><td>'+delivery_company+'</td><td>'+transport_mode+'</td><td>'+quantity+'</td><td>'+weight+'</td><td>'+volume+'</td></tr>';
				}else{
					text+='<tr role="row" class="even"><td class="sorting_1">'+checkbox+'</td> <td>'+order_id+'</td><td>'+pickup_company+'</td><td>'+delivery_company+'</td><td>'+transport_mode+'</td><td>'+quantity+'</td><td>'+weight+'</td><td>'+volume+'</td></tr>';
				}


			}
			$('#orderslist-show_data').html(text); */
           }
        });

	  // }
	    return  false;
   }


	function gettriplegs(rowno){
    $.ajax({
           url: baseurl+'trips/gettriplegs',
           type:"POST",
           dataType:'JSON',
           data:{},
           success:function(data){
				var opt = " <option value='0'>Select</option>";
				if(data['CarrierNames'].length >0){
                    $.each(data['CarrierNames'],function(key,value){
                        opt +="<option value='"+value.id+"'>"+value.name+"</option>";
                    });
                }
				$('#vendor_id_'+rowno).html(opt);
				if($("#vendor_id_value_"+rowno).val()!=""){
					$('#vendor_id_'+rowno).val($("#vendor_id_value_"+rowno).val());
					getVehicleType(rowno,$("#vendor_id_value_"+rowno).val());
				}else{
					$('#vendor_id_'+rowno).val(0);
				}

           }
        });
	}

function getVehicleType(type,value){
	 $.ajax({
           url: baseurl+'trips/getVehicleType',
           type:"POST",
           dataType:'JSON',
           data:{'carrierid':value},
           success:function(data){

					var vehiclesdata = "<option value='0' selected='selected'>Select</option>";
					var trucktypedata = "<option value='0'  selected='selected'>Select</option>";
					if(data['vehicleid']!=""){
						$.each(data['vehicleid'],function(key,value){
							vehiclesdata +="<option value='"+value.vehicle_id+"'>"+value.truck_number+"</option>";
						});
					}
					if(data['trucktypedata']!=""){
						$.each(data['trucktypedata'],function(key,value){
							trucktypedata +="<option value='"+value.truck_type+"'>"+value.trucktype+"</option>";
						});
					}
					$('#vehicle_type_'+type).html(trucktypedata);
					$('#vehicle_id_'+type).html(vehiclesdata);

					var response1 =JSON.stringify(data['truckvechdata']);
					$('#vehicle_id_hide_'+type).html(response1);
					var response2 =JSON.stringify(data['vechicledrivers']);
					$('#vehicle_driver_hide_'+type).html(response2);
					if($("#vehicle_type_value_"+type).val()){
						$('#vehicle_type_'+type).val($("#vehicle_type_value_"+type).val());
						getVehicleids(type,$("#vehicle_type_value_"+type).val());
					}else{
						$('#vehicle_type_'+type).val(0);
					}

           }
        });
}

function getVehicleids(type,valuedta){
	var vehicle_ids=JSON.parse($('#vehicle_id_hide_'+type).html());
	var vehiclesdata = "<option value='0' selected='selected'>Select</option>";
	if(vehicle_ids[valuedta]!=undefined){
		$.each(vehicle_ids[valuedta],function(key,value){
			vehiclesdata +="<option value='"+value.vehicle_id+"'>"+value.truck_number+"</option>";
		});
		// alert(vehiclesdata);
		$('#vehicle_id_'+type).html(vehiclesdata);

		if($("#vehicle_id_value_"+type).val()!=""){
			$('#vehicle_id_'+type).val($("#vehicle_id_value_"+type).val());
			getdrivernames(type,$("#vehicle_id_value_"+type).val());
		}else{

			$('#vehicle_id_'+type).val(0);
		}
	}else{
		$('#vehicle_id_'+type).html(vehiclesdata);
	}



}

function getdrivernames(type,valuedta){
	var vehicle_ids=JSON.parse($('#vehicle_driver_hide_'+type).html());
	 var vehiclesdata = " <option value='0'>Select</option>";
	 if(vehicle_ids[valuedta]!=undefined){
		vehiclesdata +="<option value='"+vehicle_ids[valuedta]['driverid']+"'>"+vehicle_ids[valuedta]['drivername']+"</option>";
		$('#driver_id_'+type).html(vehiclesdata);


		if($("#driver_id_value_"+type).val()!=""){
			$('#driver_id_'+type).val($("#driver_id_value_"+type).val());

		}else{

			$('#driver_id_'+type).val(0);
		}
	 }else{
		 $('#driver_id_'+type).html(vehiclesdata);
	 }

}
function rowAddstatus(e){
            var tableId = $(e).closest('table').attr('id');
			var shift_id=$("#shipment_id").val();
            $.ajax({
               url: baseurl+'trips/checkordertrips',
               type: "POST",
               data: {'shift_id':shift_id},
               dataType: "JSON",
               success: function(data) {

                  var pshipid = data.pshipid;
                  var dshipid = data.dshipid;
                  var dstopdetailsid = data.dstopdetailsid;
                  var pstopdetailsid = data.pstopdetailsid;
                  var orderselect = data.orderselect;
                  var statusselect = data.statusselect;
                  var legselect = data.legselect;
              var rowvalue=$('#'+tableId+' tbody tr').length;
            var trOpen = "<tr >";
      var tds = '<td colspan="7"><form method="POST" action="'+baseurl+'trips/addstatus"  id="status_form" novalidate class="status_form" autocomplete="off"><table width="100%"><tr id="editing"><td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;"><li onclick="return savecustomstatus();"><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="rowEdit(this);"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul></td><td>'+legselect+'</td><td>'+orderselect+"</td><td>"+statusselect+'<input type="hidden" name="order_status_id" id="order_status_id" value=""><input type="hidden" name="status_name" id="status_name" value=""><input type="hidden" name="pshipid" id="pshipid" value="'+pshipid+'"><input type="hidden" name="dstopdetailsid" id="dstopdetailsid" value="'+dstopdetailsid+'"><input type="hidden" name="pstopdetailsid" id="pstopdetailsid" value="'+pstopdetailsid+'"></td><td><input  class="form-control" type="text" id="status_code" name="status_code" value="" ></td><td><select name="status_type" class="form-control" id="status_type"><option value="">Select</option><option value="P">P</option><option value="D">D</option></select></td><td><input  class="form-control" type="text" id="location" name="location" readonly value="" ></td><td><input type="text" name="status_date" id="status_date" class="form-control datepicker" onclick="getdatetimepicker(this);" value=""></td></tr></table></td>';
            var buttons = '</form>';

            var divClose = "";

            var trClose = "</tr></tbody></table></td>";

            var html = trOpen + tds + buttons + divClose + trClose;

             rowAddNewBetween('status_table', e, html);
              }
            });
         }

function getorderstatus(e,order_id){
			var shift_id=$("#shipment_id").val();
			var trip_id=$("#trip_id").val();
            var leg_id=$("#status_leg").val();

            $.ajax({
               url: baseurl+'trips/checktripfororder',
               type: "POST",
               data: {'order_id':order_id,"shift_id":shift_id,"trip_id":trip_id,"leg_id":leg_id},
               dataType: "JSON",
               success: function(data) {
                var select = data.select;
                  console.log(select);
                  var pshipid = data.pshipid;
                  var dshipid = data.dshipid;
                  var dstopdetailsid = data.dstopdetailsid;
                  var pstopdetailsid = data.pstopdetailsid;
                  var select = data.select;
                  var orderselect = data.orderselect;
                  var legselect = data.legselect;

            var tds = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;"><li onclick="return savecustomstatus();"><a id="bEdit" type="button" class="btn btn-sm btn-default" ><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul></td><td>'+legselect+'</td><td>'+orderselect+'</td><td>'+select+'<input type="hidden" name="pshipid" id="pshipid" value="'+pshipid+'"><input type="hidden" name="order_status_id" id="order_status_id" value="'+order_id+'"><input type="hidden" name="status_name" id="status_name" value=""><input type="hidden" name="dstopdetailsid" id="dstopdetailsid" value="'+dstopdetailsid+'"><input type="hidden" name="pstopdetailsid" id="pstopdetailsid" value="'+pstopdetailsid+'"></td><td><input  class="form-control" type="text" id="status_code" name="status_code" value=""  ></td><td><select name="status_type" class="form-control" id="status_type"><option value="">Select</option><option value="P">P</option><option value="D">D</option></select></td><td><input  class="form-control" type="text" id="location" name="location" readonly value="" ></td><td><input type="text" name="status_date" id="status_date" class="form-control datepicker" onclick="getdatetimepicker(this);" value=""></td>';

			// $("#"+trowid).html(tds);
			$("#editing").html(tds);


              }
            });
         }
function getlegorders(e,leg_id){
          var shift_id=$("#shipment_id").val();
            var trip_id=$("#trip_id").val();

            $.ajax({
               url: baseurl+'trips/checklegorder',
               type: "POST",
               data: {"leg_id":leg_id,"shift_id":shift_id},
               dataType: "JSON",
               success: function(data) {
                var select = data.select;
                  console.log(select);
                  var pshipid = data.pshipid;
                  var dshipid = data.dshipid;
                  var dstopdetailsid = data.dstopdetailsid;
                  var pstopdetailsid = data.pstopdetailsid;
                  var statusselect = data.statusselect;
                  var legselect = data.legselect;
                  var orderselect = data.orderselect;

            var tds = '<td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;"><li onclick="return savecustomstatus();"><a id="bEdit" type="button" class="btn btn-sm btn-default" ><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul></td><td>'+legselect+" "+orderselect+'</td><td>'+statusselect+'<input type="hidden" name="pshipid" id="pshipid" value="'+pshipid+'"><input type="hidden" name="order_status_id" id="order_status_id" value=""><input type="hidden" name="status_name" id="status_name" value=""><input type="hidden" name="dstopdetailsid" id="dstopdetailsid" value="'+dstopdetailsid+'"><input type="hidden" name="pstopdetailsid" id="pstopdetailsid" value="'+pstopdetailsid+'"></td><td><input  class="form-control" type="text" id="status_code" name="status_code" value=""  ></td><td><select name="status_type" class="form-control" id="status_type"><option value="">Select</option><option value="P">P</option><option value="D">D</option></select></td><td><input  class="form-control" type="text" id="location" name="location" readonly value="" ></td><td><input type="text" name="status_date" id="status_date" class="form-control datepicker" onclick="getdatetimepicker(this);" value=""></td>';

            // $("#"+trowid).html(tds);
            $("#editing").html(tds);


              }
            });


}
function getstatusnamebyid(e){
    var val = $(e).val();
/* 	var trowid=$(e).closest('tr').attr('id');
	rowvalue=trowid.split("_");
	rowvalueid=rowvalue[1]; */
    var str = val.split('_');
    var name = str[0];
    var type = str[1];
    $('#status_code').val(name);
    $('#status_name').val(val);
    if(name != '1012'){
        $('#status_type').val(type);
    }
}


 function savecustomstatus(rowid){
	var status_code = $('#status_code').val();
	var status_name = $('#status_name').val();
	var order_status_id = $('#order_status_id').val();
	var status_date = $('#status_date').val();

	if(order_status_id.length == ""){
		gettoast('top-right','order_status_id','Please select the order');
		return false;
	}
	else 	if(status_code.length == ""){
		gettoast('top-right','status_code','Please enter a value in Status Code');
		return false;
	}
	else 	if(status_date.length == ""){
		gettoast('top-right','status_date','Please enter a value in Status Date');
		return false;
	}
	else if(status_name == ''){
		$('#status_name').focus();
		return false;
	}
	else{
	   var data = $("#status_form").serializeArray();
		$.ajax({
			url: $("#status_form").attr("action"),
			type: "POST",
			data: data,
			dataType: "JSON",
			success: function(data) {
				var shift_id=$("#shipment_id").val();
				getshiporderstatusdetails(shift_id);
			   /* console.log(data);
				$('#order_cargo_id').val(data.cargo_id);
				$('#cargo_row_id').val(data.cargo_id);*/
			},
		});
	return false;
	}

}

 function rowEditStatus(e,id,status_code,location,date,sts_value,status_name){
            var $row = $(e).closest('tr');
            var $cols = $row.find('td');
            var tableId = $(e).closest('table').attr('id');
            var order_id = $('#order_id').val();
            var sts = sts_value.split('_');
            var status_type = sts[1];
            var trOpen = "<tr >";
            var tds = '<td colspan="7"><form method="POST" action="'+baseurl+'trips/addstatus/'+id+'" id="status_form" novalidate class="status_form" autocomplete="off"><table width="100%"><tr id="editing"><td name="buttons"><ul class="nav nav-tabs"><li class="dropdown tablebtnrleft"><a class="dropdown-toggle" data-toggle="dropdown" href="#"><span class="icon  tru-icon-action-setting"></span></a><ul class="dropdown-menu" role="menu" style="left: 0 !important;"><li onclick="return savecustomstatus();"><a id="bEdit" type="button" class="btn btn-sm btn-default" onclick="rowEdit(this);"><span class="glyphicon glyphicon-ok"> </span>Save</a></li><li><a id="bElim" style="display:none;" type="button" class="btn btn-sm btn-default" onclick="rowElim(this);"><span class="glyphicon glyphicon-trash"> </span>Remove</a></li></ul></li></ul></td><td><input type="hidden" id="order_status_id" name="order_status_id" value="'+order_id+'"><select form="status_form" name="status_name" onchange="getstatusnamebyid(this);" class="form-control" id="status_name"><option selected value="'+sts_value+'">'+status_name+'</option></select></td><td><input  class="form-control" type="text" name="status_code" value="'+status_code+'" id="status_code" readonly></td><td><input  class="form-control" type="text" name="status_type" id="status_type" value="'+status_type+'" readonly></td><td><input  class="form-control" type="text" name="location" id="location" value="'+location+'" readonly></td><td><input type="text" name="status_date" id="status_date" class="form-control datepicker" onclick="getdatetimepicker(this);" value="'+date+'"></td></tr></table></td>';
            var buttons = '</form>';

            var divClose = "";

            var trClose = "</tr></tbody></table></td>";

            var html =  tds + buttons + divClose + trClose;
         $row.html(html);
      }

 function expandOrder(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function(){
            $(this).hide();
        });
        if($(ele).find(".showDetails").hasClass("fa-chevron-circle-down")){
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
            $(ele).find(".showDetails").removeClass("fa-chevron-circle-down");
            $(ele).find(".showDetails").addClass("fa-chevron-circle-up");
            $(ele).find(".showDetails").attr("title","Hide Details");
            $(".expandOrder").each(function(){
                if($(this).data("id")==id){
                    $(this).css("display","table-row");
                }
            });
            $("."+$(ele).data("optclass")).click();
        }else{
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
        }
    }
    function expand_Order(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandOrder").each(function(){
            if($(this).data("id")==id){
                $(this).css("display","table-row");
            }
        });
    }
  function expandLegs(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandLegs").each(function(){
            $(this).hide();
        });
        if($(ele).find(".showDetails").hasClass("fa-chevron-circle-down")){
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
            $(ele).find(".showDetails").removeClass("fa-chevron-circle-down");
            $(ele).find(".showDetails").addClass("fa-chevron-circle-up");
            $(ele).find(".showDetails").attr("title","Hide Details");
            $(".expandLegs").each(function(){
                if($(this).data("id")==id){
                    $(this).css("display","table-row");
                }
            });
            $("."+$(ele).data("optclass")).click();
        }else{
            $(".baseOrder").each(function(){
                $(this).find(".showDetails").removeClass("fa-chevron-circle-up");
                $(this).find(".showDetails").addClass("fa-chevron-circle-down");
                $(this).find(".showDetails").attr("title","Show Details");
            });
        }
    }
    function expand_Legs(ele){
        var id = $(ele).closest("tr").data("id");
        $(".expandLegs").each(function(){
            if($(this).data("id")==id){
                $(this).css("display","table-row");
            }
        });
    }


   function isNonSpecialCharCheck(e)
{
    var keynum;
    var keychar;
    var numcheck;
    // For Internet Explorer
    if (window.event)
    {
        keynum = e.keyCode;
    }
    // For Netscape/Firefox/Opera
    else if (e.which)
    {
        keynum = e.which;
    }
    keychar = String.fromCharCode(keynum);
    //List of special characters you want to restrict
    if (keychar == "'" || keychar == "`" || keychar == "~" || keychar == "+"
    || keychar == "/"  || keychar == "\/" || keychar == "//" || keychar == "\\"
     || keychar == "<" || keychar == ">" || keychar == "^" || keychar == "|")
    {
        return false;
    }
    else
    {
        return true;
    }
}
