function isNumberKey(evt) {
  var keyCode = (evt.which) ? evt.which : event.keyCode

  if ((keyCode != 8 || keyCode == 32) && (keyCode < 48 || keyCode > 57)) {
    if (keyCode != 46) {
      return false;
    }
  }
}

function getCrossBorderCustomerList(e) {
  e.preventDefault();
  var customerId = $('#customerId').val();
  $("#viewCustomerPopup").modal('show');
  $("#viewCustomerTitle").html('Customers List');
  var table = $('#customerList').DataTable();
  table.destroy();
  $.ajax({
    url: baseurl + 'tripstemplate/getCrossBorderCustomerDetails',
    type: 'post',
    data: {customerId: customerId},
    dataType: 'json',
    beforeSend:function(){
      $("#customerListTableBody").html("<td colspan='9'><center><progress></center></td>");
    },
    success: function (data) {
      $("#customerList").DataTable({
        data: data,
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": true,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "checkBox"},
          {"data": "customerCode"},
          {"data": "customerName"},
          {"data": "customerStreet"},
          {"data": "customerCity"},
          {"data": "customerCountry"},
          {"data": "customerMail"},
          {"data": "companyCode"},
          {"data": "branchCode"},
        ],
      });
    }
  });
}

function selectCustomer(id) {
  $('.customerList').removeClass('selected-customerlist');
  $('#customerList_' + id).addClass('selected-customerlist');
}

function selectCustomerinlist() {
  var id = $('.selected-customerlist').val();
  $('#customerCode').val($('.selected-customerlist').data('code'));
  $('#customerRowId').val(id);
  $.ajax({
    url: baseurl + 'tripstemplate/getOrderTypesByCustomer',
    type: 'post',
    data: {customerId: id},
    dataType: 'json',
    success: function (response) {
      var option = "<option value=''>Select</option>";
      if (response.length > 0) {
        $.each(response, function (key, value) {
          option += "<option value='" + value.type_id + "'>" + value.type_name + "</option>";
        });
      }
      $('#orderType').html(option);
      $('#viewCustomerPopup').modal('hide');
    }
  });
}

function loadLegsTableData() {
  var templateRowId = $("#templateRowId").val();
  $.ajax({
    url: baseurl + 'tripstemplate/loadTripsLegsTableData',
    type: 'post',
    data: {templateRowId: templateRowId},
    dataType: 'json',
    beforeSend: function () {
      $('.legsTableBody').html(" <tr><td colspan='8'><center><i class='fa fa-spinner fa-spin'></i> Loading....</center></td></tr>");
    },
    success: function (response) {
      var legs = JSON.parse(JSON.stringify(response.legs));
      var carrierMaster = response.carrierMaster;
      var transportMaster = response.transportMaster;
      var allTrucksData = JSON.stringify(response.allTrucksData);
      var allDriversData = JSON.stringify(response.allDriversData);
      var carrierOption = "<option value=''>Select</option>";
      var transportOption = "<option value=''>Select</option>";
      var rows = "";
      if (transportMaster.length > 0) {
        $.each(transportMaster, function (key, value) {
          transportOption += "<option value='" + value['code'] + "'>" + value['name'] + "</option>";
        });
      }
      if (carrierMaster.length > 0) {
        $.each(carrierMaster, function (key, value) {
          carrierOption += "<option value='" + value['id'] + "'>" + value['name'] + "</option>";
        });
      }
      for (i = 0; i < 6; i++) {
        var truckTypesMaster = legs[i]['truckTypeMaster'];
        var truckDataMaster = legs[i]['truckDataMaster'];
        var truckDriversMaster = legs[i]['truckDriversMaster'];
        var truckTypeOption = "<option value=''>Select</option>";
        var truckDataOption = "<option value=''>Select</option>";
        var truckDriversOption = "<option value=''>Select</option>";
        var carrier = legs[i]['carrier'];
        var vehicleType = legs[i]['vehicleType'];
        var vehicle = legs[i]['vehicle'];
        var driver = legs[i]['driver'];
        if (carrier && truckTypesMaster) {
          $.each(truckTypesMaster, function (key, value) {
            truckTypeOption += "<option value='" + value['id'] + "'>" + value['truckType'] + "</option>";
          });
        }
        if (vehicleType && truckDataMaster) {
          $.each(truckDataMaster, function (key, value) {
            truckDataOption += "<option value='" + value['id'] + "'>" + value['truck_number'] + "</option>";
          });
        }
        if (vehicle && truckDriversMaster) {
          $.each(truckDriversMaster, function (key, value) {
            truckDriversOption += "<option value='" + value['id'] + "'>" + value['name'] + "</option>";
          });
        }
        rows += "<tr id='legsTable" + i + "'><td><input type='text' name='legId" + i + "' id='legId" + i + "' value='" + legs[i]['legId'] + "' class='form-control' form='tripstemplateform' readonly><input type='hidden' name='legRowId" + i + "' id='legRowId" + i + "' value='" + legs[i]['legRowId'] + "' form='tripstemplateform'></td>";
        rows += "<td><div class='input-group inputBtsGroups' style='display: table;'><input type='hidden' name='originRowId" + i + "' id='originRowId" + i + "' value='" + legs[i]['OriginRowId'] + "' form='tripstemplateform'><input type='text' name='originLocation" + i + "' id='originLocation" + i + "' value='" + legs[i]['origin'] + "' class='form-control' form='tripstemplateform' readonly><div class='input-group-btn' style='position: relative;'><button class='btn' type='button' data-placement='top'  data-toggle='modal'><a href='#' title='List' id='viewPartyList' onclick='viewPartyList(event,0," + i + ")'> <i class='icon tru-icon-tender-list'></i></a></button></div></div></td>";
        rows += "<td><div class='input-group inputBtsGroups' style='display: table;'><input type='hidden' name='destinationRowId" + i + "' id='destinationRowId" + i + "' value='" + legs[i]['destinationRowId'] + "' form='tripstemplateform'><input type='text' name='destinationLocation" + i + "' id='destinationLocation" + i + "' value='" + legs[i]['destination'] + "' class='form-control' form='tripstemplateform' readonly><div class='input-group-btn' style='position: relative;'><button class='btn' type='button' data-placement='top'  data-toggle='modal'><a href='#' title='List' id='viewPartyList' onclick='viewPartyList(event,1," + i + ")'> <i class='icon tru-icon-tender-list'></i></a></button></div></div></td>";
        rows += "<td><input type='hidden' name='carrierRowId" + i + "' id='carrierRowId" + i + "' value='" + carrier + "' ><input type='hidden' id='truckTypesMaster" + i + "' value=''><select name='carrier" + i + "' id='carrier" + i + "' form='tripstemplateform' class='form-control' onchange='getVehicleTypeBasedOnCarrier(this.value," + i + ");'>" + carrierOption + "</select></td>";
        rows += "<td><select name='modeOfTransport" + i + "' id='modeOfTransport" + i + "' form='tripstemplateform' class='form-control'>" + transportOption + "</select></td>";
        rows += "<td><input type='hidden' name='vehicleTypeRowId" + i + "' id='vehicleTypeRowId" + i + "' value='" + vehicleType + "' ><input type='hidden' id='truckDataMaster" + i + "' value=''><select name='vehicleType" + i + "' id='vehicleType" + i + "' form='tripstemplateform' class='form-control' onchange='GetVehiclesBasedOnVehicleType(this.value," + i + ");'>" + truckTypeOption + "</select></td>";
        rows += "<td><input type='hidden' id='truckDriversMaster" + i + "' value=''><input type='hidden' name='vehicleRowId" + i + "' id='vehicleRowId" + i + "' value='" + vehicle + "' ><select name='vehicle" + i + "' id='vehicle" + i + "' form='tripstemplateform' class='form-control' onchange='getDriverBasedOnVehicle(this.value," + i + ")'>" + truckDataOption + "</select></td>";
        rows += "<td><input type='hidden' name='driverRowId" + i + "' id='driverRowId" + i + "' value='" + driver + "' ><select name='driver" + i + "' id='driver" + i + "' form='tripstemplateform' class='form-control' >" + truckDriversOption + "</select></td></tr>";
      }
      $('.legsTableBody').html(rows);
      for (i = 0; i < 6; i++) {
        var carrier = legs[i]['carrier'];
        var modeOfTransport = legs[i]['modeOfTransport'];
        var vehicleType = legs[i]['vehicleType'];
        var vehicle = legs[i]['vehicle'];
        var driver = legs[i]['driver'];
        if (carrier) {
          $('#carrier' + i + ' option[value="' + carrier + '"]').prop("selected", true);
        }
        if (modeOfTransport) {
          $('#modeOfTransport' + i + ' option[value="' + modeOfTransport + '"]').prop("selected", true);
        }
        if (vehicleType) {
          $('#vehicleType' + i + ' option[value="' + vehicleType + '"]').prop("selected", true);
        }
        if (vehicle) {
          $('#vehicle' + i + ' option[value="' + vehicle + '"]').prop("selected", true);
        }
        if (driver) {
          $('#driver' + i + ' option[value="' + driver + '"]').prop("selected", true);
        }
      }
      $('#allDriversData').val(allDriversData);
      $('#allTrucksData').val(allTrucksData);
      setLegsTable();
    }
  });
}

function loadLegsTableDataForView(){
  var templateRowId = $("#templateRowId").val();
  var table = $('#tripstemplateLegsTable').DataTable();
  table.destroy();
  $.ajax({
    url: baseurl + 'tripstemplate/loadTripsLegsTableDataForView',
    type: 'post',
    data: {templateRowId: templateRowId},
    dataType: 'json',
    success: function (data) {
      $("#tripstemplateLegsTable").DataTable({
        data: data,
        "bPaginate": false,
        "paging": false,
        "bLengthChange": false,
        "bFilter": false,
        "bInfo": false,
        "bAutoWidth": false,
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "legId"},
          {"data": "originLocation"},
          {"data": "destinationLocation"},
          {"data": "carrierId"},
          {"data": "transportMode"},
          {"data": "vehicleType"},
          {"data": "vehicleId"},
          {"data": "driverId"},
        ],
      });
    }
  });
}

function getVehicleTypeBasedOnCarrier(selectedCarrier, rowNumber) {
  var truckTypeOption = "<option value=''>Select</option>";
  $.ajax({
    url: baseurl + 'tripstemplate/getCarrierAllVehiclesData',
    type: "POST",
    data: {'carrierRowId': selectedCarrier},
    dataType: "JSON",
    success: function (response) {
      var truckTypesMaster = response.truckTypes;
      var truckDataMaster = JSON.stringify(response.trucksData);
      var truckDriversMaster = JSON.stringify(response.truckDrivers);
      if (truckTypesMaster[selectedCarrier]) {
        $.each(truckTypesMaster[selectedCarrier], function (key, value) {
          truckTypeOption += "<option value='" + value['id'] + "'>" + value['truckType'] + "</option>";
        });
      }
      $('#vehicleType' + rowNumber).html(truckTypeOption);
      $('#truckTypesMaster' + rowNumber).val(truckTypesMaster);
      $('#truckDataMaster' + rowNumber).val(truckDataMaster);
      $('#truckDriversMaster' + rowNumber).val(truckDriversMaster);
    }
  });
}

function GetVehiclesBasedOnVehicleType(selectedVehicleType, rowNumber) {
  var truckDataOption = "<option value=''>Select</option>";
  if (selectedVehicleType >0){
    if($('#truckDataMaster' + rowNumber).val() != ""){
      var truckDataMaster = JSON.parse($('#truckDataMaster' + rowNumber).val());
      if (truckDataMaster[selectedVehicleType]) {
        $.each(truckDataMaster[selectedVehicleType], function (key, value) {
          truckDataOption += "<option value='" + value['id'] + "'>" + value['truck_number'] + "</option>";
        });
      }
    }else{
      var allTrucksData = JSON.parse($('#allTrucksData').val());
      if (allTrucksData[selectedVehicleType]) {
        $.each(allTrucksData[selectedVehicleType], function (key, value) {
          truckDataOption += "<option value='" + value['id'] + "'>" + value['truck_number'] + "</option>";
        });
      }
    }
  }
  $('#vehicle' + rowNumber).html(truckDataOption);
}

function getDriverBasedOnVehicle(selectedVehicle, rowNumber) {
  var truckDriversOption = "<option value=''>Select</option>";
  if (selectedVehicle > 0) {
    if ($('#truckDriversMaster' + rowNumber).val() != "") {
      var truckDriversMaster = JSON.parse($('#truckDriversMaster' + rowNumber).val());
      if (truckDriversMaster[selectedVehicle]) {
        $.each(truckDriversMaster[selectedVehicle], function (key, value) {
          truckDriversOption += "<option value='" + value['id'] + "'>" + value['name'] + "</option>";
        });
      }
    } else {
      var allDriversData = JSON.parse($('#allDriversData').val());
      if (allDriversData[selectedVehicle]) {
        $.each(allDriversData[selectedVehicle], function (key, value) {
          truckDriversOption += "<option value='" + value['id'] + "'>" + value['name'] + "</option>";
        });
      }
    }
  }
  $('#driver' + rowNumber).html(truckDriversOption);
}

function selectparty(id) {
  $('.consigneelist').removeClass('selectedparty-list');
  $('#consigneelist_' + id).addClass('selectedparty-list');
}

function selectPartyFromList(party, rowNumber) {
  var id = $('.selectedparty-list').val();
  if (id.length > 0) {
    $.ajax({
      url: baseurl + 'trips/selectpartytype',
      type: "POST",
      data: {"id": id, 'party': party},
      dataType: "JSON",
      success: function (data) {
        var response = JSON.parse(JSON.stringify(data["party"]));
        var code = response[0].id;
        var location_id = response[0].location_id;
        if (party == 'origin') {
          $('#originRowId' + rowNumber).val(code);
          $('#originLocation' + rowNumber).val(location_id);
        } else {
          $('#destinationRowId' + rowNumber).val(code);
          $('#destinationLocation' + rowNumber).val(location_id);
        }
        $("#viewPartyModal").modal('hide');

      }
    });
  }
}

function viewPartyList(e, type, rowNumber) {
  e.preventDefault();
  var title = "Destination List";
  var partyType = 'drop';
  if (type == 0) {
    title = "Origin List";
    partyType = 'origin';
  }
  $('#popupPartyType').val(partyType);
  if (!$('#tableSearchDiv').hasClass('hideTableSearch')) {
    $('#tableSearchDiv').removeClass('hideTableSearch');
  }
  $('.selectparty').attr('onclick', "selectPartyFromList('" + partyType + "','" + rowNumber + "')");
  $("#viewPartyModal").modal('show');
  $("#viewPartyTitle").html(title);
  getAllMasterData(partyType);
}

function setLegsTable() {
  var carrierType = $('#carrierType').val();
  for (i = 0; i < 6; i++) {
    if (carrierType == 0) {
      if (i > 0) {
        $('#legsTable' + i).addClass("disableLegsTable");
      }
    } else {
      if ($('#legsTable' + i).hasClass("disableLegsTable")) {
        $('#legsTable' + i).removeClass("disableLegsTable");
      }
    }
  }
}

function checkValidtionBeforSubmition() {
  var checkLegs = 0;
  var templateName = $('#templateName').val();
  if (templateName == "") {
    gettoast('top-right', 'templateName', 'Please Enter Template Name');
    return false;
  }
  for (var i = 0; i < 6; i++) {
    var j = i +1;
    var originRowId = $('#originRowId' + i).val();
    if (originRowId > 0) {
      checkLegs = 1;
      var destinationRowId = $('#destinationRowId' + i).val();
      if (destinationRowId == 0) {
        gettoast('top-right', '', 'Please Select Destination For ' + j + ' leg');
        return false;
      }
      var carrier = $('#carrier' + i).val();
      if (carrier == 0) {
        gettoast('top-right', '', 'Please Select Carrier For ' + j + ' leg');
        return false;
      }
    }
  }
  if(checkLegs == 0){
    gettoast('top-right', '', 'Please Add Leg Details');
    return false;
  }
}

$('.checkAll').on('click', function() {
  if (this.checked == true)
    $('.forcheckboxes').find('input[name="chck1"]').prop('checked', true);
  else
    $('.forcheckboxes').find('input[name="chck1"]').prop('checked', false);
});

function deleteTripTemplateById(rowId) {
  var x = confirm("Are you sure you want to delete the Record");
  if (x) {
    $.ajax({
      url: baseurl + 'tripstemplate/deleteTripTemplateById',
      type: "POST",
      data: {"rowId": rowId},
      dataType: "JSON",
      success: function (response) {
        if (response.status == 1) {
          $(".popup_circle").removeClass('glyphicon-remove-circle');
          $(".popup_circle").addClass('glyphicon-ok-circle');
          $(".popup_circle").css("color", "green");
          $(".pop_message").html('Record Deleted Successfully !!');
          $("#insert_success_div").modal('show');
          $(".success_redirect").on('click', function () {
            window.location.reload();
          });
        } else {
          $("#dialog_box").dialog();
          $('.ui-dialog-title').addClass('fa fa-warning');
          $('.ui-dialog-title').addClass('fa fa-warning');
          $("#dialog_text").text("Oops...something went wrong");
        }

      }
    });
  }
}

function gettoast(position, inputId, message) {
  if (inputId != "") {
    if (!$('#' + inputId).hasClass('errorclass')) {
      $('#' + inputId).addClass('errorclass');
    }
  }
  init({
    fade_in: 800,
    fade_out: 800,
    position: position,
  });
  toast({
    type: 'custom',
    title: '<span style="color:#000000ab;">Warning Message</span>',
    description: '<span style="color:black;"><b>' + message + '</b></span>',
    close_color: '#FF7F50',
    border_color: '#FF8C00',
    color: '#FFBF00',
    timeout: 900
  });
}

$('#tableSearch').on('blur', function () {
  const value = $(this).val();
  const partyType = $('#popupPartyType').val();
  if (value.length == 0) {
    getAllMasterData(partyType);
  } else {
    var table = $('#partyListTable').DataTable();
    table.destroy();
    $.ajax({
      url: baseurl + 'tripstemplate/getMasterDataForTripTemplate',
      type: "POST",
      data: {'code': value, 'partyType': partyType},
      dataType: "JSON",
      beforeSend: function () {
        $("#partyListTableBody").html("<td colspan='10'><center><progress></center></td>");
      },
      success: function (data) {
        $("#partyListTable").DataTable({
          data: data,
          "bPaginate": true,
          "paging": true,
          "bLengthChange": true,
          "bFilter": false,
          "bInfo": false,
          "bAutoWidth": true,
          "language": {
            "lengthMenu": '<select class="form-control">' +
              '<option value="10">10</option>' +
              '<option value="20">20</option>' +
              '<option value="30">30</option>' +
              '<option value="40">40</option>' +
              '<option value="50">50</option>' +
              '<option value="-1">All</option>' +
              '</select>'
          },
          dom: 'Blfrtip',
          buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'print'
          ],
          "columns": [
            {"data": "check"},
            {"data": "id"},
            {"data": "name"},
            {"data": "party_name"},
            {"data": "street"},
            {"data": "city"},
            {"data": "country"},
            {"data": "email"},
            {"data": "company_code"},
            {"data": "branch_code"},
          ],
        });
      }
    });
  }
});

function getAllMasterData(partyType) {
  var table = $('#partyListTable').DataTable();
  table.destroy();
  $.ajax({
    url: baseurl + 'trips/vieworiginpartylist',
    type: "POST",
    data: {'party': partyType},
    dataType: "JSON",
    beforeSend:function(){
      $("#partyListTableBody").html("<td colspan='10'><center><progress></center></td>");
    },
    success: function (data) {
      $("#partyListTable").DataTable({
        data: data,
        "bPaginate": true,
        "paging": true,
        "bLengthChange": true,
        "bFilter": false,
        "bInfo": false,
        "bAutoWidth": true,
        "language": {
          "lengthMenu": '<select class="form-control">' +
            '<option value="10">10</option>' +
            '<option value="20">20</option>' +
            '<option value="30">30</option>' +
            '<option value="40">40</option>' +
            '<option value="50">50</option>' +
            '<option value="-1">All</option>' +
            '</select>'
        },
        dom: 'Blfrtip',
        buttons: [
          'copyHtml5',
          'excelHtml5',
          'csvHtml5',
          'pdfHtml5',
          'print'
        ],
        "columns": [
          {"data": "check"},
          {"data": "id"},
          {"data": "name"},
          {"data": "party_name"},
          {"data": "street"},
          {"data": "city"},
          {"data": "country"},
          {"data": "email"},
          {"data": "company_code"},
          {"data": "branch_code"},
        ],
      });
      if ($('#tableSearchDiv').hasClass('hideTableSearch')) {
        $('#tableSearchDiv').removeClass('hideTableSearch');
      }
    }
  });
}
