var session;
var publisher;
var subscribers = {};
var lview;
var pview;

var apiKey,
	sessionId,
	token;


function getApiKeyAndToken(server, room, view) {
	lview = view;
	sessionCredentialsUrl = server + '/room/' + room;
	var xhr = new XMLHttpRequest();
	xhr.open("GET", sessionCredentialsUrl, true);
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				openTokSessionInfo = JSON.parse(xhr.responseText);
				apiKey = openTokSessionInfo.apiKey;
				sessionId = openTokSessionInfo.sessionId;
				token = openTokSessionInfo.token;
				init()
			} else {
				console.error(xhr.statusText);
			}
		}
	};
	xhr.onerror = function (e) {
		console.error(xhr.statusText);
	};
	xhr.send(null);
}
function getApiKeyAndTokenDims(server, room, view, parentview) {
	lview = view;
	pview = parentview;
	sessionCredentialsUrl = server + '/room/' + room;
	var xhr = new XMLHttpRequest();
	xhr.open("GET", sessionCredentialsUrl, true);
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				openTokSessionInfo = JSON.parse(xhr.responseText);
				apiKey = openTokSessionInfo.apiKey;
				sessionId = openTokSessionInfo.sessionId;
				token = openTokSessionInfo.token;
				init()
			} else {
				console.error(xhr.statusText);
			}
		}
	};
	xhr.onerror = function (e) {
		console.error(xhr.statusText);
	};
	xhr.send(null);
}

function getArchivesUrl() {
	var xhr = new XMLHttpRequest();
	xhr.open("GET", archivesUrl, true);
	xhr.onload = function (e) {
		if (xhr.readyState === 4) {
			if (xhr.status === 200) {
				console.log(JSON.parse(xhr.responseText));
			} else {
				console.error(xhr.statusText);
			}
		}
	};
	xhr.onerror = function (e) {
		console.error(xhr.statusText);
	};
	xhr.send(null);
}

function init() {
	session = OT.initSession(apiKey,sessionId); // Initialize session
	// Add event listeners to the session
	session.addEventListener('sessionConnected', sessionConnectedHandler);
	session.addEventListener('sessionDisconnected', sessionDisconnectedHandler);
	session.addEventListener('connectionCreated', connectionCreatedHandler);
	session.addEventListener('connectionDestroyed', connectionDestroyedHandler);
	session.addEventListener('streamCreated', streamCreatedHandler);
	session.addEventListener('streamDestroyed', streamDestroyedHandler);
	session.addEventListener('signal', signalHandler);
	connect();
}

function connect() {
	session.connect(apiKey, token);
}

function disconnect() {
	session.disconnect();
}
//--------------------------------------
//  OPENTOK EVENT HANDLERS
//--------------------------------------
function sessionConnectedHandler(event) {
	// Subscribe to all streams currently in the Session
	// for (var i = 0; i < event.streams.length; i++) {
	// 	addStream(event.streams[i]);
	// }
}

function streamCreatedHandler(event) {
	// Subscribe to the newly created streams
	if (event.streams.length > 0) {
		var i = event.streams.length - 1;
		TB.log('streamCreated - connectionId: ' + event.streams[i].connection.connectionId);
		TB.log('streamCreated - connectionData: ' + event.streams[i].connection.data);
		addStream(event.streams[i]);
	}
}

function streamDestroyedHandler(event) {
	// This signals that a stream was destroyed. Any Subscribers will automatically be removed.
	// This default behaviour can be prevented using event.preventDefault()
}

function sessionDisconnectedHandler(event) {
	// This signals that the user was disconnected from the Session. Any subscribers and publishers
	// will automatically be removed. This default behaviour can be prevented using event.preventDefault()
	publisher = null;
}

function connectionDestroyedHandler(event) {
	// This signals that connections were destroyed
}

function connectionCreatedHandler(event) {
	// This signals new connections have been created.
}

function signalHandler(event) {
	var signalsDiv = document.getElementById("signals");
	var messageP = document.createElement("p");
	messageP.innerHTML = event.data;
	signalsDiv.appendChild(messageP);
}
/*
If you un-comment the call to TB.addEventListener('exception', exceptionHandler) above, OpenTok calls the
exceptionHandler() method when exception events occur. You can modify this method to further process exception events.
If you un-comment the call to TB.setLogLevel(), above, OpenTok automatically displays exception event messages.
*/
function exceptionHandler(event) {
	alert('Exception: ' + event.code + '::' + event.message);
}
//--------------------------------------
//  HELPER METHODS
//--------------------------------------
function addStream(stream) {
	// Check if this is the stream that I am publishing, and if so do not publish.
	if (stream.connection.connectionId == session.connection.connectionId) {
		return;
	}
	var subscriberDiv = document.createElement('div'); // Create a div for the subscriber to replace
	subscriberDiv.setAttribute('id', stream.streamId); // Give the replacement div the id of the stream as its id.
	var ratio = 300 / stream.videoDimensions.width;
	lview.html(subscriberDiv);
	subscribers[stream.streamId] = session.subscribe(stream, subscriberDiv.id,{
		testNetwork: true
	});
	document.getElementById(stream.streamId).style.height = stream.videoDimensions.height * ratio + "px";
	document.getElementById(stream.streamId).style.width = stream.videoDimensions.width * ratio + "px";
	if(typeof pview != "undefined"){
	    pview.css("width",$(".OT_root").css("width"));
	    pview.css("height",$(".OT_root").css("height"));
	}
}