var directionsService;
var directionsRenderer;
var trackerFrequency = 20000;
var start, end;
var defaultZoom = 10;
var googleMap, vehicle;
var markers = [];
var polylines = [];
const icon = siteurl + "assets/images/icons/Blu_Truck.png";
const blueIcon = siteurl + "assets/images/icons/blue_marker.png";
const redIcon = siteurl + "assets/images/icons/red_marker.png";


function InitializeGoogleMaps(plat, plng, dlat, dlng, clat, clng, tmode, legs, shiftId) {
  plat = +plat;
  plng = +plng;
  dlat = +dlat;
  dlng = +dlng;
  clat = +clat;
  clng = +clng;
  googleMap = new google.maps.Map(document.getElementById('map'), {
    center: { lat: plat, lng: plng },
    zoom: defaultZoom,
    styles: [
      { featureType: "all", stylers: [{ saturation: 0 }, { hue: "#e7ecf0" }] },
      { featureType: "road", stylers: [{ saturation: -70 }] },
      { featureType: "transit", stylers: [{ visibility: "off" }] },
      { featureType: "poi", stylers: [{ visibility: "off" }] },
      { featureType: "water", stylers: [{ visibility: "simplified" }, { saturation: -60 }] }
    ],
    mapTypeId: google.maps.MapTypeId.ROADMAP
  });

  directionsService = new google.maps.DirectionsService();
  directionsRenderer = new google.maps.DirectionsRenderer({ map: googleMap, suppressMarkers: true, preserveViewport: true });
  if (legs.length > 0) {
    multiLegPlot(legs, shiftId)
  }
  else {
    singleLegPlot(plat, plng, dlat, dlng, clat, clng, tmode, shiftId);
  }

}

function queueFunction(plat, plng) {
  plat = +plat;
  plng = +plng;
  const latlng = new google.maps.LatLng(plat, plng);

  if (vehicle) {
    vehicle.setPosition(latlng);
  } else {
    vehicle = new google.maps.Marker({
      position: latlng,
      scaledSize: new google.maps.Size(60, 60),
      map: googleMap,
      icon: siteurl + "assets/images/icons/Blu_Truck.png"
    });
  }

  googleMap.setCenter(latlng);
  googleMap.setZoom(defaultZoom);
}

function multiLegPlot(legs, shiftId) {
  // Clear any old stuff
  if (directionsRenderer) {
    directionsRenderer.setMap(null);
  }
  directionsRenderer = new google.maps.DirectionsRenderer({
    suppressMarkers: true,
    preserveViewport: true
  });
  directionsRenderer.setMap(googleMap);

  const startBounds = new google.maps.LatLng(legs[0].slat, legs[0].slng);
  const endBounds = new google.maps.LatLng(legs[legs.length - 1].elat, legs[legs.length - 1].elng);

  clearPolylines();
  clearBranchMarkers();

  legs.forEach((leg, index) => {
    const start = new google.maps.LatLng(leg.slat, leg.slng);
    const end = new google.maps.LatLng(leg.elat, leg.elng);
    const tmode = leg.transport_mode;

    if (tmode === "FTL" || tmode === "LTL") {
      const startMarker = new google.maps.Marker({
        position: start,
        map: googleMap,
        title: `Pickup: ${leg.splace}`,
        icon: {
          url: redIcon,
          scaledSize: new google.maps.Size(40, 40)
        }
      });
      markers.push(startMarker);

      const endMarker = new google.maps.Marker({
        position: end,
        map: googleMap,
        title: `Delivery: ${leg.eplace}`,
        icon: {
          url: greenIcon,
          scaledSize: new google.maps.Size(40, 40)
        }
      });
      markers.push(endMarker);

      const request = {
        origin: start,
        destination: end,
        travelMode: google.maps.TravelMode.DRIVING
      };

      directionsService.route(request, function (result, status) {
        if (status === google.maps.DirectionsStatus.OK) {
          directionsRenderer.setDirections(result);
          google.maps.event.addListenerOnce(directionsRenderer, 'directions_changed', () => {
            adjustBounds();
          });
        }
      });

    } else if (tmode === "RAIL") {

      const railStartMarker = new google.maps.Marker({
        position: start,
        map: googleMap,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railStartMarker);

      const railEndMarker = new google.maps.Marker({
        position: end,
        map: googleMap,
        title: "Railway Station",
        icon: {
          url: "https://img.icons8.com/ios-filled/50/train.png",
          scaledSize: new google.maps.Size(33, 33)
        }
      });
      markers.push(railEndMarker);

      const railPath = new google.maps.Polyline({
        path: [start, end],
        geodesic: true,
        strokeColor: "#007400",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: googleMap
      });

      polylines.push(railPath);

      let count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;

        const icons = railPath.get('icons');
        icons[0].offset = (count / 2) + '%';
        railPath.set('icons', icons);
      }, 100);
    } else if (tmode === "AIR") {
      const airStartMarker = new google.maps.Marker({
        position: start,
        map: googleMap,
        title: `Airport: ${leg.splace}`,
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
          scaledSize: new google.maps.Size(30, 30)
        }
      });
      markers.push(airStartMarker);

      const airEndMarker = new google.maps.Marker({
        position: end,
        map: googleMap,
        title: `Airport: ${leg.eplace}`,
        icon: {
          url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
          scaledSize: new google.maps.Size(30, 30)
        }
      });
      markers.push(airEndMarker);

      const airPath = new google.maps.Polyline({
        path: [start, end],
        geodesic: true,
        strokeColor: "#7b1c1cff",
        strokeOpacity: 0,
        strokeWeight: 3,
        icons: [{
          icon: {
            path: "M 0,-1 0,1",
            strokeOpacity: 1,
            scale: 4
          },
          offset: "0",
          repeat: "20px"
        }],
        map: googleMap
      });
      polylines.push(airPath);

      let count = 0;
      window.setInterval(() => {
        count = (count + 1) % 200;
        const icons = airPath.get('icons');
        icons[0].offset = (count / 2) + '%';
        airPath.set('icons', icons);
      }, 100);
    }
  });

  const bounds = new google.maps.LatLngBounds();
  legs.forEach(leg => {
    bounds.extend(new google.maps.LatLng(leg.slat, leg.slng));
    bounds.extend(new google.maps.LatLng(leg.elat, leg.elng));
  });

  googleMap.fitBounds(bounds);
}


function singleLegPlot(plat, plng, dlat, dlng, clat, clng, tmode, shiftId) {
  console.log("Single leg plot called", shiftId);
  if (shiftId != "" && shiftId != null && shiftId != undefined && shiftId != '0' && shiftId != 0) {
    const vehiclePosition = new google.maps.LatLng(clat, clng);
    vehicle = new google.maps.Marker({
      position: vehiclePosition,
      scaledSize: new google.maps.Size(100, 100),
      map: googleMap,
      icon: {
        url: icon,
        scaledSize: new google.maps.Size(60, 60),
      }
    });
  }

  if (directionsRenderer) {
    directionsRenderer.setMap(null);
  }
  directionsRenderer = new google.maps.DirectionsRenderer({
    suppressMarkers: true,
    preserveViewport: true
  });
  directionsRenderer.setMap(googleMap);

  clearPolylines();
  clearBranchMarkers();

  start = new google.maps.LatLng(plat, plng);
  end = new google.maps.LatLng(dlat, dlng);

  if (tmode === "FTL" || tmode === "LTL") {
    const startMarker = new google.maps.Marker({
      position: start,
      map: googleMap,
      title: "Pickup Location",
      icon: {
        url: redIcon,
        scaledSize: new google.maps.Size(40, 40)
      }
    });
    markers.push(startMarker);

    const endMarker = new google.maps.Marker({
      position: end,
      map: googleMap,
      title: "Delivery Location",
      icon: {
        url: blueIcon,
        scaledSize: new google.maps.Size(40, 40)
      }
    });
    markers.push(endMarker);
    // Road transport (Driving)
    const request = {
      origin: start,
      destination: end,
      travelMode: google.maps.TravelMode.DRIVING
    };

    directionsService.route(request, function (result, status) {
      if (status === google.maps.DirectionsStatus.OK) {
        directionsRenderer.setDirections(result);
        google.maps.event.addListenerOnce(directionsRenderer, 'directions_changed', () => {
          adjustBounds();
        });
      } else {
        alert("Unable to plot road route.");
      }
    });


  } else if (tmode === "RAIL") {

    const railStartMarker = new google.maps.Marker({
      position: start,
      map: googleMap,
      title: "Railway Station",
      icon: {
        url: "https://img.icons8.com/ios-filled/50/train.png",
        scaledSize: new google.maps.Size(33, 33)
      }
    });
    markers.push(railStartMarker);

    const railEndMarker = new google.maps.Marker({
      position: end,
      map: googleMap,
      title: "Railway Station",
      icon: {
        url: "https://img.icons8.com/ios-filled/50/train.png",
        scaledSize: new google.maps.Size(33, 33)
      }
    });
    markers.push(railEndMarker);

    const railPath = new google.maps.Polyline({
      path: [start, end],
      geodesic: true,
      strokeColor: "#007400",
      strokeOpacity: 0,
      strokeWeight: 3,
      icons: [{
        icon: {
          path: "M 0,-1 0,1",
          strokeOpacity: 1,
          scale: 4
        },
        offset: "0",
        repeat: "20px"
      }],
      map: googleMap
    });

    polylines.push(railPath);

    let count = 0;
    window.setInterval(() => {
      count = (count + 1) % 200;

      const icons = railPath.get('icons');
      icons[0].offset = (count / 2) + '%';
      railPath.set('icons', icons);
    }, 100);
  } else if (tmode === "AIR") {

    const airStartMarker = new google.maps.Marker({
      position: end,
      map: googleMap,
      title: "AIRPORT",
      icon: {
        url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-take-off.png",
        scaledSize: new google.maps.Size(30, 30)
      }
    });

    markers.push(airStartMarker);

    const airEndMarker = new google.maps.Marker({
      position: start,
      map: googleMap,
      title: "AIRPORT",
      icon: {
        url: "https://img.icons8.com/ios-filled/50/FFFFF/airplane-landing.png",
        scaledSize: new google.maps.Size(30, 30)
      }
    });

    markers.push(airEndMarker);

    const airPath = new google.maps.Polyline({
      path: [end, start],
      geodesic: true,
      strokeColor: "#7b1c1cff",
      strokeOpacity: 0,
      strokeWeight: 3,
      icons: [{
        icon: {
          path: "M 0,-1 0,1",
          strokeOpacity: 1,
          scale: 4
        },
        offset: "0",
        repeat: "20px"
      }],
      map: googleMap
    });
    polylines.push(airPath);

    var count = 0;
    window.setInterval(() => {
      count = (count + 1) % 200;

      const icons = airPath.get('icons');
      icons[0].offset = (count / 2) + '%'; // shift dots
      airPath.set('icons', icons);
    }, 100); // adjust speed here
  }
}

function clearPolylines() {
  if (polylines && polylines.length) {
    polylines.forEach(p => p.setMap(null));
  }
  polylines = [];
}

function clearBranchMarkers() {
  markers.forEach(marker => marker.setMap(null));
  markers.length = 0;
}


function adjustBounds() {
  const bounds = new google.maps.LatLngBounds();
  markers.forEach(marker => bounds.extend(marker.getPosition()));
  polylines.forEach(line => line.getPath().forEach(latlng => bounds.extend(latlng)));
  googleMap.fitBounds(bounds);
}
