var directionsService;
var directionsDisplay;
var level1Bounds;
var showRoute = false;
var trackerFrequency = 20000;
var start;
var end;


function InitializeGoogleMaps(plat,plng,dlat,dlng,clat,clng){
  plat=plat*1;
  plng=plng*1;
  dlat=dlat*1;
  dlng=dlng*1;
  clat=clat*1;
  clng=clng*1;

  level1Bounds = new google.maps.LatLngBounds();
  googleMap = new google.maps.Map(document.getElementById('map'), {
    center: {
        lat: plat,
        lng: plng
    },
    mapTypeControl: true,
    mapTypeControlOptions: {
        style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
        position: google.maps.ControlPosition.TOP_CENTER
    },
    zoomControlOptions: {
      position: google.maps.ControlPosition.LEFT_CENTER,
    },
    scaleControl: true,
          streetViewControl: true,
          streetViewControlOptions: {
          position: google.maps.ControlPosition.LEFT_TOP,
          },
    zoom: 12,
    mapTypeId: google.maps.MapTypeId.ROADMAP
});
var iconn = getIconByAngle(0);
var pos = new google.maps.LatLng(clat,clng);
bounds = new google.maps.LatLngBounds();
vehicle = new google.maps.Marker({
    position: pos,
    map: googleMap,
    icon: iconn
});


directionsService = new google.maps.DirectionsService();
directionsDisplay = new google.maps.DirectionsRenderer();
start =plat+','+plng;
end =dlat+','+dlng;
var request = {
  origin: start,
  destination: end,
  travelMode: google.maps.TravelMode.DRIVING
};

directionsService.route(request, function(response, status) {
  if (status == google.maps.DirectionsStatus.OK) {
      directionsDisplay.setDirections(response);
      directionsDisplay.setMap(googleMap);
  } else {
     // console.log("Directions Request from " + start.toUrlValue(6) + " to " + end.toUrlValue(6) + " failed: " + status);
  }
  

});



}

function getIconByAngle(angle) {
  //return siteurl+"assets/vehicle/vehicle copy " + angle + ".png";
  return siteurl+"assets/tracking/images/marker.png";
}

function queueFunction(plat,plng,dlat,dlng,clat,clng) { 
 
  plat=plat*1;
  plng=plng*1;
  dlat=dlat*1;
  dlng=dlng*1;
  clat=clat*1;
  clng=clng*1;

  var platlng = new google.maps.LatLng(plat, plng);
  var dlatlng = new google.maps.LatLng(dlat, dlng);

  var latlng = new google.maps.LatLng(clat, clng);
  vehicle.setPosition(latlng);
    bounds = new google.maps.LatLngBounds();
    bounds.extend(platlng);
    bounds.extend(dlatlng);
    bounds.extend(vehicle.position);
   

    googleMap.fitBounds(bounds);   

}


  
