<?php

if ( ! function_exists('_error_handler')) {

    function _error_handler(int $errorNumber, string $errorString, string $errorFile = null, int $errorLine = null, array $errorContext = null)
    {
        $isFatalError = (error_reporting() & $errorNumber) === $errorNumber;

        // Ignore not fatal errors
        if (!$isFatalError) {
            return;
        }

        set_status_header(500);

        log_message('error', sprintf('%s in %s on line %s', $errorString, $errorFile, $errorLine));
    }
}

if ( ! function_exists('_shutdown_handler'))
{

    function _shutdown_handler()
    {
        $last_error = error_get_last();
        if (!empty($last_error)) {
            log_message('error', sprintf('%s in %s on line %s', $last_error['message'], $last_error['file'], $last_error['line']));
        }
    }

}

