<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Cargo Details</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <?php $assets_url = base_url('assets/scanner'); ?>
    <script src="<?= $assets_url . '/js/jquery.min.js' ?>"></script>
    <script src="https://unpkg.com/html5-qrcode"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f9f9f9;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .table-container {
            max-width: 600px;
            margin: 0 auto;
            background: #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        .header-row {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        th, td {
            padding: 12px 15px;
            border: 1px solid #ddd;
            text-align: left;
        }
        .data-row td {
            border-bottom: 2px solid #eee;
        }
        @media (max-width: 768px) {
            .table-container {
                max-width: 100%;
            }
        }
        .back-btn {
            display: block;
            width: 100%;
            max-width: 300px;
            margin: 30px auto 0;
            padding: 15px;
            background-color: #88A0BF;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            text-align: center;
            text-decoration: none;
        }
        .back-btn:hover {
            background-color: #88A0BF;
        }
        .scan-img {
            width: 50px;
            height: auto;
            display: block;
            margin: 0 auto;
            border-radius: 4px;
        }
    </style>
</head>
<body>
        <script>
       
            $("#scanBtn").click(function(event) {
                event.preventDefault();
                startScanner();
            });

           function startScanner() {
                const html5QrCode = new Html5Qrcode("reader");
            
                const config = { fps: 10, qrbox: 250 };
            
                html5QrCode.start(
                    { facingMode: "environment" }, // rear camera
                    config,
                    (decodedText, decodedResult) => {
                        console.log("Scanned Code:", decodedText);
                        alert("Scanned: " + decodedText);
                        html5QrCode.stop(); // stop camera
                        //fetchApiData(decodedText);
                    },
                    (errorMessage) => {
                        // console.log(`Scan error: ${errorMessage}`);
                    }
                ).catch(err => {
                    console.error("Camera start failed:", err);
                    alert("Camera failed to start");
                });
            }
            
            function fetchApiData(code) {
                $.ajax({
                    type: "GET",
                    url: "<?php echo base_url('Scanner/fetchDataFromAPI'); ?>",
                    data: { tknNo: code },
                    success: function (data) {
                        console.log("Response:", data);
            
                        // Ensure JSON string (in case it's already a string)
                        const jsonString = (typeof data === "string") ? data : JSON.stringify(data);
            
                        // Create a hidden form to submit POST
                        const form = document.createElement("form");
                        form.method = "POST";
                        form.action = "<?= base_url('Scanner/displayCargo') ?>";
            
                        const input = document.createElement("input");
                        input.type = "hidden";
                        input.name = "cargoData";
                        input.value = jsonString;
            
                        form.appendChild(input);
                        document.body.appendChild(form);
                        form.submit();
                    },

                    error: function () {
                        alert("Failed to contact server.");
                    }
                });
            }
      
    </script>
    <h2>Cargo Details</h2>
    <h4 style="text-align:center;">Order ID: <?= htmlspecialchars($order_id ?? '') ?></h4>

    <div class="table-container">
        <table>
            <tbody>
                <tr class="header-row">
                    <th></th>
                    <th>Cargo Type</th>
                    <th>Qty</th>
                    <th>Actual Qty</th>
                </tr>
                <?php foreach ($cargo_details as $row): ?>
                    <tr class="data-row">
                        <td><button type="button" class="btn btn-info scanBtn">
                            <img src="<?= htmlspecialchars($assets_url . '/img/scan.jpg') ?>" alt="Scan Image" class="scan-img" />
                        </button></td>
                        <td><?= htmlspecialchars($row['cargo_type'] ?? '') ?></td>
                        <td><?= htmlspecialchars($row['quantity'] ?? '0') ?></td>
                        <td><?= htmlspecialchars($row['scanned_quantity'] ?? '0') ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <a href="<?= base_url('scanner') ?>" class="back-btn">Back to Scanner</a>

</body>
</html>
